/*
 * Copyright (C) 2025 The Phosh.mobi e.V.
 *
 * SPDX-License-Identifier: GPL-3.0+
 *
 * Author: Guido Günther <agx@sigxcpu.org>
 */

#include "cbd-channel-manager.h"
#include "cbd-test.h"
#include "lcb-enums.h"

#include <gio/gio.h>

static void
test_service_provider_database (void)
{
  CbdChannelManager *manager = cbd_channel_manager_new (TEST_DATABASE);

  g_assert_cmpstr (cbd_channel_manager_get_service_providers_database (manager),
                   ==,
                   TEST_DATABASE);

  g_assert_finalize_object (manager);
}

static void
test_levels (void)
{
  CbdChannelManager *manager = cbd_channel_manager_new (TEST_DATABASE);
  LcbSeverityLevel level;

  cbd_channel_manager_set_country (manager, "de");
  g_assert_cmpstr (cbd_channel_manager_get_country(manager), ==, "de");
  level = cbd_channel_manager_lookup_level (manager, 4370);
  g_assert_cmpint (level, ==, LCB_SEVERITY_LEVEL_PRESIDENTIAL);
  level = cbd_channel_manager_lookup_level (manager, 4387);
  g_assert_cmpint (level, ==, LCB_SEVERITY_LEVEL_SEVERE);
  level = cbd_channel_manager_lookup_level (manager, 1111);
  g_assert_cmpint (level, ==, LCB_SEVERITY_LEVEL_UNKNOWN);
  level = cbd_channel_manager_lookup_level (manager, 0);
  g_assert_cmpint (level, ==, LCB_SEVERITY_LEVEL_UNKNOWN);

  cbd_channel_manager_set_country (manager, "us");
  g_assert_cmpstr (cbd_channel_manager_get_country(manager), ==, "us");
  level = cbd_channel_manager_lookup_level (manager, 4370);
  g_assert_cmpint (level, ==, LCB_SEVERITY_LEVEL_PRESIDENTIAL);
  level = cbd_channel_manager_lookup_level (manager, 4387);
  g_assert_cmpint (level, ==, LCB_SEVERITY_LEVEL_UNKNOWN);

  g_assert_finalize_object (manager);

}

static void
test_defaults (void)
{
  CbdChannelManager *manager = cbd_channel_manager_new (TEST_DATABASE);
  g_autoptr (GArray) expected = cbd_test_channels_get_expected ("us");
  GArray *channels = NULL;

  g_assert_null (cbd_channel_manager_get_country (manager));

  channels = cbd_channel_manager_get_channels (manager);
  cbd_assert_cmp_channels (channels, expected);
}


gint
main (gint argc, gchar *argv[])
{
  g_test_init (&argc, &argv, NULL);

  g_test_add_func ("/cbd/channel-manager/service-provider-database", test_service_provider_database);
  g_test_add_func ("/cbd/channel-manager/levels", test_levels);
  g_test_add_func ("/cbd/channel-manager/defaults", test_defaults);

  return g_test_run ();
}
