struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 1225,
		.content = "processor\t: 0\n"
			   "model name\t: ARMv7 Processor rev 5 (v7l)\n"
			   "Processor\t: ARMv7 Processor rev 5 (v7l)\n"
			   "BogoMIPS\t: 2609.15\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xc07\n"
			   "CPU revision\t: 5\n"
			   "\n"
			   "processor\t: 1\n"
			   "model name\t: ARMv7 Processor rev 5 (v7l)\n"
			   "Processor\t: ARMv7 Processor rev 5 (v7l)\n"
			   "BogoMIPS\t: 2609.15\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xc07\n"
			   "CPU revision\t: 5\n"
			   "\n"
			   "processor\t: 2\n"
			   "model name\t: ARMv7 Processor rev 5 (v7l)\n"
			   "Processor\t: ARMv7 Processor rev 5 (v7l)\n"
			   "BogoMIPS\t: 2609.15\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xc07\n"
			   "CPU revision\t: 5\n"
			   "\n"
			   "processor\t: 3\n"
			   "model name\t: ARMv7 Processor rev 5 (v7l)\n"
			   "Processor\t: ARMv7 Processor rev 5 (v7l)\n"
			   "BogoMIPS\t: 2609.15\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xc07\n"
			   "CPU revision\t: 5\n"
			   "\n"
			   "Hardware\t: Leadcore Innopower\n"
			   "Revision\t: 0000\n"
			   "Serial\t\t: 0000000000000000\n",
	},
	{
		.path = "/system/build.prop",
		.size = 4346,
		.content =
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=KTU84Q\n"
			"ro.build.version.incremental=V8.0.1.0.KHLCNDG\n"
			"ro.build.version.sdk=19\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.release=4.4.4\n"
			"ro.build.version.security_patch=2016-08-01\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Sat Aug 13 16:53:18 CST 2016\n"
			"ro.build.date.utc=1471078398\n"
			"ro.build.type=user\n"
			"ro.build.user=builder\n"
			"ro.build.host=c3-miui-ota-bd21.bj\n"
			"ro.build.tags=release-keys\n"
			"ro.product.brand=Xiaomi\n"
			"ro.product.mod_device=lte26007\n"
			"ro.product.hardware.version=Ver0606\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.locale.language=zh\n"
			"ro.product.locale.region=CN\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=lc1860\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"# Do not try to parse ro.build.description or .fingerprint\n"
			"ro.build.description=full_lte26007-user 4.4.4 KTU84Q V8.0.1.0.KHLCNDG release-keys\n"
			"ro.build.fingerprint=Xiaomi/full_lte26007/lte26007:4.4.4/KTU84Q/V8.0.1.0.KHLCNDG:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"# end build properties\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.miui.version.code_time=1469635200\n"
			"ro.miui.ui.version.code=6\n"
			"ro.miui.ui.version.name=V8\n"
			"persist.power.useautobrightadj=true\n"
			"persist.sys.mcd_config_file=/system/etc/mcd_default.conf\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.carrier=unknown\n"
			"ro.build.mass.production=true\n"
			"persist.sys.install.lc.log=/data/local/log,I1,0,0,I2,0,0,I3,0,0,I4,0,0,I5,0,0,I6,0,0\n"
			"persist.sys.install.max.lc.log=/data/local/log,I1,10,8192,I2,10,8192,I3,10,51200,I4,100,8192,I5,10,8192,I6,10,8192\n"
			"persist.sys.lc.msms=221\n"
			"persist.sys.lc.standby.rat=7,3\n"
			"persist.sys.lc.dual2single=1\n"
			"persist.sys.lc.dynamic.rat=1\n"
			"persist.sys.lc.master.card=10\n"
			"persist.sys.lc.def.cs=0\n"
			"persist.sys.lc.def.ps=0\n"
			"persist.sys.lc.def.sms=0\n"
			"persist.sys.lc.network.model=3\n"
			"persist.sys.lc.check.imei=1\n"
			"persist.sys.lc.network.select.mode=1\n"
			"persist.sys.lc.preferred.network.mode=1\n"
			"ro.build.display.lc.id=L1860_1.00.10.R57_20151110\n"
			"ro.build.factory.mode=0\n"
			"ro.build.display.factory.id=FACTORY-02\n"
			"persist.sys.timezone=Asia/Shanghai\n"
			"debug.hwc.fakevsync=0\n"
			"debug.hwc.logvsync=0\n"
			"debug.sf.gpuoverlay=0\n"
			"debug.sf.sa_enable=1\n"
			"debug.sf.sa_log=0\n"
			"debug.hwc.asyncdisp=1\n"
			"debug.power.loghint=0\n"
			"persist.radio.elog.path=1\n"
			"persist.sys.lc.amt.mmi.station=18\n"
			"ro.installed.fm=1\n"
			"ro.fm.devicename=bcm4343_b2\n"
			"wifi.interface=wlan0\n"
			"ro.opengles.version=196608\n"
			"persist.sys.display_prefer=2\n"
			"persist.sys.display_ce=11\n"
			"sys.haptic.long.weak=0,1,20,21\n"
			"sys.haptic.long.normal=0,14,20,32\n"
			"sys.haptic.long.strong=0,24,20,45\n"
			"sys.haptic.down.weak=0,1,20,21\n"
			"sys.haptic.down.normal=0,12,24,32\n"
			"sys.haptic.down.strong=0,24,20,46\n"
			"sys.haptic.up.weak=0,1,25,26\n"
			"sys.haptic.up.normal=0,10,25,35\n"
			"sys.haptic.up.strong=0,20,25,46\n"
			"sys.haptic.tap.weak=0,8,25,28\n"
			"sys.haptic.tap.normal=0,15,30,40\n"
			"sys.haptic.tap.strong=0,24,32,48\n"
			"ro.config.low_ram=false\n"
			"ro.config.max_starting_bg=8\n"
			"ro.audio.flinger_standbytime_ms=1000\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=96m\n"
			"dalvik.vm.heapsize=256m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"persist.sys.dalvik.vm.lib=libdvm.so\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.miui.has_real_blur=1\n"
			"ro.miui.has_handy_mode_sf=1\n"
			"ro.product.mod_device=lte26007\n"
			"ro.config.sms_received_sound=FadeIn.ogg\n"
			"ro.config.sms_delivered_sound=MessageComplete.ogg\n"
			"ro.com.android.mobiledata=false\n"
			"ro.product.manufacturer=Xiaomi\n"
			"ro.config.elder-ringtone=Angel.mp3\n"
			"keyguard.no_require_sim=true\n"
			"ro.com.android.dataroaming=false\n"
			"persist.sys.mitalk.enable=true\n"
			"ro.config.ringtone=Ring_Synth_04.ogg\n"
			"ro.config.notification_sound=pixiedust.ogg\n"
			"ro.config.alarm_alert=Alarm_Classic.ogg\n"
			"ro.product.cuptsm=XIAOMI|ESE|02|01\n"
			"ro.product.name=full_lte26007\n"
			"ro.build.display.id=KTU84P\n"
			"ro.product.device=lte26007\n"
			"ro.product.board=2014502\n"
			"ro.build.customer=XIAOMI\n"
			"ro.build.product=HM2014502\n"
			"ro.product.model=HM 2A\n"
			"ro.product.real_model=2014502\n"
			"ro.build.display.wtid=SW_S26007A2_V001_M10_XM_USER\n"
			"ro.com.google.clientidbase=android-xiaomi\n"
			"ro.sf.lcd_density=320\n"
			"persist.radio.multisim.config=dsds\n"
			"ro.telephony.default_network=101\n"
			"ro.ril.auto.plmn=0\n"
			"ro.telephony.call_ring.multiple=false\n"
			"ro.ril.resend.sms.full=1\n"
			"ro.ril.modem.pb=0\n"
			"persist.sys.lc.dcrm.config=0\n"
			"persist.sys.button_jack_profile=volume\n"
			"persist.sys.button_jack_switch=0\n"
			"persist.sys.miui_feature_config=/system/etc/miui_feature/lite.conf\n"
			"\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-4\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-4\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "624000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 84,
		.content = "1495000 1401563 1308125 1214688 1121250 1027813 934375 840938 747500 654063 624000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "conservative ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "747500\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "624000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 114,
		.content = "1495000 450\n"
			   "1401563 20\n"
			   "1308125 12\n"
			   "1214688 0\n"
			   "1121250 9\n"
			   "1027813 2\n"
			   "934375 18\n"
			   "840938 33\n"
			   "747500 213\n"
			   "654063 14\n"
			   "624000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 3,
		.content = "63\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/trans_table",
		.size = 1481,
		.content =
			"   From  :    To\n"
			"         :   1495000   1401563   1308125   1214688   1121250   1027813    934375    840938    747500    654063    624000 \n"
			"  1495000:         0         2         2         0         2         0         2         2        13         0         0 \n"
			"  1401563:         1         0         0         0         1         0         0         0         0         0         0 \n"
			"  1308125:         3         0         0         0         0         0         0         0         0         0         0 \n"
			"  1214688:         0         0         0         0         0         0         0         0         0         0         0 \n"
			"  1121250:         2         0         1         0         0         0         0         0         0         0         0 \n"
			"  1027813:         1         0         0         0         0         0         0         0         0         0         0 \n"
			"   934375:         0         0         0         0         0         1         0         0         2         0         0 \n"
			"   840938:         3         0         0         0         0         0         1         0         3         0         0 \n"
			"   747500:        12         0         0         0         0         0         0         5         0         2         0 \n"
			"   654063:         0         0         0         0         0         0         0         0         2         0         0 \n"
			"   624000:         0         0         0         0         0         0         0         0         0         0         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "624000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 84,
		.content = "1495000 1401563 1308125 1214688 1121250 1027813 934375 840938 747500 654063 624000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "conservative ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "624000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 116,
		.content = "1495000 595\n"
			   "1401563 24\n"
			   "1308125 12\n"
			   "1214688 4\n"
			   "1121250 17\n"
			   "1027813 10\n"
			   "934375 30\n"
			   "840938 49\n"
			   "747500 233\n"
			   "654063 14\n"
			   "624000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 3,
		.content = "84\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/trans_table",
		.size = 1481,
		.content =
			"   From  :    To\n"
			"         :   1495000   1401563   1308125   1214688   1121250   1027813    934375    840938    747500    654063    624000 \n"
			"  1495000:         0         2         2         0         2         0         2         3        16         0         0 \n"
			"  1401563:         2         0         0         0         1         0         0         0         0         0         0 \n"
			"  1308125:         3         0         0         0         0         0         0         0         0         0         0 \n"
			"  1214688:         0         1         0         0         0         0         0         0         0         0         0 \n"
			"  1121250:         3         0         1         1         0         0         0         0         0         0         0 \n"
			"  1027813:         1         0         0         0         2         0         0         0         0         0         0 \n"
			"   934375:         1         0         0         0         0         3         0         0         2         0         0 \n"
			"   840938:         4         0         0         0         0         0         4         0         3         0         0 \n"
			"   747500:        13         0         0         0         0         0         0         8         0         2         0 \n"
			"   654063:         0         0         0         0         0         0         0         0         2         0         0 \n"
			"   624000:         0         0         0         0         0         0         0         0         0         0         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "624000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 84,
		.content = "1495000 1401563 1308125 1214688 1121250 1027813 934375 840938 747500 654063 624000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "conservative ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "624000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 116,
		.content = "1495000 763\n"
			   "1401563 24\n"
			   "1308125 28\n"
			   "1214688 4\n"
			   "1121250 29\n"
			   "1027813 10\n"
			   "934375 30\n"
			   "840938 49\n"
			   "747500 258\n"
			   "654063 18\n"
			   "624000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 3,
		.content = "98\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/trans_table",
		.size = 1481,
		.content =
			"   From  :    To\n"
			"         :   1495000   1401563   1308125   1214688   1121250   1027813    934375    840938    747500    654063    624000 \n"
			"  1495000:         0         2         2         0         2         0         2         3        19         0         0 \n"
			"  1401563:         2         0         0         0         1         0         0         0         0         0         0 \n"
			"  1308125:         5         0         0         0         1         0         0         0         0         0         0 \n"
			"  1214688:         0         1         0         0         0         0         0         0         0         0         0 \n"
			"  1121250:         3         0         4         1         0         0         0         0         0         0         0 \n"
			"  1027813:         1         0         0         0         2         0         0         0         0         0         0 \n"
			"   934375:         1         0         0         0         0         3         0         0         2         0         0 \n"
			"   840938:         4         0         0         0         0         0         4         0         3         0         0 \n"
			"   747500:        14         0         0         0         2         0         0         8         0         3         0 \n"
			"   654063:         0         0         0         0         0         0         0         0         3         0         0 \n"
			"   624000:         0         0         0         0         0         0         0         0         0         0         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 3,
		.content = "04\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "624000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 84,
		.content = "1495000 1401563 1308125 1214688 1121250 1027813 934375 840938 747500 654063 624000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "conservative ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1495000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "624000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 116,
		.content = "1495000 956\n"
			   "1401563 24\n"
			   "1308125 40\n"
			   "1214688 4\n"
			   "1121250 49\n"
			   "1027813 10\n"
			   "934375 30\n"
			   "840938 49\n"
			   "747500 264\n"
			   "654063 18\n"
			   "624000 0\n",
	},
	{NULL},
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "96m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.hwc.asyncdisp",
		.value = "1",
	},
	{
		.key = "debug.hwc.fakevsync",
		.value = "0",
	},
	{
		.key = "debug.hwc.logvsync",
		.value = "0",
	},
	{
		.key = "debug.power.loghint",
		.value = "0",
	},
	{
		.key = "debug.sf.gpuoverlay",
		.value = "0",
	},
	{
		.key = "debug.sf.sa_enable",
		.value = "1",
	},
	{
		.key = "debug.sf.sa_log",
		.value = "0",
	},
	{
		.key = "init.svc.AcdApiDaemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.akmd09911",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "running",
	},
	{
		.key = "init.svc.checkpath",
		.value = "stopped",
	},
	{
		.key = "init.svc.checksdkpath",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.emsd",
		.value = "running",
	},
	{
		.key = "init.svc.fdpp",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.fuse_sdcard",
		.value = "running",
	},
	{
		.key = "init.svc.fuse_usbotg",
		.value = "running",
	},
	{
		.key = "init.svc.gps-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.gps_config_init",
		.value = "stopped",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.invn_cal_accel",
		.value = "stopped",
	},
	{
		.key = "init.svc.invn_cal_gyro",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lc-elog_powerup",
		.value = "stopped",
	},
	{
		.key = "init.svc.lc-oms-amt",
		.value = "running",
	},
	{
		.key = "init.svc.lc-oms-sa",
		.value = "running",
	},
	{
		.key = "init.svc.lc_boot_mode",
		.value = "stopped",
	},
	{
		.key = "init.svc.mcd_init",
		.value = "stopped",
	},
	{
		.key = "init.svc.mdbd",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.memsicd",
		.value = "stopped",
	},
	{
		.key = "init.svc.middle_perf",
		.value = "stopped",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.otad",
		.value = "running",
	},
	{
		.key = "init.svc.radio_config",
		.value = "running",
	},
	{
		.key = "init.svc.sdcard",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.setlockstate",
		.value = "stopped",
	},
	{
		.key = "init.svc.shelld",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.thermal",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.tcp.buffersize.evdo",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "persist.mass_storage.enable",
		.value = "false",
	},
	{
		.key = "persist.power.useautobrightadj",
		.value = "true",
	},
	{
		.key = "persist.radio.default.data",
		.value = "0",
	},
	{
		.key = "persist.radio.elog.path",
		.value = "1",
	},
	{
		.key = "persist.radio.lc.master.card",
		.value = "10",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.sys.adb.backroot",
		.value = "0",
	},
	{
		.key = "persist.sys.aries.power_profile",
		.value = "middle",
	},
	{
		.key = "persist.sys.button_jack_profile",
		.value = "volume",
	},
	{
		.key = "persist.sys.button_jack_switch",
		.value = "0",
	},
	{
		.key = "persist.sys.country",
		.value = "US",
	},
	{
		.key = "persist.sys.dalvik.vm.lib",
		.value = "libdvm.so",
	},
	{
		.key = "persist.sys.display_cabc",
		.value = "0",
	},
	{
		.key = "persist.sys.display_ce",
		.value = "11",
	},
	{
		.key = "persist.sys.display_prefer",
		.value = "2",
	},
	{
		.key = "persist.sys.gamut_mode",
		.value = "0",
	},
	{
		.key = "persist.sys.install.lc.log",
		.value = "/data/local/log,I1,0,0,I2,0,0,I3,0,0,I4,0,0,I5,0,0,I6,0,0",
	},
	{
		.key = "persist.sys.install.max.lc.log",
		.value = "/data/local/log,I1,10,8192,I2,10,8192,I3,10,51200,I4,100,8192,I5,10,8192,I6,10,8192",
	},
	{
		.key = "persist.sys.klo.rec_start",
		.value = "1409500940",
	},
	{
		.key = "persist.sys.klo",
		.value = "on",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.lc.actual.rat",
		.value = "7,1",
	},
	{
		.key = "persist.sys.lc.amt.mmi.station",
		.value = "18",
	},
	{
		.key = "persist.sys.lc.check.imei",
		.value = "0",
	},
	{
		.key = "persist.sys.lc.dcrm.config",
		.value = "0",
	},
	{
		.key = "persist.sys.lc.def.cs",
		.value = "0",
	},
	{
		.key = "persist.sys.lc.def.ps",
		.value = "0",
	},
	{
		.key = "persist.sys.lc.def.sms",
		.value = "0",
	},
	{
		.key = "persist.sys.lc.dual2single",
		.value = "1",
	},
	{
		.key = "persist.sys.lc.dynamic.rat",
		.value = "1",
	},
	{
		.key = "persist.sys.lc.master.card",
		.value = "10",
	},
	{
		.key = "persist.sys.lc.msms",
		.value = "221",
	},
	{
		.key = "persist.sys.lc.network.model",
		.value = "3",
	},
	{
		.key = "persist.sys.lc.standby.rat",
		.value = "7,3",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.ltm_enable",
		.value = "false",
	},
	{
		.key = "persist.sys.mcd_config_file",
		.value = "/system/etc/mcd_default.conf",
	},
	{
		.key = "persist.sys.memctrl",
		.value = "on",
	},
	{
		.key = "persist.sys.mitalk.enable",
		.value = "true",
	},
	{
		.key = "persist.sys.miui_feature_config",
		.value = "/system/etc/miui_feature/lite.conf",
	},
	{
		.key = "persist.sys.modem.reset",
		.value = "1",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.released",
		.value = "true",
	},
	{
		.key = "persist.sys.screenshot_mode",
		.value = "0",
	},
	{
		.key = "persist.sys.silent",
		.value = "0",
	},
	{
		.key = "persist.sys.smartcover_enabled",
		.value = "false",
	},
	{
		.key = "persist.sys.smartcover_mode",
		.value = "1",
	},
	{
		.key = "persist.sys.timezone",
		.value = "Asia/Shanghai",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.vold.primary",
		.value = "0",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.audio.flinger_standbytime_ms",
		.value = "1000",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.platform",
		.value = "lc1860",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/amt/BT/BT_Address.txt",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.customer",
		.value = "XIAOMI",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1471078398",
	},
	{
		.key = "ro.build.date",
		.value = "Sat Aug 13 16:53:18 CST 2016",
	},
	{
		.key = "ro.build.description",
		.value = "full_lte26007-user 4.4.4 KTU84Q V8.0.1.0.KHLCNDG release-keys",
	},
	{
		.key = "ro.build.display.factory.id",
		.value = "FACTORY-02",
	},
	{
		.key = "ro.build.display.id",
		.value = "KTU84P",
	},
	{
		.key = "ro.build.display.lc.id",
		.value = "L1860_1.00.10.R57_20151110",
	},
	{
		.key = "ro.build.display.wtid",
		.value = "SW_S26007A2_V001_M10_XM_USER",
	},
	{
		.key = "ro.build.factory.mode",
		.value = "0",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "Xiaomi/full_lte26007/lte26007:4.4.4/KTU84Q/V8.0.1.0.KHLCNDG:user/release-keys",
	},
	{
		.key = "ro.build.host",
		.value = "c3-miui-ota-bd21.bj",
	},
	{
		.key = "ro.build.id",
		.value = "KTU84Q",
	},
	{
		.key = "ro.build.mass.production",
		.value = "true",
	},
	{
		.key = "ro.build.product",
		.value = "HM2014502",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "builder",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "V8.0.1.0.KHLCNDG",
	},
	{
		.key = "ro.build.version.release",
		.value = "4.4.4",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "19",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2016-08-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.android.mobiledata",
		.value = "false",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-xiaomi",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Alarm_Classic.ogg",
	},
	{
		.key = "ro.config.elder-ringtone",
		.value = "Angel.mp3",
	},
	{
		.key = "ro.config.low_ram",
		.value = "false",
	},
	{
		.key = "ro.config.max_starting_bg",
		.value = "8",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "pixiedust.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Ring_Synth_04.ogg",
	},
	{
		.key = "ro.config.sms_delivered_sound",
		.value = "MessageComplete.ogg",
	},
	{
		.key = "ro.config.sms_received_sound",
		.value = "FadeIn.ogg",
	},
	{
		.key = "ro.crypto.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.fm.devicename",
		.value = "bcm4343_b2",
	},
	{
		.key = "ro.hardware",
		.value = "leadcoreinnopower",
	},
	{
		.key = "ro.installed.fm",
		.value = "1",
	},
	{
		.key = "ro.lc.dual2single",
		.value = "1",
	},
	{
		.key = "ro.lc.dynamic.rat",
		.value = "1",
	},
	{
		.key = "ro.lc.msms",
		.value = "221",
	},
	{
		.key = "ro.miui.cust_variant",
		.value = "cn",
	},
	{
		.key = "ro.miui.has_handy_mode_sf",
		.value = "1",
	},
	{
		.key = "ro.miui.has_real_blur",
		.value = "1",
	},
	{
		.key = "ro.miui.mcc",
		.value = "9460",
	},
	{
		.key = "ro.miui.mnc",
		.value = "9999",
	},
	{
		.key = "ro.miui.region",
		.value = "CN",
	},
	{
		.key = "ro.miui.ui.version.code",
		.value = "6",
	},
	{
		.key = "ro.miui.ui.version.name",
		.value = "V8",
	},
	{
		.key = "ro.miui.version.code_time",
		.value = "1469635200",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.product.board",
		.value = "2014502",
	},
	{
		.key = "ro.product.brand",
		.value = "Xiaomi",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cuptsm",
		.value = "XIAOMI|ESE|02|01",
	},
	{
		.key = "ro.product.device",
		.value = "lte26007",
	},
	{
		.key = "ro.product.hardware.version",
		.value = "Ver0606",
	},
	{
		.key = "ro.product.locale.language",
		.value = "zh",
	},
	{
		.key = "ro.product.locale.region",
		.value = "CN",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "Xiaomi",
	},
	{
		.key = "ro.product.mod_device",
		.value = "lte26007",
	},
	{
		.key = "ro.product.model",
		.value = "HM 2A",
	},
	{
		.key = "ro.product.name",
		.value = "full_lte26007",
	},
	{
		.key = "ro.product.real_model",
		.value = "2014502",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.ril.auto.plmn",
		.value = "0",
	},
	{
		.key = "ro.ril.modem.pb",
		.value = "0",
	},
	{
		.key = "ro.ril.resend.sms.full",
		.value = "1",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "1L521W028325",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "101",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "sys.alarmboot.mode",
		.value = "0",
	},
	{
		.key = "sys.chargeonly.mode",
		.value = "0",
	},
	{
		.key = "sys.haptic.down.normal",
		.value = "0,12,24,32",
	},
	{
		.key = "sys.haptic.down.strong",
		.value = "0,24,20,46",
	},
	{
		.key = "sys.haptic.down.weak",
		.value = "0,1,20,21",
	},
	{
		.key = "sys.haptic.long.normal",
		.value = "0,14,20,32",
	},
	{
		.key = "sys.haptic.long.strong",
		.value = "0,24,20,45",
	},
	{
		.key = "sys.haptic.long.weak",
		.value = "0,1,20,21",
	},
	{
		.key = "sys.haptic.tap.normal",
		.value = "0,15,30,40",
	},
	{
		.key = "sys.haptic.tap.strong",
		.value = "0,24,32,48",
	},
	{
		.key = "sys.haptic.tap.weak",
		.value = "0,8,25,28",
	},
	{
		.key = "sys.haptic.up.normal",
		.value = "0,10,25,35",
	},
	{
		.key = "sys.haptic.up.strong",
		.value = "0,20,25,46",
	},
	{
		.key = "sys.haptic.up.weak",
		.value = "0,1,25,26",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "tcmd.suspend",
		.value = "0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{NULL},
};
#endif /* __ANDROID__ */
