//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import "time"

// APIDefinitionInfo - Information about the formal API definition for the app.
type APIDefinitionInfo struct {
	// The URL of the API definition.
	URL *string `json:"url,omitempty"`
}

// AppCertificate - SSL certificate for an app.
type AppCertificate struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Certificate resource specific properties
	Properties *AppCertificateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AppCertificateCollection - Collection of certificates.
type AppCertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*AppCertificate `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AppCertificatePatchResource - ARM resource for a certificate.
type AppCertificatePatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// CertificatePatchResource resource specific properties
	Properties *AppCertificatePatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AppCertificatePatchResourceProperties - CertificatePatchResource resource specific properties
type AppCertificatePatchResourceProperties struct {
	// REQUIRED; Certificate password.
	Password *string `json:"password,omitempty"`

	// Host names the certificate applies to.
	HostNames []*string `json:"hostNames,omitempty"`

	// Key Vault Csm resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`

	// Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`

	// Pfx blob.
	PfxBlob []byte `json:"pfxBlob,omitempty"`

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`

	// READ-ONLY; Raw bytes of .cer file
	CerBlob []byte `json:"cerBlob,omitempty" azure:"ro"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Friendly name of the certificate.
	FriendlyName *string `json:"friendlyName,omitempty" azure:"ro"`

	// READ-ONLY; Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issue Date.
	IssueDate *time.Time `json:"issueDate,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issuer.
	Issuer *string `json:"issuer,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Key Vault secret.
	KeyVaultSecretStatus *KeyVaultSecretStatus `json:"keyVaultSecretStatus,omitempty" azure:"ro"`

	// READ-ONLY; Public key hash.
	PublicKeyHash *string `json:"publicKeyHash,omitempty" azure:"ro"`

	// READ-ONLY; Self link.
	SelfLink *string `json:"selfLink,omitempty" azure:"ro"`

	// READ-ONLY; App name.
	SiteName *string `json:"siteName,omitempty" azure:"ro"`

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty" azure:"ro"`

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Is the certificate valid?.
	Valid *bool `json:"valid,omitempty" azure:"ro"`
}

// AppCertificateProperties - Certificate resource specific properties
type AppCertificateProperties struct {
	// REQUIRED; Certificate password.
	Password *string `json:"password,omitempty"`

	// Host names the certificate applies to.
	HostNames []*string `json:"hostNames,omitempty"`

	// Key Vault Csm resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`

	// Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`

	// Pfx blob.
	PfxBlob []byte `json:"pfxBlob,omitempty"`

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`

	// READ-ONLY; Raw bytes of .cer file
	CerBlob []byte `json:"cerBlob,omitempty" azure:"ro"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Friendly name of the certificate.
	FriendlyName *string `json:"friendlyName,omitempty" azure:"ro"`

	// READ-ONLY; Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issue Date.
	IssueDate *time.Time `json:"issueDate,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issuer.
	Issuer *string `json:"issuer,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Key Vault secret.
	KeyVaultSecretStatus *KeyVaultSecretStatus `json:"keyVaultSecretStatus,omitempty" azure:"ro"`

	// READ-ONLY; Public key hash.
	PublicKeyHash *string `json:"publicKeyHash,omitempty" azure:"ro"`

	// READ-ONLY; Self link.
	SelfLink *string `json:"selfLink,omitempty" azure:"ro"`

	// READ-ONLY; App name.
	SiteName *string `json:"siteName,omitempty" azure:"ro"`

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty" azure:"ro"`

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Is the certificate valid?.
	Valid *bool `json:"valid,omitempty" azure:"ro"`
}

// ApplicationLogsConfig - Application logs configuration.
type ApplicationLogsConfig struct {
	// Application logs to blob storage configuration.
	AzureBlobStorage *AzureBlobStorageApplicationLogsConfig `json:"azureBlobStorage,omitempty"`

	// Application logs to azure table storage configuration.
	AzureTableStorage *AzureTableStorageApplicationLogsConfig `json:"azureTableStorage,omitempty"`

	// Application logs to file system configuration.
	FileSystem *FileSystemApplicationLogsConfig `json:"fileSystem,omitempty"`
}

// ApplicationStack - Application stack.
type ApplicationStack struct {
	// Application stack dependency.
	Dependency *string `json:"dependency,omitempty"`

	// Application stack display name.
	Display *string `json:"display,omitempty"`

	// List of frameworks associated with application stack.
	Frameworks []*ApplicationStack `json:"frameworks,omitempty"`

	// List of major versions available.
	MajorVersions []*StackMajorVersion `json:"majorVersions,omitempty"`

	// Application stack name.
	Name *string `json:"name,omitempty"`
}

// ApplicationStackCollection - Collection of Application Stacks
type ApplicationStackCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ApplicationStack `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AutoHealActions - Actions which to take by the auto-heal module when a rule is triggered.
type AutoHealActions struct {
	// Predefined action to be taken.
	ActionType *AutoHealActionType `json:"actionType,omitempty"`

	// Custom action to be taken.
	CustomAction *AutoHealCustomAction `json:"customAction,omitempty"`

	// Minimum time the process must execute before taking the action
	MinProcessExecutionTime *string `json:"minProcessExecutionTime,omitempty"`
}

// AutoHealCustomAction - Custom action to be executed when an auto heal rule is triggered.
type AutoHealCustomAction struct {
	// Executable to be run.
	Exe *string `json:"exe,omitempty"`

	// Parameters for the executable.
	Parameters *string `json:"parameters,omitempty"`
}

// AutoHealRules - Rules that can be defined for auto-heal.
type AutoHealRules struct {
	// Actions to be executed when a rule is triggered.
	Actions *AutoHealActions `json:"actions,omitempty"`

	// Conditions that describe when to execute the auto-heal actions.
	Triggers *AutoHealTriggers `json:"triggers,omitempty"`
}

// AutoHealTriggers - Triggers for auto-heal.
type AutoHealTriggers struct {
	// A rule based on private bytes.
	PrivateBytesInKB *int32 `json:"privateBytesInKB,omitempty"`

	// A rule based on total requests.
	Requests *RequestsBasedTrigger `json:"requests,omitempty"`

	// A rule based on request execution time.
	SlowRequests *SlowRequestsBasedTrigger `json:"slowRequests,omitempty"`

	// A rule based on status codes.
	StatusCodes []*StatusCodesBasedTrigger `json:"statusCodes,omitempty"`
}

// AzureBlobStorageApplicationLogsConfig - Application logs azure blob storage configuration.
type AzureBlobStorageApplicationLogsConfig struct {
	// Log level.
	Level *LogLevel `json:"level,omitempty"`

	// Retention in days. Remove blobs older than X days. 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`

	// SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
}

// AzureBlobStorageHTTPLogsConfig - Http logs to azure blob storage configuration.
type AzureBlobStorageHTTPLogsConfig struct {
	// True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`

	// Retention in days. Remove blobs older than X days. 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`

	// SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
}

// AzureStorageInfoValue - Azure Files or Blob Storage access information value for dictionary storage.
type AzureStorageInfoValue struct {
	// Access key for the storage account.
	AccessKey *string `json:"accessKey,omitempty"`

	// Name of the storage account.
	AccountName *string `json:"accountName,omitempty"`

	// Path to mount the storage within the site's runtime environment.
	MountPath *string `json:"mountPath,omitempty"`

	// Name of the file share (container name, for Blob storage).
	ShareName *string `json:"shareName,omitempty"`

	// Type of storage.
	Type *AzureStorageType `json:"type,omitempty"`

	// READ-ONLY; State of the storage account.
	State *AzureStorageState `json:"state,omitempty" azure:"ro"`
}

// AzureStoragePropertyDictionaryResource - AzureStorageInfo dictionary resource.
type AzureStoragePropertyDictionaryResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Azure storage accounts.
	Properties map[string]*AzureStorageInfoValue `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureTableStorageApplicationLogsConfig - Application logs to Azure table storage configuration.
type AzureTableStorageApplicationLogsConfig struct {
	// REQUIRED; SAS URL to an Azure table with add/query/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`

	// Log level.
	Level *LogLevel `json:"level,omitempty"`
}

// BackupItem - Backup description.
type BackupItem struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// BackupItem resource specific properties
	Properties *BackupItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupItemCollection - Collection of backup items.
type BackupItemCollection struct {
	// REQUIRED; Collection of resources.
	Value []*BackupItem `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// BackupItemProperties - BackupItem resource specific properties
type BackupItemProperties struct {
	// READ-ONLY; Id of the backup.
	BackupID *int32 `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the blob which contains data for this backup.
	BlobName *string `json:"blobName,omitempty" azure:"ro"`

	// READ-ONLY; Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of the backup creation.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; List of databases included in the backup.
	Databases []*DatabaseBackupSetting `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp when this backup finished.
	FinishedTimeStamp *time.Time `json:"finishedTimeStamp,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of a last restore operation which used this backup.
	LastRestoreTimeStamp *time.Time `json:"lastRestoreTimeStamp,omitempty" azure:"ro"`

	// READ-ONLY; Details regarding this backup. Might contain an error message.
	Log *string `json:"log,omitempty" azure:"ro"`

	// READ-ONLY; Name of this backup.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; True if this backup has been created due to a schedule being triggered.
	Scheduled *bool `json:"scheduled,omitempty" azure:"ro"`

	// READ-ONLY; Size of the backup in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty" azure:"ro"`

	// READ-ONLY; Backup status.
	Status *BackupItemStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; SAS URL for the storage account container which contains this backup.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty" azure:"ro"`

	// READ-ONLY; Size of the original web app which has been backed up.
	WebsiteSizeInBytes *int64 `json:"websiteSizeInBytes,omitempty" azure:"ro"`
}

// BackupRequest - Description of a backup which will be performed.
type BackupRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// BackupRequest resource specific properties
	Properties *BackupRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupRequestProperties - BackupRequest resource specific properties
type BackupRequestProperties struct {
	// REQUIRED; SAS URL to the container.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`

	// Name of the backup.
	BackupName *string `json:"backupName,omitempty"`

	// Schedule for the backup if it is executed periodically.
	BackupSchedule *BackupSchedule `json:"backupSchedule,omitempty"`

	// Databases included in the backup.
	Databases []*DatabaseBackupSetting `json:"databases,omitempty"`

	// True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// BackupSchedule - Description of a backup schedule. Describes how often should be the backup performed and what should be
// the retention policy.
type BackupSchedule struct {
	// REQUIRED; How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should
	// be set to Day)
	FrequencyInterval *int32 `json:"frequencyInterval,omitempty"`

	// REQUIRED; The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day
	// and FrequencyInterval should be set to 7)
	FrequencyUnit *FrequencyUnit `json:"frequencyUnit,omitempty"`

	// REQUIRED; True if the retention policy should always keep at least one backup in the storage account, regardless how old
	// it is; false otherwise.
	KeepAtLeastOneBackup *bool `json:"keepAtLeastOneBackup,omitempty"`

	// REQUIRED; After how many days backups should be deleted.
	RetentionPeriodInDays *int32 `json:"retentionPeriodInDays,omitempty"`

	// When the schedule should start working.
	StartTime *time.Time `json:"startTime,omitempty"`

	// READ-ONLY; Last time when this schedule was triggered.
	LastExecutionTime *time.Time `json:"lastExecutionTime,omitempty" azure:"ro"`
}

// BillingMeter - App Service billing entity that contains information about meter which the Azure billing system utilizes
// to charge users for services.
type BillingMeter struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// BillingMeter resource specific properties
	Properties *BillingMeterProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BillingMeterCollection - Collection of Billing Meters
type BillingMeterCollection struct {
	// REQUIRED; Collection of resources.
	Value []*BillingMeter `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// BillingMeterProperties - BillingMeter resource specific properties
type BillingMeterProperties struct {
	// Azure Location of billable resource
	BillingLocation *string `json:"billingLocation,omitempty"`

	// Friendly name of the meter
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Meter GUID onboarded in Commerce
	MeterID *string `json:"meterId,omitempty"`

	// App Service OS type meter used for
	OSType *string `json:"osType,omitempty"`

	// App Service ResourceType meter used for
	ResourceType *string `json:"resourceType,omitempty"`

	// Short Name from App Service Azure pricing Page
	ShortName *string `json:"shortName,omitempty"`
}

// Capability - Describes the capabilities/features allowed for a specific SKU.
type Capability struct {
	// Name of the SKU capability.
	Name *string `json:"name,omitempty"`

	// Reason of the SKU capability.
	Reason *string `json:"reason,omitempty"`

	// Value of the SKU capability.
	Value *string `json:"value,omitempty"`
}

// CertificatesClientCreateOrUpdateOptions contains the optional parameters for the CertificatesClient.CreateOrUpdate method.
type CertificatesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientDeleteOptions contains the optional parameters for the CertificatesClient.Delete method.
type CertificatesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientGetOptions contains the optional parameters for the CertificatesClient.Get method.
type CertificatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientListByResourceGroupOptions contains the optional parameters for the CertificatesClient.NewListByResourceGroupPager
// method.
type CertificatesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientListOptions contains the optional parameters for the CertificatesClient.NewListPager method.
type CertificatesClientListOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientUpdateOptions contains the optional parameters for the CertificatesClient.Update method.
type CertificatesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CloningInfo - Information needed for cloning operation.
type CloningInfo struct {
	// REQUIRED; ARM resource ID of the source app. App resource ID is of the form /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
	// for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for
	// other slots.
	SourceWebAppID *string `json:"sourceWebAppId,omitempty"`

	// Application setting overrides for cloned app. If specified, these settings override the settings cloned from source app.
	// Otherwise, application settings from source app are retained.
	AppSettingsOverrides map[string]*string `json:"appSettingsOverrides,omitempty"`

	// true to clone custom hostnames from source app; otherwise, false.
	CloneCustomHostNames *bool `json:"cloneCustomHostNames,omitempty"`

	// true to clone source control from source app; otherwise, false.
	CloneSourceControl *bool `json:"cloneSourceControl,omitempty"`

	// true to configure load balancing for source and destination app.
	ConfigureLoadBalancing *bool `json:"configureLoadBalancing,omitempty"`

	// Correlation ID of cloning operation. This ID ties multiple cloning operations together to use the same snapshot.
	CorrelationID *string `json:"correlationId,omitempty"`

	// App Service Environment.
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`

	// true to overwrite destination app; otherwise, false.
	Overwrite *bool `json:"overwrite,omitempty"`

	// Location of source app ex: West US or North Europe
	SourceWebAppLocation *string `json:"sourceWebAppLocation,omitempty"`

	// ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
	TrafficManagerProfileID *string `json:"trafficManagerProfileId,omitempty"`

	// Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
	TrafficManagerProfileName *string `json:"trafficManagerProfileName,omitempty"`
}

type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; Client Id of user assigned identity
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; Principal Id of user assigned identity
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// ConnStringInfo - Database connection string information.
type ConnStringInfo struct {
	// Connection string value.
	ConnectionString *string `json:"connectionString,omitempty"`

	// Name of connection string.
	Name *string `json:"name,omitempty"`

	// Type of database.
	Type *ConnectionStringType `json:"type,omitempty"`
}

// ConnStringValueTypePair - Database connection string value to type pair.
type ConnStringValueTypePair struct {
	// REQUIRED; Type of database.
	Type *ConnectionStringType `json:"type,omitempty"`

	// REQUIRED; Value of pair.
	Value *string `json:"value,omitempty"`
}

// ConnectionStringDictionary - String dictionary resource.
type ConnectionStringDictionary struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Connection strings.
	Properties map[string]*ConnStringValueTypePair `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContinuousWebJob - Continuous Web Job Information.
type ContinuousWebJob struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ContinuousWebJob resource specific properties
	Properties *ContinuousWebJobProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContinuousWebJobCollection - Collection of Kudu continuous web job information elements.
type ContinuousWebJobCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContinuousWebJob `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ContinuousWebJobProperties - ContinuousWebJob resource specific properties
type ContinuousWebJobProperties struct {
	// Detailed status.
	DetailedStatus *string `json:"detailed_status,omitempty"`

	// Error information.
	Error *string `json:"error,omitempty"`

	// Extra Info URL.
	ExtraInfoURL *string `json:"extra_info_url,omitempty"`

	// Log URL.
	LogURL *string `json:"log_url,omitempty"`

	// Run command.
	RunCommand *string `json:"run_command,omitempty"`

	// Job settings.
	Settings map[string]any `json:"settings,omitempty"`

	// Job status.
	Status *ContinuousWebJobStatus `json:"status,omitempty"`

	// Job URL.
	URL *string `json:"url,omitempty"`

	// Using SDK?
	UsingSdk *bool `json:"using_sdk,omitempty"`

	// Job type.
	WebJobType *WebJobType `json:"web_job_type,omitempty"`
}

// CorsSettings - Cross-Origin Resource Sharing (CORS) settings for the app.
type CorsSettings struct {
	// Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345).
	// Use "*" to allow all.
	AllowedOrigins []*string `json:"allowedOrigins,omitempty"`

	// Gets or sets whether CORS requests with credentials are allowed. See https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requestswithcredentials
	// for more details.
	SupportCredentials *bool `json:"supportCredentials,omitempty"`
}

// CsmMoveResourceEnvelope - Object with a list of the resources that need to be moved and the resource group they should
// be moved to.
type CsmMoveResourceEnvelope struct {
	Resources           []*string `json:"resources,omitempty"`
	TargetResourceGroup *string   `json:"targetResourceGroup,omitempty"`
}

// CsmOperationCollection - Collection of Azure resource manager operation metadata.
type CsmOperationCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmOperationDescription `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// CsmOperationDescription - Description of an operation available for Microsoft.Web resource provider.
type CsmOperationDescription struct {
	// Meta data about operation used for display in portal.
	Display *CsmOperationDisplay `json:"display,omitempty"`
	Name    *string              `json:"name,omitempty"`
	Origin  *string              `json:"origin,omitempty"`

	// Properties available for a Microsoft.Web resource provider operation.
	Properties *CsmOperationDescriptionProperties `json:"properties,omitempty"`
}

// CsmOperationDescriptionProperties - Properties available for a Microsoft.Web resource provider operation.
type CsmOperationDescriptionProperties struct {
	// Resource metrics service provided by Microsoft.Insights resource provider.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// CsmOperationDisplay - Meta data about operation used for display in portal.
type CsmOperationDisplay struct {
	Description *string `json:"description,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
}

// CsmPublishingProfileOptions - Publishing options for requested profile.
type CsmPublishingProfileOptions struct {
	// Name of the format. Valid values are: FileZilla3 WebDeploy -- default Ftp
	Format *PublishingProfileFormat `json:"format,omitempty"`

	// Include the DisasterRecover endpoint if true
	IncludeDisasterRecoveryEndpoints *bool `json:"includeDisasterRecoveryEndpoints,omitempty"`
}

// CsmSlotEntity - Deployment slot parameters.
type CsmSlotEntity struct {
	// REQUIRED; true to preserve Virtual Network to the slot during swap; otherwise, false.
	PreserveVnet *bool `json:"preserveVnet,omitempty"`

	// REQUIRED; Destination deployment slot during swap operation.
	TargetSlot *string `json:"targetSlot,omitempty"`
}

// CsmUsageQuota - Usage of the quota resource.
type CsmUsageQuota struct {
	// The current value of the resource counter.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// The resource limit.
	Limit *int64 `json:"limit,omitempty"`

	// Quota name.
	Name *LocalizableString `json:"name,omitempty"`

	// Next reset time for the resource counter.
	NextResetTime *time.Time `json:"nextResetTime,omitempty"`

	// Units of measurement for the quota resource.
	Unit *string `json:"unit,omitempty"`
}

// CsmUsageQuotaCollection - Collection of CSM usage quotas.
type CsmUsageQuotaCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmUsageQuota `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// CustomHostnameAnalysisResult - Custom domain analysis.
type CustomHostnameAnalysisResult struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// CustomHostnameAnalysisResult resource specific properties
	Properties *CustomHostnameAnalysisResultProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomHostnameAnalysisResultProperties - CustomHostnameAnalysisResult resource specific properties
type CustomHostnameAnalysisResultProperties struct {
	// A records controller can see for this hostname.
	ARecords []*string `json:"aRecords,omitempty"`

	// Alternate CName records controller can see for this hostname.
	AlternateCNameRecords []*string `json:"alternateCNameRecords,omitempty"`

	// Alternate TXT records controller can see for this hostname.
	AlternateTxtRecords []*string `json:"alternateTxtRecords,omitempty"`

	// CName records controller can see for this hostname.
	CNameRecords []*string `json:"cNameRecords,omitempty"`

	// TXT records controller can see for this hostname.
	TxtRecords []*string `json:"txtRecords,omitempty"`

	// READ-ONLY; Name of the conflicting app on scale unit if it's within the same subscription.
	ConflictingAppResourceID *string `json:"conflictingAppResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Raw failure information if DNS verification fails.
	CustomDomainVerificationFailureInfo *ErrorEntity `json:"customDomainVerificationFailureInfo,omitempty" azure:"ro"`

	// READ-ONLY; DNS verification test result.
	CustomDomainVerificationTest *DNSVerificationTestResult `json:"customDomainVerificationTest,omitempty" azure:"ro"`

	// READ-ONLY; true if there is a conflict across subscriptions; otherwise, false.
	HasConflictAcrossSubscription *bool `json:"hasConflictAcrossSubscription,omitempty" azure:"ro"`

	// READ-ONLY; true if there is a conflict on a scale unit; otherwise, false.
	HasConflictOnScaleUnit *bool `json:"hasConflictOnScaleUnit,omitempty" azure:"ro"`

	// READ-ONLY; true if hostname is already verified; otherwise, false.
	IsHostnameAlreadyVerified *bool `json:"isHostnameAlreadyVerified,omitempty" azure:"ro"`
}

// DatabaseBackupSetting - Database backup settings.
type DatabaseBackupSetting struct {
	// REQUIRED; Database type (e.g. SqlAzure / MySql).
	DatabaseType *DatabaseType `json:"databaseType,omitempty"`

	// Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new
	// database, the database name inside is the new one.
	ConnectionString *string `json:"connectionString,omitempty"`

	// Contains a connection string name that is linked to the SiteConfig.ConnectionStrings. This is used during restore with
	// overwrite connection strings options.
	ConnectionStringName *string `json:"connectionStringName,omitempty"`
	Name                 *string `json:"name,omitempty"`
}

// DefaultErrorResponse - App Service error response.
type DefaultErrorResponse struct {
	// READ-ONLY; Error model.
	Error *DefaultErrorResponseError `json:"error,omitempty" azure:"ro"`
}

// DefaultErrorResponseError - Error model.
type DefaultErrorResponseError struct {
	Details []*DefaultErrorResponseErrorDetailsItem `json:"details,omitempty"`

	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; More information to debug error.
	Innererror *string `json:"innererror,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// DefaultErrorResponseErrorDetailsItem - Detailed errors.
type DefaultErrorResponseErrorDetailsItem struct {
	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// DeletedAppRestoreRequest - Details about restoring a deleted app.
type DeletedAppRestoreRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// DeletedAppRestoreRequest resource specific properties
	Properties *DeletedAppRestoreRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeletedAppRestoreRequestProperties - DeletedAppRestoreRequest resource specific properties
type DeletedAppRestoreRequestProperties struct {
	// ARM resource ID of the deleted app. Example: /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}
	DeletedSiteID *string `json:"deletedSiteId,omitempty"`

	// If true, deleted site configuration, in addition to content, will be restored.
	RecoverConfiguration *bool `json:"recoverConfiguration,omitempty"`

	// Point in time to restore the deleted app from, formatted as a DateTime string. If unspecified, default value is the time
	// that the app was deleted.
	SnapshotTime *string `json:"snapshotTime,omitempty"`

	// If true, the snapshot is retrieved from DRSecondary endpoint.
	UseDRSecondary *bool `json:"useDRSecondary,omitempty"`
}

// Deployment - User credentials used for publishing activity.
type Deployment struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Deployment resource specific properties
	Properties *DeploymentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeploymentCollection - Collection of app deployments.
type DeploymentCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Deployment `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DeploymentLocations - List of available locations (regions or App Service Environments) for deployment of App Service resources.
type DeploymentLocations struct {
	// Available App Service Environments with basic information.
	HostingEnvironmentDeploymentInfos []*HostingEnvironmentDeploymentInfo `json:"hostingEnvironmentDeploymentInfos,omitempty"`

	// Available App Service Environments with full descriptions of the environments.
	HostingEnvironments []*Environment `json:"hostingEnvironments,omitempty"`

	// Available regions.
	Locations []*GeoRegion `json:"locations,omitempty"`
}

// DeploymentProperties - Deployment resource specific properties
type DeploymentProperties struct {
	// True if deployment is currently active, false if completed and null if not started.
	Active *bool `json:"active,omitempty"`

	// Who authored the deployment.
	Author *string `json:"author,omitempty"`

	// Author email.
	AuthorEmail *string `json:"author_email,omitempty"`

	// Who performed the deployment.
	Deployer *string `json:"deployer,omitempty"`

	// Details on deployment.
	Details *string `json:"details,omitempty"`

	// End time.
	EndTime *time.Time `json:"end_time,omitempty"`

	// Details about deployment status.
	Message *string `json:"message,omitempty"`

	// Start time.
	StartTime *time.Time `json:"start_time,omitempty"`

	// Deployment status.
	Status *int32 `json:"status,omitempty"`
}

// Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app, where instance name is dimension
// of the metric HTTP request
type Dimension struct {
	DisplayName            *string `json:"displayName,omitempty"`
	InternalName           *string `json:"internalName,omitempty"`
	Name                   *string `json:"name,omitempty"`
	ToBeExportedForShoebox *bool   `json:"toBeExportedForShoebox,omitempty"`
}

// EnabledConfig - Enabled configuration.
type EnabledConfig struct {
	// True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`
}

// Environment - Description of an App Service Environment.
type Environment struct {
	// REQUIRED; Location of the App Service Environment, e.g. "West US".
	Location *string `json:"location,omitempty"`

	// REQUIRED; Name of the App Service Environment.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Description of the Virtual Network.
	VirtualNetwork *VirtualNetworkProfile `json:"virtualNetwork,omitempty"`

	// REQUIRED; Description of worker pools with worker size IDs, VM sizes, and number of workers in each pool.
	WorkerPools []*WorkerPool `json:"workerPools,omitempty"`

	// API Management Account associated with the App Service Environment.
	APIManagementAccountID *string `json:"apiManagementAccountId,omitempty"`

	// Custom settings for changing the behavior of the App Service Environment.
	ClusterSettings []*NameValuePair `json:"clusterSettings,omitempty"`

	// DNS suffix of the App Service Environment.
	DNSSuffix *string `json:"dnsSuffix,omitempty"`

	// True/false indicating whether the App Service Environment is suspended. The environment can be suspended e.g. when the
	// management endpoint is no longer available (most likely because NSG blocked the
	// incoming traffic).
	DynamicCacheEnabled *bool `json:"dynamicCacheEnabled,omitempty"`

	// Scale factor for front-ends.
	FrontEndScaleFactor *int32 `json:"frontEndScaleFactor,omitempty"`

	// Flag that displays whether an ASE has linux workers or not
	HasLinuxWorkers *bool `json:"hasLinuxWorkers,omitempty"`

	// Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
	InternalLoadBalancingMode *InternalLoadBalancingMode `json:"internalLoadBalancingMode,omitempty"`

	// Number of IP SSL addresses reserved for the App Service Environment.
	IpsslAddressCount *int32 `json:"ipsslAddressCount,omitempty"`

	// Number of front-end instances.
	MultiRoleCount *int32 `json:"multiRoleCount,omitempty"`

	// Front-end VM size, e.g. "Medium", "Large".
	MultiSize *string `json:"multiSize,omitempty"`

	// Access control list for controlling traffic to the App Service Environment.
	NetworkAccessControlList []*NetworkAccessControlEntry `json:"networkAccessControlList,omitempty"`

	// Key Vault ID for ILB App Service Environment default SSL certificate
	SSLCertKeyVaultID *string `json:"sslCertKeyVaultId,omitempty"`

	// Key Vault Secret Name for ILB App Service Environment default SSL certificate
	SSLCertKeyVaultSecretName *string `json:"sslCertKeyVaultSecretName,omitempty"`

	// true if the App Service Environment is suspended; otherwise, false. The environment can be suspended, e.g. when the management
	// endpoint is no longer available (most likely because NSG blocked the
	// incoming traffic).
	Suspended *bool `json:"suspended,omitempty"`

	// User added ip ranges to whitelist on ASE db
	UserWhitelistedIPRanges []*string `json:"userWhitelistedIpRanges,omitempty"`

	// Name of the Virtual Network for the App Service Environment.
	VnetName *string `json:"vnetName,omitempty"`

	// Resource group of the Virtual Network.
	VnetResourceGroupName *string `json:"vnetResourceGroupName,omitempty"`

	// Subnet of the Virtual Network.
	VnetSubnetName *string `json:"vnetSubnetName,omitempty"`

	// READ-ONLY; List of comma separated strings describing which VM sizes are allowed for front-ends.
	AllowedMultiSizes *string `json:"allowedMultiSizes,omitempty" azure:"ro"`

	// READ-ONLY; List of comma separated strings describing which VM sizes are allowed for workers.
	AllowedWorkerSizes *string `json:"allowedWorkerSizes,omitempty" azure:"ro"`

	// READ-ONLY; Edition of the metadata database for the App Service Environment, e.g. "Standard".
	DatabaseEdition *string `json:"databaseEdition,omitempty" azure:"ro"`

	// READ-ONLY; Service objective of the metadata database for the App Service Environment, e.g. "S0".
	DatabaseServiceObjective *string `json:"databaseServiceObjective,omitempty" azure:"ro"`

	// READ-ONLY; Default Scale Factor for FrontEnds.
	DefaultFrontEndScaleFactor *int32 `json:"defaultFrontEndScaleFactor,omitempty" azure:"ro"`

	// READ-ONLY; Current total, used, and available worker capacities.
	EnvironmentCapacities []*StampCapacity `json:"environmentCapacities,omitempty" azure:"ro"`

	// READ-ONLY; True/false indicating whether the App Service Environment is healthy.
	EnvironmentIsHealthy *bool `json:"environmentIsHealthy,omitempty" azure:"ro"`

	// READ-ONLY; Detailed message about with results of the last check of the App Service Environment.
	EnvironmentStatus *string `json:"environmentStatus,omitempty" azure:"ro"`

	// READ-ONLY; Last deployment action on the App Service Environment.
	LastAction *string `json:"lastAction,omitempty" azure:"ro"`

	// READ-ONLY; Result of the last deployment action on the App Service Environment.
	LastActionResult *string `json:"lastActionResult,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of VMs in the App Service Environment.
	MaximumNumberOfMachines *int32 `json:"maximumNumberOfMachines,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the App Service Environment.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource group of the App Service Environment.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; Current status of the App Service Environment.
	Status *HostingEnvironmentStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Subscription of the App Service Environment.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; Number of upgrade domains of the App Service Environment.
	UpgradeDomains *int32 `json:"upgradeDomains,omitempty" azure:"ro"`

	// READ-ONLY; Description of IP SSL mapping for the App Service Environment.
	VipMappings []*VirtualIPMapping `json:"vipMappings,omitempty" azure:"ro"`
}

// ErrorEntity - Body of the error response returned from the API.
type ErrorEntity struct {
	// Basic error code.
	Code *string `json:"code,omitempty"`

	// Type of error.
	ExtendedCode *string `json:"extendedCode,omitempty"`

	// Inner errors.
	InnerErrors []*ErrorEntity `json:"innerErrors,omitempty"`

	// Any details of the error.
	Message *string `json:"message,omitempty"`

	// Message template.
	MessageTemplate *string `json:"messageTemplate,omitempty"`

	// Parameters for the template.
	Parameters []*string `json:"parameters,omitempty"`
}

// Experiments - Routing rules in production experiments.
type Experiments struct {
	// List of ramp-up rules.
	RampUpRules []*RampUpRule `json:"rampUpRules,omitempty"`
}

// FileSystemApplicationLogsConfig - Application logs to file system configuration.
type FileSystemApplicationLogsConfig struct {
	// Log level.
	Level *LogLevel `json:"level,omitempty"`
}

// FileSystemHTTPLogsConfig - Http logs to file system configuration.
type FileSystemHTTPLogsConfig struct {
	// True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`

	// Retention in days. Remove files older than X days. 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`

	// Maximum size in megabytes that http log files can use. When reached old log files will be removed to make space for new
	// ones. Value can range between 25 and 100.
	RetentionInMb *int32 `json:"retentionInMb,omitempty"`
}

// FunctionEnvelope - Function information.
type FunctionEnvelope struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// FunctionEnvelope resource specific properties
	Properties *FunctionEnvelopeProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FunctionEnvelopeCollection - Collection of Kudu function information elements.
type FunctionEnvelopeCollection struct {
	// REQUIRED; Collection of resources.
	Value []*FunctionEnvelope `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// FunctionEnvelopeProperties - FunctionEnvelope resource specific properties
type FunctionEnvelopeProperties struct {
	// Config information.
	Config any `json:"config,omitempty"`

	// Config URI.
	ConfigHref *string `json:"config_href,omitempty"`

	// File list.
	Files map[string]*string `json:"files,omitempty"`

	// Function App ID.
	FunctionAppID *string `json:"function_app_id,omitempty"`

	// Function URI.
	Href *string `json:"href,omitempty"`

	// The invocation URL
	InvokeURLTemplate *string `json:"invoke_url_template,omitempty"`

	// Value indicating whether the function is disabled
	IsDisabled *bool `json:"isDisabled,omitempty"`

	// The function language
	Language *string `json:"language,omitempty"`

	// Script URI.
	ScriptHref *string `json:"script_href,omitempty"`

	// Script root path URI.
	ScriptRootPathHref *string `json:"script_root_path_href,omitempty"`

	// Secrets file URI.
	SecretsFileHref *string `json:"secrets_file_href,omitempty"`

	// Test data used when testing via the Azure Portal.
	TestData *string `json:"test_data,omitempty"`

	// Test data URI.
	TestDataHref *string `json:"test_data_href,omitempty"`
}

// FunctionSecrets - Function secrets.
type FunctionSecrets struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// FunctionSecrets resource specific properties
	Properties *FunctionSecretsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FunctionSecretsProperties - FunctionSecrets resource specific properties
type FunctionSecretsProperties struct {
	// Secret key.
	Key *string `json:"key,omitempty"`

	// Trigger URL.
	TriggerURL *string `json:"trigger_url,omitempty"`
}

// GeoDistribution - A global distribution definition.
type GeoDistribution struct {
	// Location.
	Location *string `json:"location,omitempty"`

	// NumberOfWorkers.
	NumberOfWorkers *int32 `json:"numberOfWorkers,omitempty"`
}

// GeoRegion - Geographical region.
type GeoRegion struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// GeoRegion resource specific properties
	Properties *GeoRegionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GeoRegionCollection - Collection of geographical regions.
type GeoRegionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*GeoRegion `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// GeoRegionProperties - GeoRegion resource specific properties
type GeoRegionProperties struct {
	// READ-ONLY; Region description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Display name for region.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GlobalCsmSKUDescription - A Global SKU Description.
type GlobalCsmSKUDescription struct {
	// Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities []*Capability `json:"capabilities,omitempty"`

	// Min, max, and default scale values of the SKU.
	Capacity *SKUCapacity `json:"capacity,omitempty"`

	// Family code of the resource SKU.
	Family *string `json:"family,omitempty"`

	// Locations of the SKU.
	Locations []*string `json:"locations,omitempty"`

	// Name of the resource SKU.
	Name *string `json:"name,omitempty"`

	// Size specifier of the resource SKU.
	Size *string `json:"size,omitempty"`

	// Service Tier of the resource SKU.
	Tier *string `json:"tier,omitempty"`
}

// HTTPLogsConfig - Http logs configuration.
type HTTPLogsConfig struct {
	// Http logs to azure blob storage configuration.
	AzureBlobStorage *AzureBlobStorageHTTPLogsConfig `json:"azureBlobStorage,omitempty"`

	// Http logs to file system configuration.
	FileSystem *FileSystemHTTPLogsConfig `json:"fileSystem,omitempty"`
}

// HandlerMapping - The IIS handler mappings used to define which handler processes HTTP requests with certain extension.
// For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
// extension.
type HandlerMapping struct {
	// Command-line arguments to be passed to the script processor.
	Arguments *string `json:"arguments,omitempty"`

	// Requests with this extension will be handled using the specified FastCGI application.
	Extension *string `json:"extension,omitempty"`

	// The absolute path to the FastCGI application.
	ScriptProcessor *string `json:"scriptProcessor,omitempty"`
}

// HostKeys - Functions host level keys.
type HostKeys struct {
	// Host level function keys.
	FunctionKeys map[string]*string `json:"functionKeys,omitempty"`

	// Secret key.
	MasterKey *string `json:"masterKey,omitempty"`

	// System keys.
	SystemKeys map[string]*string `json:"systemKeys,omitempty"`
}

// HostNameBinding - A hostname binding object.
type HostNameBinding struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// HostNameBinding resource specific properties
	Properties *HostNameBindingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HostNameBindingCollection - Collection of hostname bindings.
type HostNameBindingCollection struct {
	// REQUIRED; Collection of resources.
	Value []*HostNameBinding `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// HostNameBindingProperties - HostNameBinding resource specific properties
type HostNameBindingProperties struct {
	// Azure resource name.
	AzureResourceName *string `json:"azureResourceName,omitempty"`

	// Azure resource type.
	AzureResourceType *AzureResourceType `json:"azureResourceType,omitempty"`

	// Custom DNS record type.
	CustomHostNameDNSRecordType *CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`

	// Fully qualified ARM domain resource URI.
	DomainID *string `json:"domainId,omitempty"`

	// Hostname type.
	HostNameType *HostNameType `json:"hostNameType,omitempty"`

	// SSL type
	SSLState *SSLState `json:"sslState,omitempty"`

	// App Service app name.
	SiteName *string `json:"siteName,omitempty"`

	// SSL certificate thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`

	// READ-ONLY; Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string `json:"virtualIP,omitempty" azure:"ro"`
}

// HostNameSSLState - SSL-enabled hostname.
type HostNameSSLState struct {
	// Indicates whether the hostname is a standard or repository hostname.
	HostType *HostType `json:"hostType,omitempty"`

	// Hostname.
	Name *string `json:"name,omitempty"`

	// SSL type.
	SSLState *SSLState `json:"sslState,omitempty"`

	// SSL certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`

	// Set to true to update existing hostname.
	ToUpdate *bool `json:"toUpdate,omitempty"`

	// Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string `json:"virtualIP,omitempty"`
}

// HostingEnvironmentDeploymentInfo - Information needed to create resources on an App Service Environment.
type HostingEnvironmentDeploymentInfo struct {
	// Location of the App Service Environment.
	Location *string `json:"location,omitempty"`

	// Name of the App Service Environment.
	Name *string `json:"name,omitempty"`
}

// HostingEnvironmentProfile - Specification for an App Service Environment to use for this resource.
type HostingEnvironmentProfile struct {
	// Resource ID of the App Service Environment.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Name of the App Service Environment.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the App Service Environment.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridConnection - Hybrid Connection contract. This is used to configure a Hybrid Connection.
type HybridConnection struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// HybridConnection resource specific properties
	Properties *HybridConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridConnectionCollection - Collection of hostname bindings.
type HybridConnectionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*HybridConnection `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// HybridConnectionKey - Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.
type HybridConnectionKey struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// HybridConnectionKey resource specific properties
	Properties *HybridConnectionKeyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridConnectionKeyProperties - HybridConnectionKey resource specific properties
type HybridConnectionKeyProperties struct {
	// READ-ONLY; The name of the send key.
	SendKeyName *string `json:"sendKeyName,omitempty" azure:"ro"`

	// READ-ONLY; The value of the send key.
	SendKeyValue *string `json:"sendKeyValue,omitempty" azure:"ro"`
}

// HybridConnectionLimits - Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections.
type HybridConnectionLimits struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// HybridConnectionLimits resource specific properties
	Properties *HybridConnectionLimitsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridConnectionLimitsProperties - HybridConnectionLimits resource specific properties
type HybridConnectionLimitsProperties struct {
	// READ-ONLY; The current number of Hybrid Connections.
	Current *int32 `json:"current,omitempty" azure:"ro"`

	// READ-ONLY; The maximum number of Hybrid Connections allowed.
	Maximum *int32 `json:"maximum,omitempty" azure:"ro"`
}

// HybridConnectionProperties - HybridConnection resource specific properties
type HybridConnectionProperties struct {
	// The hostname of the endpoint.
	Hostname *string `json:"hostname,omitempty"`

	// The port of the endpoint.
	Port *int32 `json:"port,omitempty"`

	// The ARM URI to the Service Bus relay.
	RelayArmURI *string `json:"relayArmUri,omitempty"`

	// The name of the Service Bus relay.
	RelayName *string `json:"relayName,omitempty"`

	// The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
	SendKeyName *string `json:"sendKeyName,omitempty"`

	// The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned normally,
	// use the POST /listKeys API instead.
	SendKeyValue *string `json:"sendKeyValue,omitempty"`

	// The name of the Service Bus namespace.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// The suffix for the service bus endpoint. By default this is .servicebus.windows.net
	ServiceBusSuffix *string `json:"serviceBusSuffix,omitempty"`
}

// IPSecurityRestriction - IP security restriction on an app.
type IPSecurityRestriction struct {
	// Allow or Deny access for this IP range.
	Action *string `json:"action,omitempty"`

	// IP restriction rule description.
	Description *string `json:"description,omitempty"`

	// IP address the security restriction is valid for. It can be in form of pure ipv4 address (required SubnetMask property)
	// or CIDR notation such as ipv4/mask (leading bit match). For CIDR, SubnetMask
	// property must not be specified.
	IPAddress *string `json:"ipAddress,omitempty"`

	// IP restriction rule name.
	Name *string `json:"name,omitempty"`

	// Priority of IP restriction rule.
	Priority *int32 `json:"priority,omitempty"`

	// Subnet mask for the range of IP addresses the restriction is valid for.
	SubnetMask *string `json:"subnetMask,omitempty"`

	// (internal) Subnet traffic tag
	SubnetTrafficTag *int32 `json:"subnetTrafficTag,omitempty"`

	// Defines what this IP filter will be used for. This is to support IP filtering on proxies.
	Tag *IPFilterTag `json:"tag,omitempty"`

	// Virtual network resource id
	VnetSubnetResourceID *string `json:"vnetSubnetResourceId,omitempty"`

	// (internal) Vnet traffic tag
	VnetTrafficTag *int32 `json:"vnetTrafficTag,omitempty"`
}

// Identifier - A domain specific resource identifier.
type Identifier struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Identifier resource specific properties
	Properties *IdentifierProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IdentifierCollection - Collection of identifiers.
type IdentifierCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Identifier `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// IdentifierProperties - Identifier resource specific properties
type IdentifierProperties struct {
	// String representation of the identity.
	ID *string `json:"id,omitempty"`
}

// KeyInfo - Function key info.
type KeyInfo struct {
	// Key name
	Name *string `json:"name,omitempty"`

	// Key value
	Value *string `json:"value,omitempty"`
}

// LocalizableString - Localizable string object containing the name and a localized value.
type LocalizableString struct {
	// Localized name.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// Non-localized name.
	Value *string `json:"value,omitempty"`
}

// LogSpecification - Log Definition of a single resource metric.
type LogSpecification struct {
	BlobDuration *string `json:"blobDuration,omitempty"`
	DisplayName  *string `json:"displayName,omitempty"`
	Name         *string `json:"name,omitempty"`
}

// MSDeploy ARM PUT information
type MSDeploy struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *MSDeployCore `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MSDeployCore - MSDeploy ARM PUT core information
type MSDeployCore struct {
	// Sets the AppOffline rule while the MSDeploy operation executes. Setting is false by default.
	AppOffline *bool `json:"appOffline,omitempty"`

	// SQL Connection String
	ConnectionString *string `json:"connectionString,omitempty"`

	// Database Type
	DbType *string `json:"dbType,omitempty"`

	// Package URI
	PackageURI *string `json:"packageUri,omitempty"`

	// MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
	SetParameters map[string]*string `json:"setParameters,omitempty"`

	// URI of MSDeploy Parameters file. Must not be set if SetParameters is used.
	SetParametersXMLFileURI *string `json:"setParametersXmlFileUri,omitempty"`

	// Controls whether the MSDeploy operation skips the AppData directory. If set to true, the existing AppData directory on
	// the destination will not be deleted, and any App_Data directory in the source
	// will be ignored. Setting is false by default.
	SkipAppData *bool `json:"skipAppData,omitempty"`
}

// MSDeployLog - MSDeploy log
type MSDeployLog struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// MSDeployLog resource specific properties
	Properties *MSDeployLogProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MSDeployLogEntry - MSDeploy log entry
type MSDeployLogEntry struct {
	// READ-ONLY; Log entry message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of log entry
	Time *time.Time `json:"time,omitempty" azure:"ro"`

	// READ-ONLY; Log entry type
	Type *MSDeployLogEntryType `json:"type,omitempty" azure:"ro"`
}

// MSDeployLogProperties - MSDeployLog resource specific properties
type MSDeployLogProperties struct {
	// READ-ONLY; List of log entry messages
	Entries []*MSDeployLogEntry `json:"entries,omitempty" azure:"ro"`
}

// MSDeployStatus - MSDeploy ARM response
type MSDeployStatus struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// MSDeployStatus resource specific properties
	Properties *MSDeployStatusProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MSDeployStatusProperties - MSDeployStatus resource specific properties
type MSDeployStatusProperties struct {
	// READ-ONLY; Whether the deployment operation has completed
	Complete *bool `json:"complete,omitempty" azure:"ro"`

	// READ-ONLY; Username of deployer
	Deployer *string `json:"deployer,omitempty" azure:"ro"`

	// READ-ONLY; End time of deploy operation
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state
	ProvisioningState *MSDeployProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Start time of deploy operation
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// ManagedServiceIdentity - Managed service identity.
type ManagedServiceIdentity struct {
	// Type of managed service identity.
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The list of user assigned identities associated with the resource. The user identity dictionary key references will be
	// ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
	UserAssignedIdentities map[string]*Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; Principal Id of managed service identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; Tenant of managed service identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MetricAvailability - Retention policy of a resource metric.
type MetricAvailability struct {
	BlobDuration *string `json:"blobDuration,omitempty"`
	TimeGrain    *string `json:"timeGrain,omitempty"`
}

// MetricSpecification - Definition of a single resource metric.
type MetricSpecification struct {
	AggregationType                  *string               `json:"aggregationType,omitempty"`
	Availabilities                   []*MetricAvailability `json:"availabilities,omitempty"`
	Category                         *string               `json:"category,omitempty"`
	Dimensions                       []*Dimension          `json:"dimensions,omitempty"`
	DisplayDescription               *string               `json:"displayDescription,omitempty"`
	DisplayName                      *string               `json:"displayName,omitempty"`
	EnableRegionalMdmAccount         *bool                 `json:"enableRegionalMdmAccount,omitempty"`
	FillGapWithZero                  *bool                 `json:"fillGapWithZero,omitempty"`
	IsInternal                       *bool                 `json:"isInternal,omitempty"`
	MetricFilterPattern              *string               `json:"metricFilterPattern,omitempty"`
	Name                             *string               `json:"name,omitempty"`
	SourceMdmAccount                 *string               `json:"sourceMdmAccount,omitempty"`
	SourceMdmNamespace               *string               `json:"sourceMdmNamespace,omitempty"`
	SupportsInstanceLevelAggregation *bool                 `json:"supportsInstanceLevelAggregation,omitempty"`
	Unit                             *string               `json:"unit,omitempty"`
}

// MigrateMySQLRequest - MySQL migration request.
type MigrateMySQLRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// MigrateMySqlRequest resource specific properties
	Properties *MigrateMySQLRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MigrateMySQLRequestProperties - MigrateMySqlRequest resource specific properties
type MigrateMySQLRequestProperties struct {
	// REQUIRED; Connection string to the remote MySQL database.
	ConnectionString *string `json:"connectionString,omitempty"`

	// REQUIRED; The type of migration operation to be done
	MigrationType *MySQLMigrationType `json:"migrationType,omitempty"`
}

// MigrateMySQLStatus - MySQL migration status.
type MigrateMySQLStatus struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// MigrateMySqlStatus resource specific properties
	Properties *MigrateMySQLStatusProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MigrateMySQLStatusProperties - MigrateMySqlStatus resource specific properties
type MigrateMySQLStatusProperties struct {
	// READ-ONLY; True if the web app has in app MySql enabled
	LocalMySQLEnabled *bool `json:"localMySqlEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Status of the migration task.
	MigrationOperationStatus *OperationStatus `json:"migrationOperationStatus,omitempty" azure:"ro"`

	// READ-ONLY; Operation ID for the migration task.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`
}

// NameIdentifier - Identifies an object.
type NameIdentifier struct {
	// Name of the object.
	Name *string `json:"name,omitempty"`
}

// NameValuePair - Name value pair.
type NameValuePair struct {
	// Pair name.
	Name *string `json:"name,omitempty"`

	// Pair value.
	Value *string `json:"value,omitempty"`
}

// NetworkAccessControlEntry - Network access control entry.
type NetworkAccessControlEntry struct {
	// Action object.
	Action *AccessControlEntryAction `json:"action,omitempty"`

	// Description of network access control entry.
	Description *string `json:"description,omitempty"`

	// Order of precedence.
	Order *int32 `json:"order,omitempty"`

	// Remote subnet.
	RemoteSubnet *string `json:"remoteSubnet,omitempty"`
}

// NetworkFeatures - Full view of network features for an app (presently VNET integration and Hybrid Connections).
type NetworkFeatures struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// NetworkFeatures resource specific properties
	Properties *NetworkFeaturesProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkFeaturesProperties - NetworkFeatures resource specific properties
type NetworkFeaturesProperties struct {
	// READ-ONLY; The Hybrid Connections summary view.
	HybridConnections []*RelayServiceConnectionEntity `json:"hybridConnections,omitempty" azure:"ro"`

	// READ-ONLY; The Hybrid Connection V2 (Service Bus) view.
	HybridConnectionsV2 []*HybridConnection `json:"hybridConnectionsV2,omitempty" azure:"ro"`

	// READ-ONLY; The Virtual Network summary view.
	VirtualNetworkConnection *VnetInfo `json:"virtualNetworkConnection,omitempty" azure:"ro"`

	// READ-ONLY; The Virtual Network name.
	VirtualNetworkName *string `json:"virtualNetworkName,omitempty" azure:"ro"`
}

// NetworkTrace - Network trace
type NetworkTrace struct {
	// Detailed message of a network trace operation, e.g. error message in case of failure.
	Message *string `json:"message,omitempty"`

	// Local file path for the captured network trace file.
	Path *string `json:"path,omitempty"`

	// Current status of the network trace operation, same as Operation.Status (InProgress/Succeeded/Failed).
	Status *string `json:"status,omitempty"`
}

// Operation - An operation on a resource.
type Operation struct {
	// Time when operation has started.
	CreatedTime *time.Time `json:"createdTime,omitempty"`

	// Any errors associate with the operation.
	Errors []*ErrorEntity `json:"errors,omitempty"`

	// Time when operation will expire.
	ExpirationTime *time.Time `json:"expirationTime,omitempty"`

	// Applicable only for stamp operation ids.
	GeoMasterOperationID *string `json:"geoMasterOperationId,omitempty"`

	// Operation ID.
	ID *string `json:"id,omitempty"`

	// Time when operation has been updated.
	ModifiedTime *time.Time `json:"modifiedTime,omitempty"`

	// Operation name.
	Name *string `json:"name,omitempty"`

	// The current status of the operation.
	Status *OperationStatus `json:"status,omitempty"`
}

// PerfMonCounterCollection - Collection of performance monitor counters.
type PerfMonCounterCollection struct {
	// REQUIRED; Collection of resources.
	Value []*PerfMonResponse `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PerfMonResponse - Performance monitor API response.
type PerfMonResponse struct {
	// The response code.
	Code *string `json:"code,omitempty"`

	// The performance monitor counters.
	Data *PerfMonSet `json:"data,omitempty"`

	// The message.
	Message *string `json:"message,omitempty"`
}

// PerfMonSample - Performance monitor sample in a set.
type PerfMonSample struct {
	// Name of the server on which the measurement is made.
	InstanceName *string `json:"instanceName,omitempty"`

	// Point in time for which counter was measured.
	Time *time.Time `json:"time,omitempty"`

	// Value of counter at a certain time.
	Value *float64 `json:"value,omitempty"`
}

// PerfMonSet - Metric information.
type PerfMonSet struct {
	// End time of the period.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Unique key name of the counter.
	Name *string `json:"name,omitempty"`

	// Start time of the period.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Presented time grain.
	TimeGrain *string `json:"timeGrain,omitempty"`

	// Collection of workers that are active during this time.
	Values []*PerfMonSample `json:"values,omitempty"`
}

// Plan - App Service plan.
type Plan struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// AppServicePlan resource specific properties
	Properties *PlanProperties `json:"properties,omitempty"`

	// Description of a SKU for a scalable resource.
	SKU *SKUDescription `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PlanCollection - Collection of App Service plans.
type PlanCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Plan `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PlanPatchResource - ARM resource for a app service plan.
type PlanPatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// AppServicePlanPatchResource resource specific properties
	Properties *PlanPatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PlanPatchResourceProperties - AppServicePlanPatchResource resource specific properties
type PlanPatchResourceProperties struct {
	// The time when the server farm free offer expires.
	FreeOfferExpirationTime *time.Time `json:"freeOfferExpirationTime,omitempty"`

	// Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`

	// If Hyper-V container app service plan true, false otherwise.
	HyperV *bool `json:"hyperV,omitempty"`

	// If true, this App Service Plan owns spot instances.
	IsSpot *bool `json:"isSpot,omitempty"`

	// Obsolete: If Hyper-V container app service plan true, false otherwise.
	IsXenon *bool `json:"isXenon,omitempty"`

	// Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
	MaximumElasticWorkerCount *int32 `json:"maximumElasticWorkerCount,omitempty"`

	// If true, apps assigned to this App Service plan can be scaled independently. If false, apps assigned to this App Service
	// plan will scale to all instances of the plan.
	PerSiteScaling *bool `json:"perSiteScaling,omitempty"`

	// If Linux app service plan true, false otherwise.
	Reserved *bool `json:"reserved,omitempty"`

	// The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *time.Time `json:"spotExpirationTime,omitempty"`

	// Scaling worker count.
	TargetWorkerCount *int32 `json:"targetWorkerCount,omitempty"`

	// Scaling worker size ID.
	TargetWorkerSizeID *int32 `json:"targetWorkerSizeId,omitempty"`

	// Target worker tier assigned to the App Service plan.
	WorkerTierName *string `json:"workerTierName,omitempty"`

	// READ-ONLY; Geographical location for the App Service plan.
	GeoRegion *string `json:"geoRegion,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32 `json:"maximumNumberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; Number of apps assigned to this App Service plan.
	NumberOfSites *int32 `json:"numberOfSites,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the App Service Environment.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource group of the App Service plan.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; App Service plan status.
	Status *StatusOptions `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; App Service plan subscription.
	Subscription *string `json:"subscription,omitempty" azure:"ro"`
}

// PlanProperties - AppServicePlan resource specific properties
type PlanProperties struct {
	// The time when the server farm free offer expires.
	FreeOfferExpirationTime *time.Time `json:"freeOfferExpirationTime,omitempty"`

	// Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`

	// If Hyper-V container app service plan true, false otherwise.
	HyperV *bool `json:"hyperV,omitempty"`

	// If true, this App Service Plan owns spot instances.
	IsSpot *bool `json:"isSpot,omitempty"`

	// Obsolete: If Hyper-V container app service plan true, false otherwise.
	IsXenon *bool `json:"isXenon,omitempty"`

	// Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
	MaximumElasticWorkerCount *int32 `json:"maximumElasticWorkerCount,omitempty"`

	// If true, apps assigned to this App Service plan can be scaled independently. If false, apps assigned to this App Service
	// plan will scale to all instances of the plan.
	PerSiteScaling *bool `json:"perSiteScaling,omitempty"`

	// If Linux app service plan true, false otherwise.
	Reserved *bool `json:"reserved,omitempty"`

	// The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *time.Time `json:"spotExpirationTime,omitempty"`

	// Scaling worker count.
	TargetWorkerCount *int32 `json:"targetWorkerCount,omitempty"`

	// Scaling worker size ID.
	TargetWorkerSizeID *int32 `json:"targetWorkerSizeId,omitempty"`

	// Target worker tier assigned to the App Service plan.
	WorkerTierName *string `json:"workerTierName,omitempty"`

	// READ-ONLY; Geographical location for the App Service plan.
	GeoRegion *string `json:"geoRegion,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32 `json:"maximumNumberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; Number of apps assigned to this App Service plan.
	NumberOfSites *int32 `json:"numberOfSites,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the App Service Environment.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource group of the App Service plan.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; App Service plan status.
	Status *StatusOptions `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; App Service plan subscription.
	Subscription *string `json:"subscription,omitempty" azure:"ro"`
}

// PlansClientBeginCreateOrUpdateOptions contains the optional parameters for the PlansClient.BeginCreateOrUpdate method.
type PlansClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PlansClientCreateOrUpdateVnetRouteOptions contains the optional parameters for the PlansClient.CreateOrUpdateVnetRoute
// method.
type PlansClientCreateOrUpdateVnetRouteOptions struct {
	// placeholder for future optional parameters
}

// PlansClientDeleteHybridConnectionOptions contains the optional parameters for the PlansClient.DeleteHybridConnection method.
type PlansClientDeleteHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// PlansClientDeleteOptions contains the optional parameters for the PlansClient.Delete method.
type PlansClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PlansClientDeleteVnetRouteOptions contains the optional parameters for the PlansClient.DeleteVnetRoute method.
type PlansClientDeleteVnetRouteOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetHybridConnectionOptions contains the optional parameters for the PlansClient.GetHybridConnection method.
type PlansClientGetHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetHybridConnectionPlanLimitOptions contains the optional parameters for the PlansClient.GetHybridConnectionPlanLimit
// method.
type PlansClientGetHybridConnectionPlanLimitOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetOptions contains the optional parameters for the PlansClient.Get method.
type PlansClientGetOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetRouteForVnetOptions contains the optional parameters for the PlansClient.GetRouteForVnet method.
type PlansClientGetRouteForVnetOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetServerFarmSKUsOptions contains the optional parameters for the PlansClient.GetServerFarmSKUs method.
type PlansClientGetServerFarmSKUsOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetVnetFromServerFarmOptions contains the optional parameters for the PlansClient.GetVnetFromServerFarm method.
type PlansClientGetVnetFromServerFarmOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetVnetGatewayOptions contains the optional parameters for the PlansClient.GetVnetGateway method.
type PlansClientGetVnetGatewayOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListByResourceGroupOptions contains the optional parameters for the PlansClient.NewListByResourceGroupPager
// method.
type PlansClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListCapabilitiesOptions contains the optional parameters for the PlansClient.ListCapabilities method.
type PlansClientListCapabilitiesOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListHybridConnectionKeysOptions contains the optional parameters for the PlansClient.ListHybridConnectionKeys
// method.
type PlansClientListHybridConnectionKeysOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListHybridConnectionsOptions contains the optional parameters for the PlansClient.NewListHybridConnectionsPager
// method.
type PlansClientListHybridConnectionsOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListMetricDefintionsOptions contains the optional parameters for the PlansClient.NewListMetricDefintionsPager
// method.
type PlansClientListMetricDefintionsOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListMetricsOptions contains the optional parameters for the PlansClient.NewListMetricsPager method.
type PlansClientListMetricsOptions struct {
	// Specify true to include instance details. The default is false.
	Details *bool
	// Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
	// or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and
	// endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
	Filter *string
}

// PlansClientListOptions contains the optional parameters for the PlansClient.NewListPager method.
type PlansClientListOptions struct {
	// Specify true to return all App Service plan properties. The default is false, which returns a subset of the properties.
	// Retrieval of all properties may increase the API latency.
	Detailed *bool
}

// PlansClientListRoutesForVnetOptions contains the optional parameters for the PlansClient.ListRoutesForVnet method.
type PlansClientListRoutesForVnetOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListUsagesOptions contains the optional parameters for the PlansClient.NewListUsagesPager method.
type PlansClientListUsagesOptions struct {
	// Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
	// or name.value eq 'Metric2').
	Filter *string
}

// PlansClientListVnetsOptions contains the optional parameters for the PlansClient.ListVnets method.
type PlansClientListVnetsOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListWebAppsByHybridConnectionOptions contains the optional parameters for the PlansClient.NewListWebAppsByHybridConnectionPager
// method.
type PlansClientListWebAppsByHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListWebAppsOptions contains the optional parameters for the PlansClient.NewListWebAppsPager method.
type PlansClientListWebAppsOptions struct {
	// Supported filter: $filter=state eq running. Returns only web apps that are currently running
	Filter *string
	// Skip to a web app in the list of webapps associated with app service plan. If specified, the resulting list will contain
	// web apps starting from (including) the skipToken. Otherwise, the resulting list
	// contains web apps from the start of the list
	SkipToken *string
	// List page size. If specified, results are paged.
	Top *string
}

// PlansClientRebootWorkerOptions contains the optional parameters for the PlansClient.RebootWorker method.
type PlansClientRebootWorkerOptions struct {
	// placeholder for future optional parameters
}

// PlansClientRestartWebAppsOptions contains the optional parameters for the PlansClient.RestartWebApps method.
type PlansClientRestartWebAppsOptions struct {
	// Specify true to perform a soft restart, applies the configuration settings and restarts the apps if necessary. The default
	// is false, which always restarts and reprovisions the apps
	SoftRestart *bool
}

// PlansClientUpdateOptions contains the optional parameters for the PlansClient.Update method.
type PlansClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PlansClientUpdateVnetGatewayOptions contains the optional parameters for the PlansClient.UpdateVnetGateway method.
type PlansClientUpdateVnetGatewayOptions struct {
	// placeholder for future optional parameters
}

// PlansClientUpdateVnetRouteOptions contains the optional parameters for the PlansClient.UpdateVnetRoute method.
type PlansClientUpdateVnetRouteOptions struct {
	// placeholder for future optional parameters
}

// PremierAddOn - Premier add-on.
type PremierAddOn struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PremierAddOn resource specific properties
	Properties *PremierAddOnProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PremierAddOnOffer - Premier add-on offer.
type PremierAddOnOffer struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PremierAddOnOffer resource specific properties
	Properties *PremierAddOnOfferProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PremierAddOnOfferCollection - Collection of premier add-on offers.
type PremierAddOnOfferCollection struct {
	// REQUIRED; Collection of resources.
	Value []*PremierAddOnOffer `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PremierAddOnOfferProperties - PremierAddOnOffer resource specific properties
type PremierAddOnOfferProperties struct {
	// Legal terms URL.
	LegalTermsURL *string `json:"legalTermsUrl,omitempty"`

	// Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`

	// Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`

	// Privacy policy URL.
	PrivacyPolicyURL *string `json:"privacyPolicyUrl,omitempty"`

	// Premier add on offer Product.
	Product *string `json:"product,omitempty"`

	// true if promotion code is required; otherwise, false.
	PromoCodeRequired *bool `json:"promoCodeRequired,omitempty"`

	// Premier add on offer Quota.
	Quota *int32 `json:"quota,omitempty"`

	// Premier add on SKU.
	SKU *string `json:"sku,omitempty"`

	// Premier add on offer Vendor.
	Vendor *string `json:"vendor,omitempty"`

	// App Service plans this offer is restricted to.
	WebHostingPlanRestrictions *AppServicePlanRestrictions `json:"webHostingPlanRestrictions,omitempty"`
}

// PremierAddOnPatchResource - ARM resource for a PremierAddOn.
type PremierAddOnPatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PremierAddOnPatchResource resource specific properties
	Properties *PremierAddOnPatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PremierAddOnPatchResourceProperties - PremierAddOnPatchResource resource specific properties
type PremierAddOnPatchResourceProperties struct {
	// Premier add on Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`

	// Premier add on Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`

	// Premier add on Product.
	Product *string `json:"product,omitempty"`

	// Premier add on SKU.
	SKU *string `json:"sku,omitempty"`

	// Premier add on Vendor.
	Vendor *string `json:"vendor,omitempty"`
}

// PremierAddOnProperties - PremierAddOn resource specific properties
type PremierAddOnProperties struct {
	// Premier add on Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`

	// Premier add on Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`

	// Premier add on Product.
	Product *string `json:"product,omitempty"`

	// Premier add on SKU.
	SKU *string `json:"sku,omitempty"`

	// Premier add on Vendor.
	Vendor *string `json:"vendor,omitempty"`
}

// PrivateAccess - Description of the parameters of Private Access for a Web Site.
type PrivateAccess struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PrivateAccess resource specific properties
	Properties *PrivateAccessProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateAccessProperties - PrivateAccess resource specific properties
type PrivateAccessProperties struct {
	// Whether private access is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// The Virtual Networks (and subnets) allowed to access the site privately.
	VirtualNetworks []*PrivateAccessVirtualNetwork `json:"virtualNetworks,omitempty"`
}

// PrivateAccessSubnet - Description of a Virtual Network subnet that is useable for private site access.
type PrivateAccessSubnet struct {
	// The key (ID) of the subnet.
	Key *int32 `json:"key,omitempty"`

	// The name of the subnet.
	Name *string `json:"name,omitempty"`
}

// PrivateAccessVirtualNetwork - Description of a Virtual Network that is useable for private site access.
type PrivateAccessVirtualNetwork struct {
	// The key (ID) of the Virtual Network.
	Key *int32 `json:"key,omitempty"`

	// The name of the Virtual Network.
	Name *string `json:"name,omitempty"`

	// The ARM uri of the Virtual Network
	ResourceID *string `json:"resourceId,omitempty"`

	// A List of subnets that access is allowed to on this Virtual Network. An empty array (but not null) is interpreted to mean
	// that all subnets are allowed within this Virtual Network.
	Subnets []*PrivateAccessSubnet `json:"subnets,omitempty"`
}

// ProcessInfo - Process Information.
type ProcessInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ProcessInfo resource specific properties
	Properties *ProcessInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProcessInfoCollection - Collection of Kudu process information elements.
type ProcessInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ProcessInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ProcessInfoProperties - ProcessInfo resource specific properties
type ProcessInfoProperties struct {
	// Child process list.
	Children []*string `json:"children,omitempty"`

	// Command line.
	CommandLine *string `json:"command_line,omitempty"`

	// Deployment name.
	DeploymentName *string `json:"deployment_name,omitempty"`

	// Description of process.
	Description *string `json:"description,omitempty"`

	// List of environment variables.
	EnvironmentVariables map[string]*string `json:"environment_variables,omitempty"`

	// File name of this process.
	FileName *string `json:"file_name,omitempty"`

	// Handle count.
	HandleCount *int32 `json:"handle_count,omitempty"`

	// HRef URI.
	Href *string `json:"href,omitempty"`

	// IIS Profile timeout (seconds).
	IisProfileTimeoutInSeconds *float64 `json:"iis_profile_timeout_in_seconds,omitempty"`

	// Is the IIS Profile running?
	IsIisProfileRunning *bool `json:"is_iis_profile_running,omitempty"`

	// Is profile running?
	IsProfileRunning *bool `json:"is_profile_running,omitempty"`

	// Is this the SCM site?
	IsScmSite *bool `json:"is_scm_site,omitempty"`

	// Is this a Web Job?
	IsWebjob *bool `json:"is_webjob,omitempty"`

	// Minidump URI.
	Minidump *string `json:"minidump,omitempty"`

	// Module count.
	ModuleCount *int32 `json:"module_count,omitempty"`

	// List of modules.
	Modules []*ProcessModuleInfo `json:"modules,omitempty"`

	// Non-paged system memory.
	NonPagedSystemMemory *int64 `json:"non_paged_system_memory,omitempty"`

	// List of open files.
	OpenFileHandles []*string `json:"open_file_handles,omitempty"`

	// Paged memory.
	PagedMemory *int64 `json:"paged_memory,omitempty"`

	// Paged system memory.
	PagedSystemMemory *int64 `json:"paged_system_memory,omitempty"`

	// Parent process.
	Parent *string `json:"parent,omitempty"`

	// Peak paged memory.
	PeakPagedMemory *int64 `json:"peak_paged_memory,omitempty"`

	// Peak virtual memory usage.
	PeakVirtualMemory *int64 `json:"peak_virtual_memory,omitempty"`

	// Peak working set.
	PeakWorkingSet *int64 `json:"peak_working_set,omitempty"`

	// Private memory size.
	PrivateMemory *int64 `json:"private_memory,omitempty"`

	// Privileged CPU time.
	PrivilegedCPUTime *string `json:"privileged_cpu_time,omitempty"`

	// Start time.
	StartTime *time.Time `json:"start_time,omitempty"`

	// Thread count.
	ThreadCount *int32 `json:"thread_count,omitempty"`

	// Thread list.
	Threads []*ProcessThreadInfo `json:"threads,omitempty"`

	// Time stamp.
	TimeStamp *time.Time `json:"time_stamp,omitempty"`

	// Total CPU time.
	TotalCPUTime *string `json:"total_cpu_time,omitempty"`

	// User CPU time.
	UserCPUTime *string `json:"user_cpu_time,omitempty"`

	// User name.
	UserName *string `json:"user_name,omitempty"`

	// Virtual memory size.
	VirtualMemory *int64 `json:"virtual_memory,omitempty"`

	// Working set.
	WorkingSet *int64 `json:"working_set,omitempty"`

	// READ-ONLY; ARM Identifier for deployment.
	Identifier *int32 `json:"identifier,omitempty" azure:"ro"`
}

// ProcessModuleInfo - Process Module Information.
type ProcessModuleInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ProcessModuleInfo resource specific properties
	Properties *ProcessModuleInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProcessModuleInfoCollection - Collection of Kudu thread information elements.
type ProcessModuleInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ProcessModuleInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ProcessModuleInfoProperties - ProcessModuleInfo resource specific properties
type ProcessModuleInfoProperties struct {
	// Base address. Used as module identifier in ARM resource URI.
	BaseAddress *string `json:"base_address,omitempty"`

	// File description.
	FileDescription *string `json:"file_description,omitempty"`

	// File name.
	FileName *string `json:"file_name,omitempty"`

	// File path.
	FilePath *string `json:"file_path,omitempty"`

	// File version.
	FileVersion *string `json:"file_version,omitempty"`

	// HRef URI.
	Href *string `json:"href,omitempty"`

	// Is debug?
	IsDebug *bool `json:"is_debug,omitempty"`

	// Module language (locale).
	Language *string `json:"language,omitempty"`

	// Module memory size.
	ModuleMemorySize *int32 `json:"module_memory_size,omitempty"`

	// Product name.
	Product *string `json:"product,omitempty"`

	// Product version.
	ProductVersion *string `json:"product_version,omitempty"`
}

// ProcessThreadInfo - Process Thread Information.
type ProcessThreadInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ProcessThreadInfo resource specific properties
	Properties *ProcessThreadInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProcessThreadInfoCollection - Collection of Kudu thread information elements.
type ProcessThreadInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ProcessThreadInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ProcessThreadInfoProperties - ProcessThreadInfo resource specific properties
type ProcessThreadInfoProperties struct {
	// Base priority.
	BasePriority *int32 `json:"base_priority,omitempty"`

	// Current thread priority.
	CurrentPriority *int32 `json:"current_priority,omitempty"`

	// HRef URI.
	Href *string `json:"href,omitempty"`

	// Thread priority level.
	PriorityLevel *string `json:"priority_level,omitempty"`

	// Privileged processor time.
	PriviledgedProcessorTime *string `json:"priviledged_processor_time,omitempty"`

	// Process URI.
	Process *string `json:"process,omitempty"`

	// Start address.
	StartAddress *string `json:"start_address,omitempty"`

	// Start time.
	StartTime *time.Time `json:"start_time,omitempty"`

	// Thread state.
	State *string `json:"state,omitempty"`

	// Total processor time.
	TotalProcessorTime *string `json:"total_processor_time,omitempty"`

	// User processor time.
	UserProcessorTime *string `json:"user_processor_time,omitempty"`

	// Wait reason.
	WaitReason *string `json:"wait_reason,omitempty"`

	// READ-ONLY; Site extension ID.
	Identifier *int32 `json:"identifier,omitempty" azure:"ro"`
}

// ProviderClientGetAvailableStacksOnPremOptions contains the optional parameters for the ProviderClient.NewGetAvailableStacksOnPremPager
// method.
type ProviderClientGetAvailableStacksOnPremOptions struct {
	OSTypeSelected *Enum12
}

// ProviderClientGetAvailableStacksOptions contains the optional parameters for the ProviderClient.NewGetAvailableStacksPager
// method.
type ProviderClientGetAvailableStacksOptions struct {
	OSTypeSelected *Enum11
}

// ProviderClientListOperationsOptions contains the optional parameters for the ProviderClient.NewListOperationsPager method.
type ProviderClientListOperationsOptions struct {
	// placeholder for future optional parameters
}

// ProxyOnlyResource - Azure proxy only resource. This resource is not tracked by Azure Resource Manager.
type ProxyOnlyResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PublicCertificate - Public certificate object
type PublicCertificate struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PublicCertificate resource specific properties
	Properties *PublicCertificateProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PublicCertificateCollection - Collection of public certificates
type PublicCertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*PublicCertificate `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PublicCertificateProperties - PublicCertificate resource specific properties
type PublicCertificateProperties struct {
	// Public Certificate byte array
	Blob []byte `json:"blob,omitempty"`

	// Public Certificate Location
	PublicCertificateLocation *PublicCertificateLocation `json:"publicCertificateLocation,omitempty"`

	// READ-ONLY; Certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// PushSettings - Push settings for the App.
type PushSettings struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PushSettings resource specific properties
	Properties *PushSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PushSettingsProperties - PushSettings resource specific properties
type PushSettingsProperties struct {
	// REQUIRED; Gets or sets a flag indicating whether the Push endpoint is enabled.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`

	// Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration
	// endpoint.
	DynamicTagsJSON *string `json:"dynamicTagsJson,omitempty"`

	// Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
	TagWhitelistJSON *string `json:"tagWhitelistJson,omitempty"`

	// Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration
	// endpoint. Tags can consist of alphanumeric characters and the following: '_',
	// '@', '#', '.', ':', '-'. Validation should be performed at the PushRequestHandler.
	TagsRequiringAuth *string `json:"tagsRequiringAuth,omitempty"`
}

// RampUpRule - Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually
// change routing % based on performance.
type RampUpRule struct {
	// Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
	ActionHostName *string `json:"actionHostName,omitempty"`

	// Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site
	// extension for the scaffold and contracts.
	// https://www.siteextensions.net/packages/TiPCallback/
	ChangeDecisionCallbackURL *string `json:"changeDecisionCallbackUrl,omitempty"`

	// Specifies interval in minutes to reevaluate ReroutePercentage.
	ChangeIntervalInMinutes *int32 `json:"changeIntervalInMinutes,omitempty"`

	// In auto ramp up scenario this is the step to add/remove from ReroutePercentage until it reachesMinReroutePercentage or
	// MaxReroutePercentage. Site metrics are checked every N minutes specified in
	// ChangeIntervalInMinutes. Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified
	// in ChangeDecisionCallbackUrl.
	ChangeStep *float64 `json:"changeStep,omitempty"`

	// Specifies upper boundary below which ReroutePercentage will stay.
	MaxReroutePercentage *float64 `json:"maxReroutePercentage,omitempty"`

	// Specifies lower boundary above which ReroutePercentage will stay.
	MinReroutePercentage *float64 `json:"minReroutePercentage,omitempty"`

	// Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
	Name *string `json:"name,omitempty"`

	// Percentage of the traffic which will be redirected to ActionHostName.
	ReroutePercentage *float64 `json:"reroutePercentage,omitempty"`
}

// Recommendation - Represents a recommendation result generated by the recommendation engine.
type Recommendation struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Recommendation resource specific properties
	Properties *RecommendationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecommendationCollection - Collection of recommendations.
type RecommendationCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Recommendation `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// RecommendationProperties - Recommendation resource specific properties
type RecommendationProperties struct {
	// Name of action recommended by this object.
	ActionName *string `json:"actionName,omitempty"`

	// Deep link to a blade on the portal.
	BladeName *string `json:"bladeName,omitempty"`

	// List of channels that this recommendation can apply.
	Channels *Channels `json:"channels,omitempty"`

	// Timestamp when this instance was created.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// UI friendly name of the rule (may not be unique).
	DisplayName *string `json:"displayName,omitempty"`

	// True if this recommendation is still valid (i.e. "actionable"). False if it is invalid.
	Enabled *int32 `json:"enabled,omitempty"`

	// The end time in UTC of a range that the recommendation refers to.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Extension name of the portal if exists.
	ExtensionName *string `json:"extensionName,omitempty"`

	// Forward link to an external document associated with the rule.
	ForwardLink *string `json:"forwardLink,omitempty"`

	// True if this is associated with a dynamically added rule
	IsDynamic *bool `json:"isDynamic,omitempty"`

	// Level indicating how critical this recommendation can impact.
	Level *NotificationLevel `json:"level,omitempty"`

	// Recommendation text.
	Message *string `json:"message,omitempty"`

	// When to notify this recommendation next in UTC. Null means that this will never be notified anymore.
	NextNotificationTime *time.Time `json:"nextNotificationTime,omitempty"`

	// Date and time in UTC when this notification expires.
	NotificationExpirationTime *time.Time `json:"notificationExpirationTime,omitempty"`

	// Last timestamp in UTC this instance was actually notified. Null means that this recommendation hasn't been notified yet.
	NotifiedTime *time.Time `json:"notifiedTime,omitempty"`

	// A GUID value that each recommendation object is associated with.
	RecommendationID *string `json:"recommendationId,omitempty"`

	// Full ARM resource ID string that this recommendation object is associated with.
	ResourceID *string `json:"resourceId,omitempty"`

	// Name of a resource type this recommendation applies, e.g. Subscription, ServerFarm, Site.
	ResourceScope *ResourceScopeType `json:"resourceScope,omitempty"`

	// Unique name of the rule.
	RuleName *string `json:"ruleName,omitempty"`

	// A metric value measured by the rule.
	Score *float64 `json:"score,omitempty"`

	// The beginning time in UTC of a range that the recommendation refers to.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The list of states of this recommendation. If it's null then it should be considered "Active".
	States []*string `json:"states,omitempty"`

	// READ-ONLY; The list of category tags that this recommendation belongs to.
	CategoryTags []*string `json:"categoryTags,omitempty" azure:"ro"`
}

// RecommendationRule - Represents a recommendation rule that the recommendation engine can perform.
type RecommendationRule struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// RecommendationRule resource specific properties
	Properties *RecommendationRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecommendationRuleProperties - RecommendationRule resource specific properties
type RecommendationRuleProperties struct {
	// Name of action that is recommended by this rule in string.
	ActionName *string `json:"actionName,omitempty"`

	// Deep link to a blade on the portal. Applicable to dynamic rule only.
	BladeName *string `json:"bladeName,omitempty"`

	// List of available channels that this rule applies.
	Channels *Channels `json:"channels,omitempty"`

	// Localized detailed description of the rule.
	Description *string `json:"description,omitempty"`

	// UI friendly name of the rule.
	DisplayName *string `json:"displayName,omitempty"`

	// Extension name of the portal if exists. Applicable to dynamic rule only.
	ExtensionName *string `json:"extensionName,omitempty"`

	// Forward link to an external document associated with the rule. Applicable to dynamic rule only.
	ForwardLink *string `json:"forwardLink,omitempty"`

	// True if this is associated with a dynamically added rule
	IsDynamic *bool `json:"isDynamic,omitempty"`

	// Level of impact indicating how critical this rule is.
	Level *NotificationLevel `json:"level,omitempty"`

	// Localized name of the rule (Good for UI).
	Message *string `json:"message,omitempty"`

	// Recommendation ID of an associated recommendation object tied to the rule, if exists. If such an object doesn't exist,
	// it is set to null.
	RecommendationID *string `json:"recommendationId,omitempty"`

	// Unique name of the rule.
	RecommendationName *string `json:"recommendationName,omitempty"`

	// READ-ONLY; The list of category tags that this recommendation rule belongs to.
	CategoryTags []*string `json:"categoryTags,omitempty" azure:"ro"`
}

// RecommendationsClientDisableAllForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.DisableAllForHostingEnvironment
// method.
type RecommendationsClientDisableAllForHostingEnvironmentOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientDisableAllForWebAppOptions contains the optional parameters for the RecommendationsClient.DisableAllForWebApp
// method.
type RecommendationsClientDisableAllForWebAppOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientDisableRecommendationForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.DisableRecommendationForHostingEnvironment
// method.
type RecommendationsClientDisableRecommendationForHostingEnvironmentOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientDisableRecommendationForSiteOptions contains the optional parameters for the RecommendationsClient.DisableRecommendationForSite
// method.
type RecommendationsClientDisableRecommendationForSiteOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientDisableRecommendationForSubscriptionOptions contains the optional parameters for the RecommendationsClient.DisableRecommendationForSubscription
// method.
type RecommendationsClientDisableRecommendationForSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.GetRuleDetailsByHostingEnvironment
// method.
type RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions struct {
	// The GUID of the recommendation object if you query an expired one. You don't need to specify it to query an active entry.
	RecommendationID *string
	// Specify true to update the last-seen timestamp of the recommendation object.
	UpdateSeen *bool
}

// RecommendationsClientGetRuleDetailsByWebAppOptions contains the optional parameters for the RecommendationsClient.GetRuleDetailsByWebApp
// method.
type RecommendationsClientGetRuleDetailsByWebAppOptions struct {
	// The GUID of the recommendation object if you query an expired one. You don't need to specify it to query an active entry.
	RecommendationID *string
	// Specify true to update the last-seen timestamp of the recommendation object.
	UpdateSeen *bool
}

// RecommendationsClientListHistoryForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.NewListHistoryForHostingEnvironmentPager
// method.
type RecommendationsClientListHistoryForHostingEnvironmentOptions struct {
	// Specify false to return all recommendations. The default is true, which returns only expired recommendations.
	ExpiredOnly *bool
	// Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq 'Notification' and startTime
	// eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[PT1H|PT1M|P1D]
	Filter *string
}

// RecommendationsClientListHistoryForWebAppOptions contains the optional parameters for the RecommendationsClient.NewListHistoryForWebAppPager
// method.
type RecommendationsClientListHistoryForWebAppOptions struct {
	// Specify false to return all recommendations. The default is true, which returns only expired recommendations.
	ExpiredOnly *bool
	// Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq 'Notification' and startTime
	// eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[PT1H|PT1M|P1D]
	Filter *string
}

// RecommendationsClientListOptions contains the optional parameters for the RecommendationsClient.NewListPager method.
type RecommendationsClientListOptions struct {
	// Specify true to return only the most critical recommendations. The default is false, which returns all recommendations.
	Featured *bool
	// Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq 'Notification' and startTime
	// eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[PT1H|PT1M|P1D]
	Filter *string
}

// RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.NewListRecommendedRulesForHostingEnvironmentPager
// method.
type RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions struct {
	// Specify true to return only the most critical recommendations. The default is false, which returns all recommendations.
	Featured *bool
	// Return only channels specified in the filter. Filter is specified by using OData syntax. Example: $filter=channel eq 'Api'
	// or channel eq 'Notification'
	Filter *string
}

// RecommendationsClientListRecommendedRulesForWebAppOptions contains the optional parameters for the RecommendationsClient.NewListRecommendedRulesForWebAppPager
// method.
type RecommendationsClientListRecommendedRulesForWebAppOptions struct {
	// Specify true to return only the most critical recommendations. The default is false, which returns all recommendations.
	Featured *bool
	// Return only channels specified in the filter. Filter is specified by using OData syntax. Example: $filter=channel eq 'Api'
	// or channel eq 'Notification'
	Filter *string
}

// RecommendationsClientResetAllFiltersForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.ResetAllFiltersForHostingEnvironment
// method.
type RecommendationsClientResetAllFiltersForHostingEnvironmentOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientResetAllFiltersForWebAppOptions contains the optional parameters for the RecommendationsClient.ResetAllFiltersForWebApp
// method.
type RecommendationsClientResetAllFiltersForWebAppOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientResetAllFiltersOptions contains the optional parameters for the RecommendationsClient.ResetAllFilters
// method.
type RecommendationsClientResetAllFiltersOptions struct {
	// placeholder for future optional parameters
}

// RelayServiceConnectionEntity - Hybrid Connection for an App Service app.
type RelayServiceConnectionEntity struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// RelayServiceConnectionEntity resource specific properties
	Properties *RelayServiceConnectionEntityProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RelayServiceConnectionEntityProperties - RelayServiceConnectionEntity resource specific properties
type RelayServiceConnectionEntityProperties struct {
	BiztalkURI               *string `json:"biztalkUri,omitempty"`
	EntityConnectionString   *string `json:"entityConnectionString,omitempty"`
	EntityName               *string `json:"entityName,omitempty"`
	Hostname                 *string `json:"hostname,omitempty"`
	Port                     *int32  `json:"port,omitempty"`
	ResourceConnectionString *string `json:"resourceConnectionString,omitempty"`
	ResourceType             *string `json:"resourceType,omitempty"`
}

// RequestsBasedTrigger - Trigger based on total requests.
type RequestsBasedTrigger struct {
	// Request Count.
	Count *int32 `json:"count,omitempty"`

	// Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Resource - Azure resource. This resource is tracked in Azure Resource Manager
type Resource struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceCollection - Collection of resources.
type ResourceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*string `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceMetric - Object representing a metric for any resource .
type ResourceMetric struct {
	// READ-ONLY; Metric end time.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Metric values.
	MetricValues []*ResourceMetricValue `json:"metricValues,omitempty" azure:"ro"`

	// READ-ONLY; Name of metric.
	Name *ResourceMetricName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource metric properties collection.
	Properties []*ResourceMetricProperty `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Metric resource Id.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; Metric start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Metric granularity. E.g PT1H, PT5M, P1D
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`

	// READ-ONLY; Metric unit.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// ResourceMetricAvailability - Metrics availability and retention.
type ResourceMetricAvailability struct {
	// READ-ONLY; Retention period for the current time grain.
	Retention *string `json:"retention,omitempty" azure:"ro"`

	// READ-ONLY; Time grain .
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`
}

// ResourceMetricCollection - Collection of metric responses.
type ResourceMetricCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ResourceMetric `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceMetricDefinition - Metadata for the metrics.
type ResourceMetricDefinition struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ResourceMetricDefinition resource specific properties
	Properties *ResourceMetricDefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceMetricDefinitionCollection - Collection of metric definitions.
type ResourceMetricDefinitionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ResourceMetricDefinition `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceMetricDefinitionProperties - ResourceMetricDefinition resource specific properties
type ResourceMetricDefinitionProperties struct {
	// READ-ONLY; List of time grains supported for the metric together with retention period.
	MetricAvailabilities []*ResourceMetricAvailability `json:"metricAvailabilities,omitempty" azure:"ro"`

	// READ-ONLY; Primary aggregation type.
	PrimaryAggregationType *string `json:"primaryAggregationType,omitempty" azure:"ro"`

	// READ-ONLY; Resource metric definition properties.
	Properties map[string]*string `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource URI.
	ResourceURI *string `json:"resourceUri,omitempty" azure:"ro"`

	// READ-ONLY; Unit of the metric.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// ResourceMetricName - Name of a metric for any resource .
type ResourceMetricName struct {
	// READ-ONLY; Localized metric name value.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; metric name value.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// ResourceMetricProperty - Resource metric property.
type ResourceMetricProperty struct {
	// Key for resource metric property.
	Key *string `json:"key,omitempty"`

	// Value of pair.
	Value *string `json:"value,omitempty"`
}

// ResourceMetricValue - Value of resource metric.
type ResourceMetricValue struct {
	// READ-ONLY; Value average.
	Average *float32 `json:"average,omitempty" azure:"ro"`

	// READ-ONLY; Value count.
	Count *float32 `json:"count,omitempty" azure:"ro"`

	// READ-ONLY; Value maximum.
	Maximum *float32 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; Value minimum.
	Minimum *float32 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; Resource metric properties collection.
	Properties []*ResourceMetricProperty `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Value timestamp.
	Timestamp *string `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; Value total.
	Total *float32 `json:"total,omitempty" azure:"ro"`
}

// ResourceNameAvailability - Information regarding availability of a resource name.
type ResourceNameAvailability struct {
	// If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements
	// so that the user can select a valid name. If reason == AlreadyExists,
	// explain that resource name is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`

	// true indicates name is valid and available. false indicates the name is invalid, unavailable, or both.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// Invalid indicates the name provided does not match Azure App Service naming requirements. AlreadyExists indicates that
	// the name is already in use and is therefore unavailable.
	Reason *InAvailabilityReasonType `json:"reason,omitempty"`
}

// ResourceNameAvailabilityRequest - Resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	// REQUIRED; Resource name to verify.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Resource type used for verification.
	Type *CheckNameResourceTypes `json:"type,omitempty"`

	// Is fully qualified domain name.
	IsFqdn *bool `json:"isFqdn,omitempty"`
}

// RestoreRequest - Description of a restore request.
type RestoreRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// RestoreRequest resource specific properties
	Properties *RestoreRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestoreRequestProperties - RestoreRequest resource specific properties
type RestoreRequestProperties struct {
	// REQUIRED; true if the restore operation can overwrite target app; otherwise, false. true is needed if trying to restore
	// over an existing app.
	Overwrite *bool `json:"overwrite,omitempty"`

	// REQUIRED; SAS URL to the container.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`

	// true if SiteConfig.ConnectionStrings should be set in new app; otherwise, false.
	AdjustConnectionStrings *bool `json:"adjustConnectionStrings,omitempty"`

	// Specify app service plan that will own restored site.
	AppServicePlan *string `json:"appServicePlan,omitempty"`

	// Name of a blob which contains the backup.
	BlobName *string `json:"blobName,omitempty"`

	// Collection of databases which should be restored. This list has to match the list of databases included in the backup.
	Databases []*DatabaseBackupSetting `json:"databases,omitempty"`

	// App Service Environment name, if needed (only when restoring an app to an App Service Environment).
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`

	// Changes a logic when restoring an app with custom domains. true to remove custom domains automatically. If false, custom
	// domains are added to the app's object when it is being restored, but that might
	// fail due to conflicts during the operation.
	IgnoreConflictingHostNames *bool `json:"ignoreConflictingHostNames,omitempty"`

	// Ignore the databases and only restore the site content
	IgnoreDatabases *bool `json:"ignoreDatabases,omitempty"`

	// Operation type.
	OperationType *BackupRestoreOperationType `json:"operationType,omitempty"`

	// Name of an app.
	SiteName *string `json:"siteName,omitempty"`
}

// SKUCapacity - Description of the App Service plan scale options.
type SKUCapacity struct {
	// Default number of workers for this App Service plan SKU.
	Default *int32 `json:"default,omitempty"`

	// Maximum number of workers for this App Service plan SKU.
	Maximum *int32 `json:"maximum,omitempty"`

	// Minimum number of workers for this App Service plan SKU.
	Minimum *int32 `json:"minimum,omitempty"`

	// Available scale configurations for an App Service plan.
	ScaleType *string `json:"scaleType,omitempty"`
}

// SKUDescription - Description of a SKU for a scalable resource.
type SKUDescription struct {
	// Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities []*Capability `json:"capabilities,omitempty"`

	// Current number of instances assigned to the resource.
	Capacity *int32 `json:"capacity,omitempty"`

	// Family code of the resource SKU.
	Family *string `json:"family,omitempty"`

	// Locations of the SKU.
	Locations []*string `json:"locations,omitempty"`

	// Name of the resource SKU.
	Name *string `json:"name,omitempty"`

	// Min, max, and default scale values of the SKU.
	SKUCapacity *SKUCapacity `json:"skuCapacity,omitempty"`

	// Size specifier of the resource SKU.
	Size *string `json:"size,omitempty"`

	// Service tier of the resource SKU.
	Tier *string `json:"tier,omitempty"`
}

// SKUInfos - Collection of SKU information.
type SKUInfos struct {
	// Resource type that this SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`

	// List of SKUs the subscription is able to use.
	SKUs []*GlobalCsmSKUDescription `json:"skus,omitempty"`
}

// ServiceSpecification - Resource metrics service provided by Microsoft.Insights resource provider.
type ServiceSpecification struct {
	LogSpecifications    []*LogSpecification    `json:"logSpecifications,omitempty"`
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Site - A web app, a mobile app backend, or an API app.
type Site struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Managed service identity.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Site resource specific properties
	Properties *SiteProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteAuthSettings - Configuration settings for the Azure App Service Authentication / Authorization feature.
type SiteAuthSettings struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteAuthSettings resource specific properties
	Properties *SiteAuthSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteAuthSettingsProperties - SiteAuthSettings resource specific properties
type SiteAuthSettingsProperties struct {
	// Login parameters to send to the OpenID Connect authorization endpoint when a user logs in. Each parameter must be in the
	// form "key=value".
	AdditionalLoginParams []*string `json:"additionalLoginParams,omitempty"`

	// Allowed audience values to consider when validating JWTs issued by Azure Active Directory. Note that the ClientID value
	// is always considered an allowed audience, regardless of this setting.
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`

	// External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part
	// of the URL is ignored. This is an advanced setting typically only needed by
	// Windows Store application backends. Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls []*string `json:"allowedExternalRedirectUrls,omitempty"`

	// The Client ID of this relying party application, known as the clientid. This setting is required for enabling OpenID Connection
	// authentication with Azure Active Directory or other 3rd party OpenID
	// Connect providers. More information on OpenID Connect: http://openid.net/specs/openid-connect-core-10.html
	ClientID *string `json:"clientId,omitempty"`

	// The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key). This
	// setting is optional. If no client secret is configured, the OpenID Connect
	// implicit auth flow is used to authenticate end users. Otherwise, the OpenID Connect Authorization Code Flow is used to
	// authenticate end users. More information on OpenID Connect:
	// http://openid.net/specs/openid-connect-core-1_0.html
	ClientSecret *string `json:"clientSecret,omitempty"`

	// An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts
	// as a replacement for the Client Secret. It is also optional.
	ClientSecretCertificateThumbprint *string `json:"clientSecretCertificateThumbprint,omitempty"`

	// The default authentication provider to use when multiple providers are configured. This setting is only needed if multiple
	// providers are configured and the unauthenticated client action is set to
	// "RedirectToLoginPage".
	DefaultProvider *BuiltInAuthenticationProvider `json:"defaultProvider,omitempty"`

	// true if the Authentication / Authorization feature is enabled for the current app; otherwise, false.
	Enabled *bool `json:"enabled,omitempty"`

	// The App ID of the Facebook app used for login. This setting is required for enabling Facebook Login. Facebook Login documentation:
	// https://developers.facebook.com/docs/facebook-login
	FacebookAppID *string `json:"facebookAppId,omitempty"`

	// The App Secret of the Facebook app used for Facebook Login. This setting is required for enabling Facebook Login. Facebook
	// Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookAppSecret *string `json:"facebookAppSecret,omitempty"`

	// The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication. This setting is optional. Facebook
	// Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookOAuthScopes []*string `json:"facebookOAuthScopes,omitempty"`

	// The OpenID Connect Client ID for the Google web application. This setting is required for enabling Google Sign-In. Google
	// Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientID *string `json:"googleClientId,omitempty"`

	// The client secret associated with the Google web application. This setting is required for enabling Google Sign-In. Google
	// Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientSecret *string `json:"googleClientSecret,omitempty"`

	// The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication. This setting is optional. If not
	// specified, "openid", "profile", and "email" are used as default scopes. Google
	// Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleOAuthScopes []*string `json:"googleOAuthScopes,omitempty"`

	// The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application. When using Azure
	// Active Directory, this value is the URI of the directory tenant, e.g.
	// https://sts.windows.net/{tenant-guid}/. This URI is a case-sensitive identifier for the token issuer. More information
	// on OpenID Connect Discovery:
	// http://openid.net/specs/openid-connect-discovery-1_0.html
	Issuer *string `json:"issuer,omitempty"`

	// The OAuth 2.0 client ID that was created for the app used for authentication. This setting is required for enabling Microsoft
	// Account authentication. Microsoft Account OAuth documentation:
	// https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientID *string `json:"microsoftAccountClientId,omitempty"`

	// The OAuth 2.0 client secret that was created for the app used for authentication. This setting is required for enabling
	// Microsoft Account authentication. Microsoft Account OAuth documentation:
	// https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientSecret *string `json:"microsoftAccountClientSecret,omitempty"`

	// The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication. This setting is optional. If not
	// specified, "wl.basic" is used as the default scope. Microsoft Account Scopes
	// and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
	MicrosoftAccountOAuthScopes []*string `json:"microsoftAccountOAuthScopes,omitempty"`

	// The RuntimeVersion of the Authentication / Authorization feature in use for the current app. The setting in this value
	// can control the behavior of certain features in the Authentication /
	// Authorization module.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`

	// The number of hours after session token expiration that a session token can be used to call the token refresh API. The
	// default is 72 hours.
	TokenRefreshExtensionHours *float64 `json:"tokenRefreshExtensionHours,omitempty"`

	// true to durably store platform-specific security tokens that are obtained during login flows; otherwise, false. The default
	// is false.
	TokenStoreEnabled *bool `json:"tokenStoreEnabled,omitempty"`

	// The OAuth 1.0a consumer key of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerKey *string `json:"twitterConsumerKey,omitempty"`

	// The OAuth 1.0a consumer secret of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerSecret *string `json:"twitterConsumerSecret,omitempty"`

	// The action to take when an unauthenticated client attempts to access the app.
	UnauthenticatedClientAction *UnauthenticatedClientAction `json:"unauthenticatedClientAction,omitempty"`

	// Gets a value indicating whether the issuer should be a valid HTTPS url and be validated as such.
	ValidateIssuer *bool `json:"validateIssuer,omitempty"`
}

// SiteCloneability - Represents whether or not an app is cloneable.
type SiteCloneability struct {
	// List of blocking application characteristics.
	BlockingCharacteristics []*SiteCloneabilityCriterion `json:"blockingCharacteristics,omitempty"`

	// List of features enabled on app that prevent cloning.
	BlockingFeatures []*SiteCloneabilityCriterion `json:"blockingFeatures,omitempty"`

	// Name of app.
	Result *CloneAbilityResult `json:"result,omitempty"`

	// List of features enabled on app that are non-blocking but cannot be cloned. The app can still be cloned but the features
	// in this list will not be set up on cloned app.
	UnsupportedFeatures []*SiteCloneabilityCriterion `json:"unsupportedFeatures,omitempty"`
}

// SiteCloneabilityCriterion - An app cloneability criterion.
type SiteCloneabilityCriterion struct {
	// Description of criterion.
	Description *string `json:"description,omitempty"`

	// Name of criterion.
	Name *string `json:"name,omitempty"`
}

// SiteConfig - Configuration of an App Service app.
type SiteConfig struct {
	// Information about the formal API definition for the app.
	APIDefinition *APIDefinitionInfo `json:"apiDefinition,omitempty"`

	// true if Always On is enabled; otherwise, false.
	AlwaysOn *bool `json:"alwaysOn,omitempty"`

	// App command line to launch.
	AppCommandLine *string `json:"appCommandLine,omitempty"`

	// Application settings.
	AppSettings []*NameValuePair `json:"appSettings,omitempty"`

	// true if Auto Heal is enabled; otherwise, false.
	AutoHealEnabled *bool `json:"autoHealEnabled,omitempty"`

	// Auto Heal rules.
	AutoHealRules *AutoHealRules `json:"autoHealRules,omitempty"`

	// Auto-swap slot name.
	AutoSwapSlotName *string `json:"autoSwapSlotName,omitempty"`

	// User-provided Azure storage accounts.
	AzureStorageAccounts map[string]*AzureStorageInfoValue `json:"azureStorageAccounts,omitempty"`

	// Connection strings.
	ConnectionStrings []*ConnStringInfo `json:"connectionStrings,omitempty"`

	// Cross-Origin Resource Sharing (CORS) settings.
	Cors *CorsSettings `json:"cors,omitempty"`

	// Default documents.
	DefaultDocuments []*string `json:"defaultDocuments,omitempty"`

	// true if detailed error logging is enabled; otherwise, false.
	DetailedErrorLoggingEnabled *bool `json:"detailedErrorLoggingEnabled,omitempty"`

	// Document root.
	DocumentRoot *string `json:"documentRoot,omitempty"`

	// This is work around for polymorphic types.
	Experiments *Experiments `json:"experiments,omitempty"`

	// State of FTP / FTPS service
	FtpsState *FtpsState `json:"ftpsState,omitempty"`

	// true if HTTP logging is enabled; otherwise, false.
	HTTPLoggingEnabled *bool `json:"httpLoggingEnabled,omitempty"`

	// Handler mappings.
	HandlerMappings []*HandlerMapping `json:"handlerMappings,omitempty"`

	// Http20Enabled: configures a web site to allow clients to connect over http2.0
	Http20Enabled *bool `json:"http20Enabled,omitempty"`

	// IP security restrictions for main.
	IPSecurityRestrictions []*IPSecurityRestriction `json:"ipSecurityRestrictions,omitempty"`

	// Java container.
	JavaContainer *string `json:"javaContainer,omitempty"`

	// Java container version.
	JavaContainerVersion *string `json:"javaContainerVersion,omitempty"`

	// Java version.
	JavaVersion *string `json:"javaVersion,omitempty"`

	// Site limits.
	Limits *SiteLimits `json:"limits,omitempty"`

	// Linux App Framework and version
	LinuxFxVersion *string `json:"linuxFxVersion,omitempty"`

	// Site load balancing.
	LoadBalancing *SiteLoadBalancing `json:"loadBalancing,omitempty"`

	// true to enable local MySQL; otherwise, false.
	LocalMySQLEnabled *bool `json:"localMySqlEnabled,omitempty"`

	// HTTP logs directory size limit.
	LogsDirectorySizeLimit *int32 `json:"logsDirectorySizeLimit,omitempty"`

	// Managed pipeline mode.
	ManagedPipelineMode *ManagedPipelineMode `json:"managedPipelineMode,omitempty"`

	// Managed Service Identity Id
	ManagedServiceIdentityID *int32 `json:"managedServiceIdentityId,omitempty"`

	// MinTlsVersion: configures the minimum version of TLS required for SSL requests
	MinTLSVersion *SupportedTLSVersions `json:"minTlsVersion,omitempty"`

	// .NET Framework version.
	NetFrameworkVersion *string `json:"netFrameworkVersion,omitempty"`

	// Version of Node.js.
	NodeVersion *string `json:"nodeVersion,omitempty"`

	// Number of workers.
	NumberOfWorkers *int32 `json:"numberOfWorkers,omitempty"`

	// Version of PHP.
	PhpVersion *string `json:"phpVersion,omitempty"`

	// Publishing user name.
	PublishingUsername *string `json:"publishingUsername,omitempty"`

	// Push endpoint settings.
	Push *PushSettings `json:"push,omitempty"`

	// Version of Python.
	PythonVersion *string `json:"pythonVersion,omitempty"`

	// true if remote debugging is enabled; otherwise, false.
	RemoteDebuggingEnabled *bool `json:"remoteDebuggingEnabled,omitempty"`

	// Remote debugging version.
	RemoteDebuggingVersion *string `json:"remoteDebuggingVersion,omitempty"`

	// true if request tracing is enabled; otherwise, false.
	RequestTracingEnabled *bool `json:"requestTracingEnabled,omitempty"`

	// Request tracing expiration time.
	RequestTracingExpirationTime *time.Time `json:"requestTracingExpirationTime,omitempty"`

	// Number of reserved instances. This setting only applies to the Consumption Plan
	ReservedInstanceCount *int32 `json:"reservedInstanceCount,omitempty"`

	// IP security restrictions for scm.
	ScmIPSecurityRestrictions []*IPSecurityRestriction `json:"scmIpSecurityRestrictions,omitempty"`

	// IP security restrictions for scm to use main.
	ScmIPSecurityRestrictionsUseMain *bool `json:"scmIpSecurityRestrictionsUseMain,omitempty"`

	// SCM type.
	ScmType *ScmType `json:"scmType,omitempty"`

	// Tracing options.
	TracingOptions *string `json:"tracingOptions,omitempty"`

	// true to use 32-bit worker process; otherwise, false.
	Use32BitWorkerProcess *bool `json:"use32BitWorkerProcess,omitempty"`

	// Virtual applications.
	VirtualApplications []*VirtualApplication `json:"virtualApplications,omitempty"`

	// Virtual Network name.
	VnetName *string `json:"vnetName,omitempty"`

	// true if WebSocket is enabled; otherwise, false.
	WebSocketsEnabled *bool `json:"webSocketsEnabled,omitempty"`

	// Xenon App Framework and version
	WindowsFxVersion *string `json:"windowsFxVersion,omitempty"`

	// Explicit Managed Service Identity Id
	XManagedServiceIdentityID *int32 `json:"xManagedServiceIdentityId,omitempty"`

	// READ-ONLY; Site MachineKey.
	MachineKey *SiteMachineKey `json:"machineKey,omitempty" azure:"ro"`
}

// SiteConfigResource - Web app configuration ARM resource.
type SiteConfigResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *SiteConfig `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteConfigResourceCollection - Collection of site configurations.
type SiteConfigResourceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteConfigResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SiteConfigurationSnapshotInfo - A snapshot of a web app configuration.
type SiteConfigurationSnapshotInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteConfigurationSnapshotInfo resource specific properties
	Properties *SiteConfigurationSnapshotInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteConfigurationSnapshotInfoCollection - Collection of metadata for the app configuration snapshots that can be restored.
type SiteConfigurationSnapshotInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteConfigurationSnapshotInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SiteConfigurationSnapshotInfoProperties - SiteConfigurationSnapshotInfo resource specific properties
type SiteConfigurationSnapshotInfoProperties struct {
	// READ-ONLY; The id of the snapshot
	SnapshotID *int32 `json:"snapshotId,omitempty" azure:"ro"`

	// READ-ONLY; The time the snapshot was taken.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// SiteExtensionInfo - Site Extension Information.
type SiteExtensionInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteExtensionInfo resource specific properties
	Properties *SiteExtensionInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteExtensionInfoCollection - Collection of Kudu site extension information elements.
type SiteExtensionInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteExtensionInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SiteExtensionInfoProperties - SiteExtensionInfo resource specific properties
type SiteExtensionInfoProperties struct {
	// List of authors.
	Authors []*string `json:"authors,omitempty"`

	// Site Extension comment.
	Comment *string `json:"comment,omitempty"`

	// Detailed description.
	Description *string `json:"description,omitempty"`

	// Count of downloads.
	DownloadCount *int32 `json:"download_count,omitempty"`

	// Site extension ID.
	ExtensionID *string `json:"extension_id,omitempty"`

	// Site extension type.
	ExtensionType *SiteExtensionType `json:"extension_type,omitempty"`

	// Extension URL.
	ExtensionURL *string `json:"extension_url,omitempty"`

	// Feed URL.
	FeedURL *string `json:"feed_url,omitempty"`

	// Icon URL.
	IconURL *string `json:"icon_url,omitempty"`

	// Installed timestamp.
	InstalledDateTime *time.Time `json:"installed_date_time,omitempty"`

	// Installer command line parameters.
	InstallerCommandLineParams *string `json:"installer_command_line_params,omitempty"`

	// License URL.
	LicenseURL *string `json:"license_url,omitempty"`

	// true if the local version is the latest version; false otherwise.
	LocalIsLatestVersion *bool `json:"local_is_latest_version,omitempty"`

	// Local path.
	LocalPath *string `json:"local_path,omitempty"`

	// Project URL.
	ProjectURL *string `json:"project_url,omitempty"`

	// Provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Published timestamp.
	PublishedDateTime *time.Time `json:"published_date_time,omitempty"`

	// Summary description.
	Summary *string `json:"summary,omitempty"`
	Title   *string `json:"title,omitempty"`

	// Version information.
	Version *string `json:"version,omitempty"`
}

// SiteInstance - Instance of an app.
type SiteInstance struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteInstance resource specific properties
	Properties *SiteInstanceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteInstanceProperties - SiteInstance resource specific properties
type SiteInstanceProperties struct {
	// READ-ONLY; Name of instance.
	SiteInstanceName *string `json:"siteInstanceName,omitempty" azure:"ro"`
}

// SiteLimits - Metric limits set on an app.
type SiteLimits struct {
	// Maximum allowed disk size usage in MB.
	MaxDiskSizeInMb *int64 `json:"maxDiskSizeInMb,omitempty"`

	// Maximum allowed memory usage in MB.
	MaxMemoryInMb *int64 `json:"maxMemoryInMb,omitempty"`

	// Maximum allowed CPU usage percentage.
	MaxPercentageCPU *float64 `json:"maxPercentageCpu,omitempty"`
}

// SiteLogsConfig - Configuration of App Service site logs.
type SiteLogsConfig struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteLogsConfig resource specific properties
	Properties *SiteLogsConfigProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteLogsConfigProperties - SiteLogsConfig resource specific properties
type SiteLogsConfigProperties struct {
	// Application logs configuration.
	ApplicationLogs *ApplicationLogsConfig `json:"applicationLogs,omitempty"`

	// Detailed error messages configuration.
	DetailedErrorMessages *EnabledConfig `json:"detailedErrorMessages,omitempty"`

	// Failed requests tracing configuration.
	FailedRequestsTracing *EnabledConfig `json:"failedRequestsTracing,omitempty"`

	// HTTP logs configuration.
	HTTPLogs *HTTPLogsConfig `json:"httpLogs,omitempty"`
}

// SiteMachineKey - MachineKey of an app.
type SiteMachineKey struct {
	// Algorithm used for decryption.
	Decryption *string `json:"decryption,omitempty"`

	// Decryption key.
	DecryptionKey *string `json:"decryptionKey,omitempty"`

	// MachineKey validation.
	Validation *string `json:"validation,omitempty"`

	// Validation key.
	ValidationKey *string `json:"validationKey,omitempty"`
}

// SitePatchResource - ARM resource for a site.
type SitePatchResource struct {
	// Managed service identity.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SitePatchResource resource specific properties
	Properties *SitePatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SitePatchResourceProperties - SitePatchResource resource specific properties
type SitePatchResourceProperties struct {
	// true to enable client affinity; false to stop sending session affinity cookies, which route client requests in the same
	// session to the same instance. Default is true.
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`

	// true to enable client certificate authentication (TLS mutual authentication); otherwise, false. Default is false.
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`

	// client certificate authentication comma-separated exclusion paths
	ClientCertExclusionPaths *string `json:"clientCertExclusionPaths,omitempty"`

	// If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`

	// Size of the function container.
	ContainerSize *int32 `json:"containerSize,omitempty"`

	// Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32 `json:"dailyMemoryTimeQuota,omitempty"`

	// true if the app is enabled; otherwise, false. Setting this value to false disables the app (takes the app offline).
	Enabled *bool `json:"enabled,omitempty"`

	// GeoDistributions for this site
	GeoDistributions []*GeoDistribution `json:"geoDistributions,omitempty"`

	// HttpsOnly: configures a web site to accept only https requests. Issues redirect for http requests
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`

	// Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSSLStates []*HostNameSSLState `json:"hostNameSslStates,omitempty"`

	// true to disable the public hostnames of the app; otherwise, false. If true, the app is only accessible via API management
	// process.
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`

	// App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`

	// Hyper-V sandbox.
	HyperV *bool `json:"hyperV,omitempty"`

	// Obsolete: Hyper-V sandbox.
	IsXenon *bool `json:"isXenon,omitempty"`

	// Site redundancy mode
	RedundancyMode *RedundancyMode `json:"redundancyMode,omitempty"`

	// true if reserved; otherwise, false.
	Reserved *bool `json:"reserved,omitempty"`

	// true to stop SCM (KUDU) site when the app is stopped; otherwise, false. The default is false.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`

	// Configuration of the app.
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`

	// READ-ONLY; Management information availability state for the app.
	AvailabilityState *SiteAvailabilityState `json:"availabilityState,omitempty" azure:"ro"`

	// READ-ONLY; Default hostname of the app. Read-only.
	DefaultHostName *string `json:"defaultHostName,omitempty" azure:"ro"`

	// READ-ONLY; Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise, the app
	// is not served on those hostnames.
	EnabledHostNames []*string `json:"enabledHostNames,omitempty" azure:"ro"`

	// READ-ONLY; Hostnames associated with the app.
	HostNames []*string `json:"hostNames,omitempty" azure:"ro"`

	// READ-ONLY; Specifies an operation id if this site has a pending operation.
	InProgressOperationID *string `json:"inProgressOperationId,omitempty" azure:"ro"`

	// READ-ONLY; true if the app is a default container; otherwise, false.
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty" azure:"ro"`

	// READ-ONLY; Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUTC *time.Time `json:"lastModifiedTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of workers. This only applies to Functions container.
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants
	// that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all
	// tenants. Read-only.
	PossibleOutboundIPAddresses *string `json:"possibleOutboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY; Name of the repository site.
	RepositorySiteName *string `json:"repositorySiteName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus `json:"slotSwapStatus,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the app.
	State *string `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; App suspended till in case memory-time quota is exceeded.
	SuspendedTill *time.Time `json:"suspendedTill,omitempty" azure:"ro"`

	// READ-ONLY; Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty" azure:"ro"`

	// READ-ONLY; Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames []*string `json:"trafficManagerHostNames,omitempty" azure:"ro"`

	// READ-ONLY; State indicating whether the app has exceeded its quota usage. Read-only.
	UsageState *UsageState `json:"usageState,omitempty" azure:"ro"`
}

// SitePhpErrorLogFlag - Used for getting PHP error logging flag.
type SitePhpErrorLogFlag struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SitePhpErrorLogFlag resource specific properties
	Properties *SitePhpErrorLogFlagProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SitePhpErrorLogFlagProperties - SitePhpErrorLogFlag resource specific properties
type SitePhpErrorLogFlagProperties struct {
	// Local log_errors setting.
	LocalLogErrors *string `json:"localLogErrors,omitempty"`

	// Local logerrorsmax_len setting.
	LocalLogErrorsMaxLength *string `json:"localLogErrorsMaxLength,omitempty"`

	// Master log_errors setting.
	MasterLogErrors *string `json:"masterLogErrors,omitempty"`

	// Master logerrorsmax_len setting.
	MasterLogErrorsMaxLength *string `json:"masterLogErrorsMaxLength,omitempty"`
}

// SiteProperties - Site resource specific properties
type SiteProperties struct {
	// true to enable client affinity; false to stop sending session affinity cookies, which route client requests in the same
	// session to the same instance. Default is true.
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`

	// true to enable client certificate authentication (TLS mutual authentication); otherwise, false. Default is false.
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`

	// client certificate authentication comma-separated exclusion paths
	ClientCertExclusionPaths *string `json:"clientCertExclusionPaths,omitempty"`

	// If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`

	// Size of the function container.
	ContainerSize *int32 `json:"containerSize,omitempty"`

	// Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32 `json:"dailyMemoryTimeQuota,omitempty"`

	// true if the app is enabled; otherwise, false. Setting this value to false disables the app (takes the app offline).
	Enabled *bool `json:"enabled,omitempty"`

	// GeoDistributions for this site
	GeoDistributions []*GeoDistribution `json:"geoDistributions,omitempty"`

	// HttpsOnly: configures a web site to accept only https requests. Issues redirect for http requests
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`

	// Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSSLStates []*HostNameSSLState `json:"hostNameSslStates,omitempty"`

	// true to disable the public hostnames of the app; otherwise, false. If true, the app is only accessible via API management
	// process.
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`

	// App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`

	// Hyper-V sandbox.
	HyperV *bool `json:"hyperV,omitempty"`

	// Obsolete: Hyper-V sandbox.
	IsXenon *bool `json:"isXenon,omitempty"`

	// Site redundancy mode
	RedundancyMode *RedundancyMode `json:"redundancyMode,omitempty"`

	// true if reserved; otherwise, false.
	Reserved *bool `json:"reserved,omitempty"`

	// true to stop SCM (KUDU) site when the app is stopped; otherwise, false. The default is false.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`

	// Configuration of the app.
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`

	// READ-ONLY; Management information availability state for the app.
	AvailabilityState *SiteAvailabilityState `json:"availabilityState,omitempty" azure:"ro"`

	// READ-ONLY; Default hostname of the app. Read-only.
	DefaultHostName *string `json:"defaultHostName,omitempty" azure:"ro"`

	// READ-ONLY; Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise, the app
	// is not served on those hostnames.
	EnabledHostNames []*string `json:"enabledHostNames,omitempty" azure:"ro"`

	// READ-ONLY; Hostnames associated with the app.
	HostNames []*string `json:"hostNames,omitempty" azure:"ro"`

	// READ-ONLY; Specifies an operation id if this site has a pending operation.
	InProgressOperationID *string `json:"inProgressOperationId,omitempty" azure:"ro"`

	// READ-ONLY; true if the app is a default container; otherwise, false.
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty" azure:"ro"`

	// READ-ONLY; Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUTC *time.Time `json:"lastModifiedTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of workers. This only applies to Functions container.
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants
	// that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all
	// tenants. Read-only.
	PossibleOutboundIPAddresses *string `json:"possibleOutboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY; Name of the repository site.
	RepositorySiteName *string `json:"repositorySiteName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus `json:"slotSwapStatus,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the app.
	State *string `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; App suspended till in case memory-time quota is exceeded.
	SuspendedTill *time.Time `json:"suspendedTill,omitempty" azure:"ro"`

	// READ-ONLY; Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty" azure:"ro"`

	// READ-ONLY; Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames []*string `json:"trafficManagerHostNames,omitempty" azure:"ro"`

	// READ-ONLY; State indicating whether the app has exceeded its quota usage. Read-only.
	UsageState *UsageState `json:"usageState,omitempty" azure:"ro"`
}

// SiteSourceControl - Source control configuration for an app.
type SiteSourceControl struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteSourceControl resource specific properties
	Properties *SiteSourceControlProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteSourceControlProperties - SiteSourceControl resource specific properties
type SiteSourceControlProperties struct {
	// Name of branch to use for deployment.
	Branch *string `json:"branch,omitempty"`

	// true to enable deployment rollback; otherwise, false.
	DeploymentRollbackEnabled *bool `json:"deploymentRollbackEnabled,omitempty"`

	// true to limit to manual integration; false to enable continuous integration (which configures webhooks into online repos
	// like GitHub).
	IsManualIntegration *bool `json:"isManualIntegration,omitempty"`

	// true for a Mercurial repository; false for a Git repository.
	IsMercurial *bool `json:"isMercurial,omitempty"`

	// Repository or source control URL.
	RepoURL *string `json:"repoUrl,omitempty"`
}

// SlotConfigNames - Names for connection strings, application settings, and external Azure storage account configuration
// identifiers to be marked as sticky to the deployment slot and not moved during a swap operation.
// This is valid for all deployment slots in an app.
type SlotConfigNames struct {
	// List of application settings names.
	AppSettingNames []*string `json:"appSettingNames,omitempty"`

	// List of external Azure storage account identifiers.
	AzureStorageConfigNames []*string `json:"azureStorageConfigNames,omitempty"`

	// List of connection string names.
	ConnectionStringNames []*string `json:"connectionStringNames,omitempty"`
}

// SlotConfigNamesResource - Slot Config names azure resource.
type SlotConfigNamesResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *SlotConfigNames `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SlotDifference - A setting difference between two deployment slots of an app.
type SlotDifference struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SlotDifference resource specific properties
	Properties *SlotDifferenceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SlotDifferenceCollection - Collection of slot differences.
type SlotDifferenceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SlotDifference `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SlotDifferenceProperties - SlotDifference resource specific properties
type SlotDifferenceProperties struct {
	// READ-ONLY; Description of the setting difference.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Rule that describes how to process the setting difference during a slot swap.
	DiffRule *string `json:"diffRule,omitempty" azure:"ro"`

	// READ-ONLY; Level of the difference: Information, Warning or Error.
	Level *string `json:"level,omitempty" azure:"ro"`

	// READ-ONLY; Name of the setting.
	SettingName *string `json:"settingName,omitempty" azure:"ro"`

	// READ-ONLY; The type of the setting: General, AppSetting or ConnectionString.
	SettingType *string `json:"settingType,omitempty" azure:"ro"`

	// READ-ONLY; Value of the setting in the current slot.
	ValueInCurrentSlot *string `json:"valueInCurrentSlot,omitempty" azure:"ro"`

	// READ-ONLY; Value of the setting in the target slot.
	ValueInTargetSlot *string `json:"valueInTargetSlot,omitempty" azure:"ro"`
}

// SlotSwapStatus - The status of the last successful slot swap operation.
type SlotSwapStatus struct {
	// READ-ONLY; The destination slot of the last swap operation.
	DestinationSlotName *string `json:"destinationSlotName,omitempty" azure:"ro"`

	// READ-ONLY; The source slot of the last swap operation.
	SourceSlotName *string `json:"sourceSlotName,omitempty" azure:"ro"`

	// READ-ONLY; The time the last successful slot swap completed.
	TimestampUTC *time.Time `json:"timestampUtc,omitempty" azure:"ro"`
}

// SlowRequestsBasedTrigger - Trigger based on request execution time.
type SlowRequestsBasedTrigger struct {
	// Request Count.
	Count *int32 `json:"count,omitempty"`

	// Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`

	// Time taken.
	TimeTaken *string `json:"timeTaken,omitempty"`
}

// Snapshot - A snapshot of an app.
type Snapshot struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Snapshot resource specific properties
	Properties *SnapshotProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotCollection - Collection of snapshots which can be used to revert an app to a previous time.
type SnapshotCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Snapshot `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SnapshotProperties - Snapshot resource specific properties
type SnapshotProperties struct {
	// READ-ONLY; The time the snapshot was taken.
	Time *string `json:"time,omitempty" azure:"ro"`
}

// SnapshotRecoverySource - Specifies the web app that snapshot contents will be retrieved from.
type SnapshotRecoverySource struct {
	// ARM resource ID of the source app. /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
	// for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for
	// other slots.
	ID *string `json:"id,omitempty"`

	// Geographical location of the source web app, e.g. SouthEastAsia, SouthCentralUS
	Location *string `json:"location,omitempty"`
}

// SnapshotRestoreRequest - Details about app recovery operation.
type SnapshotRestoreRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SnapshotRestoreRequest resource specific properties
	Properties *SnapshotRestoreRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotRestoreRequestProperties - SnapshotRestoreRequest resource specific properties
type SnapshotRestoreRequestProperties struct {
	// REQUIRED; If true the restore operation can overwrite source app; otherwise, false.
	Overwrite *bool `json:"overwrite,omitempty"`

	// If true, custom hostname conflicts will be ignored when recovering to a target web app. This setting is only necessary
	// when RecoverConfiguration is enabled.
	IgnoreConflictingHostNames *bool `json:"ignoreConflictingHostNames,omitempty"`

	// If true, site configuration, in addition to content, will be reverted.
	RecoverConfiguration *bool `json:"recoverConfiguration,omitempty"`

	// Optional. Specifies the web app that snapshot contents will be retrieved from. If empty, the targeted web app will be used
	// as the source.
	RecoverySource *SnapshotRecoverySource `json:"recoverySource,omitempty"`

	// Point in time in which the app restore should be done, formatted as a DateTime string.
	SnapshotTime *string `json:"snapshotTime,omitempty"`

	// If true, the snapshot is retrieved from DRSecondary endpoint.
	UseDRSecondary *bool `json:"useDRSecondary,omitempty"`
}

// SourceControl - The source control OAuth token.
type SourceControl struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SourceControl resource specific properties
	Properties *SourceControlProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SourceControlCollection - Collection of source controls.
type SourceControlCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SourceControl `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SourceControlProperties - SourceControl resource specific properties
type SourceControlProperties struct {
	// OAuth token expiration.
	ExpirationTime *time.Time `json:"expirationTime,omitempty"`

	// OAuth refresh token.
	RefreshToken *string `json:"refreshToken,omitempty"`

	// OAuth access token.
	Token *string `json:"token,omitempty"`

	// OAuth access token secret.
	TokenSecret *string `json:"tokenSecret,omitempty"`
}

// StackMajorVersion - Application stack major version.
type StackMajorVersion struct {
	// true if this supports Application Insights; otherwise, false.
	ApplicationInsights *bool `json:"applicationInsights,omitempty"`

	// Application stack major version (display only).
	DisplayVersion *string `json:"displayVersion,omitempty"`

	// true if this is the default major version; otherwise, false.
	IsDefault *bool `json:"isDefault,omitempty"`

	// Minor versions associated with the major version.
	MinorVersions []*StackMinorVersion `json:"minorVersions,omitempty"`

	// Application stack major version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
}

// StackMinorVersion - Application stack minor version.
type StackMinorVersion struct {
	// Application stack minor version (display only).
	DisplayVersion *string `json:"displayVersion,omitempty"`

	// true if this is the default minor version; otherwise, false.
	IsDefault *bool `json:"isDefault,omitempty"`

	// true if this supports Remote Debugging, otherwise false.
	IsRemoteDebuggingEnabled *bool `json:"isRemoteDebuggingEnabled,omitempty"`

	// Application stack minor version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
}

// StampCapacity - Stamp capacity information.
type StampCapacity struct {
	// Available capacity (# of machines, bytes of storage etc…).
	AvailableCapacity *int64 `json:"availableCapacity,omitempty"`

	// Shared/dedicated workers.
	ComputeMode *ComputeModeOptions `json:"computeMode,omitempty"`

	// If true, it includes basic apps. Basic apps are not used for capacity allocation.
	ExcludeFromCapacityAllocation *bool `json:"excludeFromCapacityAllocation,omitempty"`

	// true if capacity is applicable for all apps; otherwise, false.
	IsApplicableForAllComputeModes *bool `json:"isApplicableForAllComputeModes,omitempty"`

	// Is this a linux stamp capacity
	IsLinux *bool `json:"isLinux,omitempty"`

	// Name of the stamp.
	Name *string `json:"name,omitempty"`

	// Shared or Dedicated.
	SiteMode *string `json:"siteMode,omitempty"`

	// Total capacity (# of machines, bytes of storage etc…).
	TotalCapacity *int64 `json:"totalCapacity,omitempty"`

	// Name of the unit.
	Unit *string `json:"unit,omitempty"`

	// Size of the machines.
	WorkerSize *WorkerSizeOptions `json:"workerSize,omitempty"`

	// Size ID of machines: 0 - Small 1 - Medium 2 - Large
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`
}

// StatusCodesBasedTrigger - Trigger based on status code.
type StatusCodesBasedTrigger struct {
	// Request Count.
	Count *int32 `json:"count,omitempty"`

	// HTTP status code.
	Status *int32 `json:"status,omitempty"`

	// Request Sub Status.
	SubStatus *int32 `json:"subStatus,omitempty"`

	// Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`

	// Win32 error code.
	Win32Status *int32 `json:"win32Status,omitempty"`
}

// StorageMigrationOptions - Options for app content migration.
type StorageMigrationOptions struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StorageMigrationOptions resource specific properties
	Properties *StorageMigrationOptionsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageMigrationOptionsProperties - StorageMigrationOptions resource specific properties
type StorageMigrationOptionsProperties struct {
	// REQUIRED; AzureFiles connection string.
	AzurefilesConnectionString *string `json:"azurefilesConnectionString,omitempty"`

	// REQUIRED; AzureFiles share.
	AzurefilesShare *string `json:"azurefilesShare,omitempty"`

	// true if the app should be read only during copy operation; otherwise, false.
	BlockWriteAccessToSite *bool `json:"blockWriteAccessToSite,omitempty"`

	// trueif the app should be switched over; otherwise, false.
	SwitchSiteAfterMigration *bool `json:"switchSiteAfterMigration,omitempty"`
}

// StorageMigrationResponse - Response for a migration of app content request.
type StorageMigrationResponse struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StorageMigrationResponse resource specific properties
	Properties *StorageMigrationResponseProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageMigrationResponseProperties - StorageMigrationResponse resource specific properties
type StorageMigrationResponseProperties struct {
	// READ-ONLY; When server starts the migration process, it will return an operation ID identifying that particular migration
	// operation.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`
}

// StringDictionary - String dictionary resource.
type StringDictionary struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Settings.
	Properties map[string]*string `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SwiftVirtualNetwork - Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network
// integration.
type SwiftVirtualNetwork struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SwiftVirtualNetwork resource specific properties
	Properties *SwiftVirtualNetworkProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SwiftVirtualNetworkProperties - SwiftVirtualNetwork resource specific properties
type SwiftVirtualNetworkProperties struct {
	// The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation
	// to Microsoft.Web/serverFarms defined first.
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`

	// A flag that specifies if the scale unit this Web App is on supports Swift integration.
	SwiftSupported *bool `json:"swiftSupported,omitempty"`
}

// TriggeredJobHistory - Triggered Web Job History. List of Triggered Web Job Run Information elements.
type TriggeredJobHistory struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// TriggeredJobHistory resource specific properties
	Properties *TriggeredJobHistoryProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TriggeredJobHistoryCollection - Collection of Kudu continuous web job information elements.
type TriggeredJobHistoryCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TriggeredJobHistory `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TriggeredJobHistoryProperties - TriggeredJobHistory resource specific properties
type TriggeredJobHistoryProperties struct {
	// List of triggered web job runs.
	Runs []*TriggeredJobRun `json:"runs,omitempty"`
}

// TriggeredJobRun - Triggered Web Job Run Information.
type TriggeredJobRun struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// TriggeredJobRun resource specific properties
	Properties *TriggeredJobRunProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TriggeredJobRunProperties - TriggeredJobRun resource specific properties
type TriggeredJobRunProperties struct {
	// Job duration.
	Duration *string `json:"duration,omitempty"`

	// End time.
	EndTime *time.Time `json:"end_time,omitempty"`

	// Error URL.
	ErrorURL *string `json:"error_url,omitempty"`

	// Job name.
	JobName *string `json:"job_name,omitempty"`

	// Output URL.
	OutputURL *string `json:"output_url,omitempty"`

	// Start time.
	StartTime *time.Time `json:"start_time,omitempty"`

	// Job status.
	Status *TriggeredWebJobStatus `json:"status,omitempty"`

	// Job trigger.
	Trigger *string `json:"trigger,omitempty"`

	// Job URL.
	URL *string `json:"url,omitempty"`

	// Job ID.
	WebJobID *string `json:"web_job_id,omitempty"`

	// Job name.
	WebJobName *string `json:"web_job_name,omitempty"`
}

// TriggeredWebJob - Triggered Web Job Information.
type TriggeredWebJob struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// TriggeredWebJob resource specific properties
	Properties *TriggeredWebJobProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TriggeredWebJobCollection - Collection of Kudu continuous web job information elements.
type TriggeredWebJobCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TriggeredWebJob `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TriggeredWebJobProperties - TriggeredWebJob resource specific properties
type TriggeredWebJobProperties struct {
	// Error information.
	Error *string `json:"error,omitempty"`

	// Extra Info URL.
	ExtraInfoURL *string `json:"extra_info_url,omitempty"`

	// History URL.
	HistoryURL *string `json:"history_url,omitempty"`

	// Latest job run information.
	LatestRun *TriggeredJobRun `json:"latest_run,omitempty"`

	// Run command.
	RunCommand *string `json:"run_command,omitempty"`

	// Scheduler Logs URL.
	SchedulerLogsURL *string `json:"scheduler_logs_url,omitempty"`

	// Job settings.
	Settings map[string]any `json:"settings,omitempty"`

	// Job URL.
	URL *string `json:"url,omitempty"`

	// Using SDK?
	UsingSdk *bool `json:"using_sdk,omitempty"`

	// Job type.
	WebJobType *WebJobType `json:"web_job_type,omitempty"`
}

// User credentials used for publishing activity.
type User struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// User resource specific properties
	Properties *UserProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserProperties - User resource specific properties
type UserProperties struct {
	// REQUIRED; Username used for publishing.
	PublishingUserName *string `json:"publishingUserName,omitempty"`

	// Password used for publishing.
	PublishingPassword *string `json:"publishingPassword,omitempty"`

	// Password hash used for publishing.
	PublishingPasswordHash *string `json:"publishingPasswordHash,omitempty"`

	// Password hash salt used for publishing.
	PublishingPasswordHashSalt *string `json:"publishingPasswordHashSalt,omitempty"`

	// Url of SCM site.
	ScmURI *string `json:"scmUri,omitempty"`
}

// ValidateContainerSettingsRequest - Container settings validation request context
type ValidateContainerSettingsRequest struct {
	// Base URL of the container registry
	BaseURL *string `json:"baseUrl,omitempty"`

	// Password for to access the container registry
	Password *string `json:"password,omitempty"`

	// Platform (windows or linux)
	Platform *string `json:"platform,omitempty"`

	// Repository name (image name)
	Repository *string `json:"repository,omitempty"`

	// Image tag
	Tag *string `json:"tag,omitempty"`

	// Username for to access the container registry
	Username *string `json:"username,omitempty"`
}

// ValidateProperties - App properties used for validation.
type ValidateProperties struct {
	// Target capacity of the App Service plan (number of VMs).
	Capacity *int32 `json:"capacity,omitempty"`

	// Name of App Service Environment where app or App Service plan should be created.
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`

	// true if App Service plan is for Spot instances; otherwise, false.
	IsSpot *bool `json:"isSpot,omitempty"`

	// true if App Service plan is running as a windows container
	IsXenon *bool `json:"isXenon,omitempty"`

	// true if App Service plan is for Linux workers; otherwise, false.
	NeedLinuxWorkers *bool `json:"needLinuxWorkers,omitempty"`

	// Name of the target SKU for the App Service plan.
	SKUName *string `json:"skuName,omitempty"`

	// ARM resource ID of an App Service plan that would host the app.
	ServerFarmID *string `json:"serverFarmId,omitempty"`
}

// ValidateRequest - Resource validation request content.
type ValidateRequest struct {
	// REQUIRED; Expected location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource name to verify.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Properties of the resource to validate.
	Properties *ValidateProperties `json:"properties,omitempty"`

	// REQUIRED; Resource type used for verification.
	Type *ValidateResourceTypes `json:"type,omitempty"`
}

// ValidateResponse - Describes the result of resource validation.
type ValidateResponse struct {
	// Error details for the case when validation fails.
	Error *ValidateResponseError `json:"error,omitempty"`

	// Result of validation.
	Status *string `json:"status,omitempty"`
}

// ValidateResponseError - Error details for when validation fails.
type ValidateResponseError struct {
	// Validation error code.
	Code *string `json:"code,omitempty"`

	// Validation error message.
	Message *string `json:"message,omitempty"`
}

// VirtualApplication - Virtual application in an app.
type VirtualApplication struct {
	// Physical path.
	PhysicalPath *string `json:"physicalPath,omitempty"`

	// true if preloading is enabled; otherwise, false.
	PreloadEnabled *bool `json:"preloadEnabled,omitempty"`

	// Virtual directories for virtual application.
	VirtualDirectories []*VirtualDirectory `json:"virtualDirectories,omitempty"`

	// Virtual path.
	VirtualPath *string `json:"virtualPath,omitempty"`
}

// VirtualDirectory - Directory for virtual application.
type VirtualDirectory struct {
	// Physical path.
	PhysicalPath *string `json:"physicalPath,omitempty"`

	// Path to virtual application.
	VirtualPath *string `json:"virtualPath,omitempty"`
}

// VirtualIPMapping - Virtual IP mapping.
type VirtualIPMapping struct {
	// Is virtual IP mapping in use.
	InUse *bool `json:"inUse,omitempty"`

	// Internal HTTP port.
	InternalHTTPPort *int32 `json:"internalHttpPort,omitempty"`

	// Internal HTTPS port.
	InternalHTTPSPort *int32 `json:"internalHttpsPort,omitempty"`

	// Virtual IP address.
	VirtualIP *string `json:"virtualIP,omitempty"`
}

// VirtualNetworkProfile - Specification for using a Virtual Network.
type VirtualNetworkProfile struct {
	// Resource id of the Virtual Network.
	ID *string `json:"id,omitempty"`

	// Subnet within the Virtual Network.
	Subnet *string `json:"subnet,omitempty"`

	// READ-ONLY; Name of the Virtual Network (read-only).
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the Virtual Network (read-only).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetGateway - The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN
// package.
type VnetGateway struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetGateway resource specific properties
	Properties *VnetGatewayProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetGatewayProperties - VnetGateway resource specific properties
type VnetGatewayProperties struct {
	// REQUIRED; The URI where the VPN package can be downloaded.
	VPNPackageURI *string `json:"vpnPackageUri,omitempty"`

	// The Virtual Network name.
	VnetName *string `json:"vnetName,omitempty"`
}

// VnetInfo - Virtual Network information contract.
type VnetInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetInfo resource specific properties
	Properties *VnetInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetInfoProperties - VnetInfo resource specific properties
type VnetInfoProperties struct {
	// A certificate file (.cer) blob containing the public key of the private key used to authenticate a Point-To-Site VPN connection.
	CertBlob *string `json:"certBlob,omitempty"`

	// DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
	DNSServers *string `json:"dnsServers,omitempty"`

	// Flag that is used to denote if this is VNET injection
	IsSwift *bool `json:"isSwift,omitempty"`

	// The Virtual Network's resource ID.
	VnetResourceID *string `json:"vnetResourceId,omitempty"`

	// READ-ONLY; The client certificate thumbprint.
	CertThumbprint *string `json:"certThumbprint,omitempty" azure:"ro"`

	// READ-ONLY; true if a resync is required; otherwise, false.
	ResyncRequired *bool `json:"resyncRequired,omitempty" azure:"ro"`

	// READ-ONLY; The routes that this Virtual Network connection uses.
	Routes []*VnetRoute `json:"routes,omitempty" azure:"ro"`
}

// VnetParameters - The required set of inputs to validate a VNET
type VnetParameters struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetParameters resource specific properties
	Properties *VnetParametersProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetParametersProperties - VnetParameters resource specific properties
type VnetParametersProperties struct {
	// The name of the VNET to be validated
	VnetName *string `json:"vnetName,omitempty"`

	// The Resource Group of the VNET to be validated
	VnetResourceGroup *string `json:"vnetResourceGroup,omitempty"`

	// The subnet name to be validated
	VnetSubnetName *string `json:"vnetSubnetName,omitempty"`
}

// VnetRoute - Virtual Network route contract used to pass routing information for a Virtual Network.
type VnetRoute struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetRoute resource specific properties
	Properties *VnetRouteProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetRouteProperties - VnetRoute resource specific properties
type VnetRouteProperties struct {
	// The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
	EndAddress *string `json:"endAddress,omitempty"`

	// The type of route this is: DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
	// INHERITED - Routes inherited from the real Virtual Network routes STATIC - Static
	// route set on the app only
	// These values will be used for syncing an app's routes with those from a Virtual Network.
	RouteType *RouteType `json:"routeType,omitempty"`

	// The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
	StartAddress *string `json:"startAddress,omitempty"`
}

// VnetValidationFailureDetails - A class that describes the reason for a validation failure.
type VnetValidationFailureDetails struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetValidationFailureDetails resource specific properties
	Properties *VnetValidationFailureDetailsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetValidationFailureDetailsProperties - VnetValidationFailureDetails resource specific properties
type VnetValidationFailureDetailsProperties struct {
	// A flag describing whether or not validation failed.
	Failed *bool `json:"failed,omitempty"`

	// A list of tests that failed in the validation.
	FailedTests []*VnetValidationTestFailure `json:"failedTests,omitempty"`
}

// VnetValidationTestFailure - A class that describes a test that failed during NSG and UDR validation.
type VnetValidationTestFailure struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetValidationTestFailure resource specific properties
	Properties *VnetValidationTestFailureProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetValidationTestFailureProperties - VnetValidationTestFailure resource specific properties
type VnetValidationTestFailureProperties struct {
	// The details of what caused the failure, e.g. the blocking rule name, etc.
	Details *string `json:"details,omitempty"`

	// The name of the test that failed.
	TestName *string `json:"testName,omitempty"`
}

// WebAppCollection - Collection of App Service apps.
type WebAppCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Site `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WebAppInstanceCollection - Collection of app instances.
type WebAppInstanceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteInstance `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WebAppsClientAddPremierAddOnOptions contains the optional parameters for the WebAppsClient.AddPremierAddOn method.
type WebAppsClientAddPremierAddOnOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientAddPremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.AddPremierAddOnSlot method.
type WebAppsClientAddPremierAddOnSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientAnalyzeCustomHostnameOptions contains the optional parameters for the WebAppsClient.AnalyzeCustomHostname
// method.
type WebAppsClientAnalyzeCustomHostnameOptions struct {
	// Custom hostname.
	HostName *string
}

// WebAppsClientAnalyzeCustomHostnameSlotOptions contains the optional parameters for the WebAppsClient.AnalyzeCustomHostnameSlot
// method.
type WebAppsClientAnalyzeCustomHostnameSlotOptions struct {
	// Custom hostname.
	HostName *string
}

// WebAppsClientApplySlotConfigToProductionOptions contains the optional parameters for the WebAppsClient.ApplySlotConfigToProduction
// method.
type WebAppsClientApplySlotConfigToProductionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientApplySlotConfigurationSlotOptions contains the optional parameters for the WebAppsClient.ApplySlotConfigurationSlot
// method.
type WebAppsClientApplySlotConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientBackupOptions contains the optional parameters for the WebAppsClient.Backup method.
type WebAppsClientBackupOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientBackupSlotOptions contains the optional parameters for the WebAppsClient.BackupSlot method.
type WebAppsClientBackupSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientBeginCreateFunctionOptions contains the optional parameters for the WebAppsClient.BeginCreateFunction method.
type WebAppsClientBeginCreateFunctionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateInstanceFunctionSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateInstanceFunctionSlot
// method.
type WebAppsClientBeginCreateInstanceFunctionSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateInstanceMSDeployOperationOptions contains the optional parameters for the WebAppsClient.BeginCreateInstanceMSDeployOperation
// method.
type WebAppsClientBeginCreateInstanceMSDeployOperationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateInstanceMSDeployOperationSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateInstanceMSDeployOperationSlot
// method.
type WebAppsClientBeginCreateInstanceMSDeployOperationSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateMSDeployOperationOptions contains the optional parameters for the WebAppsClient.BeginCreateMSDeployOperation
// method.
type WebAppsClientBeginCreateMSDeployOperationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateMSDeployOperationSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateMSDeployOperationSlot
// method.
type WebAppsClientBeginCreateMSDeployOperationSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateOrUpdateOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdate method.
type WebAppsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateOrUpdateSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdateSlot
// method.
type WebAppsClientBeginCreateOrUpdateSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateOrUpdateSourceControlOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdateSourceControl
// method.
type WebAppsClientBeginCreateOrUpdateSourceControlOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateOrUpdateSourceControlSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdateSourceControlSlot
// method.
type WebAppsClientBeginCreateOrUpdateSourceControlSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginInstallSiteExtensionOptions contains the optional parameters for the WebAppsClient.BeginInstallSiteExtension
// method.
type WebAppsClientBeginInstallSiteExtensionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginInstallSiteExtensionSlotOptions contains the optional parameters for the WebAppsClient.BeginInstallSiteExtensionSlot
// method.
type WebAppsClientBeginInstallSiteExtensionSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginListPublishingCredentialsOptions contains the optional parameters for the WebAppsClient.BeginListPublishingCredentials
// method.
type WebAppsClientBeginListPublishingCredentialsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginListPublishingCredentialsSlotOptions contains the optional parameters for the WebAppsClient.BeginListPublishingCredentialsSlot
// method.
type WebAppsClientBeginListPublishingCredentialsSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginMigrateMySQLOptions contains the optional parameters for the WebAppsClient.BeginMigrateMySQL method.
type WebAppsClientBeginMigrateMySQLOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginMigrateStorageOptions contains the optional parameters for the WebAppsClient.BeginMigrateStorage method.
type WebAppsClientBeginMigrateStorageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreFromBackupBlobOptions contains the optional parameters for the WebAppsClient.BeginRestoreFromBackupBlob
// method.
type WebAppsClientBeginRestoreFromBackupBlobOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreFromBackupBlobSlotOptions contains the optional parameters for the WebAppsClient.BeginRestoreFromBackupBlobSlot
// method.
type WebAppsClientBeginRestoreFromBackupBlobSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreFromDeletedAppOptions contains the optional parameters for the WebAppsClient.BeginRestoreFromDeletedApp
// method.
type WebAppsClientBeginRestoreFromDeletedAppOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreFromDeletedAppSlotOptions contains the optional parameters for the WebAppsClient.BeginRestoreFromDeletedAppSlot
// method.
type WebAppsClientBeginRestoreFromDeletedAppSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreOptions contains the optional parameters for the WebAppsClient.BeginRestore method.
type WebAppsClientBeginRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreSlotOptions contains the optional parameters for the WebAppsClient.BeginRestoreSlot method.
type WebAppsClientBeginRestoreSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreSnapshotOptions contains the optional parameters for the WebAppsClient.BeginRestoreSnapshot method.
type WebAppsClientBeginRestoreSnapshotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreSnapshotSlotOptions contains the optional parameters for the WebAppsClient.BeginRestoreSnapshotSlot
// method.
type WebAppsClientBeginRestoreSnapshotSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginStartNetworkTraceOptions contains the optional parameters for the WebAppsClient.BeginStartNetworkTrace
// method.
type WebAppsClientBeginStartNetworkTraceOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientBeginStartNetworkTraceSlotOptions contains the optional parameters for the WebAppsClient.BeginStartNetworkTraceSlot
// method.
type WebAppsClientBeginStartNetworkTraceSlotOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientBeginStartWebSiteNetworkTraceOperationOptions contains the optional parameters for the WebAppsClient.BeginStartWebSiteNetworkTraceOperation
// method.
type WebAppsClientBeginStartWebSiteNetworkTraceOperationOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientBeginStartWebSiteNetworkTraceOperationSlotOptions contains the optional parameters for the WebAppsClient.BeginStartWebSiteNetworkTraceOperationSlot
// method.
type WebAppsClientBeginStartWebSiteNetworkTraceOperationSlotOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientBeginSwapSlotOptions contains the optional parameters for the WebAppsClient.BeginSwapSlot method.
type WebAppsClientBeginSwapSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginSwapSlotWithProductionOptions contains the optional parameters for the WebAppsClient.BeginSwapSlotWithProduction
// method.
type WebAppsClientBeginSwapSlotWithProductionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientCreateDeploymentOptions contains the optional parameters for the WebAppsClient.CreateDeployment method.
type WebAppsClientCreateDeploymentOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateDeploymentSlotOptions contains the optional parameters for the WebAppsClient.CreateDeploymentSlot method.
type WebAppsClientCreateDeploymentSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateConfigurationOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateConfiguration
// method.
type WebAppsClientCreateOrUpdateConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateConfigurationSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateConfigurationSlot
// method.
type WebAppsClientCreateOrUpdateConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateDomainOwnershipIdentifier
// method.
type WebAppsClientCreateOrUpdateDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateDomainOwnershipIdentifierSlot
// method.
type WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateFunctionSecretOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateFunctionSecret
// method.
type WebAppsClientCreateOrUpdateFunctionSecretOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateFunctionSecretSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateFunctionSecretSlot
// method.
type WebAppsClientCreateOrUpdateFunctionSecretSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHostNameBindingOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostNameBinding
// method.
type WebAppsClientCreateOrUpdateHostNameBindingOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHostNameBindingSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostNameBindingSlot
// method.
type WebAppsClientCreateOrUpdateHostNameBindingSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHostSecretOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostSecret
// method.
type WebAppsClientCreateOrUpdateHostSecretOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHostSecretSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostSecretSlot
// method.
type WebAppsClientCreateOrUpdateHostSecretSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHybridConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHybridConnection
// method.
type WebAppsClientCreateOrUpdateHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHybridConnectionSlot
// method.
type WebAppsClientCreateOrUpdateHybridConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdatePublicCertificateOptions contains the optional parameters for the WebAppsClient.CreateOrUpdatePublicCertificate
// method.
type WebAppsClientCreateOrUpdatePublicCertificateOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdatePublicCertificateSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdatePublicCertificateSlot
// method.
type WebAppsClientCreateOrUpdatePublicCertificateSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateRelayServiceConnection
// method.
type WebAppsClientCreateOrUpdateRelayServiceConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateRelayServiceConnectionSlot
// method.
type WebAppsClientCreateOrUpdateRelayServiceConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnection
// method.
type WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionSlot
// method.
type WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateVnetConnectionGatewayOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnectionGateway
// method.
type WebAppsClientCreateOrUpdateVnetConnectionGatewayOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnectionGatewaySlot
// method.
type WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateVnetConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnection
// method.
type WebAppsClientCreateOrUpdateVnetConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnectionSlot
// method.
type WebAppsClientCreateOrUpdateVnetConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteBackupConfigurationOptions contains the optional parameters for the WebAppsClient.DeleteBackupConfiguration
// method.
type WebAppsClientDeleteBackupConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteBackupConfigurationSlotOptions contains the optional parameters for the WebAppsClient.DeleteBackupConfigurationSlot
// method.
type WebAppsClientDeleteBackupConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteBackupOptions contains the optional parameters for the WebAppsClient.DeleteBackup method.
type WebAppsClientDeleteBackupOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteBackupSlotOptions contains the optional parameters for the WebAppsClient.DeleteBackupSlot method.
type WebAppsClientDeleteBackupSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteContinuousWebJobOptions contains the optional parameters for the WebAppsClient.DeleteContinuousWebJob
// method.
type WebAppsClientDeleteContinuousWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.DeleteContinuousWebJobSlot
// method.
type WebAppsClientDeleteContinuousWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteDeploymentOptions contains the optional parameters for the WebAppsClient.DeleteDeployment method.
type WebAppsClientDeleteDeploymentOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteDeploymentSlotOptions contains the optional parameters for the WebAppsClient.DeleteDeploymentSlot method.
type WebAppsClientDeleteDeploymentSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.DeleteDomainOwnershipIdentifier
// method.
type WebAppsClientDeleteDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.DeleteDomainOwnershipIdentifierSlot
// method.
type WebAppsClientDeleteDomainOwnershipIdentifierSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteFunctionOptions contains the optional parameters for the WebAppsClient.DeleteFunction method.
type WebAppsClientDeleteFunctionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteFunctionSecretOptions contains the optional parameters for the WebAppsClient.DeleteFunctionSecret method.
type WebAppsClientDeleteFunctionSecretOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteFunctionSecretSlotOptions contains the optional parameters for the WebAppsClient.DeleteFunctionSecretSlot
// method.
type WebAppsClientDeleteFunctionSecretSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHostNameBindingOptions contains the optional parameters for the WebAppsClient.DeleteHostNameBinding
// method.
type WebAppsClientDeleteHostNameBindingOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHostNameBindingSlotOptions contains the optional parameters for the WebAppsClient.DeleteHostNameBindingSlot
// method.
type WebAppsClientDeleteHostNameBindingSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHostSecretOptions contains the optional parameters for the WebAppsClient.DeleteHostSecret method.
type WebAppsClientDeleteHostSecretOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHostSecretSlotOptions contains the optional parameters for the WebAppsClient.DeleteHostSecretSlot method.
type WebAppsClientDeleteHostSecretSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHybridConnectionOptions contains the optional parameters for the WebAppsClient.DeleteHybridConnection
// method.
type WebAppsClientDeleteHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.DeleteHybridConnectionSlot
// method.
type WebAppsClientDeleteHybridConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteInstanceFunctionSlotOptions contains the optional parameters for the WebAppsClient.DeleteInstanceFunctionSlot
// method.
type WebAppsClientDeleteInstanceFunctionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteInstanceProcessOptions contains the optional parameters for the WebAppsClient.DeleteInstanceProcess
// method.
type WebAppsClientDeleteInstanceProcessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteInstanceProcessSlotOptions contains the optional parameters for the WebAppsClient.DeleteInstanceProcessSlot
// method.
type WebAppsClientDeleteInstanceProcessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteOptions contains the optional parameters for the WebAppsClient.Delete method.
type WebAppsClientDeleteOptions struct {
	// Specify false if you want to keep empty App Service plan. By default, empty App Service plan is deleted.
	DeleteEmptyServerFarm *bool
	// If true, web app metrics are also deleted.
	DeleteMetrics *bool
}

// WebAppsClientDeletePremierAddOnOptions contains the optional parameters for the WebAppsClient.DeletePremierAddOn method.
type WebAppsClientDeletePremierAddOnOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeletePremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.DeletePremierAddOnSlot
// method.
type WebAppsClientDeletePremierAddOnSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteProcessOptions contains the optional parameters for the WebAppsClient.DeleteProcess method.
type WebAppsClientDeleteProcessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteProcessSlotOptions contains the optional parameters for the WebAppsClient.DeleteProcessSlot method.
type WebAppsClientDeleteProcessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeletePublicCertificateOptions contains the optional parameters for the WebAppsClient.DeletePublicCertificate
// method.
type WebAppsClientDeletePublicCertificateOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeletePublicCertificateSlotOptions contains the optional parameters for the WebAppsClient.DeletePublicCertificateSlot
// method.
type WebAppsClientDeletePublicCertificateSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.DeleteRelayServiceConnection
// method.
type WebAppsClientDeleteRelayServiceConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.DeleteRelayServiceConnectionSlot
// method.
type WebAppsClientDeleteRelayServiceConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSiteExtensionOptions contains the optional parameters for the WebAppsClient.DeleteSiteExtension method.
type WebAppsClientDeleteSiteExtensionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSiteExtensionSlotOptions contains the optional parameters for the WebAppsClient.DeleteSiteExtensionSlot
// method.
type WebAppsClientDeleteSiteExtensionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSlotOptions contains the optional parameters for the WebAppsClient.DeleteSlot method.
type WebAppsClientDeleteSlotOptions struct {
	// Specify true if the App Service plan will be empty after app deletion and you want to delete the empty App Service plan.
	// By default, the empty App Service plan is not deleted.
	DeleteEmptyServerFarm *bool
	// If true, web app metrics are also deleted.
	DeleteMetrics *bool
}

// WebAppsClientDeleteSourceControlOptions contains the optional parameters for the WebAppsClient.DeleteSourceControl method.
type WebAppsClientDeleteSourceControlOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSourceControlSlotOptions contains the optional parameters for the WebAppsClient.DeleteSourceControlSlot
// method.
type WebAppsClientDeleteSourceControlSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSwiftVirtualNetworkOptions contains the optional parameters for the WebAppsClient.DeleteSwiftVirtualNetwork
// method.
type WebAppsClientDeleteSwiftVirtualNetworkOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSwiftVirtualNetworkSlotOptions contains the optional parameters for the WebAppsClient.DeleteSwiftVirtualNetworkSlot
// method.
type WebAppsClientDeleteSwiftVirtualNetworkSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteTriggeredWebJobOptions contains the optional parameters for the WebAppsClient.DeleteTriggeredWebJob
// method.
type WebAppsClientDeleteTriggeredWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteTriggeredWebJobSlotOptions contains the optional parameters for the WebAppsClient.DeleteTriggeredWebJobSlot
// method.
type WebAppsClientDeleteTriggeredWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteVnetConnectionOptions contains the optional parameters for the WebAppsClient.DeleteVnetConnection method.
type WebAppsClientDeleteVnetConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.DeleteVnetConnectionSlot
// method.
type WebAppsClientDeleteVnetConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDiscoverBackupOptions contains the optional parameters for the WebAppsClient.DiscoverBackup method.
type WebAppsClientDiscoverBackupOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDiscoverBackupSlotOptions contains the optional parameters for the WebAppsClient.DiscoverBackupSlot method.
type WebAppsClientDiscoverBackupSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGenerateNewSitePublishingPasswordOptions contains the optional parameters for the WebAppsClient.GenerateNewSitePublishingPassword
// method.
type WebAppsClientGenerateNewSitePublishingPasswordOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGenerateNewSitePublishingPasswordSlotOptions contains the optional parameters for the WebAppsClient.GenerateNewSitePublishingPasswordSlot
// method.
type WebAppsClientGenerateNewSitePublishingPasswordSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAuthSettingsOptions contains the optional parameters for the WebAppsClient.GetAuthSettings method.
type WebAppsClientGetAuthSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAuthSettingsSlotOptions contains the optional parameters for the WebAppsClient.GetAuthSettingsSlot method.
type WebAppsClientGetAuthSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetBackupConfigurationOptions contains the optional parameters for the WebAppsClient.GetBackupConfiguration
// method.
type WebAppsClientGetBackupConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetBackupConfigurationSlotOptions contains the optional parameters for the WebAppsClient.GetBackupConfigurationSlot
// method.
type WebAppsClientGetBackupConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetBackupStatusOptions contains the optional parameters for the WebAppsClient.GetBackupStatus method.
type WebAppsClientGetBackupStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetBackupStatusSlotOptions contains the optional parameters for the WebAppsClient.GetBackupStatusSlot method.
type WebAppsClientGetBackupStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetConfigurationOptions contains the optional parameters for the WebAppsClient.GetConfiguration method.
type WebAppsClientGetConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetConfigurationSlotOptions contains the optional parameters for the WebAppsClient.GetConfigurationSlot method.
type WebAppsClientGetConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetConfigurationSnapshotOptions contains the optional parameters for the WebAppsClient.GetConfigurationSnapshot
// method.
type WebAppsClientGetConfigurationSnapshotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetConfigurationSnapshotSlotOptions contains the optional parameters for the WebAppsClient.GetConfigurationSnapshotSlot
// method.
type WebAppsClientGetConfigurationSnapshotSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetContainerLogsZipOptions contains the optional parameters for the WebAppsClient.GetContainerLogsZip method.
type WebAppsClientGetContainerLogsZipOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetContainerLogsZipSlotOptions contains the optional parameters for the WebAppsClient.GetContainerLogsZipSlot
// method.
type WebAppsClientGetContainerLogsZipSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetContinuousWebJobOptions contains the optional parameters for the WebAppsClient.GetContinuousWebJob method.
type WebAppsClientGetContinuousWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.GetContinuousWebJobSlot
// method.
type WebAppsClientGetContinuousWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDeploymentOptions contains the optional parameters for the WebAppsClient.GetDeployment method.
type WebAppsClientGetDeploymentOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDeploymentSlotOptions contains the optional parameters for the WebAppsClient.GetDeploymentSlot method.
type WebAppsClientGetDeploymentSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDiagnosticLogsConfigurationOptions contains the optional parameters for the WebAppsClient.GetDiagnosticLogsConfiguration
// method.
type WebAppsClientGetDiagnosticLogsConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDiagnosticLogsConfigurationSlotOptions contains the optional parameters for the WebAppsClient.GetDiagnosticLogsConfigurationSlot
// method.
type WebAppsClientGetDiagnosticLogsConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.GetDomainOwnershipIdentifier
// method.
type WebAppsClientGetDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.GetDomainOwnershipIdentifierSlot
// method.
type WebAppsClientGetDomainOwnershipIdentifierSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetFunctionOptions contains the optional parameters for the WebAppsClient.GetFunction method.
type WebAppsClientGetFunctionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetFunctionsAdminTokenOptions contains the optional parameters for the WebAppsClient.GetFunctionsAdminToken
// method.
type WebAppsClientGetFunctionsAdminTokenOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetFunctionsAdminTokenSlotOptions contains the optional parameters for the WebAppsClient.GetFunctionsAdminTokenSlot
// method.
type WebAppsClientGetFunctionsAdminTokenSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetHostNameBindingOptions contains the optional parameters for the WebAppsClient.GetHostNameBinding method.
type WebAppsClientGetHostNameBindingOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetHostNameBindingSlotOptions contains the optional parameters for the WebAppsClient.GetHostNameBindingSlot
// method.
type WebAppsClientGetHostNameBindingSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetHybridConnectionOptions contains the optional parameters for the WebAppsClient.GetHybridConnection method.
type WebAppsClientGetHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetHybridConnectionSlot
// method.
type WebAppsClientGetHybridConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceFunctionSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceFunctionSlot
// method.
type WebAppsClientGetInstanceFunctionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceMSDeployLogOptions contains the optional parameters for the WebAppsClient.GetInstanceMSDeployLog
// method.
type WebAppsClientGetInstanceMSDeployLogOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceMSDeployLogSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceMSDeployLogSlot
// method.
type WebAppsClientGetInstanceMSDeployLogSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceMsDeployStatusOptions contains the optional parameters for the WebAppsClient.GetInstanceMsDeployStatus
// method.
type WebAppsClientGetInstanceMsDeployStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceMsDeployStatusSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceMsDeployStatusSlot
// method.
type WebAppsClientGetInstanceMsDeployStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessDumpOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessDump
// method.
type WebAppsClientGetInstanceProcessDumpOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessDumpSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessDumpSlot
// method.
type WebAppsClientGetInstanceProcessDumpSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessModuleOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessModule
// method.
type WebAppsClientGetInstanceProcessModuleOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessModuleSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessModuleSlot
// method.
type WebAppsClientGetInstanceProcessModuleSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessOptions contains the optional parameters for the WebAppsClient.GetInstanceProcess method.
type WebAppsClientGetInstanceProcessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessSlot
// method.
type WebAppsClientGetInstanceProcessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessThreadOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessThread
// method.
type WebAppsClientGetInstanceProcessThreadOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessThreadSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessThreadSlot
// method.
type WebAppsClientGetInstanceProcessThreadSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMSDeployLogOptions contains the optional parameters for the WebAppsClient.GetMSDeployLog method.
type WebAppsClientGetMSDeployLogOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMSDeployLogSlotOptions contains the optional parameters for the WebAppsClient.GetMSDeployLogSlot method.
type WebAppsClientGetMSDeployLogSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMSDeployStatusOptions contains the optional parameters for the WebAppsClient.GetMSDeployStatus method.
type WebAppsClientGetMSDeployStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMSDeployStatusSlotOptions contains the optional parameters for the WebAppsClient.GetMSDeployStatusSlot
// method.
type WebAppsClientGetMSDeployStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMigrateMySQLStatusOptions contains the optional parameters for the WebAppsClient.GetMigrateMySQLStatus
// method.
type WebAppsClientGetMigrateMySQLStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMigrateMySQLStatusSlotOptions contains the optional parameters for the WebAppsClient.GetMigrateMySQLStatusSlot
// method.
type WebAppsClientGetMigrateMySQLStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTraceOperationOptions contains the optional parameters for the WebAppsClient.GetNetworkTraceOperation
// method.
type WebAppsClientGetNetworkTraceOperationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTraceOperationSlotOptions contains the optional parameters for the WebAppsClient.GetNetworkTraceOperationSlot
// method.
type WebAppsClientGetNetworkTraceOperationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTraceOperationSlotV2Options contains the optional parameters for the WebAppsClient.GetNetworkTraceOperationSlotV2
// method.
type WebAppsClientGetNetworkTraceOperationSlotV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTraceOperationV2Options contains the optional parameters for the WebAppsClient.GetNetworkTraceOperationV2
// method.
type WebAppsClientGetNetworkTraceOperationV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTracesOptions contains the optional parameters for the WebAppsClient.GetNetworkTraces method.
type WebAppsClientGetNetworkTracesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTracesSlotOptions contains the optional parameters for the WebAppsClient.GetNetworkTracesSlot method.
type WebAppsClientGetNetworkTracesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTracesSlotV2Options contains the optional parameters for the WebAppsClient.GetNetworkTracesSlotV2
// method.
type WebAppsClientGetNetworkTracesSlotV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTracesV2Options contains the optional parameters for the WebAppsClient.GetNetworkTracesV2 method.
type WebAppsClientGetNetworkTracesV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetOptions contains the optional parameters for the WebAppsClient.Get method.
type WebAppsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPremierAddOnOptions contains the optional parameters for the WebAppsClient.GetPremierAddOn method.
type WebAppsClientGetPremierAddOnOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.GetPremierAddOnSlot method.
type WebAppsClientGetPremierAddOnSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateAccessOptions contains the optional parameters for the WebAppsClient.GetPrivateAccess method.
type WebAppsClientGetPrivateAccessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateAccessSlotOptions contains the optional parameters for the WebAppsClient.GetPrivateAccessSlot method.
type WebAppsClientGetPrivateAccessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessDumpOptions contains the optional parameters for the WebAppsClient.GetProcessDump method.
type WebAppsClientGetProcessDumpOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessDumpSlotOptions contains the optional parameters for the WebAppsClient.GetProcessDumpSlot method.
type WebAppsClientGetProcessDumpSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessModuleOptions contains the optional parameters for the WebAppsClient.GetProcessModule method.
type WebAppsClientGetProcessModuleOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessModuleSlotOptions contains the optional parameters for the WebAppsClient.GetProcessModuleSlot method.
type WebAppsClientGetProcessModuleSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessOptions contains the optional parameters for the WebAppsClient.GetProcess method.
type WebAppsClientGetProcessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessSlotOptions contains the optional parameters for the WebAppsClient.GetProcessSlot method.
type WebAppsClientGetProcessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessThreadOptions contains the optional parameters for the WebAppsClient.GetProcessThread method.
type WebAppsClientGetProcessThreadOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessThreadSlotOptions contains the optional parameters for the WebAppsClient.GetProcessThreadSlot method.
type WebAppsClientGetProcessThreadSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPublicCertificateOptions contains the optional parameters for the WebAppsClient.GetPublicCertificate method.
type WebAppsClientGetPublicCertificateOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPublicCertificateSlotOptions contains the optional parameters for the WebAppsClient.GetPublicCertificateSlot
// method.
type WebAppsClientGetPublicCertificateSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.GetRelayServiceConnection
// method.
type WebAppsClientGetRelayServiceConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetRelayServiceConnectionSlot
// method.
type WebAppsClientGetRelayServiceConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSiteExtensionOptions contains the optional parameters for the WebAppsClient.GetSiteExtension method.
type WebAppsClientGetSiteExtensionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSiteExtensionSlotOptions contains the optional parameters for the WebAppsClient.GetSiteExtensionSlot method.
type WebAppsClientGetSiteExtensionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSitePhpErrorLogFlagOptions contains the optional parameters for the WebAppsClient.GetSitePhpErrorLogFlag
// method.
type WebAppsClientGetSitePhpErrorLogFlagOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSitePhpErrorLogFlagSlotOptions contains the optional parameters for the WebAppsClient.GetSitePhpErrorLogFlagSlot
// method.
type WebAppsClientGetSitePhpErrorLogFlagSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSlotOptions contains the optional parameters for the WebAppsClient.GetSlot method.
type WebAppsClientGetSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSourceControlOptions contains the optional parameters for the WebAppsClient.GetSourceControl method.
type WebAppsClientGetSourceControlOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSourceControlSlotOptions contains the optional parameters for the WebAppsClient.GetSourceControlSlot method.
type WebAppsClientGetSourceControlSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSwiftVirtualNetworkConnectionOptions contains the optional parameters for the WebAppsClient.GetSwiftVirtualNetworkConnection
// method.
type WebAppsClientGetSwiftVirtualNetworkConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSwiftVirtualNetworkConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetSwiftVirtualNetworkConnectionSlot
// method.
type WebAppsClientGetSwiftVirtualNetworkConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetTriggeredWebJobHistoryOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJobHistory
// method.
type WebAppsClientGetTriggeredWebJobHistoryOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetTriggeredWebJobHistorySlotOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJobHistorySlot
// method.
type WebAppsClientGetTriggeredWebJobHistorySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetTriggeredWebJobOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJob method.
type WebAppsClientGetTriggeredWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetTriggeredWebJobSlotOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJobSlot
// method.
type WebAppsClientGetTriggeredWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetVnetConnectionGatewayOptions contains the optional parameters for the WebAppsClient.GetVnetConnectionGateway
// method.
type WebAppsClientGetVnetConnectionGatewayOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetVnetConnectionGatewaySlotOptions contains the optional parameters for the WebAppsClient.GetVnetConnectionGatewaySlot
// method.
type WebAppsClientGetVnetConnectionGatewaySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetVnetConnectionOptions contains the optional parameters for the WebAppsClient.GetVnetConnection method.
type WebAppsClientGetVnetConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetVnetConnectionSlot
// method.
type WebAppsClientGetVnetConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetWebJobOptions contains the optional parameters for the WebAppsClient.GetWebJob method.
type WebAppsClientGetWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetWebJobSlotOptions contains the optional parameters for the WebAppsClient.GetWebJobSlot method.
type WebAppsClientGetWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetWebSiteContainerLogsOptions contains the optional parameters for the WebAppsClient.GetWebSiteContainerLogs
// method.
type WebAppsClientGetWebSiteContainerLogsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetWebSiteContainerLogsSlotOptions contains the optional parameters for the WebAppsClient.GetWebSiteContainerLogsSlot
// method.
type WebAppsClientGetWebSiteContainerLogsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientIsCloneableOptions contains the optional parameters for the WebAppsClient.IsCloneable method.
type WebAppsClientIsCloneableOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientIsCloneableSlotOptions contains the optional parameters for the WebAppsClient.IsCloneableSlot method.
type WebAppsClientIsCloneableSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListApplicationSettingsOptions contains the optional parameters for the WebAppsClient.ListApplicationSettings
// method.
type WebAppsClientListApplicationSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListApplicationSettingsSlotOptions contains the optional parameters for the WebAppsClient.ListApplicationSettingsSlot
// method.
type WebAppsClientListApplicationSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListAzureStorageAccountsOptions contains the optional parameters for the WebAppsClient.ListAzureStorageAccounts
// method.
type WebAppsClientListAzureStorageAccountsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListAzureStorageAccountsSlotOptions contains the optional parameters for the WebAppsClient.ListAzureStorageAccountsSlot
// method.
type WebAppsClientListAzureStorageAccountsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBackupStatusSecretsOptions contains the optional parameters for the WebAppsClient.ListBackupStatusSecrets
// method.
type WebAppsClientListBackupStatusSecretsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBackupStatusSecretsSlotOptions contains the optional parameters for the WebAppsClient.ListBackupStatusSecretsSlot
// method.
type WebAppsClientListBackupStatusSecretsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBackupsOptions contains the optional parameters for the WebAppsClient.NewListBackupsPager method.
type WebAppsClientListBackupsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBackupsSlotOptions contains the optional parameters for the WebAppsClient.NewListBackupsSlotPager method.
type WebAppsClientListBackupsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListByResourceGroupOptions contains the optional parameters for the WebAppsClient.NewListByResourceGroupPager
// method.
type WebAppsClientListByResourceGroupOptions struct {
	// Specify true to include deployment slots in results. The default is false, which only gives you the production slot of
	// all apps.
	IncludeSlots *bool
}

// WebAppsClientListConfigurationSnapshotInfoOptions contains the optional parameters for the WebAppsClient.NewListConfigurationSnapshotInfoPager
// method.
type WebAppsClientListConfigurationSnapshotInfoOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConfigurationSnapshotInfoSlotOptions contains the optional parameters for the WebAppsClient.NewListConfigurationSnapshotInfoSlotPager
// method.
type WebAppsClientListConfigurationSnapshotInfoSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConfigurationsOptions contains the optional parameters for the WebAppsClient.NewListConfigurationsPager
// method.
type WebAppsClientListConfigurationsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConfigurationsSlotOptions contains the optional parameters for the WebAppsClient.NewListConfigurationsSlotPager
// method.
type WebAppsClientListConfigurationsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConnectionStringsOptions contains the optional parameters for the WebAppsClient.ListConnectionStrings
// method.
type WebAppsClientListConnectionStringsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConnectionStringsSlotOptions contains the optional parameters for the WebAppsClient.ListConnectionStringsSlot
// method.
type WebAppsClientListConnectionStringsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListContinuousWebJobsOptions contains the optional parameters for the WebAppsClient.NewListContinuousWebJobsPager
// method.
type WebAppsClientListContinuousWebJobsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListContinuousWebJobsSlotOptions contains the optional parameters for the WebAppsClient.NewListContinuousWebJobsSlotPager
// method.
type WebAppsClientListContinuousWebJobsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDeploymentLogOptions contains the optional parameters for the WebAppsClient.ListDeploymentLog method.
type WebAppsClientListDeploymentLogOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDeploymentLogSlotOptions contains the optional parameters for the WebAppsClient.ListDeploymentLogSlot
// method.
type WebAppsClientListDeploymentLogSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDeploymentsOptions contains the optional parameters for the WebAppsClient.NewListDeploymentsPager method.
type WebAppsClientListDeploymentsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDeploymentsSlotOptions contains the optional parameters for the WebAppsClient.NewListDeploymentsSlotPager
// method.
type WebAppsClientListDeploymentsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDomainOwnershipIdentifiersOptions contains the optional parameters for the WebAppsClient.NewListDomainOwnershipIdentifiersPager
// method.
type WebAppsClientListDomainOwnershipIdentifiersOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDomainOwnershipIdentifiersSlotOptions contains the optional parameters for the WebAppsClient.NewListDomainOwnershipIdentifiersSlotPager
// method.
type WebAppsClientListDomainOwnershipIdentifiersSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionKeysOptions contains the optional parameters for the WebAppsClient.ListFunctionKeys method.
type WebAppsClientListFunctionKeysOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionKeysSlotOptions contains the optional parameters for the WebAppsClient.ListFunctionKeysSlot method.
type WebAppsClientListFunctionKeysSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionSecretsOptions contains the optional parameters for the WebAppsClient.ListFunctionSecrets method.
type WebAppsClientListFunctionSecretsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionSecretsSlotOptions contains the optional parameters for the WebAppsClient.ListFunctionSecretsSlot
// method.
type WebAppsClientListFunctionSecretsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionsOptions contains the optional parameters for the WebAppsClient.NewListFunctionsPager method.
type WebAppsClientListFunctionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHostKeysOptions contains the optional parameters for the WebAppsClient.ListHostKeys method.
type WebAppsClientListHostKeysOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHostKeysSlotOptions contains the optional parameters for the WebAppsClient.ListHostKeysSlot method.
type WebAppsClientListHostKeysSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHostNameBindingsOptions contains the optional parameters for the WebAppsClient.NewListHostNameBindingsPager
// method.
type WebAppsClientListHostNameBindingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHostNameBindingsSlotOptions contains the optional parameters for the WebAppsClient.NewListHostNameBindingsSlotPager
// method.
type WebAppsClientListHostNameBindingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHybridConnectionKeysOptions contains the optional parameters for the WebAppsClient.ListHybridConnectionKeys
// method.
type WebAppsClientListHybridConnectionKeysOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHybridConnectionKeysSlotOptions contains the optional parameters for the WebAppsClient.ListHybridConnectionKeysSlot
// method.
type WebAppsClientListHybridConnectionKeysSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHybridConnectionsOptions contains the optional parameters for the WebAppsClient.ListHybridConnections
// method.
type WebAppsClientListHybridConnectionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHybridConnectionsSlotOptions contains the optional parameters for the WebAppsClient.ListHybridConnectionsSlot
// method.
type WebAppsClientListHybridConnectionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceFunctionsSlotOptions contains the optional parameters for the WebAppsClient.NewListInstanceFunctionsSlotPager
// method.
type WebAppsClientListInstanceFunctionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceIdentifiersOptions contains the optional parameters for the WebAppsClient.NewListInstanceIdentifiersPager
// method.
type WebAppsClientListInstanceIdentifiersOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceIdentifiersSlotOptions contains the optional parameters for the WebAppsClient.NewListInstanceIdentifiersSlotPager
// method.
type WebAppsClientListInstanceIdentifiersSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessModulesOptions contains the optional parameters for the WebAppsClient.NewListInstanceProcessModulesPager
// method.
type WebAppsClientListInstanceProcessModulesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessModulesSlotOptions contains the optional parameters for the WebAppsClient.NewListInstanceProcessModulesSlotPager
// method.
type WebAppsClientListInstanceProcessModulesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessThreadsOptions contains the optional parameters for the WebAppsClient.NewListInstanceProcessThreadsPager
// method.
type WebAppsClientListInstanceProcessThreadsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessThreadsSlotOptions contains the optional parameters for the WebAppsClient.NewListInstanceProcessThreadsSlotPager
// method.
type WebAppsClientListInstanceProcessThreadsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessesOptions contains the optional parameters for the WebAppsClient.NewListInstanceProcessesPager
// method.
type WebAppsClientListInstanceProcessesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessesSlotOptions contains the optional parameters for the WebAppsClient.NewListInstanceProcessesSlotPager
// method.
type WebAppsClientListInstanceProcessesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListMetadataOptions contains the optional parameters for the WebAppsClient.ListMetadata method.
type WebAppsClientListMetadataOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListMetadataSlotOptions contains the optional parameters for the WebAppsClient.ListMetadataSlot method.
type WebAppsClientListMetadataSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListMetricDefinitionsOptions contains the optional parameters for the WebAppsClient.NewListMetricDefinitionsPager
// method.
type WebAppsClientListMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListMetricDefinitionsSlotOptions contains the optional parameters for the WebAppsClient.NewListMetricDefinitionsSlotPager
// method.
type WebAppsClientListMetricDefinitionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListMetricsOptions contains the optional parameters for the WebAppsClient.NewListMetricsPager method.
type WebAppsClientListMetricsOptions struct {
	// Specify "true" to include metric details in the response. It is "false" by default.
	Details *bool
	// Return only metrics specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value
	// eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq
	// 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListMetricsSlotOptions contains the optional parameters for the WebAppsClient.NewListMetricsSlotPager method.
type WebAppsClientListMetricsSlotOptions struct {
	// Specify "true" to include metric details in the response. It is "false" by default.
	Details *bool
	// Return only metrics specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value
	// eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq
	// 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListNetworkFeaturesOptions contains the optional parameters for the WebAppsClient.ListNetworkFeatures method.
type WebAppsClientListNetworkFeaturesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListNetworkFeaturesSlotOptions contains the optional parameters for the WebAppsClient.ListNetworkFeaturesSlot
// method.
type WebAppsClientListNetworkFeaturesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListOptions contains the optional parameters for the WebAppsClient.NewListPager method.
type WebAppsClientListOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPerfMonCountersOptions contains the optional parameters for the WebAppsClient.NewListPerfMonCountersPager
// method.
type WebAppsClientListPerfMonCountersOptions struct {
	// Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(startTime eq 2014-01-01T00:00:00Z
	// and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListPerfMonCountersSlotOptions contains the optional parameters for the WebAppsClient.NewListPerfMonCountersSlotPager
// method.
type WebAppsClientListPerfMonCountersSlotOptions struct {
	// Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(startTime eq 2014-01-01T00:00:00Z
	// and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListPremierAddOnsOptions contains the optional parameters for the WebAppsClient.ListPremierAddOns method.
type WebAppsClientListPremierAddOnsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPremierAddOnsSlotOptions contains the optional parameters for the WebAppsClient.ListPremierAddOnsSlot
// method.
type WebAppsClientListPremierAddOnsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessModulesOptions contains the optional parameters for the WebAppsClient.NewListProcessModulesPager
// method.
type WebAppsClientListProcessModulesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessModulesSlotOptions contains the optional parameters for the WebAppsClient.NewListProcessModulesSlotPager
// method.
type WebAppsClientListProcessModulesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessThreadsOptions contains the optional parameters for the WebAppsClient.NewListProcessThreadsPager
// method.
type WebAppsClientListProcessThreadsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessThreadsSlotOptions contains the optional parameters for the WebAppsClient.NewListProcessThreadsSlotPager
// method.
type WebAppsClientListProcessThreadsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessesOptions contains the optional parameters for the WebAppsClient.NewListProcessesPager method.
type WebAppsClientListProcessesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessesSlotOptions contains the optional parameters for the WebAppsClient.NewListProcessesSlotPager
// method.
type WebAppsClientListProcessesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPublicCertificatesOptions contains the optional parameters for the WebAppsClient.NewListPublicCertificatesPager
// method.
type WebAppsClientListPublicCertificatesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPublicCertificatesSlotOptions contains the optional parameters for the WebAppsClient.NewListPublicCertificatesSlotPager
// method.
type WebAppsClientListPublicCertificatesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPublishingProfileXMLWithSecretsOptions contains the optional parameters for the WebAppsClient.ListPublishingProfileXMLWithSecrets
// method.
type WebAppsClientListPublishingProfileXMLWithSecretsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPublishingProfileXMLWithSecretsSlotOptions contains the optional parameters for the WebAppsClient.ListPublishingProfileXMLWithSecretsSlot
// method.
type WebAppsClientListPublishingProfileXMLWithSecretsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListRelayServiceConnectionsOptions contains the optional parameters for the WebAppsClient.ListRelayServiceConnections
// method.
type WebAppsClientListRelayServiceConnectionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListRelayServiceConnectionsSlotOptions contains the optional parameters for the WebAppsClient.ListRelayServiceConnectionsSlot
// method.
type WebAppsClientListRelayServiceConnectionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSiteExtensionsOptions contains the optional parameters for the WebAppsClient.NewListSiteExtensionsPager
// method.
type WebAppsClientListSiteExtensionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSiteExtensionsSlotOptions contains the optional parameters for the WebAppsClient.NewListSiteExtensionsSlotPager
// method.
type WebAppsClientListSiteExtensionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSitePushSettingsOptions contains the optional parameters for the WebAppsClient.ListSitePushSettings method.
type WebAppsClientListSitePushSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSitePushSettingsSlotOptions contains the optional parameters for the WebAppsClient.ListSitePushSettingsSlot
// method.
type WebAppsClientListSitePushSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSlotConfigurationNamesOptions contains the optional parameters for the WebAppsClient.ListSlotConfigurationNames
// method.
type WebAppsClientListSlotConfigurationNamesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSlotDifferencesFromProductionOptions contains the optional parameters for the WebAppsClient.NewListSlotDifferencesFromProductionPager
// method.
type WebAppsClientListSlotDifferencesFromProductionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSlotDifferencesSlotOptions contains the optional parameters for the WebAppsClient.NewListSlotDifferencesSlotPager
// method.
type WebAppsClientListSlotDifferencesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSlotsOptions contains the optional parameters for the WebAppsClient.NewListSlotsPager method.
type WebAppsClientListSlotsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSnapshotsFromDRSecondaryOptions contains the optional parameters for the WebAppsClient.NewListSnapshotsFromDRSecondaryPager
// method.
type WebAppsClientListSnapshotsFromDRSecondaryOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSnapshotsFromDRSecondarySlotOptions contains the optional parameters for the WebAppsClient.NewListSnapshotsFromDRSecondarySlotPager
// method.
type WebAppsClientListSnapshotsFromDRSecondarySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSnapshotsOptions contains the optional parameters for the WebAppsClient.NewListSnapshotsPager method.
type WebAppsClientListSnapshotsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSnapshotsSlotOptions contains the optional parameters for the WebAppsClient.NewListSnapshotsSlotPager
// method.
type WebAppsClientListSnapshotsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSyncFunctionTriggersOptions contains the optional parameters for the WebAppsClient.ListSyncFunctionTriggers
// method.
type WebAppsClientListSyncFunctionTriggersOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSyncFunctionTriggersSlotOptions contains the optional parameters for the WebAppsClient.ListSyncFunctionTriggersSlot
// method.
type WebAppsClientListSyncFunctionTriggersSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSyncStatusOptions contains the optional parameters for the WebAppsClient.ListSyncStatus method.
type WebAppsClientListSyncStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSyncStatusSlotOptions contains the optional parameters for the WebAppsClient.ListSyncStatusSlot method.
type WebAppsClientListSyncStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListTriggeredWebJobHistoryOptions contains the optional parameters for the WebAppsClient.NewListTriggeredWebJobHistoryPager
// method.
type WebAppsClientListTriggeredWebJobHistoryOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListTriggeredWebJobHistorySlotOptions contains the optional parameters for the WebAppsClient.NewListTriggeredWebJobHistorySlotPager
// method.
type WebAppsClientListTriggeredWebJobHistorySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListTriggeredWebJobsOptions contains the optional parameters for the WebAppsClient.NewListTriggeredWebJobsPager
// method.
type WebAppsClientListTriggeredWebJobsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListTriggeredWebJobsSlotOptions contains the optional parameters for the WebAppsClient.NewListTriggeredWebJobsSlotPager
// method.
type WebAppsClientListTriggeredWebJobsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListUsagesOptions contains the optional parameters for the WebAppsClient.NewListUsagesPager method.
type WebAppsClientListUsagesOptions struct {
	// Return only information specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or
	// name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq
	// 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListUsagesSlotOptions contains the optional parameters for the WebAppsClient.NewListUsagesSlotPager method.
type WebAppsClientListUsagesSlotOptions struct {
	// Return only information specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or
	// name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq
	// 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListVnetConnectionsOptions contains the optional parameters for the WebAppsClient.ListVnetConnections method.
type WebAppsClientListVnetConnectionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListVnetConnectionsSlotOptions contains the optional parameters for the WebAppsClient.ListVnetConnectionsSlot
// method.
type WebAppsClientListVnetConnectionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListWebJobsOptions contains the optional parameters for the WebAppsClient.NewListWebJobsPager method.
type WebAppsClientListWebJobsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListWebJobsSlotOptions contains the optional parameters for the WebAppsClient.NewListWebJobsSlotPager method.
type WebAppsClientListWebJobsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientPutPrivateAccessVnetOptions contains the optional parameters for the WebAppsClient.PutPrivateAccessVnet method.
type WebAppsClientPutPrivateAccessVnetOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientPutPrivateAccessVnetSlotOptions contains the optional parameters for the WebAppsClient.PutPrivateAccessVnetSlot
// method.
type WebAppsClientPutPrivateAccessVnetSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientRecoverSiteConfigurationSnapshotOptions contains the optional parameters for the WebAppsClient.RecoverSiteConfigurationSnapshot
// method.
type WebAppsClientRecoverSiteConfigurationSnapshotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientRecoverSiteConfigurationSnapshotSlotOptions contains the optional parameters for the WebAppsClient.RecoverSiteConfigurationSnapshotSlot
// method.
type WebAppsClientRecoverSiteConfigurationSnapshotSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientResetProductionSlotConfigOptions contains the optional parameters for the WebAppsClient.ResetProductionSlotConfig
// method.
type WebAppsClientResetProductionSlotConfigOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientResetSlotConfigurationSlotOptions contains the optional parameters for the WebAppsClient.ResetSlotConfigurationSlot
// method.
type WebAppsClientResetSlotConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientRestartOptions contains the optional parameters for the WebAppsClient.Restart method.
type WebAppsClientRestartOptions struct {
	// Specify true to apply the configuration settings and restarts the app only if necessary. By default, the API always restarts
	// and reprovisions the app.
	SoftRestart *bool
	// Specify true to block until the app is restarted. By default, it is set to false, and the API responds immediately (asynchronous).
	Synchronous *bool
}

// WebAppsClientRestartSlotOptions contains the optional parameters for the WebAppsClient.RestartSlot method.
type WebAppsClientRestartSlotOptions struct {
	// Specify true to apply the configuration settings and restarts the app only if necessary. By default, the API always restarts
	// and reprovisions the app.
	SoftRestart *bool
	// Specify true to block until the app is restarted. By default, it is set to false, and the API responds immediately (asynchronous).
	Synchronous *bool
}

// WebAppsClientRunTriggeredWebJobOptions contains the optional parameters for the WebAppsClient.RunTriggeredWebJob method.
type WebAppsClientRunTriggeredWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientRunTriggeredWebJobSlotOptions contains the optional parameters for the WebAppsClient.RunTriggeredWebJobSlot
// method.
type WebAppsClientRunTriggeredWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartContinuousWebJobOptions contains the optional parameters for the WebAppsClient.StartContinuousWebJob
// method.
type WebAppsClientStartContinuousWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.StartContinuousWebJobSlot
// method.
type WebAppsClientStartContinuousWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartOptions contains the optional parameters for the WebAppsClient.Start method.
type WebAppsClientStartOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartSlotOptions contains the optional parameters for the WebAppsClient.StartSlot method.
type WebAppsClientStartSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartWebSiteNetworkTraceOptions contains the optional parameters for the WebAppsClient.StartWebSiteNetworkTrace
// method.
type WebAppsClientStartWebSiteNetworkTraceOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientStartWebSiteNetworkTraceSlotOptions contains the optional parameters for the WebAppsClient.StartWebSiteNetworkTraceSlot
// method.
type WebAppsClientStartWebSiteNetworkTraceSlotOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientStopContinuousWebJobOptions contains the optional parameters for the WebAppsClient.StopContinuousWebJob method.
type WebAppsClientStopContinuousWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.StopContinuousWebJobSlot
// method.
type WebAppsClientStopContinuousWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopNetworkTraceOptions contains the optional parameters for the WebAppsClient.StopNetworkTrace method.
type WebAppsClientStopNetworkTraceOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopNetworkTraceSlotOptions contains the optional parameters for the WebAppsClient.StopNetworkTraceSlot method.
type WebAppsClientStopNetworkTraceSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopOptions contains the optional parameters for the WebAppsClient.Stop method.
type WebAppsClientStopOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopSlotOptions contains the optional parameters for the WebAppsClient.StopSlot method.
type WebAppsClientStopSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopWebSiteNetworkTraceOptions contains the optional parameters for the WebAppsClient.StopWebSiteNetworkTrace
// method.
type WebAppsClientStopWebSiteNetworkTraceOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopWebSiteNetworkTraceSlotOptions contains the optional parameters for the WebAppsClient.StopWebSiteNetworkTraceSlot
// method.
type WebAppsClientStopWebSiteNetworkTraceSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncFunctionTriggersOptions contains the optional parameters for the WebAppsClient.SyncFunctionTriggers method.
type WebAppsClientSyncFunctionTriggersOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncFunctionTriggersSlotOptions contains the optional parameters for the WebAppsClient.SyncFunctionTriggersSlot
// method.
type WebAppsClientSyncFunctionTriggersSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncFunctionsOptions contains the optional parameters for the WebAppsClient.SyncFunctions method.
type WebAppsClientSyncFunctionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncFunctionsSlotOptions contains the optional parameters for the WebAppsClient.SyncFunctionsSlot method.
type WebAppsClientSyncFunctionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncRepositoryOptions contains the optional parameters for the WebAppsClient.SyncRepository method.
type WebAppsClientSyncRepositoryOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncRepositorySlotOptions contains the optional parameters for the WebAppsClient.SyncRepositorySlot method.
type WebAppsClientSyncRepositorySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateApplicationSettingsOptions contains the optional parameters for the WebAppsClient.UpdateApplicationSettings
// method.
type WebAppsClientUpdateApplicationSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateApplicationSettingsSlotOptions contains the optional parameters for the WebAppsClient.UpdateApplicationSettingsSlot
// method.
type WebAppsClientUpdateApplicationSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAuthSettingsOptions contains the optional parameters for the WebAppsClient.UpdateAuthSettings method.
type WebAppsClientUpdateAuthSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAuthSettingsSlotOptions contains the optional parameters for the WebAppsClient.UpdateAuthSettingsSlot
// method.
type WebAppsClientUpdateAuthSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAzureStorageAccountsOptions contains the optional parameters for the WebAppsClient.UpdateAzureStorageAccounts
// method.
type WebAppsClientUpdateAzureStorageAccountsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAzureStorageAccountsSlotOptions contains the optional parameters for the WebAppsClient.UpdateAzureStorageAccountsSlot
// method.
type WebAppsClientUpdateAzureStorageAccountsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateBackupConfigurationOptions contains the optional parameters for the WebAppsClient.UpdateBackupConfiguration
// method.
type WebAppsClientUpdateBackupConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateBackupConfigurationSlotOptions contains the optional parameters for the WebAppsClient.UpdateBackupConfigurationSlot
// method.
type WebAppsClientUpdateBackupConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateConfigurationOptions contains the optional parameters for the WebAppsClient.UpdateConfiguration method.
type WebAppsClientUpdateConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateConfigurationSlotOptions contains the optional parameters for the WebAppsClient.UpdateConfigurationSlot
// method.
type WebAppsClientUpdateConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateConnectionStringsOptions contains the optional parameters for the WebAppsClient.UpdateConnectionStrings
// method.
type WebAppsClientUpdateConnectionStringsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateConnectionStringsSlotOptions contains the optional parameters for the WebAppsClient.UpdateConnectionStringsSlot
// method.
type WebAppsClientUpdateConnectionStringsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateDiagnosticLogsConfigOptions contains the optional parameters for the WebAppsClient.UpdateDiagnosticLogsConfig
// method.
type WebAppsClientUpdateDiagnosticLogsConfigOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateDiagnosticLogsConfigSlotOptions contains the optional parameters for the WebAppsClient.UpdateDiagnosticLogsConfigSlot
// method.
type WebAppsClientUpdateDiagnosticLogsConfigSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.UpdateDomainOwnershipIdentifier
// method.
type WebAppsClientUpdateDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.UpdateDomainOwnershipIdentifierSlot
// method.
type WebAppsClientUpdateDomainOwnershipIdentifierSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateHybridConnectionOptions contains the optional parameters for the WebAppsClient.UpdateHybridConnection
// method.
type WebAppsClientUpdateHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.UpdateHybridConnectionSlot
// method.
type WebAppsClientUpdateHybridConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateMetadataOptions contains the optional parameters for the WebAppsClient.UpdateMetadata method.
type WebAppsClientUpdateMetadataOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateMetadataSlotOptions contains the optional parameters for the WebAppsClient.UpdateMetadataSlot method.
type WebAppsClientUpdateMetadataSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateOptions contains the optional parameters for the WebAppsClient.Update method.
type WebAppsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdatePremierAddOnOptions contains the optional parameters for the WebAppsClient.UpdatePremierAddOn method.
type WebAppsClientUpdatePremierAddOnOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdatePremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.UpdatePremierAddOnSlot
// method.
type WebAppsClientUpdatePremierAddOnSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.UpdateRelayServiceConnection
// method.
type WebAppsClientUpdateRelayServiceConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.UpdateRelayServiceConnectionSlot
// method.
type WebAppsClientUpdateRelayServiceConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSitePushSettingsOptions contains the optional parameters for the WebAppsClient.UpdateSitePushSettings
// method.
type WebAppsClientUpdateSitePushSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSitePushSettingsSlotOptions contains the optional parameters for the WebAppsClient.UpdateSitePushSettingsSlot
// method.
type WebAppsClientUpdateSitePushSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSlotConfigurationNamesOptions contains the optional parameters for the WebAppsClient.UpdateSlotConfigurationNames
// method.
type WebAppsClientUpdateSlotConfigurationNamesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSlotOptions contains the optional parameters for the WebAppsClient.UpdateSlot method.
type WebAppsClientUpdateSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSourceControlOptions contains the optional parameters for the WebAppsClient.UpdateSourceControl method.
type WebAppsClientUpdateSourceControlOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSourceControlSlotOptions contains the optional parameters for the WebAppsClient.UpdateSourceControlSlot
// method.
type WebAppsClientUpdateSourceControlSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSwiftVirtualNetworkConnectionOptions contains the optional parameters for the WebAppsClient.UpdateSwiftVirtualNetworkConnection
// method.
type WebAppsClientUpdateSwiftVirtualNetworkConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSwiftVirtualNetworkConnectionSlotOptions contains the optional parameters for the WebAppsClient.UpdateSwiftVirtualNetworkConnectionSlot
// method.
type WebAppsClientUpdateSwiftVirtualNetworkConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateVnetConnectionGatewayOptions contains the optional parameters for the WebAppsClient.UpdateVnetConnectionGateway
// method.
type WebAppsClientUpdateVnetConnectionGatewayOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateVnetConnectionGatewaySlotOptions contains the optional parameters for the WebAppsClient.UpdateVnetConnectionGatewaySlot
// method.
type WebAppsClientUpdateVnetConnectionGatewaySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateVnetConnectionOptions contains the optional parameters for the WebAppsClient.UpdateVnetConnection method.
type WebAppsClientUpdateVnetConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.UpdateVnetConnectionSlot
// method.
type WebAppsClientUpdateVnetConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebJob - Web Job Information.
type WebJob struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// WebJob resource specific properties
	Properties *WebJobProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebJobCollection - Collection of Kudu web job information elements.
type WebJobCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WebJob `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WebJobProperties - WebJob resource specific properties
type WebJobProperties struct {
	// Error information.
	Error *string `json:"error,omitempty"`

	// Extra Info URL.
	ExtraInfoURL *string `json:"extra_info_url,omitempty"`

	// Run command.
	RunCommand *string `json:"run_command,omitempty"`

	// Job settings.
	Settings map[string]any `json:"settings,omitempty"`

	// Job URL.
	URL *string `json:"url,omitempty"`

	// Using SDK?
	UsingSdk *bool `json:"using_sdk,omitempty"`

	// Job type.
	WebJobType *WebJobType `json:"web_job_type,omitempty"`
}

// WebSiteManagementClientCheckNameAvailabilityOptions contains the optional parameters for the WebSiteManagementClient.CheckNameAvailability
// method.
type WebSiteManagementClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientGetPublishingUserOptions contains the optional parameters for the WebSiteManagementClient.GetPublishingUser
// method.
type WebSiteManagementClientGetPublishingUserOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientGetSourceControlOptions contains the optional parameters for the WebSiteManagementClient.GetSourceControl
// method.
type WebSiteManagementClientGetSourceControlOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientGetSubscriptionDeploymentLocationsOptions contains the optional parameters for the WebSiteManagementClient.GetSubscriptionDeploymentLocations
// method.
type WebSiteManagementClientGetSubscriptionDeploymentLocationsOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientListBillingMetersOptions contains the optional parameters for the WebSiteManagementClient.NewListBillingMetersPager
// method.
type WebSiteManagementClientListBillingMetersOptions struct {
	// Azure Location of billable resource
	BillingLocation *string
	// App Service OS type meters used for
	OSType *string
}

// WebSiteManagementClientListGeoRegionsOptions contains the optional parameters for the WebSiteManagementClient.NewListGeoRegionsPager
// method.
type WebSiteManagementClientListGeoRegionsOptions struct {
	// Specify true if you want to filter to only regions that support Linux Consumption Workers.
	LinuxDynamicWorkersEnabled *bool
	// Specify true if you want to filter to only regions that support Linux workers.
	LinuxWorkersEnabled *bool
	// Name of SKU used to filter the regions.
	SKU *SKUName
	// Specify true if you want to filter to only regions that support Xenon workers.
	XenonWorkersEnabled *bool
}

// WebSiteManagementClientListPremierAddOnOffersOptions contains the optional parameters for the WebSiteManagementClient.NewListPremierAddOnOffersPager
// method.
type WebSiteManagementClientListPremierAddOnOffersOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientListSKUsOptions contains the optional parameters for the WebSiteManagementClient.ListSKUs method.
type WebSiteManagementClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientListSiteIdentifiersAssignedToHostNameOptions contains the optional parameters for the WebSiteManagementClient.NewListSiteIdentifiersAssignedToHostNamePager
// method.
type WebSiteManagementClientListSiteIdentifiersAssignedToHostNameOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientListSourceControlsOptions contains the optional parameters for the WebSiteManagementClient.NewListSourceControlsPager
// method.
type WebSiteManagementClientListSourceControlsOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientMoveOptions contains the optional parameters for the WebSiteManagementClient.Move method.
type WebSiteManagementClientMoveOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientUpdatePublishingUserOptions contains the optional parameters for the WebSiteManagementClient.UpdatePublishingUser
// method.
type WebSiteManagementClientUpdatePublishingUserOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientUpdateSourceControlOptions contains the optional parameters for the WebSiteManagementClient.UpdateSourceControl
// method.
type WebSiteManagementClientUpdateSourceControlOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientValidateContainerSettingsOptions contains the optional parameters for the WebSiteManagementClient.ValidateContainerSettings
// method.
type WebSiteManagementClientValidateContainerSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientValidateMoveOptions contains the optional parameters for the WebSiteManagementClient.ValidateMove
// method.
type WebSiteManagementClientValidateMoveOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientValidateOptions contains the optional parameters for the WebSiteManagementClient.Validate method.
type WebSiteManagementClientValidateOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientVerifyHostingEnvironmentVnetOptions contains the optional parameters for the WebSiteManagementClient.VerifyHostingEnvironmentVnet
// method.
type WebSiteManagementClientVerifyHostingEnvironmentVnetOptions struct {
	// placeholder for future optional parameters
}

// WorkerPool - Worker pool of an App Service Environment.
type WorkerPool struct {
	// Shared or dedicated app hosting.
	ComputeMode *ComputeModeOptions `json:"computeMode,omitempty"`

	// Number of instances in the worker pool.
	WorkerCount *int32 `json:"workerCount,omitempty"`

	// VM size of the worker pool instances.
	WorkerSize *string `json:"workerSize,omitempty"`

	// Worker size ID for referencing this worker pool.
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`

	// READ-ONLY; Names of all instances in the worker pool (read only).
	InstanceNames []*string `json:"instanceNames,omitempty" azure:"ro"`
}
