//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azopenai

import "encoding/json"

func unmarshalAzureChatExtensionConfigurationClassification(rawMsg json.RawMessage) (AzureChatExtensionConfigurationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AzureChatExtensionConfigurationClassification
	switch m["type"] {
	case string(AzureChatExtensionTypeAzureCognitiveSearch):
		b = &AzureCognitiveSearchChatExtensionConfiguration{}
	case string(AzureChatExtensionTypeAzureCosmosDB):
		b = &AzureCosmosDBChatExtensionConfiguration{}
	case string(AzureChatExtensionTypeAzureMachineLearningIndex):
		b = &AzureMachineLearningIndexChatExtensionConfiguration{}
	case string(AzureChatExtensionTypeElasticsearch):
		b = &ElasticsearchChatExtensionConfiguration{}
	case string(AzureChatExtensionTypePinecone):
		b = &PineconeChatExtensionConfiguration{}
	default:
		b = &AzureChatExtensionConfiguration{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAzureChatExtensionConfigurationClassificationArray(rawMsg json.RawMessage) ([]AzureChatExtensionConfigurationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AzureChatExtensionConfigurationClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAzureChatExtensionConfigurationClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalChatCompletionsResponseFormatClassification(rawMsg json.RawMessage) (ChatCompletionsResponseFormatClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ChatCompletionsResponseFormatClassification
	switch m["type"] {
	case "json_object":
		b = &ChatCompletionsJSONResponseFormat{}
	case "text":
		b = &ChatCompletionsTextResponseFormat{}
	default:
		b = &ChatCompletionsResponseFormat{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalChatCompletionsToolCallClassification(rawMsg json.RawMessage) (ChatCompletionsToolCallClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ChatCompletionsToolCallClassification

	if m["type"] == nil && m["function"] != nil {
		// WORKAROUND: the streaming results don't contain the proper role for functions, so we need to add these in.
		m["type"] = string(ChatRoleFunction)
	}
	switch m["type"] {
	case "function":
		b = &ChatCompletionsFunctionToolCall{}
	default:
		b = &ChatCompletionsToolCall{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalChatCompletionsToolCallClassificationArray(rawMsg json.RawMessage) ([]ChatCompletionsToolCallClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ChatCompletionsToolCallClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalChatCompletionsToolCallClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalChatCompletionsToolDefinitionClassification(rawMsg json.RawMessage) (ChatCompletionsToolDefinitionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ChatCompletionsToolDefinitionClassification
	switch m["type"] {
	case "function":
		b = &ChatCompletionsFunctionToolDefinition{}
	default:
		b = &ChatCompletionsToolDefinition{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalChatCompletionsToolDefinitionClassificationArray(rawMsg json.RawMessage) ([]ChatCompletionsToolDefinitionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ChatCompletionsToolDefinitionClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalChatCompletionsToolDefinitionClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalChatFinishDetailsClassification(rawMsg json.RawMessage) (ChatFinishDetailsClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ChatFinishDetailsClassification
	switch m["type"] {
	case "max_tokens":
		b = &MaxTokensFinishDetails{}
	case "stop":
		b = &StopFinishDetails{}
	default:
		b = &ChatFinishDetails{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalChatRequestMessageClassification(rawMsg json.RawMessage) (ChatRequestMessageClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ChatRequestMessageClassification
	switch m["role"] {
	case string(ChatRoleAssistant):
		b = &ChatRequestAssistantMessage{}
	case string(ChatRoleSystem):
		b = &ChatRequestSystemMessage{}
	case string(ChatRoleTool):
		b = &ChatRequestToolMessage{}
	case string(ChatRoleUser):
		b = &ChatRequestUserMessage{}
	default:
		b = &ChatRequestMessage{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalChatRequestMessageClassificationArray(rawMsg json.RawMessage) ([]ChatRequestMessageClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ChatRequestMessageClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalChatRequestMessageClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalOnYourDataAuthenticationOptionsClassification(rawMsg json.RawMessage) (OnYourDataAuthenticationOptionsClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b OnYourDataAuthenticationOptionsClassification
	switch m["type"] {
	case string(OnYourDataAuthenticationTypeAPIKey):
		b = &OnYourDataAPIKeyAuthenticationOptions{}
	case string(OnYourDataAuthenticationTypeConnectionString):
		b = &OnYourDataConnectionStringAuthenticationOptions{}
	case string(OnYourDataAuthenticationTypeKeyAndKeyID):
		b = &OnYourDataKeyAndKeyIDAuthenticationOptions{}
	case string(OnYourDataAuthenticationTypeSystemAssignedManagedIdentity):
		b = &OnYourDataSystemAssignedManagedIdentityAuthenticationOptions{}
	case string(OnYourDataAuthenticationTypeUserAssignedManagedIdentity):
		b = &OnYourDataUserAssignedManagedIdentityAuthenticationOptions{}
	default:
		b = &OnYourDataAuthenticationOptions{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalOnYourDataVectorizationSourceClassification(rawMsg json.RawMessage) (OnYourDataVectorizationSourceClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b OnYourDataVectorizationSourceClassification
	switch m["type"] {
	case string(OnYourDataVectorizationSourceTypeDeploymentName):
		b = &OnYourDataDeploymentNameVectorizationSource{}
	case string(OnYourDataVectorizationSourceTypeEndpoint):
		b = &OnYourDataEndpointVectorizationSource{}
	case string(OnYourDataVectorizationSourceTypeModelID):
		b = &OnYourDataModelIDVectorizationSource{}
	default:
		b = &OnYourDataVectorizationSource{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
