//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armappcontainers.ClientFactory type.
type ServerFactory struct {
	AvailableWorkloadProfilesServer           AvailableWorkloadProfilesServer
	BillingMetersServer                       BillingMetersServer
	CertificatesServer                        CertificatesServer
	ConnectedEnvironmentsCertificatesServer   ConnectedEnvironmentsCertificatesServer
	ConnectedEnvironmentsServer               ConnectedEnvironmentsServer
	ConnectedEnvironmentsDaprComponentsServer ConnectedEnvironmentsDaprComponentsServer
	ConnectedEnvironmentsStoragesServer       ConnectedEnvironmentsStoragesServer
	ContainerAppsAPIServer                    ContainerAppsAPIServer
	ContainerAppsAuthConfigsServer            ContainerAppsAuthConfigsServer
	ContainerAppsServer                       ContainerAppsServer
	ContainerAppsDiagnosticsServer            ContainerAppsDiagnosticsServer
	ContainerAppsRevisionReplicasServer       ContainerAppsRevisionReplicasServer
	ContainerAppsRevisionsServer              ContainerAppsRevisionsServer
	ContainerAppsSourceControlsServer         ContainerAppsSourceControlsServer
	DaprComponentsServer                      DaprComponentsServer
	JobsServer                                JobsServer
	JobsExecutionsServer                      JobsExecutionsServer
	ManagedCertificatesServer                 ManagedCertificatesServer
	ManagedEnvironmentDiagnosticsServer       ManagedEnvironmentDiagnosticsServer
	ManagedEnvironmentsServer                 ManagedEnvironmentsServer
	ManagedEnvironmentsDiagnosticsServer      ManagedEnvironmentsDiagnosticsServer
	ManagedEnvironmentsStoragesServer         ManagedEnvironmentsStoragesServer
	NamespacesServer                          NamespacesServer
	OperationsServer                          OperationsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armappcontainers.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armappcontainers.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                         *ServerFactory
	trMu                                        sync.Mutex
	trAvailableWorkloadProfilesServer           *AvailableWorkloadProfilesServerTransport
	trBillingMetersServer                       *BillingMetersServerTransport
	trCertificatesServer                        *CertificatesServerTransport
	trConnectedEnvironmentsCertificatesServer   *ConnectedEnvironmentsCertificatesServerTransport
	trConnectedEnvironmentsServer               *ConnectedEnvironmentsServerTransport
	trConnectedEnvironmentsDaprComponentsServer *ConnectedEnvironmentsDaprComponentsServerTransport
	trConnectedEnvironmentsStoragesServer       *ConnectedEnvironmentsStoragesServerTransport
	trContainerAppsAPIServer                    *ContainerAppsAPIServerTransport
	trContainerAppsAuthConfigsServer            *ContainerAppsAuthConfigsServerTransport
	trContainerAppsServer                       *ContainerAppsServerTransport
	trContainerAppsDiagnosticsServer            *ContainerAppsDiagnosticsServerTransport
	trContainerAppsRevisionReplicasServer       *ContainerAppsRevisionReplicasServerTransport
	trContainerAppsRevisionsServer              *ContainerAppsRevisionsServerTransport
	trContainerAppsSourceControlsServer         *ContainerAppsSourceControlsServerTransport
	trDaprComponentsServer                      *DaprComponentsServerTransport
	trJobsServer                                *JobsServerTransport
	trJobsExecutionsServer                      *JobsExecutionsServerTransport
	trManagedCertificatesServer                 *ManagedCertificatesServerTransport
	trManagedEnvironmentDiagnosticsServer       *ManagedEnvironmentDiagnosticsServerTransport
	trManagedEnvironmentsServer                 *ManagedEnvironmentsServerTransport
	trManagedEnvironmentsDiagnosticsServer      *ManagedEnvironmentsDiagnosticsServerTransport
	trManagedEnvironmentsStoragesServer         *ManagedEnvironmentsStoragesServerTransport
	trNamespacesServer                          *NamespacesServerTransport
	trOperationsServer                          *OperationsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AvailableWorkloadProfilesClient":
		initServer(s, &s.trAvailableWorkloadProfilesServer, func() *AvailableWorkloadProfilesServerTransport {
			return NewAvailableWorkloadProfilesServerTransport(&s.srv.AvailableWorkloadProfilesServer)
		})
		resp, err = s.trAvailableWorkloadProfilesServer.Do(req)
	case "BillingMetersClient":
		initServer(s, &s.trBillingMetersServer, func() *BillingMetersServerTransport {
			return NewBillingMetersServerTransport(&s.srv.BillingMetersServer)
		})
		resp, err = s.trBillingMetersServer.Do(req)
	case "CertificatesClient":
		initServer(s, &s.trCertificatesServer, func() *CertificatesServerTransport { return NewCertificatesServerTransport(&s.srv.CertificatesServer) })
		resp, err = s.trCertificatesServer.Do(req)
	case "ConnectedEnvironmentsCertificatesClient":
		initServer(s, &s.trConnectedEnvironmentsCertificatesServer, func() *ConnectedEnvironmentsCertificatesServerTransport {
			return NewConnectedEnvironmentsCertificatesServerTransport(&s.srv.ConnectedEnvironmentsCertificatesServer)
		})
		resp, err = s.trConnectedEnvironmentsCertificatesServer.Do(req)
	case "ConnectedEnvironmentsClient":
		initServer(s, &s.trConnectedEnvironmentsServer, func() *ConnectedEnvironmentsServerTransport {
			return NewConnectedEnvironmentsServerTransport(&s.srv.ConnectedEnvironmentsServer)
		})
		resp, err = s.trConnectedEnvironmentsServer.Do(req)
	case "ConnectedEnvironmentsDaprComponentsClient":
		initServer(s, &s.trConnectedEnvironmentsDaprComponentsServer, func() *ConnectedEnvironmentsDaprComponentsServerTransport {
			return NewConnectedEnvironmentsDaprComponentsServerTransport(&s.srv.ConnectedEnvironmentsDaprComponentsServer)
		})
		resp, err = s.trConnectedEnvironmentsDaprComponentsServer.Do(req)
	case "ConnectedEnvironmentsStoragesClient":
		initServer(s, &s.trConnectedEnvironmentsStoragesServer, func() *ConnectedEnvironmentsStoragesServerTransport {
			return NewConnectedEnvironmentsStoragesServerTransport(&s.srv.ConnectedEnvironmentsStoragesServer)
		})
		resp, err = s.trConnectedEnvironmentsStoragesServer.Do(req)
	case "ContainerAppsAPIClient":
		initServer(s, &s.trContainerAppsAPIServer, func() *ContainerAppsAPIServerTransport {
			return NewContainerAppsAPIServerTransport(&s.srv.ContainerAppsAPIServer)
		})
		resp, err = s.trContainerAppsAPIServer.Do(req)
	case "ContainerAppsAuthConfigsClient":
		initServer(s, &s.trContainerAppsAuthConfigsServer, func() *ContainerAppsAuthConfigsServerTransport {
			return NewContainerAppsAuthConfigsServerTransport(&s.srv.ContainerAppsAuthConfigsServer)
		})
		resp, err = s.trContainerAppsAuthConfigsServer.Do(req)
	case "ContainerAppsClient":
		initServer(s, &s.trContainerAppsServer, func() *ContainerAppsServerTransport {
			return NewContainerAppsServerTransport(&s.srv.ContainerAppsServer)
		})
		resp, err = s.trContainerAppsServer.Do(req)
	case "ContainerAppsDiagnosticsClient":
		initServer(s, &s.trContainerAppsDiagnosticsServer, func() *ContainerAppsDiagnosticsServerTransport {
			return NewContainerAppsDiagnosticsServerTransport(&s.srv.ContainerAppsDiagnosticsServer)
		})
		resp, err = s.trContainerAppsDiagnosticsServer.Do(req)
	case "ContainerAppsRevisionReplicasClient":
		initServer(s, &s.trContainerAppsRevisionReplicasServer, func() *ContainerAppsRevisionReplicasServerTransport {
			return NewContainerAppsRevisionReplicasServerTransport(&s.srv.ContainerAppsRevisionReplicasServer)
		})
		resp, err = s.trContainerAppsRevisionReplicasServer.Do(req)
	case "ContainerAppsRevisionsClient":
		initServer(s, &s.trContainerAppsRevisionsServer, func() *ContainerAppsRevisionsServerTransport {
			return NewContainerAppsRevisionsServerTransport(&s.srv.ContainerAppsRevisionsServer)
		})
		resp, err = s.trContainerAppsRevisionsServer.Do(req)
	case "ContainerAppsSourceControlsClient":
		initServer(s, &s.trContainerAppsSourceControlsServer, func() *ContainerAppsSourceControlsServerTransport {
			return NewContainerAppsSourceControlsServerTransport(&s.srv.ContainerAppsSourceControlsServer)
		})
		resp, err = s.trContainerAppsSourceControlsServer.Do(req)
	case "DaprComponentsClient":
		initServer(s, &s.trDaprComponentsServer, func() *DaprComponentsServerTransport {
			return NewDaprComponentsServerTransport(&s.srv.DaprComponentsServer)
		})
		resp, err = s.trDaprComponentsServer.Do(req)
	case "JobsClient":
		initServer(s, &s.trJobsServer, func() *JobsServerTransport { return NewJobsServerTransport(&s.srv.JobsServer) })
		resp, err = s.trJobsServer.Do(req)
	case "JobsExecutionsClient":
		initServer(s, &s.trJobsExecutionsServer, func() *JobsExecutionsServerTransport {
			return NewJobsExecutionsServerTransport(&s.srv.JobsExecutionsServer)
		})
		resp, err = s.trJobsExecutionsServer.Do(req)
	case "ManagedCertificatesClient":
		initServer(s, &s.trManagedCertificatesServer, func() *ManagedCertificatesServerTransport {
			return NewManagedCertificatesServerTransport(&s.srv.ManagedCertificatesServer)
		})
		resp, err = s.trManagedCertificatesServer.Do(req)
	case "ManagedEnvironmentDiagnosticsClient":
		initServer(s, &s.trManagedEnvironmentDiagnosticsServer, func() *ManagedEnvironmentDiagnosticsServerTransport {
			return NewManagedEnvironmentDiagnosticsServerTransport(&s.srv.ManagedEnvironmentDiagnosticsServer)
		})
		resp, err = s.trManagedEnvironmentDiagnosticsServer.Do(req)
	case "ManagedEnvironmentsClient":
		initServer(s, &s.trManagedEnvironmentsServer, func() *ManagedEnvironmentsServerTransport {
			return NewManagedEnvironmentsServerTransport(&s.srv.ManagedEnvironmentsServer)
		})
		resp, err = s.trManagedEnvironmentsServer.Do(req)
	case "ManagedEnvironmentsDiagnosticsClient":
		initServer(s, &s.trManagedEnvironmentsDiagnosticsServer, func() *ManagedEnvironmentsDiagnosticsServerTransport {
			return NewManagedEnvironmentsDiagnosticsServerTransport(&s.srv.ManagedEnvironmentsDiagnosticsServer)
		})
		resp, err = s.trManagedEnvironmentsDiagnosticsServer.Do(req)
	case "ManagedEnvironmentsStoragesClient":
		initServer(s, &s.trManagedEnvironmentsStoragesServer, func() *ManagedEnvironmentsStoragesServerTransport {
			return NewManagedEnvironmentsStoragesServerTransport(&s.srv.ManagedEnvironmentsStoragesServer)
		})
		resp, err = s.trManagedEnvironmentsStoragesServer.Do(req)
	case "NamespacesClient":
		initServer(s, &s.trNamespacesServer, func() *NamespacesServerTransport { return NewNamespacesServerTransport(&s.srv.NamespacesServer) })
		resp, err = s.trNamespacesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
