//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DatabaseSQLVulnerabilityAssessmentsSettingsClient contains the methods for the DatabaseSQLVulnerabilityAssessmentsSettings group.
// Don't use this type directly, use NewDatabaseSQLVulnerabilityAssessmentsSettingsClient() instead.
type DatabaseSQLVulnerabilityAssessmentsSettingsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDatabaseSQLVulnerabilityAssessmentsSettingsClient creates a new instance of DatabaseSQLVulnerabilityAssessmentsSettingsClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDatabaseSQLVulnerabilityAssessmentsSettingsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DatabaseSQLVulnerabilityAssessmentsSettingsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DatabaseSQLVulnerabilityAssessmentsSettingsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets SQL Vulnerability Assessment policy for database.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the SQL Vulnerability Assessment.
//   - options - DatabaseSQLVulnerabilityAssessmentsSettingsClientGetOptions contains the optional parameters for the DatabaseSQLVulnerabilityAssessmentsSettingsClient.Get
//     method.
func (client *DatabaseSQLVulnerabilityAssessmentsSettingsClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, options *DatabaseSQLVulnerabilityAssessmentsSettingsClientGetOptions) (DatabaseSQLVulnerabilityAssessmentsSettingsClientGetResponse, error) {
	var err error
	const operationName = "DatabaseSQLVulnerabilityAssessmentsSettingsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, options)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DatabaseSQLVulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DatabaseSQLVulnerabilityAssessmentsSettingsClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, options *DatabaseSQLVulnerabilityAssessmentsSettingsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DatabaseSQLVulnerabilityAssessmentsSettingsClient) getHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentsSettingsClientGetResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentsSettingsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessment); err != nil {
		return DatabaseSQLVulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByDatabasePager - Lists SQL Vulnerability Assessment policies associated with a database.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - options - DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseOptions contains the optional parameters for the
//     DatabaseSQLVulnerabilityAssessmentsSettingsClient.NewListByDatabasePager method.
func (client *DatabaseSQLVulnerabilityAssessmentsSettingsClient) NewListByDatabasePager(resourceGroupName string, serverName string, databaseName string, options *DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseOptions) *runtime.Pager[DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse] {
	return runtime.NewPager(runtime.PagingHandler[DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse]{
		More: func(page DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse) (DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DatabaseSQLVulnerabilityAssessmentsSettingsClient.NewListByDatabasePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByDatabaseCreateRequest(ctx, resourceGroupName, serverName, databaseName, options)
			}, nil)
			if err != nil {
				return DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse{}, err
			}
			return client.listByDatabaseHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByDatabaseCreateRequest creates the ListByDatabase request.
func (client *DatabaseSQLVulnerabilityAssessmentsSettingsClient) listByDatabaseCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, options *DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDatabaseHandleResponse handles the ListByDatabase response.
func (client *DatabaseSQLVulnerabilityAssessmentsSettingsClient) listByDatabaseHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentListResult); err != nil {
		return DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse{}, err
	}
	return result, nil
}
