//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/streamanalytics/armstreamanalytics"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// InputsServer is a fake server for instances of the armstreamanalytics.InputsClient type.
type InputsServer struct {
	// CreateOrReplace is the fake for method InputsClient.CreateOrReplace
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrReplace func(ctx context.Context, resourceGroupName string, jobName string, inputName string, input armstreamanalytics.Input, options *armstreamanalytics.InputsClientCreateOrReplaceOptions) (resp azfake.Responder[armstreamanalytics.InputsClientCreateOrReplaceResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method InputsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, jobName string, inputName string, options *armstreamanalytics.InputsClientDeleteOptions) (resp azfake.Responder[armstreamanalytics.InputsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method InputsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, jobName string, inputName string, options *armstreamanalytics.InputsClientGetOptions) (resp azfake.Responder[armstreamanalytics.InputsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByStreamingJobPager is the fake for method InputsClient.NewListByStreamingJobPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByStreamingJobPager func(resourceGroupName string, jobName string, options *armstreamanalytics.InputsClientListByStreamingJobOptions) (resp azfake.PagerResponder[armstreamanalytics.InputsClientListByStreamingJobResponse])

	// BeginTest is the fake for method InputsClient.BeginTest
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTest func(ctx context.Context, resourceGroupName string, jobName string, inputName string, options *armstreamanalytics.InputsClientBeginTestOptions) (resp azfake.PollerResponder[armstreamanalytics.InputsClientTestResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method InputsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, jobName string, inputName string, input armstreamanalytics.Input, options *armstreamanalytics.InputsClientUpdateOptions) (resp azfake.Responder[armstreamanalytics.InputsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewInputsServerTransport creates a new instance of InputsServerTransport with the provided implementation.
// The returned InputsServerTransport instance is connected to an instance of armstreamanalytics.InputsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewInputsServerTransport(srv *InputsServer) *InputsServerTransport {
	return &InputsServerTransport{
		srv:                        srv,
		newListByStreamingJobPager: newTracker[azfake.PagerResponder[armstreamanalytics.InputsClientListByStreamingJobResponse]](),
		beginTest:                  newTracker[azfake.PollerResponder[armstreamanalytics.InputsClientTestResponse]](),
	}
}

// InputsServerTransport connects instances of armstreamanalytics.InputsClient to instances of InputsServer.
// Don't use this type directly, use NewInputsServerTransport instead.
type InputsServerTransport struct {
	srv                        *InputsServer
	newListByStreamingJobPager *tracker[azfake.PagerResponder[armstreamanalytics.InputsClientListByStreamingJobResponse]]
	beginTest                  *tracker[azfake.PollerResponder[armstreamanalytics.InputsClientTestResponse]]
}

// Do implements the policy.Transporter interface for InputsServerTransport.
func (i *InputsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "InputsClient.CreateOrReplace":
		resp, err = i.dispatchCreateOrReplace(req)
	case "InputsClient.Delete":
		resp, err = i.dispatchDelete(req)
	case "InputsClient.Get":
		resp, err = i.dispatchGet(req)
	case "InputsClient.NewListByStreamingJobPager":
		resp, err = i.dispatchNewListByStreamingJobPager(req)
	case "InputsClient.BeginTest":
		resp, err = i.dispatchBeginTest(req)
	case "InputsClient.Update":
		resp, err = i.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *InputsServerTransport) dispatchCreateOrReplace(req *http.Request) (*http.Response, error) {
	if i.srv.CreateOrReplace == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrReplace not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inputs/(?P<inputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.Input](req)
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	inputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inputName")])
	if err != nil {
		return nil, err
	}
	var options *armstreamanalytics.InputsClientCreateOrReplaceOptions
	if ifMatchParam != nil || ifNoneMatchParam != nil {
		options = &armstreamanalytics.InputsClientCreateOrReplaceOptions{
			IfMatch:     ifMatchParam,
			IfNoneMatch: ifNoneMatchParam,
		}
	}
	respr, errRespr := i.srv.CreateOrReplace(req.Context(), resourceGroupNameParam, jobNameParam, inputNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Input, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (i *InputsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if i.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inputs/(?P<inputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	inputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inputName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Delete(req.Context(), resourceGroupNameParam, jobNameParam, inputNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InputsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inputs/(?P<inputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	inputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inputName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, jobNameParam, inputNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Input, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (i *InputsServerTransport) dispatchNewListByStreamingJobPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByStreamingJobPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByStreamingJobPager not implemented")}
	}
	newListByStreamingJobPager := i.newListByStreamingJobPager.get(req)
	if newListByStreamingJobPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inputs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		var options *armstreamanalytics.InputsClientListByStreamingJobOptions
		if selectParam != nil {
			options = &armstreamanalytics.InputsClientListByStreamingJobOptions{
				Select: selectParam,
			}
		}
		resp := i.srv.NewListByStreamingJobPager(resourceGroupNameParam, jobNameParam, options)
		newListByStreamingJobPager = &resp
		i.newListByStreamingJobPager.add(req, newListByStreamingJobPager)
		server.PagerResponderInjectNextLinks(newListByStreamingJobPager, req, func(page *armstreamanalytics.InputsClientListByStreamingJobResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByStreamingJobPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByStreamingJobPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByStreamingJobPager) {
		i.newListByStreamingJobPager.remove(req)
	}
	return resp, nil
}

func (i *InputsServerTransport) dispatchBeginTest(req *http.Request) (*http.Response, error) {
	if i.srv.BeginTest == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTest not implemented")}
	}
	beginTest := i.beginTest.get(req)
	if beginTest == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inputs/(?P<inputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/test`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.Input](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		inputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inputName")])
		if err != nil {
			return nil, err
		}
		var options *armstreamanalytics.InputsClientBeginTestOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armstreamanalytics.InputsClientBeginTestOptions{
				Input: &body,
			}
		}
		respr, errRespr := i.srv.BeginTest(req.Context(), resourceGroupNameParam, jobNameParam, inputNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTest = &respr
		i.beginTest.add(req, beginTest)
	}

	resp, err := server.PollerResponderNext(beginTest, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginTest.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTest) {
		i.beginTest.remove(req)
	}

	return resp, nil
}

func (i *InputsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inputs/(?P<inputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.Input](req)
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	inputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inputName")])
	if err != nil {
		return nil, err
	}
	var options *armstreamanalytics.InputsClientUpdateOptions
	if ifMatchParam != nil {
		options = &armstreamanalytics.InputsClientUpdateOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := i.srv.Update(req.Context(), resourceGroupNameParam, jobNameParam, inputNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Input, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}
