// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

package videointelligence

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Human face detection.
	Feature_FACE_DETECTION Feature = 4
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
	// OCR text detection and tracking.
	Feature_TEXT_DETECTION Feature = 7
	// Object detection and tracking.
	Feature_OBJECT_TRACKING Feature = 9
	// Logo detection, tracking, and recognition.
	Feature_LOGO_RECOGNITION Feature = 12
	// Celebrity recognition.
	Feature_CELEBRITY_RECOGNITION Feature = 13
	// Person detection.
	Feature_PERSON_DETECTION Feature = 14
)

var Feature_name = map[int32]string{
	0:  "FEATURE_UNSPECIFIED",
	1:  "LABEL_DETECTION",
	2:  "SHOT_CHANGE_DETECTION",
	3:  "EXPLICIT_CONTENT_DETECTION",
	4:  "FACE_DETECTION",
	6:  "SPEECH_TRANSCRIPTION",
	7:  "TEXT_DETECTION",
	9:  "OBJECT_TRACKING",
	12: "LOGO_RECOGNITION",
	13: "CELEBRITY_RECOGNITION",
	14: "PERSON_DETECTION",
}

var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"FACE_DETECTION":             4,
	"SPEECH_TRANSCRIPTION":       6,
	"TEXT_DETECTION":             7,
	"OBJECT_TRACKING":            9,
	"LOGO_RECOGNITION":           12,
	"CELEBRITY_RECOGNITION":      13,
	"PERSON_DETECTION":           14,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}

func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}

var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}

func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{2}
}

// Streaming video annotation feature.
type StreamingFeature int32

const (
	// Unspecified.
	StreamingFeature_STREAMING_FEATURE_UNSPECIFIED StreamingFeature = 0
	// Label detection. Detect objects, such as dog or flower.
	StreamingFeature_STREAMING_LABEL_DETECTION StreamingFeature = 1
	// Shot change detection.
	StreamingFeature_STREAMING_SHOT_CHANGE_DETECTION StreamingFeature = 2
	// Explicit content detection.
	StreamingFeature_STREAMING_EXPLICIT_CONTENT_DETECTION StreamingFeature = 3
	// Object detection and tracking.
	StreamingFeature_STREAMING_OBJECT_TRACKING StreamingFeature = 4
	// Video classification based on AutoML model.
	StreamingFeature_STREAMING_AUTOML_CLASSIFICATION StreamingFeature = 21
	// Object detection and tracking based on AutoML model.
	StreamingFeature_STREAMING_AUTOML_OBJECT_TRACKING StreamingFeature = 22
)

var StreamingFeature_name = map[int32]string{
	0:  "STREAMING_FEATURE_UNSPECIFIED",
	1:  "STREAMING_LABEL_DETECTION",
	2:  "STREAMING_SHOT_CHANGE_DETECTION",
	3:  "STREAMING_EXPLICIT_CONTENT_DETECTION",
	4:  "STREAMING_OBJECT_TRACKING",
	21: "STREAMING_AUTOML_CLASSIFICATION",
	22: "STREAMING_AUTOML_OBJECT_TRACKING",
}

var StreamingFeature_value = map[string]int32{
	"STREAMING_FEATURE_UNSPECIFIED":        0,
	"STREAMING_LABEL_DETECTION":            1,
	"STREAMING_SHOT_CHANGE_DETECTION":      2,
	"STREAMING_EXPLICIT_CONTENT_DETECTION": 3,
	"STREAMING_OBJECT_TRACKING":            4,
	"STREAMING_AUTOML_CLASSIFICATION":      21,
	"STREAMING_AUTOML_OBJECT_TRACKING":     22,
}

func (x StreamingFeature) String() string {
	return proto.EnumName(StreamingFeature_name, int32(x))
}

func (StreamingFeature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{3}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](https://cloud.google.com/storage/docs/request-endpoints). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Required. Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1p3beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional. Location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](https://cloud.google.com/storage/docs/request-endpoints).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional. Cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{0}
}

func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(m, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for FACE_DETECTION.
	FaceDetectionConfig *FaceDetectionConfig `protobuf:"bytes,5,opt,name=face_detection_config,json=faceDetectionConfig,proto3" json:"face_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig,proto3" json:"speech_transcription_config,omitempty"`
	// Config for TEXT_DETECTION.
	TextDetectionConfig *TextDetectionConfig `protobuf:"bytes,8,opt,name=text_detection_config,json=textDetectionConfig,proto3" json:"text_detection_config,omitempty"`
	// Config for PERSON_DETECTION.
	PersonDetectionConfig *PersonDetectionConfig `protobuf:"bytes,11,opt,name=person_detection_config,json=personDetectionConfig,proto3" json:"person_detection_config,omitempty"`
	// Config for OBJECT_TRACKING.
	ObjectTrackingConfig *ObjectTrackingConfig `protobuf:"bytes,13,opt,name=object_tracking_config,json=objectTrackingConfig,proto3" json:"object_tracking_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{1}
}

func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (m *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(m, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetFaceDetectionConfig() *FaceDetectionConfig {
	if m != nil {
		return m.FaceDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if m != nil {
		return m.SpeechTranscriptionConfig
	}
	return nil
}

func (m *VideoContext) GetTextDetectionConfig() *TextDetectionConfig {
	if m != nil {
		return m.TextDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetPersonDetectionConfig() *PersonDetectionConfig {
	if m != nil {
		return m.PersonDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetObjectTrackingConfig() *ObjectTrackingConfig {
	if m != nil {
		return m.ObjectTrackingConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1p3beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// The confidence threshold we perform filtering on the labels from
	// frame-level detection. If not set, it is set to 0.4 by default. The valid
	// range for this threshold is [0.1, 0.9]. Any value set outside of this
	// range will be clipped.
	// Note: for best results please follow the default threshold. We will update
	// the default threshold everytime when we release a new model.
	FrameConfidenceThreshold float32 `protobuf:"fixed32,4,opt,name=frame_confidence_threshold,json=frameConfidenceThreshold,proto3" json:"frame_confidence_threshold,omitempty"`
	// The confidence threshold we perform filtering on the labels from
	// video-level and shot-level detections. If not set, it is set to 0.3 by
	// default. The valid range for this threshold is [0.1, 0.9]. Any value set
	// outside of this range will be clipped.
	// Note: for best results please follow the default threshold. We will update
	// the default threshold everytime when we release a new model.
	VideoConfidenceThreshold float32  `protobuf:"fixed32,5,opt,name=video_confidence_threshold,json=videoConfidenceThreshold,proto3" json:"video_confidence_threshold,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{2}
}

func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (m *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(m, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *LabelDetectionConfig) GetFrameConfidenceThreshold() float32 {
	if m != nil {
		return m.FrameConfidenceThreshold
	}
	return 0
}

func (m *LabelDetectionConfig) GetVideoConfidenceThreshold() float32 {
	if m != nil {
		return m.VideoConfidenceThreshold
	}
	return 0
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{3}
}

func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(m, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for OBJECT_TRACKING.
type ObjectTrackingConfig struct {
	// Model to use for object tracking.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ObjectTrackingConfig) Reset()         { *m = ObjectTrackingConfig{} }
func (m *ObjectTrackingConfig) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingConfig) ProtoMessage()    {}
func (*ObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{4}
}

func (m *ObjectTrackingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingConfig.Unmarshal(m, b)
}
func (m *ObjectTrackingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingConfig.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingConfig.Merge(m, src)
}
func (m *ObjectTrackingConfig) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingConfig.Size(m)
}
func (m *ObjectTrackingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingConfig proto.InternalMessageInfo

func (m *ObjectTrackingConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{5}
}

func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(m, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for FACE_DETECTION.
type FaceDetectionConfig struct {
	// Model to use for face detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Whether bounding boxes be included in the face annotation output.
	IncludeBoundingBoxes bool `protobuf:"varint,2,opt,name=include_bounding_boxes,json=includeBoundingBoxes,proto3" json:"include_bounding_boxes,omitempty"`
	// Whether to enable face attributes detection, such as glasses, dark_glasses,
	// mouth_open etc. Ignored if 'include_bounding_boxes' is false.
	IncludeAttributes    bool     `protobuf:"varint,5,opt,name=include_attributes,json=includeAttributes,proto3" json:"include_attributes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaceDetectionConfig) Reset()         { *m = FaceDetectionConfig{} }
func (m *FaceDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*FaceDetectionConfig) ProtoMessage()    {}
func (*FaceDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{6}
}

func (m *FaceDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceDetectionConfig.Unmarshal(m, b)
}
func (m *FaceDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceDetectionConfig.Marshal(b, m, deterministic)
}
func (m *FaceDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceDetectionConfig.Merge(m, src)
}
func (m *FaceDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_FaceDetectionConfig.Size(m)
}
func (m *FaceDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FaceDetectionConfig proto.InternalMessageInfo

func (m *FaceDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *FaceDetectionConfig) GetIncludeBoundingBoxes() bool {
	if m != nil {
		return m.IncludeBoundingBoxes
	}
	return false
}

func (m *FaceDetectionConfig) GetIncludeAttributes() bool {
	if m != nil {
		return m.IncludeAttributes
	}
	return false
}

// Config for PERSON_DETECTION.
type PersonDetectionConfig struct {
	// Whether bounding boxes be included in the person detection annotation
	// output.
	IncludeBoundingBoxes bool `protobuf:"varint,1,opt,name=include_bounding_boxes,json=includeBoundingBoxes,proto3" json:"include_bounding_boxes,omitempty"`
	// Whether to enable pose landmarks detection. Ignored if
	// 'include_bounding_boxes' is false.
	IncludePoseLandmarks bool `protobuf:"varint,2,opt,name=include_pose_landmarks,json=includePoseLandmarks,proto3" json:"include_pose_landmarks,omitempty"`
	// Whether to enable person attributes detection, such as cloth color (black,
	// blue, etc), type (coat, dress, etc), pattern (plain, floral, etc), hair
	// color (black, blonde, etc), hair length (long, short, bald), etc.
	// Ignored if 'include_bounding_boxes' is false.
	IncludeAttributes    bool     `protobuf:"varint,3,opt,name=include_attributes,json=includeAttributes,proto3" json:"include_attributes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PersonDetectionConfig) Reset()         { *m = PersonDetectionConfig{} }
func (m *PersonDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*PersonDetectionConfig) ProtoMessage()    {}
func (*PersonDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{7}
}

func (m *PersonDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PersonDetectionConfig.Unmarshal(m, b)
}
func (m *PersonDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PersonDetectionConfig.Marshal(b, m, deterministic)
}
func (m *PersonDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersonDetectionConfig.Merge(m, src)
}
func (m *PersonDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_PersonDetectionConfig.Size(m)
}
func (m *PersonDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PersonDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PersonDetectionConfig proto.InternalMessageInfo

func (m *PersonDetectionConfig) GetIncludeBoundingBoxes() bool {
	if m != nil {
		return m.IncludeBoundingBoxes
	}
	return false
}

func (m *PersonDetectionConfig) GetIncludePoseLandmarks() bool {
	if m != nil {
		return m.IncludePoseLandmarks
	}
	return false
}

func (m *PersonDetectionConfig) GetIncludeAttributes() bool {
	if m != nil {
		return m.IncludeAttributes
	}
	return false
}

// Config for TEXT_DETECTION.
type TextDetectionConfig struct {
	// Language hint can be specified if the language to be detected is known a
	// priori. It can increase the accuracy of the detection. Language hint must
	// be language code in BCP-47 format.
	//
	// Automatic language detection is performed if no hint is provided.
	LanguageHints []string `protobuf:"bytes,1,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	// Model to use for text detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextDetectionConfig) Reset()         { *m = TextDetectionConfig{} }
func (m *TextDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*TextDetectionConfig) ProtoMessage()    {}
func (*TextDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{8}
}

func (m *TextDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextDetectionConfig.Unmarshal(m, b)
}
func (m *TextDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextDetectionConfig.Marshal(b, m, deterministic)
}
func (m *TextDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextDetectionConfig.Merge(m, src)
}
func (m *TextDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_TextDetectionConfig.Size(m)
}
func (m *TextDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TextDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TextDetectionConfig proto.InternalMessageInfo

func (m *TextDetectionConfig) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

func (m *TextDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{9}
}

func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (m *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(m, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{10}
}

func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (m *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(m, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{11}
}

func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (m *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(m, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{12}
}

func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{13}
}

func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (m *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(m, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1p3beta1.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{14}
}

func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (m *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(m, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{15}
}

func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (m *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(m, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom               float32  `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedBoundingBox) Reset()         { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()    {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{16}
}

func (m *NormalizedBoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingBox.Unmarshal(m, b)
}
func (m *NormalizedBoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingBox.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingBox.Merge(m, src)
}
func (m *NormalizedBoundingBox) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingBox.Size(m)
}
func (m *NormalizedBoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingBox proto.InternalMessageInfo

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// For tracking related features.
// An object at time_offset with attributes, and located with
// normalized_bounding_box.
type TimestampedObject struct {
	// Normalized Bounding box in a frame, where the object is located.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this object.
	TimeOffset *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Optional. The attributes of the object in the bounding box.
	Attributes []*DetectedAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// Optional. The detected landmarks.
	Landmarks            []*DetectedLandmark `protobuf:"bytes,4,rep,name=landmarks,proto3" json:"landmarks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *TimestampedObject) Reset()         { *m = TimestampedObject{} }
func (m *TimestampedObject) String() string { return proto.CompactTextString(m) }
func (*TimestampedObject) ProtoMessage()    {}
func (*TimestampedObject) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{17}
}

func (m *TimestampedObject) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampedObject.Unmarshal(m, b)
}
func (m *TimestampedObject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampedObject.Marshal(b, m, deterministic)
}
func (m *TimestampedObject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampedObject.Merge(m, src)
}
func (m *TimestampedObject) XXX_Size() int {
	return xxx_messageInfo_TimestampedObject.Size(m)
}
func (m *TimestampedObject) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampedObject.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampedObject proto.InternalMessageInfo

func (m *TimestampedObject) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBox
	}
	return nil
}

func (m *TimestampedObject) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *TimestampedObject) GetAttributes() []*DetectedAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *TimestampedObject) GetLandmarks() []*DetectedLandmark {
	if m != nil {
		return m.Landmarks
	}
	return nil
}

// A track of an object instance.
type Track struct {
	// Video segment of a track.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// The object with timestamp and attributes per frame in the track.
	TimestampedObjects []*TimestampedObject `protobuf:"bytes,2,rep,name=timestamped_objects,json=timestampedObjects,proto3" json:"timestamped_objects,omitempty"`
	// Optional. Attributes in the track level.
	Attributes []*DetectedAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// Optional. The confidence score of the tracked object.
	Confidence           float32  `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Track) Reset()         { *m = Track{} }
func (m *Track) String() string { return proto.CompactTextString(m) }
func (*Track) ProtoMessage()    {}
func (*Track) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{18}
}

func (m *Track) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Track.Unmarshal(m, b)
}
func (m *Track) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Track.Marshal(b, m, deterministic)
}
func (m *Track) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Track.Merge(m, src)
}
func (m *Track) XXX_Size() int {
	return xxx_messageInfo_Track.Size(m)
}
func (m *Track) XXX_DiscardUnknown() {
	xxx_messageInfo_Track.DiscardUnknown(m)
}

var xxx_messageInfo_Track proto.InternalMessageInfo

func (m *Track) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *Track) GetTimestampedObjects() []*TimestampedObject {
	if m != nil {
		return m.TimestampedObjects
	}
	return nil
}

func (m *Track) GetAttributes() []*DetectedAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Track) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// A generic detected attribute represented by name in string format.
type DetectedAttribute struct {
	// The name of the attribute, i.e. glasses, dark_glasses, mouth_open etc.
	// A full list of supported type names will be provided in the document.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Detected attribute confidence. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Text value of the detection result. For example, the value for "HairColor"
	// can be "black", "blonde", etc.
	Value                string   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectedAttribute) Reset()         { *m = DetectedAttribute{} }
func (m *DetectedAttribute) String() string { return proto.CompactTextString(m) }
func (*DetectedAttribute) ProtoMessage()    {}
func (*DetectedAttribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{19}
}

func (m *DetectedAttribute) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectedAttribute.Unmarshal(m, b)
}
func (m *DetectedAttribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectedAttribute.Marshal(b, m, deterministic)
}
func (m *DetectedAttribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectedAttribute.Merge(m, src)
}
func (m *DetectedAttribute) XXX_Size() int {
	return xxx_messageInfo_DetectedAttribute.Size(m)
}
func (m *DetectedAttribute) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectedAttribute.DiscardUnknown(m)
}

var xxx_messageInfo_DetectedAttribute proto.InternalMessageInfo

func (m *DetectedAttribute) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DetectedAttribute) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *DetectedAttribute) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Celebrity definition.
type Celebrity struct {
	// The resource name of the celebrity. Have the format
	// `video-intelligence/kg-mid` indicates a celebrity from preloaded gallery.
	// kg-mid is the id in Google knowledge graph, which is unique for the
	// celebrity.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The celebrity name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Textual description of additional information about the celebrity, if
	// applicable.
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Celebrity) Reset()         { *m = Celebrity{} }
func (m *Celebrity) String() string { return proto.CompactTextString(m) }
func (*Celebrity) ProtoMessage()    {}
func (*Celebrity) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{20}
}

func (m *Celebrity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Celebrity.Unmarshal(m, b)
}
func (m *Celebrity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Celebrity.Marshal(b, m, deterministic)
}
func (m *Celebrity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Celebrity.Merge(m, src)
}
func (m *Celebrity) XXX_Size() int {
	return xxx_messageInfo_Celebrity.Size(m)
}
func (m *Celebrity) XXX_DiscardUnknown() {
	xxx_messageInfo_Celebrity.DiscardUnknown(m)
}

var xxx_messageInfo_Celebrity proto.InternalMessageInfo

func (m *Celebrity) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Celebrity) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Celebrity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// The annotation result of a celebrity face track. RecognizedCelebrity field
// could be empty if the face track does not have any matched celebrities.
type CelebrityTrack struct {
	// Top N match of the celebrities for the face in this track.
	Celebrities []*CelebrityTrack_RecognizedCelebrity `protobuf:"bytes,1,rep,name=celebrities,proto3" json:"celebrities,omitempty"`
	// A track of a person's face.
	FaceTrack            *Track   `protobuf:"bytes,3,opt,name=face_track,json=faceTrack,proto3" json:"face_track,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CelebrityTrack) Reset()         { *m = CelebrityTrack{} }
func (m *CelebrityTrack) String() string { return proto.CompactTextString(m) }
func (*CelebrityTrack) ProtoMessage()    {}
func (*CelebrityTrack) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{21}
}

func (m *CelebrityTrack) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CelebrityTrack.Unmarshal(m, b)
}
func (m *CelebrityTrack) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CelebrityTrack.Marshal(b, m, deterministic)
}
func (m *CelebrityTrack) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CelebrityTrack.Merge(m, src)
}
func (m *CelebrityTrack) XXX_Size() int {
	return xxx_messageInfo_CelebrityTrack.Size(m)
}
func (m *CelebrityTrack) XXX_DiscardUnknown() {
	xxx_messageInfo_CelebrityTrack.DiscardUnknown(m)
}

var xxx_messageInfo_CelebrityTrack proto.InternalMessageInfo

func (m *CelebrityTrack) GetCelebrities() []*CelebrityTrack_RecognizedCelebrity {
	if m != nil {
		return m.Celebrities
	}
	return nil
}

func (m *CelebrityTrack) GetFaceTrack() *Track {
	if m != nil {
		return m.FaceTrack
	}
	return nil
}

// The recognized celebrity with confidence score.
type CelebrityTrack_RecognizedCelebrity struct {
	// The recognized celebrity.
	Celebrity *Celebrity `protobuf:"bytes,1,opt,name=celebrity,proto3" json:"celebrity,omitempty"`
	// Recognition confidence. Range [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CelebrityTrack_RecognizedCelebrity) Reset()         { *m = CelebrityTrack_RecognizedCelebrity{} }
func (m *CelebrityTrack_RecognizedCelebrity) String() string { return proto.CompactTextString(m) }
func (*CelebrityTrack_RecognizedCelebrity) ProtoMessage()    {}
func (*CelebrityTrack_RecognizedCelebrity) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{21, 0}
}

func (m *CelebrityTrack_RecognizedCelebrity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.Unmarshal(m, b)
}
func (m *CelebrityTrack_RecognizedCelebrity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.Marshal(b, m, deterministic)
}
func (m *CelebrityTrack_RecognizedCelebrity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.Merge(m, src)
}
func (m *CelebrityTrack_RecognizedCelebrity) XXX_Size() int {
	return xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.Size(m)
}
func (m *CelebrityTrack_RecognizedCelebrity) XXX_DiscardUnknown() {
	xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.DiscardUnknown(m)
}

var xxx_messageInfo_CelebrityTrack_RecognizedCelebrity proto.InternalMessageInfo

func (m *CelebrityTrack_RecognizedCelebrity) GetCelebrity() *Celebrity {
	if m != nil {
		return m.Celebrity
	}
	return nil
}

func (m *CelebrityTrack_RecognizedCelebrity) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Celebrity recognition annotation per video.
type CelebrityRecognitionAnnotation struct {
	// The tracks detected from the input video, including recognized celebrities
	// and other detected faces in the video.
	CelebrityTracks      []*CelebrityTrack `protobuf:"bytes,1,rep,name=celebrity_tracks,json=celebrityTracks,proto3" json:"celebrity_tracks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CelebrityRecognitionAnnotation) Reset()         { *m = CelebrityRecognitionAnnotation{} }
func (m *CelebrityRecognitionAnnotation) String() string { return proto.CompactTextString(m) }
func (*CelebrityRecognitionAnnotation) ProtoMessage()    {}
func (*CelebrityRecognitionAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{22}
}

func (m *CelebrityRecognitionAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CelebrityRecognitionAnnotation.Unmarshal(m, b)
}
func (m *CelebrityRecognitionAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CelebrityRecognitionAnnotation.Marshal(b, m, deterministic)
}
func (m *CelebrityRecognitionAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CelebrityRecognitionAnnotation.Merge(m, src)
}
func (m *CelebrityRecognitionAnnotation) XXX_Size() int {
	return xxx_messageInfo_CelebrityRecognitionAnnotation.Size(m)
}
func (m *CelebrityRecognitionAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_CelebrityRecognitionAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_CelebrityRecognitionAnnotation proto.InternalMessageInfo

func (m *CelebrityRecognitionAnnotation) GetCelebrityTracks() []*CelebrityTrack {
	if m != nil {
		return m.CelebrityTracks
	}
	return nil
}

// A generic detected landmark represented by name in string format and a 2D
// location.
type DetectedLandmark struct {
	// The name of this landmark, i.e. left_hand, right_shoulder.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The 2D point of the detected landmark using the normalized image
	// coordindate system. The normalized coordinates have the range from 0 to 1.
	Point *NormalizedVertex `protobuf:"bytes,2,opt,name=point,proto3" json:"point,omitempty"`
	// The confidence score of the detected landmark. Range [0, 1].
	Confidence           float32  `protobuf:"fixed32,3,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectedLandmark) Reset()         { *m = DetectedLandmark{} }
func (m *DetectedLandmark) String() string { return proto.CompactTextString(m) }
func (*DetectedLandmark) ProtoMessage()    {}
func (*DetectedLandmark) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{23}
}

func (m *DetectedLandmark) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectedLandmark.Unmarshal(m, b)
}
func (m *DetectedLandmark) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectedLandmark.Marshal(b, m, deterministic)
}
func (m *DetectedLandmark) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectedLandmark.Merge(m, src)
}
func (m *DetectedLandmark) XXX_Size() int {
	return xxx_messageInfo_DetectedLandmark.Size(m)
}
func (m *DetectedLandmark) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectedLandmark.DiscardUnknown(m)
}

var xxx_messageInfo_DetectedLandmark proto.InternalMessageInfo

func (m *DetectedLandmark) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DetectedLandmark) GetPoint() *NormalizedVertex {
	if m != nil {
		return m.Point
	}
	return nil
}

func (m *DetectedLandmark) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Face detection annotation.
type FaceDetectionAnnotation struct {
	// The face tracks with attributes.
	Tracks []*Track `protobuf:"bytes,3,rep,name=tracks,proto3" json:"tracks,omitempty"`
	// The thumbnail of a person's face.
	Thumbnail            []byte   `protobuf:"bytes,4,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaceDetectionAnnotation) Reset()         { *m = FaceDetectionAnnotation{} }
func (m *FaceDetectionAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceDetectionAnnotation) ProtoMessage()    {}
func (*FaceDetectionAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{24}
}

func (m *FaceDetectionAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceDetectionAnnotation.Unmarshal(m, b)
}
func (m *FaceDetectionAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceDetectionAnnotation.Marshal(b, m, deterministic)
}
func (m *FaceDetectionAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceDetectionAnnotation.Merge(m, src)
}
func (m *FaceDetectionAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceDetectionAnnotation.Size(m)
}
func (m *FaceDetectionAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceDetectionAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceDetectionAnnotation proto.InternalMessageInfo

func (m *FaceDetectionAnnotation) GetTracks() []*Track {
	if m != nil {
		return m.Tracks
	}
	return nil
}

func (m *FaceDetectionAnnotation) GetThumbnail() []byte {
	if m != nil {
		return m.Thumbnail
	}
	return nil
}

// Person detection annotation per video.
type PersonDetectionAnnotation struct {
	// The trackes that a person is detected.
	Tracks               []*Track `protobuf:"bytes,1,rep,name=tracks,proto3" json:"tracks,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PersonDetectionAnnotation) Reset()         { *m = PersonDetectionAnnotation{} }
func (m *PersonDetectionAnnotation) String() string { return proto.CompactTextString(m) }
func (*PersonDetectionAnnotation) ProtoMessage()    {}
func (*PersonDetectionAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{25}
}

func (m *PersonDetectionAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PersonDetectionAnnotation.Unmarshal(m, b)
}
func (m *PersonDetectionAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PersonDetectionAnnotation.Marshal(b, m, deterministic)
}
func (m *PersonDetectionAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersonDetectionAnnotation.Merge(m, src)
}
func (m *PersonDetectionAnnotation) XXX_Size() int {
	return xxx_messageInfo_PersonDetectionAnnotation.Size(m)
}
func (m *PersonDetectionAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_PersonDetectionAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_PersonDetectionAnnotation proto.InternalMessageInfo

func (m *PersonDetectionAnnotation) GetTracks() []*Track {
	if m != nil {
		return m.Tracks
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Video segment on which the annotation is run.
	Segment *VideoSegment `protobuf:"bytes,10,opt,name=segment,proto3" json:"segment,omitempty"`
	// Topical label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Presence label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label. Compared to the
	// existing topical `segment_label_annotations`, this field presents more
	// fine-grained, segment-level labels detected in video content and is made
	// available only when the client sets `LabelDetectionConfig.model` to
	// "builtin/latest" in the request.
	SegmentPresenceLabelAnnotations []*LabelAnnotation `protobuf:"bytes,23,rep,name=segment_presence_label_annotations,json=segmentPresenceLabelAnnotations,proto3" json:"segment_presence_label_annotations,omitempty"`
	// Topical label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Presence label annotations on shot level. There is exactly one element for
	// each unique label. Compared to the existing topical
	// `shot_label_annotations`, this field presents more fine-grained, shot-level
	// labels detected in video content and is made available only when the client
	// sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
	ShotPresenceLabelAnnotations []*LabelAnnotation `protobuf:"bytes,24,rep,name=shot_presence_label_annotations,json=shotPresenceLabelAnnotations,proto3" json:"shot_presence_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Face detection annotations.
	FaceDetectionAnnotations []*FaceDetectionAnnotation `protobuf:"bytes,13,rep,name=face_detection_annotations,json=faceDetectionAnnotations,proto3" json:"face_detection_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions,proto3" json:"speech_transcriptions,omitempty"`
	// OCR text detection and tracking.
	// Annotations for list of detected text snippets. Each will have list of
	// frame information associated with it.
	TextAnnotations []*TextAnnotation `protobuf:"bytes,12,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// Annotations for list of objects detected and tracked in video.
	ObjectAnnotations []*ObjectTrackingAnnotation `protobuf:"bytes,14,rep,name=object_annotations,json=objectAnnotations,proto3" json:"object_annotations,omitempty"`
	// Annotations for list of logos detected, tracked and recognized in video.
	LogoRecognitionAnnotations []*LogoRecognitionAnnotation `protobuf:"bytes,19,rep,name=logo_recognition_annotations,json=logoRecognitionAnnotations,proto3" json:"logo_recognition_annotations,omitempty"`
	// Person detection annotations.
	PersonDetectionAnnotations []*PersonDetectionAnnotation `protobuf:"bytes,20,rep,name=person_detection_annotations,json=personDetectionAnnotations,proto3" json:"person_detection_annotations,omitempty"`
	// Celebrity recognition annotations.
	CelebrityRecognitionAnnotations *CelebrityRecognitionAnnotation `protobuf:"bytes,21,opt,name=celebrity_recognition_annotations,json=celebrityRecognitionAnnotations,proto3" json:"celebrity_recognition_annotations,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{26}
}

func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(m, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetSegmentPresenceLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentPresenceLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotPresenceLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotPresenceLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceDetectionAnnotations() []*FaceDetectionAnnotation {
	if m != nil {
		return m.FaceDetectionAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if m != nil {
		return m.SpeechTranscriptions
	}
	return nil
}

func (m *VideoAnnotationResults) GetTextAnnotations() []*TextAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetObjectAnnotations() []*ObjectTrackingAnnotation {
	if m != nil {
		return m.ObjectAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetLogoRecognitionAnnotations() []*LogoRecognitionAnnotation {
	if m != nil {
		return m.LogoRecognitionAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetPersonDetectionAnnotations() []*PersonDetectionAnnotation {
	if m != nil {
		return m.PersonDetectionAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetCelebrityRecognitionAnnotations() *CelebrityRecognitionAnnotation {
	if m != nil {
		return m.CelebrityRecognitionAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{27}
}

func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(m, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Specifies which feature is being tracked if the request contains more than
	// one features.
	Feature Feature `protobuf:"varint,5,opt,name=feature,proto3,enum=google.cloud.videointelligence.v1p3beta1.Feature" json:"feature,omitempty"`
	// Specifies which segment is being tracked if the request contains more than
	// one segments.
	Segment              *VideoSegment `protobuf:"bytes,6,opt,name=segment,proto3" json:"segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{28}
}

func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(m, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetFeature() Feature {
	if m != nil {
		return m.Feature
	}
	return Feature_FEATURE_UNSPECIFIED
}

func (m *VideoAnnotationProgress) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{29}
}

func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(m, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	// Required. *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechTranscription`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// Optional. If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity,proto3" json:"filter_profanity,omitempty"`
	// Optional. A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// Optional. If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all. The default 'false' value
	// does not add punctuation to result hypotheses. NOTE: "This is currently
	// offered as an experimental service, complimentary to all users. In the
	// future this may be exclusively available as a premium feature."
	EnableAutomaticPunctuation bool `protobuf:"varint,5,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// Optional. For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks []int32 `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks,proto3" json:"audio_tracks,omitempty"`
	// Optional. If 'true', enables speaker detection for each recognized word in
	// the top alternative of the recognition result using a speaker_tag provided
	// in the WordInfo.
	// Note: When this is true, we send all the words from the beginning of the
	// audio for the top alternative in every consecutive responses.
	// This is done in order to improve our speaker tags as our models learn to
	// identify the speakers in the conversation over time.
	EnableSpeakerDiarization bool `protobuf:"varint,7,opt,name=enable_speaker_diarization,json=enableSpeakerDiarization,proto3" json:"enable_speaker_diarization,omitempty"`
	// Optional. If set, specifies the estimated number of speakers in the
	// conversation. If not set, defaults to '2'. Ignored unless
	// enable_speaker_diarization is set to true.
	DiarizationSpeakerCount int32 `protobuf:"varint,8,opt,name=diarization_speaker_count,json=diarizationSpeakerCount,proto3" json:"diarization_speaker_count,omitempty"`
	// Optional. If `true`, the top result includes a list of words and the
	// confidence for those words. If `false`, no word-level confidence
	// information is returned. The default is `false`.
	EnableWordConfidence bool     `protobuf:"varint,9,opt,name=enable_word_confidence,json=enableWordConfidence,proto3" json:"enable_word_confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscriptionConfig) Reset()         { *m = SpeechTranscriptionConfig{} }
func (m *SpeechTranscriptionConfig) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscriptionConfig) ProtoMessage()    {}
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{30}
}

func (m *SpeechTranscriptionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscriptionConfig.Unmarshal(m, b)
}
func (m *SpeechTranscriptionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscriptionConfig.Marshal(b, m, deterministic)
}
func (m *SpeechTranscriptionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscriptionConfig.Merge(m, src)
}
func (m *SpeechTranscriptionConfig) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscriptionConfig.Size(m)
}
func (m *SpeechTranscriptionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscriptionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscriptionConfig proto.InternalMessageInfo

func (m *SpeechTranscriptionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if m != nil {
		return m.FilterProfanity
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableAutomaticPunctuation() bool {
	if m != nil {
		return m.EnableAutomaticPunctuation
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if m != nil {
		return m.AudioTracks
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableSpeakerDiarization() bool {
	if m != nil {
		return m.EnableSpeakerDiarization
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetDiarizationSpeakerCount() int32 {
	if m != nil {
		return m.DiarizationSpeakerCount
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetEnableWordConfidence() bool {
	if m != nil {
		return m.EnableWordConfidence
	}
	return false
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// Optional. A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases              []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechContext) Reset()         { *m = SpeechContext{} }
func (m *SpeechContext) String() string { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()    {}
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{31}
}

func (m *SpeechContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechContext.Unmarshal(m, b)
}
func (m *SpeechContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechContext.Marshal(b, m, deterministic)
}
func (m *SpeechContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechContext.Merge(m, src)
}
func (m *SpeechContext) XXX_Size() int {
	return xxx_messageInfo_SpeechContext.Size(m)
}
func (m *SpeechContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechContext.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechContext proto.InternalMessageInfo

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	// May contain one or more recognition hypotheses (up to the maximum specified
	// in `max_alternatives`).  These alternatives are ordered in terms of
	// accuracy, with the top (first) alternative being the most probable, as
	// ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag of the language in this result. This language code was
	// detected to have the most likelihood of being spoken in the audio.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscription) Reset()         { *m = SpeechTranscription{} }
func (m *SpeechTranscription) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscription) ProtoMessage()    {}
func (*SpeechTranscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{32}
}

func (m *SpeechTranscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscription.Unmarshal(m, b)
}
func (m *SpeechTranscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscription.Marshal(b, m, deterministic)
}
func (m *SpeechTranscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscription.Merge(m, src)
}
func (m *SpeechTranscription) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscription.Size(m)
}
func (m *SpeechTranscription) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscription.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscription proto.InternalMessageInfo

func (m *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

func (m *SpeechTranscription) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	// Note: When `enable_speaker_diarization` is true, you will see all the words
	// from the beginning of the audio.
	Words                []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SpeechRecognitionAlternative) Reset()         { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()    {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{33}
}

func (m *SpeechRecognitionAlternative) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionAlternative.Unmarshal(m, b)
}
func (m *SpeechRecognitionAlternative) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionAlternative.Marshal(b, m, deterministic)
}
func (m *SpeechRecognitionAlternative) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionAlternative.Merge(m, src)
}
func (m *SpeechRecognitionAlternative) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionAlternative.Size(m)
}
func (m *SpeechRecognitionAlternative) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionAlternative.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionAlternative proto.InternalMessageInfo

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	// Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *duration.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *duration.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A distinct integer value is assigned for every speaker within
	// the audio. This field specifies which one of those speakers was detected to
	// have spoken this word. Value ranges from 1 up to diarization_speaker_count,
	// and is only set if speaker diarization is enabled.
	SpeakerTag           int32    `protobuf:"varint,5,opt,name=speaker_tag,json=speakerTag,proto3" json:"speaker_tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WordInfo) Reset()         { *m = WordInfo{} }
func (m *WordInfo) String() string { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()    {}
func (*WordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{34}
}

func (m *WordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WordInfo.Unmarshal(m, b)
}
func (m *WordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WordInfo.Marshal(b, m, deterministic)
}
func (m *WordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WordInfo.Merge(m, src)
}
func (m *WordInfo) XXX_Size() int {
	return xxx_messageInfo_WordInfo.Size(m)
}
func (m *WordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WordInfo proto.InternalMessageInfo

func (m *WordInfo) GetStartTime() *duration.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *duration.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func (m *WordInfo) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *WordInfo) GetSpeakerTag() int32 {
	if m != nil {
		return m.SpeakerTag
	}
	return 0
}

// A vertex represents a 2D point in the image.
// NOTE: the normalized vertex coordinates are relative to the original image
// and range from 0 to 1.
type NormalizedVertex struct {
	// X coordinate.
	X float32 `protobuf:"fixed32,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y                    float32  `protobuf:"fixed32,2,opt,name=y,proto3" json:"y,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedVertex) Reset()         { *m = NormalizedVertex{} }
func (m *NormalizedVertex) String() string { return proto.CompactTextString(m) }
func (*NormalizedVertex) ProtoMessage()    {}
func (*NormalizedVertex) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{35}
}

func (m *NormalizedVertex) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedVertex.Unmarshal(m, b)
}
func (m *NormalizedVertex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedVertex.Marshal(b, m, deterministic)
}
func (m *NormalizedVertex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedVertex.Merge(m, src)
}
func (m *NormalizedVertex) XXX_Size() int {
	return xxx_messageInfo_NormalizedVertex.Size(m)
}
func (m *NormalizedVertex) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedVertex.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedVertex proto.InternalMessageInfo

func (m *NormalizedVertex) GetX() float32 {
	if m != nil {
		return m.X
	}
	return 0
}

func (m *NormalizedVertex) GetY() float32 {
	if m != nil {
		return m.Y
	}
	return 0
}

// Normalized bounding polygon for text (that might not be aligned with axis).
// Contains list of the corner points in clockwise order starting from
// top-left corner. For example, for a rectangular bounding box:
// When the text is horizontal it might look like:
//         0----1
//         |    |
//         3----2
//
// When it's clockwise rotated 180 degrees around the top-left corner it
// becomes:
//         2----3
//         |    |
//         1----0
//
// and the vertex order will still be (0, 1, 2, 3). Note that values can be less
// than 0, or greater than 1 due to trignometric calculations for location of
// the box.
type NormalizedBoundingPoly struct {
	// Normalized vertices of the bounding polygon.
	Vertices             []*NormalizedVertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NormalizedBoundingPoly) Reset()         { *m = NormalizedBoundingPoly{} }
func (m *NormalizedBoundingPoly) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingPoly) ProtoMessage()    {}
func (*NormalizedBoundingPoly) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{36}
}

func (m *NormalizedBoundingPoly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingPoly.Unmarshal(m, b)
}
func (m *NormalizedBoundingPoly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingPoly.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingPoly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingPoly.Merge(m, src)
}
func (m *NormalizedBoundingPoly) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingPoly.Size(m)
}
func (m *NormalizedBoundingPoly) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingPoly.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingPoly proto.InternalMessageInfo

func (m *NormalizedBoundingPoly) GetVertices() []*NormalizedVertex {
	if m != nil {
		return m.Vertices
	}
	return nil
}

// Video segment level annotation results for text detection.
type TextSegment struct {
	// Video segment where a text snippet was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence for the track of detected text. It is calculated as the highest
	// over all frames where OCR detected text appears.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information related to the frames where OCR detected text appears.
	Frames               []*TextFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *TextSegment) Reset()         { *m = TextSegment{} }
func (m *TextSegment) String() string { return proto.CompactTextString(m) }
func (*TextSegment) ProtoMessage()    {}
func (*TextSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{37}
}

func (m *TextSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextSegment.Unmarshal(m, b)
}
func (m *TextSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextSegment.Marshal(b, m, deterministic)
}
func (m *TextSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextSegment.Merge(m, src)
}
func (m *TextSegment) XXX_Size() int {
	return xxx_messageInfo_TextSegment.Size(m)
}
func (m *TextSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_TextSegment.DiscardUnknown(m)
}

var xxx_messageInfo_TextSegment proto.InternalMessageInfo

func (m *TextSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *TextSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *TextSegment) GetFrames() []*TextFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for text annotation (OCR).
// Contains information regarding timestamp and bounding box locations for the
// frames containing detected OCR text snippets.
type TextFrame struct {
	// Bounding polygon of the detected text for this frame.
	RotatedBoundingBox *NormalizedBoundingPoly `protobuf:"bytes,1,opt,name=rotated_bounding_box,json=rotatedBoundingBox,proto3" json:"rotated_bounding_box,omitempty"`
	// Timestamp of this frame.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TextFrame) Reset()         { *m = TextFrame{} }
func (m *TextFrame) String() string { return proto.CompactTextString(m) }
func (*TextFrame) ProtoMessage()    {}
func (*TextFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{38}
}

func (m *TextFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextFrame.Unmarshal(m, b)
}
func (m *TextFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextFrame.Marshal(b, m, deterministic)
}
func (m *TextFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextFrame.Merge(m, src)
}
func (m *TextFrame) XXX_Size() int {
	return xxx_messageInfo_TextFrame.Size(m)
}
func (m *TextFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_TextFrame.DiscardUnknown(m)
}

var xxx_messageInfo_TextFrame proto.InternalMessageInfo

func (m *TextFrame) GetRotatedBoundingBox() *NormalizedBoundingPoly {
	if m != nil {
		return m.RotatedBoundingBox
	}
	return nil
}

func (m *TextFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations related to one detected OCR text snippet. This will contain the
// corresponding text, confidence value, and frame level information for each
// detection.
type TextAnnotation struct {
	// The detected text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// All video segments where OCR detected text appears.
	Segments             []*TextSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TextAnnotation) Reset()         { *m = TextAnnotation{} }
func (m *TextAnnotation) String() string { return proto.CompactTextString(m) }
func (*TextAnnotation) ProtoMessage()    {}
func (*TextAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{39}
}

func (m *TextAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextAnnotation.Unmarshal(m, b)
}
func (m *TextAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextAnnotation.Marshal(b, m, deterministic)
}
func (m *TextAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextAnnotation.Merge(m, src)
}
func (m *TextAnnotation) XXX_Size() int {
	return xxx_messageInfo_TextAnnotation.Size(m)
}
func (m *TextAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TextAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TextAnnotation proto.InternalMessageInfo

func (m *TextAnnotation) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextAnnotation) GetSegments() []*TextSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

// Video frame level annotations for object detection and tracking. This field
// stores per frame location, time offset, and confidence.
type ObjectTrackingFrame struct {
	// The normalized bounding box location of this object track for the frame.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// The timestamp of the frame in microseconds.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ObjectTrackingFrame) Reset()         { *m = ObjectTrackingFrame{} }
func (m *ObjectTrackingFrame) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingFrame) ProtoMessage()    {}
func (*ObjectTrackingFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{40}
}

func (m *ObjectTrackingFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingFrame.Unmarshal(m, b)
}
func (m *ObjectTrackingFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingFrame.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingFrame.Merge(m, src)
}
func (m *ObjectTrackingFrame) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingFrame.Size(m)
}
func (m *ObjectTrackingFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingFrame proto.InternalMessageInfo

func (m *ObjectTrackingFrame) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBox
	}
	return nil
}

func (m *ObjectTrackingFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations corresponding to one tracked object.
type ObjectTrackingAnnotation struct {
	// Entity to specify the object category that this track is labeled as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Object category's labeling confidence of this track.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information corresponding to all frames where this object track appears.
	// Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
	// messages in frames.
	// Streaming mode: it can only be one ObjectTrackingFrame message in frames.
	Frames []*ObjectTrackingFrame `protobuf:"bytes,2,rep,name=frames,proto3" json:"frames,omitempty"`
	// Different representation of tracking info in non-streaming batch
	// and streaming modes.
	//
	// Types that are valid to be assigned to TrackInfo:
	//	*ObjectTrackingAnnotation_Segment
	//	*ObjectTrackingAnnotation_TrackId
	TrackInfo            isObjectTrackingAnnotation_TrackInfo `protobuf_oneof:"track_info"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ObjectTrackingAnnotation) Reset()         { *m = ObjectTrackingAnnotation{} }
func (m *ObjectTrackingAnnotation) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingAnnotation) ProtoMessage()    {}
func (*ObjectTrackingAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{41}
}

func (m *ObjectTrackingAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingAnnotation.Unmarshal(m, b)
}
func (m *ObjectTrackingAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingAnnotation.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingAnnotation.Merge(m, src)
}
func (m *ObjectTrackingAnnotation) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingAnnotation.Size(m)
}
func (m *ObjectTrackingAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingAnnotation proto.InternalMessageInfo

func (m *ObjectTrackingAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *ObjectTrackingAnnotation) GetFrames() []*ObjectTrackingFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

type isObjectTrackingAnnotation_TrackInfo interface {
	isObjectTrackingAnnotation_TrackInfo()
}

type ObjectTrackingAnnotation_Segment struct {
	Segment *VideoSegment `protobuf:"bytes,3,opt,name=segment,proto3,oneof"`
}

type ObjectTrackingAnnotation_TrackId struct {
	TrackId int64 `protobuf:"varint,5,opt,name=track_id,json=trackId,proto3,oneof"`
}

func (*ObjectTrackingAnnotation_Segment) isObjectTrackingAnnotation_TrackInfo() {}

func (*ObjectTrackingAnnotation_TrackId) isObjectTrackingAnnotation_TrackInfo() {}

func (m *ObjectTrackingAnnotation) GetTrackInfo() isObjectTrackingAnnotation_TrackInfo {
	if m != nil {
		return m.TrackInfo
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetSegment() *VideoSegment {
	if x, ok := m.GetTrackInfo().(*ObjectTrackingAnnotation_Segment); ok {
		return x.Segment
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetTrackId() int64 {
	if x, ok := m.GetTrackInfo().(*ObjectTrackingAnnotation_TrackId); ok {
		return x.TrackId
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ObjectTrackingAnnotation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ObjectTrackingAnnotation_Segment)(nil),
		(*ObjectTrackingAnnotation_TrackId)(nil),
	}
}

// Annotation corresponding to one detected, tracked and recognized logo class.
type LogoRecognitionAnnotation struct {
	// Entity category information to specify the logo class that all the logo
	// tracks within this LogoRecognitionAnnotation are recognized as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// All logo tracks where the recognized logo appears. Each track corresponds
	// to one logo instance appearing in consecutive frames.
	Tracks []*Track `protobuf:"bytes,2,rep,name=tracks,proto3" json:"tracks,omitempty"`
	// All video segments where the recognized logo appears. There might be
	// multiple instances of the same logo class appearing in one VideoSegment.
	Segments             []*VideoSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *LogoRecognitionAnnotation) Reset()         { *m = LogoRecognitionAnnotation{} }
func (m *LogoRecognitionAnnotation) String() string { return proto.CompactTextString(m) }
func (*LogoRecognitionAnnotation) ProtoMessage()    {}
func (*LogoRecognitionAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{42}
}

func (m *LogoRecognitionAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogoRecognitionAnnotation.Unmarshal(m, b)
}
func (m *LogoRecognitionAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogoRecognitionAnnotation.Marshal(b, m, deterministic)
}
func (m *LogoRecognitionAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogoRecognitionAnnotation.Merge(m, src)
}
func (m *LogoRecognitionAnnotation) XXX_Size() int {
	return xxx_messageInfo_LogoRecognitionAnnotation.Size(m)
}
func (m *LogoRecognitionAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LogoRecognitionAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LogoRecognitionAnnotation proto.InternalMessageInfo

func (m *LogoRecognitionAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LogoRecognitionAnnotation) GetTracks() []*Track {
	if m != nil {
		return m.Tracks
	}
	return nil
}

func (m *LogoRecognitionAnnotation) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

// The top-level message sent by the client for the `StreamingAnnotateVideo`
// method. Multiple `StreamingAnnotateVideoRequest` messages are sent.
// The first message must only contain a `StreamingVideoConfig` message.
// All subsequent messages must only contain `input_content` data.
type StreamingAnnotateVideoRequest struct {
	// *Required* The streaming request, which is either a streaming config or
	// video content.
	//
	// Types that are valid to be assigned to StreamingRequest:
	//	*StreamingAnnotateVideoRequest_VideoConfig
	//	*StreamingAnnotateVideoRequest_InputContent
	StreamingRequest     isStreamingAnnotateVideoRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *StreamingAnnotateVideoRequest) Reset()         { *m = StreamingAnnotateVideoRequest{} }
func (m *StreamingAnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingAnnotateVideoRequest) ProtoMessage()    {}
func (*StreamingAnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{43}
}

func (m *StreamingAnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAnnotateVideoRequest.Unmarshal(m, b)
}
func (m *StreamingAnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *StreamingAnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAnnotateVideoRequest.Merge(m, src)
}
func (m *StreamingAnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingAnnotateVideoRequest.Size(m)
}
func (m *StreamingAnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAnnotateVideoRequest proto.InternalMessageInfo

type isStreamingAnnotateVideoRequest_StreamingRequest interface {
	isStreamingAnnotateVideoRequest_StreamingRequest()
}

type StreamingAnnotateVideoRequest_VideoConfig struct {
	VideoConfig *StreamingVideoConfig `protobuf:"bytes,1,opt,name=video_config,json=videoConfig,proto3,oneof"`
}

type StreamingAnnotateVideoRequest_InputContent struct {
	InputContent []byte `protobuf:"bytes,2,opt,name=input_content,json=inputContent,proto3,oneof"`
}

func (*StreamingAnnotateVideoRequest_VideoConfig) isStreamingAnnotateVideoRequest_StreamingRequest() {}

func (*StreamingAnnotateVideoRequest_InputContent) isStreamingAnnotateVideoRequest_StreamingRequest() {
}

func (m *StreamingAnnotateVideoRequest) GetStreamingRequest() isStreamingAnnotateVideoRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (m *StreamingAnnotateVideoRequest) GetVideoConfig() *StreamingVideoConfig {
	if x, ok := m.GetStreamingRequest().(*StreamingAnnotateVideoRequest_VideoConfig); ok {
		return x.VideoConfig
	}
	return nil
}

func (m *StreamingAnnotateVideoRequest) GetInputContent() []byte {
	if x, ok := m.GetStreamingRequest().(*StreamingAnnotateVideoRequest_InputContent); ok {
		return x.InputContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StreamingAnnotateVideoRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StreamingAnnotateVideoRequest_VideoConfig)(nil),
		(*StreamingAnnotateVideoRequest_InputContent)(nil),
	}
}

// `StreamingAnnotateVideoResponse` is the only message returned to the client
// by `StreamingAnnotateVideo`. A series of zero or more
// `StreamingAnnotateVideoResponse` messages are streamed back to the client.
type StreamingAnnotateVideoResponse struct {
	// If set, returns a [google.rpc.Status][google.rpc.Status] message that
	// specifies the error for the operation.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// Streaming annotation results.
	AnnotationResults *StreamingVideoAnnotationResults `protobuf:"bytes,2,opt,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	// GCS URI that stores annotation results of one streaming session.
	// It is a directory that can hold multiple files in JSON format.
	// Example uri format:
	// gs://bucket_id/object_id/cloud_project_name-session_id
	AnnotationResultsUri string   `protobuf:"bytes,3,opt,name=annotation_results_uri,json=annotationResultsUri,proto3" json:"annotation_results_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingAnnotateVideoResponse) Reset()         { *m = StreamingAnnotateVideoResponse{} }
func (m *StreamingAnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingAnnotateVideoResponse) ProtoMessage()    {}
func (*StreamingAnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{44}
}

func (m *StreamingAnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAnnotateVideoResponse.Unmarshal(m, b)
}
func (m *StreamingAnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *StreamingAnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAnnotateVideoResponse.Merge(m, src)
}
func (m *StreamingAnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingAnnotateVideoResponse.Size(m)
}
func (m *StreamingAnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAnnotateVideoResponse proto.InternalMessageInfo

func (m *StreamingAnnotateVideoResponse) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *StreamingAnnotateVideoResponse) GetAnnotationResults() *StreamingVideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

func (m *StreamingAnnotateVideoResponse) GetAnnotationResultsUri() string {
	if m != nil {
		return m.AnnotationResultsUri
	}
	return ""
}

// Config for STREAMING_AUTOML_CLASSIFICATION.
type StreamingAutomlClassificationConfig struct {
	// Resource name of AutoML model.
	// Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
	ModelName            string   `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingAutomlClassificationConfig) Reset()         { *m = StreamingAutomlClassificationConfig{} }
func (m *StreamingAutomlClassificationConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingAutomlClassificationConfig) ProtoMessage()    {}
func (*StreamingAutomlClassificationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{45}
}

func (m *StreamingAutomlClassificationConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAutomlClassificationConfig.Unmarshal(m, b)
}
func (m *StreamingAutomlClassificationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAutomlClassificationConfig.Marshal(b, m, deterministic)
}
func (m *StreamingAutomlClassificationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAutomlClassificationConfig.Merge(m, src)
}
func (m *StreamingAutomlClassificationConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingAutomlClassificationConfig.Size(m)
}
func (m *StreamingAutomlClassificationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAutomlClassificationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAutomlClassificationConfig proto.InternalMessageInfo

func (m *StreamingAutomlClassificationConfig) GetModelName() string {
	if m != nil {
		return m.ModelName
	}
	return ""
}

// Config for STREAMING_AUTOML_OBJECT_TRACKING.
type StreamingAutomlObjectTrackingConfig struct {
	// Resource name of AutoML model.
	// Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
	ModelName            string   `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingAutomlObjectTrackingConfig) Reset()         { *m = StreamingAutomlObjectTrackingConfig{} }
func (m *StreamingAutomlObjectTrackingConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingAutomlObjectTrackingConfig) ProtoMessage()    {}
func (*StreamingAutomlObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{46}
}

func (m *StreamingAutomlObjectTrackingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAutomlObjectTrackingConfig.Unmarshal(m, b)
}
func (m *StreamingAutomlObjectTrackingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAutomlObjectTrackingConfig.Marshal(b, m, deterministic)
}
func (m *StreamingAutomlObjectTrackingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAutomlObjectTrackingConfig.Merge(m, src)
}
func (m *StreamingAutomlObjectTrackingConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingAutomlObjectTrackingConfig.Size(m)
}
func (m *StreamingAutomlObjectTrackingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAutomlObjectTrackingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAutomlObjectTrackingConfig proto.InternalMessageInfo

func (m *StreamingAutomlObjectTrackingConfig) GetModelName() string {
	if m != nil {
		return m.ModelName
	}
	return ""
}

// Config for STREAMING_EXPLICIT_CONTENT_DETECTION.
type StreamingExplicitContentDetectionConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingExplicitContentDetectionConfig) Reset() {
	*m = StreamingExplicitContentDetectionConfig{}
}
func (m *StreamingExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingExplicitContentDetectionConfig) ProtoMessage()    {}
func (*StreamingExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{47}
}

func (m *StreamingExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingExplicitContentDetectionConfig.Merge(m, src)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingExplicitContentDetectionConfig.Size(m)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingExplicitContentDetectionConfig proto.InternalMessageInfo

// Config for STREAMING_LABEL_DETECTION.
type StreamingLabelDetectionConfig struct {
	// Whether the video has been captured from a stationary (i.e. non-moving)
	// camera. When set to true, might improve detection accuracy for moving
	// objects. Default: false.
	StationaryCamera     bool     `protobuf:"varint,1,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingLabelDetectionConfig) Reset()         { *m = StreamingLabelDetectionConfig{} }
func (m *StreamingLabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingLabelDetectionConfig) ProtoMessage()    {}
func (*StreamingLabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{48}
}

func (m *StreamingLabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingLabelDetectionConfig.Unmarshal(m, b)
}
func (m *StreamingLabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingLabelDetectionConfig.Marshal(b, m, deterministic)
}
func (m *StreamingLabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingLabelDetectionConfig.Merge(m, src)
}
func (m *StreamingLabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingLabelDetectionConfig.Size(m)
}
func (m *StreamingLabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingLabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingLabelDetectionConfig proto.InternalMessageInfo

func (m *StreamingLabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

// Config for STREAMING_OBJECT_TRACKING.
type StreamingObjectTrackingConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingObjectTrackingConfig) Reset()         { *m = StreamingObjectTrackingConfig{} }
func (m *StreamingObjectTrackingConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingObjectTrackingConfig) ProtoMessage()    {}
func (*StreamingObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{49}
}

func (m *StreamingObjectTrackingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingObjectTrackingConfig.Unmarshal(m, b)
}
func (m *StreamingObjectTrackingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingObjectTrackingConfig.Marshal(b, m, deterministic)
}
func (m *StreamingObjectTrackingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingObjectTrackingConfig.Merge(m, src)
}
func (m *StreamingObjectTrackingConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingObjectTrackingConfig.Size(m)
}
func (m *StreamingObjectTrackingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingObjectTrackingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingObjectTrackingConfig proto.InternalMessageInfo

// Config for STREAMING_SHOT_CHANGE_DETECTION.
type StreamingShotChangeDetectionConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingShotChangeDetectionConfig) Reset()         { *m = StreamingShotChangeDetectionConfig{} }
func (m *StreamingShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingShotChangeDetectionConfig) ProtoMessage()    {}
func (*StreamingShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{50}
}

func (m *StreamingShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *StreamingShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (m *StreamingShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingShotChangeDetectionConfig.Merge(m, src)
}
func (m *StreamingShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingShotChangeDetectionConfig.Size(m)
}
func (m *StreamingShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingShotChangeDetectionConfig proto.InternalMessageInfo

// Config for streaming storage option.
type StreamingStorageConfig struct {
	// Enable streaming storage. Default: false.
	EnableStorageAnnotationResult bool `protobuf:"varint,1,opt,name=enable_storage_annotation_result,json=enableStorageAnnotationResult,proto3" json:"enable_storage_annotation_result,omitempty"`
	// GCS URI to store all annotation results for one client. Client should
	// specify this field as the top-level storage directory. Annotation results
	// of different sessions will be put into different sub-directories denoted
	// by project_name and session_id. All sub-directories will be auto generated
	// by program and will be made accessible to client in response proto.
	// URIs must be specified in the following format: `gs://bucket-id/object-id`
	// `bucket-id` should be a valid GCS bucket created by client and bucket
	// permission shall also be configured properly. `object-id` can be arbitrary
	// string that make sense to client. Other URI formats will return error and
	// cause GCS write failure.
	AnnotationResultStorageDirectory string   `protobuf:"bytes,3,opt,name=annotation_result_storage_directory,json=annotationResultStorageDirectory,proto3" json:"annotation_result_storage_directory,omitempty"`
	XXX_NoUnkeyedLiteral             struct{} `json:"-"`
	XXX_unrecognized                 []byte   `json:"-"`
	XXX_sizecache                    int32    `json:"-"`
}

func (m *StreamingStorageConfig) Reset()         { *m = StreamingStorageConfig{} }
func (m *StreamingStorageConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingStorageConfig) ProtoMessage()    {}
func (*StreamingStorageConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{51}
}

func (m *StreamingStorageConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingStorageConfig.Unmarshal(m, b)
}
func (m *StreamingStorageConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingStorageConfig.Marshal(b, m, deterministic)
}
func (m *StreamingStorageConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingStorageConfig.Merge(m, src)
}
func (m *StreamingStorageConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingStorageConfig.Size(m)
}
func (m *StreamingStorageConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingStorageConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingStorageConfig proto.InternalMessageInfo

func (m *StreamingStorageConfig) GetEnableStorageAnnotationResult() bool {
	if m != nil {
		return m.EnableStorageAnnotationResult
	}
	return false
}

func (m *StreamingStorageConfig) GetAnnotationResultStorageDirectory() string {
	if m != nil {
		return m.AnnotationResultStorageDirectory
	}
	return ""
}

// Streaming annotation results corresponding to a portion of the video
// that is currently being processed.
type StreamingVideoAnnotationResults struct {
	// Shot annotation results. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,1,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Label annotation results.
	LabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=label_annotations,json=labelAnnotations,proto3" json:"label_annotations,omitempty"`
	// Explicit content annotation results.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,3,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Object tracking results.
	ObjectAnnotations    []*ObjectTrackingAnnotation `protobuf:"bytes,4,rep,name=object_annotations,json=objectAnnotations,proto3" json:"object_annotations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *StreamingVideoAnnotationResults) Reset()         { *m = StreamingVideoAnnotationResults{} }
func (m *StreamingVideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*StreamingVideoAnnotationResults) ProtoMessage()    {}
func (*StreamingVideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{52}
}

func (m *StreamingVideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingVideoAnnotationResults.Unmarshal(m, b)
}
func (m *StreamingVideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingVideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *StreamingVideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingVideoAnnotationResults.Merge(m, src)
}
func (m *StreamingVideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_StreamingVideoAnnotationResults.Size(m)
}
func (m *StreamingVideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingVideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingVideoAnnotationResults proto.InternalMessageInfo

func (m *StreamingVideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *StreamingVideoAnnotationResults) GetLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *StreamingVideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *StreamingVideoAnnotationResults) GetObjectAnnotations() []*ObjectTrackingAnnotation {
	if m != nil {
		return m.ObjectAnnotations
	}
	return nil
}

// Provides information to the annotator that specifies how to process the
// request.
type StreamingVideoConfig struct {
	// Requested annotation feature.
	Feature StreamingFeature `protobuf:"varint,1,opt,name=feature,proto3,enum=google.cloud.videointelligence.v1p3beta1.StreamingFeature" json:"feature,omitempty"`
	// Config for requested annotation feature.
	//
	// Types that are valid to be assigned to StreamingConfig:
	//	*StreamingVideoConfig_ShotChangeDetectionConfig
	//	*StreamingVideoConfig_LabelDetectionConfig
	//	*StreamingVideoConfig_ExplicitContentDetectionConfig
	//	*StreamingVideoConfig_ObjectTrackingConfig
	//	*StreamingVideoConfig_AutomlClassificationConfig
	//	*StreamingVideoConfig_AutomlObjectTrackingConfig
	StreamingConfig isStreamingVideoConfig_StreamingConfig `protobuf_oneof:"streaming_config"`
	// Streaming storage option. By default: storage is disabled.
	StorageConfig        *StreamingStorageConfig `protobuf:"bytes,30,opt,name=storage_config,json=storageConfig,proto3" json:"storage_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *StreamingVideoConfig) Reset()         { *m = StreamingVideoConfig{} }
func (m *StreamingVideoConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingVideoConfig) ProtoMessage()    {}
func (*StreamingVideoConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{53}
}

func (m *StreamingVideoConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingVideoConfig.Unmarshal(m, b)
}
func (m *StreamingVideoConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingVideoConfig.Marshal(b, m, deterministic)
}
func (m *StreamingVideoConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingVideoConfig.Merge(m, src)
}
func (m *StreamingVideoConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingVideoConfig.Size(m)
}
func (m *StreamingVideoConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingVideoConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingVideoConfig proto.InternalMessageInfo

func (m *StreamingVideoConfig) GetFeature() StreamingFeature {
	if m != nil {
		return m.Feature
	}
	return StreamingFeature_STREAMING_FEATURE_UNSPECIFIED
}

type isStreamingVideoConfig_StreamingConfig interface {
	isStreamingVideoConfig_StreamingConfig()
}

type StreamingVideoConfig_ShotChangeDetectionConfig struct {
	ShotChangeDetectionConfig *StreamingShotChangeDetectionConfig `protobuf:"bytes,2,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3,oneof"`
}

type StreamingVideoConfig_LabelDetectionConfig struct {
	LabelDetectionConfig *StreamingLabelDetectionConfig `protobuf:"bytes,3,opt,name=label_detection_config,json=labelDetectionConfig,proto3,oneof"`
}

type StreamingVideoConfig_ExplicitContentDetectionConfig struct {
	ExplicitContentDetectionConfig *StreamingExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3,oneof"`
}

type StreamingVideoConfig_ObjectTrackingConfig struct {
	ObjectTrackingConfig *StreamingObjectTrackingConfig `protobuf:"bytes,5,opt,name=object_tracking_config,json=objectTrackingConfig,proto3,oneof"`
}

type StreamingVideoConfig_AutomlClassificationConfig struct {
	AutomlClassificationConfig *StreamingAutomlClassificationConfig `protobuf:"bytes,21,opt,name=automl_classification_config,json=automlClassificationConfig,proto3,oneof"`
}

type StreamingVideoConfig_AutomlObjectTrackingConfig struct {
	AutomlObjectTrackingConfig *StreamingAutomlObjectTrackingConfig `protobuf:"bytes,22,opt,name=automl_object_tracking_config,json=automlObjectTrackingConfig,proto3,oneof"`
}

func (*StreamingVideoConfig_ShotChangeDetectionConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_LabelDetectionConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_ExplicitContentDetectionConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_ObjectTrackingConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_AutomlClassificationConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_AutomlObjectTrackingConfig) isStreamingVideoConfig_StreamingConfig() {}

func (m *StreamingVideoConfig) GetStreamingConfig() isStreamingVideoConfig_StreamingConfig {
	if m != nil {
		return m.StreamingConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetShotChangeDetectionConfig() *StreamingShotChangeDetectionConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_ShotChangeDetectionConfig); ok {
		return x.ShotChangeDetectionConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetLabelDetectionConfig() *StreamingLabelDetectionConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_LabelDetectionConfig); ok {
		return x.LabelDetectionConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetExplicitContentDetectionConfig() *StreamingExplicitContentDetectionConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_ExplicitContentDetectionConfig); ok {
		return x.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetObjectTrackingConfig() *StreamingObjectTrackingConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_ObjectTrackingConfig); ok {
		return x.ObjectTrackingConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetAutomlClassificationConfig() *StreamingAutomlClassificationConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_AutomlClassificationConfig); ok {
		return x.AutomlClassificationConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetAutomlObjectTrackingConfig() *StreamingAutomlObjectTrackingConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_AutomlObjectTrackingConfig); ok {
		return x.AutomlObjectTrackingConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetStorageConfig() *StreamingStorageConfig {
	if m != nil {
		return m.StorageConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StreamingVideoConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StreamingVideoConfig_ShotChangeDetectionConfig)(nil),
		(*StreamingVideoConfig_LabelDetectionConfig)(nil),
		(*StreamingVideoConfig_ExplicitContentDetectionConfig)(nil),
		(*StreamingVideoConfig_ObjectTrackingConfig)(nil),
		(*StreamingVideoConfig_AutomlClassificationConfig)(nil),
		(*StreamingVideoConfig_AutomlObjectTrackingConfig)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.StreamingFeature", StreamingFeature_name, StreamingFeature_value)
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p3beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1p3beta1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.ShotChangeDetectionConfig")
	proto.RegisterType((*ObjectTrackingConfig)(nil), "google.cloud.videointelligence.v1p3beta1.ObjectTrackingConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.ExplicitContentDetectionConfig")
	proto.RegisterType((*FaceDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.FaceDetectionConfig")
	proto.RegisterType((*PersonDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.PersonDetectionConfig")
	proto.RegisterType((*TextDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.TextDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1p3beta1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1p3beta1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1p3beta1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1p3beta1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1p3beta1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox")
	proto.RegisterType((*TimestampedObject)(nil), "google.cloud.videointelligence.v1p3beta1.TimestampedObject")
	proto.RegisterType((*Track)(nil), "google.cloud.videointelligence.v1p3beta1.Track")
	proto.RegisterType((*DetectedAttribute)(nil), "google.cloud.videointelligence.v1p3beta1.DetectedAttribute")
	proto.RegisterType((*Celebrity)(nil), "google.cloud.videointelligence.v1p3beta1.Celebrity")
	proto.RegisterType((*CelebrityTrack)(nil), "google.cloud.videointelligence.v1p3beta1.CelebrityTrack")
	proto.RegisterType((*CelebrityTrack_RecognizedCelebrity)(nil), "google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity")
	proto.RegisterType((*CelebrityRecognitionAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.CelebrityRecognitionAnnotation")
	proto.RegisterType((*DetectedLandmark)(nil), "google.cloud.videointelligence.v1p3beta1.DetectedLandmark")
	proto.RegisterType((*FaceDetectionAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.FaceDetectionAnnotation")
	proto.RegisterType((*PersonDetectionAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.PersonDetectionAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p3beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p3beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1p3beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1p3beta1.AnnotateVideoProgress")
	proto.RegisterType((*SpeechTranscriptionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.videointelligence.v1p3beta1.SpeechContext")
	proto.RegisterType((*SpeechTranscription)(nil), "google.cloud.videointelligence.v1p3beta1.SpeechTranscription")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.videointelligence.v1p3beta1.WordInfo")
	proto.RegisterType((*NormalizedVertex)(nil), "google.cloud.videointelligence.v1p3beta1.NormalizedVertex")
	proto.RegisterType((*NormalizedBoundingPoly)(nil), "google.cloud.videointelligence.v1p3beta1.NormalizedBoundingPoly")
	proto.RegisterType((*TextSegment)(nil), "google.cloud.videointelligence.v1p3beta1.TextSegment")
	proto.RegisterType((*TextFrame)(nil), "google.cloud.videointelligence.v1p3beta1.TextFrame")
	proto.RegisterType((*TextAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.TextAnnotation")
	proto.RegisterType((*ObjectTrackingFrame)(nil), "google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame")
	proto.RegisterType((*ObjectTrackingAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation")
	proto.RegisterType((*LogoRecognitionAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.LogoRecognitionAnnotation")
	proto.RegisterType((*StreamingAnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAnnotateVideoRequest")
	proto.RegisterType((*StreamingAnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAnnotateVideoResponse")
	proto.RegisterType((*StreamingAutomlClassificationConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAutomlClassificationConfig")
	proto.RegisterType((*StreamingAutomlObjectTrackingConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAutomlObjectTrackingConfig")
	proto.RegisterType((*StreamingExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingExplicitContentDetectionConfig")
	proto.RegisterType((*StreamingLabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingLabelDetectionConfig")
	proto.RegisterType((*StreamingObjectTrackingConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingObjectTrackingConfig")
	proto.RegisterType((*StreamingShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingShotChangeDetectionConfig")
	proto.RegisterType((*StreamingStorageConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingStorageConfig")
	proto.RegisterType((*StreamingVideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults")
	proto.RegisterType((*StreamingVideoConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingVideoConfig")
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1p3beta1/video_intelligence.proto", fileDescriptor_06234ac6e4dad78c)
}

var fileDescriptor_06234ac6e4dad78c = []byte{
	// 3812 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x3b, 0x4d, 0x73, 0x23, 0x59,
	0x52, 0x5d, 0x25, 0xdb, 0x6d, 0xa7, 0x65, 0x5b, 0x7e, 0x96, 0x6d, 0xd9, 0xd3, 0x76, 0xbb, 0xab,
	0x7b, 0xc1, 0xdb, 0xcc, 0xca, 0xdb, 0xdd, 0xc3, 0xb2, 0xd3, 0xb3, 0x5f, 0xb2, 0xac, 0xb6, 0xc5,
	0xa8, 0x6d, 0x4d, 0x59, 0xdd, 0xec, 0xc0, 0x4c, 0x14, 0xe5, 0xaa, 0x27, 0xb9, 0xb6, 0x4b, 0xf5,
	0x34, 0x55, 0xa5, 0x6e, 0x7b, 0x2f, 0x33, 0xb1, 0xb0, 0xc4, 0x12, 0x04, 0xc1, 0xc2, 0x72, 0xe0,
	0xc4, 0x0f, 0x80, 0x20, 0x02, 0xf6, 0x08, 0x07, 0xb8, 0x10, 0x44, 0x4c, 0x10, 0x1b, 0x04, 0x1b,
	0x1c, 0xd8, 0xe5, 0xc0, 0x01, 0xfe, 0x03, 0xc1, 0x89, 0x78, 0x1f, 0xf5, 0xa1, 0xaa, 0x92, 0x6d,
	0xc9, 0xdd, 0x10, 0xdc, 0x54, 0x99, 0xf9, 0x32, 0xf3, 0xe5, 0xcb, 0x97, 0x99, 0x2f, 0xdf, 0x13,
	0x54, 0x3a, 0x84, 0x74, 0x6c, 0xbc, 0x63, 0xd8, 0xa4, 0x6f, 0xee, 0xbc, 0xb4, 0x4c, 0x4c, 0x2c,
	0xc7, 0xc7, 0xb6, 0x6d, 0x75, 0xb0, 0x63, 0xe0, 0x9d, 0x97, 0x0f, 0x7a, 0x8f, 0x4e, 0xb0, 0xaf,
	0x3f, 0xe0, 0x38, 0x2d, 0x8e, 0x2c, 0xf7, 0x5c, 0xe2, 0x13, 0xb4, 0xcd, 0x59, 0x94, 0x19, 0x8b,
	0x72, 0x8a, 0x45, 0x39, 0x64, 0xb1, 0x7e, 0x4b, 0x08, 0xd3, 0x7b, 0xd6, 0x8e, 0xee, 0x38, 0xc4,
	0xd7, 0x7d, 0x8b, 0x38, 0x1e, 0xe7, 0xb3, 0xbe, 0x1a, 0xc3, 0x1a, 0xb6, 0x85, 0x1d, 0x5f, 0x20,
	0x6e, 0xc7, 0x10, 0x6d, 0x0b, 0xdb, 0xa6, 0x76, 0x82, 0x4f, 0xf5, 0x97, 0x16, 0x71, 0x05, 0xc1,
	0x5d, 0x41, 0x60, 0x13, 0xa7, 0xe3, 0xf6, 0x1d, 0xc7, 0x72, 0x3a, 0x3b, 0xa4, 0x87, 0xdd, 0x01,
	0xf6, 0x9b, 0x82, 0x88, 0x7d, 0x9d, 0xf4, 0xdb, 0x3b, 0x66, 0x9f, 0x13, 0x24, 0xa4, 0x84, 0x78,
	0xdf, 0xea, 0x62, 0xcf, 0xd7, 0xbb, 0xbd, 0x84, 0x7e, 0x6e, 0xcf, 0xd8, 0xf1, 0x7c, 0xdd, 0xef,
	0x0b, 0xce, 0xca, 0x4f, 0x65, 0x28, 0x56, 0xf8, 0x74, 0xf0, 0x73, 0x3a, 0x7d, 0x15, 0x7f, 0xd2,
	0xc7, 0x9e, 0x8f, 0xde, 0x82, 0x19, 0xcb, 0xe9, 0xf5, 0x7d, 0xad, 0xef, 0x5a, 0x25, 0x69, 0x4b,
	0xda, 0x9e, 0x51, 0xa7, 0x19, 0xe0, 0x99, 0x6b, 0xa1, 0xbb, 0x30, 0xc7, 0x91, 0x06, 0x71, 0x7c,
	0xec, 0xf8, 0xa5, 0xa9, 0x2d, 0x69, 0x3b, 0xaf, 0xe6, 0x19, 0xb0, 0xca, 0x61, 0x48, 0x85, 0xe9,
	0x36, 0xd6, 0xfd, 0xbe, 0x8b, 0xbd, 0x92, 0xbc, 0x95, 0xdb, 0x9e, 0x7f, 0xf8, 0xa0, 0x7c, 0x55,
	0x73, 0x97, 0x9f, 0xf0, 0x91, 0xbb, 0xb9, 0x7f, 0xaf, 0xc8, 0x6a, 0xc8, 0x07, 0xfd, 0x06, 0xcc,
	0xf1, 0xb5, 0x64, 0x82, 0xcf, 0xfc, 0x52, 0x6e, 0x4b, 0xda, 0x9e, 0x7d, 0xf8, 0x95, 0xab, 0x33,
	0x66, 0x93, 0xac, 0xf2, 0xd1, 0x6a, 0xfe, 0x65, 0xec, 0x0b, 0x29, 0x00, 0xa4, 0xef, 0x07, 0x73,
	0x9e, 0xa0, 0x73, 0xa6, 0xf2, 0x25, 0x75, 0x86, 0x83, 0xe9, 0xcc, 0xef, 0xc1, 0xac, 0x4d, 0x0c,
	0x66, 0x7b, 0xcd, 0x32, 0x4b, 0x93, 0x11, 0x11, 0x04, 0xf0, 0xba, 0xa9, 0xfc, 0xd3, 0x34, 0xe4,
	0xe3, 0x82, 0xa8, 0x2d, 0x3c, 0xdc, 0xe9, 0x62, 0xc7, 0xf7, 0x4a, 0xd2, 0x56, 0x6e, 0x0c, 0x95,
	0x8f, 0xf9, 0x70, 0x35, 0xe4, 0x83, 0x7c, 0x58, 0xb1, 0xf5, 0x13, 0x6c, 0x6b, 0x26, 0xf6, 0xb1,
	0xc1, 0x34, 0x32, 0x88, 0xd3, 0xb6, 0x3a, 0x25, 0x99, 0x19, 0xe5, 0x1b, 0x57, 0x97, 0xd0, 0xa0,
	0x7c, 0xf6, 0x02, 0x36, 0x55, 0xc6, 0x45, 0x2d, 0xda, 0x19, 0x50, 0xf4, 0xdb, 0x12, 0xdc, 0xf2,
	0x4e, 0x89, 0xaf, 0x19, 0xa7, 0xba, 0xd3, 0xc1, 0x69, 0xe1, 0x7c, 0x45, 0xaa, 0x57, 0x17, 0x7e,
	0x7c, 0x4a, 0xfc, 0x2a, 0x63, 0x96, 0xd4, 0x60, 0xcd, 0x1b, 0x86, 0x42, 0x3f, 0x92, 0xe0, 0x0e,
	0x3e, 0xeb, 0xd9, 0x96, 0x61, 0x85, 0x5e, 0x98, 0xd6, 0x65, 0x82, 0xe9, 0x72, 0x70, 0x75, 0x5d,
	0x6a, 0x82, 0xa5, 0xf0, 0xe1, 0xa4, 0x42, 0x9b, 0xf8, 0x42, 0x3c, 0xfa, 0x04, 0x96, 0xdb, 0xba,
	0x91, 0x61, 0x94, 0x49, 0xa6, 0xc8, 0xd7, 0x47, 0xf0, 0x7f, 0xdd, 0x48, 0x99, 0x63, 0xa9, 0x9d,
	0x06, 0xa2, 0xdf, 0x92, 0xe0, 0x2d, 0xaf, 0x87, 0xb1, 0x71, 0xaa, 0xf9, 0xae, 0xee, 0x78, 0x86,
	0x6b, 0xf5, 0xe2, 0x92, 0xa7, 0x46, 0x5e, 0x0e, 0xc6, 0xac, 0x15, 0xe7, 0x15, 0x2e, 0xc7, 0x30,
	0x14, 0x9d, 0x38, 0xf5, 0xf3, 0xf4, 0xc4, 0xa7, 0x47, 0x9d, 0x78, 0x0b, 0x9f, 0xa5, 0xcc, 0xbe,
	0xe4, 0xa7, 0x81, 0xe8, 0x15, 0xac, 0xf6, 0xb0, 0xeb, 0x11, 0x27, 0x2d, 0x74, 0x96, 0x09, 0xfd,
	0xe6, 0xd5, 0x85, 0x36, 0x19, 0xa3, 0xa4, 0xd8, 0xe5, 0x5e, 0x16, 0x98, 0xee, 0x3b, 0x72, 0xf2,
	0x1d, 0x6c, 0xf8, 0xd4, 0xe0, 0xc6, 0x0b, 0xcb, 0xe9, 0x04, 0x72, 0xe7, 0x46, 0xdd, 0x77, 0x47,
	0x8c, 0x4f, 0x4b, 0xb0, 0x09, 0xf6, 0x1d, 0xc9, 0x80, 0x2a, 0x7f, 0x2f, 0x43, 0x31, 0x6b, 0x9b,
	0x22, 0x07, 0x8a, 0xc9, 0x30, 0xd0, 0x25, 0x26, 0x66, 0x31, 0x7b, 0xfe, 0xe1, 0xd7, 0xc6, 0x0d,
	0x02, 0x4f, 0x89, 0x89, 0x55, 0x64, 0xa7, 0x60, 0xe8, 0x97, 0x60, 0xd1, 0xe3, 0xc9, 0x4f, 0x77,
	0xcf, 0x35, 0x43, 0xef, 0x62, 0x57, 0x67, 0x11, 0x67, 0x5a, 0x2d, 0x44, 0x88, 0x2a, 0x83, 0xa3,
	0x22, 0x4c, 0x52, 0x65, 0x6c, 0x16, 0x15, 0x66, 0x54, 0xfe, 0x81, 0xbe, 0x06, 0xeb, 0x6d, 0x57,
	0xef, 0x62, 0x6e, 0x37, 0x93, 0xea, 0xa1, 0xf9, 0xa7, 0x2e, 0xf6, 0x4e, 0x89, 0x6d, 0xb2, 0x4d,
	0x2b, 0xab, 0x25, 0x46, 0x51, 0x0d, 0x09, 0x5a, 0x01, 0x9e, 0x8e, 0x0e, 0x73, 0x40, 0x7a, 0xf4,
	0x24, 0x1f, 0x1d, 0x04, 0xf6, 0xe4, 0x68, 0xe5, 0x01, 0xac, 0x0d, 0x0d, 0x38, 0x91, 0xba, 0x52,
	0x4c, 0x5d, 0xe5, 0x6d, 0x28, 0x66, 0x2d, 0xd4, 0x10, 0xea, 0xaf, 0xc0, 0xe6, 0xc5, 0x51, 0x64,
	0xc8, 0xb8, 0x1f, 0x4a, 0xb0, 0x94, 0xb1, 0xeb, 0xb3, 0xa9, 0xd1, 0x3b, 0xb0, 0x62, 0x39, 0x86,
	0xdd, 0x37, 0xb1, 0x76, 0x42, 0xfa, 0x8e, 0x49, 0xbd, 0xf0, 0x84, 0x9c, 0xb1, 0x54, 0x4b, 0x97,
	0xa2, 0x28, 0xb0, 0xbb, 0x02, 0xb9, 0x4b, 0x71, 0xe8, 0x4b, 0x80, 0x82, 0x51, 0xba, 0xef, 0xbb,
	0xd6, 0x49, 0xdf, 0xc7, 0x1e, 0x33, 0xd9, 0xb4, 0xba, 0x28, 0x30, 0x95, 0x10, 0xa1, 0xfc, 0x58,
	0x82, 0xe5, 0xcc, 0xad, 0x71, 0x81, 0x78, 0xe9, 0x02, 0xf1, 0xb1, 0x51, 0x3d, 0xe2, 0x61, 0xcd,
	0xd6, 0x1d, 0xb3, 0xab, 0xbb, 0x2f, 0x92, 0x4a, 0x37, 0x89, 0x87, 0x1b, 0x01, 0x6e, 0x88, 0xd2,
	0xb9, 0x61, 0x4a, 0xab, 0xb0, 0x94, 0x11, 0x43, 0xd0, 0x17, 0x60, 0xde, 0xd6, 0x9d, 0x4e, 0x5f,
	0xef, 0x60, 0xed, 0xd4, 0x0a, 0xf2, 0xf0, 0x8c, 0x3a, 0x17, 0x40, 0x0f, 0x28, 0x30, 0xb2, 0xb6,
	0x1c, 0x5f, 0x9b, 0x3f, 0x91, 0x44, 0x3e, 0x17, 0x59, 0x18, 0xd5, 0xd8, 0x26, 0x70, 0x7d, 0x8d,
	0x16, 0x5a, 0x1a, 0x69, 0xb7, 0x3d, 0xec, 0xb3, 0xa9, 0xcf, 0x3e, 0x5c, 0x0b, 0x76, 0x5c, 0x50,
	0x8c, 0x95, 0xf7, 0x44, 0xb1, 0xa6, 0x2e, 0xb0, 0x31, 0x2d, 0xab, 0x8b, 0x8f, 0xd8, 0x08, 0x54,
	0x81, 0x05, 0xec, 0x98, 0x03, 0x4c, 0xe4, 0xcb, 0x98, 0xcc, 0x61, 0xc7, 0x8c, 0x58, 0x28, 0x9f,
	0x49, 0x90, 0x67, 0x3b, 0x37, 0x50, 0xad, 0x09, 0x37, 0x45, 0x89, 0x20, 0x14, 0x1a, 0xb7, 0xd2,
	0x08, 0xd8, 0xa0, 0x4d, 0x80, 0x68, 0xab, 0x31, 0x05, 0x65, 0x35, 0x06, 0x51, 0x4e, 0x01, 0x98,
	0x06, 0x4f, 0xe8, 0x8e, 0x45, 0x8f, 0x61, 0x76, 0x24, 0xa3, 0x80, 0x1f, 0xd9, 0xe3, 0x32, 0x49,
	0x36, 0x4c, 0xd5, 0x1c, 0xdf, 0xf2, 0xcf, 0x69, 0x79, 0x8a, 0xd9, 0x2f, 0x5a, 0x85, 0x89, 0xf2,
	0x94, 0x03, 0xea, 0x26, 0xda, 0x82, 0x59, 0x13, 0x87, 0x29, 0x4a, 0x2c, 0x65, 0x1c, 0x44, 0x0b,
	0xd8, 0xd0, 0x1b, 0x0c, 0x1a, 0x2d, 0x79, 0x7c, 0xca, 0x07, 0xc0, 0x2a, 0x31, 0xb1, 0xf2, 0x6f,
	0x32, 0x2c, 0xb0, 0x89, 0x55, 0xc2, 0x7a, 0x1f, 0x1d, 0xc0, 0x14, 0x17, 0x23, 0x26, 0xf6, 0xe5,
	0x11, 0x6a, 0x0b, 0x36, 0x4e, 0x15, 0xe3, 0xd1, 0xc7, 0xb0, 0x68, 0xe8, 0x3e, 0xee, 0x10, 0xf7,
	0x5c, 0x63, 0x20, 0x4b, 0xd4, 0xc9, 0xe3, 0x30, 0x2d, 0x04, 0xac, 0x6a, 0x82, 0xd3, 0x40, 0xc5,
	0x99, 0x1b, 0xb5, 0xe2, 0x8c, 0x3b, 0x54, 0xac, 0xe2, 0x6c, 0xc0, 0x14, 0x8b, 0xca, 0x5e, 0x69,
	0x82, 0x71, 0x7c, 0x67, 0x44, 0x8e, 0xcc, 0x41, 0x54, 0xc1, 0x43, 0xf9, 0x5b, 0x09, 0x8a, 0x89,
	0x48, 0x79, 0x7d, 0x0f, 0x7a, 0x01, 0x2b, 0x3d, 0xe2, 0x3a, 0xa4, 0xe3, 0xea, 0xbd, 0xd3, 0x73,
	0xcd, 0xb6, 0x5e, 0x60, 0xdb, 0x3a, 0x25, 0xc4, 0x64, 0x5e, 0x30, 0x3f, 0x92, 0xca, 0xe1, 0x58,
	0x75, 0x39, 0xc6, 0x33, 0x02, 0x2b, 0x1e, 0xac, 0x25, 0x26, 0x10, 0xf3, 0x94, 0xe7, 0xa1, 0xb1,
	0x78, 0xc1, 0xff, 0x8d, 0xb1, 0xab, 0xd0, 0x41, 0xb3, 0xbd, 0x80, 0xe5, 0x43, 0xe2, 0x76, 0x75,
	0xdb, 0xfa, 0x2e, 0x36, 0x63, 0xf1, 0x15, 0x21, 0x98, 0xb0, 0x71, 0x9b, 0xdb, 0x4b, 0x56, 0xd9,
	0x6f, 0x54, 0x80, 0x9c, 0x4f, 0x7a, 0x62, 0x27, 0xd1, 0x9f, 0x34, 0xc0, 0xb9, 0x56, 0xe7, 0x94,
	0x9f, 0x9c, 0x64, 0x95, 0x7f, 0xa0, 0x15, 0x98, 0x3a, 0x21, 0xbe, 0x4f, 0xba, 0x22, 0xfb, 0x8a,
	0x2f, 0xe5, 0x77, 0x73, 0xb0, 0xd8, 0x0a, 0xce, 0x92, 0xd8, 0xe4, 0x69, 0x90, 0x96, 0x5e, 0x4e,
	0xa8, 0xc2, 0x40, 0x02, 0x10, 0x8b, 0x35, 0x42, 0xe9, 0x95, 0x39, 0x17, 0x75, 0xd9, 0xc9, 0x9c,
	0x62, 0xc2, 0x33, 0xe4, 0x51, 0x3c, 0xe3, 0x37, 0x01, 0x06, 0xd2, 0x07, 0x5d, 0x93, 0xf7, 0xae,
	0xae, 0x27, 0xcf, 0x27, 0xd8, 0x0c, 0x33, 0x8d, 0x38, 0xf5, 0x45, 0x3c, 0xd1, 0xc7, 0x30, 0x13,
	0x65, 0x34, 0xbe, 0x43, 0x1e, 0x8f, 0x2e, 0x20, 0x48, 0x7c, 0xe2, 0xe8, 0x19, 0x72, 0x54, 0x7e,
	0x22, 0xc3, 0x24, 0xab, 0x40, 0xde, 0x40, 0x88, 0xb7, 0x61, 0xc9, 0x8f, 0x96, 0x59, 0xe3, 0x15,
	0x68, 0x10, 0x8e, 0x46, 0xb0, 0x52, 0xca, 0x57, 0x54, 0xe4, 0x27, 0x41, 0xde, 0xff, 0xc2, 0x52,
	0xdc, 0x1d, 0x48, 0x24, 0xcc, 0xa7, 0x05, 0x51, 0x2c, 0x9b, 0x7c, 0x0c, 0x8b, 0x29, 0x56, 0x74,
	0x17, 0x39, 0x7a, 0x17, 0x8b, 0x9c, 0xc2, 0x7e, 0x5f, 0x96, 0x96, 0xe8, 0x9e, 0x7a, 0xa9, 0xdb,
	0xfd, 0x20, 0x8b, 0xf0, 0x0f, 0xc5, 0x84, 0x99, 0x2a, 0xb6, 0xf1, 0x89, 0x4b, 0xa3, 0x7d, 0x16,
	0xdb, 0x3b, 0x90, 0x37, 0x2d, 0xaf, 0x67, 0xeb, 0xe7, 0x1a, 0xc3, 0x05, 0x79, 0x8a, 0xc3, 0x0e,
	0x29, 0x49, 0x22, 0x93, 0xe5, 0x52, 0x99, 0x4c, 0xf9, 0xb9, 0x0c, 0xf3, 0xa1, 0x18, 0xee, 0x1e,
	0x0e, 0xcc, 0x1a, 0x02, 0x62, 0x85, 0xe1, 0xa7, 0x71, 0x75, 0xfb, 0x0e, 0xb2, 0x2b, 0xab, 0xd8,
	0x20, 0x1d, 0x87, 0x6e, 0xc5, 0x10, 0xa1, 0xc6, 0x05, 0xa0, 0x43, 0x00, 0x76, 0xea, 0x65, 0xc7,
	0x21, 0x71, 0xfe, 0xdf, 0x19, 0xc1, 0x67, 0xe8, 0x30, 0x75, 0x86, 0xb2, 0x60, 0x3f, 0xd7, 0x7f,
	0x20, 0xc1, 0x52, 0x86, 0x50, 0xf4, 0x01, 0xcc, 0x04, 0x62, 0x83, 0xf4, 0xfb, 0x68, 0x8c, 0x59,
	0xa9, 0x11, 0x97, 0x4b, 0x0b, 0x8e, 0xef, 0x4b, 0xb0, 0x19, 0x0d, 0xe4, 0x3a, 0x51, 0xb3, 0xc7,
	0xe2, 0xbc, 0x01, 0x85, 0x90, 0x1f, 0x37, 0x41, 0x60, 0xf2, 0xaf, 0x8e, 0x6b, 0x72, 0x75, 0xc1,
	0x18, 0xf8, 0xf6, 0x68, 0x01, 0x5a, 0x48, 0x06, 0x88, 0x4c, 0x9f, 0x6a, 0xc2, 0x64, 0x8f, 0x0a,
	0x11, 0xb1, 0xf1, 0xf1, 0x38, 0x81, 0xf8, 0x39, 0x76, 0x7d, 0x7c, 0xa6, 0x72, 0x46, 0x09, 0x13,
	0xe5, 0x52, 0x26, 0xfa, 0x4c, 0x82, 0xd5, 0x81, 0x73, 0x4b, 0xcc, 0x36, 0xfb, 0x30, 0x25, 0x2c,
	0xc2, 0x37, 0xf9, 0xc8, 0x5e, 0x21, 0x86, 0xa3, 0x5b, 0x30, 0xe3, 0x9f, 0xf6, 0xbb, 0x27, 0x8e,
	0x6e, 0xd9, 0x6c, 0x3b, 0xe7, 0xd5, 0x08, 0xa0, 0x98, 0xb0, 0x96, 0x38, 0xa6, 0x64, 0xea, 0x20,
	0x5d, 0x4b, 0x07, 0xe5, 0x3f, 0xe7, 0x61, 0x85, 0x45, 0xcf, 0x88, 0xb9, 0x8a, 0xbd, 0xbe, 0xed,
	0x7b, 0x17, 0x37, 0x4b, 0x63, 0xd1, 0x1a, 0x5e, 0x4f, 0xb4, 0xee, 0xc3, 0x9a, 0xf8, 0xa9, 0xf1,
	0xa3, 0x7f, 0xac, 0x21, 0x2d, 0x62, 0xf6, 0xbb, 0x23, 0x96, 0x66, 0xb1, 0x39, 0xad, 0x0a, 0xde,
	0x09, 0xb8, 0x87, 0x7e, 0x47, 0x02, 0x25, 0x90, 0xdb, 0x73, 0xb1, 0xc7, 0x4e, 0xde, 0x69, 0x05,
	0x56, 0xaf, 0xab, 0xc0, 0x6d, 0x21, 0xa4, 0x29, 0x64, 0xa4, 0x14, 0x21, 0xb0, 0xc2, 0x5a, 0x90,
	0x69, 0xd9, 0xb9, 0xeb, 0xca, 0x2e, 0x52, 0xc6, 0x29, 0x81, 0x9f, 0x49, 0x70, 0x9b, 0x49, 0xbc,
	0x60, 0xda, 0xa5, 0xeb, 0x8a, 0x66, 0x6d, 0xd5, 0xa1, 0x73, 0xfe, 0x04, 0x56, 0x79, 0xcf, 0x24,
	0x2d, 0x79, 0xe2, 0xba, 0x92, 0x97, 0x19, 0xe7, 0x94, 0xc8, 0x4f, 0x61, 0x3d, 0xd1, 0xcd, 0x8c,
	0x4b, 0x9d, 0x63, 0x52, 0x2b, 0x63, 0xb6, 0x34, 0x63, 0xd2, 0x4b, 0xed, 0x6c, 0x84, 0x87, 0x74,
	0x28, 0x30, 0xab, 0xc7, 0xc5, 0x4e, 0x5d, 0xab, 0x7b, 0xbe, 0x40, 0xf9, 0xc5, 0x45, 0xf8, 0xb0,
	0x14, 0xb6, 0x91, 0x23, 0x31, 0xa5, 0x9b, 0xa3, 0x76, 0x4d, 0x87, 0x9e, 0x03, 0x54, 0x14, 0xf0,
	0x8f, 0xc5, 0x24, 0x17, 0x96, 0xb3, 0x7a, 0xb6, 0x5e, 0x69, 0x96, 0xcd, 0xee, 0xeb, 0xd7, 0xea,
	0xd6, 0xaa, 0xc5, 0x8c, 0x3e, 0xad, 0x47, 0xf3, 0x14, 0x6b, 0xd1, 0xc6, 0x8d, 0x99, 0x1f, 0x35,
	0x4f, 0xb5, 0xf0, 0x59, 0x7c, 0x6e, 0x0b, 0xfe, 0xc0, 0x37, 0xf5, 0x52, 0x24, 0x7a, 0xa3, 0x71,
	0x31, 0xf3, 0x4c, 0xcc, 0xee, 0xb8, 0x7d, 0xd1, 0x98, 0xc0, 0x45, 0xce, 0x3d, 0x2e, 0xf2, 0xfb,
	0x12, 0xdc, 0xb2, 0x49, 0x87, 0x68, 0x6e, 0x94, 0x9e, 0x07, 0xa4, 0x2f, 0x31, 0xe9, 0x23, 0xac,
	0x65, 0x83, 0x74, 0x48, 0x66, 0xae, 0x57, 0xd7, 0xed, 0x61, 0x28, 0xae, 0x47, 0xaa, 0x21, 0x1d,
	0xd7, 0xa3, 0x38, 0xaa, 0x1e, 0x43, 0x73, 0x9a, 0xba, 0xde, 0x1b, 0x86, 0xf2, 0xd0, 0x1f, 0x4b,
	0x70, 0x27, 0x2a, 0x48, 0x86, 0x19, 0x65, 0x79, 0xd4, 0x9b, 0x91, 0x8b, 0xab, 0x20, 0xf5, 0xb6,
	0x71, 0x21, 0xde, 0x43, 0xdb, 0x30, 0x89, 0x5d, 0x97, 0xb8, 0xa5, 0x19, 0x26, 0x19, 0x05, 0x92,
	0xdd, 0x9e, 0x51, 0x3e, 0x66, 0x37, 0x92, 0x2a, 0x27, 0x50, 0x7e, 0x20, 0xc1, 0x72, 0xe2, 0x4a,
	0xd2, 0xeb, 0x11, 0xc7, 0xc3, 0x88, 0x00, 0x8a, 0xe6, 0xa0, 0xb9, 0x3c, 0xf9, 0x8a, 0xb4, 0xfe,
	0xad, 0x11, 0x23, 0x42, 0x2a, 0x89, 0xab, 0x8b, 0x7a, 0x12, 0xa4, 0xfc, 0x97, 0x0c, 0xab, 0x09,
	0xea, 0xa6, 0x4b, 0x3a, 0x2e, 0xf6, 0x2e, 0xc9, 0xf9, 0x5f, 0x84, 0x42, 0x4f, 0x10, 0x6a, 0x3d,
	0xec, 0x1a, 0x58, 0x54, 0x64, 0x93, 0xea, 0x42, 0x00, 0x6f, 0x72, 0x30, 0x7a, 0x17, 0x20, 0x6a,
	0x25, 0x8a, 0xea, 0x79, 0x3d, 0x75, 0xa4, 0x0d, 0x0f, 0x56, 0xea, 0x4c, 0xd8, 0x44, 0x44, 0xef,
	0xc1, 0x6c, 0xbf, 0x67, 0xea, 0x3e, 0xe6, 0x63, 0x27, 0x2e, 0x1d, 0x0b, 0x9c, 0x9c, 0x0d, 0x7e,
	0x1f, 0x6e, 0x8a, 0x6b, 0x55, 0xd6, 0x00, 0x1e, 0xe7, 0x76, 0x56, 0x0d, 0x38, 0xc4, 0x6b, 0x9c,
	0xa9, 0xd7, 0x52, 0xe3, 0x28, 0xbf, 0x97, 0xf4, 0x82, 0xd0, 0xf0, 0x2e, 0x2c, 0xc5, 0xbc, 0x20,
	0x30, 0xa7, 0x70, 0x83, 0xca, 0xd8, 0x6e, 0x10, 0xf0, 0x57, 0x63, 0x3e, 0x16, 0xc0, 0x94, 0xbf,
	0x9e, 0x80, 0xb5, 0xa1, 0x17, 0x63, 0x68, 0x3b, 0xd9, 0x4d, 0x94, 0x82, 0x6b, 0x61, 0x79, 0xb0,
	0xa5, 0x88, 0xca, 0x50, 0xe8, 0xea, 0x67, 0x9a, 0x6e, 0xfb, 0xd8, 0x75, 0x74, 0xdf, 0x7a, 0x29,
	0x1a, 0xf6, 0x93, 0xfc, 0x74, 0xba, 0xd0, 0xd5, 0xcf, 0x2a, 0x31, 0x1c, 0xa5, 0x6f, 0x5b, 0x14,
	0x40, 0xe7, 0xd9, 0xd6, 0x1d, 0x7a, 0xf2, 0x61, 0x9d, 0x6f, 0x41, 0xcf, 0x91, 0xcd, 0x00, 0x87,
	0x30, 0x2c, 0x88, 0xc4, 0x22, 0x2e, 0xc8, 0x83, 0xea, 0xe0, 0x57, 0x46, 0x4d, 0x29, 0xe2, 0xe6,
	0x9a, 0xcb, 0x99, 0xf7, 0xe2, 0x30, 0x0f, 0xd5, 0xe0, 0x16, 0x76, 0xf4, 0x13, 0x1b, 0x6b, 0x7a,
	0xdf, 0x27, 0x5d, 0xdd, 0xb7, 0x0c, 0xad, 0xd7, 0x77, 0x0c, 0xbf, 0xcf, 0xd3, 0xe7, 0x64, 0xa4,
	0xe2, 0x3a, 0x27, 0xac, 0x04, 0x74, 0xcd, 0x88, 0x0c, 0xfd, 0x02, 0xe4, 0xf5, 0xbe, 0x69, 0x91,
	0xe0, 0xd8, 0x44, 0x73, 0xbb, 0xb0, 0xc4, 0x2c, 0x43, 0xf0, 0xd3, 0x0f, 0xaa, 0x80, 0xe0, 0xa2,
	0x79, 0x3d, 0xac, 0xbf, 0xc0, 0xae, 0x66, 0x5a, 0xba, 0x6b, 0x7d, 0x37, 0xca, 0xd5, 0x42, 0x58,
	0x89, 0x93, 0x1d, 0x73, 0xaa, 0xbd, 0x88, 0x08, 0x7d, 0x13, 0xd6, 0x62, 0x63, 0x42, 0x3e, 0x06,
	0xe9, 0x3b, 0x3e, 0xbb, 0xa4, 0x14, 0x72, 0x57, 0x63, 0x54, 0x82, 0x4d, 0x95, 0xd2, 0xa0, 0x77,
	0x61, 0x45, 0xe8, 0xf0, 0x8a, 0xb8, 0x66, 0xec, 0xee, 0x89, 0x05, 0x34, 0x21, 0xbf, 0xc8, 0x49,
	0x7e, 0x8d, 0xb8, 0x66, 0x74, 0xf7, 0xa4, 0x94, 0x61, 0x6e, 0xc0, 0xa6, 0x68, 0x03, 0x6e, 0xf6,
	0x4e, 0x5d, 0xdd, 0x13, 0x87, 0x73, 0xf1, 0x80, 0x20, 0x80, 0x29, 0x7f, 0x2e, 0xc1, 0x52, 0x86,
	0xb3, 0xa1, 0xef, 0x40, 0x7e, 0xc0, 0x71, 0xb8, 0xc7, 0x3f, 0x19, 0x75, 0x65, 0xe3, 0x01, 0x3a,
	0x62, 0xa7, 0x0e, 0xf0, 0x4e, 0xbb, 0xb4, 0x1c, 0xb8, 0x74, 0x2e, 0xd1, 0x25, 0xff, 0xb1, 0x04,
	0xb7, 0x2e, 0x62, 0x4c, 0x0f, 0x90, 0x51, 0x95, 0x23, 0x22, 0x65, 0x0c, 0x92, 0xe8, 0xd5, 0xc8,
	0x41, 0xaf, 0x26, 0x37, 0xd0, 0x62, 0x79, 0x0a, 0x93, 0xd4, 0xee, 0x41, 0x85, 0xff, 0xf0, 0xea,
	0x93, 0xa6, 0x8b, 0x51, 0x77, 0xda, 0x84, 0xf3, 0xe4, 0x5c, 0x94, 0x7f, 0x95, 0x60, 0x3a, 0x40,
	0xa0, 0xaf, 0x0e, 0x44, 0xe0, 0x4b, 0xdb, 0xcd, 0xb1, 0x00, 0xfc, 0x0e, 0x4c, 0x07, 0xf7, 0x37,
	0x97, 0x37, 0x23, 0x6f, 0x8a, 0x8b, 0x1b, 0x7a, 0x6e, 0xa7, 0x5a, 0x88, 0x6e, 0x0e, 0xfb, 0x3d,
	0xac, 0x61, 0x35, 0x68, 0x84, 0x7b, 0x30, 0x1b, 0x38, 0xae, 0xaf, 0xf3, 0x47, 0x05, 0x93, 0x82,
	0x4a, 0xc0, 0x5b, 0x7a, 0x47, 0x29, 0x43, 0x21, 0x79, 0x96, 0x47, 0x79, 0x90, 0xce, 0x44, 0x63,
	0x58, 0x62, 0x5f, 0xe7, 0xa2, 0xd9, 0x21, 0x9d, 0x2b, 0x3d, 0x58, 0x49, 0x37, 0x61, 0x9b, 0xc4,
	0x3e, 0x47, 0xcf, 0x61, 0xfa, 0x25, 0x76, 0x7d, 0xcb, 0x08, 0x9d, 0xed, 0x3a, 0xfd, 0x84, 0x90,
	0x97, 0xf2, 0x8f, 0x12, 0xcc, 0xd2, 0x4a, 0xf2, 0xff, 0xec, 0xca, 0x0a, 0xbd, 0x1f, 0x36, 0xe7,
	0xb9, 0x3f, 0x3d, 0x1a, 0xad, 0x04, 0x1e, 0xec, 0xc8, 0xff, 0x8d, 0x04, 0x33, 0x21, 0x14, 0xb9,
	0x50, 0x74, 0x59, 0xd6, 0xca, 0xec, 0x8c, 0x7f, 0xeb, 0x3a, 0x9d, 0x71, 0xba, 0x28, 0x2a, 0x12,
	0xdc, 0x5f, 0x53, 0x5f, 0x5c, 0x79, 0x05, 0xf3, 0x83, 0x55, 0x3d, 0xf5, 0x4f, 0xf6, 0xb6, 0x4a,
	0xf4, 0x95, 0x58, 0xc8, 0xfa, 0x20, 0x76, 0x9d, 0xc4, 0x3b, 0x0c, 0xbf, 0x3c, 0x9a, 0xc9, 0x52,
	0xb7, 0x49, 0xca, 0xe7, 0x12, 0x2c, 0x0d, 0x16, 0xfa, 0xdc, 0x80, 0xff, 0x1f, 0x6f, 0x17, 0x94,
	0x9f, 0xc9, 0x50, 0x1a, 0x76, 0x6a, 0x79, 0x8d, 0x97, 0x86, 0x9b, 0xe9, 0x30, 0x31, 0xe0, 0xd7,
	0xcf, 0x42, 0xbf, 0x96, 0x47, 0x3d, 0x49, 0x66, 0x2c, 0x45, 0xe0, 0xe1, 0x48, 0x8d, 0x36, 0x68,
	0xee, 0x3a, 0x1b, 0xf4, 0xe0, 0x46, 0xb4, 0x45, 0xdf, 0x82, 0x69, 0x96, 0xf6, 0x83, 0x67, 0x74,
	0x39, 0x8a, 0x64, 0x90, 0xba, 0xb9, 0x9b, 0x67, 0x39, 0x83, 0x22, 0x9d, 0x36, 0x51, 0xbe, 0x27,
	0xc3, 0xda, 0xd0, 0x43, 0xd9, 0x6b, 0xb4, 0x6e, 0xd4, 0x2a, 0x94, 0xaf, 0xd7, 0xae, 0xbc, 0xd6,
	0xe5, 0x6b, 0xf6, 0x73, 0x3f, 0xe5, 0xef, 0x24, 0xd8, 0x38, 0xf6, 0x5d, 0xac, 0x77, 0x23, 0xe7,
	0x1a, 0x7c, 0xb2, 0x69, 0x40, 0x3e, 0xf6, 0x30, 0xa6, 0x23, 0xcc, 0x31, 0xc2, 0xbd, 0x63, 0xc8,
	0xfe, 0x79, 0xf8, 0x7a, 0xa6, 0x73, 0x70, 0x43, 0x9d, 0x8d, 0x1e, 0xd3, 0x74, 0xd0, 0x17, 0x92,
	0x4f, 0x3f, 0xe9, 0x36, 0xc9, 0x1f, 0xdc, 0x18, 0x7c, 0xfc, 0xb9, 0xbb, 0x04, 0x8b, 0x5e, 0xc0,
	0x4d, 0x73, 0xb9, 0x82, 0xca, 0x7f, 0x4b, 0xb0, 0x39, 0x6c, 0x0a, 0xe2, 0x88, 0x17, 0x1e, 0x13,
	0xa5, 0x4b, 0x8e, 0x89, 0xe8, 0x2c, 0xf3, 0x30, 0xc8, 0x37, 0x6d, 0x7d, 0xdc, 0x39, 0x5f, 0xe5,
	0x54, 0x88, 0xde, 0x81, 0x95, 0xb4, 0x64, 0x76, 0x0c, 0xe4, 0x19, 0xbd, 0x98, 0x1a, 0xf2, 0xcc,
	0xb5, 0x94, 0x3d, 0xb8, 0x1b, 0xcd, 0x9d, 0x56, 0xc3, 0x76, 0xd5, 0xd6, 0x3d, 0xcf, 0x6a, 0x5b,
	0xfc, 0xd9, 0xa8, 0xb0, 0xef, 0x06, 0x00, 0x7b, 0x73, 0xa2, 0xc5, 0x5a, 0xfb, 0x33, 0x0c, 0x72,
	0xa8, 0x77, 0x71, 0x06, 0x97, 0xcc, 0xa7, 0x49, 0x97, 0x70, 0xf9, 0x22, 0xfc, 0x62, 0xc8, 0xe5,
	0xe2, 0xc7, 0x4a, 0x4a, 0x23, 0xe6, 0x75, 0x99, 0xef, 0xcf, 0x32, 0xdf, 0x83, 0x49, 0xd9, 0xef,
	0xc1, 0x94, 0xdb, 0x31, 0x6e, 0x59, 0x8a, 0x2b, 0xf7, 0x40, 0x09, 0x09, 0x86, 0xbe, 0xd3, 0x52,
	0xfe, 0x52, 0x82, 0x95, 0x88, 0xcc, 0x27, 0x2e, 0x2b, 0x46, 0x99, 0x3a, 0xfb, 0xb0, 0x15, 0x9c,
	0x15, 0x38, 0x5c, 0x4b, 0xad, 0x95, 0xd0, 0x6e, 0x43, 0x1c, 0x16, 0x38, 0x59, 0x72, 0xe5, 0xd1,
	0x53, 0xb8, 0x9b, 0x1a, 0x19, 0xf2, 0x34, 0x2d, 0x17, 0x1b, 0x3e, 0x71, 0xcf, 0xc5, 0x92, 0x6f,
	0x25, 0x97, 0x5c, 0x70, 0xdd, 0x0b, 0xe8, 0x94, 0x7f, 0xc9, 0xc1, 0xed, 0x4b, 0x7c, 0x2d, 0xb3,
	0xdf, 0x29, 0xbd, 0xde, 0x7e, 0x67, 0x1b, 0x16, 0xdf, 0xc0, 0x95, 0x41, 0xc1, 0x4e, 0xf6, 0x8e,
	0x87, 0xf4, 0x55, 0x73, 0x6f, 0xb6, 0xaf, 0x9a, 0xdd, 0x7e, 0x9c, 0x78, 0x83, 0xed, 0x47, 0xe5,
	0x1f, 0xa6, 0xa1, 0x98, 0x15, 0x37, 0x51, 0x2b, 0xea, 0xaf, 0xf0, 0xa7, 0x98, 0x8f, 0xc7, 0x08,
	0x4a, 0xa9, 0x46, 0xcb, 0x1f, 0x5c, 0xf6, 0xfc, 0x9a, 0x07, 0xc0, 0xc6, 0x18, 0xb2, 0x86, 0x6e,
	0xb7, 0x83, 0x1b, 0x17, 0xbd, 0xc4, 0xfe, 0x74, 0xe8, 0x33, 0x74, 0xbe, 0xd8, 0xfb, 0x63, 0xa8,
	0x92, 0x15, 0x68, 0x0e, 0x6e, 0x0c, 0x79, 0x91, 0xfe, 0xa7, 0x23, 0x3c, 0x05, 0xff, 0x60, 0x0c,
	0x65, 0x2e, 0x0e, 0x90, 0x07, 0x37, 0x2e, 0x7d, 0x15, 0xfe, 0xe9, 0xd0, 0x07, 0xc3, 0x93, 0x63,
	0x5b, 0x28, 0x2b, 0x78, 0x52, 0x0b, 0x65, 0xbd, 0x1d, 0x46, 0x7f, 0x28, 0xc1, 0x2d, 0xd6, 0xa8,
	0xb1, 0x35, 0x63, 0x20, 0xe7, 0x04, 0x7a, 0xf0, 0x6e, 0xf0, 0xd3, 0x31, 0xf4, 0x18, 0x9e, 0xc9,
	0x0e, 0x6e, 0xa8, 0xeb, 0xfa, 0xf0, 0x3c, 0xf7, 0x47, 0x12, 0x6c, 0x08, 0x9d, 0x86, 0x18, 0x67,
	0xe5, 0x9a, 0x4a, 0x0d, 0x31, 0x91, 0x50, 0x2a, 0x33, 0x6d, 0x76, 0x60, 0x3e, 0x88, 0xf0, 0x42,
	0x89, 0xcd, 0x51, 0x4f, 0x6d, 0xd9, 0x69, 0x49, 0x9d, 0xf3, 0xe2, 0x9f, 0xbb, 0x08, 0x0a, 0x51,
	0x79, 0xc4, 0x45, 0xdd, 0xff, 0xa1, 0x0c, 0x37, 0xc5, 0x7e, 0x47, 0xab, 0xb0, 0xf4, 0xa4, 0x56,
	0x69, 0x3d, 0x53, 0x6b, 0xda, 0xb3, 0xc3, 0xe3, 0x66, 0xad, 0x5a, 0x7f, 0x52, 0xaf, 0xed, 0x15,
	0x6e, 0xa0, 0x25, 0x58, 0x68, 0x54, 0x76, 0x6b, 0x0d, 0x6d, 0xaf, 0xd6, 0xaa, 0x55, 0x5b, 0xf5,
	0xa3, 0xc3, 0x82, 0x84, 0xd6, 0x60, 0xf9, 0xf8, 0xe0, 0xa8, 0xa5, 0x55, 0x0f, 0x2a, 0x87, 0xfb,
	0xb5, 0x18, 0x4a, 0x46, 0x9b, 0xb0, 0x5e, 0xfb, 0x76, 0xb3, 0x51, 0xaf, 0xd6, 0x5b, 0x5a, 0xf5,
	0xe8, 0xb0, 0x55, 0x3b, 0x6c, 0xc5, 0xf0, 0x39, 0x84, 0x60, 0xfe, 0x49, 0xa5, 0x1a, 0x1f, 0x33,
	0x81, 0x4a, 0x50, 0x3c, 0x6e, 0xd6, 0x6a, 0xd5, 0x03, 0xad, 0xa5, 0x56, 0x0e, 0x8f, 0xab, 0x6a,
	0xbd, 0xc9, 0x30, 0x53, 0x94, 0xba, 0x55, 0xfb, 0x76, 0x9c, 0xc3, 0x4d, 0xaa, 0xd1, 0xd1, 0xee,
	0xaf, 0xd6, 0xaa, 0x2d, 0x4a, 0x5d, 0x7d, 0xbf, 0x7e, 0xb8, 0x5f, 0x98, 0x41, 0x45, 0x28, 0x34,
	0x8e, 0xf6, 0x8f, 0x34, 0xb5, 0x56, 0x3d, 0xda, 0x3f, 0xac, 0x33, 0xd2, 0x3c, 0xd5, 0xb3, 0x5a,
	0x6b, 0xd4, 0x76, 0xd5, 0x7a, 0xeb, 0xc3, 0x01, 0xd4, 0x1c, 0x1d, 0xd0, 0xac, 0xa9, 0xc7, 0x47,
	0x87, 0x31, 0xde, 0xf3, 0xf7, 0x5d, 0x40, 0xe9, 0x57, 0xe9, 0xe8, 0x1e, 0x6c, 0x25, 0x6c, 0xa0,
	0x3d, 0x3d, 0xda, 0x4b, 0x5a, 0x6a, 0x0e, 0x66, 0x98, 0x51, 0x28, 0xaa, 0x20, 0xa1, 0x79, 0x80,
	0x27, 0x6a, 0xe5, 0x69, 0x8d, 0x7f, 0xcb, 0xd4, 0xc2, 0x0c, 0x5d, 0x39, 0xdc, 0xd3, 0x62, 0x88,
	0xdc, 0x7d, 0x1f, 0x20, 0x7a, 0xe2, 0x87, 0xd6, 0x61, 0xa5, 0x51, 0x7f, 0xbf, 0xd6, 0xa8, 0x1f,
	0x1c, 0x1d, 0xed, 0x25, 0x24, 0x2c, 0xc2, 0xdc, 0xf3, 0x9a, 0xfa, 0xa1, 0xf6, 0xec, 0x90, 0x91,
	0x7c, 0x58, 0x90, 0x50, 0x1e, 0xa6, 0xc3, 0x2f, 0x99, 0x7e, 0x35, 0x8f, 0x8e, 0x8f, 0xeb, 0xbb,
	0x8d, 0x5a, 0x21, 0x87, 0x00, 0xa6, 0x04, 0x66, 0x02, 0x2d, 0xc0, 0x2c, 0x1b, 0x2a, 0x00, 0x93,
	0xf7, 0x7f, 0x5f, 0x86, 0x42, 0x32, 0xea, 0xa3, 0x3b, 0xb0, 0x71, 0xdc, 0x52, 0x6b, 0x95, 0xa7,
	0xf5, 0xc3, 0x7d, 0x2d, 0xdb, 0x1f, 0x36, 0x60, 0x2d, 0x22, 0x49, 0x7b, 0xc6, 0x5d, 0xb8, 0x1d,
	0xa1, 0x87, 0xf9, 0xc8, 0x36, 0xdc, 0x8b, 0x88, 0x2e, 0xf4, 0x96, 0x01, 0x69, 0xc9, 0x55, 0x9f,
	0x18, 0x94, 0x56, 0x79, 0xd6, 0x3a, 0x7a, 0xda, 0xd0, 0xaa, 0x8d, 0xca, 0xf1, 0x71, 0xfd, 0x49,
	0xbd, 0x5a, 0x61, 0x3c, 0x96, 0xe9, 0xea, 0xa5, 0x88, 0x92, 0xac, 0x56, 0x1e, 0xfe, 0x44, 0x86,
	0x12, 0xcb, 0xa6, 0xf5, 0xd8, 0x36, 0x3b, 0xc6, 0xee, 0x4b, 0xcb, 0xc0, 0xe8, 0xe7, 0x12, 0xcc,
	0x0d, 0x1c, 0x1f, 0xd0, 0x08, 0x87, 0x9c, 0xac, 0xa3, 0xd3, 0xfa, 0x46, 0x30, 0x3e, 0xf6, 0x37,
	0xbc, 0xf2, 0x51, 0xf0, 0x37, 0x3c, 0xe5, 0xc5, 0xe7, 0x95, 0xf2, 0xb0, 0x4b, 0xa9, 0xec, 0x5b,
	0x8a, 0x9f, 0x55, 0x50, 0x78, 0x3b, 0xf4, 0x76, 0xf0, 0xf7, 0xb5, 0xef, 0xfd, 0xf4, 0x3f, 0x7e,
	0x24, 0xdf, 0x56, 0xd6, 0x93, 0xff, 0x4c, 0xf4, 0x1e, 0x8b, 0x72, 0x05, 0x3f, 0x96, 0xee, 0xaf,
	0xb7, 0x3e, 0xaf, 0x6c, 0xa5, 0x27, 0xc0, 0xf5, 0xd3, 0x7b, 0x96, 0x57, 0x36, 0x48, 0xf7, 0x9f,
	0x2b, 0xe5, 0x53, 0xdf, 0xef, 0x79, 0x8f, 0x77, 0x76, 0x5e, 0xbd, 0x7a, 0x95, 0x40, 0xee, 0xe8,
	0x7d, 0xff, 0x94, 0xff, 0x2b, 0xf2, 0x4b, 0x3d, 0x5b, 0xf7, 0xdb, 0xc4, 0xed, 0x3e, 0xfc, 0x0b,
	0x19, 0xee, 0x0c, 0xd6, 0x29, 0x59, 0x96, 0xfd, 0xab, 0x78, 0x61, 0x3d, 0x68, 0xe2, 0x71, 0xb2,
	0x54, 0xa6, 0xad, 0x0f, 0xae, 0xcf, 0x88, 0x9b, 0x5e, 0xb9, 0xb1, 0x2d, 0x7d, 0x59, 0x7a, 0x33,
	0xf6, 0xda, 0xfd, 0x4c, 0x86, 0xb7, 0x0d, 0xd2, 0xbd, 0xb2, 0xae, 0xbb, 0x1b, 0xc3, 0x8c, 0xda,
	0x74, 0x89, 0x4f, 0x9a, 0xd2, 0xaf, 0x7f, 0x28, 0x58, 0x75, 0x88, 0xad, 0x3b, 0x9d, 0x32, 0x71,
	0x3b, 0x3b, 0x1d, 0xec, 0xb0, 0xb6, 0xd2, 0x4e, 0xa4, 0xd0, 0xe5, 0xff, 0x66, 0x7d, 0x2f, 0x85,
	0xfb, 0x33, 0x79, 0x7b, 0x9f, 0xf3, 0xae, 0x32, 0x35, 0x53, 0x9a, 0x94, 0x9f, 0x3f, 0x68, 0x3e,
	0xda, 0xa5, 0x83, 0x3f, 0x0f, 0x48, 0x3f, 0x62, 0xa4, 0x1f, 0xa5, 0x48, 0x3f, 0x7a, 0x1e, 0xc8,
	0x39, 0x99, 0x62, 0xba, 0x3d, 0xfa, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xea, 0xb0, 0x84, 0x8a,
	0x68, 0x3b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVideoIntelligenceServiceClient(cc grpc.ClientConnInterface) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1p3beta1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

// UnimplementedVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoIntelligenceServiceServer struct {
}

func (*UnimplementedVideoIntelligenceServiceServer) AnnotateVideo(ctx context.Context, req *AnnotateVideoRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnnotateVideo not implemented")
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1p3beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p3beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1p3beta1/video_intelligence.proto",
}

// StreamingVideoIntelligenceServiceClient is the client API for StreamingVideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StreamingVideoIntelligenceServiceClient interface {
	// Performs video annotation with bidirectional streaming: emitting results
	// while sending video/audio bytes.
	// This method is only available via the gRPC API (not REST).
	StreamingAnnotateVideo(ctx context.Context, opts ...grpc.CallOption) (StreamingVideoIntelligenceService_StreamingAnnotateVideoClient, error)
}

type streamingVideoIntelligenceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStreamingVideoIntelligenceServiceClient(cc grpc.ClientConnInterface) StreamingVideoIntelligenceServiceClient {
	return &streamingVideoIntelligenceServiceClient{cc}
}

func (c *streamingVideoIntelligenceServiceClient) StreamingAnnotateVideo(ctx context.Context, opts ...grpc.CallOption) (StreamingVideoIntelligenceService_StreamingAnnotateVideoClient, error) {
	stream, err := c.cc.NewStream(ctx, &_StreamingVideoIntelligenceService_serviceDesc.Streams[0], "/google.cloud.videointelligence.v1p3beta1.StreamingVideoIntelligenceService/StreamingAnnotateVideo", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingVideoIntelligenceServiceStreamingAnnotateVideoClient{stream}
	return x, nil
}

type StreamingVideoIntelligenceService_StreamingAnnotateVideoClient interface {
	Send(*StreamingAnnotateVideoRequest) error
	Recv() (*StreamingAnnotateVideoResponse, error)
	grpc.ClientStream
}

type streamingVideoIntelligenceServiceStreamingAnnotateVideoClient struct {
	grpc.ClientStream
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoClient) Send(m *StreamingAnnotateVideoRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoClient) Recv() (*StreamingAnnotateVideoResponse, error) {
	m := new(StreamingAnnotateVideoResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// StreamingVideoIntelligenceServiceServer is the server API for StreamingVideoIntelligenceService service.
type StreamingVideoIntelligenceServiceServer interface {
	// Performs video annotation with bidirectional streaming: emitting results
	// while sending video/audio bytes.
	// This method is only available via the gRPC API (not REST).
	StreamingAnnotateVideo(StreamingVideoIntelligenceService_StreamingAnnotateVideoServer) error
}

// UnimplementedStreamingVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedStreamingVideoIntelligenceServiceServer struct {
}

func (*UnimplementedStreamingVideoIntelligenceServiceServer) StreamingAnnotateVideo(srv StreamingVideoIntelligenceService_StreamingAnnotateVideoServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingAnnotateVideo not implemented")
}

func RegisterStreamingVideoIntelligenceServiceServer(s *grpc.Server, srv StreamingVideoIntelligenceServiceServer) {
	s.RegisterService(&_StreamingVideoIntelligenceService_serviceDesc, srv)
}

func _StreamingVideoIntelligenceService_StreamingAnnotateVideo_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StreamingVideoIntelligenceServiceServer).StreamingAnnotateVideo(&streamingVideoIntelligenceServiceStreamingAnnotateVideoServer{stream})
}

type StreamingVideoIntelligenceService_StreamingAnnotateVideoServer interface {
	Send(*StreamingAnnotateVideoResponse) error
	Recv() (*StreamingAnnotateVideoRequest, error)
	grpc.ServerStream
}

type streamingVideoIntelligenceServiceStreamingAnnotateVideoServer struct {
	grpc.ServerStream
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoServer) Send(m *StreamingAnnotateVideoResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoServer) Recv() (*StreamingAnnotateVideoRequest, error) {
	m := new(StreamingAnnotateVideoRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _StreamingVideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p3beta1.StreamingVideoIntelligenceService",
	HandlerType: (*StreamingVideoIntelligenceServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingAnnotateVideo",
			Handler:       _StreamingVideoIntelligenceService_StreamingAnnotateVideo_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/videointelligence/v1p3beta1/video_intelligence.proto",
}
