---
layout: post
title: Leaflet 0.6 Released, Code Sprint in DC with MapBox
description: Leaflet 0.6 released &mdash; with nicer controls, better usability and tons of API improvements and various bugfixes &mdash; more than 120 changes! The first ever Leaflet Code Sprint happening in Washington, DC with the MapBox team
author: Vladimir Agafonkin
authorsite: http://agafonkin.com/en
---

_Leaflet 0.6 released &mdash; with nicer controls, better usability and tons of API improvements and various bugfixes &mdash; more than 120 changes! The first ever Leaflet Code Sprint happening in Washington, DC with the MapBox team..._

After 5 months of active development with [36 contributors involved](https://github.com/Leaflet/Leaflet/graphs/contributors?from=2013-01-18&to=2013-06-26&type=c) since the previous major version, today I'm excited to finally announce the **release of Leaflet 0.6** stable.

0.6 highlights include nicer controls, lots of interaction usability improvements, many new API methods, events and options, ability to save layers as [GeoJSON](http://en.wikipedia.org/wiki/GeoJSON), much better test infrastructure and TONS of bugfixes that made Leaflet significantly more reliable. Checkout the huge detailed list of changes (**120+ total**!) [in the changelog](https://github.com/Leaflet/Leaflet/blob/master/CHANGELOG.md). The [API reference](../../../reference.html) was also updated to reflect all these changes.

The final push for the release (last 2 days) was a part of the first ever **Leaflet Code Sprint**, organized in Washington DC by the amazing [MapBox](http://mapbox.com), a company responsible for perhaps the greatest innovations and awesome tools in the geospatial world of recent years, now [using Leaflet for its JS API](mapbox.com/blog/mapbox-js-with-leaflet/) too. The sprint will go on for a week and there are many more awesome improvements to come in upcoming days (and lots of partying as well).

On a related note, even GitHub itself is now [using Leaflet for GeoJSON visualizations](https://github.com/blog/1541-geojson-rendering-improvements), along with [Leaflet.markercluster](github.com/Leaflet/Leaflet.markercluster) & MapBox tiles! How cool is that?

Special thanks go to [Universal Mind](http://universalmind.com/), my awesome employer and sponsor of Leaflet development for the past 5 months, to the most active contributors &mdash; [John Firebaugh](https://github.com/jfirebaugh) and [Tom MacWright](https://github.com/tmcw) of [MapBox](http://mapbox.com), [Dave Leaver](https://github.com/danzel) and [Jacob Toye](https://github.com/jacobtoye) of [Smartrak](http://www.smartrak.co.nz/), [Steve Kashishian](https://github.com/snkashis) of [First Mile Geo](http://www.firstmilegeo.com/), and to everyone else involved in contributions, bug reports, mailing list, Twitter, making awesome apps, etc. You're such an amazing community! I'm really happy to be a part of it.

Grab the CDN links or downloads for the new release on the [download page](../../../download.html) as always. Enjoy! And be sure try it out and report any regressions in your apps so that we can patch them up immediately.

**update** (June 27): 0.6.1 hotfix released with a couple of regressions fixed (particularly the one with FF scroll-zooming too fast).<br>
**update** (June 28): 0.6.2 hotfix released with a couple more minor issues fixed.<br>
**update** (July 17): 0.6.3 released with lots of regressions and bugs fixed.<br>
**update** (July 25): 0.6.4 released with a fix to 0.6.3 regression.

P.S. Everyone who tweets/posts about the new Leaflet release or why he loves Leaflet over the next few days will get a karma boost of over 9000 points. I heard that from a passing monk in Georgetown yesterday, true story!

Cheers,<br />
Vladimir, Leaflet creator and maintainer.
