/* SPDX-License-Identifier: MIT */
/*
 * Copyright 2025 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef __RAS_GFX_V9_0_H__
#define __RAS_GFX_V9_0_H__

enum ras_gfx_v9_subblock {
	/* CPC */
	RAS_GFX_V9__GFX_CPC_INDEX_START = 0,
	RAS_GFX_V9__GFX_CPC_SCRATCH =
		RAS_GFX_V9__GFX_CPC_INDEX_START,
	RAS_GFX_V9__GFX_CPC_UCODE,
	RAS_GFX_V9__GFX_DC_STATE_ME1,
	RAS_GFX_V9__GFX_DC_CSINVOC_ME1,
	RAS_GFX_V9__GFX_DC_RESTORE_ME1,
	RAS_GFX_V9__GFX_DC_STATE_ME2,
	RAS_GFX_V9__GFX_DC_CSINVOC_ME2,
	RAS_GFX_V9__GFX_DC_RESTORE_ME2,
	RAS_GFX_V9__GFX_CPC_INDEX_END =
		RAS_GFX_V9__GFX_DC_RESTORE_ME2,
	/* CPF */
	RAS_GFX_V9__GFX_CPF_INDEX_START,
	RAS_GFX_V9__GFX_CPF_ROQ_ME2 =
		RAS_GFX_V9__GFX_CPF_INDEX_START,
	RAS_GFX_V9__GFX_CPF_ROQ_ME1,
	RAS_GFX_V9__GFX_CPF_TAG,
	RAS_GFX_V9__GFX_CPF_INDEX_END = RAS_GFX_V9__GFX_CPF_TAG,
	/* CPG */
	RAS_GFX_V9__GFX_CPG_INDEX_START,
	RAS_GFX_V9__GFX_CPG_DMA_ROQ =
		RAS_GFX_V9__GFX_CPG_INDEX_START,
	RAS_GFX_V9__GFX_CPG_DMA_TAG,
	RAS_GFX_V9__GFX_CPG_TAG,
	RAS_GFX_V9__GFX_CPG_INDEX_END = RAS_GFX_V9__GFX_CPG_TAG,
	/* GDS */
	RAS_GFX_V9__GFX_GDS_INDEX_START,
	RAS_GFX_V9__GFX_GDS_MEM = RAS_GFX_V9__GFX_GDS_INDEX_START,
	RAS_GFX_V9__GFX_GDS_INPUT_QUEUE,
	RAS_GFX_V9__GFX_GDS_OA_PHY_CMD_RAM_MEM,
	RAS_GFX_V9__GFX_GDS_OA_PHY_DATA_RAM_MEM,
	RAS_GFX_V9__GFX_GDS_OA_PIPE_MEM,
	RAS_GFX_V9__GFX_GDS_INDEX_END =
		RAS_GFX_V9__GFX_GDS_OA_PIPE_MEM,
	/* SPI */
	RAS_GFX_V9__GFX_SPI_SR_MEM,
	/* SQ */
	RAS_GFX_V9__GFX_SQ_INDEX_START,
	RAS_GFX_V9__GFX_SQ_SGPR = RAS_GFX_V9__GFX_SQ_INDEX_START,
	RAS_GFX_V9__GFX_SQ_LDS_D,
	RAS_GFX_V9__GFX_SQ_LDS_I,
	RAS_GFX_V9__GFX_SQ_VGPR,
	RAS_GFX_V9__GFX_SQ_INDEX_END = RAS_GFX_V9__GFX_SQ_VGPR,
	/* SQC (3 ranges) */
	RAS_GFX_V9__GFX_SQC_INDEX_START,
	/* SQC range 0 */
	RAS_GFX_V9__GFX_SQC_INDEX0_START =
		RAS_GFX_V9__GFX_SQC_INDEX_START,
	RAS_GFX_V9__GFX_SQC_INST_UTCL1_LFIFO =
		RAS_GFX_V9__GFX_SQC_INDEX0_START,
	RAS_GFX_V9__GFX_SQC_DATA_CU0_WRITE_DATA_BUF,
	RAS_GFX_V9__GFX_SQC_DATA_CU0_UTCL1_LFIFO,
	RAS_GFX_V9__GFX_SQC_DATA_CU1_WRITE_DATA_BUF,
	RAS_GFX_V9__GFX_SQC_DATA_CU1_UTCL1_LFIFO,
	RAS_GFX_V9__GFX_SQC_DATA_CU2_WRITE_DATA_BUF,
	RAS_GFX_V9__GFX_SQC_DATA_CU2_UTCL1_LFIFO,
	RAS_GFX_V9__GFX_SQC_INDEX0_END =
		RAS_GFX_V9__GFX_SQC_DATA_CU2_UTCL1_LFIFO,
	/* SQC range 1 */
	RAS_GFX_V9__GFX_SQC_INDEX1_START,
	RAS_GFX_V9__GFX_SQC_INST_BANKA_TAG_RAM =
		RAS_GFX_V9__GFX_SQC_INDEX1_START,
	RAS_GFX_V9__GFX_SQC_INST_BANKA_UTCL1_MISS_FIFO,
	RAS_GFX_V9__GFX_SQC_INST_BANKA_MISS_FIFO,
	RAS_GFX_V9__GFX_SQC_INST_BANKA_BANK_RAM,
	RAS_GFX_V9__GFX_SQC_DATA_BANKA_TAG_RAM,
	RAS_GFX_V9__GFX_SQC_DATA_BANKA_HIT_FIFO,
	RAS_GFX_V9__GFX_SQC_DATA_BANKA_MISS_FIFO,
	RAS_GFX_V9__GFX_SQC_DATA_BANKA_DIRTY_BIT_RAM,
	RAS_GFX_V9__GFX_SQC_DATA_BANKA_BANK_RAM,
	RAS_GFX_V9__GFX_SQC_INDEX1_END =
		RAS_GFX_V9__GFX_SQC_DATA_BANKA_BANK_RAM,
	/* SQC range 2 */
	RAS_GFX_V9__GFX_SQC_INDEX2_START,
	RAS_GFX_V9__GFX_SQC_INST_BANKB_TAG_RAM =
		RAS_GFX_V9__GFX_SQC_INDEX2_START,
	RAS_GFX_V9__GFX_SQC_INST_BANKB_UTCL1_MISS_FIFO,
	RAS_GFX_V9__GFX_SQC_INST_BANKB_MISS_FIFO,
	RAS_GFX_V9__GFX_SQC_INST_BANKB_BANK_RAM,
	RAS_GFX_V9__GFX_SQC_DATA_BANKB_TAG_RAM,
	RAS_GFX_V9__GFX_SQC_DATA_BANKB_HIT_FIFO,
	RAS_GFX_V9__GFX_SQC_DATA_BANKB_MISS_FIFO,
	RAS_GFX_V9__GFX_SQC_DATA_BANKB_DIRTY_BIT_RAM,
	RAS_GFX_V9__GFX_SQC_DATA_BANKB_BANK_RAM,
	RAS_GFX_V9__GFX_SQC_INDEX2_END =
		RAS_GFX_V9__GFX_SQC_DATA_BANKB_BANK_RAM,
	RAS_GFX_V9__GFX_SQC_INDEX_END =
		RAS_GFX_V9__GFX_SQC_INDEX2_END,
	/* TA */
	RAS_GFX_V9__GFX_TA_INDEX_START,
	RAS_GFX_V9__GFX_TA_FS_DFIFO =
		RAS_GFX_V9__GFX_TA_INDEX_START,
	RAS_GFX_V9__GFX_TA_FS_AFIFO,
	RAS_GFX_V9__GFX_TA_FL_LFIFO,
	RAS_GFX_V9__GFX_TA_FX_LFIFO,
	RAS_GFX_V9__GFX_TA_FS_CFIFO,
	RAS_GFX_V9__GFX_TA_INDEX_END = RAS_GFX_V9__GFX_TA_FS_CFIFO,
	/* TCA */
	RAS_GFX_V9__GFX_TCA_INDEX_START,
	RAS_GFX_V9__GFX_TCA_HOLE_FIFO =
		RAS_GFX_V9__GFX_TCA_INDEX_START,
	RAS_GFX_V9__GFX_TCA_REQ_FIFO,
	RAS_GFX_V9__GFX_TCA_INDEX_END =
		RAS_GFX_V9__GFX_TCA_REQ_FIFO,
	/* TCC (5 sub-ranges) */
	RAS_GFX_V9__GFX_TCC_INDEX_START,
	/* TCC range 0 */
	RAS_GFX_V9__GFX_TCC_INDEX0_START =
		RAS_GFX_V9__GFX_TCC_INDEX_START,
	RAS_GFX_V9__GFX_TCC_CACHE_DATA =
		RAS_GFX_V9__GFX_TCC_INDEX0_START,
	RAS_GFX_V9__GFX_TCC_CACHE_DATA_BANK_0_1,
	RAS_GFX_V9__GFX_TCC_CACHE_DATA_BANK_1_0,
	RAS_GFX_V9__GFX_TCC_CACHE_DATA_BANK_1_1,
	RAS_GFX_V9__GFX_TCC_CACHE_DIRTY_BANK_0,
	RAS_GFX_V9__GFX_TCC_CACHE_DIRTY_BANK_1,
	RAS_GFX_V9__GFX_TCC_HIGH_RATE_TAG,
	RAS_GFX_V9__GFX_TCC_LOW_RATE_TAG,
	RAS_GFX_V9__GFX_TCC_INDEX0_END =
		RAS_GFX_V9__GFX_TCC_LOW_RATE_TAG,
	/* TCC range 1 */
	RAS_GFX_V9__GFX_TCC_INDEX1_START,
	RAS_GFX_V9__GFX_TCC_IN_USE_DEC =
		RAS_GFX_V9__GFX_TCC_INDEX1_START,
	RAS_GFX_V9__GFX_TCC_IN_USE_TRANSFER,
	RAS_GFX_V9__GFX_TCC_INDEX1_END =
		RAS_GFX_V9__GFX_TCC_IN_USE_TRANSFER,
	/* TCC range 2 */
	RAS_GFX_V9__GFX_TCC_INDEX2_START,
	RAS_GFX_V9__GFX_TCC_RETURN_DATA =
		RAS_GFX_V9__GFX_TCC_INDEX2_START,
	RAS_GFX_V9__GFX_TCC_RETURN_CONTROL,
	RAS_GFX_V9__GFX_TCC_UC_ATOMIC_FIFO,
	RAS_GFX_V9__GFX_TCC_WRITE_RETURN,
	RAS_GFX_V9__GFX_TCC_WRITE_CACHE_READ,
	RAS_GFX_V9__GFX_TCC_SRC_FIFO,
	RAS_GFX_V9__GFX_TCC_SRC_FIFO_NEXT_RAM,
	RAS_GFX_V9__GFX_TCC_CACHE_TAG_PROBE_FIFO,
	RAS_GFX_V9__GFX_TCC_INDEX2_END =
		RAS_GFX_V9__GFX_TCC_CACHE_TAG_PROBE_FIFO,
	/* TCC range 3 */
	RAS_GFX_V9__GFX_TCC_INDEX3_START,
	RAS_GFX_V9__GFX_TCC_LATENCY_FIFO =
		RAS_GFX_V9__GFX_TCC_INDEX3_START,
	RAS_GFX_V9__GFX_TCC_LATENCY_FIFO_NEXT_RAM,
	RAS_GFX_V9__GFX_TCC_INDEX3_END =
		RAS_GFX_V9__GFX_TCC_LATENCY_FIFO_NEXT_RAM,
	/* TCC range 4 */
	RAS_GFX_V9__GFX_TCC_INDEX4_START,
	RAS_GFX_V9__GFX_TCC_WRRET_TAG_WRITE_RETURN =
		RAS_GFX_V9__GFX_TCC_INDEX4_START,
	RAS_GFX_V9__GFX_TCC_ATOMIC_RETURN_BUFFER,
	RAS_GFX_V9__GFX_TCC_INDEX4_END =
		RAS_GFX_V9__GFX_TCC_ATOMIC_RETURN_BUFFER,
	RAS_GFX_V9__GFX_TCC_INDEX_END =
		RAS_GFX_V9__GFX_TCC_INDEX4_END,
	/* TCI */
	RAS_GFX_V9__GFX_TCI_WRITE_RAM,
	/* TCP */
	RAS_GFX_V9__GFX_TCP_INDEX_START,
	RAS_GFX_V9__GFX_TCP_CACHE_RAM =
		RAS_GFX_V9__GFX_TCP_INDEX_START,
	RAS_GFX_V9__GFX_TCP_LFIFO_RAM,
	RAS_GFX_V9__GFX_TCP_CMD_FIFO,
	RAS_GFX_V9__GFX_TCP_VM_FIFO,
	RAS_GFX_V9__GFX_TCP_DB_RAM,
	RAS_GFX_V9__GFX_TCP_UTCL1_LFIFO0,
	RAS_GFX_V9__GFX_TCP_UTCL1_LFIFO1,
	RAS_GFX_V9__GFX_TCP_INDEX_END =
		RAS_GFX_V9__GFX_TCP_UTCL1_LFIFO1,
	/* TD */
	RAS_GFX_V9__GFX_TD_INDEX_START,
	RAS_GFX_V9__GFX_TD_SS_FIFO_LO =
		RAS_GFX_V9__GFX_TD_INDEX_START,
	RAS_GFX_V9__GFX_TD_SS_FIFO_HI,
	RAS_GFX_V9__GFX_TD_CS_FIFO,
	RAS_GFX_V9__GFX_TD_INDEX_END = RAS_GFX_V9__GFX_TD_CS_FIFO,
	/* EA (3 sub-ranges) */
	RAS_GFX_V9__GFX_EA_INDEX_START,
	/* EA range 0 */
	RAS_GFX_V9__GFX_EA_INDEX0_START =
		RAS_GFX_V9__GFX_EA_INDEX_START,
	RAS_GFX_V9__GFX_EA_DRAMRD_CMDMEM =
		RAS_GFX_V9__GFX_EA_INDEX0_START,
	RAS_GFX_V9__GFX_EA_DRAMWR_CMDMEM,
	RAS_GFX_V9__GFX_EA_DRAMWR_DATAMEM,
	RAS_GFX_V9__GFX_EA_RRET_TAGMEM,
	RAS_GFX_V9__GFX_EA_WRET_TAGMEM,
	RAS_GFX_V9__GFX_EA_GMIRD_CMDMEM,
	RAS_GFX_V9__GFX_EA_GMIWR_CMDMEM,
	RAS_GFX_V9__GFX_EA_GMIWR_DATAMEM,
	RAS_GFX_V9__GFX_EA_INDEX0_END =
		RAS_GFX_V9__GFX_EA_GMIWR_DATAMEM,
	/* EA range 1 */
	RAS_GFX_V9__GFX_EA_INDEX1_START,
	RAS_GFX_V9__GFX_EA_DRAMRD_PAGEMEM =
		RAS_GFX_V9__GFX_EA_INDEX1_START,
	RAS_GFX_V9__GFX_EA_DRAMWR_PAGEMEM,
	RAS_GFX_V9__GFX_EA_IORD_CMDMEM,
	RAS_GFX_V9__GFX_EA_IOWR_CMDMEM,
	RAS_GFX_V9__GFX_EA_IOWR_DATAMEM,
	RAS_GFX_V9__GFX_EA_GMIRD_PAGEMEM,
	RAS_GFX_V9__GFX_EA_GMIWR_PAGEMEM,
	RAS_GFX_V9__GFX_EA_INDEX1_END =
		RAS_GFX_V9__GFX_EA_GMIWR_PAGEMEM,
	/* EA range 2 */
	RAS_GFX_V9__GFX_EA_INDEX2_START,
	RAS_GFX_V9__GFX_EA_MAM_D0MEM =
		RAS_GFX_V9__GFX_EA_INDEX2_START,
	RAS_GFX_V9__GFX_EA_MAM_D1MEM,
	RAS_GFX_V9__GFX_EA_MAM_D2MEM,
	RAS_GFX_V9__GFX_EA_MAM_D3MEM,
	RAS_GFX_V9__GFX_EA_INDEX2_END =
		RAS_GFX_V9__GFX_EA_MAM_D3MEM,
	RAS_GFX_V9__GFX_EA_INDEX_END =
		RAS_GFX_V9__GFX_EA_INDEX2_END,
	/* UTC VM L2 bank */
	RAS_GFX_V9__UTC_VML2_BANK_CACHE,
	/* UTC VM walker */
	RAS_GFX_V9__UTC_VML2_WALKER,
	/* UTC ATC L2 2MB cache */
	RAS_GFX_V9__UTC_ATCL2_CACHE_2M_BANK,
	/* UTC ATC L2 4KB cache */
	RAS_GFX_V9__UTC_ATCL2_CACHE_4K_BANK,
	RAS_GFX_V9__GFX_MAX
};

extern const struct ras_gfx_ip_func gfx_ras_func_v9_0;

#endif
