/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public final class SingleAppInstance {
    private static SingleAppInstance s_instance = null;
    private static final String INSTANCE_FILENAME = "INSTANCE.RUN";
    private File m_file = null;
    private FileChannel m_channel = null;
    private FileLock m_lock = null;
    private boolean m_reportPopup = true;
    private static final String m_fileLockErrorTitle = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileLockErrorTitle");
    private static final String m_fileLockErrorMsg1 = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileLockErrorMsg1");
    private static final String m_fileLockErrorMsg2 = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileLockErrorMsg2");
    private static final String m_fileDeleteErrorTitle = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileDeleteErrorTitle");
    private static final String m_fileDeleteErrorMsg1 = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileDeleteErrorMsg1");
    private static final String m_fileDeleteErrorMsg2 = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileDeleteErrorMsg2");
    private static final String m_fileExistsTitle = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileExistsTitle");
    private static final String m_fileExistsMsg1 = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileExistsMsg1");
    private static final String m_fileExistsMsg2 = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileExistsMsg2");
    private static final String m_fileExistsMsg3 = ResourceBundle.getBundle("gr/zeus/res/singleappinstance").getString("fileExistsMsg3");

    public static synchronized SingleAppInstance getInstance() {
        if (s_instance == null) {
            s_instance = new SingleAppInstance();
        }
        return s_instance;
    }

    public static synchronized SingleAppInstance getInstance(String filename) {
        if (s_instance == null) {
            s_instance = new SingleAppInstance(filename);
        }
        return s_instance;
    }

    public synchronized void onInit() {
        if (this.m_file.exists()) {
            if (!this.inform_user()) {
                System.exit(1);
            }
            if (!this.force_delete_file()) {
                System.exit(2);
            }
        }
        if (!this.lock_file()) {
            System.exit(3);
        }
    }

    public synchronized void onExit() {
        try {
            this.m_lock.release();
            this.m_channel.close();
            this.m_file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getReportPopup() {
        return this.m_reportPopup;
    }

    public synchronized void setReportPopup(boolean f) {
        this.m_reportPopup = f;
    }

    private SingleAppInstance() {
        this.m_file = new File(INSTANCE_FILENAME);
    }

    private SingleAppInstance(String filename) {
        this.m_file = new File(filename);
    }

    private void report_lock_error(String s) {
        String msg = m_fileLockErrorMsg1 + this.m_file.getAbsolutePath() + m_fileLockErrorMsg2 + s;
        String title = m_fileLockErrorTitle;
        if (this.m_reportPopup) {
            JOptionPane.showMessageDialog(null, msg, title, 0);
        } else {
            System.err.println(msg);
        }
    }

    private void report_delete_error(String s) {
        String msg = m_fileDeleteErrorMsg1 + this.m_file.getAbsolutePath();
        if (s != null) {
            msg = msg + m_fileDeleteErrorMsg2 + s;
        }
        String title = m_fileDeleteErrorTitle;
        if (this.m_reportPopup) {
            JOptionPane.showMessageDialog(null, msg, title, 0);
        } else {
            System.err.println(msg);
        }
    }

    private boolean lock_file() {
        try {
            this.m_channel = new RandomAccessFile(this.m_file, "rw").getChannel();
            this.m_lock = this.m_channel.lock();
            return true;
        }
        catch (Exception ex) {
            this.report_lock_error(ex.getMessage());
            return false;
        }
    }

    private boolean force_delete_file() {
        try {
            boolean deleted = this.m_file.delete();
            if (!deleted) {
                this.report_delete_error(null);
            }
            return deleted;
        }
        catch (Exception ex) {
            this.report_delete_error(ex.getMessage());
            return false;
        }
    }

    private boolean inform_user() {
        String msg_gui = m_fileExistsMsg1 + m_fileExistsMsg2;
        String msg_txt = m_fileExistsMsg1 + m_fileExistsMsg3 + this.m_file.getAbsolutePath();
        String title = m_fileExistsTitle;
        if (this.m_reportPopup) {
            int res = JOptionPane.showConfirmDialog(null, msg_gui, title, 2, 2);
            return res == 0;
        }
        System.err.println(msg_txt);
        return false;
    }
}

