/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Compute a moving squared sample Pearson product-moment correlation coefficient incrementally.
*
* @module @stdlib/stats/incr/mpcorr2
*
* @example
* var incrmpcorr2 = require( '@stdlib/stats/incr/mpcorr2' );
*
* var accumulator = incrmpcorr2( 3 );
*
* var r2 = accumulator();
* // returns null
*
* r2 = accumulator( 2.0, 1.0 );
* // returns 0.0
*
* r2 = accumulator( -5.0, 3.14 );
* // returns ~1.0
*
* r2 = accumulator( 3.0, -1.0 );
* // returns ~0.86
*
* r2 = accumulator( 5.0, -9.5 );
* // returns ~0.74
*
* r2 = accumulator();
* // returns ~0.74
*/

// MODULES //

var incrmpcorr2 = require( './main.js' );


// EXPORTS //

module.exports = incrmpcorr2;
