// GENERATED FILE - DO NOT EDIT.
// Generated by gen_gl_enum_utils.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// gl_enum_utils_autogen.cpp:
//   mapping of GLenum value to string.

#include "common/gl_enum_utils_autogen.h"

#include "common/debug.h"
#include "common/gl_enum_utils.h"

#include <cstring>

namespace gl
{
namespace
{
const char *UnknownEnumToString(unsigned int value)
{
    constexpr size_t kBufferSize = 64;
    static thread_local char sBuffer[kBufferSize];
    snprintf(sBuffer, kBufferSize, "0x%04X", value);
    return sBuffer;
}
}  // anonymous namespace

const char *GLenumToString(GLESEnum enumGroup, unsigned int value)
{
    switch (enumGroup)
    {
        case GLESEnum::AccumOp:
        {
            switch (value)
            {
                case 0x104:
                    return "GL_ADD";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::AllEnums:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1:
                    return "GL_ONE";
                case 0x2:
                    return "GL_LINE_LOOP";
                case 0x3:
                    return "GL_LINE_STRIP";
                case 0x4:
                    return "GL_TRIANGLES";
                case 0x5:
                    return "GL_TRIANGLE_STRIP";
                case 0x6:
                    return "GL_TRIANGLE_FAN";
                case 0x7:
                    return "GL_QUADS";
                case 0x8:
                    return "GL_TESS_CONTROL_SHADER_BIT";
                case 0xA:
                    return "GL_LINES_ADJACENCY";
                case 0xB:
                    return "GL_LINE_STRIP_ADJACENCY";
                case 0xC:
                    return "GL_TRIANGLES_ADJACENCY";
                case 0xD:
                    return "GL_TRIANGLE_STRIP_ADJACENCY";
                case 0xE:
                    return "GL_PATCHES";
                case 0x10:
                    return "GL_MAP_FLUSH_EXPLICIT_BIT";
                case 0x16:
                    return "GL_UUID_SIZE_EXT";
                case 0x20:
                    return "GL_COMPUTE_SHADER_BIT";
                case 0x40:
                    return "GL_COMMAND_BARRIER_BIT";
                case 0x80:
                    return "GL_MAP_COHERENT_BIT_EXT";
                case 0x100:
                    return "GL_DEPTH_BUFFER_BIT";
                case 0x104:
                    return "GL_ADD";
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                case 0x300:
                    return "GL_SRC_COLOR";
                case 0x301:
                    return "GL_ONE_MINUS_SRC_COLOR";
                case 0x302:
                    return "GL_SRC_ALPHA";
                case 0x303:
                    return "GL_ONE_MINUS_SRC_ALPHA";
                case 0x304:
                    return "GL_DST_ALPHA";
                case 0x305:
                    return "GL_ONE_MINUS_DST_ALPHA";
                case 0x306:
                    return "GL_DST_COLOR";
                case 0x307:
                    return "GL_ONE_MINUS_DST_COLOR";
                case 0x308:
                    return "GL_SRC_ALPHA_SATURATE";
                case 0x400:
                    return "GL_STENCIL_BUFFER_BIT";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                case 0x500:
                    return "GL_INVALID_ENUM";
                case 0x501:
                    return "GL_INVALID_VALUE";
                case 0x502:
                    return "GL_INVALID_OPERATION";
                case 0x503:
                    return "GL_STACK_OVERFLOW";
                case 0x504:
                    return "GL_STACK_UNDERFLOW";
                case 0x505:
                    return "GL_OUT_OF_MEMORY";
                case 0x506:
                    return "GL_INVALID_FRAMEBUFFER_OPERATION";
                case 0x507:
                    return "GL_CONTEXT_LOST";
                case 0x800:
                    return "GL_EXP";
                case 0x801:
                    return "GL_EXP2";
                case 0x900:
                    return "GL_CW";
                case 0x901:
                    return "GL_CCW";
                case 0xB00:
                    return "GL_CURRENT_COLOR";
                case 0xB02:
                    return "GL_CURRENT_NORMAL";
                case 0xB03:
                    return "GL_CURRENT_TEXTURE_COORDS";
                case 0xB10:
                    return "GL_POINT_SMOOTH";
                case 0xB11:
                    return "GL_POINT_SIZE";
                case 0xB12:
                    return "GL_SMOOTH_POINT_SIZE_RANGE";
                case 0xB20:
                    return "GL_LINE_SMOOTH";
                case 0xB21:
                    return "GL_LINE_WIDTH";
                case 0xB22:
                    return "GL_SMOOTH_LINE_WIDTH_RANGE";
                case 0xB44:
                    return "GL_CULL_FACE";
                case 0xB45:
                    return "GL_CULL_FACE_MODE";
                case 0xB46:
                    return "GL_FRONT_FACE";
                case 0xB50:
                    return "GL_LIGHTING";
                case 0xB52:
                    return "GL_LIGHT_MODEL_TWO_SIDE";
                case 0xB53:
                    return "GL_LIGHT_MODEL_AMBIENT";
                case 0xB54:
                    return "GL_SHADE_MODEL";
                case 0xB57:
                    return "GL_COLOR_MATERIAL";
                case 0xB60:
                    return "GL_FOG";
                case 0xB62:
                    return "GL_FOG_DENSITY";
                case 0xB63:
                    return "GL_FOG_START";
                case 0xB64:
                    return "GL_FOG_END";
                case 0xB65:
                    return "GL_FOG_MODE";
                case 0xB66:
                    return "GL_FOG_COLOR";
                case 0xB70:
                    return "GL_DEPTH_RANGE";
                case 0xB71:
                    return "GL_DEPTH_TEST";
                case 0xB72:
                    return "GL_DEPTH_WRITEMASK";
                case 0xB73:
                    return "GL_DEPTH_CLEAR_VALUE";
                case 0xB74:
                    return "GL_DEPTH_FUNC";
                case 0xB90:
                    return "GL_STENCIL_TEST";
                case 0xB91:
                    return "GL_STENCIL_CLEAR_VALUE";
                case 0xB92:
                    return "GL_STENCIL_FUNC";
                case 0xB93:
                    return "GL_STENCIL_VALUE_MASK";
                case 0xB94:
                    return "GL_STENCIL_FAIL";
                case 0xB95:
                    return "GL_STENCIL_PASS_DEPTH_FAIL";
                case 0xB96:
                    return "GL_STENCIL_PASS_DEPTH_PASS";
                case 0xB97:
                    return "GL_STENCIL_REF";
                case 0xB98:
                    return "GL_STENCIL_WRITEMASK";
                case 0xBA0:
                    return "GL_MATRIX_MODE";
                case 0xBA1:
                    return "GL_NORMALIZE";
                case 0xBA2:
                    return "GL_VIEWPORT";
                case 0xBA3:
                    return "GL_MODELVIEW_STACK_DEPTH";
                case 0xBA4:
                    return "GL_PROJECTION_STACK_DEPTH";
                case 0xBA5:
                    return "GL_TEXTURE_STACK_DEPTH";
                case 0xBA6:
                    return "GL_MODELVIEW_MATRIX";
                case 0xBA7:
                    return "GL_PROJECTION_MATRIX";
                case 0xBA8:
                    return "GL_TEXTURE_MATRIX";
                case 0xBC0:
                    return "GL_ALPHA_TEST";
                case 0xBC1:
                    return "GL_ALPHA_TEST_FUNC";
                case 0xBC2:
                    return "GL_ALPHA_TEST_REF";
                case 0xBD0:
                    return "GL_DITHER";
                case 0xBE0:
                    return "GL_BLEND_DST";
                case 0xBE1:
                    return "GL_BLEND_SRC";
                case 0xBE2:
                    return "GL_BLEND";
                case 0xBF0:
                    return "GL_LOGIC_OP_MODE";
                case 0xBF2:
                    return "GL_COLOR_LOGIC_OP";
                case 0xC02:
                    return "GL_READ_BUFFER";
                case 0xC10:
                    return "GL_SCISSOR_BOX";
                case 0xC11:
                    return "GL_SCISSOR_TEST";
                case 0xC22:
                    return "GL_COLOR_CLEAR_VALUE";
                case 0xC23:
                    return "GL_COLOR_WRITEMASK";
                case 0xC50:
                    return "GL_PERSPECTIVE_CORRECTION_HINT";
                case 0xC51:
                    return "GL_POINT_SMOOTH_HINT";
                case 0xC52:
                    return "GL_LINE_SMOOTH_HINT";
                case 0xC54:
                    return "GL_FOG_HINT";
                case 0xCF2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xCF3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xCF4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xCF5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xD02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xD03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xD04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xD05:
                    return "GL_PACK_ALIGNMENT";
                case 0xD1C:
                    return "GL_ALPHA_SCALE";
                case 0xD31:
                    return "GL_MAX_LIGHTS";
                case 0xD32:
                    return "GL_MAX_CLIP_PLANES";
                case 0xD33:
                    return "GL_MAX_TEXTURE_SIZE";
                case 0xD36:
                    return "GL_MAX_MODELVIEW_STACK_DEPTH";
                case 0xD38:
                    return "GL_MAX_PROJECTION_STACK_DEPTH";
                case 0xD39:
                    return "GL_MAX_TEXTURE_STACK_DEPTH";
                case 0xD3A:
                    return "GL_MAX_VIEWPORT_DIMS";
                case 0xD50:
                    return "GL_SUBPIXEL_BITS";
                case 0xD52:
                    return "GL_RED_BITS";
                case 0xD53:
                    return "GL_GREEN_BITS";
                case 0xD54:
                    return "GL_BLUE_BITS";
                case 0xD55:
                    return "GL_ALPHA_BITS";
                case 0xD56:
                    return "GL_DEPTH_BITS";
                case 0xD57:
                    return "GL_STENCIL_BITS";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_INTERNAL_FORMAT";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x1101:
                    return "GL_FASTEST";
                case 0x1102:
                    return "GL_NICEST";
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1203:
                    return "GL_POSITION";
                case 0x1204:
                    return "GL_SPOT_DIRECTION";
                case 0x1205:
                    return "GL_SPOT_EXPONENT";
                case 0x1206:
                    return "GL_SPOT_CUTOFF";
                case 0x1207:
                    return "GL_CONSTANT_ATTENUATION";
                case 0x1208:
                    return "GL_LINEAR_ATTENUATION";
                case 0x1209:
                    return "GL_QUADRATIC_ATTENUATION";
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x140C:
                    return "GL_FIXED";
                case 0x1500:
                    return "GL_CLEAR";
                case 0x1501:
                    return "GL_AND";
                case 0x1502:
                    return "GL_AND_REVERSE";
                case 0x1503:
                    return "GL_COPY";
                case 0x1504:
                    return "GL_AND_INVERTED";
                case 0x1505:
                    return "GL_NOOP";
                case 0x1506:
                    return "GL_XOR";
                case 0x1507:
                    return "GL_OR";
                case 0x1508:
                    return "GL_NOR";
                case 0x1509:
                    return "GL_EQUIV";
                case 0x150A:
                    return "GL_INVERT";
                case 0x150B:
                    return "GL_OR_REVERSE";
                case 0x150C:
                    return "GL_COPY_INVERTED";
                case 0x150D:
                    return "GL_OR_INVERTED";
                case 0x150E:
                    return "GL_NAND";
                case 0x150F:
                    return "GL_SET";
                case 0x1600:
                    return "GL_EMISSION";
                case 0x1601:
                    return "GL_SHININESS";
                case 0x1602:
                    return "GL_AMBIENT_AND_DIFFUSE";
                case 0x1700:
                    return "GL_MODELVIEW";
                case 0x1701:
                    return "GL_PROJECTION";
                case 0x1702:
                    return "GL_TEXTURE";
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190A:
                    return "GL_LUMINANCE_ALPHA";
                case 0x1D00:
                    return "GL_FLAT";
                case 0x1D01:
                    return "GL_SMOOTH";
                case 0x1E00:
                    return "GL_KEEP";
                case 0x1E01:
                    return "GL_REPLACE";
                case 0x1E02:
                    return "GL_INCR";
                case 0x1E03:
                    return "GL_DECR";
                case 0x1F00:
                    return "GL_VENDOR";
                case 0x1F01:
                    return "GL_RENDERER";
                case 0x1F02:
                    return "GL_VERSION";
                case 0x1F03:
                    return "GL_EXTENSIONS";
                case 0x2000:
                    return "GL_SHADER_STORAGE_BARRIER_BIT";
                case 0x2100:
                    return "GL_MODULATE";
                case 0x2101:
                    return "GL_DECAL";
                case 0x2200:
                    return "GL_TEXTURE_ENV_MODE";
                case 0x2201:
                    return "GL_TEXTURE_ENV_COLOR";
                case 0x2300:
                    return "GL_TEXTURE_ENV";
                case 0x2500:
                    return "GL_TEXTURE_GEN_MODE_OES";
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                case 0x2700:
                    return "GL_NEAREST_MIPMAP_NEAREST";
                case 0x2701:
                    return "GL_LINEAR_MIPMAP_NEAREST";
                case 0x2702:
                    return "GL_NEAREST_MIPMAP_LINEAR";
                case 0x2703:
                    return "GL_LINEAR_MIPMAP_LINEAR";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x2901:
                    return "GL_REPEAT";
                case 0x2A00:
                    return "GL_POLYGON_OFFSET_UNITS";
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                case 0x3006:
                    return "GL_CLIP_DISTANCE6_EXT";
                case 0x3007:
                    return "GL_CLIP_DISTANCE7_EXT";
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                case 0x8001:
                    return "GL_CONSTANT_COLOR";
                case 0x8002:
                    return "GL_ONE_MINUS_CONSTANT_COLOR";
                case 0x8003:
                    return "GL_CONSTANT_ALPHA";
                case 0x8004:
                    return "GL_ONE_MINUS_CONSTANT_ALPHA";
                case 0x8005:
                    return "GL_BLEND_COLOR";
                case 0x8006:
                    return "GL_FUNC_ADD";
                case 0x8007:
                    return "GL_MIN";
                case 0x8008:
                    return "GL_MAX";
                case 0x8009:
                    return "GL_BLEND_EQUATION";
                case 0x800A:
                    return "GL_FUNC_SUBTRACT";
                case 0x800B:
                    return "GL_FUNC_REVERSE_SUBTRACT";
                case 0x8033:
                    return "GL_UNSIGNED_SHORT_4_4_4_4";
                case 0x8034:
                    return "GL_UNSIGNED_SHORT_5_5_5_1";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8038:
                    return "GL_POLYGON_OFFSET_FACTOR";
                case 0x803A:
                    return "GL_RESCALE_NORMAL";
                case 0x803C:
                    return "GL_ALPHA8_EXT";
                case 0x8040:
                    return "GL_LUMINANCE8_EXT";
                case 0x8045:
                    return "GL_LUMINANCE8_ALPHA8_EXT";
                case 0x8051:
                    return "GL_RGB8";
                case 0x8052:
                    return "GL_RGB10_EXT";
                case 0x8054:
                    return "GL_RGB16_EXT";
                case 0x8056:
                    return "GL_RGBA4";
                case 0x8057:
                    return "GL_RGB5_A1";
                case 0x8058:
                    return "GL_RGBA8";
                case 0x8059:
                    return "GL_RGB10_A2";
                case 0x805B:
                    return "GL_RGBA16_EXT";
                case 0x805C:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805D:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805E:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805F:
                    return "GL_TEXTURE_ALPHA_SIZE";
                case 0x8069:
                    return "GL_TEXTURE_BINDING_2D";
                case 0x806A:
                    return "GL_TEXTURE_BINDING_3D";
                case 0x806D:
                    return "GL_UNPACK_SKIP_IMAGES";
                case 0x806E:
                    return "GL_UNPACK_IMAGE_HEIGHT";
                case 0x806F:
                    return "GL_TEXTURE_3D";
                case 0x8071:
                    return "GL_TEXTURE_DEPTH";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x8073:
                    return "GL_MAX_3D_TEXTURE_SIZE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x8075:
                    return "GL_NORMAL_ARRAY";
                case 0x8076:
                    return "GL_COLOR_ARRAY";
                case 0x8078:
                    return "GL_TEXTURE_COORD_ARRAY";
                case 0x807A:
                    return "GL_VERTEX_ARRAY_SIZE";
                case 0x807B:
                    return "GL_VERTEX_ARRAY_TYPE";
                case 0x807C:
                    return "GL_VERTEX_ARRAY_STRIDE";
                case 0x807E:
                    return "GL_NORMAL_ARRAY_TYPE";
                case 0x807F:
                    return "GL_NORMAL_ARRAY_STRIDE";
                case 0x8081:
                    return "GL_COLOR_ARRAY_SIZE";
                case 0x8082:
                    return "GL_COLOR_ARRAY_TYPE";
                case 0x8083:
                    return "GL_COLOR_ARRAY_STRIDE";
                case 0x8088:
                    return "GL_TEXTURE_COORD_ARRAY_SIZE";
                case 0x8089:
                    return "GL_TEXTURE_COORD_ARRAY_TYPE";
                case 0x808A:
                    return "GL_TEXTURE_COORD_ARRAY_STRIDE";
                case 0x808E:
                    return "GL_VERTEX_ARRAY_POINTER";
                case 0x808F:
                    return "GL_NORMAL_ARRAY_POINTER";
                case 0x8090:
                    return "GL_COLOR_ARRAY_POINTER";
                case 0x8092:
                    return "GL_TEXTURE_COORD_ARRAY_POINTER";
                case 0x809D:
                    return "GL_MULTISAMPLE";
                case 0x809E:
                    return "GL_SAMPLE_ALPHA_TO_COVERAGE";
                case 0x809F:
                    return "GL_SAMPLE_ALPHA_TO_ONE";
                case 0x80A0:
                    return "GL_SAMPLE_COVERAGE";
                case 0x80A8:
                    return "GL_SAMPLE_BUFFERS";
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x80AA:
                    return "GL_SAMPLE_COVERAGE_VALUE";
                case 0x80AB:
                    return "GL_SAMPLE_COVERAGE_INVERT";
                case 0x80C8:
                    return "GL_BLEND_DST_RGB";
                case 0x80C9:
                    return "GL_BLEND_SRC_RGB";
                case 0x80CA:
                    return "GL_BLEND_DST_ALPHA";
                case 0x80CB:
                    return "GL_BLEND_SRC_ALPHA";
                case 0x80E1:
                    return "GL_BGRA_EXT";
                case 0x80E8:
                    return "GL_MAX_ELEMENTS_VERTICES";
                case 0x80E9:
                    return "GL_MAX_ELEMENTS_INDICES";
                case 0x8126:
                    return "GL_POINT_SIZE_MIN";
                case 0x8127:
                    return "GL_POINT_SIZE_MAX";
                case 0x8128:
                    return "GL_POINT_FADE_THRESHOLD_SIZE";
                case 0x8129:
                    return "GL_POINT_DISTANCE_ATTENUATION";
                case 0x812D:
                    return "GL_CLAMP_TO_BORDER";
                case 0x812F:
                    return "GL_CLAMP_TO_EDGE";
                case 0x813A:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813B:
                    return "GL_TEXTURE_MAX_LOD";
                case 0x813C:
                    return "GL_TEXTURE_BASE_LEVEL";
                case 0x813D:
                    return "GL_TEXTURE_MAX_LEVEL";
                case 0x8191:
                    return "GL_GENERATE_MIPMAP";
                case 0x8192:
                    return "GL_GENERATE_MIPMAP_HINT";
                case 0x81A5:
                    return "GL_DEPTH_COMPONENT16";
                case 0x81A6:
                    return "GL_DEPTH_COMPONENT24";
                case 0x81A7:
                    return "GL_DEPTH_COMPONENT32_OES";
                case 0x8210:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING";
                case 0x8211:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE";
                case 0x8212:
                    return "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE";
                case 0x8213:
                    return "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE";
                case 0x8214:
                    return "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE";
                case 0x8215:
                    return "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE";
                case 0x8216:
                    return "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE";
                case 0x8217:
                    return "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE";
                case 0x8218:
                    return "GL_FRAMEBUFFER_DEFAULT";
                case 0x8219:
                    return "GL_FRAMEBUFFER_UNDEFINED";
                case 0x821A:
                    return "GL_DEPTH_STENCIL_ATTACHMENT";
                case 0x821B:
                    return "GL_MAJOR_VERSION";
                case 0x821C:
                    return "GL_MINOR_VERSION";
                case 0x821D:
                    return "GL_NUM_EXTENSIONS";
                case 0x821E:
                    return "GL_CONTEXT_FLAGS";
                case 0x821F:
                    return "GL_BUFFER_IMMUTABLE_STORAGE_EXT";
                case 0x8220:
                    return "GL_BUFFER_STORAGE_FLAGS_EXT";
                case 0x8221:
                    return "GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED";
                case 0x8227:
                    return "GL_RG";
                case 0x8228:
                    return "GL_RG_INTEGER";
                case 0x8229:
                    return "GL_R8";
                case 0x822A:
                    return "GL_R16_EXT";
                case 0x822B:
                    return "GL_RG8";
                case 0x822C:
                    return "GL_RG16_EXT";
                case 0x822D:
                    return "GL_R16F";
                case 0x822E:
                    return "GL_R32F";
                case 0x822F:
                    return "GL_RG16F";
                case 0x8230:
                    return "GL_RG32F";
                case 0x8231:
                    return "GL_R8I";
                case 0x8232:
                    return "GL_R8UI";
                case 0x8233:
                    return "GL_R16I";
                case 0x8234:
                    return "GL_R16UI";
                case 0x8235:
                    return "GL_R32I";
                case 0x8236:
                    return "GL_R32UI";
                case 0x8237:
                    return "GL_RG8I";
                case 0x8238:
                    return "GL_RG8UI";
                case 0x8239:
                    return "GL_RG16I";
                case 0x823A:
                    return "GL_RG16UI";
                case 0x823B:
                    return "GL_RG32I";
                case 0x823C:
                    return "GL_RG32UI";
                case 0x8242:
                    return "GL_DEBUG_OUTPUT_SYNCHRONOUS";
                case 0x8243:
                    return "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH";
                case 0x8244:
                    return "GL_DEBUG_CALLBACK_FUNCTION";
                case 0x8245:
                    return "GL_DEBUG_CALLBACK_USER_PARAM";
                case 0x8246:
                    return "GL_DEBUG_SOURCE_API";
                case 0x8247:
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM";
                case 0x8248:
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER";
                case 0x8249:
                    return "GL_DEBUG_SOURCE_THIRD_PARTY";
                case 0x824A:
                    return "GL_DEBUG_SOURCE_APPLICATION";
                case 0x824B:
                    return "GL_DEBUG_SOURCE_OTHER";
                case 0x824C:
                    return "GL_DEBUG_TYPE_ERROR";
                case 0x824D:
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR";
                case 0x824E:
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR";
                case 0x824F:
                    return "GL_DEBUG_TYPE_PORTABILITY";
                case 0x8250:
                    return "GL_DEBUG_TYPE_PERFORMANCE";
                case 0x8251:
                    return "GL_DEBUG_TYPE_OTHER";
                case 0x8252:
                    return "GL_LOSE_CONTEXT_ON_RESET";
                case 0x8253:
                    return "GL_GUILTY_CONTEXT_RESET";
                case 0x8254:
                    return "GL_INNOCENT_CONTEXT_RESET";
                case 0x8255:
                    return "GL_UNKNOWN_CONTEXT_RESET";
                case 0x8256:
                    return "GL_RESET_NOTIFICATION_STRATEGY";
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x8258:
                    return "GL_PROGRAM_SEPARABLE";
                case 0x8259:
                    return "GL_ACTIVE_PROGRAM";
                case 0x825A:
                    return "GL_PROGRAM_PIPELINE_BINDING";
                case 0x825E:
                    return "GL_LAYER_PROVOKING_VERTEX";
                case 0x8260:
                    return "GL_UNDEFINED_VERTEX";
                case 0x8261:
                    return "GL_NO_RESET_NOTIFICATION";
                case 0x8262:
                    return "GL_MAX_COMPUTE_SHARED_MEMORY_SIZE";
                case 0x8263:
                    return "GL_MAX_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8264:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS";
                case 0x8265:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTERS";
                case 0x8266:
                    return "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8267:
                    return "GL_COMPUTE_WORK_GROUP_SIZE";
                case 0x8268:
                    return "GL_DEBUG_TYPE_MARKER";
                case 0x8269:
                    return "GL_DEBUG_TYPE_PUSH_GROUP";
                case 0x826A:
                    return "GL_DEBUG_TYPE_POP_GROUP";
                case 0x826B:
                    return "GL_DEBUG_SEVERITY_NOTIFICATION";
                case 0x826C:
                    return "GL_MAX_DEBUG_GROUP_STACK_DEPTH";
                case 0x826D:
                    return "GL_DEBUG_GROUP_STACK_DEPTH";
                case 0x826E:
                    return "GL_MAX_UNIFORM_LOCATIONS";
                case 0x82D4:
                    return "GL_VERTEX_ATTRIB_BINDING";
                case 0x82D5:
                    return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x82D6:
                    return "GL_VERTEX_BINDING_DIVISOR";
                case 0x82D7:
                    return "GL_VERTEX_BINDING_OFFSET";
                case 0x82D8:
                    return "GL_VERTEX_BINDING_STRIDE";
                case 0x82D9:
                    return "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x82DA:
                    return "GL_MAX_VERTEX_ATTRIB_BINDINGS";
                case 0x82DF:
                    return "GL_TEXTURE_IMMUTABLE_LEVELS";
                case 0x82E0:
                    return "GL_BUFFER";
                case 0x82E1:
                    return "GL_SHADER";
                case 0x82E2:
                    return "GL_PROGRAM";
                case 0x82E3:
                    return "GL_QUERY";
                case 0x82E4:
                    return "GL_PROGRAM_PIPELINE";
                case 0x82E5:
                    return "GL_MAX_VERTEX_ATTRIB_STRIDE";
                case 0x82E6:
                    return "GL_SAMPLER";
                case 0x82E8:
                    return "GL_MAX_LABEL_LENGTH";
                case 0x82F9:
                    return "GL_MAX_CULL_DISTANCES_EXT";
                case 0x82FA:
                    return "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_EXT";
                case 0x8363:
                    return "GL_UNSIGNED_SHORT_5_6_5";
                case 0x8365:
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT";
                case 0x8366:
                    return "GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8370:
                    return "GL_MIRRORED_REPEAT";
                case 0x83F0:
                    return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
                case 0x83F1:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
                case 0x83F2:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
                case 0x83F3:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
                case 0x846D:
                    return "GL_ALIASED_POINT_SIZE_RANGE";
                case 0x846E:
                    return "GL_ALIASED_LINE_WIDTH_RANGE";
                case 0x84C0:
                    return "GL_TEXTURE0";
                case 0x84C1:
                    return "GL_TEXTURE1";
                case 0x84C2:
                    return "GL_TEXTURE2";
                case 0x84C3:
                    return "GL_TEXTURE3";
                case 0x84C4:
                    return "GL_TEXTURE4";
                case 0x84C5:
                    return "GL_TEXTURE5";
                case 0x84C6:
                    return "GL_TEXTURE6";
                case 0x84C7:
                    return "GL_TEXTURE7";
                case 0x84C8:
                    return "GL_TEXTURE8";
                case 0x84C9:
                    return "GL_TEXTURE9";
                case 0x84CA:
                    return "GL_TEXTURE10";
                case 0x84CB:
                    return "GL_TEXTURE11";
                case 0x84CC:
                    return "GL_TEXTURE12";
                case 0x84CD:
                    return "GL_TEXTURE13";
                case 0x84CE:
                    return "GL_TEXTURE14";
                case 0x84CF:
                    return "GL_TEXTURE15";
                case 0x84D0:
                    return "GL_TEXTURE16";
                case 0x84D1:
                    return "GL_TEXTURE17";
                case 0x84D2:
                    return "GL_TEXTURE18";
                case 0x84D3:
                    return "GL_TEXTURE19";
                case 0x84D4:
                    return "GL_TEXTURE20";
                case 0x84D5:
                    return "GL_TEXTURE21";
                case 0x84D6:
                    return "GL_TEXTURE22";
                case 0x84D7:
                    return "GL_TEXTURE23";
                case 0x84D8:
                    return "GL_TEXTURE24";
                case 0x84D9:
                    return "GL_TEXTURE25";
                case 0x84DA:
                    return "GL_TEXTURE26";
                case 0x84DB:
                    return "GL_TEXTURE27";
                case 0x84DC:
                    return "GL_TEXTURE28";
                case 0x84DD:
                    return "GL_TEXTURE29";
                case 0x84DE:
                    return "GL_TEXTURE30";
                case 0x84DF:
                    return "GL_TEXTURE31";
                case 0x84E0:
                    return "GL_ACTIVE_TEXTURE";
                case 0x84E1:
                    return "GL_CLIENT_ACTIVE_TEXTURE";
                case 0x84E2:
                    return "GL_MAX_TEXTURE_UNITS";
                case 0x84E7:
                    return "GL_SUBTRACT";
                case 0x84E8:
                    return "GL_MAX_RENDERBUFFER_SIZE";
                case 0x84F2:
                    return "GL_ALL_COMPLETED_NV";
                case 0x84F3:
                    return "GL_FENCE_STATUS_NV";
                case 0x84F4:
                    return "GL_FENCE_CONDITION_NV";
                case 0x84F9:
                    return "GL_DEPTH_STENCIL";
                case 0x84FA:
                    return "GL_UNSIGNED_INT_24_8";
                case 0x84FD:
                    return "GL_MAX_TEXTURE_LOD_BIAS";
                case 0x84FE:
                    return "GL_TEXTURE_MAX_ANISOTROPY_EXT";
                case 0x84FF:
                    return "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT";
                case 0x8507:
                    return "GL_INCR_WRAP";
                case 0x8508:
                    return "GL_DECR_WRAP";
                case 0x8511:
                    return "GL_NORMAL_MAP_OES";
                case 0x8512:
                    return "GL_REFLECTION_MAP_OES";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8514:
                    return "GL_TEXTURE_BINDING_CUBE_MAP";
                case 0x8515:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X";
                case 0x8516:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X";
                case 0x8517:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y";
                case 0x8518:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y";
                case 0x8519:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z";
                case 0x851A:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z";
                case 0x851C:
                    return "GL_MAX_CUBE_MAP_TEXTURE_SIZE";
                case 0x8570:
                    return "GL_COMBINE";
                case 0x8571:
                    return "GL_COMBINE_RGB";
                case 0x8572:
                    return "GL_COMBINE_ALPHA";
                case 0x8573:
                    return "GL_RGB_SCALE";
                case 0x8574:
                    return "GL_ADD_SIGNED";
                case 0x8575:
                    return "GL_INTERPOLATE";
                case 0x8576:
                    return "GL_CONSTANT";
                case 0x8577:
                    return "GL_PRIMARY_COLOR";
                case 0x8578:
                    return "GL_PREVIOUS";
                case 0x8580:
                    return "GL_SRC0_RGB";
                case 0x8581:
                    return "GL_SRC1_RGB";
                case 0x8582:
                    return "GL_SRC2_RGB";
                case 0x8588:
                    return "GL_SRC0_ALPHA";
                case 0x8589:
                    return "GL_SRC1_ALPHA";
                case 0x858A:
                    return "GL_SRC2_ALPHA";
                case 0x8590:
                    return "GL_OPERAND0_RGB";
                case 0x8591:
                    return "GL_OPERAND1_RGB";
                case 0x8592:
                    return "GL_OPERAND2_RGB";
                case 0x8598:
                    return "GL_OPERAND0_ALPHA";
                case 0x8599:
                    return "GL_OPERAND1_ALPHA";
                case 0x859A:
                    return "GL_OPERAND2_ALPHA";
                case 0x85B5:
                    return "GL_VERTEX_ARRAY_BINDING";
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x8626:
                    return "GL_CURRENT_VERTEX_ATTRIB";
                case 0x8645:
                    return "GL_VERTEX_ATTRIB_ARRAY_POINTER";
                case 0x86A1:
                    return "GL_TEXTURE_COMPRESSED";
                case 0x86A2:
                    return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
                case 0x86A3:
                    return "GL_COMPRESSED_TEXTURE_FORMATS";
                case 0x86A4:
                    return "GL_MAX_VERTEX_UNITS_OES";
                case 0x86A9:
                    return "GL_WEIGHT_ARRAY_TYPE_OES";
                case 0x86AA:
                    return "GL_WEIGHT_ARRAY_STRIDE_OES";
                case 0x86AB:
                    return "GL_WEIGHT_ARRAY_SIZE_OES";
                case 0x86AC:
                    return "GL_WEIGHT_ARRAY_POINTER_OES";
                case 0x86AD:
                    return "GL_WEIGHT_ARRAY_OES";
                case 0x86AE:
                    return "GL_DOT3_RGB";
                case 0x86AF:
                    return "GL_DOT3_RGBA";
                case 0x8741:
                    return "GL_PROGRAM_BINARY_LENGTH";
                case 0x8764:
                    return "GL_BUFFER_SIZE";
                case 0x8765:
                    return "GL_BUFFER_USAGE";
                case 0x87FE:
                    return "GL_NUM_PROGRAM_BINARY_FORMATS";
                case 0x87FF:
                    return "GL_PROGRAM_BINARY_FORMATS";
                case 0x8800:
                    return "GL_STENCIL_BACK_FUNC";
                case 0x8801:
                    return "GL_STENCIL_BACK_FAIL";
                case 0x8802:
                    return "GL_STENCIL_BACK_PASS_DEPTH_FAIL";
                case 0x8803:
                    return "GL_STENCIL_BACK_PASS_DEPTH_PASS";
                case 0x8814:
                    return "GL_RGBA32F";
                case 0x8815:
                    return "GL_RGB32F";
                case 0x8816:
                    return "GL_ALPHA32F_EXT";
                case 0x8818:
                    return "GL_LUMINANCE32F_EXT";
                case 0x8819:
                    return "GL_LUMINANCE_ALPHA32F_EXT";
                case 0x881A:
                    return "GL_RGBA16F";
                case 0x881B:
                    return "GL_RGB16F";
                case 0x881C:
                    return "GL_ALPHA16F_EXT";
                case 0x881E:
                    return "GL_LUMINANCE16F_EXT";
                case 0x881F:
                    return "GL_LUMINANCE_ALPHA16F_EXT";
                case 0x8824:
                    return "GL_MAX_DRAW_BUFFERS";
                case 0x8825:
                    return "GL_DRAW_BUFFER0";
                case 0x8826:
                    return "GL_DRAW_BUFFER1";
                case 0x8827:
                    return "GL_DRAW_BUFFER2";
                case 0x8828:
                    return "GL_DRAW_BUFFER3";
                case 0x8829:
                    return "GL_DRAW_BUFFER4";
                case 0x882A:
                    return "GL_DRAW_BUFFER5";
                case 0x882B:
                    return "GL_DRAW_BUFFER6";
                case 0x882C:
                    return "GL_DRAW_BUFFER7";
                case 0x882D:
                    return "GL_DRAW_BUFFER8";
                case 0x882E:
                    return "GL_DRAW_BUFFER9";
                case 0x882F:
                    return "GL_DRAW_BUFFER10";
                case 0x8830:
                    return "GL_DRAW_BUFFER11";
                case 0x8831:
                    return "GL_DRAW_BUFFER12";
                case 0x8832:
                    return "GL_DRAW_BUFFER13";
                case 0x8833:
                    return "GL_DRAW_BUFFER14";
                case 0x8834:
                    return "GL_DRAW_BUFFER15";
                case 0x883D:
                    return "GL_BLEND_EQUATION_ALPHA";
                case 0x8840:
                    return "GL_MATRIX_PALETTE_OES";
                case 0x8842:
                    return "GL_MAX_PALETTE_MATRICES_OES";
                case 0x8843:
                    return "GL_CURRENT_PALETTE_MATRIX_OES";
                case 0x8844:
                    return "GL_MATRIX_INDEX_ARRAY_OES";
                case 0x8846:
                    return "GL_MATRIX_INDEX_ARRAY_SIZE_OES";
                case 0x8847:
                    return "GL_MATRIX_INDEX_ARRAY_TYPE_OES";
                case 0x8848:
                    return "GL_MATRIX_INDEX_ARRAY_STRIDE_OES";
                case 0x8849:
                    return "GL_MATRIX_INDEX_ARRAY_POINTER_OES";
                case 0x884A:
                    return "GL_TEXTURE_DEPTH_SIZE";
                case 0x884C:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884D:
                    return "GL_TEXTURE_COMPARE_FUNC";
                case 0x884E:
                    return "GL_COMPARE_REF_TO_TEXTURE";
                case 0x8861:
                    return "GL_POINT_SPRITE_OES";
                case 0x8862:
                    return "GL_COORD_REPLACE_OES";
                case 0x8864:
                    return "GL_QUERY_COUNTER_BITS_EXT";
                case 0x8865:
                    return "GL_CURRENT_QUERY";
                case 0x8866:
                    return "GL_QUERY_RESULT";
                case 0x8867:
                    return "GL_QUERY_RESULT_AVAILABLE";
                case 0x8869:
                    return "GL_MAX_VERTEX_ATTRIBS";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x886C:
                    return "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS";
                case 0x886D:
                    return "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS";
                case 0x8872:
                    return "GL_MAX_TEXTURE_IMAGE_UNITS";
                case 0x887F:
                    return "GL_GEOMETRY_SHADER_INVOCATIONS";
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x8894:
                    return "GL_ARRAY_BUFFER_BINDING";
                case 0x8895:
                    return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
                case 0x8896:
                    return "GL_VERTEX_ARRAY_BUFFER_BINDING";
                case 0x8897:
                    return "GL_NORMAL_ARRAY_BUFFER_BINDING";
                case 0x8898:
                    return "GL_COLOR_ARRAY_BUFFER_BINDING";
                case 0x889A:
                    return "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING";
                case 0x889E:
                    return "GL_WEIGHT_ARRAY_BUFFER_BINDING_OES";
                case 0x889F:
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
                case 0x88B8:
                    return "GL_READ_ONLY";
                case 0x88B9:
                    return "GL_WRITE_ONLY";
                case 0x88BA:
                    return "GL_READ_WRITE";
                case 0x88BB:
                    return "GL_BUFFER_ACCESS_OES";
                case 0x88BC:
                    return "GL_BUFFER_MAPPED";
                case 0x88BD:
                    return "GL_BUFFER_MAP_POINTER";
                case 0x88BF:
                    return "GL_TIME_ELAPSED_EXT";
                case 0x88E0:
                    return "GL_STREAM_DRAW";
                case 0x88E1:
                    return "GL_STREAM_READ";
                case 0x88E2:
                    return "GL_STREAM_COPY";
                case 0x88E4:
                    return "GL_STATIC_DRAW";
                case 0x88E5:
                    return "GL_STATIC_READ";
                case 0x88E6:
                    return "GL_STATIC_COPY";
                case 0x88E8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88E9:
                    return "GL_DYNAMIC_READ";
                case 0x88EA:
                    return "GL_DYNAMIC_COPY";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x88ED:
                    return "GL_PIXEL_PACK_BUFFER_BINDING";
                case 0x88EF:
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING";
                case 0x88F0:
                    return "GL_DEPTH24_STENCIL8";
                case 0x88F1:
                    return "GL_TEXTURE_STENCIL_SIZE";
                case 0x88F9:
                    return "GL_SRC1_COLOR_EXT";
                case 0x88FA:
                    return "GL_ONE_MINUS_SRC1_COLOR_EXT";
                case 0x88FB:
                    return "GL_ONE_MINUS_SRC1_ALPHA_EXT";
                case 0x88FC:
                    return "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                case 0x88FF:
                    return "GL_MAX_ARRAY_TEXTURE_LAYERS";
                case 0x8904:
                    return "GL_MIN_PROGRAM_TEXEL_OFFSET";
                case 0x8905:
                    return "GL_MAX_PROGRAM_TEXEL_OFFSET";
                case 0x8916:
                    return "GL_GEOMETRY_VERTICES_OUT";
                case 0x8917:
                    return "GL_GEOMETRY_INPUT_TYPE";
                case 0x8918:
                    return "GL_GEOMETRY_OUTPUT_TYPE";
                case 0x8919:
                    return "GL_SAMPLER_BINDING";
                case 0x898A:
                    return "GL_POINT_SIZE_ARRAY_TYPE_OES";
                case 0x898B:
                    return "GL_POINT_SIZE_ARRAY_STRIDE_OES";
                case 0x898C:
                    return "GL_POINT_SIZE_ARRAY_POINTER_OES";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8A28:
                    return "GL_UNIFORM_BUFFER_BINDING";
                case 0x8A29:
                    return "GL_UNIFORM_BUFFER_START";
                case 0x8A2A:
                    return "GL_UNIFORM_BUFFER_SIZE";
                case 0x8A2B:
                    return "GL_MAX_VERTEX_UNIFORM_BLOCKS";
                case 0x8A2C:
                    return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS";
                case 0x8A2D:
                    return "GL_MAX_FRAGMENT_UNIFORM_BLOCKS";
                case 0x8A2E:
                    return "GL_MAX_COMBINED_UNIFORM_BLOCKS";
                case 0x8A2F:
                    return "GL_MAX_UNIFORM_BUFFER_BINDINGS";
                case 0x8A30:
                    return "GL_MAX_UNIFORM_BLOCK_SIZE";
                case 0x8A31:
                    return "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS";
                case 0x8A32:
                    return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8A33:
                    return "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8A34:
                    return "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT";
                case 0x8A35:
                    return "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH";
                case 0x8A36:
                    return "GL_ACTIVE_UNIFORM_BLOCKS";
                case 0x8A37:
                    return "GL_UNIFORM_TYPE";
                case 0x8A38:
                    return "GL_UNIFORM_SIZE";
                case 0x8A39:
                    return "GL_UNIFORM_NAME_LENGTH";
                case 0x8A3A:
                    return "GL_UNIFORM_BLOCK_INDEX";
                case 0x8A3B:
                    return "GL_UNIFORM_OFFSET";
                case 0x8A3C:
                    return "GL_UNIFORM_ARRAY_STRIDE";
                case 0x8A3D:
                    return "GL_UNIFORM_MATRIX_STRIDE";
                case 0x8A3E:
                    return "GL_UNIFORM_IS_ROW_MAJOR";
                case 0x8A3F:
                    return "GL_UNIFORM_BLOCK_BINDING";
                case 0x8A40:
                    return "GL_UNIFORM_BLOCK_DATA_SIZE";
                case 0x8A41:
                    return "GL_UNIFORM_BLOCK_NAME_LENGTH";
                case 0x8A42:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS";
                case 0x8A43:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES";
                case 0x8A44:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER";
                case 0x8A46:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x8A48:
                    return "GL_TEXTURE_SRGB_DECODE_EXT";
                case 0x8A49:
                    return "GL_DECODE_EXT";
                case 0x8A4A:
                    return "GL_SKIP_DECODE_EXT";
                case 0x8A4F:
                    return "GL_PROGRAM_PIPELINE_OBJECT_EXT";
                case 0x8A52:
                    return "GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT";
                case 0x8A54:
                    return "GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT";
                case 0x8A55:
                    return "GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT";
                case 0x8A56:
                    return "GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT";
                case 0x8A57:
                    return "GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT";
                case 0x8B30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8B31:
                    return "GL_VERTEX_SHADER";
                case 0x8B40:
                    return "GL_PROGRAM_OBJECT_EXT";
                case 0x8B48:
                    return "GL_SHADER_OBJECT_EXT";
                case 0x8B49:
                    return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8B4A:
                    return "GL_MAX_VERTEX_UNIFORM_COMPONENTS";
                case 0x8B4B:
                    return "GL_MAX_VARYING_COMPONENTS";
                case 0x8B4C:
                    return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS";
                case 0x8B4D:
                    return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS";
                case 0x8B4F:
                    return "GL_SHADER_TYPE";
                case 0x8B50:
                    return "GL_FLOAT_VEC2";
                case 0x8B51:
                    return "GL_FLOAT_VEC3";
                case 0x8B52:
                    return "GL_FLOAT_VEC4";
                case 0x8B53:
                    return "GL_INT_VEC2";
                case 0x8B54:
                    return "GL_INT_VEC3";
                case 0x8B55:
                    return "GL_INT_VEC4";
                case 0x8B56:
                    return "GL_BOOL";
                case 0x8B57:
                    return "GL_BOOL_VEC2";
                case 0x8B58:
                    return "GL_BOOL_VEC3";
                case 0x8B59:
                    return "GL_BOOL_VEC4";
                case 0x8B5A:
                    return "GL_FLOAT_MAT2";
                case 0x8B5B:
                    return "GL_FLOAT_MAT3";
                case 0x8B5C:
                    return "GL_FLOAT_MAT4";
                case 0x8B5E:
                    return "GL_SAMPLER_2D";
                case 0x8B5F:
                    return "GL_SAMPLER_3D";
                case 0x8B60:
                    return "GL_SAMPLER_CUBE";
                case 0x8B62:
                    return "GL_SAMPLER_2D_SHADOW";
                case 0x8B65:
                    return "GL_FLOAT_MAT2x3";
                case 0x8B66:
                    return "GL_FLOAT_MAT2x4";
                case 0x8B67:
                    return "GL_FLOAT_MAT3x2";
                case 0x8B68:
                    return "GL_FLOAT_MAT3x4";
                case 0x8B69:
                    return "GL_FLOAT_MAT4x2";
                case 0x8B6A:
                    return "GL_FLOAT_MAT4x3";
                case 0x8B80:
                    return "GL_DELETE_STATUS";
                case 0x8B81:
                    return "GL_COMPILE_STATUS";
                case 0x8B82:
                    return "GL_LINK_STATUS";
                case 0x8B83:
                    return "GL_VALIDATE_STATUS";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8B85:
                    return "GL_ATTACHED_SHADERS";
                case 0x8B86:
                    return "GL_ACTIVE_UNIFORMS";
                case 0x8B87:
                    return "GL_ACTIVE_UNIFORM_MAX_LENGTH";
                case 0x8B88:
                    return "GL_SHADER_SOURCE_LENGTH";
                case 0x8B89:
                    return "GL_ACTIVE_ATTRIBUTES";
                case 0x8B8A:
                    return "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH";
                case 0x8B8B:
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
                case 0x8B8C:
                    return "GL_SHADING_LANGUAGE_VERSION";
                case 0x8B8D:
                    return "GL_CURRENT_PROGRAM";
                case 0x8B90:
                    return "GL_PALETTE4_RGB8_OES";
                case 0x8B91:
                    return "GL_PALETTE4_RGBA8_OES";
                case 0x8B92:
                    return "GL_PALETTE4_R5_G6_B5_OES";
                case 0x8B93:
                    return "GL_PALETTE4_RGBA4_OES";
                case 0x8B94:
                    return "GL_PALETTE4_RGB5_A1_OES";
                case 0x8B95:
                    return "GL_PALETTE8_RGB8_OES";
                case 0x8B96:
                    return "GL_PALETTE8_RGBA8_OES";
                case 0x8B97:
                    return "GL_PALETTE8_R5_G6_B5_OES";
                case 0x8B98:
                    return "GL_PALETTE8_RGBA4_OES";
                case 0x8B99:
                    return "GL_PALETTE8_RGB5_A1_OES";
                case 0x8B9A:
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
                case 0x8B9B:
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
                case 0x8B9C:
                    return "GL_POINT_SIZE_ARRAY_OES";
                case 0x8B9D:
                    return "GL_TEXTURE_CROP_RECT_OES";
                case 0x8B9E:
                    return "GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES";
                case 0x8B9F:
                    return "GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES";
                case 0x8BBB:
                    return "GL_FRAMEBUFFER_FLIP_Y_MESA";
                case 0x8BC0:
                    return "GL_COUNTER_TYPE_AMD";
                case 0x8BC1:
                    return "GL_COUNTER_RANGE_AMD";
                case 0x8BC2:
                    return "GL_UNSIGNED_INT64_AMD";
                case 0x8BC3:
                    return "GL_PERCENTAGE_AMD";
                case 0x8BC4:
                    return "GL_PERFMON_RESULT_AVAILABLE_AMD";
                case 0x8BC5:
                    return "GL_PERFMON_RESULT_SIZE_AMD";
                case 0x8BC6:
                    return "GL_PERFMON_RESULT_AMD";
                case 0x8BE7:
                    return "GL_SAMPLER_EXTERNAL_2D_Y2Y_EXT";
                case 0x8BFA:
                    return "GL_TEXTURE_PROTECTED_EXT";
                case 0x8C00:
                    return "GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG";
                case 0x8C01:
                    return "GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG";
                case 0x8C02:
                    return "GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG";
                case 0x8C03:
                    return "GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG";
                case 0x8C10:
                    return "GL_TEXTURE_RED_TYPE";
                case 0x8C11:
                    return "GL_TEXTURE_GREEN_TYPE";
                case 0x8C12:
                    return "GL_TEXTURE_BLUE_TYPE";
                case 0x8C13:
                    return "GL_TEXTURE_ALPHA_TYPE";
                case 0x8C16:
                    return "GL_TEXTURE_DEPTH_TYPE";
                case 0x8C17:
                    return "GL_UNSIGNED_NORMALIZED";
                case 0x8C1A:
                    return "GL_TEXTURE_2D_ARRAY";
                case 0x8C1D:
                    return "GL_TEXTURE_BINDING_2D_ARRAY";
                case 0x8C29:
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C2B:
                    return "GL_MAX_TEXTURE_BUFFER_SIZE";
                case 0x8C2C:
                    return "GL_TEXTURE_BINDING_BUFFER";
                case 0x8C2D:
                    return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING";
                case 0x8C2F:
                    return "GL_ANY_SAMPLES_PASSED";
                case 0x8C36:
                    return "GL_SAMPLE_SHADING";
                case 0x8C37:
                    return "GL_MIN_SAMPLE_SHADING_VALUE";
                case 0x8C3A:
                    return "GL_R11F_G11F_B10F";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8C3D:
                    return "GL_RGB9_E5";
                case 0x8C3E:
                    return "GL_UNSIGNED_INT_5_9_9_9_REV";
                case 0x8C3F:
                    return "GL_TEXTURE_SHARED_SIZE";
                case 0x8C40:
                    return "GL_SRGB";
                case 0x8C41:
                    return "GL_SRGB8";
                case 0x8C42:
                    return "GL_SRGB_ALPHA_EXT";
                case 0x8C43:
                    return "GL_SRGB8_ALPHA8";
                case 0x8C4C:
                    return "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT";
                case 0x8C4D:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT";
                case 0x8C4E:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT";
                case 0x8C4F:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT";
                case 0x8C76:
                    return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH";
                case 0x8C7F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE";
                case 0x8C80:
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS";
                case 0x8C83:
                    return "GL_TRANSFORM_FEEDBACK_VARYINGS";
                case 0x8C84:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
                case 0x8C85:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
                case 0x8C87:
                    return "GL_PRIMITIVES_GENERATED";
                case 0x8C88:
                    return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN";
                case 0x8C89:
                    return "GL_RASTERIZER_DISCARD";
                case 0x8C8A:
                    return "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS";
                case 0x8C8B:
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS";
                case 0x8C8C:
                    return "GL_INTERLEAVED_ATTRIBS";
                case 0x8C8D:
                    return "GL_SEPARATE_ATTRIBS";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8C8F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
                case 0x8CA1:
                    return "GL_LOWER_LEFT_EXT";
                case 0x8CA2:
                    return "GL_UPPER_LEFT_EXT";
                case 0x8CA3:
                    return "GL_STENCIL_BACK_REF";
                case 0x8CA4:
                    return "GL_STENCIL_BACK_VALUE_MASK";
                case 0x8CA5:
                    return "GL_STENCIL_BACK_WRITEMASK";
                case 0x8CA6:
                    return "GL_FRAMEBUFFER_BINDING";
                case 0x8CA7:
                    return "GL_RENDERBUFFER_BINDING";
                case 0x8CA8:
                    return "GL_READ_FRAMEBUFFER";
                case 0x8CA9:
                    return "GL_DRAW_FRAMEBUFFER";
                case 0x8CAA:
                    return "GL_READ_FRAMEBUFFER_BINDING";
                case 0x8CAB:
                    return "GL_RENDERBUFFER_SAMPLES";
                case 0x8CAC:
                    return "GL_DEPTH_COMPONENT32F";
                case 0x8CAD:
                    return "GL_DEPTH32F_STENCIL8";
                case 0x8CD0:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE";
                case 0x8CD1:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME";
                case 0x8CD2:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL";
                case 0x8CD3:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE";
                case 0x8CD4:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER";
                case 0x8CD5:
                    return "GL_FRAMEBUFFER_COMPLETE";
                case 0x8CD6:
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                case 0x8CD7:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                case 0x8CD9:
                    return "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
                case 0x8CDA:
                    return "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES";
                case 0x8CDD:
                    return "GL_FRAMEBUFFER_UNSUPPORTED";
                case 0x8CDF:
                    return "GL_MAX_COLOR_ATTACHMENTS";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                case 0x8D00:
                    return "GL_DEPTH_ATTACHMENT";
                case 0x8D20:
                    return "GL_STENCIL_ATTACHMENT";
                case 0x8D40:
                    return "GL_FRAMEBUFFER";
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                case 0x8D42:
                    return "GL_RENDERBUFFER_WIDTH";
                case 0x8D43:
                    return "GL_RENDERBUFFER_HEIGHT";
                case 0x8D44:
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT";
                case 0x8D48:
                    return "GL_STENCIL_INDEX8";
                case 0x8D50:
                    return "GL_RENDERBUFFER_RED_SIZE";
                case 0x8D51:
                    return "GL_RENDERBUFFER_GREEN_SIZE";
                case 0x8D52:
                    return "GL_RENDERBUFFER_BLUE_SIZE";
                case 0x8D53:
                    return "GL_RENDERBUFFER_ALPHA_SIZE";
                case 0x8D54:
                    return "GL_RENDERBUFFER_DEPTH_SIZE";
                case 0x8D55:
                    return "GL_RENDERBUFFER_STENCIL_SIZE";
                case 0x8D56:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
                case 0x8D57:
                    return "GL_MAX_SAMPLES";
                case 0x8D60:
                    return "GL_TEXTURE_GEN_STR_OES";
                case 0x8D61:
                    return "GL_HALF_FLOAT_OES";
                case 0x8D62:
                    return "GL_RGB565";
                case 0x8D64:
                    return "GL_ETC1_RGB8_OES";
                case 0x8D65:
                    return "GL_TEXTURE_EXTERNAL_OES";
                case 0x8D66:
                    return "GL_SAMPLER_EXTERNAL_OES";
                case 0x8D67:
                    return "GL_TEXTURE_BINDING_EXTERNAL_OES";
                case 0x8D68:
                    return "GL_REQUIRED_TEXTURE_IMAGE_UNITS_OES";
                case 0x8D69:
                    return "GL_PRIMITIVE_RESTART_FIXED_INDEX";
                case 0x8D6A:
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE";
                case 0x8D6B:
                    return "GL_MAX_ELEMENT_INDEX";
                case 0x8D6C:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT";
                case 0x8D70:
                    return "GL_RGBA32UI";
                case 0x8D71:
                    return "GL_RGB32UI";
                case 0x8D76:
                    return "GL_RGBA16UI";
                case 0x8D77:
                    return "GL_RGB16UI";
                case 0x8D7C:
                    return "GL_RGBA8UI";
                case 0x8D7D:
                    return "GL_RGB8UI";
                case 0x8D82:
                    return "GL_RGBA32I";
                case 0x8D83:
                    return "GL_RGB32I";
                case 0x8D88:
                    return "GL_RGBA16I";
                case 0x8D89:
                    return "GL_RGB16I";
                case 0x8D8E:
                    return "GL_RGBA8I";
                case 0x8D8F:
                    return "GL_RGB8I";
                case 0x8D94:
                    return "GL_RED_INTEGER";
                case 0x8D98:
                    return "GL_RGB_INTEGER";
                case 0x8D99:
                    return "GL_RGBA_INTEGER";
                case 0x8D9F:
                    return "GL_INT_2_10_10_10_REV";
                case 0x8DA7:
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED";
                case 0x8DA8:
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS";
                case 0x8DAD:
                    return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV";
                case 0x8DB9:
                    return "GL_FRAMEBUFFER_SRGB_EXT";
                case 0x8DBB:
                    return "GL_COMPRESSED_RED_RGTC1_EXT";
                case 0x8DBC:
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1_EXT";
                case 0x8DBD:
                    return "GL_COMPRESSED_RED_GREEN_RGTC2_EXT";
                case 0x8DBE:
                    return "GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT";
                case 0x8DC1:
                    return "GL_SAMPLER_2D_ARRAY";
                case 0x8DC2:
                    return "GL_SAMPLER_BUFFER";
                case 0x8DC4:
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
                case 0x8DC5:
                    return "GL_SAMPLER_CUBE_SHADOW";
                case 0x8DC6:
                    return "GL_UNSIGNED_INT_VEC2";
                case 0x8DC7:
                    return "GL_UNSIGNED_INT_VEC3";
                case 0x8DC8:
                    return "GL_UNSIGNED_INT_VEC4";
                case 0x8DCA:
                    return "GL_INT_SAMPLER_2D";
                case 0x8DCB:
                    return "GL_INT_SAMPLER_3D";
                case 0x8DCC:
                    return "GL_INT_SAMPLER_CUBE";
                case 0x8DCF:
                    return "GL_INT_SAMPLER_2D_ARRAY";
                case 0x8DD0:
                    return "GL_INT_SAMPLER_BUFFER";
                case 0x8DD2:
                    return "GL_UNSIGNED_INT_SAMPLER_2D";
                case 0x8DD3:
                    return "GL_UNSIGNED_INT_SAMPLER_3D";
                case 0x8DD4:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE";
                case 0x8DD7:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
                case 0x8DD8:
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
                case 0x8DD9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8DDF:
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8DE0:
                    return "GL_MAX_GEOMETRY_OUTPUT_VERTICES";
                case 0x8DE1:
                    return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS";
                case 0x8DF0:
                    return "GL_LOW_FLOAT";
                case 0x8DF1:
                    return "GL_MEDIUM_FLOAT";
                case 0x8DF2:
                    return "GL_HIGH_FLOAT";
                case 0x8DF3:
                    return "GL_LOW_INT";
                case 0x8DF4:
                    return "GL_MEDIUM_INT";
                case 0x8DF5:
                    return "GL_HIGH_INT";
                case 0x8DF6:
                    return "GL_UNSIGNED_INT_10_10_10_2_OES";
                case 0x8DF7:
                    return "GL_INT_10_10_10_2_OES";
                case 0x8DF8:
                    return "GL_SHADER_BINARY_FORMATS";
                case 0x8DF9:
                    return "GL_NUM_SHADER_BINARY_FORMATS";
                case 0x8DFA:
                    return "GL_SHADER_COMPILER";
                case 0x8DFB:
                    return "GL_MAX_VERTEX_UNIFORM_VECTORS";
                case 0x8DFC:
                    return "GL_MAX_VARYING_VECTORS";
                case 0x8DFD:
                    return "GL_MAX_FRAGMENT_UNIFORM_VECTORS";
                case 0x8E1B:
                    return "GL_POLYGON_OFFSET_CLAMP_EXT";
                case 0x8E1E:
                    return "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS";
                case 0x8E1F:
                    return "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS";
                case 0x8E22:
                    return "GL_TRANSFORM_FEEDBACK";
                case 0x8E23:
                    return "GL_TRANSFORM_FEEDBACK_PAUSED";
                case 0x8E24:
                    return "GL_TRANSFORM_FEEDBACK_ACTIVE";
                case 0x8E25:
                    return "GL_TRANSFORM_FEEDBACK_BINDING";
                case 0x8E28:
                    return "GL_TIMESTAMP_EXT";
                case 0x8E42:
                    return "GL_TEXTURE_SWIZZLE_R";
                case 0x8E43:
                    return "GL_TEXTURE_SWIZZLE_G";
                case 0x8E44:
                    return "GL_TEXTURE_SWIZZLE_B";
                case 0x8E45:
                    return "GL_TEXTURE_SWIZZLE_A";
                case 0x8E4D:
                    return "GL_FIRST_VERTEX_CONVENTION";
                case 0x8E4E:
                    return "GL_LAST_VERTEX_CONVENTION";
                case 0x8E4F:
                    return "GL_PROVOKING_VERTEX_ANGLE";
                case 0x8E50:
                    return "GL_SAMPLE_POSITION";
                case 0x8E51:
                    return "GL_SAMPLE_MASK";
                case 0x8E52:
                    return "GL_SAMPLE_MASK_VALUE";
                case 0x8E59:
                    return "GL_MAX_SAMPLE_MASK_WORDS";
                case 0x8E5A:
                    return "GL_MAX_GEOMETRY_SHADER_INVOCATIONS";
                case 0x8E5B:
                    return "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET";
                case 0x8E5C:
                    return "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET";
                case 0x8E5D:
                    return "GL_FRAGMENT_INTERPOLATION_OFFSET_BITS";
                case 0x8E5E:
                    return "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET";
                case 0x8E5F:
                    return "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET";
                case 0x8E72:
                    return "GL_PATCH_VERTICES";
                case 0x8E75:
                    return "GL_TESS_CONTROL_OUTPUT_VERTICES";
                case 0x8E76:
                    return "GL_TESS_GEN_MODE";
                case 0x8E77:
                    return "GL_TESS_GEN_SPACING";
                case 0x8E78:
                    return "GL_TESS_GEN_VERTEX_ORDER";
                case 0x8E79:
                    return "GL_TESS_GEN_POINT_MODE";
                case 0x8E7A:
                    return "GL_ISOLINES";
                case 0x8E7B:
                    return "GL_FRACTIONAL_ODD";
                case 0x8E7C:
                    return "GL_FRACTIONAL_EVEN";
                case 0x8E7D:
                    return "GL_MAX_PATCH_VERTICES";
                case 0x8E7E:
                    return "GL_MAX_TESS_GEN_LEVEL";
                case 0x8E7F:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS";
                case 0x8E80:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS";
                case 0x8E81:
                    return "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS";
                case 0x8E82:
                    return "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS";
                case 0x8E83:
                    return "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS";
                case 0x8E84:
                    return "GL_MAX_TESS_PATCH_COMPONENTS";
                case 0x8E85:
                    return "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS";
                case 0x8E86:
                    return "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS";
                case 0x8E87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8E88:
                    return "GL_TESS_CONTROL_SHADER";
                case 0x8E89:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS";
                case 0x8E8A:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS";
                case 0x8E8C:
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM_EXT";
                case 0x8E8D:
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT";
                case 0x8E8E:
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT";
                case 0x8E8F:
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F38:
                    return "GL_MAX_IMAGE_UNITS";
                case 0x8F39:
                    return "GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES";
                case 0x8F3A:
                    return "GL_IMAGE_BINDING_NAME";
                case 0x8F3B:
                    return "GL_IMAGE_BINDING_LEVEL";
                case 0x8F3C:
                    return "GL_IMAGE_BINDING_LAYERED";
                case 0x8F3D:
                    return "GL_IMAGE_BINDING_LAYER";
                case 0x8F3E:
                    return "GL_IMAGE_BINDING_ACCESS";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x8F43:
                    return "GL_DRAW_INDIRECT_BUFFER_BINDING";
                case 0x8F4F:
                    return "GL_VERTEX_BINDING_BUFFER";
                case 0x8F65:
                    return "GL_FETCH_PER_SAMPLE_ARM";
                case 0x8F66:
                    return "GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM";
                case 0x8F94:
                    return "GL_R8_SNORM";
                case 0x8F95:
                    return "GL_RG8_SNORM";
                case 0x8F96:
                    return "GL_RGB8_SNORM";
                case 0x8F97:
                    return "GL_RGBA8_SNORM";
                case 0x8F98:
                    return "GL_R16_SNORM_EXT";
                case 0x8F99:
                    return "GL_RG16_SNORM_EXT";
                case 0x8F9A:
                    return "GL_RGB16_SNORM_EXT";
                case 0x8F9B:
                    return "GL_RGBA16_SNORM_EXT";
                case 0x8F9C:
                    return "GL_SIGNED_NORMALIZED";
                case 0x8FBB:
                    return "GL_GPU_DISJOINT_EXT";
                case 0x8FBD:
                    return "GL_SR8_EXT";
                case 0x8FBE:
                    return "GL_SRG8_EXT";
                case 0x8FBF:
                    return "GL_TEXTURE_FORMAT_SRGB_OVERRIDE_EXT";
                case 0x9009:
                    return "GL_TEXTURE_CUBE_MAP_ARRAY";
                case 0x900A:
                    return "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY";
                case 0x900C:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900D:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
                case 0x900E:
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900F:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x904D:
                    return "GL_IMAGE_2D";
                case 0x904E:
                    return "GL_IMAGE_3D";
                case 0x9050:
                    return "GL_IMAGE_CUBE";
                case 0x9051:
                    return "GL_IMAGE_BUFFER";
                case 0x9053:
                    return "GL_IMAGE_2D_ARRAY";
                case 0x9054:
                    return "GL_IMAGE_CUBE_MAP_ARRAY";
                case 0x9058:
                    return "GL_INT_IMAGE_2D";
                case 0x9059:
                    return "GL_INT_IMAGE_3D";
                case 0x905B:
                    return "GL_INT_IMAGE_CUBE";
                case 0x905C:
                    return "GL_INT_IMAGE_BUFFER";
                case 0x905E:
                    return "GL_INT_IMAGE_2D_ARRAY";
                case 0x905F:
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x9063:
                    return "GL_UNSIGNED_INT_IMAGE_2D";
                case 0x9064:
                    return "GL_UNSIGNED_INT_IMAGE_3D";
                case 0x9066:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE";
                case 0x9067:
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER";
                case 0x9069:
                    return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY";
                case 0x906A:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x906E:
                    return "GL_IMAGE_BINDING_FORMAT";
                case 0x906F:
                    return "GL_RGB10_A2UI";
                case 0x90C7:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE";
                case 0x90C8:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE";
                case 0x90C9:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS";
                case 0x90CA:
                    return "GL_MAX_VERTEX_IMAGE_UNIFORMS";
                case 0x90CB:
                    return "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS";
                case 0x90CC:
                    return "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS";
                case 0x90CD:
                    return "GL_MAX_GEOMETRY_IMAGE_UNIFORMS";
                case 0x90CE:
                    return "GL_MAX_FRAGMENT_IMAGE_UNIFORMS";
                case 0x90CF:
                    return "GL_MAX_COMBINED_IMAGE_UNIFORMS";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90D3:
                    return "GL_SHADER_STORAGE_BUFFER_BINDING";
                case 0x90D4:
                    return "GL_SHADER_STORAGE_BUFFER_START";
                case 0x90D5:
                    return "GL_SHADER_STORAGE_BUFFER_SIZE";
                case 0x90D6:
                    return "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS";
                case 0x90D7:
                    return "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS";
                case 0x90D8:
                    return "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS";
                case 0x90D9:
                    return "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS";
                case 0x90DA:
                    return "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS";
                case 0x90DB:
                    return "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS";
                case 0x90DC:
                    return "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS";
                case 0x90DD:
                    return "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS";
                case 0x90DE:
                    return "GL_MAX_SHADER_STORAGE_BLOCK_SIZE";
                case 0x90DF:
                    return "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT";
                case 0x90EA:
                    return "GL_DEPTH_STENCIL_TEXTURE_MODE";
                case 0x90EB:
                    return "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x90EF:
                    return "GL_DISPATCH_INDIRECT_BUFFER_BINDING";
                case 0x90F3:
                    return "GL_CONTEXT_ROBUST_ACCESS_EXT";
                case 0x9100:
                    return "GL_TEXTURE_2D_MULTISAMPLE";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
                case 0x9104:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE";
                case 0x9105:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY";
                case 0x9106:
                    return "GL_TEXTURE_SAMPLES";
                case 0x9107:
                    return "GL_TEXTURE_FIXED_SAMPLE_LOCATIONS";
                case 0x9108:
                    return "GL_SAMPLER_2D_MULTISAMPLE";
                case 0x9109:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910A:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910B:
                    return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910C:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910D:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910E:
                    return "GL_MAX_COLOR_TEXTURE_SAMPLES";
                case 0x910F:
                    return "GL_MAX_DEPTH_TEXTURE_SAMPLES";
                case 0x9110:
                    return "GL_MAX_INTEGER_SAMPLES";
                case 0x9111:
                    return "GL_MAX_SERVER_WAIT_TIMEOUT";
                case 0x9112:
                    return "GL_OBJECT_TYPE";
                case 0x9113:
                    return "GL_SYNC_CONDITION";
                case 0x9114:
                    return "GL_SYNC_STATUS";
                case 0x9115:
                    return "GL_SYNC_FLAGS";
                case 0x9116:
                    return "GL_SYNC_FENCE";
                case 0x9117:
                    return "GL_SYNC_GPU_COMMANDS_COMPLETE";
                case 0x9118:
                    return "GL_UNSIGNALED";
                case 0x9119:
                    return "GL_SIGNALED";
                case 0x911A:
                    return "GL_ALREADY_SIGNALED";
                case 0x911B:
                    return "GL_TIMEOUT_EXPIRED";
                case 0x911C:
                    return "GL_CONDITION_SATISFIED";
                case 0x911D:
                    return "GL_WAIT_FAILED";
                case 0x911F:
                    return "GL_BUFFER_ACCESS_FLAGS";
                case 0x9120:
                    return "GL_BUFFER_MAP_LENGTH";
                case 0x9121:
                    return "GL_BUFFER_MAP_OFFSET";
                case 0x9122:
                    return "GL_MAX_VERTEX_OUTPUT_COMPONENTS";
                case 0x9123:
                    return "GL_MAX_GEOMETRY_INPUT_COMPONENTS";
                case 0x9124:
                    return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS";
                case 0x9125:
                    return "GL_MAX_FRAGMENT_INPUT_COMPONENTS";
                case 0x912F:
                    return "GL_TEXTURE_IMMUTABLE_FORMAT";
                case 0x9137:
                    return "GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG";
                case 0x9138:
                    return "GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG";
                case 0x9143:
                    return "GL_MAX_DEBUG_MESSAGE_LENGTH";
                case 0x9144:
                    return "GL_MAX_DEBUG_LOGGED_MESSAGES";
                case 0x9145:
                    return "GL_DEBUG_LOGGED_MESSAGES";
                case 0x9146:
                    return "GL_DEBUG_SEVERITY_HIGH";
                case 0x9147:
                    return "GL_DEBUG_SEVERITY_MEDIUM";
                case 0x9148:
                    return "GL_DEBUG_SEVERITY_LOW";
                case 0x9151:
                    return "GL_BUFFER_OBJECT_EXT";
                case 0x9153:
                    return "GL_QUERY_OBJECT_EXT";
                case 0x9154:
                    return "GL_VERTEX_ARRAY_OBJECT_EXT";
                case 0x919D:
                    return "GL_TEXTURE_BUFFER_OFFSET";
                case 0x919E:
                    return "GL_TEXTURE_BUFFER_SIZE";
                case 0x919F:
                    return "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT";
                case 0x91B0:
                    return "GL_MAX_SHADER_COMPILER_THREADS_KHR";
                case 0x91B1:
                    return "GL_COMPLETION_STATUS_KHR";
                case 0x91B9:
                    return "GL_COMPUTE_SHADER";
                case 0x91BB:
                    return "GL_MAX_COMPUTE_UNIFORM_BLOCKS";
                case 0x91BC:
                    return "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS";
                case 0x91BD:
                    return "GL_MAX_COMPUTE_IMAGE_UNIFORMS";
                case 0x91BE:
                    return "GL_MAX_COMPUTE_WORK_GROUP_COUNT";
                case 0x91BF:
                    return "GL_MAX_COMPUTE_WORK_GROUP_SIZE";
                case 0x9270:
                    return "GL_COMPRESSED_R11_EAC";
                case 0x9271:
                    return "GL_COMPRESSED_SIGNED_R11_EAC";
                case 0x9272:
                    return "GL_COMPRESSED_RG11_EAC";
                case 0x9273:
                    return "GL_COMPRESSED_SIGNED_RG11_EAC";
                case 0x9274:
                    return "GL_COMPRESSED_RGB8_ETC2";
                case 0x9275:
                    return "GL_COMPRESSED_SRGB8_ETC2";
                case 0x9276:
                    return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9277:
                    return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9278:
                    return "GL_COMPRESSED_RGBA8_ETC2_EAC";
                case 0x9279:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
                case 0x9294:
                    return "GL_MULTIPLY";
                case 0x9295:
                    return "GL_SCREEN";
                case 0x9296:
                    return "GL_OVERLAY";
                case 0x9297:
                    return "GL_DARKEN";
                case 0x9298:
                    return "GL_LIGHTEN";
                case 0x9299:
                    return "GL_COLORDODGE";
                case 0x929A:
                    return "GL_COLORBURN";
                case 0x929B:
                    return "GL_HARDLIGHT";
                case 0x929C:
                    return "GL_SOFTLIGHT";
                case 0x929E:
                    return "GL_DIFFERENCE";
                case 0x92A0:
                    return "GL_EXCLUSION";
                case 0x92AD:
                    return "GL_HSL_HUE";
                case 0x92AE:
                    return "GL_HSL_SATURATION";
                case 0x92AF:
                    return "GL_HSL_COLOR";
                case 0x92B0:
                    return "GL_HSL_LUMINOSITY";
                case 0x92BE:
                    return "GL_PRIMITIVE_BOUNDING_BOX";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                case 0x92C1:
                    return "GL_ATOMIC_COUNTER_BUFFER_BINDING";
                case 0x92C2:
                    return "GL_ATOMIC_COUNTER_BUFFER_START";
                case 0x92C3:
                    return "GL_ATOMIC_COUNTER_BUFFER_SIZE";
                case 0x92CC:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS";
                case 0x92CD:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS";
                case 0x92CE:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS";
                case 0x92CF:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS";
                case 0x92D0:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS";
                case 0x92D1:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS";
                case 0x92D2:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTERS";
                case 0x92D3:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS";
                case 0x92D4:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS";
                case 0x92D5:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTERS";
                case 0x92D6:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTERS";
                case 0x92D7:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTERS";
                case 0x92D8:
                    return "GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE";
                case 0x92D9:
                    return "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS";
                case 0x92DB:
                    return "GL_UNSIGNED_INT_ATOMIC_COUNTER";
                case 0x92DC:
                    return "GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS";
                case 0x92E0:
                    return "GL_DEBUG_OUTPUT";
                case 0x92E1:
                    return "GL_UNIFORM";
                case 0x92E2:
                    return "GL_UNIFORM_BLOCK";
                case 0x92E3:
                    return "GL_PROGRAM_INPUT";
                case 0x92E4:
                    return "GL_PROGRAM_OUTPUT";
                case 0x92E5:
                    return "GL_BUFFER_VARIABLE";
                case 0x92E6:
                    return "GL_SHADER_STORAGE_BLOCK";
                case 0x92E7:
                    return "GL_IS_PER_PATCH";
                case 0x92F4:
                    return "GL_TRANSFORM_FEEDBACK_VARYING";
                case 0x92F5:
                    return "GL_ACTIVE_RESOURCES";
                case 0x92F6:
                    return "GL_MAX_NAME_LENGTH";
                case 0x92F7:
                    return "GL_MAX_NUM_ACTIVE_VARIABLES";
                case 0x92F9:
                    return "GL_NAME_LENGTH";
                case 0x92FA:
                    return "GL_TYPE";
                case 0x92FB:
                    return "GL_ARRAY_SIZE";
                case 0x92FC:
                    return "GL_OFFSET";
                case 0x92FD:
                    return "GL_BLOCK_INDEX";
                case 0x92FE:
                    return "GL_ARRAY_STRIDE";
                case 0x92FF:
                    return "GL_MATRIX_STRIDE";
                case 0x9300:
                    return "GL_IS_ROW_MAJOR";
                case 0x9301:
                    return "GL_ATOMIC_COUNTER_BUFFER_INDEX";
                case 0x9302:
                    return "GL_BUFFER_BINDING";
                case 0x9303:
                    return "GL_BUFFER_DATA_SIZE";
                case 0x9304:
                    return "GL_NUM_ACTIVE_VARIABLES";
                case 0x9305:
                    return "GL_ACTIVE_VARIABLES";
                case 0x9306:
                    return "GL_REFERENCED_BY_VERTEX_SHADER";
                case 0x9307:
                    return "GL_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x9308:
                    return "GL_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x9309:
                    return "GL_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x930A:
                    return "GL_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x930B:
                    return "GL_REFERENCED_BY_COMPUTE_SHADER";
                case 0x930C:
                    return "GL_TOP_LEVEL_ARRAY_SIZE";
                case 0x930D:
                    return "GL_TOP_LEVEL_ARRAY_STRIDE";
                case 0x930E:
                    return "GL_LOCATION";
                case 0x930F:
                    return "GL_LOCATION_INDEX_EXT";
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                case 0x9315:
                    return "GL_MAX_FRAMEBUFFER_WIDTH";
                case 0x9316:
                    return "GL_MAX_FRAMEBUFFER_HEIGHT";
                case 0x9317:
                    return "GL_MAX_FRAMEBUFFER_LAYERS";
                case 0x9318:
                    return "GL_MAX_FRAMEBUFFER_SAMPLES";
                case 0x935C:
                    return "GL_CLIP_ORIGIN_EXT";
                case 0x935D:
                    return "GL_CLIP_DEPTH_MODE_EXT";
                case 0x935E:
                    return "GL_NEGATIVE_ONE_TO_ONE_EXT";
                case 0x935F:
                    return "GL_ZERO_TO_ONE_EXT";
                case 0x9380:
                    return "GL_NUM_SAMPLE_COUNTS";
                case 0x9381:
                    return "GL_MULTISAMPLE_LINE_WIDTH_RANGE";
                case 0x9382:
                    return "GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY";
                case 0x93A0:
                    return "GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE";
                case 0x93A1:
                    return "GL_BGRA8_EXT";
                case 0x93A2:
                    return "GL_TEXTURE_USAGE_ANGLE";
                case 0x93A3:
                    return "GL_FRAMEBUFFER_ATTACHMENT_ANGLE";
                case 0x93A4:
                    return "GL_PACK_REVERSE_ROW_ORDER_ANGLE";
                case 0x93A6:
                    return "GL_PROGRAM_BINARY_ANGLE";
                case 0x93A7:
                    return "GL_ROBUST_RESOURCE_INITIALIZATION_ANGLE";
                case 0x93AE:
                    return "GL_HANDLE_TYPE_ZIRCON_VMO_ANGLE";
                case 0x93AF:
                    return "GL_HANDLE_TYPE_ZIRCON_EVENT_ANGLE";
                case 0x93B0:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4";
                case 0x93B1:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4";
                case 0x93B2:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5";
                case 0x93B3:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5";
                case 0x93B4:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6";
                case 0x93B5:
                    return "GL_COMPRESSED_RGBA_ASTC_8x5";
                case 0x93B6:
                    return "GL_COMPRESSED_RGBA_ASTC_8x6";
                case 0x93B7:
                    return "GL_COMPRESSED_RGBA_ASTC_8x8";
                case 0x93B8:
                    return "GL_COMPRESSED_RGBA_ASTC_10x5";
                case 0x93B9:
                    return "GL_COMPRESSED_RGBA_ASTC_10x6";
                case 0x93BA:
                    return "GL_COMPRESSED_RGBA_ASTC_10x8";
                case 0x93BB:
                    return "GL_COMPRESSED_RGBA_ASTC_10x10";
                case 0x93BC:
                    return "GL_COMPRESSED_RGBA_ASTC_12x10";
                case 0x93BD:
                    return "GL_COMPRESSED_RGBA_ASTC_12x12";
                case 0x93C0:
                    return "GL_COMPRESSED_RGBA_ASTC_3x3x3_OES";
                case 0x93C1:
                    return "GL_COMPRESSED_RGBA_ASTC_4x3x3_OES";
                case 0x93C2:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4x3_OES";
                case 0x93C3:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4x4_OES";
                case 0x93C4:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4x4_OES";
                case 0x93C5:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5x4_OES";
                case 0x93C6:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5x5_OES";
                case 0x93C7:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5x5_OES";
                case 0x93C8:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6x5_OES";
                case 0x93C9:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6x6_OES";
                case 0x93D0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4";
                case 0x93D1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4";
                case 0x93D2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5";
                case 0x93D3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5";
                case 0x93D4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6";
                case 0x93D5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5";
                case 0x93D6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6";
                case 0x93D7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8";
                case 0x93D8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5";
                case 0x93D9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6";
                case 0x93DA:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8";
                case 0x93DB:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10";
                case 0x93DC:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10";
                case 0x93DD:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12";
                case 0x93E0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES";
                case 0x93E1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES";
                case 0x93E2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES";
                case 0x93E3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES";
                case 0x93E4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES";
                case 0x93E5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES";
                case 0x93E6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES";
                case 0x93E7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES";
                case 0x93E8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES";
                case 0x93E9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES";
                case 0x93F0:
                    return "GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG";
                case 0x93F1:
                    return "GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG";
                case 0x9530:
                    return "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT";
                case 0x9531:
                    return "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT";
                case 0x9580:
                    return "GL_TEXTURE_TILING_EXT";
                case 0x9581:
                    return "GL_DEDICATED_MEMORY_OBJECT_EXT";
                case 0x9582:
                    return "GL_NUM_TILING_TYPES_EXT";
                case 0x9583:
                    return "GL_TILING_TYPES_EXT";
                case 0x9584:
                    return "GL_OPTIMAL_TILING_EXT";
                case 0x9585:
                    return "GL_LINEAR_TILING_EXT";
                case 0x9586:
                    return "GL_HANDLE_TYPE_OPAQUE_FD_EXT";
                case 0x958D:
                    return "GL_LAYOUT_GENERAL_EXT";
                case 0x958E:
                    return "GL_LAYOUT_COLOR_ATTACHMENT_EXT";
                case 0x958F:
                    return "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT";
                case 0x9590:
                    return "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT";
                case 0x9591:
                    return "GL_LAYOUT_SHADER_READ_ONLY_EXT";
                case 0x9592:
                    return "GL_LAYOUT_TRANSFER_SRC_EXT";
                case 0x9593:
                    return "GL_LAYOUT_TRANSFER_DST_EXT";
                case 0x9596:
                    return "GL_NUM_DEVICE_UUIDS_EXT";
                case 0x9597:
                    return "GL_DEVICE_UUID_EXT";
                case 0x9598:
                    return "GL_DRIVER_UUID_EXT";
                case 0x959B:
                    return "GL_PROTECTED_MEMORY_OBJECT_EXT";
                case 0x9630:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR";
                case 0x9631:
                    return "GL_MAX_VIEWS_OVR";
                case 0x9632:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR";
                case 0x9633:
                    return "GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR";
                case 0x969F:
                    return "GL_RESOURCE_INITIALIZED_ANGLE";
                case 0x96A4:
                    return "GL_SHADING_RATE_QCOM";
                case 0x96A5:
                    return "GL_SHADING_RATE_PRESERVE_ASPECT_RATIO_QCOM";
                case 0x96A6:
                    return "GL_SHADING_RATE_1X1_PIXELS_QCOM";
                case 0x96A7:
                    return "GL_SHADING_RATE_1X2_PIXELS_QCOM";
                case 0x96A8:
                    return "GL_SHADING_RATE_2X1_PIXELS_QCOM";
                case 0x96A9:
                    return "GL_SHADING_RATE_2X2_PIXELS_QCOM";
                case 0x96AC:
                    return "GL_SHADING_RATE_4X2_PIXELS_QCOM";
                case 0x96AE:
                    return "GL_SHADING_RATE_4X4_PIXELS_QCOM";
                case 0x96E0:
                    return "GL_MAX_PIXEL_LOCAL_STORAGE_PLANES_ANGLE";
                case 0x96E1:
                    return "GL_MAX_COLOR_ATTACHMENTS_WITH_ACTIVE_PIXEL_LOCAL_STORAGE_ANGLE";
                case 0x96E2:
                    return "GL_MAX_COMBINED_DRAW_BUFFERS_AND_PIXEL_LOCAL_STORAGE_PLANES_ANGLE";
                case 0x96E3:
                    return "GL_PIXEL_LOCAL_STORAGE_ACTIVE_PLANES_ANGLE";
                case 0x96E4:
                    return "GL_LOAD_OP_ZERO_ANGLE";
                case 0x96E5:
                    return "GL_LOAD_OP_CLEAR_ANGLE";
                case 0x96E6:
                    return "GL_LOAD_OP_LOAD_ANGLE";
                case 0x96E7:
                    return "GL_LOAD_OP_DISABLE_ANGLE";
                case 0x96E8:
                    return "GL_STORE_OP_STORE_ANGLE";
                case 0x96E9:
                    return "GL_PIXEL_LOCAL_FORMAT_ANGLE";
                case 0x96EA:
                    return "GL_PIXEL_LOCAL_TEXTURE_NAME_ANGLE";
                case 0x96EB:
                    return "GL_PIXEL_LOCAL_TEXTURE_LEVEL_ANGLE";
                case 0x96EC:
                    return "GL_PIXEL_LOCAL_TEXTURE_LAYER_ANGLE";
                case 0x96ED:
                    return "GL_PIXEL_LOCAL_CLEAR_VALUE_FLOAT_ANGLE";
                case 0x96EE:
                    return "GL_PIXEL_LOCAL_CLEAR_VALUE_INT_ANGLE";
                case 0x96EF:
                    return "GL_PIXEL_LOCAL_CLEAR_VALUE_UNSIGNED_INT_ANGLE";
                case 0xFFFFFFFF:
                    return "GL_INVALID_INDEX";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::AlphaFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::AtomicCounterBufferPName:
        {
            switch (value)
            {
                case 0x92C1:
                    return "GL_ATOMIC_COUNTER_BUFFER_BINDING";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::AttribMask:
        {
            switch (value)
            {
                case 0x100:
                    return "GL_DEPTH_BUFFER_BIT";
                case 0x400:
                    return "GL_STENCIL_BUFFER_BIT";
                case 0x4000:
                    return "GL_COLOR_BUFFER_BIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::AttributeType:
        {
            switch (value)
            {
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x8B50:
                    return "GL_FLOAT_VEC2";
                case 0x8B51:
                    return "GL_FLOAT_VEC3";
                case 0x8B52:
                    return "GL_FLOAT_VEC4";
                case 0x8B53:
                    return "GL_INT_VEC2";
                case 0x8B54:
                    return "GL_INT_VEC3";
                case 0x8B55:
                    return "GL_INT_VEC4";
                case 0x8B56:
                    return "GL_BOOL";
                case 0x8B57:
                    return "GL_BOOL_VEC2";
                case 0x8B58:
                    return "GL_BOOL_VEC3";
                case 0x8B59:
                    return "GL_BOOL_VEC4";
                case 0x8B5A:
                    return "GL_FLOAT_MAT2";
                case 0x8B5B:
                    return "GL_FLOAT_MAT3";
                case 0x8B5C:
                    return "GL_FLOAT_MAT4";
                case 0x8B5E:
                    return "GL_SAMPLER_2D";
                case 0x8B5F:
                    return "GL_SAMPLER_3D";
                case 0x8B60:
                    return "GL_SAMPLER_CUBE";
                case 0x8B62:
                    return "GL_SAMPLER_2D_SHADOW";
                case 0x8B65:
                    return "GL_FLOAT_MAT2x3";
                case 0x8B66:
                    return "GL_FLOAT_MAT2x4";
                case 0x8B67:
                    return "GL_FLOAT_MAT3x2";
                case 0x8B68:
                    return "GL_FLOAT_MAT3x4";
                case 0x8B69:
                    return "GL_FLOAT_MAT4x2";
                case 0x8B6A:
                    return "GL_FLOAT_MAT4x3";
                case 0x8DC2:
                    return "GL_SAMPLER_BUFFER";
                case 0x8DC4:
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
                case 0x8DC5:
                    return "GL_SAMPLER_CUBE_SHADOW";
                case 0x8DC6:
                    return "GL_UNSIGNED_INT_VEC2";
                case 0x8DC7:
                    return "GL_UNSIGNED_INT_VEC3";
                case 0x8DC8:
                    return "GL_UNSIGNED_INT_VEC4";
                case 0x8DCA:
                    return "GL_INT_SAMPLER_2D";
                case 0x8DCB:
                    return "GL_INT_SAMPLER_3D";
                case 0x8DCC:
                    return "GL_INT_SAMPLER_CUBE";
                case 0x8DCF:
                    return "GL_INT_SAMPLER_2D_ARRAY";
                case 0x8DD0:
                    return "GL_INT_SAMPLER_BUFFER";
                case 0x8DD2:
                    return "GL_UNSIGNED_INT_SAMPLER_2D";
                case 0x8DD3:
                    return "GL_UNSIGNED_INT_SAMPLER_3D";
                case 0x8DD4:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE";
                case 0x8DD7:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
                case 0x8DD8:
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
                case 0x900C:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900D:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
                case 0x900E:
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900F:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x904D:
                    return "GL_IMAGE_2D";
                case 0x904E:
                    return "GL_IMAGE_3D";
                case 0x9050:
                    return "GL_IMAGE_CUBE";
                case 0x9051:
                    return "GL_IMAGE_BUFFER";
                case 0x9053:
                    return "GL_IMAGE_2D_ARRAY";
                case 0x9054:
                    return "GL_IMAGE_CUBE_MAP_ARRAY";
                case 0x9058:
                    return "GL_INT_IMAGE_2D";
                case 0x9059:
                    return "GL_INT_IMAGE_3D";
                case 0x905B:
                    return "GL_INT_IMAGE_CUBE";
                case 0x905C:
                    return "GL_INT_IMAGE_BUFFER";
                case 0x905E:
                    return "GL_INT_IMAGE_2D_ARRAY";
                case 0x905F:
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x9063:
                    return "GL_UNSIGNED_INT_IMAGE_2D";
                case 0x9064:
                    return "GL_UNSIGNED_INT_IMAGE_3D";
                case 0x9066:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE";
                case 0x9067:
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER";
                case 0x9069:
                    return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY";
                case 0x906A:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x9108:
                    return "GL_SAMPLER_2D_MULTISAMPLE";
                case 0x9109:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910A:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910B:
                    return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910C:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910D:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BindTransformFeedbackTarget:
        {
            switch (value)
            {
                case 0x8E22:
                    return "GL_TRANSFORM_FEEDBACK";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BinormalPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BlendEquationModeEXT:
        {
            switch (value)
            {
                case 0x8006:
                    return "GL_FUNC_ADD";
                case 0x8007:
                    return "GL_MIN";
                case 0x8008:
                    return "GL_MAX";
                case 0x800A:
                    return "GL_FUNC_SUBTRACT";
                case 0x800B:
                    return "GL_FUNC_REVERSE_SUBTRACT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BlendingFactor:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x1:
                    return "GL_ONE";
                case 0x300:
                    return "GL_SRC_COLOR";
                case 0x301:
                    return "GL_ONE_MINUS_SRC_COLOR";
                case 0x302:
                    return "GL_SRC_ALPHA";
                case 0x303:
                    return "GL_ONE_MINUS_SRC_ALPHA";
                case 0x304:
                    return "GL_DST_ALPHA";
                case 0x305:
                    return "GL_ONE_MINUS_DST_ALPHA";
                case 0x306:
                    return "GL_DST_COLOR";
                case 0x307:
                    return "GL_ONE_MINUS_DST_COLOR";
                case 0x308:
                    return "GL_SRC_ALPHA_SATURATE";
                case 0x8001:
                    return "GL_CONSTANT_COLOR";
                case 0x8002:
                    return "GL_ONE_MINUS_CONSTANT_COLOR";
                case 0x8003:
                    return "GL_CONSTANT_ALPHA";
                case 0x8004:
                    return "GL_ONE_MINUS_CONSTANT_ALPHA";
                case 0x8589:
                    return "GL_SRC1_ALPHA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BlitFramebufferFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::Boolean:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_FALSE";
                case 0x1:
                    return "GL_TRUE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::Buffer:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BufferAccessARB:
        {
            switch (value)
            {
                case 0x88B8:
                    return "GL_READ_ONLY";
                case 0x88B9:
                    return "GL_WRITE_ONLY";
                case 0x88BA:
                    return "GL_READ_WRITE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BufferPNameARB:
        {
            switch (value)
            {
                case 0x8764:
                    return "GL_BUFFER_SIZE";
                case 0x8765:
                    return "GL_BUFFER_USAGE";
                case 0x88BC:
                    return "GL_BUFFER_MAPPED";
                case 0x911F:
                    return "GL_BUFFER_ACCESS_FLAGS";
                case 0x9120:
                    return "GL_BUFFER_MAP_LENGTH";
                case 0x9121:
                    return "GL_BUFFER_MAP_OFFSET";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BufferPointerNameARB:
        {
            switch (value)
            {
                case 0x88BD:
                    return "GL_BUFFER_MAP_POINTER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BufferStorageMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_MAP_READ_BIT";
                case 0x2:
                    return "GL_MAP_WRITE_BIT";
                case 0x40:
                    return "GL_MAP_PERSISTENT_BIT_EXT";
                case 0x80:
                    return "GL_MAP_COHERENT_BIT_EXT";
                case 0x100:
                    return "GL_DYNAMIC_STORAGE_BIT_EXT";
                case 0x200:
                    return "GL_CLIENT_STORAGE_BIT_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BufferStorageTarget:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BufferTargetARB:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::BufferUsageARB:
        {
            switch (value)
            {
                case 0x88E0:
                    return "GL_STREAM_DRAW";
                case 0x88E1:
                    return "GL_STREAM_READ";
                case 0x88E2:
                    return "GL_STREAM_COPY";
                case 0x88E4:
                    return "GL_STATIC_DRAW";
                case 0x88E5:
                    return "GL_STATIC_READ";
                case 0x88E6:
                    return "GL_STATIC_COPY";
                case 0x88E8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88E9:
                    return "GL_DYNAMIC_READ";
                case 0x88EA:
                    return "GL_DYNAMIC_COPY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ClampColorModeARB:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_FALSE";
                case 0x1:
                    return "GL_TRUE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ClearBufferMask:
        {
            switch (value)
            {
                case 0x100:
                    return "GL_DEPTH_BUFFER_BIT";
                case 0x400:
                    return "GL_STENCIL_BUFFER_BIT";
                case 0x4000:
                    return "GL_COLOR_BUFFER_BIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ClipPlaneName:
        {
            switch (value)
            {
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ColorBuffer:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ColorMaterialParameter:
        {
            switch (value)
            {
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1600:
                    return "GL_EMISSION";
                case 0x1602:
                    return "GL_AMBIENT_AND_DIFFUSE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ColorPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::CombinerBiasNV:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::CombinerComponentUsageNV:
        {
            switch (value)
            {
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::CombinerPortionNV:
        {
            switch (value)
            {
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::CombinerScaleNV:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ContainerType:
        {
            switch (value)
            {
                case 0x8B40:
                    return "GL_PROGRAM_OBJECT_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ContextFlagMask:
        {
            switch (value)
            {
                case 0x2:
                    return "GL_CONTEXT_FLAG_DEBUG_BIT";
                case 0x4:
                    return "GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT";
                case 0x8:
                    return "GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR";
                case 0x10:
                    return "GL_CONTEXT_FLAG_PROTECTED_CONTENT_BIT_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::CopyBufferSubDataTarget:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::CopyImageSubDataTarget:
        {
            switch (value)
            {
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x806F:
                    return "GL_TEXTURE_3D";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8C1A:
                    return "GL_TEXTURE_2D_ARRAY";
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                case 0x9009:
                    return "GL_TEXTURE_CUBE_MAP_ARRAY";
                case 0x9100:
                    return "GL_TEXTURE_2D_MULTISAMPLE";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::DebugSeverity:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x826B:
                    return "GL_DEBUG_SEVERITY_NOTIFICATION";
                case 0x9146:
                    return "GL_DEBUG_SEVERITY_HIGH";
                case 0x9147:
                    return "GL_DEBUG_SEVERITY_MEDIUM";
                case 0x9148:
                    return "GL_DEBUG_SEVERITY_LOW";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::DebugSource:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x8246:
                    return "GL_DEBUG_SOURCE_API";
                case 0x8247:
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM";
                case 0x8248:
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER";
                case 0x8249:
                    return "GL_DEBUG_SOURCE_THIRD_PARTY";
                case 0x824A:
                    return "GL_DEBUG_SOURCE_APPLICATION";
                case 0x824B:
                    return "GL_DEBUG_SOURCE_OTHER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::DebugType:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x824C:
                    return "GL_DEBUG_TYPE_ERROR";
                case 0x824D:
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR";
                case 0x824E:
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR";
                case 0x824F:
                    return "GL_DEBUG_TYPE_PORTABILITY";
                case 0x8250:
                    return "GL_DEBUG_TYPE_PERFORMANCE";
                case 0x8251:
                    return "GL_DEBUG_TYPE_OTHER";
                case 0x8268:
                    return "GL_DEBUG_TYPE_MARKER";
                case 0x8269:
                    return "GL_DEBUG_TYPE_PUSH_GROUP";
                case 0x826A:
                    return "GL_DEBUG_TYPE_POP_GROUP";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::DepthFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::DepthStencilTextureMode:
        {
            switch (value)
            {
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::DrawBufferMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::DrawElementsType:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ElementPointerTypeATI:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::EnableCap:
        {
            switch (value)
            {
                case 0xB10:
                    return "GL_POINT_SMOOTH";
                case 0xB20:
                    return "GL_LINE_SMOOTH";
                case 0xB44:
                    return "GL_CULL_FACE";
                case 0xB50:
                    return "GL_LIGHTING";
                case 0xB57:
                    return "GL_COLOR_MATERIAL";
                case 0xB60:
                    return "GL_FOG";
                case 0xB71:
                    return "GL_DEPTH_TEST";
                case 0xB90:
                    return "GL_STENCIL_TEST";
                case 0xBA1:
                    return "GL_NORMALIZE";
                case 0xBC0:
                    return "GL_ALPHA_TEST";
                case 0xBD0:
                    return "GL_DITHER";
                case 0xBE2:
                    return "GL_BLEND";
                case 0xBF2:
                    return "GL_COLOR_LOGIC_OP";
                case 0xC11:
                    return "GL_SCISSOR_TEST";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                case 0x3006:
                    return "GL_CLIP_DISTANCE6_ANGLE";
                case 0x3007:
                    return "GL_CLIP_DISTANCE7_ANGLE";
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x8075:
                    return "GL_NORMAL_ARRAY";
                case 0x8076:
                    return "GL_COLOR_ARRAY";
                case 0x8078:
                    return "GL_TEXTURE_COORD_ARRAY";
                case 0x809D:
                    return "GL_MULTISAMPLE";
                case 0x809E:
                    return "GL_SAMPLE_ALPHA_TO_COVERAGE";
                case 0x809F:
                    return "GL_SAMPLE_ALPHA_TO_ONE";
                case 0x80A0:
                    return "GL_SAMPLE_COVERAGE";
                case 0x8242:
                    return "GL_DEBUG_OUTPUT_SYNCHRONOUS";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8C36:
                    return "GL_SAMPLE_SHADING";
                case 0x8C89:
                    return "GL_RASTERIZER_DISCARD";
                case 0x8D60:
                    return "GL_TEXTURE_GEN_STR_OES";
                case 0x8D69:
                    return "GL_PRIMITIVE_RESTART_FIXED_INDEX";
                case 0x8E51:
                    return "GL_SAMPLE_MASK";
                case 0x8F65:
                    return "GL_FETCH_PER_SAMPLE_ARM";
                case 0x92E0:
                    return "GL_DEBUG_OUTPUT";
                case 0x96A5:
                    return "GL_SHADING_RATE_PRESERVE_ASPECT_RATIO_QCOM";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ErrorCode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NO_ERROR";
                case 0x500:
                    return "GL_INVALID_ENUM";
                case 0x501:
                    return "GL_INVALID_VALUE";
                case 0x502:
                    return "GL_INVALID_OPERATION";
                case 0x503:
                    return "GL_STACK_OVERFLOW";
                case 0x504:
                    return "GL_STACK_UNDERFLOW";
                case 0x505:
                    return "GL_OUT_OF_MEMORY";
                case 0x506:
                    return "GL_INVALID_FRAMEBUFFER_OPERATION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ExternalHandleType:
        {
            switch (value)
            {
                case 0x9586:
                    return "GL_HANDLE_TYPE_OPAQUE_FD_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FenceConditionNV:
        {
            switch (value)
            {
                case 0x84F2:
                    return "GL_ALL_COMPLETED_NV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FenceParameterNameNV:
        {
            switch (value)
            {
                case 0x84F3:
                    return "GL_FENCE_STATUS_NV";
                case 0x84F4:
                    return "GL_FENCE_CONDITION_NV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FogCoordinatePointerType:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FogMode:
        {
            switch (value)
            {
                case 0x800:
                    return "GL_EXP";
                case 0x801:
                    return "GL_EXP2";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FogPName:
        {
            switch (value)
            {
                case 0xB62:
                    return "GL_FOG_DENSITY";
                case 0xB63:
                    return "GL_FOG_START";
                case 0xB64:
                    return "GL_FOG_END";
                case 0xB65:
                    return "GL_FOG_MODE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FogParameter:
        {
            switch (value)
            {
                case 0xB62:
                    return "GL_FOG_DENSITY";
                case 0xB63:
                    return "GL_FOG_START";
                case 0xB64:
                    return "GL_FOG_END";
                case 0xB65:
                    return "GL_FOG_MODE";
                case 0xB66:
                    return "GL_FOG_COLOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FogPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FogPointerTypeIBM:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FragmentLightParameterSGIX:
        {
            switch (value)
            {
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1203:
                    return "GL_POSITION";
                case 0x1204:
                    return "GL_SPOT_DIRECTION";
                case 0x1205:
                    return "GL_SPOT_EXPONENT";
                case 0x1206:
                    return "GL_SPOT_CUTOFF";
                case 0x1207:
                    return "GL_CONSTANT_ATTENUATION";
                case 0x1208:
                    return "GL_LINEAR_ATTENUATION";
                case 0x1209:
                    return "GL_QUADRATIC_ATTENUATION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FragmentShaderDestMaskATI:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FragmentShaderDestModMaskATI:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FragmentShaderGenericSourceATI:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x1:
                    return "GL_ONE";
                case 0x8577:
                    return "GL_PRIMARY_COLOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FragmentShaderTextureSourceATI:
        {
            switch (value)
            {
                case 0x84C0:
                    return "GL_TEXTURE0";
                case 0x84C1:
                    return "GL_TEXTURE1";
                case 0x84C2:
                    return "GL_TEXTURE2";
                case 0x84C3:
                    return "GL_TEXTURE3";
                case 0x84C4:
                    return "GL_TEXTURE4";
                case 0x84C5:
                    return "GL_TEXTURE5";
                case 0x84C6:
                    return "GL_TEXTURE6";
                case 0x84C7:
                    return "GL_TEXTURE7";
                case 0x84C8:
                    return "GL_TEXTURE8";
                case 0x84C9:
                    return "GL_TEXTURE9";
                case 0x84CA:
                    return "GL_TEXTURE10";
                case 0x84CB:
                    return "GL_TEXTURE11";
                case 0x84CC:
                    return "GL_TEXTURE12";
                case 0x84CD:
                    return "GL_TEXTURE13";
                case 0x84CE:
                    return "GL_TEXTURE14";
                case 0x84CF:
                    return "GL_TEXTURE15";
                case 0x84D0:
                    return "GL_TEXTURE16";
                case 0x84D1:
                    return "GL_TEXTURE17";
                case 0x84D2:
                    return "GL_TEXTURE18";
                case 0x84D3:
                    return "GL_TEXTURE19";
                case 0x84D4:
                    return "GL_TEXTURE20";
                case 0x84D5:
                    return "GL_TEXTURE21";
                case 0x84D6:
                    return "GL_TEXTURE22";
                case 0x84D7:
                    return "GL_TEXTURE23";
                case 0x84D8:
                    return "GL_TEXTURE24";
                case 0x84D9:
                    return "GL_TEXTURE25";
                case 0x84DA:
                    return "GL_TEXTURE26";
                case 0x84DB:
                    return "GL_TEXTURE27";
                case 0x84DC:
                    return "GL_TEXTURE28";
                case 0x84DD:
                    return "GL_TEXTURE29";
                case 0x84DE:
                    return "GL_TEXTURE30";
                case 0x84DF:
                    return "GL_TEXTURE31";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FragmentShaderValueRepATI:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FramebufferAttachment:
        {
            switch (value)
            {
                case 0x821A:
                    return "GL_DEPTH_STENCIL_ATTACHMENT";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                case 0x8D00:
                    return "GL_DEPTH_ATTACHMENT";
                case 0x8D20:
                    return "GL_STENCIL_ATTACHMENT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FramebufferAttachmentParameterName:
        {
            switch (value)
            {
                case 0x8210:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING";
                case 0x8211:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE";
                case 0x8212:
                    return "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE";
                case 0x8213:
                    return "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE";
                case 0x8214:
                    return "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE";
                case 0x8215:
                    return "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE";
                case 0x8216:
                    return "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE";
                case 0x8217:
                    return "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE";
                case 0x8CD0:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE";
                case 0x8CD1:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME";
                case 0x8CD2:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL";
                case 0x8CD3:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE";
                case 0x8CD4:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER";
                case 0x8D6C:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT";
                case 0x8DA7:
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED";
                case 0x9630:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR";
                case 0x9632:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FramebufferParameterName:
        {
            switch (value)
            {
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FramebufferStatus:
        {
            switch (value)
            {
                case 0x8219:
                    return "GL_FRAMEBUFFER_UNDEFINED";
                case 0x8CD5:
                    return "GL_FRAMEBUFFER_COMPLETE";
                case 0x8CD6:
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                case 0x8CD7:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                case 0x8CDD:
                    return "GL_FRAMEBUFFER_UNSUPPORTED";
                case 0x8D56:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
                case 0x8DA8:
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FramebufferTarget:
        {
            switch (value)
            {
                case 0x8CA8:
                    return "GL_READ_FRAMEBUFFER";
                case 0x8CA9:
                    return "GL_DRAW_FRAMEBUFFER";
                case 0x8D40:
                    return "GL_FRAMEBUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::FrontFaceDirection:
        {
            switch (value)
            {
                case 0x900:
                    return "GL_CW";
                case 0x901:
                    return "GL_CCW";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::GetFramebufferParameter:
        {
            switch (value)
            {
                case 0x80A8:
                    return "GL_SAMPLE_BUFFERS";
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x8B9A:
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
                case 0x8B9B:
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::GetMultisamplePNameNV:
        {
            switch (value)
            {
                case 0x8E50:
                    return "GL_SAMPLE_POSITION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::GetPName:
        {
            switch (value)
            {
                case 0xB00:
                    return "GL_CURRENT_COLOR";
                case 0xB02:
                    return "GL_CURRENT_NORMAL";
                case 0xB03:
                    return "GL_CURRENT_TEXTURE_COORDS";
                case 0xB10:
                    return "GL_POINT_SMOOTH";
                case 0xB11:
                    return "GL_POINT_SIZE";
                case 0xB12:
                    return "GL_SMOOTH_POINT_SIZE_RANGE";
                case 0xB20:
                    return "GL_LINE_SMOOTH";
                case 0xB21:
                    return "GL_LINE_WIDTH";
                case 0xB22:
                    return "GL_SMOOTH_LINE_WIDTH_RANGE";
                case 0xB44:
                    return "GL_CULL_FACE";
                case 0xB45:
                    return "GL_CULL_FACE_MODE";
                case 0xB46:
                    return "GL_FRONT_FACE";
                case 0xB50:
                    return "GL_LIGHTING";
                case 0xB52:
                    return "GL_LIGHT_MODEL_TWO_SIDE";
                case 0xB53:
                    return "GL_LIGHT_MODEL_AMBIENT";
                case 0xB54:
                    return "GL_SHADE_MODEL";
                case 0xB57:
                    return "GL_COLOR_MATERIAL";
                case 0xB60:
                    return "GL_FOG";
                case 0xB62:
                    return "GL_FOG_DENSITY";
                case 0xB63:
                    return "GL_FOG_START";
                case 0xB64:
                    return "GL_FOG_END";
                case 0xB65:
                    return "GL_FOG_MODE";
                case 0xB66:
                    return "GL_FOG_COLOR";
                case 0xB70:
                    return "GL_DEPTH_RANGE";
                case 0xB71:
                    return "GL_DEPTH_TEST";
                case 0xB72:
                    return "GL_DEPTH_WRITEMASK";
                case 0xB73:
                    return "GL_DEPTH_CLEAR_VALUE";
                case 0xB74:
                    return "GL_DEPTH_FUNC";
                case 0xB90:
                    return "GL_STENCIL_TEST";
                case 0xB91:
                    return "GL_STENCIL_CLEAR_VALUE";
                case 0xB92:
                    return "GL_STENCIL_FUNC";
                case 0xB93:
                    return "GL_STENCIL_VALUE_MASK";
                case 0xB94:
                    return "GL_STENCIL_FAIL";
                case 0xB95:
                    return "GL_STENCIL_PASS_DEPTH_FAIL";
                case 0xB96:
                    return "GL_STENCIL_PASS_DEPTH_PASS";
                case 0xB97:
                    return "GL_STENCIL_REF";
                case 0xB98:
                    return "GL_STENCIL_WRITEMASK";
                case 0xBA0:
                    return "GL_MATRIX_MODE";
                case 0xBA1:
                    return "GL_NORMALIZE";
                case 0xBA2:
                    return "GL_VIEWPORT";
                case 0xBA3:
                    return "GL_MODELVIEW_STACK_DEPTH";
                case 0xBA4:
                    return "GL_PROJECTION_STACK_DEPTH";
                case 0xBA5:
                    return "GL_TEXTURE_STACK_DEPTH";
                case 0xBA6:
                    return "GL_MODELVIEW_MATRIX";
                case 0xBA7:
                    return "GL_PROJECTION_MATRIX";
                case 0xBA8:
                    return "GL_TEXTURE_MATRIX";
                case 0xBC0:
                    return "GL_ALPHA_TEST";
                case 0xBC1:
                    return "GL_ALPHA_TEST_FUNC";
                case 0xBC2:
                    return "GL_ALPHA_TEST_REF";
                case 0xBD0:
                    return "GL_DITHER";
                case 0xBE0:
                    return "GL_BLEND_DST";
                case 0xBE1:
                    return "GL_BLEND_SRC";
                case 0xBE2:
                    return "GL_BLEND";
                case 0xBF0:
                    return "GL_LOGIC_OP_MODE";
                case 0xBF2:
                    return "GL_COLOR_LOGIC_OP";
                case 0xC02:
                    return "GL_READ_BUFFER";
                case 0xC10:
                    return "GL_SCISSOR_BOX";
                case 0xC11:
                    return "GL_SCISSOR_TEST";
                case 0xC22:
                    return "GL_COLOR_CLEAR_VALUE";
                case 0xC23:
                    return "GL_COLOR_WRITEMASK";
                case 0xC50:
                    return "GL_PERSPECTIVE_CORRECTION_HINT";
                case 0xC51:
                    return "GL_POINT_SMOOTH_HINT";
                case 0xC52:
                    return "GL_LINE_SMOOTH_HINT";
                case 0xC54:
                    return "GL_FOG_HINT";
                case 0xCF2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xCF3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xCF4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xCF5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xD02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xD03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xD04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xD05:
                    return "GL_PACK_ALIGNMENT";
                case 0xD1C:
                    return "GL_ALPHA_SCALE";
                case 0xD31:
                    return "GL_MAX_LIGHTS";
                case 0xD32:
                    return "GL_MAX_CLIP_PLANES";
                case 0xD33:
                    return "GL_MAX_TEXTURE_SIZE";
                case 0xD36:
                    return "GL_MAX_MODELVIEW_STACK_DEPTH";
                case 0xD38:
                    return "GL_MAX_PROJECTION_STACK_DEPTH";
                case 0xD39:
                    return "GL_MAX_TEXTURE_STACK_DEPTH";
                case 0xD3A:
                    return "GL_MAX_VIEWPORT_DIMS";
                case 0xD50:
                    return "GL_SUBPIXEL_BITS";
                case 0xD52:
                    return "GL_RED_BITS";
                case 0xD53:
                    return "GL_GREEN_BITS";
                case 0xD54:
                    return "GL_BLUE_BITS";
                case 0xD55:
                    return "GL_ALPHA_BITS";
                case 0xD56:
                    return "GL_DEPTH_BITS";
                case 0xD57:
                    return "GL_STENCIL_BITS";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x2A00:
                    return "GL_POLYGON_OFFSET_UNITS";
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                case 0x8005:
                    return "GL_BLEND_COLOR";
                case 0x8009:
                    return "GL_BLEND_EQUATION";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8038:
                    return "GL_POLYGON_OFFSET_FACTOR";
                case 0x8069:
                    return "GL_TEXTURE_BINDING_2D";
                case 0x806A:
                    return "GL_TEXTURE_BINDING_3D";
                case 0x806D:
                    return "GL_UNPACK_SKIP_IMAGES";
                case 0x806E:
                    return "GL_UNPACK_IMAGE_HEIGHT";
                case 0x8073:
                    return "GL_MAX_3D_TEXTURE_SIZE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x8075:
                    return "GL_NORMAL_ARRAY";
                case 0x8076:
                    return "GL_COLOR_ARRAY";
                case 0x8078:
                    return "GL_TEXTURE_COORD_ARRAY";
                case 0x807A:
                    return "GL_VERTEX_ARRAY_SIZE";
                case 0x807B:
                    return "GL_VERTEX_ARRAY_TYPE";
                case 0x807C:
                    return "GL_VERTEX_ARRAY_STRIDE";
                case 0x807E:
                    return "GL_NORMAL_ARRAY_TYPE";
                case 0x807F:
                    return "GL_NORMAL_ARRAY_STRIDE";
                case 0x8081:
                    return "GL_COLOR_ARRAY_SIZE";
                case 0x8082:
                    return "GL_COLOR_ARRAY_TYPE";
                case 0x8083:
                    return "GL_COLOR_ARRAY_STRIDE";
                case 0x8088:
                    return "GL_TEXTURE_COORD_ARRAY_SIZE";
                case 0x8089:
                    return "GL_TEXTURE_COORD_ARRAY_TYPE";
                case 0x808A:
                    return "GL_TEXTURE_COORD_ARRAY_STRIDE";
                case 0x80A8:
                    return "GL_SAMPLE_BUFFERS";
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x80AA:
                    return "GL_SAMPLE_COVERAGE_VALUE";
                case 0x80AB:
                    return "GL_SAMPLE_COVERAGE_INVERT";
                case 0x80C8:
                    return "GL_BLEND_DST_RGB";
                case 0x80C9:
                    return "GL_BLEND_SRC_RGB";
                case 0x80CA:
                    return "GL_BLEND_DST_ALPHA";
                case 0x80CB:
                    return "GL_BLEND_SRC_ALPHA";
                case 0x80E8:
                    return "GL_MAX_ELEMENTS_VERTICES";
                case 0x80E9:
                    return "GL_MAX_ELEMENTS_INDICES";
                case 0x8126:
                    return "GL_POINT_SIZE_MIN";
                case 0x8127:
                    return "GL_POINT_SIZE_MAX";
                case 0x8128:
                    return "GL_POINT_FADE_THRESHOLD_SIZE";
                case 0x8129:
                    return "GL_POINT_DISTANCE_ATTENUATION";
                case 0x821B:
                    return "GL_MAJOR_VERSION";
                case 0x821C:
                    return "GL_MINOR_VERSION";
                case 0x821D:
                    return "GL_NUM_EXTENSIONS";
                case 0x821E:
                    return "GL_CONTEXT_FLAGS";
                case 0x825A:
                    return "GL_PROGRAM_PIPELINE_BINDING";
                case 0x825E:
                    return "GL_LAYER_PROVOKING_VERTEX";
                case 0x8263:
                    return "GL_MAX_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8264:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS";
                case 0x8265:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTERS";
                case 0x8266:
                    return "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS";
                case 0x826C:
                    return "GL_MAX_DEBUG_GROUP_STACK_DEPTH";
                case 0x826D:
                    return "GL_DEBUG_GROUP_STACK_DEPTH";
                case 0x826E:
                    return "GL_MAX_UNIFORM_LOCATIONS";
                case 0x82D6:
                    return "GL_VERTEX_BINDING_DIVISOR";
                case 0x82D7:
                    return "GL_VERTEX_BINDING_OFFSET";
                case 0x82D8:
                    return "GL_VERTEX_BINDING_STRIDE";
                case 0x82D9:
                    return "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x82DA:
                    return "GL_MAX_VERTEX_ATTRIB_BINDINGS";
                case 0x82E8:
                    return "GL_MAX_LABEL_LENGTH";
                case 0x82F9:
                    return "GL_MAX_CULL_DISTANCES_ANGLE";
                case 0x82FA:
                    return "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_ANGLE";
                case 0x846D:
                    return "GL_ALIASED_POINT_SIZE_RANGE";
                case 0x846E:
                    return "GL_ALIASED_LINE_WIDTH_RANGE";
                case 0x84E0:
                    return "GL_ACTIVE_TEXTURE";
                case 0x84E8:
                    return "GL_MAX_RENDERBUFFER_SIZE";
                case 0x84FD:
                    return "GL_MAX_TEXTURE_LOD_BIAS";
                case 0x8514:
                    return "GL_TEXTURE_BINDING_CUBE_MAP";
                case 0x851C:
                    return "GL_MAX_CUBE_MAP_TEXTURE_SIZE";
                case 0x85B5:
                    return "GL_VERTEX_ARRAY_BINDING";
                case 0x86A2:
                    return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
                case 0x86A3:
                    return "GL_COMPRESSED_TEXTURE_FORMATS";
                case 0x87FE:
                    return "GL_NUM_PROGRAM_BINARY_FORMATS";
                case 0x87FF:
                    return "GL_PROGRAM_BINARY_FORMATS";
                case 0x8800:
                    return "GL_STENCIL_BACK_FUNC";
                case 0x8801:
                    return "GL_STENCIL_BACK_FAIL";
                case 0x8802:
                    return "GL_STENCIL_BACK_PASS_DEPTH_FAIL";
                case 0x8803:
                    return "GL_STENCIL_BACK_PASS_DEPTH_PASS";
                case 0x8824:
                    return "GL_MAX_DRAW_BUFFERS";
                case 0x883D:
                    return "GL_BLEND_EQUATION_ALPHA";
                case 0x8869:
                    return "GL_MAX_VERTEX_ATTRIBS";
                case 0x8872:
                    return "GL_MAX_TEXTURE_IMAGE_UNITS";
                case 0x8894:
                    return "GL_ARRAY_BUFFER_BINDING";
                case 0x8895:
                    return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
                case 0x88ED:
                    return "GL_PIXEL_PACK_BUFFER_BINDING";
                case 0x88EF:
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING";
                case 0x88FF:
                    return "GL_MAX_ARRAY_TEXTURE_LAYERS";
                case 0x8904:
                    return "GL_MIN_PROGRAM_TEXEL_OFFSET";
                case 0x8905:
                    return "GL_MAX_PROGRAM_TEXEL_OFFSET";
                case 0x8919:
                    return "GL_SAMPLER_BINDING";
                case 0x8A28:
                    return "GL_UNIFORM_BUFFER_BINDING";
                case 0x8A29:
                    return "GL_UNIFORM_BUFFER_START";
                case 0x8A2A:
                    return "GL_UNIFORM_BUFFER_SIZE";
                case 0x8A2B:
                    return "GL_MAX_VERTEX_UNIFORM_BLOCKS";
                case 0x8A2C:
                    return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS";
                case 0x8A2D:
                    return "GL_MAX_FRAGMENT_UNIFORM_BLOCKS";
                case 0x8A2E:
                    return "GL_MAX_COMBINED_UNIFORM_BLOCKS";
                case 0x8A2F:
                    return "GL_MAX_UNIFORM_BUFFER_BINDINGS";
                case 0x8A30:
                    return "GL_MAX_UNIFORM_BLOCK_SIZE";
                case 0x8A31:
                    return "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS";
                case 0x8A32:
                    return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8A33:
                    return "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8A34:
                    return "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT";
                case 0x8B49:
                    return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8B4A:
                    return "GL_MAX_VERTEX_UNIFORM_COMPONENTS";
                case 0x8B4B:
                    return "GL_MAX_VARYING_COMPONENTS";
                case 0x8B4C:
                    return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS";
                case 0x8B4D:
                    return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS";
                case 0x8B8B:
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
                case 0x8B8D:
                    return "GL_CURRENT_PROGRAM";
                case 0x8B9A:
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
                case 0x8B9B:
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
                case 0x8C1D:
                    return "GL_TEXTURE_BINDING_2D_ARRAY";
                case 0x8C29:
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS";
                case 0x8C2B:
                    return "GL_MAX_TEXTURE_BUFFER_SIZE";
                case 0x8C2C:
                    return "GL_TEXTURE_BINDING_BUFFER";
                case 0x8C84:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
                case 0x8C85:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
                case 0x8C8F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
                case 0x8CA3:
                    return "GL_STENCIL_BACK_REF";
                case 0x8CA4:
                    return "GL_STENCIL_BACK_VALUE_MASK";
                case 0x8CA5:
                    return "GL_STENCIL_BACK_WRITEMASK";
                case 0x8CA6:
                    return "GL_DRAW_FRAMEBUFFER_BINDING";
                case 0x8CA7:
                    return "GL_RENDERBUFFER_BINDING";
                case 0x8CAA:
                    return "GL_READ_FRAMEBUFFER_BINDING";
                case 0x8CDF:
                    return "GL_MAX_COLOR_ATTACHMENTS";
                case 0x8D60:
                    return "GL_TEXTURE_GEN_STR_OES";
                case 0x8D6B:
                    return "GL_MAX_ELEMENT_INDEX";
                case 0x8DDF:
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8DF8:
                    return "GL_SHADER_BINARY_FORMATS";
                case 0x8DF9:
                    return "GL_NUM_SHADER_BINARY_FORMATS";
                case 0x8DFA:
                    return "GL_SHADER_COMPILER";
                case 0x8DFB:
                    return "GL_MAX_VERTEX_UNIFORM_VECTORS";
                case 0x8DFC:
                    return "GL_MAX_VARYING_VECTORS";
                case 0x8DFD:
                    return "GL_MAX_FRAGMENT_UNIFORM_VECTORS";
                case 0x8E28:
                    return "GL_TIMESTAMP_EXT";
                case 0x8E4F:
                    return "GL_PROVOKING_VERTEX_ANGLE";
                case 0x8E59:
                    return "GL_MAX_SAMPLE_MASK_WORDS";
                case 0x8E89:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS";
                case 0x8E8A:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS";
                case 0x8F65:
                    return "GL_FETCH_PER_SAMPLE_ARM";
                case 0x8F66:
                    return "GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM";
                case 0x90D3:
                    return "GL_SHADER_STORAGE_BUFFER_BINDING";
                case 0x90D4:
                    return "GL_SHADER_STORAGE_BUFFER_START";
                case 0x90D5:
                    return "GL_SHADER_STORAGE_BUFFER_SIZE";
                case 0x90D6:
                    return "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS";
                case 0x90D7:
                    return "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS";
                case 0x90D8:
                    return "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS";
                case 0x90D9:
                    return "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS";
                case 0x90DA:
                    return "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS";
                case 0x90DB:
                    return "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS";
                case 0x90DC:
                    return "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS";
                case 0x90DD:
                    return "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS";
                case 0x90DF:
                    return "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT";
                case 0x90EB:
                    return "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS";
                case 0x90EF:
                    return "GL_DISPATCH_INDIRECT_BUFFER_BINDING";
                case 0x9104:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE";
                case 0x9105:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY";
                case 0x910E:
                    return "GL_MAX_COLOR_TEXTURE_SAMPLES";
                case 0x910F:
                    return "GL_MAX_DEPTH_TEXTURE_SAMPLES";
                case 0x9110:
                    return "GL_MAX_INTEGER_SAMPLES";
                case 0x9111:
                    return "GL_MAX_SERVER_WAIT_TIMEOUT";
                case 0x9122:
                    return "GL_MAX_VERTEX_OUTPUT_COMPONENTS";
                case 0x9123:
                    return "GL_MAX_GEOMETRY_INPUT_COMPONENTS";
                case 0x9124:
                    return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS";
                case 0x9125:
                    return "GL_MAX_FRAGMENT_INPUT_COMPONENTS";
                case 0x919F:
                    return "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT";
                case 0x91BB:
                    return "GL_MAX_COMPUTE_UNIFORM_BLOCKS";
                case 0x91BC:
                    return "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS";
                case 0x91BE:
                    return "GL_MAX_COMPUTE_WORK_GROUP_COUNT";
                case 0x91BF:
                    return "GL_MAX_COMPUTE_WORK_GROUP_SIZE";
                case 0x92D2:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTERS";
                case 0x92D3:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS";
                case 0x92D4:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS";
                case 0x92D5:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTERS";
                case 0x92D6:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTERS";
                case 0x92D7:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTERS";
                case 0x9315:
                    return "GL_MAX_FRAMEBUFFER_WIDTH";
                case 0x9316:
                    return "GL_MAX_FRAMEBUFFER_HEIGHT";
                case 0x9317:
                    return "GL_MAX_FRAMEBUFFER_LAYERS";
                case 0x9318:
                    return "GL_MAX_FRAMEBUFFER_SAMPLES";
                case 0x9596:
                    return "GL_NUM_DEVICE_UUIDS_EXT";
                case 0x9597:
                    return "GL_DEVICE_UUID_EXT";
                case 0x9598:
                    return "GL_DRIVER_UUID_EXT";
                case 0x96A4:
                    return "GL_SHADING_RATE_QCOM";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::GetPointervPName:
        {
            switch (value)
            {
                case 0x808E:
                    return "GL_VERTEX_ARRAY_POINTER";
                case 0x808F:
                    return "GL_NORMAL_ARRAY_POINTER";
                case 0x8090:
                    return "GL_COLOR_ARRAY_POINTER";
                case 0x8092:
                    return "GL_TEXTURE_COORD_ARRAY_POINTER";
                case 0x8244:
                    return "GL_DEBUG_CALLBACK_FUNCTION";
                case 0x8245:
                    return "GL_DEBUG_CALLBACK_USER_PARAM";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::GetTextureParameter:
        {
            switch (value)
            {
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_INTERNAL_FORMAT";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x805C:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805D:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805E:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805F:
                    return "GL_TEXTURE_ALPHA_SIZE";
                case 0x8511:
                    return "GL_NORMAL_MAP_OES";
                case 0x8512:
                    return "GL_REFLECTION_MAP_OES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::GraphicsResetStatus:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NO_ERROR";
                case 0x8253:
                    return "GL_GUILTY_CONTEXT_RESET";
                case 0x8254:
                    return "GL_INNOCENT_CONTEXT_RESET";
                case 0x8255:
                    return "GL_UNKNOWN_CONTEXT_RESET";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::HintMode:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x1101:
                    return "GL_FASTEST";
                case 0x1102:
                    return "GL_NICEST";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::HintTarget:
        {
            switch (value)
            {
                case 0xC50:
                    return "GL_PERSPECTIVE_CORRECTION_HINT";
                case 0xC51:
                    return "GL_POINT_SMOOTH_HINT";
                case 0xC52:
                    return "GL_LINE_SMOOTH_HINT";
                case 0xC54:
                    return "GL_FOG_HINT";
                case 0x8192:
                    return "GL_GENERATE_MIPMAP_HINT";
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x8B8B:
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::IndexFunctionEXT:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::IndexPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::InternalFormat:
        {
            switch (value)
            {
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x803C:
                    return "GL_ALPHA8_EXT";
                case 0x8040:
                    return "GL_LUMINANCE8_EXT";
                case 0x8045:
                    return "GL_LUMINANCE8_ALPHA8_EXT";
                case 0x8051:
                    return "GL_RGB8";
                case 0x8052:
                    return "GL_RGB10_EXT";
                case 0x8054:
                    return "GL_RGB16_EXT";
                case 0x8056:
                    return "GL_RGBA4";
                case 0x8057:
                    return "GL_RGB5_A1";
                case 0x8058:
                    return "GL_RGBA8";
                case 0x8059:
                    return "GL_RGB10_A2";
                case 0x805B:
                    return "GL_RGBA16_EXT";
                case 0x81A5:
                    return "GL_DEPTH_COMPONENT16";
                case 0x81A6:
                    return "GL_DEPTH_COMPONENT24";
                case 0x81A7:
                    return "GL_DEPTH_COMPONENT32_OES";
                case 0x8227:
                    return "GL_RG";
                case 0x8229:
                    return "GL_R8";
                case 0x822A:
                    return "GL_R16_EXT";
                case 0x822B:
                    return "GL_RG8";
                case 0x822C:
                    return "GL_RG16_EXT";
                case 0x822D:
                    return "GL_R16F";
                case 0x822E:
                    return "GL_R32F";
                case 0x822F:
                    return "GL_RG16F";
                case 0x8230:
                    return "GL_RG32F";
                case 0x8231:
                    return "GL_R8I";
                case 0x8232:
                    return "GL_R8UI";
                case 0x8233:
                    return "GL_R16I";
                case 0x8234:
                    return "GL_R16UI";
                case 0x8235:
                    return "GL_R32I";
                case 0x8236:
                    return "GL_R32UI";
                case 0x8237:
                    return "GL_RG8I";
                case 0x8238:
                    return "GL_RG8UI";
                case 0x8239:
                    return "GL_RG16I";
                case 0x823A:
                    return "GL_RG16UI";
                case 0x823B:
                    return "GL_RG32I";
                case 0x823C:
                    return "GL_RG32UI";
                case 0x83F0:
                    return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
                case 0x83F1:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
                case 0x83F2:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
                case 0x83F3:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
                case 0x84F9:
                    return "GL_DEPTH_STENCIL";
                case 0x8814:
                    return "GL_RGBA32F";
                case 0x8815:
                    return "GL_RGB32F";
                case 0x881A:
                    return "GL_RGBA16F";
                case 0x881B:
                    return "GL_RGB16F";
                case 0x88F0:
                    return "GL_DEPTH24_STENCIL8";
                case 0x8C3A:
                    return "GL_R11F_G11F_B10F";
                case 0x8C3D:
                    return "GL_RGB9_E5";
                case 0x8C40:
                    return "GL_SRGB";
                case 0x8C41:
                    return "GL_SRGB8";
                case 0x8C42:
                    return "GL_SRGB_ALPHA_EXT";
                case 0x8C43:
                    return "GL_SRGB8_ALPHA8";
                case 0x8C4C:
                    return "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT";
                case 0x8C4D:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT";
                case 0x8C4E:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT";
                case 0x8C4F:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT";
                case 0x8CAC:
                    return "GL_DEPTH_COMPONENT32F";
                case 0x8CAD:
                    return "GL_DEPTH32F_STENCIL8";
                case 0x8D48:
                    return "GL_STENCIL_INDEX8";
                case 0x8D62:
                    return "GL_RGB565";
                case 0x8D64:
                    return "GL_ETC1_RGB8_OES";
                case 0x8D70:
                    return "GL_RGBA32UI";
                case 0x8D71:
                    return "GL_RGB32UI";
                case 0x8D76:
                    return "GL_RGBA16UI";
                case 0x8D77:
                    return "GL_RGB16UI";
                case 0x8D7C:
                    return "GL_RGBA8UI";
                case 0x8D7D:
                    return "GL_RGB8UI";
                case 0x8D82:
                    return "GL_RGBA32I";
                case 0x8D83:
                    return "GL_RGB32I";
                case 0x8D88:
                    return "GL_RGBA16I";
                case 0x8D89:
                    return "GL_RGB16I";
                case 0x8D8E:
                    return "GL_RGBA8I";
                case 0x8D8F:
                    return "GL_RGB8I";
                case 0x8DBB:
                    return "GL_COMPRESSED_RED_RGTC1_EXT";
                case 0x8DBC:
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1_EXT";
                case 0x8DBD:
                    return "GL_COMPRESSED_RED_GREEN_RGTC2_EXT";
                case 0x8DBE:
                    return "GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT";
                case 0x8E8C:
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM_EXT";
                case 0x8E8D:
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT";
                case 0x8E8E:
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT";
                case 0x8E8F:
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT";
                case 0x8F94:
                    return "GL_R8_SNORM";
                case 0x8F95:
                    return "GL_RG8_SNORM";
                case 0x8F96:
                    return "GL_RGB8_SNORM";
                case 0x8F97:
                    return "GL_RGBA8_SNORM";
                case 0x8F98:
                    return "GL_R16_SNORM_EXT";
                case 0x8F99:
                    return "GL_RG16_SNORM_EXT";
                case 0x8F9A:
                    return "GL_RGB16_SNORM_EXT";
                case 0x8F9B:
                    return "GL_RGBA16_SNORM_EXT";
                case 0x8FBD:
                    return "GL_SR8_EXT";
                case 0x8FBE:
                    return "GL_SRG8_EXT";
                case 0x906F:
                    return "GL_RGB10_A2UI";
                case 0x9270:
                    return "GL_COMPRESSED_R11_EAC";
                case 0x9271:
                    return "GL_COMPRESSED_SIGNED_R11_EAC";
                case 0x9272:
                    return "GL_COMPRESSED_RG11_EAC";
                case 0x9273:
                    return "GL_COMPRESSED_SIGNED_RG11_EAC";
                case 0x9274:
                    return "GL_COMPRESSED_RGB8_ETC2";
                case 0x9275:
                    return "GL_COMPRESSED_SRGB8_ETC2";
                case 0x9276:
                    return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9277:
                    return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9278:
                    return "GL_COMPRESSED_RGBA8_ETC2_EAC";
                case 0x9279:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
                case 0x93B0:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4";
                case 0x93B1:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4";
                case 0x93B2:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5";
                case 0x93B3:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5";
                case 0x93B4:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6";
                case 0x93B5:
                    return "GL_COMPRESSED_RGBA_ASTC_8x5";
                case 0x93B6:
                    return "GL_COMPRESSED_RGBA_ASTC_8x6";
                case 0x93B7:
                    return "GL_COMPRESSED_RGBA_ASTC_8x8";
                case 0x93B8:
                    return "GL_COMPRESSED_RGBA_ASTC_10x5";
                case 0x93B9:
                    return "GL_COMPRESSED_RGBA_ASTC_10x6";
                case 0x93BA:
                    return "GL_COMPRESSED_RGBA_ASTC_10x8";
                case 0x93BB:
                    return "GL_COMPRESSED_RGBA_ASTC_10x10";
                case 0x93BC:
                    return "GL_COMPRESSED_RGBA_ASTC_12x10";
                case 0x93BD:
                    return "GL_COMPRESSED_RGBA_ASTC_12x12";
                case 0x93C0:
                    return "GL_COMPRESSED_RGBA_ASTC_3x3x3_OES";
                case 0x93C1:
                    return "GL_COMPRESSED_RGBA_ASTC_4x3x3_OES";
                case 0x93C2:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4x3_OES";
                case 0x93C3:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4x4_OES";
                case 0x93C4:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4x4_OES";
                case 0x93C5:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5x4_OES";
                case 0x93C6:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5x5_OES";
                case 0x93C7:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5x5_OES";
                case 0x93C8:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6x5_OES";
                case 0x93C9:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6x6_OES";
                case 0x93D0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4";
                case 0x93D1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4";
                case 0x93D2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5";
                case 0x93D3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5";
                case 0x93D4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6";
                case 0x93D5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5";
                case 0x93D6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6";
                case 0x93D7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8";
                case 0x93D8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5";
                case 0x93D9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6";
                case 0x93DA:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8";
                case 0x93DB:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10";
                case 0x93DC:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10";
                case 0x93DD:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12";
                case 0x93E0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES";
                case 0x93E1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES";
                case 0x93E2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES";
                case 0x93E3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES";
                case 0x93E4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES";
                case 0x93E5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES";
                case 0x93E6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES";
                case 0x93E7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES";
                case 0x93E8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES";
                case 0x93E9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::InternalFormatPName:
        {
            switch (value)
            {
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x8191:
                    return "GL_GENERATE_MIPMAP";
                case 0x86A1:
                    return "GL_TEXTURE_COMPRESSED";
                case 0x90C7:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE";
                case 0x9380:
                    return "GL_NUM_SAMPLE_COUNTS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::InvalidateFramebufferAttachment:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                case 0x821A:
                    return "GL_DEPTH_STENCIL_ATTACHMENT";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                case 0x8D00:
                    return "GL_DEPTH_ATTACHMENT";
                case 0x8D20:
                    return "GL_STENCIL_ATTACHMENT_OES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::LightEnvModeSGIX:
        {
            switch (value)
            {
                case 0x104:
                    return "GL_ADD";
                case 0x1E01:
                    return "GL_REPLACE";
                case 0x2100:
                    return "GL_MODULATE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::LightModelParameter:
        {
            switch (value)
            {
                case 0xB52:
                    return "GL_LIGHT_MODEL_TWO_SIDE";
                case 0xB53:
                    return "GL_LIGHT_MODEL_AMBIENT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::LightName:
        {
            switch (value)
            {
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::LightParameter:
        {
            switch (value)
            {
                case 0x1203:
                    return "GL_POSITION";
                case 0x1204:
                    return "GL_SPOT_DIRECTION";
                case 0x1205:
                    return "GL_SPOT_EXPONENT";
                case 0x1206:
                    return "GL_SPOT_CUTOFF";
                case 0x1207:
                    return "GL_CONSTANT_ATTENUATION";
                case 0x1208:
                    return "GL_LINEAR_ATTENUATION";
                case 0x1209:
                    return "GL_QUADRATIC_ATTENUATION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ListNameType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::LogicOp:
        {
            switch (value)
            {
                case 0x1500:
                    return "GL_CLEAR";
                case 0x1501:
                    return "GL_AND";
                case 0x1502:
                    return "GL_AND_REVERSE";
                case 0x1503:
                    return "GL_COPY";
                case 0x1504:
                    return "GL_AND_INVERTED";
                case 0x1505:
                    return "GL_NOOP";
                case 0x1506:
                    return "GL_XOR";
                case 0x1507:
                    return "GL_OR";
                case 0x1508:
                    return "GL_NOR";
                case 0x1509:
                    return "GL_EQUIV";
                case 0x150A:
                    return "GL_INVERT";
                case 0x150B:
                    return "GL_OR_REVERSE";
                case 0x150C:
                    return "GL_COPY_INVERTED";
                case 0x150D:
                    return "GL_OR_INVERTED";
                case 0x150E:
                    return "GL_NAND";
                case 0x150F:
                    return "GL_SET";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::MapBufferAccessMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_MAP_READ_BIT";
                case 0x2:
                    return "GL_MAP_WRITE_BIT";
                case 0x4:
                    return "GL_MAP_INVALIDATE_RANGE_BIT";
                case 0x8:
                    return "GL_MAP_INVALIDATE_BUFFER_BIT";
                case 0x10:
                    return "GL_MAP_FLUSH_EXPLICIT_BIT";
                case 0x20:
                    return "GL_MAP_UNSYNCHRONIZED_BIT";
                case 0x40:
                    return "GL_MAP_PERSISTENT_BIT_EXT";
                case 0x80:
                    return "GL_MAP_COHERENT_BIT_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::MapTypeNV:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::MaterialParameter:
        {
            switch (value)
            {
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1600:
                    return "GL_EMISSION";
                case 0x1601:
                    return "GL_SHININESS";
                case 0x1602:
                    return "GL_AMBIENT_AND_DIFFUSE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::MatrixIndexPointerTypeARB:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::MatrixMode:
        {
            switch (value)
            {
                case 0x1700:
                    return "GL_MODELVIEW";
                case 0x1701:
                    return "GL_PROJECTION";
                case 0x1702:
                    return "GL_TEXTURE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::MemoryBarrierMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT";
                case 0x2:
                    return "GL_ELEMENT_ARRAY_BARRIER_BIT";
                case 0x4:
                    return "GL_UNIFORM_BARRIER_BIT";
                case 0x8:
                    return "GL_TEXTURE_FETCH_BARRIER_BIT";
                case 0x20:
                    return "GL_SHADER_IMAGE_ACCESS_BARRIER_BIT";
                case 0x40:
                    return "GL_COMMAND_BARRIER_BIT";
                case 0x80:
                    return "GL_PIXEL_BUFFER_BARRIER_BIT";
                case 0x100:
                    return "GL_TEXTURE_UPDATE_BARRIER_BIT";
                case 0x200:
                    return "GL_BUFFER_UPDATE_BARRIER_BIT";
                case 0x400:
                    return "GL_FRAMEBUFFER_BARRIER_BIT";
                case 0x800:
                    return "GL_TRANSFORM_FEEDBACK_BARRIER_BIT";
                case 0x1000:
                    return "GL_ATOMIC_COUNTER_BARRIER_BIT";
                case 0x2000:
                    return "GL_SHADER_STORAGE_BARRIER_BIT";
                case 0x4000:
                    return "GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT";
                case 0xFFFFFFFF:
                    return "GL_ALL_BARRIER_BITS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::MemoryObjectParameterName:
        {
            switch (value)
            {
                case 0x9581:
                    return "GL_DEDICATED_MEMORY_OBJECT_EXT";
                case 0x959B:
                    return "GL_PROTECTED_MEMORY_OBJECT_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::NormalPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ObjectIdentifier:
        {
            switch (value)
            {
                case 0x1702:
                    return "GL_TEXTURE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x82E0:
                    return "GL_BUFFER";
                case 0x82E1:
                    return "GL_SHADER";
                case 0x82E2:
                    return "GL_PROGRAM";
                case 0x82E3:
                    return "GL_QUERY";
                case 0x82E4:
                    return "GL_PROGRAM_PIPELINE";
                case 0x82E6:
                    return "GL_SAMPLER";
                case 0x8D40:
                    return "GL_FRAMEBUFFER";
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                case 0x8E22:
                    return "GL_TRANSFORM_FEEDBACK";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PLSQueryFloat:
        {
            switch (value)
            {
                case 0x96ED:
                    return "GL_PIXEL_LOCAL_CLEAR_VALUE_FLOAT_ANGLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PLSQueryInt:
        {
            switch (value)
            {
                case 0x96E9:
                    return "GL_PIXEL_LOCAL_FORMAT_ANGLE";
                case 0x96EA:
                    return "GL_PIXEL_LOCAL_TEXTURE_NAME_ANGLE";
                case 0x96EB:
                    return "GL_PIXEL_LOCAL_TEXTURE_LEVEL_ANGLE";
                case 0x96EC:
                    return "GL_PIXEL_LOCAL_TEXTURE_LAYER_ANGLE";
                case 0x96EE:
                    return "GL_PIXEL_LOCAL_CLEAR_VALUE_INT_ANGLE";
                case 0x96EF:
                    return "GL_PIXEL_LOCAL_CLEAR_VALUE_UNSIGNED_INT_ANGLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PatchParameterName:
        {
            switch (value)
            {
                case 0x8E72:
                    return "GL_PATCH_VERTICES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PathColor:
        {
            switch (value)
            {
                case 0x8577:
                    return "GL_PRIMARY_COLOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PathColorFormat:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190A:
                    return "GL_LUMINANCE_ALPHA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PathFillMode:
        {
            switch (value)
            {
                case 0x150A:
                    return "GL_INVERT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PathFontStyle:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PathGenMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x8576:
                    return "GL_CONSTANT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PathTransformType:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PipelineParameterName:
        {
            switch (value)
            {
                case 0x8259:
                    return "GL_ACTIVE_PROGRAM";
                case 0x8B30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8B31:
                    return "GL_VERTEX_SHADER";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8DD9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8E87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8E88:
                    return "GL_TESS_CONTROL_SHADER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PixelCopyType:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PixelFormat:
        {
            switch (value)
            {
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190A:
                    return "GL_LUMINANCE_ALPHA";
                case 0x80E1:
                    return "GL_BGRA_EXT";
                case 0x8227:
                    return "GL_RG";
                case 0x8228:
                    return "GL_RG_INTEGER";
                case 0x84F9:
                    return "GL_DEPTH_STENCIL";
                case 0x8D94:
                    return "GL_RED_INTEGER";
                case 0x8D98:
                    return "GL_RGB_INTEGER";
                case 0x8D99:
                    return "GL_RGBA_INTEGER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PixelStoreParameter:
        {
            switch (value)
            {
                case 0xCF2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xCF3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xCF4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xCF5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xD02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xD03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xD04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xD05:
                    return "GL_PACK_ALIGNMENT";
                case 0x806D:
                    return "GL_UNPACK_SKIP_IMAGES";
                case 0x806E:
                    return "GL_UNPACK_IMAGE_HEIGHT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PixelTexGenModeSGIX:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PixelTransferParameter:
        {
            switch (value)
            {
                case 0xD1C:
                    return "GL_ALPHA_SCALE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PixelType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x8033:
                    return "GL_UNSIGNED_SHORT_4_4_4_4";
                case 0x8034:
                    return "GL_UNSIGNED_SHORT_5_5_5_1";
                case 0x8363:
                    return "GL_UNSIGNED_SHORT_5_6_5";
                case 0x8365:
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT";
                case 0x8366:
                    return "GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x84FA:
                    return "GL_UNSIGNED_INT_24_8";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8C3E:
                    return "GL_UNSIGNED_INT_5_9_9_9_REV";
                case 0x8DAD:
                    return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PointParameterNameARB:
        {
            switch (value)
            {
                case 0x8126:
                    return "GL_POINT_SIZE_MIN";
                case 0x8127:
                    return "GL_POINT_SIZE_MAX";
                case 0x8128:
                    return "GL_POINT_FADE_THRESHOLD_SIZE";
                case 0x8129:
                    return "GL_POINT_DISTANCE_ATTENUATION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PrecisionType:
        {
            switch (value)
            {
                case 0x8DF0:
                    return "GL_LOW_FLOAT";
                case 0x8DF1:
                    return "GL_MEDIUM_FLOAT";
                case 0x8DF2:
                    return "GL_HIGH_FLOAT";
                case 0x8DF3:
                    return "GL_LOW_INT";
                case 0x8DF4:
                    return "GL_MEDIUM_INT";
                case 0x8DF5:
                    return "GL_HIGH_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::PrimitiveType:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_POINTS";
                case 0x1:
                    return "GL_LINES";
                case 0x2:
                    return "GL_LINE_LOOP";
                case 0x3:
                    return "GL_LINE_STRIP";
                case 0x4:
                    return "GL_TRIANGLES";
                case 0x5:
                    return "GL_TRIANGLE_STRIP";
                case 0x6:
                    return "GL_TRIANGLE_FAN";
                case 0x7:
                    return "GL_QUADS";
                case 0xA:
                    return "GL_LINES_ADJACENCY";
                case 0xB:
                    return "GL_LINE_STRIP_ADJACENCY";
                case 0xC:
                    return "GL_TRIANGLES_ADJACENCY";
                case 0xD:
                    return "GL_TRIANGLE_STRIP_ADJACENCY";
                case 0xE:
                    return "GL_PATCHES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ProgramInterface:
        {
            switch (value)
            {
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x92E1:
                    return "GL_UNIFORM";
                case 0x92E2:
                    return "GL_UNIFORM_BLOCK";
                case 0x92E3:
                    return "GL_PROGRAM_INPUT";
                case 0x92E4:
                    return "GL_PROGRAM_OUTPUT";
                case 0x92E5:
                    return "GL_BUFFER_VARIABLE";
                case 0x92E6:
                    return "GL_SHADER_STORAGE_BLOCK";
                case 0x92F4:
                    return "GL_TRANSFORM_FEEDBACK_VARYING";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ProgramInterfacePName:
        {
            switch (value)
            {
                case 0x92F5:
                    return "GL_ACTIVE_RESOURCES";
                case 0x92F6:
                    return "GL_MAX_NAME_LENGTH";
                case 0x92F7:
                    return "GL_MAX_NUM_ACTIVE_VARIABLES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ProgramParameterPName:
        {
            switch (value)
            {
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x8258:
                    return "GL_PROGRAM_SEPARABLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ProgramPropertyARB:
        {
            switch (value)
            {
                case 0x8267:
                    return "GL_COMPUTE_WORK_GROUP_SIZE";
                case 0x8741:
                    return "GL_PROGRAM_BINARY_LENGTH";
                case 0x8916:
                    return "GL_GEOMETRY_VERTICES_OUT";
                case 0x8917:
                    return "GL_GEOMETRY_INPUT_TYPE";
                case 0x8918:
                    return "GL_GEOMETRY_OUTPUT_TYPE";
                case 0x8A35:
                    return "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH";
                case 0x8A36:
                    return "GL_ACTIVE_UNIFORM_BLOCKS";
                case 0x8B80:
                    return "GL_DELETE_STATUS";
                case 0x8B82:
                    return "GL_LINK_STATUS";
                case 0x8B83:
                    return "GL_VALIDATE_STATUS";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8B85:
                    return "GL_ATTACHED_SHADERS";
                case 0x8B86:
                    return "GL_ACTIVE_UNIFORMS";
                case 0x8B87:
                    return "GL_ACTIVE_UNIFORM_MAX_LENGTH";
                case 0x8B89:
                    return "GL_ACTIVE_ATTRIBUTES";
                case 0x8B8A:
                    return "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH";
                case 0x8C76:
                    return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH";
                case 0x8C7F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE";
                case 0x8C83:
                    return "GL_TRANSFORM_FEEDBACK_VARYINGS";
                case 0x92D9:
                    return "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ProgramResourceProperty:
        {
            switch (value)
            {
                case 0x92E1:
                    return "GL_UNIFORM";
                case 0x92E7:
                    return "GL_IS_PER_PATCH";
                case 0x92F9:
                    return "GL_NAME_LENGTH";
                case 0x92FA:
                    return "GL_TYPE";
                case 0x92FB:
                    return "GL_ARRAY_SIZE";
                case 0x92FC:
                    return "GL_OFFSET";
                case 0x92FD:
                    return "GL_BLOCK_INDEX";
                case 0x92FE:
                    return "GL_ARRAY_STRIDE";
                case 0x92FF:
                    return "GL_MATRIX_STRIDE";
                case 0x9300:
                    return "GL_IS_ROW_MAJOR";
                case 0x9301:
                    return "GL_ATOMIC_COUNTER_BUFFER_INDEX";
                case 0x9302:
                    return "GL_BUFFER_BINDING";
                case 0x9303:
                    return "GL_BUFFER_DATA_SIZE";
                case 0x9304:
                    return "GL_NUM_ACTIVE_VARIABLES";
                case 0x9305:
                    return "GL_ACTIVE_VARIABLES";
                case 0x9306:
                    return "GL_REFERENCED_BY_VERTEX_SHADER";
                case 0x9307:
                    return "GL_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x9308:
                    return "GL_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x9309:
                    return "GL_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x930A:
                    return "GL_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x930B:
                    return "GL_REFERENCED_BY_COMPUTE_SHADER";
                case 0x930C:
                    return "GL_TOP_LEVEL_ARRAY_SIZE";
                case 0x930D:
                    return "GL_TOP_LEVEL_ARRAY_STRIDE";
                case 0x930E:
                    return "GL_LOCATION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::QueryCounterTarget:
        {
            switch (value)
            {
                case 0x8E28:
                    return "GL_TIMESTAMP_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::QueryObjectParameterName:
        {
            switch (value)
            {
                case 0x8866:
                    return "GL_QUERY_RESULT";
                case 0x8867:
                    return "GL_QUERY_RESULT_AVAILABLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::QueryParameterName:
        {
            switch (value)
            {
                case 0x8865:
                    return "GL_CURRENT_QUERY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::QueryTarget:
        {
            switch (value)
            {
                case 0x8C2F:
                    return "GL_ANY_SAMPLES_PASSED";
                case 0x8C87:
                    return "GL_PRIMITIVES_GENERATED";
                case 0x8C88:
                    return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN";
                case 0x8D6A:
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ReadBufferMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::RenderbufferParameterName:
        {
            switch (value)
            {
                case 0x8CAB:
                    return "GL_RENDERBUFFER_SAMPLES";
                case 0x8D42:
                    return "GL_RENDERBUFFER_WIDTH";
                case 0x8D43:
                    return "GL_RENDERBUFFER_HEIGHT";
                case 0x8D44:
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT";
                case 0x8D50:
                    return "GL_RENDERBUFFER_RED_SIZE";
                case 0x8D51:
                    return "GL_RENDERBUFFER_GREEN_SIZE";
                case 0x8D52:
                    return "GL_RENDERBUFFER_BLUE_SIZE";
                case 0x8D53:
                    return "GL_RENDERBUFFER_ALPHA_SIZE";
                case 0x8D54:
                    return "GL_RENDERBUFFER_DEPTH_SIZE";
                case 0x8D55:
                    return "GL_RENDERBUFFER_STENCIL_SIZE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::RenderbufferTarget:
        {
            switch (value)
            {
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ReplacementCodeTypeSUN:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SamplerParameterF:
        {
            switch (value)
            {
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x813A:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813B:
                    return "GL_TEXTURE_MAX_LOD";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SamplerParameterI:
        {
            switch (value)
            {
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x884C:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884D:
                    return "GL_TEXTURE_COMPARE_FUNC";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ScalarType:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SecondaryColorPointerTypeIBM:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ShaderParameterName:
        {
            switch (value)
            {
                case 0x8B4F:
                    return "GL_SHADER_TYPE";
                case 0x8B80:
                    return "GL_DELETE_STATUS";
                case 0x8B81:
                    return "GL_COMPILE_STATUS";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8B88:
                    return "GL_SHADER_SOURCE_LENGTH";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ShaderType:
        {
            switch (value)
            {
                case 0x8B30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8B31:
                    return "GL_VERTEX_SHADER";
                case 0x8DD9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8E87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8E88:
                    return "GL_TESS_CONTROL_SHADER";
                case 0x91B9:
                    return "GL_COMPUTE_SHADER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ShadingModel:
        {
            switch (value)
            {
                case 0x1D00:
                    return "GL_FLAT";
                case 0x1D01:
                    return "GL_SMOOTH";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::ShadingRateQCOM:
        {
            switch (value)
            {
                case 0x96A6:
                    return "GL_SHADING_RATE_1X1_PIXELS_QCOM";
                case 0x96A7:
                    return "GL_SHADING_RATE_1X2_PIXELS_QCOM";
                case 0x96A8:
                    return "GL_SHADING_RATE_2X1_PIXELS_QCOM";
                case 0x96A9:
                    return "GL_SHADING_RATE_2X2_PIXELS_QCOM";
                case 0x96AC:
                    return "GL_SHADING_RATE_4X2_PIXELS_QCOM";
                case 0x96AE:
                    return "GL_SHADING_RATE_4X4_PIXELS_QCOM";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SizedInternalFormat:
        {
            switch (value)
            {
                case 0x803C:
                    return "GL_ALPHA8_EXT";
                case 0x8040:
                    return "GL_LUMINANCE8_EXT";
                case 0x8045:
                    return "GL_LUMINANCE8_ALPHA8_EXT";
                case 0x8051:
                    return "GL_RGB8";
                case 0x8052:
                    return "GL_RGB10_EXT";
                case 0x8054:
                    return "GL_RGB16_EXT";
                case 0x8056:
                    return "GL_RGBA4";
                case 0x8057:
                    return "GL_RGB5_A1";
                case 0x8058:
                    return "GL_RGBA8";
                case 0x8059:
                    return "GL_RGB10_A2";
                case 0x805B:
                    return "GL_RGBA16_EXT";
                case 0x81A5:
                    return "GL_DEPTH_COMPONENT16";
                case 0x81A6:
                    return "GL_DEPTH_COMPONENT24";
                case 0x81A7:
                    return "GL_DEPTH_COMPONENT32_OES";
                case 0x8229:
                    return "GL_R8";
                case 0x822A:
                    return "GL_R16_EXT";
                case 0x822B:
                    return "GL_RG8";
                case 0x822C:
                    return "GL_RG16_EXT";
                case 0x822D:
                    return "GL_R16F";
                case 0x822E:
                    return "GL_R32F";
                case 0x822F:
                    return "GL_RG16F";
                case 0x8230:
                    return "GL_RG32F";
                case 0x8231:
                    return "GL_R8I";
                case 0x8232:
                    return "GL_R8UI";
                case 0x8233:
                    return "GL_R16I";
                case 0x8234:
                    return "GL_R16UI";
                case 0x8235:
                    return "GL_R32I";
                case 0x8236:
                    return "GL_R32UI";
                case 0x8237:
                    return "GL_RG8I";
                case 0x8238:
                    return "GL_RG8UI";
                case 0x8239:
                    return "GL_RG16I";
                case 0x823A:
                    return "GL_RG16UI";
                case 0x823B:
                    return "GL_RG32I";
                case 0x823C:
                    return "GL_RG32UI";
                case 0x83F0:
                    return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
                case 0x83F1:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
                case 0x83F2:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
                case 0x83F3:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
                case 0x8814:
                    return "GL_RGBA32F";
                case 0x8815:
                    return "GL_RGB32F";
                case 0x881A:
                    return "GL_RGBA16F";
                case 0x881B:
                    return "GL_RGB16F";
                case 0x88F0:
                    return "GL_DEPTH24_STENCIL8";
                case 0x8C3A:
                    return "GL_R11F_G11F_B10F";
                case 0x8C3D:
                    return "GL_RGB9_E5";
                case 0x8C41:
                    return "GL_SRGB8";
                case 0x8C43:
                    return "GL_SRGB8_ALPHA8";
                case 0x8C4C:
                    return "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT";
                case 0x8C4D:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT";
                case 0x8C4E:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT";
                case 0x8C4F:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT";
                case 0x8CAC:
                    return "GL_DEPTH_COMPONENT32F";
                case 0x8CAD:
                    return "GL_DEPTH32F_STENCIL8";
                case 0x8D48:
                    return "GL_STENCIL_INDEX8";
                case 0x8D62:
                    return "GL_RGB565";
                case 0x8D64:
                    return "GL_ETC1_RGB8_OES";
                case 0x8D70:
                    return "GL_RGBA32UI";
                case 0x8D71:
                    return "GL_RGB32UI";
                case 0x8D76:
                    return "GL_RGBA16UI";
                case 0x8D77:
                    return "GL_RGB16UI";
                case 0x8D7C:
                    return "GL_RGBA8UI";
                case 0x8D7D:
                    return "GL_RGB8UI";
                case 0x8D82:
                    return "GL_RGBA32I";
                case 0x8D83:
                    return "GL_RGB32I";
                case 0x8D88:
                    return "GL_RGBA16I";
                case 0x8D89:
                    return "GL_RGB16I";
                case 0x8D8E:
                    return "GL_RGBA8I";
                case 0x8D8F:
                    return "GL_RGB8I";
                case 0x8DBB:
                    return "GL_COMPRESSED_RED_RGTC1_EXT";
                case 0x8DBC:
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1_EXT";
                case 0x8DBD:
                    return "GL_COMPRESSED_RED_GREEN_RGTC2_EXT";
                case 0x8DBE:
                    return "GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT";
                case 0x8E8C:
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM_EXT";
                case 0x8E8D:
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT";
                case 0x8E8E:
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT";
                case 0x8E8F:
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT";
                case 0x8F94:
                    return "GL_R8_SNORM";
                case 0x8F95:
                    return "GL_RG8_SNORM";
                case 0x8F96:
                    return "GL_RGB8_SNORM";
                case 0x8F97:
                    return "GL_RGBA8_SNORM";
                case 0x8F98:
                    return "GL_R16_SNORM_EXT";
                case 0x8F99:
                    return "GL_RG16_SNORM_EXT";
                case 0x8F9A:
                    return "GL_RGB16_SNORM_EXT";
                case 0x8F9B:
                    return "GL_RGBA16_SNORM_EXT";
                case 0x906F:
                    return "GL_RGB10_A2UI";
                case 0x9270:
                    return "GL_COMPRESSED_R11_EAC";
                case 0x9271:
                    return "GL_COMPRESSED_SIGNED_R11_EAC";
                case 0x9272:
                    return "GL_COMPRESSED_RG11_EAC";
                case 0x9273:
                    return "GL_COMPRESSED_SIGNED_RG11_EAC";
                case 0x9274:
                    return "GL_COMPRESSED_RGB8_ETC2";
                case 0x9275:
                    return "GL_COMPRESSED_SRGB8_ETC2";
                case 0x9276:
                    return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9277:
                    return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9278:
                    return "GL_COMPRESSED_RGBA8_ETC2_EAC";
                case 0x9279:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
                case 0x93B0:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4";
                case 0x93B1:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4";
                case 0x93B2:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5";
                case 0x93B3:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5";
                case 0x93B4:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6";
                case 0x93B5:
                    return "GL_COMPRESSED_RGBA_ASTC_8x5";
                case 0x93B6:
                    return "GL_COMPRESSED_RGBA_ASTC_8x6";
                case 0x93B7:
                    return "GL_COMPRESSED_RGBA_ASTC_8x8";
                case 0x93B8:
                    return "GL_COMPRESSED_RGBA_ASTC_10x5";
                case 0x93B9:
                    return "GL_COMPRESSED_RGBA_ASTC_10x6";
                case 0x93BA:
                    return "GL_COMPRESSED_RGBA_ASTC_10x8";
                case 0x93BB:
                    return "GL_COMPRESSED_RGBA_ASTC_10x10";
                case 0x93BC:
                    return "GL_COMPRESSED_RGBA_ASTC_12x10";
                case 0x93BD:
                    return "GL_COMPRESSED_RGBA_ASTC_12x12";
                case 0x93C0:
                    return "GL_COMPRESSED_RGBA_ASTC_3x3x3_OES";
                case 0x93C1:
                    return "GL_COMPRESSED_RGBA_ASTC_4x3x3_OES";
                case 0x93C2:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4x3_OES";
                case 0x93C3:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4x4_OES";
                case 0x93C4:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4x4_OES";
                case 0x93C5:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5x4_OES";
                case 0x93C6:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5x5_OES";
                case 0x93C7:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5x5_OES";
                case 0x93C8:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6x5_OES";
                case 0x93C9:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6x6_OES";
                case 0x93D0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4";
                case 0x93D1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4";
                case 0x93D2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5";
                case 0x93D3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5";
                case 0x93D4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6";
                case 0x93D5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5";
                case 0x93D6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6";
                case 0x93D7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8";
                case 0x93D8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5";
                case 0x93D9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6";
                case 0x93DA:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8";
                case 0x93DB:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10";
                case 0x93DC:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10";
                case 0x93DD:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12";
                case 0x93E0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES";
                case 0x93E1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES";
                case 0x93E2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES";
                case 0x93E3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES";
                case 0x93E4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES";
                case 0x93E5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES";
                case 0x93E6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES";
                case 0x93E7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES";
                case 0x93E8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES";
                case 0x93E9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::StencilFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::StencilOp:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x150A:
                    return "GL_INVERT";
                case 0x1E00:
                    return "GL_KEEP";
                case 0x1E01:
                    return "GL_REPLACE";
                case 0x1E02:
                    return "GL_INCR";
                case 0x1E03:
                    return "GL_DECR";
                case 0x8507:
                    return "GL_INCR_WRAP";
                case 0x8508:
                    return "GL_DECR_WRAP";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::StringName:
        {
            switch (value)
            {
                case 0x1F00:
                    return "GL_VENDOR";
                case 0x1F01:
                    return "GL_RENDERER";
                case 0x1F02:
                    return "GL_VERSION";
                case 0x1F03:
                    return "GL_EXTENSIONS";
                case 0x8B8C:
                    return "GL_SHADING_LANGUAGE_VERSION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SubroutineParameterName:
        {
            switch (value)
            {
                case 0x8A38:
                    return "GL_UNIFORM_SIZE";
                case 0x8A39:
                    return "GL_UNIFORM_NAME_LENGTH";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SyncBehaviorFlags:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SyncCondition:
        {
            switch (value)
            {
                case 0x9117:
                    return "GL_SYNC_GPU_COMMANDS_COMPLETE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SyncObjectMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_SYNC_FLUSH_COMMANDS_BIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SyncParameterName:
        {
            switch (value)
            {
                case 0x9112:
                    return "GL_OBJECT_TYPE";
                case 0x9113:
                    return "GL_SYNC_CONDITION";
                case 0x9114:
                    return "GL_SYNC_STATUS";
                case 0x9115:
                    return "GL_SYNC_FLAGS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::SyncStatus:
        {
            switch (value)
            {
                case 0x911A:
                    return "GL_ALREADY_SIGNALED";
                case 0x911B:
                    return "GL_TIMEOUT_EXPIRED";
                case 0x911C:
                    return "GL_CONDITION_SATISFIED";
                case 0x911D:
                    return "GL_WAIT_FAILED";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TangentPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TexCoordPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureCompareMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x884E:
                    return "GL_COMPARE_REF_TO_TEXTURE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureCoordName:
        {
            switch (value)
            {
                case 0x8D60:
                    return "GL_TEXTURE_GEN_STR_OES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureEnvMode:
        {
            switch (value)
            {
                case 0x104:
                    return "GL_ADD";
                case 0xBE2:
                    return "GL_BLEND";
                case 0x2100:
                    return "GL_MODULATE";
                case 0x2101:
                    return "GL_DECAL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureEnvParameter:
        {
            switch (value)
            {
                case 0x2200:
                    return "GL_TEXTURE_ENV_MODE";
                case 0x2201:
                    return "GL_TEXTURE_ENV_COLOR";
                case 0x8570:
                    return "GL_COMBINE";
                case 0x8571:
                    return "GL_COMBINE_RGB";
                case 0x8572:
                    return "GL_COMBINE_ALPHA";
                case 0x8573:
                    return "GL_RGB_SCALE";
                case 0x8574:
                    return "GL_ADD_SIGNED";
                case 0x8575:
                    return "GL_INTERPOLATE";
                case 0x8576:
                    return "GL_CONSTANT";
                case 0x8577:
                    return "GL_PRIMARY_COLOR";
                case 0x8578:
                    return "GL_PREVIOUS";
                case 0x8580:
                    return "GL_SRC0_RGB";
                case 0x8581:
                    return "GL_SRC1_RGB";
                case 0x8582:
                    return "GL_SRC2_RGB";
                case 0x8588:
                    return "GL_SRC0_ALPHA";
                case 0x8589:
                    return "GL_SRC1_ALPHA";
                case 0x858A:
                    return "GL_SRC2_ALPHA";
                case 0x8590:
                    return "GL_OPERAND0_RGB";
                case 0x8591:
                    return "GL_OPERAND1_RGB";
                case 0x8592:
                    return "GL_OPERAND2_RGB";
                case 0x8598:
                    return "GL_OPERAND0_ALPHA";
                case 0x8599:
                    return "GL_OPERAND1_ALPHA";
                case 0x859A:
                    return "GL_OPERAND2_ALPHA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureEnvTarget:
        {
            switch (value)
            {
                case 0x2300:
                    return "GL_TEXTURE_ENV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureGenParameter:
        {
            switch (value)
            {
                case 0x2500:
                    return "GL_TEXTURE_GEN_MODE_OES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureLayout:
        {
            switch (value)
            {
                case 0x9530:
                    return "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT";
                case 0x9531:
                    return "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT";
                case 0x958D:
                    return "GL_LAYOUT_GENERAL_EXT";
                case 0x958E:
                    return "GL_LAYOUT_COLOR_ATTACHMENT_EXT";
                case 0x958F:
                    return "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT";
                case 0x9590:
                    return "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT";
                case 0x9591:
                    return "GL_LAYOUT_SHADER_READ_ONLY_EXT";
                case 0x9592:
                    return "GL_LAYOUT_TRANSFER_SRC_EXT";
                case 0x9593:
                    return "GL_LAYOUT_TRANSFER_DST_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureMagFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureMinFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                case 0x2700:
                    return "GL_NEAREST_MIPMAP_NEAREST";
                case 0x2701:
                    return "GL_LINEAR_MIPMAP_NEAREST";
                case 0x2702:
                    return "GL_NEAREST_MIPMAP_LINEAR";
                case 0x2703:
                    return "GL_LINEAR_MIPMAP_LINEAR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureParameterName:
        {
            switch (value)
            {
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_INTERNAL_FORMAT";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x805C:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805D:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805E:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805F:
                    return "GL_TEXTURE_ALPHA_SIZE";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x813A:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813B:
                    return "GL_TEXTURE_MAX_LOD";
                case 0x813C:
                    return "GL_TEXTURE_BASE_LEVEL";
                case 0x813D:
                    return "GL_TEXTURE_MAX_LEVEL";
                case 0x8191:
                    return "GL_GENERATE_MIPMAP";
                case 0x884C:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884D:
                    return "GL_TEXTURE_COMPARE_FUNC";
                case 0x8E42:
                    return "GL_TEXTURE_SWIZZLE_R";
                case 0x8E43:
                    return "GL_TEXTURE_SWIZZLE_G";
                case 0x8E44:
                    return "GL_TEXTURE_SWIZZLE_B";
                case 0x8E45:
                    return "GL_TEXTURE_SWIZZLE_A";
                case 0x90EA:
                    return "GL_DEPTH_STENCIL_TEXTURE_MODE";
                case 0x9580:
                    return "GL_TEXTURE_TILING_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureSwizzle:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x1:
                    return "GL_ONE";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureTarget:
        {
            switch (value)
            {
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x806F:
                    return "GL_TEXTURE_3D";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8515:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X";
                case 0x8516:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X";
                case 0x8517:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y";
                case 0x8518:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y";
                case 0x8519:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z";
                case 0x851A:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z";
                case 0x8C1A:
                    return "GL_TEXTURE_2D_ARRAY";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                case 0x9009:
                    return "GL_TEXTURE_CUBE_MAP_ARRAY";
                case 0x9100:
                    return "GL_TEXTURE_2D_MULTISAMPLE";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureUnit:
        {
            switch (value)
            {
                case 0x84C0:
                    return "GL_TEXTURE0";
                case 0x84C1:
                    return "GL_TEXTURE1";
                case 0x84C2:
                    return "GL_TEXTURE2";
                case 0x84C3:
                    return "GL_TEXTURE3";
                case 0x84C4:
                    return "GL_TEXTURE4";
                case 0x84C5:
                    return "GL_TEXTURE5";
                case 0x84C6:
                    return "GL_TEXTURE6";
                case 0x84C7:
                    return "GL_TEXTURE7";
                case 0x84C8:
                    return "GL_TEXTURE8";
                case 0x84C9:
                    return "GL_TEXTURE9";
                case 0x84CA:
                    return "GL_TEXTURE10";
                case 0x84CB:
                    return "GL_TEXTURE11";
                case 0x84CC:
                    return "GL_TEXTURE12";
                case 0x84CD:
                    return "GL_TEXTURE13";
                case 0x84CE:
                    return "GL_TEXTURE14";
                case 0x84CF:
                    return "GL_TEXTURE15";
                case 0x84D0:
                    return "GL_TEXTURE16";
                case 0x84D1:
                    return "GL_TEXTURE17";
                case 0x84D2:
                    return "GL_TEXTURE18";
                case 0x84D3:
                    return "GL_TEXTURE19";
                case 0x84D4:
                    return "GL_TEXTURE20";
                case 0x84D5:
                    return "GL_TEXTURE21";
                case 0x84D6:
                    return "GL_TEXTURE22";
                case 0x84D7:
                    return "GL_TEXTURE23";
                case 0x84D8:
                    return "GL_TEXTURE24";
                case 0x84D9:
                    return "GL_TEXTURE25";
                case 0x84DA:
                    return "GL_TEXTURE26";
                case 0x84DB:
                    return "GL_TEXTURE27";
                case 0x84DC:
                    return "GL_TEXTURE28";
                case 0x84DD:
                    return "GL_TEXTURE29";
                case 0x84DE:
                    return "GL_TEXTURE30";
                case 0x84DF:
                    return "GL_TEXTURE31";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TextureWrapMode:
        {
            switch (value)
            {
                case 0x2703:
                    return "GL_LINEAR_MIPMAP_LINEAR";
                case 0x2901:
                    return "GL_REPEAT";
                case 0x812D:
                    return "GL_CLAMP_TO_BORDER";
                case 0x812F:
                    return "GL_CLAMP_TO_EDGE";
                case 0x8370:
                    return "GL_MIRRORED_REPEAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TransformFeedbackBufferMode:
        {
            switch (value)
            {
                case 0x8C8C:
                    return "GL_INTERLEAVED_ATTRIBS";
                case 0x8C8D:
                    return "GL_SEPARATE_ATTRIBS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TransformFeedbackPName:
        {
            switch (value)
            {
                case 0x8C84:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
                case 0x8C85:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
                case 0x8C8F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
                case 0x8E23:
                    return "GL_TRANSFORM_FEEDBACK_PAUSED";
                case 0x8E24:
                    return "GL_TRANSFORM_FEEDBACK_ACTIVE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::TriangleFace:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::UniformBlockPName:
        {
            switch (value)
            {
                case 0x8A3F:
                    return "GL_UNIFORM_BLOCK_BINDING";
                case 0x8A40:
                    return "GL_UNIFORM_BLOCK_DATA_SIZE";
                case 0x8A41:
                    return "GL_UNIFORM_BLOCK_NAME_LENGTH";
                case 0x8A42:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS";
                case 0x8A43:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES";
                case 0x8A44:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER";
                case 0x8A46:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::UniformPName:
        {
            switch (value)
            {
                case 0x8A37:
                    return "GL_UNIFORM_TYPE";
                case 0x8A38:
                    return "GL_UNIFORM_SIZE";
                case 0x8A39:
                    return "GL_UNIFORM_NAME_LENGTH";
                case 0x8A3A:
                    return "GL_UNIFORM_BLOCK_INDEX";
                case 0x8A3B:
                    return "GL_UNIFORM_OFFSET";
                case 0x8A3C:
                    return "GL_UNIFORM_ARRAY_STRIDE";
                case 0x8A3D:
                    return "GL_UNIFORM_MATRIX_STRIDE";
                case 0x8A3E:
                    return "GL_UNIFORM_IS_ROW_MAJOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::UniformType:
        {
            switch (value)
            {
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x8B50:
                    return "GL_FLOAT_VEC2";
                case 0x8B51:
                    return "GL_FLOAT_VEC3";
                case 0x8B52:
                    return "GL_FLOAT_VEC4";
                case 0x8B53:
                    return "GL_INT_VEC2";
                case 0x8B54:
                    return "GL_INT_VEC3";
                case 0x8B55:
                    return "GL_INT_VEC4";
                case 0x8B56:
                    return "GL_BOOL";
                case 0x8B57:
                    return "GL_BOOL_VEC2";
                case 0x8B58:
                    return "GL_BOOL_VEC3";
                case 0x8B59:
                    return "GL_BOOL_VEC4";
                case 0x8B5A:
                    return "GL_FLOAT_MAT2";
                case 0x8B5B:
                    return "GL_FLOAT_MAT3";
                case 0x8B5C:
                    return "GL_FLOAT_MAT4";
                case 0x8B5E:
                    return "GL_SAMPLER_2D";
                case 0x8B5F:
                    return "GL_SAMPLER_3D";
                case 0x8B60:
                    return "GL_SAMPLER_CUBE";
                case 0x8B62:
                    return "GL_SAMPLER_2D_SHADOW";
                case 0x8B65:
                    return "GL_FLOAT_MAT2x3";
                case 0x8B66:
                    return "GL_FLOAT_MAT2x4";
                case 0x8B67:
                    return "GL_FLOAT_MAT3x2";
                case 0x8B68:
                    return "GL_FLOAT_MAT3x4";
                case 0x8B69:
                    return "GL_FLOAT_MAT4x2";
                case 0x8B6A:
                    return "GL_FLOAT_MAT4x3";
                case 0x8DC1:
                    return "GL_SAMPLER_2D_ARRAY";
                case 0x8DC2:
                    return "GL_SAMPLER_BUFFER";
                case 0x8DC4:
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
                case 0x8DC5:
                    return "GL_SAMPLER_CUBE_SHADOW";
                case 0x8DC6:
                    return "GL_UNSIGNED_INT_VEC2";
                case 0x8DC7:
                    return "GL_UNSIGNED_INT_VEC3";
                case 0x8DC8:
                    return "GL_UNSIGNED_INT_VEC4";
                case 0x8DCA:
                    return "GL_INT_SAMPLER_2D";
                case 0x8DCB:
                    return "GL_INT_SAMPLER_3D";
                case 0x8DCC:
                    return "GL_INT_SAMPLER_CUBE";
                case 0x8DCF:
                    return "GL_INT_SAMPLER_2D_ARRAY";
                case 0x8DD0:
                    return "GL_INT_SAMPLER_BUFFER";
                case 0x8DD2:
                    return "GL_UNSIGNED_INT_SAMPLER_2D";
                case 0x8DD3:
                    return "GL_UNSIGNED_INT_SAMPLER_3D";
                case 0x8DD4:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE";
                case 0x8DD7:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
                case 0x8DD8:
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
                case 0x900C:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900D:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
                case 0x900E:
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900F:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x9108:
                    return "GL_SAMPLER_2D_MULTISAMPLE";
                case 0x9109:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910A:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910B:
                    return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910C:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910D:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::UseProgramStageMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_VERTEX_SHADER_BIT";
                case 0x2:
                    return "GL_FRAGMENT_SHADER_BIT";
                case 0x4:
                    return "GL_GEOMETRY_SHADER_BIT";
                case 0x8:
                    return "GL_TESS_CONTROL_SHADER_BIT";
                case 0x10:
                    return "GL_TESS_EVALUATION_SHADER_BIT";
                case 0x20:
                    return "GL_COMPUTE_SHADER_BIT";
                case 0xFFFFFFFF:
                    return "GL_ALL_SHADER_BITS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexArrayPName:
        {
            switch (value)
            {
                case 0x82D5:
                    return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexAttribEnum:
        {
            switch (value)
            {
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x8626:
                    return "GL_CURRENT_VERTEX_ATTRIB";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x889F:
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexAttribIType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexAttribPointerPropertyARB:
        {
            switch (value)
            {
                case 0x8645:
                    return "GL_VERTEX_ATTRIB_ARRAY_POINTER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexAttribPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x140C:
                    return "GL_FIXED";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8D9F:
                    return "GL_INT_2_10_10_10_REV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexAttribPropertyARB:
        {
            switch (value)
            {
                case 0x82D4:
                    return "GL_VERTEX_ATTRIB_BINDING";
                case 0x82D5:
                    return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x8626:
                    return "GL_CURRENT_VERTEX_ATTRIB";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x889F:
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexAttribType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x140C:
                    return "GL_FIXED";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8D9F:
                    return "GL_INT_2_10_10_10_REV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexBufferObjectUsage:
        {
            switch (value)
            {
                case 0x88E0:
                    return "GL_STREAM_DRAW";
                case 0x88E1:
                    return "GL_STREAM_READ";
                case 0x88E2:
                    return "GL_STREAM_COPY";
                case 0x88E4:
                    return "GL_STATIC_DRAW";
                case 0x88E5:
                    return "GL_STATIC_READ";
                case 0x88E6:
                    return "GL_STATIC_COPY";
                case 0x88E8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88E9:
                    return "GL_DYNAMIC_READ";
                case 0x88EA:
                    return "GL_DYNAMIC_COPY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexProvokingMode:
        {
            switch (value)
            {
                case 0x8E4D:
                    return "GL_FIRST_VERTEX_CONVENTION";
                case 0x8E4E:
                    return "GL_LAST_VERTEX_CONVENTION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexShaderTextureUnitParameter:
        {
            switch (value)
            {
                case 0xB03:
                    return "GL_CURRENT_TEXTURE_COORDS";
                case 0xBA8:
                    return "GL_TEXTURE_MATRIX";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexShaderWriteMaskEXT:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_FALSE";
                case 0x1:
                    return "GL_TRUE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::VertexWeightPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case GLESEnum::WeightPointerTypeARB:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        default:
            return UnknownEnumToString(value);
    }
}

const char *GLenumToString(BigGLEnum enumGroup, unsigned int value)
{
    switch (enumGroup)
    {
        case BigGLEnum::AccumOp:
        {
            switch (value)
            {
                case 0x100:
                    return "GL_ACCUM";
                case 0x101:
                    return "GL_LOAD";
                case 0x102:
                    return "GL_RETURN";
                case 0x103:
                    return "GL_MULT";
                case 0x104:
                    return "GL_ADD";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::AllEnums:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1:
                    return "GL_ONE";
                case 0x2:
                    return "GL_LINE_LOOP";
                case 0x3:
                    return "GL_LINE_STRIP";
                case 0x4:
                    return "GL_LINE_BIT";
                case 0x5:
                    return "GL_TRIANGLE_STRIP";
                case 0x6:
                    return "GL_TRIANGLE_FAN";
                case 0x7:
                    return "GL_QUADS";
                case 0x8:
                    return "GL_QUAD_STRIP";
                case 0x9:
                    return "GL_POLYGON";
                case 0xA:
                    return "GL_LINES_ADJACENCY";
                case 0xB:
                    return "GL_LINE_STRIP_ADJACENCY";
                case 0xC:
                    return "GL_TRIANGLES_ADJACENCY";
                case 0xD:
                    return "GL_TRIANGLE_STRIP_ADJACENCY";
                case 0xE:
                    return "GL_PATCHES";
                case 0x10:
                    return "GL_POLYGON_STIPPLE_BIT";
                case 0x16:
                    return "GL_UUID_SIZE_EXT";
                case 0x20:
                    return "GL_PIXEL_MODE_BIT";
                case 0x40:
                    return "GL_LIGHTING_BIT";
                case 0x80:
                    return "GL_FOG_BIT";
                case 0x100:
                    return "GL_ACCUM";
                case 0x101:
                    return "GL_LOAD";
                case 0x102:
                    return "GL_RETURN";
                case 0x103:
                    return "GL_MULT";
                case 0x104:
                    return "GL_ADD";
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                case 0x300:
                    return "GL_SRC_COLOR";
                case 0x301:
                    return "GL_ONE_MINUS_SRC_COLOR";
                case 0x302:
                    return "GL_SRC_ALPHA";
                case 0x303:
                    return "GL_ONE_MINUS_SRC_ALPHA";
                case 0x304:
                    return "GL_DST_ALPHA";
                case 0x305:
                    return "GL_ONE_MINUS_DST_ALPHA";
                case 0x306:
                    return "GL_DST_COLOR";
                case 0x307:
                    return "GL_ONE_MINUS_DST_COLOR";
                case 0x308:
                    return "GL_SRC_ALPHA_SATURATE";
                case 0x400:
                    return "GL_FRONT_LEFT";
                case 0x401:
                    return "GL_FRONT_RIGHT";
                case 0x402:
                    return "GL_BACK_LEFT";
                case 0x403:
                    return "GL_BACK_RIGHT";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x406:
                    return "GL_LEFT";
                case 0x407:
                    return "GL_RIGHT";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                case 0x409:
                    return "GL_AUX0";
                case 0x40A:
                    return "GL_AUX1";
                case 0x40B:
                    return "GL_AUX2";
                case 0x40C:
                    return "GL_AUX3";
                case 0x500:
                    return "GL_INVALID_ENUM";
                case 0x501:
                    return "GL_INVALID_VALUE";
                case 0x502:
                    return "GL_INVALID_OPERATION";
                case 0x503:
                    return "GL_STACK_OVERFLOW";
                case 0x504:
                    return "GL_STACK_UNDERFLOW";
                case 0x505:
                    return "GL_OUT_OF_MEMORY";
                case 0x506:
                    return "GL_INVALID_FRAMEBUFFER_OPERATION";
                case 0x507:
                    return "GL_CONTEXT_LOST";
                case 0x600:
                    return "GL_2D";
                case 0x601:
                    return "GL_3D";
                case 0x602:
                    return "GL_3D_COLOR";
                case 0x603:
                    return "GL_3D_COLOR_TEXTURE";
                case 0x604:
                    return "GL_4D_COLOR_TEXTURE";
                case 0x700:
                    return "GL_PASS_THROUGH_TOKEN";
                case 0x701:
                    return "GL_POINT_TOKEN";
                case 0x702:
                    return "GL_LINE_TOKEN";
                case 0x703:
                    return "GL_POLYGON_TOKEN";
                case 0x704:
                    return "GL_BITMAP_TOKEN";
                case 0x705:
                    return "GL_DRAW_PIXEL_TOKEN";
                case 0x706:
                    return "GL_COPY_PIXEL_TOKEN";
                case 0x707:
                    return "GL_LINE_RESET_TOKEN";
                case 0x800:
                    return "GL_EXP";
                case 0x801:
                    return "GL_EXP2";
                case 0x900:
                    return "GL_CW";
                case 0x901:
                    return "GL_CCW";
                case 0xA00:
                    return "GL_COEFF";
                case 0xA01:
                    return "GL_ORDER";
                case 0xA02:
                    return "GL_DOMAIN";
                case 0xB00:
                    return "GL_CURRENT_COLOR";
                case 0xB01:
                    return "GL_CURRENT_INDEX";
                case 0xB02:
                    return "GL_CURRENT_NORMAL";
                case 0xB03:
                    return "GL_CURRENT_TEXTURE_COORDS";
                case 0xB04:
                    return "GL_CURRENT_RASTER_COLOR";
                case 0xB05:
                    return "GL_CURRENT_RASTER_INDEX";
                case 0xB06:
                    return "GL_CURRENT_RASTER_TEXTURE_COORDS";
                case 0xB07:
                    return "GL_CURRENT_RASTER_POSITION";
                case 0xB08:
                    return "GL_CURRENT_RASTER_POSITION_VALID";
                case 0xB09:
                    return "GL_CURRENT_RASTER_DISTANCE";
                case 0xB10:
                    return "GL_POINT_SMOOTH";
                case 0xB11:
                    return "GL_POINT_SIZE";
                case 0xB12:
                    return "GL_POINT_SIZE_RANGE";
                case 0xB13:
                    return "GL_POINT_SIZE_GRANULARITY";
                case 0xB20:
                    return "GL_LINE_SMOOTH";
                case 0xB21:
                    return "GL_LINE_WIDTH";
                case 0xB22:
                    return "GL_LINE_WIDTH_RANGE";
                case 0xB23:
                    return "GL_LINE_WIDTH_GRANULARITY";
                case 0xB24:
                    return "GL_LINE_STIPPLE";
                case 0xB25:
                    return "GL_LINE_STIPPLE_PATTERN";
                case 0xB26:
                    return "GL_LINE_STIPPLE_REPEAT";
                case 0xB30:
                    return "GL_LIST_MODE";
                case 0xB31:
                    return "GL_MAX_LIST_NESTING";
                case 0xB32:
                    return "GL_LIST_BASE";
                case 0xB33:
                    return "GL_LIST_INDEX";
                case 0xB40:
                    return "GL_POLYGON_MODE";
                case 0xB41:
                    return "GL_POLYGON_SMOOTH";
                case 0xB42:
                    return "GL_POLYGON_STIPPLE";
                case 0xB43:
                    return "GL_EDGE_FLAG";
                case 0xB44:
                    return "GL_CULL_FACE";
                case 0xB45:
                    return "GL_CULL_FACE_MODE";
                case 0xB46:
                    return "GL_FRONT_FACE";
                case 0xB50:
                    return "GL_LIGHTING";
                case 0xB51:
                    return "GL_LIGHT_MODEL_LOCAL_VIEWER";
                case 0xB52:
                    return "GL_LIGHT_MODEL_TWO_SIDE";
                case 0xB53:
                    return "GL_LIGHT_MODEL_AMBIENT";
                case 0xB54:
                    return "GL_SHADE_MODEL";
                case 0xB55:
                    return "GL_COLOR_MATERIAL_FACE";
                case 0xB56:
                    return "GL_COLOR_MATERIAL_PARAMETER";
                case 0xB57:
                    return "GL_COLOR_MATERIAL";
                case 0xB60:
                    return "GL_FOG";
                case 0xB61:
                    return "GL_FOG_INDEX";
                case 0xB62:
                    return "GL_FOG_DENSITY";
                case 0xB63:
                    return "GL_FOG_START";
                case 0xB64:
                    return "GL_FOG_END";
                case 0xB65:
                    return "GL_FOG_MODE";
                case 0xB66:
                    return "GL_FOG_COLOR";
                case 0xB70:
                    return "GL_DEPTH_RANGE";
                case 0xB71:
                    return "GL_DEPTH_TEST";
                case 0xB72:
                    return "GL_DEPTH_WRITEMASK";
                case 0xB73:
                    return "GL_DEPTH_CLEAR_VALUE";
                case 0xB74:
                    return "GL_DEPTH_FUNC";
                case 0xB80:
                    return "GL_ACCUM_CLEAR_VALUE";
                case 0xB90:
                    return "GL_STENCIL_TEST";
                case 0xB91:
                    return "GL_STENCIL_CLEAR_VALUE";
                case 0xB92:
                    return "GL_STENCIL_FUNC";
                case 0xB93:
                    return "GL_STENCIL_VALUE_MASK";
                case 0xB94:
                    return "GL_STENCIL_FAIL";
                case 0xB95:
                    return "GL_STENCIL_PASS_DEPTH_FAIL";
                case 0xB96:
                    return "GL_STENCIL_PASS_DEPTH_PASS";
                case 0xB97:
                    return "GL_STENCIL_REF";
                case 0xB98:
                    return "GL_STENCIL_WRITEMASK";
                case 0xBA0:
                    return "GL_MATRIX_MODE";
                case 0xBA1:
                    return "GL_NORMALIZE";
                case 0xBA2:
                    return "GL_VIEWPORT";
                case 0xBA3:
                    return "GL_MODELVIEW_STACK_DEPTH";
                case 0xBA4:
                    return "GL_PROJECTION_STACK_DEPTH";
                case 0xBA5:
                    return "GL_TEXTURE_STACK_DEPTH";
                case 0xBA6:
                    return "GL_MODELVIEW_MATRIX";
                case 0xBA7:
                    return "GL_PROJECTION_MATRIX";
                case 0xBA8:
                    return "GL_TEXTURE_MATRIX";
                case 0xBB0:
                    return "GL_ATTRIB_STACK_DEPTH";
                case 0xBB1:
                    return "GL_CLIENT_ATTRIB_STACK_DEPTH";
                case 0xBC0:
                    return "GL_ALPHA_TEST";
                case 0xBC1:
                    return "GL_ALPHA_TEST_FUNC";
                case 0xBC2:
                    return "GL_ALPHA_TEST_REF";
                case 0xBD0:
                    return "GL_DITHER";
                case 0xBE0:
                    return "GL_BLEND_DST";
                case 0xBE1:
                    return "GL_BLEND_SRC";
                case 0xBE2:
                    return "GL_BLEND";
                case 0xBF0:
                    return "GL_LOGIC_OP_MODE";
                case 0xBF1:
                    return "GL_LOGIC_OP";
                case 0xBF2:
                    return "GL_COLOR_LOGIC_OP";
                case 0xC00:
                    return "GL_AUX_BUFFERS";
                case 0xC01:
                    return "GL_DRAW_BUFFER";
                case 0xC02:
                    return "GL_READ_BUFFER";
                case 0xC10:
                    return "GL_SCISSOR_BOX";
                case 0xC11:
                    return "GL_SCISSOR_TEST";
                case 0xC20:
                    return "GL_INDEX_CLEAR_VALUE";
                case 0xC21:
                    return "GL_INDEX_WRITEMASK";
                case 0xC22:
                    return "GL_COLOR_CLEAR_VALUE";
                case 0xC23:
                    return "GL_COLOR_WRITEMASK";
                case 0xC30:
                    return "GL_INDEX_MODE";
                case 0xC31:
                    return "GL_RGBA_MODE";
                case 0xC32:
                    return "GL_DOUBLEBUFFER";
                case 0xC33:
                    return "GL_STEREO";
                case 0xC40:
                    return "GL_RENDER_MODE";
                case 0xC50:
                    return "GL_PERSPECTIVE_CORRECTION_HINT";
                case 0xC51:
                    return "GL_POINT_SMOOTH_HINT";
                case 0xC52:
                    return "GL_LINE_SMOOTH_HINT";
                case 0xC53:
                    return "GL_POLYGON_SMOOTH_HINT";
                case 0xC54:
                    return "GL_FOG_HINT";
                case 0xC60:
                    return "GL_TEXTURE_GEN_S";
                case 0xC61:
                    return "GL_TEXTURE_GEN_T";
                case 0xC62:
                    return "GL_TEXTURE_GEN_R";
                case 0xC63:
                    return "GL_TEXTURE_GEN_Q";
                case 0xC70:
                    return "GL_PIXEL_MAP_I_TO_I";
                case 0xC71:
                    return "GL_PIXEL_MAP_S_TO_S";
                case 0xC72:
                    return "GL_PIXEL_MAP_I_TO_R";
                case 0xC73:
                    return "GL_PIXEL_MAP_I_TO_G";
                case 0xC74:
                    return "GL_PIXEL_MAP_I_TO_B";
                case 0xC75:
                    return "GL_PIXEL_MAP_I_TO_A";
                case 0xC76:
                    return "GL_PIXEL_MAP_R_TO_R";
                case 0xC77:
                    return "GL_PIXEL_MAP_G_TO_G";
                case 0xC78:
                    return "GL_PIXEL_MAP_B_TO_B";
                case 0xC79:
                    return "GL_PIXEL_MAP_A_TO_A";
                case 0xCB0:
                    return "GL_PIXEL_MAP_I_TO_I_SIZE";
                case 0xCB1:
                    return "GL_PIXEL_MAP_S_TO_S_SIZE";
                case 0xCB2:
                    return "GL_PIXEL_MAP_I_TO_R_SIZE";
                case 0xCB3:
                    return "GL_PIXEL_MAP_I_TO_G_SIZE";
                case 0xCB4:
                    return "GL_PIXEL_MAP_I_TO_B_SIZE";
                case 0xCB5:
                    return "GL_PIXEL_MAP_I_TO_A_SIZE";
                case 0xCB6:
                    return "GL_PIXEL_MAP_R_TO_R_SIZE";
                case 0xCB7:
                    return "GL_PIXEL_MAP_G_TO_G_SIZE";
                case 0xCB8:
                    return "GL_PIXEL_MAP_B_TO_B_SIZE";
                case 0xCB9:
                    return "GL_PIXEL_MAP_A_TO_A_SIZE";
                case 0xCF0:
                    return "GL_UNPACK_SWAP_BYTES";
                case 0xCF1:
                    return "GL_UNPACK_LSB_FIRST";
                case 0xCF2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xCF3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xCF4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xCF5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xD00:
                    return "GL_PACK_SWAP_BYTES";
                case 0xD01:
                    return "GL_PACK_LSB_FIRST";
                case 0xD02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xD03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xD04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xD05:
                    return "GL_PACK_ALIGNMENT";
                case 0xD10:
                    return "GL_MAP_COLOR";
                case 0xD11:
                    return "GL_MAP_STENCIL";
                case 0xD12:
                    return "GL_INDEX_SHIFT";
                case 0xD13:
                    return "GL_INDEX_OFFSET";
                case 0xD14:
                    return "GL_RED_SCALE";
                case 0xD15:
                    return "GL_RED_BIAS";
                case 0xD16:
                    return "GL_ZOOM_X";
                case 0xD17:
                    return "GL_ZOOM_Y";
                case 0xD18:
                    return "GL_GREEN_SCALE";
                case 0xD19:
                    return "GL_GREEN_BIAS";
                case 0xD1A:
                    return "GL_BLUE_SCALE";
                case 0xD1B:
                    return "GL_BLUE_BIAS";
                case 0xD1C:
                    return "GL_ALPHA_SCALE";
                case 0xD1D:
                    return "GL_ALPHA_BIAS";
                case 0xD1E:
                    return "GL_DEPTH_SCALE";
                case 0xD1F:
                    return "GL_DEPTH_BIAS";
                case 0xD30:
                    return "GL_MAX_EVAL_ORDER";
                case 0xD31:
                    return "GL_MAX_LIGHTS";
                case 0xD32:
                    return "GL_MAX_CLIP_PLANES";
                case 0xD33:
                    return "GL_MAX_TEXTURE_SIZE";
                case 0xD34:
                    return "GL_MAX_PIXEL_MAP_TABLE";
                case 0xD35:
                    return "GL_MAX_ATTRIB_STACK_DEPTH";
                case 0xD36:
                    return "GL_MAX_MODELVIEW_STACK_DEPTH";
                case 0xD37:
                    return "GL_MAX_NAME_STACK_DEPTH";
                case 0xD38:
                    return "GL_MAX_PROJECTION_STACK_DEPTH";
                case 0xD39:
                    return "GL_MAX_TEXTURE_STACK_DEPTH";
                case 0xD3A:
                    return "GL_MAX_VIEWPORT_DIMS";
                case 0xD3B:
                    return "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH";
                case 0xD50:
                    return "GL_SUBPIXEL_BITS";
                case 0xD51:
                    return "GL_INDEX_BITS";
                case 0xD52:
                    return "GL_RED_BITS";
                case 0xD53:
                    return "GL_GREEN_BITS";
                case 0xD54:
                    return "GL_BLUE_BITS";
                case 0xD55:
                    return "GL_ALPHA_BITS";
                case 0xD56:
                    return "GL_DEPTH_BITS";
                case 0xD57:
                    return "GL_STENCIL_BITS";
                case 0xD58:
                    return "GL_ACCUM_RED_BITS";
                case 0xD59:
                    return "GL_ACCUM_GREEN_BITS";
                case 0xD5A:
                    return "GL_ACCUM_BLUE_BITS";
                case 0xD5B:
                    return "GL_ACCUM_ALPHA_BITS";
                case 0xD70:
                    return "GL_NAME_STACK_DEPTH";
                case 0xD80:
                    return "GL_AUTO_NORMAL";
                case 0xD90:
                    return "GL_MAP1_COLOR_4";
                case 0xD91:
                    return "GL_MAP1_INDEX";
                case 0xD92:
                    return "GL_MAP1_NORMAL";
                case 0xD93:
                    return "GL_MAP1_TEXTURE_COORD_1";
                case 0xD94:
                    return "GL_MAP1_TEXTURE_COORD_2";
                case 0xD95:
                    return "GL_MAP1_TEXTURE_COORD_3";
                case 0xD96:
                    return "GL_MAP1_TEXTURE_COORD_4";
                case 0xD97:
                    return "GL_MAP1_VERTEX_3";
                case 0xD98:
                    return "GL_MAP1_VERTEX_4";
                case 0xDB0:
                    return "GL_MAP2_COLOR_4";
                case 0xDB1:
                    return "GL_MAP2_INDEX";
                case 0xDB2:
                    return "GL_MAP2_NORMAL";
                case 0xDB3:
                    return "GL_MAP2_TEXTURE_COORD_1";
                case 0xDB4:
                    return "GL_MAP2_TEXTURE_COORD_2";
                case 0xDB5:
                    return "GL_MAP2_TEXTURE_COORD_3";
                case 0xDB6:
                    return "GL_MAP2_TEXTURE_COORD_4";
                case 0xDB7:
                    return "GL_MAP2_VERTEX_3";
                case 0xDB8:
                    return "GL_MAP2_VERTEX_4";
                case 0xDD0:
                    return "GL_MAP1_GRID_DOMAIN";
                case 0xDD1:
                    return "GL_MAP1_GRID_SEGMENTS";
                case 0xDD2:
                    return "GL_MAP2_GRID_DOMAIN";
                case 0xDD3:
                    return "GL_MAP2_GRID_SEGMENTS";
                case 0xDE0:
                    return "GL_TEXTURE_1D";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0xDF0:
                    return "GL_FEEDBACK_BUFFER_POINTER";
                case 0xDF1:
                    return "GL_FEEDBACK_BUFFER_SIZE";
                case 0xDF2:
                    return "GL_FEEDBACK_BUFFER_TYPE";
                case 0xDF3:
                    return "GL_SELECTION_BUFFER_POINTER";
                case 0xDF4:
                    return "GL_SELECTION_BUFFER_SIZE";
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_COMPONENTS";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x1005:
                    return "GL_TEXTURE_BORDER";
                case 0x1006:
                    return "GL_TEXTURE_TARGET";
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x1101:
                    return "GL_FASTEST";
                case 0x1102:
                    return "GL_NICEST";
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1203:
                    return "GL_POSITION";
                case 0x1204:
                    return "GL_SPOT_DIRECTION";
                case 0x1205:
                    return "GL_SPOT_EXPONENT";
                case 0x1206:
                    return "GL_SPOT_CUTOFF";
                case 0x1207:
                    return "GL_CONSTANT_ATTENUATION";
                case 0x1208:
                    return "GL_LINEAR_ATTENUATION";
                case 0x1209:
                    return "GL_QUADRATIC_ATTENUATION";
                case 0x1300:
                    return "GL_COMPILE";
                case 0x1301:
                    return "GL_COMPILE_AND_EXECUTE";
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x1407:
                    return "GL_2_BYTES";
                case 0x1408:
                    return "GL_3_BYTES";
                case 0x1409:
                    return "GL_4_BYTES";
                case 0x140A:
                    return "GL_DOUBLE";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x140C:
                    return "GL_FIXED";
                case 0x1500:
                    return "GL_CLEAR";
                case 0x1501:
                    return "GL_AND";
                case 0x1502:
                    return "GL_AND_REVERSE";
                case 0x1503:
                    return "GL_COPY";
                case 0x1504:
                    return "GL_AND_INVERTED";
                case 0x1505:
                    return "GL_NOOP";
                case 0x1506:
                    return "GL_XOR";
                case 0x1507:
                    return "GL_OR";
                case 0x1508:
                    return "GL_NOR";
                case 0x1509:
                    return "GL_EQUIV";
                case 0x150A:
                    return "GL_INVERT";
                case 0x150B:
                    return "GL_OR_REVERSE";
                case 0x150C:
                    return "GL_COPY_INVERTED";
                case 0x150D:
                    return "GL_OR_INVERTED";
                case 0x150E:
                    return "GL_NAND";
                case 0x150F:
                    return "GL_SET";
                case 0x1600:
                    return "GL_EMISSION";
                case 0x1601:
                    return "GL_SHININESS";
                case 0x1602:
                    return "GL_AMBIENT_AND_DIFFUSE";
                case 0x1603:
                    return "GL_COLOR_INDEXES";
                case 0x1700:
                    return "GL_MODELVIEW";
                case 0x1701:
                    return "GL_PROJECTION";
                case 0x1702:
                    return "GL_TEXTURE";
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                case 0x1900:
                    return "GL_COLOR_INDEX";
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190A:
                    return "GL_LUMINANCE_ALPHA";
                case 0x1A00:
                    return "GL_BITMAP";
                case 0x1B00:
                    return "GL_POINT";
                case 0x1B01:
                    return "GL_LINE";
                case 0x1B02:
                    return "GL_FILL";
                case 0x1C00:
                    return "GL_RENDER";
                case 0x1C01:
                    return "GL_FEEDBACK";
                case 0x1C02:
                    return "GL_SELECT";
                case 0x1D00:
                    return "GL_FLAT";
                case 0x1D01:
                    return "GL_SMOOTH";
                case 0x1E00:
                    return "GL_KEEP";
                case 0x1E01:
                    return "GL_REPLACE";
                case 0x1E02:
                    return "GL_INCR";
                case 0x1E03:
                    return "GL_DECR";
                case 0x1F00:
                    return "GL_VENDOR";
                case 0x1F01:
                    return "GL_RENDERER";
                case 0x1F02:
                    return "GL_VERSION";
                case 0x1F03:
                    return "GL_EXTENSIONS";
                case 0x2000:
                    return "GL_S";
                case 0x2001:
                    return "GL_T";
                case 0x2002:
                    return "GL_R";
                case 0x2003:
                    return "GL_Q";
                case 0x2100:
                    return "GL_MODULATE";
                case 0x2101:
                    return "GL_DECAL";
                case 0x2200:
                    return "GL_TEXTURE_ENV_MODE";
                case 0x2201:
                    return "GL_TEXTURE_ENV_COLOR";
                case 0x2300:
                    return "GL_TEXTURE_ENV";
                case 0x2400:
                    return "GL_EYE_LINEAR";
                case 0x2401:
                    return "GL_OBJECT_LINEAR";
                case 0x2402:
                    return "GL_SPHERE_MAP";
                case 0x2500:
                    return "GL_TEXTURE_GEN_MODE";
                case 0x2501:
                    return "GL_OBJECT_PLANE";
                case 0x2502:
                    return "GL_EYE_PLANE";
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                case 0x2700:
                    return "GL_NEAREST_MIPMAP_NEAREST";
                case 0x2701:
                    return "GL_LINEAR_MIPMAP_NEAREST";
                case 0x2702:
                    return "GL_NEAREST_MIPMAP_LINEAR";
                case 0x2703:
                    return "GL_LINEAR_MIPMAP_LINEAR";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x2900:
                    return "GL_CLAMP";
                case 0x2901:
                    return "GL_REPEAT";
                case 0x2A00:
                    return "GL_POLYGON_OFFSET_UNITS";
                case 0x2A01:
                    return "GL_POLYGON_OFFSET_POINT";
                case 0x2A02:
                    return "GL_POLYGON_OFFSET_LINE";
                case 0x2A10:
                    return "GL_R3_G3_B2";
                case 0x2A20:
                    return "GL_V2F";
                case 0x2A21:
                    return "GL_V3F";
                case 0x2A22:
                    return "GL_C4UB_V2F";
                case 0x2A23:
                    return "GL_C4UB_V3F";
                case 0x2A24:
                    return "GL_C3F_V3F";
                case 0x2A25:
                    return "GL_N3F_V3F";
                case 0x2A26:
                    return "GL_C4F_N3F_V3F";
                case 0x2A27:
                    return "GL_T2F_V3F";
                case 0x2A28:
                    return "GL_T4F_V4F";
                case 0x2A29:
                    return "GL_T2F_C4UB_V3F";
                case 0x2A2A:
                    return "GL_T2F_C3F_V3F";
                case 0x2A2B:
                    return "GL_T2F_N3F_V3F";
                case 0x2A2C:
                    return "GL_T2F_C4F_N3F_V3F";
                case 0x2A2D:
                    return "GL_T4F_C4F_N3F_V4F";
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                case 0x3006:
                    return "GL_CLIP_DISTANCE6";
                case 0x3007:
                    return "GL_CLIP_DISTANCE7";
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                case 0x8000:
                    return "GL_HINT_BIT";
                case 0x8001:
                    return "GL_CONSTANT_COLOR";
                case 0x8002:
                    return "GL_ONE_MINUS_CONSTANT_COLOR";
                case 0x8003:
                    return "GL_CONSTANT_ALPHA";
                case 0x8004:
                    return "GL_ONE_MINUS_CONSTANT_ALPHA";
                case 0x8005:
                    return "GL_BLEND_COLOR";
                case 0x8006:
                    return "GL_FUNC_ADD";
                case 0x8007:
                    return "GL_MIN";
                case 0x8008:
                    return "GL_MAX";
                case 0x8009:
                    return "GL_BLEND_EQUATION";
                case 0x800A:
                    return "GL_FUNC_SUBTRACT";
                case 0x800B:
                    return "GL_FUNC_REVERSE_SUBTRACT";
                case 0x8010:
                    return "GL_CONVOLUTION_1D";
                case 0x8011:
                    return "GL_CONVOLUTION_2D";
                case 0x8012:
                    return "GL_SEPARABLE_2D";
                case 0x8024:
                    return "GL_HISTOGRAM";
                case 0x8025:
                    return "GL_PROXY_HISTOGRAM";
                case 0x802E:
                    return "GL_MINMAX";
                case 0x8032:
                    return "GL_UNSIGNED_BYTE_3_3_2";
                case 0x8033:
                    return "GL_UNSIGNED_SHORT_4_4_4_4";
                case 0x8034:
                    return "GL_UNSIGNED_SHORT_5_5_5_1";
                case 0x8035:
                    return "GL_UNSIGNED_INT_8_8_8_8";
                case 0x8036:
                    return "GL_UNSIGNED_INT_10_10_10_2";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8038:
                    return "GL_POLYGON_OFFSET_FACTOR";
                case 0x803A:
                    return "GL_RESCALE_NORMAL";
                case 0x803B:
                    return "GL_ALPHA4";
                case 0x803C:
                    return "GL_ALPHA8";
                case 0x803D:
                    return "GL_ALPHA12";
                case 0x803E:
                    return "GL_ALPHA16";
                case 0x803F:
                    return "GL_LUMINANCE4";
                case 0x8040:
                    return "GL_LUMINANCE8";
                case 0x8041:
                    return "GL_LUMINANCE12";
                case 0x8042:
                    return "GL_LUMINANCE16";
                case 0x8043:
                    return "GL_LUMINANCE4_ALPHA4";
                case 0x8044:
                    return "GL_LUMINANCE6_ALPHA2";
                case 0x8045:
                    return "GL_LUMINANCE8_ALPHA8";
                case 0x8046:
                    return "GL_LUMINANCE12_ALPHA4";
                case 0x8047:
                    return "GL_LUMINANCE12_ALPHA12";
                case 0x8048:
                    return "GL_LUMINANCE16_ALPHA16";
                case 0x8049:
                    return "GL_INTENSITY";
                case 0x804A:
                    return "GL_INTENSITY4";
                case 0x804B:
                    return "GL_INTENSITY8";
                case 0x804C:
                    return "GL_INTENSITY12";
                case 0x804D:
                    return "GL_INTENSITY16";
                case 0x804F:
                    return "GL_RGB4";
                case 0x8050:
                    return "GL_RGB5";
                case 0x8051:
                    return "GL_RGB8";
                case 0x8052:
                    return "GL_RGB10";
                case 0x8053:
                    return "GL_RGB12";
                case 0x8054:
                    return "GL_RGB16";
                case 0x8055:
                    return "GL_RGBA2";
                case 0x8056:
                    return "GL_RGBA4";
                case 0x8057:
                    return "GL_RGB5_A1";
                case 0x8058:
                    return "GL_RGBA8";
                case 0x8059:
                    return "GL_RGB10_A2";
                case 0x805A:
                    return "GL_RGBA12";
                case 0x805B:
                    return "GL_RGBA16";
                case 0x805C:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805D:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805E:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805F:
                    return "GL_TEXTURE_ALPHA_SIZE";
                case 0x8060:
                    return "GL_TEXTURE_LUMINANCE_SIZE";
                case 0x8061:
                    return "GL_TEXTURE_INTENSITY_SIZE";
                case 0x8063:
                    return "GL_PROXY_TEXTURE_1D";
                case 0x8064:
                    return "GL_PROXY_TEXTURE_2D";
                case 0x8066:
                    return "GL_TEXTURE_PRIORITY";
                case 0x8067:
                    return "GL_TEXTURE_RESIDENT";
                case 0x8068:
                    return "GL_TEXTURE_BINDING_1D";
                case 0x8069:
                    return "GL_TEXTURE_BINDING_2D";
                case 0x806A:
                    return "GL_TEXTURE_BINDING_3D";
                case 0x806B:
                    return "GL_PACK_SKIP_IMAGES";
                case 0x806C:
                    return "GL_PACK_IMAGE_HEIGHT";
                case 0x806D:
                    return "GL_UNPACK_SKIP_IMAGES";
                case 0x806E:
                    return "GL_UNPACK_IMAGE_HEIGHT";
                case 0x806F:
                    return "GL_TEXTURE_3D";
                case 0x8070:
                    return "GL_PROXY_TEXTURE_3D";
                case 0x8071:
                    return "GL_TEXTURE_DEPTH";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x8073:
                    return "GL_MAX_3D_TEXTURE_SIZE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x8075:
                    return "GL_NORMAL_ARRAY";
                case 0x8076:
                    return "GL_COLOR_ARRAY";
                case 0x8077:
                    return "GL_INDEX_ARRAY";
                case 0x8078:
                    return "GL_TEXTURE_COORD_ARRAY";
                case 0x8079:
                    return "GL_EDGE_FLAG_ARRAY";
                case 0x807A:
                    return "GL_VERTEX_ARRAY_SIZE";
                case 0x807B:
                    return "GL_VERTEX_ARRAY_TYPE";
                case 0x807C:
                    return "GL_VERTEX_ARRAY_STRIDE";
                case 0x807E:
                    return "GL_NORMAL_ARRAY_TYPE";
                case 0x807F:
                    return "GL_NORMAL_ARRAY_STRIDE";
                case 0x8081:
                    return "GL_COLOR_ARRAY_SIZE";
                case 0x8082:
                    return "GL_COLOR_ARRAY_TYPE";
                case 0x8083:
                    return "GL_COLOR_ARRAY_STRIDE";
                case 0x8085:
                    return "GL_INDEX_ARRAY_TYPE";
                case 0x8086:
                    return "GL_INDEX_ARRAY_STRIDE";
                case 0x8088:
                    return "GL_TEXTURE_COORD_ARRAY_SIZE";
                case 0x8089:
                    return "GL_TEXTURE_COORD_ARRAY_TYPE";
                case 0x808A:
                    return "GL_TEXTURE_COORD_ARRAY_STRIDE";
                case 0x808C:
                    return "GL_EDGE_FLAG_ARRAY_STRIDE";
                case 0x808E:
                    return "GL_VERTEX_ARRAY_POINTER";
                case 0x808F:
                    return "GL_NORMAL_ARRAY_POINTER";
                case 0x8090:
                    return "GL_COLOR_ARRAY_POINTER";
                case 0x8091:
                    return "GL_INDEX_ARRAY_POINTER";
                case 0x8092:
                    return "GL_TEXTURE_COORD_ARRAY_POINTER";
                case 0x8093:
                    return "GL_EDGE_FLAG_ARRAY_POINTER";
                case 0x809D:
                    return "GL_MULTISAMPLE";
                case 0x809E:
                    return "GL_SAMPLE_ALPHA_TO_COVERAGE";
                case 0x809F:
                    return "GL_SAMPLE_ALPHA_TO_ONE";
                case 0x80A0:
                    return "GL_SAMPLE_COVERAGE";
                case 0x80A8:
                    return "GL_SAMPLE_BUFFERS";
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x80AA:
                    return "GL_SAMPLE_COVERAGE_VALUE";
                case 0x80AB:
                    return "GL_SAMPLE_COVERAGE_INVERT";
                case 0x80C8:
                    return "GL_BLEND_DST_RGB";
                case 0x80C9:
                    return "GL_BLEND_SRC_RGB";
                case 0x80CA:
                    return "GL_BLEND_DST_ALPHA";
                case 0x80CB:
                    return "GL_BLEND_SRC_ALPHA";
                case 0x80D0:
                    return "GL_COLOR_TABLE";
                case 0x80D1:
                    return "GL_POST_CONVOLUTION_COLOR_TABLE";
                case 0x80D2:
                    return "GL_POST_COLOR_MATRIX_COLOR_TABLE";
                case 0x80D3:
                    return "GL_PROXY_COLOR_TABLE";
                case 0x80D4:
                    return "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE";
                case 0x80D5:
                    return "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE";
                case 0x80E0:
                    return "GL_BGR";
                case 0x80E1:
                    return "GL_BGRA";
                case 0x80E8:
                    return "GL_MAX_ELEMENTS_VERTICES";
                case 0x80E9:
                    return "GL_MAX_ELEMENTS_INDICES";
                case 0x80EE:
                    return "GL_PARAMETER_BUFFER";
                case 0x80EF:
                    return "GL_PARAMETER_BUFFER_BINDING";
                case 0x8126:
                    return "GL_POINT_SIZE_MIN";
                case 0x8127:
                    return "GL_POINT_SIZE_MAX";
                case 0x8128:
                    return "GL_POINT_FADE_THRESHOLD_SIZE";
                case 0x8129:
                    return "GL_POINT_DISTANCE_ATTENUATION";
                case 0x812D:
                    return "GL_CLAMP_TO_BORDER";
                case 0x812F:
                    return "GL_CLAMP_TO_EDGE";
                case 0x813A:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813B:
                    return "GL_TEXTURE_MAX_LOD";
                case 0x813C:
                    return "GL_TEXTURE_BASE_LEVEL";
                case 0x813D:
                    return "GL_TEXTURE_MAX_LEVEL";
                case 0x8191:
                    return "GL_GENERATE_MIPMAP";
                case 0x8192:
                    return "GL_GENERATE_MIPMAP_HINT";
                case 0x81A5:
                    return "GL_DEPTH_COMPONENT16";
                case 0x81A6:
                    return "GL_DEPTH_COMPONENT24";
                case 0x81A7:
                    return "GL_DEPTH_COMPONENT32";
                case 0x81F8:
                    return "GL_LIGHT_MODEL_COLOR_CONTROL";
                case 0x81F9:
                    return "GL_SINGLE_COLOR";
                case 0x81FA:
                    return "GL_SEPARATE_SPECULAR_COLOR";
                case 0x8210:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING";
                case 0x8211:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE";
                case 0x8212:
                    return "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE";
                case 0x8213:
                    return "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE";
                case 0x8214:
                    return "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE";
                case 0x8215:
                    return "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE";
                case 0x8216:
                    return "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE";
                case 0x8217:
                    return "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE";
                case 0x8218:
                    return "GL_FRAMEBUFFER_DEFAULT";
                case 0x8219:
                    return "GL_FRAMEBUFFER_UNDEFINED";
                case 0x821A:
                    return "GL_DEPTH_STENCIL_ATTACHMENT";
                case 0x821B:
                    return "GL_MAJOR_VERSION";
                case 0x821C:
                    return "GL_MINOR_VERSION";
                case 0x821D:
                    return "GL_NUM_EXTENSIONS";
                case 0x821E:
                    return "GL_CONTEXT_FLAGS";
                case 0x821F:
                    return "GL_BUFFER_IMMUTABLE_STORAGE";
                case 0x8220:
                    return "GL_BUFFER_STORAGE_FLAGS";
                case 0x8221:
                    return "GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED";
                case 0x8222:
                    return "GL_INDEX";
                case 0x8225:
                    return "GL_COMPRESSED_RED";
                case 0x8226:
                    return "GL_COMPRESSED_RG";
                case 0x8227:
                    return "GL_RG";
                case 0x8228:
                    return "GL_RG_INTEGER";
                case 0x8229:
                    return "GL_R8";
                case 0x822A:
                    return "GL_R16";
                case 0x822B:
                    return "GL_RG8";
                case 0x822C:
                    return "GL_RG16";
                case 0x822D:
                    return "GL_R16F";
                case 0x822E:
                    return "GL_R32F";
                case 0x822F:
                    return "GL_RG16F";
                case 0x8230:
                    return "GL_RG32F";
                case 0x8231:
                    return "GL_R8I";
                case 0x8232:
                    return "GL_R8UI";
                case 0x8233:
                    return "GL_R16I";
                case 0x8234:
                    return "GL_R16UI";
                case 0x8235:
                    return "GL_R32I";
                case 0x8236:
                    return "GL_R32UI";
                case 0x8237:
                    return "GL_RG8I";
                case 0x8238:
                    return "GL_RG8UI";
                case 0x8239:
                    return "GL_RG16I";
                case 0x823A:
                    return "GL_RG16UI";
                case 0x823B:
                    return "GL_RG32I";
                case 0x823C:
                    return "GL_RG32UI";
                case 0x8242:
                    return "GL_DEBUG_OUTPUT_SYNCHRONOUS";
                case 0x8243:
                    return "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH";
                case 0x8244:
                    return "GL_DEBUG_CALLBACK_FUNCTION";
                case 0x8245:
                    return "GL_DEBUG_CALLBACK_USER_PARAM";
                case 0x8246:
                    return "GL_DEBUG_SOURCE_API";
                case 0x8247:
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM";
                case 0x8248:
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER";
                case 0x8249:
                    return "GL_DEBUG_SOURCE_THIRD_PARTY";
                case 0x824A:
                    return "GL_DEBUG_SOURCE_APPLICATION";
                case 0x824B:
                    return "GL_DEBUG_SOURCE_OTHER";
                case 0x824C:
                    return "GL_DEBUG_TYPE_ERROR";
                case 0x824D:
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR";
                case 0x824E:
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR";
                case 0x824F:
                    return "GL_DEBUG_TYPE_PORTABILITY";
                case 0x8250:
                    return "GL_DEBUG_TYPE_PERFORMANCE";
                case 0x8251:
                    return "GL_DEBUG_TYPE_OTHER";
                case 0x8252:
                    return "GL_LOSE_CONTEXT_ON_RESET";
                case 0x8253:
                    return "GL_GUILTY_CONTEXT_RESET";
                case 0x8254:
                    return "GL_INNOCENT_CONTEXT_RESET";
                case 0x8255:
                    return "GL_UNKNOWN_CONTEXT_RESET";
                case 0x8256:
                    return "GL_RESET_NOTIFICATION_STRATEGY";
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x8258:
                    return "GL_PROGRAM_SEPARABLE";
                case 0x8259:
                    return "GL_ACTIVE_PROGRAM";
                case 0x825A:
                    return "GL_PROGRAM_PIPELINE_BINDING";
                case 0x825B:
                    return "GL_MAX_VIEWPORTS";
                case 0x825C:
                    return "GL_VIEWPORT_SUBPIXEL_BITS";
                case 0x825D:
                    return "GL_VIEWPORT_BOUNDS_RANGE";
                case 0x825E:
                    return "GL_LAYER_PROVOKING_VERTEX";
                case 0x825F:
                    return "GL_VIEWPORT_INDEX_PROVOKING_VERTEX";
                case 0x8260:
                    return "GL_UNDEFINED_VERTEX";
                case 0x8261:
                    return "GL_NO_RESET_NOTIFICATION";
                case 0x8262:
                    return "GL_MAX_COMPUTE_SHARED_MEMORY_SIZE";
                case 0x8263:
                    return "GL_MAX_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8264:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS";
                case 0x8265:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTERS";
                case 0x8266:
                    return "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8267:
                    return "GL_COMPUTE_WORK_GROUP_SIZE";
                case 0x8268:
                    return "GL_DEBUG_TYPE_MARKER";
                case 0x8269:
                    return "GL_DEBUG_TYPE_PUSH_GROUP";
                case 0x826A:
                    return "GL_DEBUG_TYPE_POP_GROUP";
                case 0x826B:
                    return "GL_DEBUG_SEVERITY_NOTIFICATION";
                case 0x826C:
                    return "GL_MAX_DEBUG_GROUP_STACK_DEPTH";
                case 0x826D:
                    return "GL_DEBUG_GROUP_STACK_DEPTH";
                case 0x826E:
                    return "GL_MAX_UNIFORM_LOCATIONS";
                case 0x826F:
                    return "GL_INTERNALFORMAT_SUPPORTED";
                case 0x8270:
                    return "GL_INTERNALFORMAT_PREFERRED";
                case 0x8271:
                    return "GL_INTERNALFORMAT_RED_SIZE";
                case 0x8272:
                    return "GL_INTERNALFORMAT_GREEN_SIZE";
                case 0x8273:
                    return "GL_INTERNALFORMAT_BLUE_SIZE";
                case 0x8274:
                    return "GL_INTERNALFORMAT_ALPHA_SIZE";
                case 0x8275:
                    return "GL_INTERNALFORMAT_DEPTH_SIZE";
                case 0x8276:
                    return "GL_INTERNALFORMAT_STENCIL_SIZE";
                case 0x8277:
                    return "GL_INTERNALFORMAT_SHARED_SIZE";
                case 0x8278:
                    return "GL_INTERNALFORMAT_RED_TYPE";
                case 0x8279:
                    return "GL_INTERNALFORMAT_GREEN_TYPE";
                case 0x827A:
                    return "GL_INTERNALFORMAT_BLUE_TYPE";
                case 0x827B:
                    return "GL_INTERNALFORMAT_ALPHA_TYPE";
                case 0x827C:
                    return "GL_INTERNALFORMAT_DEPTH_TYPE";
                case 0x827D:
                    return "GL_INTERNALFORMAT_STENCIL_TYPE";
                case 0x827E:
                    return "GL_MAX_WIDTH";
                case 0x827F:
                    return "GL_MAX_HEIGHT";
                case 0x8280:
                    return "GL_MAX_DEPTH";
                case 0x8281:
                    return "GL_MAX_LAYERS";
                case 0x8282:
                    return "GL_MAX_COMBINED_DIMENSIONS";
                case 0x8283:
                    return "GL_COLOR_COMPONENTS";
                case 0x8284:
                    return "GL_DEPTH_COMPONENTS";
                case 0x8285:
                    return "GL_STENCIL_COMPONENTS";
                case 0x8286:
                    return "GL_COLOR_RENDERABLE";
                case 0x8287:
                    return "GL_DEPTH_RENDERABLE";
                case 0x8288:
                    return "GL_STENCIL_RENDERABLE";
                case 0x8289:
                    return "GL_FRAMEBUFFER_RENDERABLE";
                case 0x828A:
                    return "GL_FRAMEBUFFER_RENDERABLE_LAYERED";
                case 0x828B:
                    return "GL_FRAMEBUFFER_BLEND";
                case 0x828C:
                    return "GL_READ_PIXELS";
                case 0x828D:
                    return "GL_READ_PIXELS_FORMAT";
                case 0x828E:
                    return "GL_READ_PIXELS_TYPE";
                case 0x828F:
                    return "GL_TEXTURE_IMAGE_FORMAT";
                case 0x8290:
                    return "GL_TEXTURE_IMAGE_TYPE";
                case 0x8291:
                    return "GL_GET_TEXTURE_IMAGE_FORMAT";
                case 0x8292:
                    return "GL_GET_TEXTURE_IMAGE_TYPE";
                case 0x8293:
                    return "GL_MIPMAP";
                case 0x8294:
                    return "GL_MANUAL_GENERATE_MIPMAP";
                case 0x8295:
                    return "GL_AUTO_GENERATE_MIPMAP";
                case 0x8296:
                    return "GL_COLOR_ENCODING";
                case 0x8297:
                    return "GL_SRGB_READ";
                case 0x8298:
                    return "GL_SRGB_WRITE";
                case 0x829A:
                    return "GL_FILTER";
                case 0x829B:
                    return "GL_VERTEX_TEXTURE";
                case 0x829C:
                    return "GL_TESS_CONTROL_TEXTURE";
                case 0x829D:
                    return "GL_TESS_EVALUATION_TEXTURE";
                case 0x829E:
                    return "GL_GEOMETRY_TEXTURE";
                case 0x829F:
                    return "GL_FRAGMENT_TEXTURE";
                case 0x82A0:
                    return "GL_COMPUTE_TEXTURE";
                case 0x82A1:
                    return "GL_TEXTURE_SHADOW";
                case 0x82A2:
                    return "GL_TEXTURE_GATHER";
                case 0x82A3:
                    return "GL_TEXTURE_GATHER_SHADOW";
                case 0x82A4:
                    return "GL_SHADER_IMAGE_LOAD";
                case 0x82A5:
                    return "GL_SHADER_IMAGE_STORE";
                case 0x82A6:
                    return "GL_SHADER_IMAGE_ATOMIC";
                case 0x82A7:
                    return "GL_IMAGE_TEXEL_SIZE";
                case 0x82A8:
                    return "GL_IMAGE_COMPATIBILITY_CLASS";
                case 0x82A9:
                    return "GL_IMAGE_PIXEL_FORMAT";
                case 0x82AA:
                    return "GL_IMAGE_PIXEL_TYPE";
                case 0x82AC:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST";
                case 0x82AD:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST";
                case 0x82AE:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE";
                case 0x82AF:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE";
                case 0x82B1:
                    return "GL_TEXTURE_COMPRESSED_BLOCK_WIDTH";
                case 0x82B2:
                    return "GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT";
                case 0x82B3:
                    return "GL_TEXTURE_COMPRESSED_BLOCK_SIZE";
                case 0x82B4:
                    return "GL_CLEAR_BUFFER";
                case 0x82B5:
                    return "GL_TEXTURE_VIEW";
                case 0x82B6:
                    return "GL_VIEW_COMPATIBILITY_CLASS";
                case 0x82B7:
                    return "GL_FULL_SUPPORT";
                case 0x82B8:
                    return "GL_CAVEAT_SUPPORT";
                case 0x82B9:
                    return "GL_IMAGE_CLASS_4_X_32";
                case 0x82BA:
                    return "GL_IMAGE_CLASS_2_X_32";
                case 0x82BB:
                    return "GL_IMAGE_CLASS_1_X_32";
                case 0x82BC:
                    return "GL_IMAGE_CLASS_4_X_16";
                case 0x82BD:
                    return "GL_IMAGE_CLASS_2_X_16";
                case 0x82BE:
                    return "GL_IMAGE_CLASS_1_X_16";
                case 0x82BF:
                    return "GL_IMAGE_CLASS_4_X_8";
                case 0x82C0:
                    return "GL_IMAGE_CLASS_2_X_8";
                case 0x82C1:
                    return "GL_IMAGE_CLASS_1_X_8";
                case 0x82C2:
                    return "GL_IMAGE_CLASS_11_11_10";
                case 0x82C3:
                    return "GL_IMAGE_CLASS_10_10_10_2";
                case 0x82C4:
                    return "GL_VIEW_CLASS_128_BITS";
                case 0x82C5:
                    return "GL_VIEW_CLASS_96_BITS";
                case 0x82C6:
                    return "GL_VIEW_CLASS_64_BITS";
                case 0x82C7:
                    return "GL_VIEW_CLASS_48_BITS";
                case 0x82C8:
                    return "GL_VIEW_CLASS_32_BITS";
                case 0x82C9:
                    return "GL_VIEW_CLASS_24_BITS";
                case 0x82CA:
                    return "GL_VIEW_CLASS_16_BITS";
                case 0x82CB:
                    return "GL_VIEW_CLASS_8_BITS";
                case 0x82CC:
                    return "GL_VIEW_CLASS_S3TC_DXT1_RGB";
                case 0x82CD:
                    return "GL_VIEW_CLASS_S3TC_DXT1_RGBA";
                case 0x82CE:
                    return "GL_VIEW_CLASS_S3TC_DXT3_RGBA";
                case 0x82CF:
                    return "GL_VIEW_CLASS_S3TC_DXT5_RGBA";
                case 0x82D0:
                    return "GL_VIEW_CLASS_RGTC1_RED";
                case 0x82D1:
                    return "GL_VIEW_CLASS_RGTC2_RG";
                case 0x82D2:
                    return "GL_VIEW_CLASS_BPTC_UNORM";
                case 0x82D3:
                    return "GL_VIEW_CLASS_BPTC_FLOAT";
                case 0x82D4:
                    return "GL_VERTEX_ATTRIB_BINDING";
                case 0x82D5:
                    return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x82D6:
                    return "GL_VERTEX_BINDING_DIVISOR";
                case 0x82D7:
                    return "GL_VERTEX_BINDING_OFFSET";
                case 0x82D8:
                    return "GL_VERTEX_BINDING_STRIDE";
                case 0x82D9:
                    return "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x82DA:
                    return "GL_MAX_VERTEX_ATTRIB_BINDINGS";
                case 0x82DB:
                    return "GL_TEXTURE_VIEW_MIN_LEVEL";
                case 0x82DC:
                    return "GL_TEXTURE_VIEW_NUM_LEVELS";
                case 0x82DD:
                    return "GL_TEXTURE_VIEW_MIN_LAYER";
                case 0x82DE:
                    return "GL_TEXTURE_VIEW_NUM_LAYERS";
                case 0x82DF:
                    return "GL_TEXTURE_IMMUTABLE_LEVELS";
                case 0x82E0:
                    return "GL_BUFFER";
                case 0x82E1:
                    return "GL_SHADER";
                case 0x82E2:
                    return "GL_PROGRAM";
                case 0x82E3:
                    return "GL_QUERY";
                case 0x82E4:
                    return "GL_PROGRAM_PIPELINE";
                case 0x82E5:
                    return "GL_MAX_VERTEX_ATTRIB_STRIDE";
                case 0x82E6:
                    return "GL_SAMPLER";
                case 0x82E7:
                    return "GL_DISPLAY_LIST";
                case 0x82E8:
                    return "GL_MAX_LABEL_LENGTH";
                case 0x82E9:
                    return "GL_NUM_SHADING_LANGUAGE_VERSIONS";
                case 0x82EA:
                    return "GL_QUERY_TARGET";
                case 0x82EC:
                    return "GL_TRANSFORM_FEEDBACK_OVERFLOW";
                case 0x82ED:
                    return "GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW";
                case 0x82EE:
                    return "GL_VERTICES_SUBMITTED";
                case 0x82EF:
                    return "GL_PRIMITIVES_SUBMITTED";
                case 0x82F0:
                    return "GL_VERTEX_SHADER_INVOCATIONS";
                case 0x82F1:
                    return "GL_TESS_CONTROL_SHADER_PATCHES";
                case 0x82F2:
                    return "GL_TESS_EVALUATION_SHADER_INVOCATIONS";
                case 0x82F3:
                    return "GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED";
                case 0x82F4:
                    return "GL_FRAGMENT_SHADER_INVOCATIONS";
                case 0x82F5:
                    return "GL_COMPUTE_SHADER_INVOCATIONS";
                case 0x82F6:
                    return "GL_CLIPPING_INPUT_PRIMITIVES";
                case 0x82F7:
                    return "GL_CLIPPING_OUTPUT_PRIMITIVES";
                case 0x82F9:
                    return "GL_MAX_CULL_DISTANCES";
                case 0x82FA:
                    return "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES";
                case 0x82FB:
                    return "GL_CONTEXT_RELEASE_BEHAVIOR";
                case 0x82FC:
                    return "GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH";
                case 0x8362:
                    return "GL_UNSIGNED_BYTE_2_3_3_REV";
                case 0x8363:
                    return "GL_UNSIGNED_SHORT_5_6_5";
                case 0x8364:
                    return "GL_UNSIGNED_SHORT_5_6_5_REV";
                case 0x8365:
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV";
                case 0x8366:
                    return "GL_UNSIGNED_SHORT_1_5_5_5_REV";
                case 0x8367:
                    return "GL_UNSIGNED_INT_8_8_8_8_REV";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8370:
                    return "GL_MIRRORED_REPEAT";
                case 0x83F0:
                    return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
                case 0x83F1:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
                case 0x83F2:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
                case 0x83F3:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
                case 0x8450:
                    return "GL_FOG_COORD_SRC";
                case 0x8451:
                    return "GL_FOG_COORD";
                case 0x8452:
                    return "GL_FRAGMENT_DEPTH";
                case 0x8453:
                    return "GL_CURRENT_FOG_COORD";
                case 0x8454:
                    return "GL_FOG_COORD_ARRAY_TYPE";
                case 0x8455:
                    return "GL_FOG_COORD_ARRAY_STRIDE";
                case 0x8456:
                    return "GL_FOG_COORD_ARRAY_POINTER";
                case 0x8457:
                    return "GL_FOG_COORD_ARRAY";
                case 0x8458:
                    return "GL_COLOR_SUM";
                case 0x8459:
                    return "GL_CURRENT_SECONDARY_COLOR";
                case 0x845A:
                    return "GL_SECONDARY_COLOR_ARRAY_SIZE";
                case 0x845B:
                    return "GL_SECONDARY_COLOR_ARRAY_TYPE";
                case 0x845C:
                    return "GL_SECONDARY_COLOR_ARRAY_STRIDE";
                case 0x845D:
                    return "GL_SECONDARY_COLOR_ARRAY_POINTER";
                case 0x845E:
                    return "GL_SECONDARY_COLOR_ARRAY";
                case 0x845F:
                    return "GL_CURRENT_RASTER_SECONDARY_COLOR";
                case 0x846D:
                    return "GL_ALIASED_POINT_SIZE_RANGE";
                case 0x846E:
                    return "GL_ALIASED_LINE_WIDTH_RANGE";
                case 0x84C0:
                    return "GL_TEXTURE0";
                case 0x84C1:
                    return "GL_TEXTURE1";
                case 0x84C2:
                    return "GL_TEXTURE2";
                case 0x84C3:
                    return "GL_TEXTURE3";
                case 0x84C4:
                    return "GL_TEXTURE4";
                case 0x84C5:
                    return "GL_TEXTURE5";
                case 0x84C6:
                    return "GL_TEXTURE6";
                case 0x84C7:
                    return "GL_TEXTURE7";
                case 0x84C8:
                    return "GL_TEXTURE8";
                case 0x84C9:
                    return "GL_TEXTURE9";
                case 0x84CA:
                    return "GL_TEXTURE10";
                case 0x84CB:
                    return "GL_TEXTURE11";
                case 0x84CC:
                    return "GL_TEXTURE12";
                case 0x84CD:
                    return "GL_TEXTURE13";
                case 0x84CE:
                    return "GL_TEXTURE14";
                case 0x84CF:
                    return "GL_TEXTURE15";
                case 0x84D0:
                    return "GL_TEXTURE16";
                case 0x84D1:
                    return "GL_TEXTURE17";
                case 0x84D2:
                    return "GL_TEXTURE18";
                case 0x84D3:
                    return "GL_TEXTURE19";
                case 0x84D4:
                    return "GL_TEXTURE20";
                case 0x84D5:
                    return "GL_TEXTURE21";
                case 0x84D6:
                    return "GL_TEXTURE22";
                case 0x84D7:
                    return "GL_TEXTURE23";
                case 0x84D8:
                    return "GL_TEXTURE24";
                case 0x84D9:
                    return "GL_TEXTURE25";
                case 0x84DA:
                    return "GL_TEXTURE26";
                case 0x84DB:
                    return "GL_TEXTURE27";
                case 0x84DC:
                    return "GL_TEXTURE28";
                case 0x84DD:
                    return "GL_TEXTURE29";
                case 0x84DE:
                    return "GL_TEXTURE30";
                case 0x84DF:
                    return "GL_TEXTURE31";
                case 0x84E0:
                    return "GL_ACTIVE_TEXTURE";
                case 0x84E1:
                    return "GL_CLIENT_ACTIVE_TEXTURE";
                case 0x84E2:
                    return "GL_MAX_TEXTURE_UNITS";
                case 0x84E3:
                    return "GL_TRANSPOSE_MODELVIEW_MATRIX";
                case 0x84E4:
                    return "GL_TRANSPOSE_PROJECTION_MATRIX";
                case 0x84E5:
                    return "GL_TRANSPOSE_TEXTURE_MATRIX";
                case 0x84E6:
                    return "GL_TRANSPOSE_COLOR_MATRIX";
                case 0x84E7:
                    return "GL_SUBTRACT";
                case 0x84E8:
                    return "GL_MAX_RENDERBUFFER_SIZE";
                case 0x84E9:
                    return "GL_COMPRESSED_ALPHA";
                case 0x84EA:
                    return "GL_COMPRESSED_LUMINANCE";
                case 0x84EB:
                    return "GL_COMPRESSED_LUMINANCE_ALPHA";
                case 0x84EC:
                    return "GL_COMPRESSED_INTENSITY";
                case 0x84ED:
                    return "GL_COMPRESSED_RGB";
                case 0x84EE:
                    return "GL_COMPRESSED_RGBA";
                case 0x84EF:
                    return "GL_TEXTURE_COMPRESSION_HINT";
                case 0x84F0:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x84F1:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x84F2:
                    return "GL_ALL_COMPLETED_NV";
                case 0x84F3:
                    return "GL_FENCE_STATUS_NV";
                case 0x84F4:
                    return "GL_FENCE_CONDITION_NV";
                case 0x84F5:
                    return "GL_TEXTURE_RECTANGLE";
                case 0x84F6:
                    return "GL_TEXTURE_BINDING_RECTANGLE";
                case 0x84F7:
                    return "GL_PROXY_TEXTURE_RECTANGLE";
                case 0x84F8:
                    return "GL_MAX_RECTANGLE_TEXTURE_SIZE";
                case 0x84F9:
                    return "GL_DEPTH_STENCIL";
                case 0x84FA:
                    return "GL_UNSIGNED_INT_24_8";
                case 0x84FD:
                    return "GL_MAX_TEXTURE_LOD_BIAS";
                case 0x84FE:
                    return "GL_TEXTURE_MAX_ANISOTROPY";
                case 0x84FF:
                    return "GL_MAX_TEXTURE_MAX_ANISOTROPY";
                case 0x8500:
                    return "GL_TEXTURE_FILTER_CONTROL";
                case 0x8501:
                    return "GL_TEXTURE_LOD_BIAS";
                case 0x8507:
                    return "GL_INCR_WRAP";
                case 0x8508:
                    return "GL_DECR_WRAP";
                case 0x8511:
                    return "GL_NORMAL_MAP";
                case 0x8512:
                    return "GL_REFLECTION_MAP";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8514:
                    return "GL_TEXTURE_BINDING_CUBE_MAP";
                case 0x8515:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X";
                case 0x8516:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X";
                case 0x8517:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y";
                case 0x8518:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y";
                case 0x8519:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z";
                case 0x851A:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z";
                case 0x851B:
                    return "GL_PROXY_TEXTURE_CUBE_MAP";
                case 0x851C:
                    return "GL_MAX_CUBE_MAP_TEXTURE_SIZE";
                case 0x8570:
                    return "GL_COMBINE";
                case 0x8571:
                    return "GL_COMBINE_RGB";
                case 0x8572:
                    return "GL_COMBINE_ALPHA";
                case 0x8573:
                    return "GL_RGB_SCALE";
                case 0x8574:
                    return "GL_ADD_SIGNED";
                case 0x8575:
                    return "GL_INTERPOLATE";
                case 0x8576:
                    return "GL_CONSTANT";
                case 0x8577:
                    return "GL_PRIMARY_COLOR";
                case 0x8578:
                    return "GL_PREVIOUS";
                case 0x8580:
                    return "GL_SRC0_RGB";
                case 0x8581:
                    return "GL_SRC1_RGB";
                case 0x8582:
                    return "GL_SRC2_RGB";
                case 0x8588:
                    return "GL_SRC0_ALPHA";
                case 0x8589:
                    return "GL_SRC1_ALPHA";
                case 0x858A:
                    return "GL_SRC2_ALPHA";
                case 0x8590:
                    return "GL_OPERAND0_RGB";
                case 0x8591:
                    return "GL_OPERAND1_RGB";
                case 0x8592:
                    return "GL_OPERAND2_RGB";
                case 0x8598:
                    return "GL_OPERAND0_ALPHA";
                case 0x8599:
                    return "GL_OPERAND1_ALPHA";
                case 0x859A:
                    return "GL_OPERAND2_ALPHA";
                case 0x85B5:
                    return "GL_VERTEX_ARRAY_BINDING";
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x8626:
                    return "GL_CURRENT_VERTEX_ATTRIB";
                case 0x8642:
                    return "GL_PROGRAM_POINT_SIZE";
                case 0x8643:
                    return "GL_VERTEX_PROGRAM_TWO_SIDE";
                case 0x8645:
                    return "GL_VERTEX_ATTRIB_ARRAY_POINTER";
                case 0x864F:
                    return "GL_DEPTH_CLAMP";
                case 0x86A0:
                    return "GL_TEXTURE_COMPRESSED_IMAGE_SIZE";
                case 0x86A1:
                    return "GL_TEXTURE_COMPRESSED";
                case 0x86A2:
                    return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
                case 0x86A3:
                    return "GL_COMPRESSED_TEXTURE_FORMATS";
                case 0x86AE:
                    return "GL_DOT3_RGB";
                case 0x86AF:
                    return "GL_DOT3_RGBA";
                case 0x8741:
                    return "GL_PROGRAM_BINARY_LENGTH";
                case 0x8743:
                    return "GL_MIRROR_CLAMP_TO_EDGE";
                case 0x874E:
                    return "GL_VERTEX_ATTRIB_ARRAY_LONG";
                case 0x8764:
                    return "GL_BUFFER_SIZE";
                case 0x8765:
                    return "GL_BUFFER_USAGE";
                case 0x87FE:
                    return "GL_NUM_PROGRAM_BINARY_FORMATS";
                case 0x87FF:
                    return "GL_PROGRAM_BINARY_FORMATS";
                case 0x8800:
                    return "GL_STENCIL_BACK_FUNC";
                case 0x8801:
                    return "GL_STENCIL_BACK_FAIL";
                case 0x8802:
                    return "GL_STENCIL_BACK_PASS_DEPTH_FAIL";
                case 0x8803:
                    return "GL_STENCIL_BACK_PASS_DEPTH_PASS";
                case 0x8814:
                    return "GL_RGBA32F";
                case 0x8815:
                    return "GL_RGB32F";
                case 0x8816:
                    return "GL_ALPHA32F_EXT";
                case 0x8818:
                    return "GL_LUMINANCE32F_EXT";
                case 0x8819:
                    return "GL_LUMINANCE_ALPHA32F_EXT";
                case 0x881A:
                    return "GL_RGBA16F";
                case 0x881B:
                    return "GL_RGB16F";
                case 0x881C:
                    return "GL_ALPHA16F_EXT";
                case 0x881E:
                    return "GL_LUMINANCE16F_EXT";
                case 0x881F:
                    return "GL_LUMINANCE_ALPHA16F_EXT";
                case 0x8824:
                    return "GL_MAX_DRAW_BUFFERS";
                case 0x8825:
                    return "GL_DRAW_BUFFER0";
                case 0x8826:
                    return "GL_DRAW_BUFFER1";
                case 0x8827:
                    return "GL_DRAW_BUFFER2";
                case 0x8828:
                    return "GL_DRAW_BUFFER3";
                case 0x8829:
                    return "GL_DRAW_BUFFER4";
                case 0x882A:
                    return "GL_DRAW_BUFFER5";
                case 0x882B:
                    return "GL_DRAW_BUFFER6";
                case 0x882C:
                    return "GL_DRAW_BUFFER7";
                case 0x882D:
                    return "GL_DRAW_BUFFER8";
                case 0x882E:
                    return "GL_DRAW_BUFFER9";
                case 0x882F:
                    return "GL_DRAW_BUFFER10";
                case 0x8830:
                    return "GL_DRAW_BUFFER11";
                case 0x8831:
                    return "GL_DRAW_BUFFER12";
                case 0x8832:
                    return "GL_DRAW_BUFFER13";
                case 0x8833:
                    return "GL_DRAW_BUFFER14";
                case 0x8834:
                    return "GL_DRAW_BUFFER15";
                case 0x883D:
                    return "GL_BLEND_EQUATION_ALPHA";
                case 0x884A:
                    return "GL_TEXTURE_DEPTH_SIZE";
                case 0x884B:
                    return "GL_DEPTH_TEXTURE_MODE";
                case 0x884C:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884D:
                    return "GL_TEXTURE_COMPARE_FUNC";
                case 0x884E:
                    return "GL_COMPARE_R_TO_TEXTURE";
                case 0x884F:
                    return "GL_TEXTURE_CUBE_MAP_SEAMLESS";
                case 0x8861:
                    return "GL_POINT_SPRITE";
                case 0x8862:
                    return "GL_COORD_REPLACE";
                case 0x8864:
                    return "GL_QUERY_COUNTER_BITS";
                case 0x8865:
                    return "GL_CURRENT_QUERY";
                case 0x8866:
                    return "GL_QUERY_RESULT";
                case 0x8867:
                    return "GL_QUERY_RESULT_AVAILABLE";
                case 0x8869:
                    return "GL_MAX_VERTEX_ATTRIBS";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x886C:
                    return "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS";
                case 0x886D:
                    return "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS";
                case 0x8871:
                    return "GL_MAX_TEXTURE_COORDS";
                case 0x8872:
                    return "GL_MAX_TEXTURE_IMAGE_UNITS";
                case 0x887F:
                    return "GL_GEOMETRY_SHADER_INVOCATIONS";
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x8894:
                    return "GL_ARRAY_BUFFER_BINDING";
                case 0x8895:
                    return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
                case 0x8896:
                    return "GL_VERTEX_ARRAY_BUFFER_BINDING";
                case 0x8897:
                    return "GL_NORMAL_ARRAY_BUFFER_BINDING";
                case 0x8898:
                    return "GL_COLOR_ARRAY_BUFFER_BINDING";
                case 0x8899:
                    return "GL_INDEX_ARRAY_BUFFER_BINDING";
                case 0x889A:
                    return "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING";
                case 0x889B:
                    return "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING";
                case 0x889C:
                    return "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING";
                case 0x889D:
                    return "GL_FOG_COORD_ARRAY_BUFFER_BINDING";
                case 0x889E:
                    return "GL_WEIGHT_ARRAY_BUFFER_BINDING";
                case 0x889F:
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
                case 0x88B8:
                    return "GL_READ_ONLY";
                case 0x88B9:
                    return "GL_WRITE_ONLY";
                case 0x88BA:
                    return "GL_READ_WRITE";
                case 0x88BB:
                    return "GL_BUFFER_ACCESS";
                case 0x88BC:
                    return "GL_BUFFER_MAPPED";
                case 0x88BD:
                    return "GL_BUFFER_MAP_POINTER";
                case 0x88BF:
                    return "GL_TIME_ELAPSED";
                case 0x88E0:
                    return "GL_STREAM_DRAW";
                case 0x88E1:
                    return "GL_STREAM_READ";
                case 0x88E2:
                    return "GL_STREAM_COPY";
                case 0x88E4:
                    return "GL_STATIC_DRAW";
                case 0x88E5:
                    return "GL_STATIC_READ";
                case 0x88E6:
                    return "GL_STATIC_COPY";
                case 0x88E8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88E9:
                    return "GL_DYNAMIC_READ";
                case 0x88EA:
                    return "GL_DYNAMIC_COPY";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x88ED:
                    return "GL_PIXEL_PACK_BUFFER_BINDING";
                case 0x88EF:
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING";
                case 0x88F0:
                    return "GL_DEPTH24_STENCIL8";
                case 0x88F1:
                    return "GL_TEXTURE_STENCIL_SIZE";
                case 0x88F9:
                    return "GL_SRC1_COLOR";
                case 0x88FA:
                    return "GL_ONE_MINUS_SRC1_COLOR";
                case 0x88FB:
                    return "GL_ONE_MINUS_SRC1_ALPHA";
                case 0x88FC:
                    return "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                case 0x88FF:
                    return "GL_MAX_ARRAY_TEXTURE_LAYERS";
                case 0x8904:
                    return "GL_MIN_PROGRAM_TEXEL_OFFSET";
                case 0x8905:
                    return "GL_MAX_PROGRAM_TEXEL_OFFSET";
                case 0x8914:
                    return "GL_SAMPLES_PASSED";
                case 0x8916:
                    return "GL_GEOMETRY_VERTICES_OUT";
                case 0x8917:
                    return "GL_GEOMETRY_INPUT_TYPE";
                case 0x8918:
                    return "GL_GEOMETRY_OUTPUT_TYPE";
                case 0x8919:
                    return "GL_SAMPLER_BINDING";
                case 0x891A:
                    return "GL_CLAMP_VERTEX_COLOR";
                case 0x891B:
                    return "GL_CLAMP_FRAGMENT_COLOR";
                case 0x891C:
                    return "GL_CLAMP_READ_COLOR";
                case 0x891D:
                    return "GL_FIXED_ONLY";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8A28:
                    return "GL_UNIFORM_BUFFER_BINDING";
                case 0x8A29:
                    return "GL_UNIFORM_BUFFER_START";
                case 0x8A2A:
                    return "GL_UNIFORM_BUFFER_SIZE";
                case 0x8A2B:
                    return "GL_MAX_VERTEX_UNIFORM_BLOCKS";
                case 0x8A2C:
                    return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS";
                case 0x8A2D:
                    return "GL_MAX_FRAGMENT_UNIFORM_BLOCKS";
                case 0x8A2E:
                    return "GL_MAX_COMBINED_UNIFORM_BLOCKS";
                case 0x8A2F:
                    return "GL_MAX_UNIFORM_BUFFER_BINDINGS";
                case 0x8A30:
                    return "GL_MAX_UNIFORM_BLOCK_SIZE";
                case 0x8A31:
                    return "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS";
                case 0x8A32:
                    return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8A33:
                    return "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8A34:
                    return "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT";
                case 0x8A35:
                    return "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH";
                case 0x8A36:
                    return "GL_ACTIVE_UNIFORM_BLOCKS";
                case 0x8A37:
                    return "GL_UNIFORM_TYPE";
                case 0x8A38:
                    return "GL_UNIFORM_SIZE";
                case 0x8A39:
                    return "GL_UNIFORM_NAME_LENGTH";
                case 0x8A3A:
                    return "GL_UNIFORM_BLOCK_INDEX";
                case 0x8A3B:
                    return "GL_UNIFORM_OFFSET";
                case 0x8A3C:
                    return "GL_UNIFORM_ARRAY_STRIDE";
                case 0x8A3D:
                    return "GL_UNIFORM_MATRIX_STRIDE";
                case 0x8A3E:
                    return "GL_UNIFORM_IS_ROW_MAJOR";
                case 0x8A3F:
                    return "GL_UNIFORM_BLOCK_BINDING";
                case 0x8A40:
                    return "GL_UNIFORM_BLOCK_DATA_SIZE";
                case 0x8A41:
                    return "GL_UNIFORM_BLOCK_NAME_LENGTH";
                case 0x8A42:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS";
                case 0x8A43:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES";
                case 0x8A44:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER";
                case 0x8A45:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x8A46:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x8A48:
                    return "GL_TEXTURE_SRGB_DECODE_EXT";
                case 0x8A49:
                    return "GL_DECODE_EXT";
                case 0x8A4A:
                    return "GL_SKIP_DECODE_EXT";
                case 0x8A4F:
                    return "GL_PROGRAM_PIPELINE_OBJECT_EXT";
                case 0x8A52:
                    return "GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT";
                case 0x8B30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8B31:
                    return "GL_VERTEX_SHADER";
                case 0x8B40:
                    return "GL_PROGRAM_OBJECT_EXT";
                case 0x8B48:
                    return "GL_SHADER_OBJECT_EXT";
                case 0x8B49:
                    return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8B4A:
                    return "GL_MAX_VERTEX_UNIFORM_COMPONENTS";
                case 0x8B4B:
                    return "GL_MAX_VARYING_FLOATS";
                case 0x8B4C:
                    return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS";
                case 0x8B4D:
                    return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS";
                case 0x8B4F:
                    return "GL_SHADER_TYPE";
                case 0x8B50:
                    return "GL_FLOAT_VEC2";
                case 0x8B51:
                    return "GL_FLOAT_VEC3";
                case 0x8B52:
                    return "GL_FLOAT_VEC4";
                case 0x8B53:
                    return "GL_INT_VEC2";
                case 0x8B54:
                    return "GL_INT_VEC3";
                case 0x8B55:
                    return "GL_INT_VEC4";
                case 0x8B56:
                    return "GL_BOOL";
                case 0x8B57:
                    return "GL_BOOL_VEC2";
                case 0x8B58:
                    return "GL_BOOL_VEC3";
                case 0x8B59:
                    return "GL_BOOL_VEC4";
                case 0x8B5A:
                    return "GL_FLOAT_MAT2";
                case 0x8B5B:
                    return "GL_FLOAT_MAT3";
                case 0x8B5C:
                    return "GL_FLOAT_MAT4";
                case 0x8B5D:
                    return "GL_SAMPLER_1D";
                case 0x8B5E:
                    return "GL_SAMPLER_2D";
                case 0x8B5F:
                    return "GL_SAMPLER_3D";
                case 0x8B60:
                    return "GL_SAMPLER_CUBE";
                case 0x8B61:
                    return "GL_SAMPLER_1D_SHADOW";
                case 0x8B62:
                    return "GL_SAMPLER_2D_SHADOW";
                case 0x8B63:
                    return "GL_SAMPLER_2D_RECT";
                case 0x8B64:
                    return "GL_SAMPLER_2D_RECT_SHADOW";
                case 0x8B65:
                    return "GL_FLOAT_MAT2x3";
                case 0x8B66:
                    return "GL_FLOAT_MAT2x4";
                case 0x8B67:
                    return "GL_FLOAT_MAT3x2";
                case 0x8B68:
                    return "GL_FLOAT_MAT3x4";
                case 0x8B69:
                    return "GL_FLOAT_MAT4x2";
                case 0x8B6A:
                    return "GL_FLOAT_MAT4x3";
                case 0x8B80:
                    return "GL_DELETE_STATUS";
                case 0x8B81:
                    return "GL_COMPILE_STATUS";
                case 0x8B82:
                    return "GL_LINK_STATUS";
                case 0x8B83:
                    return "GL_VALIDATE_STATUS";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8B85:
                    return "GL_ATTACHED_SHADERS";
                case 0x8B86:
                    return "GL_ACTIVE_UNIFORMS";
                case 0x8B87:
                    return "GL_ACTIVE_UNIFORM_MAX_LENGTH";
                case 0x8B88:
                    return "GL_SHADER_SOURCE_LENGTH";
                case 0x8B89:
                    return "GL_ACTIVE_ATTRIBUTES";
                case 0x8B8A:
                    return "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH";
                case 0x8B8B:
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
                case 0x8B8C:
                    return "GL_SHADING_LANGUAGE_VERSION";
                case 0x8B8D:
                    return "GL_CURRENT_PROGRAM";
                case 0x8B90:
                    return "GL_PALETTE4_RGB8_OES";
                case 0x8B91:
                    return "GL_PALETTE4_RGBA8_OES";
                case 0x8B92:
                    return "GL_PALETTE4_R5_G6_B5_OES";
                case 0x8B93:
                    return "GL_PALETTE4_RGBA4_OES";
                case 0x8B94:
                    return "GL_PALETTE4_RGB5_A1_OES";
                case 0x8B95:
                    return "GL_PALETTE8_RGB8_OES";
                case 0x8B96:
                    return "GL_PALETTE8_RGBA8_OES";
                case 0x8B97:
                    return "GL_PALETTE8_R5_G6_B5_OES";
                case 0x8B98:
                    return "GL_PALETTE8_RGBA4_OES";
                case 0x8B99:
                    return "GL_PALETTE8_RGB5_A1_OES";
                case 0x8B9A:
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
                case 0x8B9B:
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
                case 0x8BBB:
                    return "GL_FRAMEBUFFER_FLIP_Y_MESA";
                case 0x8BC0:
                    return "GL_COUNTER_TYPE_AMD";
                case 0x8BC1:
                    return "GL_COUNTER_RANGE_AMD";
                case 0x8BC2:
                    return "GL_UNSIGNED_INT64_AMD";
                case 0x8BC3:
                    return "GL_PERCENTAGE_AMD";
                case 0x8BC4:
                    return "GL_PERFMON_RESULT_AVAILABLE_AMD";
                case 0x8BC5:
                    return "GL_PERFMON_RESULT_SIZE_AMD";
                case 0x8BC6:
                    return "GL_PERFMON_RESULT_AMD";
                case 0x8C10:
                    return "GL_TEXTURE_RED_TYPE";
                case 0x8C11:
                    return "GL_TEXTURE_GREEN_TYPE";
                case 0x8C12:
                    return "GL_TEXTURE_BLUE_TYPE";
                case 0x8C13:
                    return "GL_TEXTURE_ALPHA_TYPE";
                case 0x8C14:
                    return "GL_TEXTURE_LUMINANCE_TYPE";
                case 0x8C15:
                    return "GL_TEXTURE_INTENSITY_TYPE";
                case 0x8C16:
                    return "GL_TEXTURE_DEPTH_TYPE";
                case 0x8C17:
                    return "GL_UNSIGNED_NORMALIZED";
                case 0x8C18:
                    return "GL_TEXTURE_1D_ARRAY";
                case 0x8C19:
                    return "GL_PROXY_TEXTURE_1D_ARRAY";
                case 0x8C1A:
                    return "GL_TEXTURE_2D_ARRAY";
                case 0x8C1B:
                    return "GL_PROXY_TEXTURE_2D_ARRAY";
                case 0x8C1C:
                    return "GL_TEXTURE_BINDING_1D_ARRAY";
                case 0x8C1D:
                    return "GL_TEXTURE_BINDING_2D_ARRAY";
                case 0x8C29:
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C2B:
                    return "GL_MAX_TEXTURE_BUFFER_SIZE";
                case 0x8C2C:
                    return "GL_TEXTURE_BINDING_BUFFER";
                case 0x8C2D:
                    return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING";
                case 0x8C2F:
                    return "GL_ANY_SAMPLES_PASSED";
                case 0x8C36:
                    return "GL_SAMPLE_SHADING";
                case 0x8C37:
                    return "GL_MIN_SAMPLE_SHADING_VALUE";
                case 0x8C3A:
                    return "GL_R11F_G11F_B10F";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8C3D:
                    return "GL_RGB9_E5";
                case 0x8C3E:
                    return "GL_UNSIGNED_INT_5_9_9_9_REV";
                case 0x8C3F:
                    return "GL_TEXTURE_SHARED_SIZE";
                case 0x8C40:
                    return "GL_SRGB";
                case 0x8C41:
                    return "GL_SRGB8";
                case 0x8C42:
                    return "GL_SRGB_ALPHA";
                case 0x8C43:
                    return "GL_SRGB8_ALPHA8";
                case 0x8C44:
                    return "GL_SLUMINANCE_ALPHA";
                case 0x8C45:
                    return "GL_SLUMINANCE8_ALPHA8";
                case 0x8C46:
                    return "GL_SLUMINANCE";
                case 0x8C47:
                    return "GL_SLUMINANCE8";
                case 0x8C48:
                    return "GL_COMPRESSED_SRGB";
                case 0x8C49:
                    return "GL_COMPRESSED_SRGB_ALPHA";
                case 0x8C4A:
                    return "GL_COMPRESSED_SLUMINANCE";
                case 0x8C4B:
                    return "GL_COMPRESSED_SLUMINANCE_ALPHA";
                case 0x8C76:
                    return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH";
                case 0x8C7F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE";
                case 0x8C80:
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS";
                case 0x8C83:
                    return "GL_TRANSFORM_FEEDBACK_VARYINGS";
                case 0x8C84:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
                case 0x8C85:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
                case 0x8C87:
                    return "GL_PRIMITIVES_GENERATED";
                case 0x8C88:
                    return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN";
                case 0x8C89:
                    return "GL_RASTERIZER_DISCARD";
                case 0x8C8A:
                    return "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS";
                case 0x8C8B:
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS";
                case 0x8C8C:
                    return "GL_INTERLEAVED_ATTRIBS";
                case 0x8C8D:
                    return "GL_SEPARATE_ATTRIBS";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8C8F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
                case 0x8CA0:
                    return "GL_POINT_SPRITE_COORD_ORIGIN";
                case 0x8CA1:
                    return "GL_LOWER_LEFT";
                case 0x8CA2:
                    return "GL_UPPER_LEFT";
                case 0x8CA3:
                    return "GL_STENCIL_BACK_REF";
                case 0x8CA4:
                    return "GL_STENCIL_BACK_VALUE_MASK";
                case 0x8CA5:
                    return "GL_STENCIL_BACK_WRITEMASK";
                case 0x8CA6:
                    return "GL_FRAMEBUFFER_BINDING";
                case 0x8CA7:
                    return "GL_RENDERBUFFER_BINDING";
                case 0x8CA8:
                    return "GL_READ_FRAMEBUFFER";
                case 0x8CA9:
                    return "GL_DRAW_FRAMEBUFFER";
                case 0x8CAA:
                    return "GL_READ_FRAMEBUFFER_BINDING";
                case 0x8CAB:
                    return "GL_RENDERBUFFER_SAMPLES";
                case 0x8CAC:
                    return "GL_DEPTH_COMPONENT32F";
                case 0x8CAD:
                    return "GL_DEPTH32F_STENCIL8";
                case 0x8CD0:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE";
                case 0x8CD1:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME";
                case 0x8CD2:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL";
                case 0x8CD3:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE";
                case 0x8CD4:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER";
                case 0x8CD5:
                    return "GL_FRAMEBUFFER_COMPLETE";
                case 0x8CD6:
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                case 0x8CD7:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                case 0x8CDB:
                    return "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
                case 0x8CDC:
                    return "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
                case 0x8CDD:
                    return "GL_FRAMEBUFFER_UNSUPPORTED";
                case 0x8CDF:
                    return "GL_MAX_COLOR_ATTACHMENTS";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                case 0x8D00:
                    return "GL_DEPTH_ATTACHMENT";
                case 0x8D20:
                    return "GL_STENCIL_ATTACHMENT";
                case 0x8D40:
                    return "GL_FRAMEBUFFER";
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                case 0x8D42:
                    return "GL_RENDERBUFFER_WIDTH";
                case 0x8D43:
                    return "GL_RENDERBUFFER_HEIGHT";
                case 0x8D44:
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT";
                case 0x8D46:
                    return "GL_STENCIL_INDEX1";
                case 0x8D47:
                    return "GL_STENCIL_INDEX4";
                case 0x8D48:
                    return "GL_STENCIL_INDEX8";
                case 0x8D49:
                    return "GL_STENCIL_INDEX16";
                case 0x8D50:
                    return "GL_RENDERBUFFER_RED_SIZE";
                case 0x8D51:
                    return "GL_RENDERBUFFER_GREEN_SIZE";
                case 0x8D52:
                    return "GL_RENDERBUFFER_BLUE_SIZE";
                case 0x8D53:
                    return "GL_RENDERBUFFER_ALPHA_SIZE";
                case 0x8D54:
                    return "GL_RENDERBUFFER_DEPTH_SIZE";
                case 0x8D55:
                    return "GL_RENDERBUFFER_STENCIL_SIZE";
                case 0x8D56:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
                case 0x8D57:
                    return "GL_MAX_SAMPLES";
                case 0x8D62:
                    return "GL_RGB565";
                case 0x8D69:
                    return "GL_PRIMITIVE_RESTART_FIXED_INDEX";
                case 0x8D6A:
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE";
                case 0x8D6B:
                    return "GL_MAX_ELEMENT_INDEX";
                case 0x8D70:
                    return "GL_RGBA32UI";
                case 0x8D71:
                    return "GL_RGB32UI";
                case 0x8D76:
                    return "GL_RGBA16UI";
                case 0x8D77:
                    return "GL_RGB16UI";
                case 0x8D7C:
                    return "GL_RGBA8UI";
                case 0x8D7D:
                    return "GL_RGB8UI";
                case 0x8D82:
                    return "GL_RGBA32I";
                case 0x8D83:
                    return "GL_RGB32I";
                case 0x8D88:
                    return "GL_RGBA16I";
                case 0x8D89:
                    return "GL_RGB16I";
                case 0x8D8E:
                    return "GL_RGBA8I";
                case 0x8D8F:
                    return "GL_RGB8I";
                case 0x8D94:
                    return "GL_RED_INTEGER";
                case 0x8D95:
                    return "GL_GREEN_INTEGER";
                case 0x8D96:
                    return "GL_BLUE_INTEGER";
                case 0x8D97:
                    return "GL_ALPHA_INTEGER";
                case 0x8D98:
                    return "GL_RGB_INTEGER";
                case 0x8D99:
                    return "GL_RGBA_INTEGER";
                case 0x8D9A:
                    return "GL_BGR_INTEGER";
                case 0x8D9B:
                    return "GL_BGRA_INTEGER";
                case 0x8D9F:
                    return "GL_INT_2_10_10_10_REV";
                case 0x8DA7:
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED";
                case 0x8DA8:
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS";
                case 0x8DAD:
                    return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV";
                case 0x8DB9:
                    return "GL_FRAMEBUFFER_SRGB";
                case 0x8DBB:
                    return "GL_COMPRESSED_RED_RGTC1";
                case 0x8DBC:
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1";
                case 0x8DBD:
                    return "GL_COMPRESSED_RG_RGTC2";
                case 0x8DBE:
                    return "GL_COMPRESSED_SIGNED_RG_RGTC2";
                case 0x8DC0:
                    return "GL_SAMPLER_1D_ARRAY";
                case 0x8DC1:
                    return "GL_SAMPLER_2D_ARRAY";
                case 0x8DC2:
                    return "GL_SAMPLER_BUFFER";
                case 0x8DC3:
                    return "GL_SAMPLER_1D_ARRAY_SHADOW";
                case 0x8DC4:
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
                case 0x8DC5:
                    return "GL_SAMPLER_CUBE_SHADOW";
                case 0x8DC6:
                    return "GL_UNSIGNED_INT_VEC2";
                case 0x8DC7:
                    return "GL_UNSIGNED_INT_VEC3";
                case 0x8DC8:
                    return "GL_UNSIGNED_INT_VEC4";
                case 0x8DC9:
                    return "GL_INT_SAMPLER_1D";
                case 0x8DCA:
                    return "GL_INT_SAMPLER_2D";
                case 0x8DCB:
                    return "GL_INT_SAMPLER_3D";
                case 0x8DCC:
                    return "GL_INT_SAMPLER_CUBE";
                case 0x8DCD:
                    return "GL_INT_SAMPLER_2D_RECT";
                case 0x8DCE:
                    return "GL_INT_SAMPLER_1D_ARRAY";
                case 0x8DCF:
                    return "GL_INT_SAMPLER_2D_ARRAY";
                case 0x8DD0:
                    return "GL_INT_SAMPLER_BUFFER";
                case 0x8DD1:
                    return "GL_UNSIGNED_INT_SAMPLER_1D";
                case 0x8DD2:
                    return "GL_UNSIGNED_INT_SAMPLER_2D";
                case 0x8DD3:
                    return "GL_UNSIGNED_INT_SAMPLER_3D";
                case 0x8DD4:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE";
                case 0x8DD5:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_RECT";
                case 0x8DD6:
                    return "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY";
                case 0x8DD7:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
                case 0x8DD8:
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
                case 0x8DD9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8DDF:
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8DE0:
                    return "GL_MAX_GEOMETRY_OUTPUT_VERTICES";
                case 0x8DE1:
                    return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS";
                case 0x8DE5:
                    return "GL_ACTIVE_SUBROUTINES";
                case 0x8DE6:
                    return "GL_ACTIVE_SUBROUTINE_UNIFORMS";
                case 0x8DE7:
                    return "GL_MAX_SUBROUTINES";
                case 0x8DE8:
                    return "GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS";
                case 0x8DF0:
                    return "GL_LOW_FLOAT";
                case 0x8DF1:
                    return "GL_MEDIUM_FLOAT";
                case 0x8DF2:
                    return "GL_HIGH_FLOAT";
                case 0x8DF3:
                    return "GL_LOW_INT";
                case 0x8DF4:
                    return "GL_MEDIUM_INT";
                case 0x8DF5:
                    return "GL_HIGH_INT";
                case 0x8DF8:
                    return "GL_SHADER_BINARY_FORMATS";
                case 0x8DF9:
                    return "GL_NUM_SHADER_BINARY_FORMATS";
                case 0x8DFA:
                    return "GL_SHADER_COMPILER";
                case 0x8DFB:
                    return "GL_MAX_VERTEX_UNIFORM_VECTORS";
                case 0x8DFC:
                    return "GL_MAX_VARYING_VECTORS";
                case 0x8DFD:
                    return "GL_MAX_FRAGMENT_UNIFORM_VECTORS";
                case 0x8E13:
                    return "GL_QUERY_WAIT";
                case 0x8E14:
                    return "GL_QUERY_NO_WAIT";
                case 0x8E15:
                    return "GL_QUERY_BY_REGION_WAIT";
                case 0x8E16:
                    return "GL_QUERY_BY_REGION_NO_WAIT";
                case 0x8E17:
                    return "GL_QUERY_WAIT_INVERTED";
                case 0x8E18:
                    return "GL_QUERY_NO_WAIT_INVERTED";
                case 0x8E19:
                    return "GL_QUERY_BY_REGION_WAIT_INVERTED";
                case 0x8E1A:
                    return "GL_QUERY_BY_REGION_NO_WAIT_INVERTED";
                case 0x8E1B:
                    return "GL_POLYGON_OFFSET_CLAMP";
                case 0x8E1E:
                    return "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS";
                case 0x8E1F:
                    return "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS";
                case 0x8E22:
                    return "GL_TRANSFORM_FEEDBACK";
                case 0x8E23:
                    return "GL_TRANSFORM_FEEDBACK_PAUSED";
                case 0x8E24:
                    return "GL_TRANSFORM_FEEDBACK_ACTIVE";
                case 0x8E25:
                    return "GL_TRANSFORM_FEEDBACK_BINDING";
                case 0x8E28:
                    return "GL_TIMESTAMP";
                case 0x8E42:
                    return "GL_TEXTURE_SWIZZLE_R";
                case 0x8E43:
                    return "GL_TEXTURE_SWIZZLE_G";
                case 0x8E44:
                    return "GL_TEXTURE_SWIZZLE_B";
                case 0x8E45:
                    return "GL_TEXTURE_SWIZZLE_A";
                case 0x8E46:
                    return "GL_TEXTURE_SWIZZLE_RGBA";
                case 0x8E47:
                    return "GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS";
                case 0x8E48:
                    return "GL_ACTIVE_SUBROUTINE_MAX_LENGTH";
                case 0x8E49:
                    return "GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH";
                case 0x8E4A:
                    return "GL_NUM_COMPATIBLE_SUBROUTINES";
                case 0x8E4B:
                    return "GL_COMPATIBLE_SUBROUTINES";
                case 0x8E4C:
                    return "GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION";
                case 0x8E4D:
                    return "GL_FIRST_VERTEX_CONVENTION";
                case 0x8E4E:
                    return "GL_LAST_VERTEX_CONVENTION";
                case 0x8E4F:
                    return "GL_PROVOKING_VERTEX";
                case 0x8E50:
                    return "GL_SAMPLE_POSITION";
                case 0x8E51:
                    return "GL_SAMPLE_MASK";
                case 0x8E52:
                    return "GL_SAMPLE_MASK_VALUE";
                case 0x8E59:
                    return "GL_MAX_SAMPLE_MASK_WORDS";
                case 0x8E5A:
                    return "GL_MAX_GEOMETRY_SHADER_INVOCATIONS";
                case 0x8E5B:
                    return "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET";
                case 0x8E5C:
                    return "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET";
                case 0x8E5D:
                    return "GL_FRAGMENT_INTERPOLATION_OFFSET_BITS";
                case 0x8E5E:
                    return "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET";
                case 0x8E5F:
                    return "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET";
                case 0x8E70:
                    return "GL_MAX_TRANSFORM_FEEDBACK_BUFFERS";
                case 0x8E71:
                    return "GL_MAX_VERTEX_STREAMS";
                case 0x8E72:
                    return "GL_PATCH_VERTICES";
                case 0x8E73:
                    return "GL_PATCH_DEFAULT_INNER_LEVEL";
                case 0x8E74:
                    return "GL_PATCH_DEFAULT_OUTER_LEVEL";
                case 0x8E75:
                    return "GL_TESS_CONTROL_OUTPUT_VERTICES";
                case 0x8E76:
                    return "GL_TESS_GEN_MODE";
                case 0x8E77:
                    return "GL_TESS_GEN_SPACING";
                case 0x8E78:
                    return "GL_TESS_GEN_VERTEX_ORDER";
                case 0x8E79:
                    return "GL_TESS_GEN_POINT_MODE";
                case 0x8E7A:
                    return "GL_ISOLINES";
                case 0x8E7B:
                    return "GL_FRACTIONAL_ODD";
                case 0x8E7C:
                    return "GL_FRACTIONAL_EVEN";
                case 0x8E7D:
                    return "GL_MAX_PATCH_VERTICES";
                case 0x8E7E:
                    return "GL_MAX_TESS_GEN_LEVEL";
                case 0x8E7F:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS";
                case 0x8E80:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS";
                case 0x8E81:
                    return "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS";
                case 0x8E82:
                    return "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS";
                case 0x8E83:
                    return "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS";
                case 0x8E84:
                    return "GL_MAX_TESS_PATCH_COMPONENTS";
                case 0x8E85:
                    return "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS";
                case 0x8E86:
                    return "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS";
                case 0x8E87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8E88:
                    return "GL_TESS_CONTROL_SHADER";
                case 0x8E89:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS";
                case 0x8E8A:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS";
                case 0x8E8C:
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM";
                case 0x8E8D:
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM";
                case 0x8E8E:
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT";
                case 0x8E8F:
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F38:
                    return "GL_MAX_IMAGE_UNITS";
                case 0x8F39:
                    return "GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES";
                case 0x8F3A:
                    return "GL_IMAGE_BINDING_NAME";
                case 0x8F3B:
                    return "GL_IMAGE_BINDING_LEVEL";
                case 0x8F3C:
                    return "GL_IMAGE_BINDING_LAYERED";
                case 0x8F3D:
                    return "GL_IMAGE_BINDING_LAYER";
                case 0x8F3E:
                    return "GL_IMAGE_BINDING_ACCESS";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x8F43:
                    return "GL_DRAW_INDIRECT_BUFFER_BINDING";
                case 0x8F46:
                    return "GL_DOUBLE_MAT2";
                case 0x8F47:
                    return "GL_DOUBLE_MAT3";
                case 0x8F48:
                    return "GL_DOUBLE_MAT4";
                case 0x8F49:
                    return "GL_DOUBLE_MAT2x3";
                case 0x8F4A:
                    return "GL_DOUBLE_MAT2x4";
                case 0x8F4B:
                    return "GL_DOUBLE_MAT3x2";
                case 0x8F4C:
                    return "GL_DOUBLE_MAT3x4";
                case 0x8F4D:
                    return "GL_DOUBLE_MAT4x2";
                case 0x8F4E:
                    return "GL_DOUBLE_MAT4x3";
                case 0x8F4F:
                    return "GL_VERTEX_BINDING_BUFFER";
                case 0x8F94:
                    return "GL_R8_SNORM";
                case 0x8F95:
                    return "GL_RG8_SNORM";
                case 0x8F96:
                    return "GL_RGB8_SNORM";
                case 0x8F97:
                    return "GL_RGBA8_SNORM";
                case 0x8F98:
                    return "GL_R16_SNORM";
                case 0x8F99:
                    return "GL_RG16_SNORM";
                case 0x8F9A:
                    return "GL_RGB16_SNORM";
                case 0x8F9B:
                    return "GL_RGBA16_SNORM";
                case 0x8F9C:
                    return "GL_SIGNED_NORMALIZED";
                case 0x8F9D:
                    return "GL_PRIMITIVE_RESTART";
                case 0x8F9E:
                    return "GL_PRIMITIVE_RESTART_INDEX";
                case 0x8FBD:
                    return "GL_SR8_EXT";
                case 0x8FBE:
                    return "GL_SRG8_EXT";
                case 0x8FFC:
                    return "GL_DOUBLE_VEC2";
                case 0x8FFD:
                    return "GL_DOUBLE_VEC3";
                case 0x8FFE:
                    return "GL_DOUBLE_VEC4";
                case 0x9009:
                    return "GL_TEXTURE_CUBE_MAP_ARRAY";
                case 0x900A:
                    return "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY";
                case 0x900B:
                    return "GL_PROXY_TEXTURE_CUBE_MAP_ARRAY";
                case 0x900C:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900D:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
                case 0x900E:
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900F:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x904C:
                    return "GL_IMAGE_1D";
                case 0x904D:
                    return "GL_IMAGE_2D";
                case 0x904E:
                    return "GL_IMAGE_3D";
                case 0x904F:
                    return "GL_IMAGE_2D_RECT";
                case 0x9050:
                    return "GL_IMAGE_CUBE";
                case 0x9051:
                    return "GL_IMAGE_BUFFER";
                case 0x9052:
                    return "GL_IMAGE_1D_ARRAY";
                case 0x9053:
                    return "GL_IMAGE_2D_ARRAY";
                case 0x9054:
                    return "GL_IMAGE_CUBE_MAP_ARRAY";
                case 0x9055:
                    return "GL_IMAGE_2D_MULTISAMPLE";
                case 0x9056:
                    return "GL_IMAGE_2D_MULTISAMPLE_ARRAY";
                case 0x9057:
                    return "GL_INT_IMAGE_1D";
                case 0x9058:
                    return "GL_INT_IMAGE_2D";
                case 0x9059:
                    return "GL_INT_IMAGE_3D";
                case 0x905A:
                    return "GL_INT_IMAGE_2D_RECT";
                case 0x905B:
                    return "GL_INT_IMAGE_CUBE";
                case 0x905C:
                    return "GL_INT_IMAGE_BUFFER";
                case 0x905D:
                    return "GL_INT_IMAGE_1D_ARRAY";
                case 0x905E:
                    return "GL_INT_IMAGE_2D_ARRAY";
                case 0x905F:
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x9060:
                    return "GL_INT_IMAGE_2D_MULTISAMPLE";
                case 0x9061:
                    return "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY";
                case 0x9062:
                    return "GL_UNSIGNED_INT_IMAGE_1D";
                case 0x9063:
                    return "GL_UNSIGNED_INT_IMAGE_2D";
                case 0x9064:
                    return "GL_UNSIGNED_INT_IMAGE_3D";
                case 0x9065:
                    return "GL_UNSIGNED_INT_IMAGE_2D_RECT";
                case 0x9066:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE";
                case 0x9067:
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER";
                case 0x9068:
                    return "GL_UNSIGNED_INT_IMAGE_1D_ARRAY";
                case 0x9069:
                    return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY";
                case 0x906A:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x906B:
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE";
                case 0x906C:
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY";
                case 0x906D:
                    return "GL_MAX_IMAGE_SAMPLES";
                case 0x906E:
                    return "GL_IMAGE_BINDING_FORMAT";
                case 0x906F:
                    return "GL_RGB10_A2UI";
                case 0x90BC:
                    return "GL_MIN_MAP_BUFFER_ALIGNMENT";
                case 0x90C7:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE";
                case 0x90C8:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE";
                case 0x90C9:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS";
                case 0x90CA:
                    return "GL_MAX_VERTEX_IMAGE_UNIFORMS";
                case 0x90CB:
                    return "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS";
                case 0x90CC:
                    return "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS";
                case 0x90CD:
                    return "GL_MAX_GEOMETRY_IMAGE_UNIFORMS";
                case 0x90CE:
                    return "GL_MAX_FRAGMENT_IMAGE_UNIFORMS";
                case 0x90CF:
                    return "GL_MAX_COMBINED_IMAGE_UNIFORMS";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90D3:
                    return "GL_SHADER_STORAGE_BUFFER_BINDING";
                case 0x90D4:
                    return "GL_SHADER_STORAGE_BUFFER_START";
                case 0x90D5:
                    return "GL_SHADER_STORAGE_BUFFER_SIZE";
                case 0x90D6:
                    return "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS";
                case 0x90D7:
                    return "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS";
                case 0x90D8:
                    return "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS";
                case 0x90D9:
                    return "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS";
                case 0x90DA:
                    return "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS";
                case 0x90DB:
                    return "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS";
                case 0x90DC:
                    return "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS";
                case 0x90DD:
                    return "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS";
                case 0x90DE:
                    return "GL_MAX_SHADER_STORAGE_BLOCK_SIZE";
                case 0x90DF:
                    return "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT";
                case 0x90EA:
                    return "GL_DEPTH_STENCIL_TEXTURE_MODE";
                case 0x90EB:
                    return "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS";
                case 0x90EC:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER";
                case 0x90ED:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x90EF:
                    return "GL_DISPATCH_INDIRECT_BUFFER_BINDING";
                case 0x9100:
                    return "GL_TEXTURE_2D_MULTISAMPLE";
                case 0x9101:
                    return "GL_PROXY_TEXTURE_2D_MULTISAMPLE";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
                case 0x9103:
                    return "GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY";
                case 0x9104:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE";
                case 0x9105:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY";
                case 0x9106:
                    return "GL_TEXTURE_SAMPLES";
                case 0x9107:
                    return "GL_TEXTURE_FIXED_SAMPLE_LOCATIONS";
                case 0x9108:
                    return "GL_SAMPLER_2D_MULTISAMPLE";
                case 0x9109:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910A:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910B:
                    return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910C:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910D:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910E:
                    return "GL_MAX_COLOR_TEXTURE_SAMPLES";
                case 0x910F:
                    return "GL_MAX_DEPTH_TEXTURE_SAMPLES";
                case 0x9110:
                    return "GL_MAX_INTEGER_SAMPLES";
                case 0x9111:
                    return "GL_MAX_SERVER_WAIT_TIMEOUT";
                case 0x9112:
                    return "GL_OBJECT_TYPE";
                case 0x9113:
                    return "GL_SYNC_CONDITION";
                case 0x9114:
                    return "GL_SYNC_STATUS";
                case 0x9115:
                    return "GL_SYNC_FLAGS";
                case 0x9116:
                    return "GL_SYNC_FENCE";
                case 0x9117:
                    return "GL_SYNC_GPU_COMMANDS_COMPLETE";
                case 0x9118:
                    return "GL_UNSIGNALED";
                case 0x9119:
                    return "GL_SIGNALED";
                case 0x911A:
                    return "GL_ALREADY_SIGNALED";
                case 0x911B:
                    return "GL_TIMEOUT_EXPIRED";
                case 0x911C:
                    return "GL_CONDITION_SATISFIED";
                case 0x911D:
                    return "GL_WAIT_FAILED";
                case 0x911F:
                    return "GL_BUFFER_ACCESS_FLAGS";
                case 0x9120:
                    return "GL_BUFFER_MAP_LENGTH";
                case 0x9121:
                    return "GL_BUFFER_MAP_OFFSET";
                case 0x9122:
                    return "GL_MAX_VERTEX_OUTPUT_COMPONENTS";
                case 0x9123:
                    return "GL_MAX_GEOMETRY_INPUT_COMPONENTS";
                case 0x9124:
                    return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS";
                case 0x9125:
                    return "GL_MAX_FRAGMENT_INPUT_COMPONENTS";
                case 0x9126:
                    return "GL_CONTEXT_PROFILE_MASK";
                case 0x9127:
                    return "GL_UNPACK_COMPRESSED_BLOCK_WIDTH";
                case 0x9128:
                    return "GL_UNPACK_COMPRESSED_BLOCK_HEIGHT";
                case 0x9129:
                    return "GL_UNPACK_COMPRESSED_BLOCK_DEPTH";
                case 0x912A:
                    return "GL_UNPACK_COMPRESSED_BLOCK_SIZE";
                case 0x912B:
                    return "GL_PACK_COMPRESSED_BLOCK_WIDTH";
                case 0x912C:
                    return "GL_PACK_COMPRESSED_BLOCK_HEIGHT";
                case 0x912D:
                    return "GL_PACK_COMPRESSED_BLOCK_DEPTH";
                case 0x912E:
                    return "GL_PACK_COMPRESSED_BLOCK_SIZE";
                case 0x912F:
                    return "GL_TEXTURE_IMMUTABLE_FORMAT";
                case 0x9143:
                    return "GL_MAX_DEBUG_MESSAGE_LENGTH";
                case 0x9144:
                    return "GL_MAX_DEBUG_LOGGED_MESSAGES";
                case 0x9145:
                    return "GL_DEBUG_LOGGED_MESSAGES";
                case 0x9146:
                    return "GL_DEBUG_SEVERITY_HIGH";
                case 0x9147:
                    return "GL_DEBUG_SEVERITY_MEDIUM";
                case 0x9148:
                    return "GL_DEBUG_SEVERITY_LOW";
                case 0x9151:
                    return "GL_BUFFER_OBJECT_EXT";
                case 0x9153:
                    return "GL_QUERY_OBJECT_EXT";
                case 0x9154:
                    return "GL_VERTEX_ARRAY_OBJECT_EXT";
                case 0x9192:
                    return "GL_QUERY_BUFFER";
                case 0x9193:
                    return "GL_QUERY_BUFFER_BINDING";
                case 0x9194:
                    return "GL_QUERY_RESULT_NO_WAIT";
                case 0x919D:
                    return "GL_TEXTURE_BUFFER_OFFSET";
                case 0x919E:
                    return "GL_TEXTURE_BUFFER_SIZE";
                case 0x919F:
                    return "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT";
                case 0x91B0:
                    return "GL_MAX_SHADER_COMPILER_THREADS_KHR";
                case 0x91B1:
                    return "GL_COMPLETION_STATUS_KHR";
                case 0x91B9:
                    return "GL_COMPUTE_SHADER";
                case 0x91BB:
                    return "GL_MAX_COMPUTE_UNIFORM_BLOCKS";
                case 0x91BC:
                    return "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS";
                case 0x91BD:
                    return "GL_MAX_COMPUTE_IMAGE_UNIFORMS";
                case 0x91BE:
                    return "GL_MAX_COMPUTE_WORK_GROUP_COUNT";
                case 0x91BF:
                    return "GL_MAX_COMPUTE_WORK_GROUP_SIZE";
                case 0x9270:
                    return "GL_COMPRESSED_R11_EAC";
                case 0x9271:
                    return "GL_COMPRESSED_SIGNED_R11_EAC";
                case 0x9272:
                    return "GL_COMPRESSED_RG11_EAC";
                case 0x9273:
                    return "GL_COMPRESSED_SIGNED_RG11_EAC";
                case 0x9274:
                    return "GL_COMPRESSED_RGB8_ETC2";
                case 0x9275:
                    return "GL_COMPRESSED_SRGB8_ETC2";
                case 0x9276:
                    return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9277:
                    return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9278:
                    return "GL_COMPRESSED_RGBA8_ETC2_EAC";
                case 0x9279:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
                case 0x9294:
                    return "GL_MULTIPLY_KHR";
                case 0x9295:
                    return "GL_SCREEN_KHR";
                case 0x9296:
                    return "GL_OVERLAY_KHR";
                case 0x9297:
                    return "GL_DARKEN_KHR";
                case 0x9298:
                    return "GL_LIGHTEN_KHR";
                case 0x9299:
                    return "GL_COLORDODGE_KHR";
                case 0x929A:
                    return "GL_COLORBURN_KHR";
                case 0x929B:
                    return "GL_HARDLIGHT_KHR";
                case 0x929C:
                    return "GL_SOFTLIGHT_KHR";
                case 0x929E:
                    return "GL_DIFFERENCE_KHR";
                case 0x92A0:
                    return "GL_EXCLUSION_KHR";
                case 0x92AD:
                    return "GL_HSL_HUE_KHR";
                case 0x92AE:
                    return "GL_HSL_SATURATION_KHR";
                case 0x92AF:
                    return "GL_HSL_COLOR_KHR";
                case 0x92B0:
                    return "GL_HSL_LUMINOSITY_KHR";
                case 0x92BB:
                    return "GL_PURGED_CONTEXT_RESET_NV";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                case 0x92C1:
                    return "GL_ATOMIC_COUNTER_BUFFER_BINDING";
                case 0x92C2:
                    return "GL_ATOMIC_COUNTER_BUFFER_START";
                case 0x92C3:
                    return "GL_ATOMIC_COUNTER_BUFFER_SIZE";
                case 0x92C4:
                    return "GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE";
                case 0x92C5:
                    return "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS";
                case 0x92C6:
                    return "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES";
                case 0x92C7:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER";
                case 0x92C8:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x92C9:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x92CA:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x92CB:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x92CC:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS";
                case 0x92CD:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS";
                case 0x92CE:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS";
                case 0x92CF:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS";
                case 0x92D0:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS";
                case 0x92D1:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS";
                case 0x92D2:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTERS";
                case 0x92D3:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS";
                case 0x92D4:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS";
                case 0x92D5:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTERS";
                case 0x92D6:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTERS";
                case 0x92D7:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTERS";
                case 0x92D8:
                    return "GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE";
                case 0x92D9:
                    return "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS";
                case 0x92DA:
                    return "GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX";
                case 0x92DB:
                    return "GL_UNSIGNED_INT_ATOMIC_COUNTER";
                case 0x92DC:
                    return "GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS";
                case 0x92E0:
                    return "GL_DEBUG_OUTPUT";
                case 0x92E1:
                    return "GL_UNIFORM";
                case 0x92E2:
                    return "GL_UNIFORM_BLOCK";
                case 0x92E3:
                    return "GL_PROGRAM_INPUT";
                case 0x92E4:
                    return "GL_PROGRAM_OUTPUT";
                case 0x92E5:
                    return "GL_BUFFER_VARIABLE";
                case 0x92E6:
                    return "GL_SHADER_STORAGE_BLOCK";
                case 0x92E7:
                    return "GL_IS_PER_PATCH";
                case 0x92E8:
                    return "GL_VERTEX_SUBROUTINE";
                case 0x92E9:
                    return "GL_TESS_CONTROL_SUBROUTINE";
                case 0x92EA:
                    return "GL_TESS_EVALUATION_SUBROUTINE";
                case 0x92EB:
                    return "GL_GEOMETRY_SUBROUTINE";
                case 0x92EC:
                    return "GL_FRAGMENT_SUBROUTINE";
                case 0x92ED:
                    return "GL_COMPUTE_SUBROUTINE";
                case 0x92EE:
                    return "GL_VERTEX_SUBROUTINE_UNIFORM";
                case 0x92EF:
                    return "GL_TESS_CONTROL_SUBROUTINE_UNIFORM";
                case 0x92F0:
                    return "GL_TESS_EVALUATION_SUBROUTINE_UNIFORM";
                case 0x92F1:
                    return "GL_GEOMETRY_SUBROUTINE_UNIFORM";
                case 0x92F2:
                    return "GL_FRAGMENT_SUBROUTINE_UNIFORM";
                case 0x92F3:
                    return "GL_COMPUTE_SUBROUTINE_UNIFORM";
                case 0x92F4:
                    return "GL_TRANSFORM_FEEDBACK_VARYING";
                case 0x92F5:
                    return "GL_ACTIVE_RESOURCES";
                case 0x92F6:
                    return "GL_MAX_NAME_LENGTH";
                case 0x92F7:
                    return "GL_MAX_NUM_ACTIVE_VARIABLES";
                case 0x92F8:
                    return "GL_MAX_NUM_COMPATIBLE_SUBROUTINES";
                case 0x92F9:
                    return "GL_NAME_LENGTH";
                case 0x92FA:
                    return "GL_TYPE";
                case 0x92FB:
                    return "GL_ARRAY_SIZE";
                case 0x92FC:
                    return "GL_OFFSET";
                case 0x92FD:
                    return "GL_BLOCK_INDEX";
                case 0x92FE:
                    return "GL_ARRAY_STRIDE";
                case 0x92FF:
                    return "GL_MATRIX_STRIDE";
                case 0x9300:
                    return "GL_IS_ROW_MAJOR";
                case 0x9301:
                    return "GL_ATOMIC_COUNTER_BUFFER_INDEX";
                case 0x9302:
                    return "GL_BUFFER_BINDING";
                case 0x9303:
                    return "GL_BUFFER_DATA_SIZE";
                case 0x9304:
                    return "GL_NUM_ACTIVE_VARIABLES";
                case 0x9305:
                    return "GL_ACTIVE_VARIABLES";
                case 0x9306:
                    return "GL_REFERENCED_BY_VERTEX_SHADER";
                case 0x9307:
                    return "GL_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x9308:
                    return "GL_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x9309:
                    return "GL_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x930A:
                    return "GL_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x930B:
                    return "GL_REFERENCED_BY_COMPUTE_SHADER";
                case 0x930C:
                    return "GL_TOP_LEVEL_ARRAY_SIZE";
                case 0x930D:
                    return "GL_TOP_LEVEL_ARRAY_STRIDE";
                case 0x930E:
                    return "GL_LOCATION";
                case 0x930F:
                    return "GL_LOCATION_INDEX";
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                case 0x9315:
                    return "GL_MAX_FRAMEBUFFER_WIDTH";
                case 0x9316:
                    return "GL_MAX_FRAMEBUFFER_HEIGHT";
                case 0x9317:
                    return "GL_MAX_FRAMEBUFFER_LAYERS";
                case 0x9318:
                    return "GL_MAX_FRAMEBUFFER_SAMPLES";
                case 0x934A:
                    return "GL_LOCATION_COMPONENT";
                case 0x934B:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_INDEX";
                case 0x934C:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE";
                case 0x935C:
                    return "GL_CLIP_ORIGIN";
                case 0x935D:
                    return "GL_CLIP_DEPTH_MODE";
                case 0x935E:
                    return "GL_NEGATIVE_ONE_TO_ONE";
                case 0x935F:
                    return "GL_ZERO_TO_ONE";
                case 0x9365:
                    return "GL_CLEAR_TEXTURE";
                case 0x9380:
                    return "GL_NUM_SAMPLE_COUNTS";
                case 0x93A1:
                    return "GL_BGRA8_EXT";
                case 0x93AE:
                    return "GL_HANDLE_TYPE_ZIRCON_VMO_ANGLE";
                case 0x93AF:
                    return "GL_HANDLE_TYPE_ZIRCON_EVENT_ANGLE";
                case 0x93B0:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4_KHR";
                case 0x93B1:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4_KHR";
                case 0x93B2:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5_KHR";
                case 0x93B3:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5_KHR";
                case 0x93B4:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6_KHR";
                case 0x93B5:
                    return "GL_COMPRESSED_RGBA_ASTC_8x5_KHR";
                case 0x93B6:
                    return "GL_COMPRESSED_RGBA_ASTC_8x6_KHR";
                case 0x93B7:
                    return "GL_COMPRESSED_RGBA_ASTC_8x8_KHR";
                case 0x93B8:
                    return "GL_COMPRESSED_RGBA_ASTC_10x5_KHR";
                case 0x93B9:
                    return "GL_COMPRESSED_RGBA_ASTC_10x6_KHR";
                case 0x93BA:
                    return "GL_COMPRESSED_RGBA_ASTC_10x8_KHR";
                case 0x93BB:
                    return "GL_COMPRESSED_RGBA_ASTC_10x10_KHR";
                case 0x93BC:
                    return "GL_COMPRESSED_RGBA_ASTC_12x10_KHR";
                case 0x93BD:
                    return "GL_COMPRESSED_RGBA_ASTC_12x12_KHR";
                case 0x93D0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR";
                case 0x93D1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR";
                case 0x93D2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR";
                case 0x93D3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR";
                case 0x93D4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR";
                case 0x93D5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR";
                case 0x93D6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR";
                case 0x93D7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR";
                case 0x93D8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR";
                case 0x93D9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR";
                case 0x93DA:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR";
                case 0x93DB:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR";
                case 0x93DC:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR";
                case 0x93DD:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR";
                case 0x9530:
                    return "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT";
                case 0x9531:
                    return "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT";
                case 0x9551:
                    return "GL_SHADER_BINARY_FORMAT_SPIR_V";
                case 0x9552:
                    return "GL_SPIR_V_BINARY";
                case 0x9553:
                    return "GL_SPIR_V_EXTENSIONS";
                case 0x9554:
                    return "GL_NUM_SPIR_V_EXTENSIONS";
                case 0x9580:
                    return "GL_TEXTURE_TILING_EXT";
                case 0x9581:
                    return "GL_DEDICATED_MEMORY_OBJECT_EXT";
                case 0x9582:
                    return "GL_NUM_TILING_TYPES_EXT";
                case 0x9583:
                    return "GL_TILING_TYPES_EXT";
                case 0x9584:
                    return "GL_OPTIMAL_TILING_EXT";
                case 0x9585:
                    return "GL_LINEAR_TILING_EXT";
                case 0x9586:
                    return "GL_HANDLE_TYPE_OPAQUE_FD_EXT";
                case 0x958D:
                    return "GL_LAYOUT_GENERAL_EXT";
                case 0x958E:
                    return "GL_LAYOUT_COLOR_ATTACHMENT_EXT";
                case 0x958F:
                    return "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT";
                case 0x9590:
                    return "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT";
                case 0x9591:
                    return "GL_LAYOUT_SHADER_READ_ONLY_EXT";
                case 0x9592:
                    return "GL_LAYOUT_TRANSFER_SRC_EXT";
                case 0x9593:
                    return "GL_LAYOUT_TRANSFER_DST_EXT";
                case 0x9596:
                    return "GL_NUM_DEVICE_UUIDS_EXT";
                case 0x9597:
                    return "GL_DEVICE_UUID_EXT";
                case 0x9598:
                    return "GL_DRIVER_UUID_EXT";
                case 0x959B:
                    return "GL_PROTECTED_MEMORY_OBJECT_EXT";
                case 0x9630:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR";
                case 0x9631:
                    return "GL_MAX_VIEWS_OVR";
                case 0x9632:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR";
                case 0x9633:
                    return "GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR";
                case 0x10000:
                    return "GL_EVAL_BIT";
                case 0x20000:
                    return "GL_LIST_BIT";
                case 0x40000:
                    return "GL_TEXTURE_BIT";
                case 0x80000:
                    return "GL_SCISSOR_BIT";
                case 0x20000000:
                    return "GL_MULTISAMPLE_BIT";
                case 0xFFFFFFFF:
                    return "GL_INVALID_INDEX";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::AlphaFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::AtomicCounterBufferPName:
        {
            switch (value)
            {
                case 0x90ED:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER";
                case 0x92C1:
                    return "GL_ATOMIC_COUNTER_BUFFER_BINDING";
                case 0x92C4:
                    return "GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE";
                case 0x92C5:
                    return "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS";
                case 0x92C6:
                    return "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES";
                case 0x92C7:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER";
                case 0x92C8:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x92C9:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x92CA:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x92CB:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::AttribMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_CURRENT_BIT";
                case 0x2:
                    return "GL_POINT_BIT";
                case 0x4:
                    return "GL_LINE_BIT";
                case 0x8:
                    return "GL_POLYGON_BIT";
                case 0x10:
                    return "GL_POLYGON_STIPPLE_BIT";
                case 0x20:
                    return "GL_PIXEL_MODE_BIT";
                case 0x40:
                    return "GL_LIGHTING_BIT";
                case 0x80:
                    return "GL_FOG_BIT";
                case 0x100:
                    return "GL_DEPTH_BUFFER_BIT";
                case 0x200:
                    return "GL_ACCUM_BUFFER_BIT";
                case 0x400:
                    return "GL_STENCIL_BUFFER_BIT";
                case 0x800:
                    return "GL_VIEWPORT_BIT";
                case 0x1000:
                    return "GL_TRANSFORM_BIT";
                case 0x2000:
                    return "GL_ENABLE_BIT";
                case 0x4000:
                    return "GL_COLOR_BUFFER_BIT";
                case 0x8000:
                    return "GL_HINT_BIT";
                case 0x10000:
                    return "GL_EVAL_BIT";
                case 0x20000:
                    return "GL_LIST_BIT";
                case 0x40000:
                    return "GL_TEXTURE_BIT";
                case 0x80000:
                    return "GL_SCISSOR_BIT";
                case 0x20000000:
                    return "GL_MULTISAMPLE_BIT";
                case 0xFFFFFFFF:
                    return "GL_ALL_ATTRIB_BITS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::AttributeType:
        {
            switch (value)
            {
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                case 0x8B50:
                    return "GL_FLOAT_VEC2";
                case 0x8B51:
                    return "GL_FLOAT_VEC3";
                case 0x8B52:
                    return "GL_FLOAT_VEC4";
                case 0x8B53:
                    return "GL_INT_VEC2";
                case 0x8B54:
                    return "GL_INT_VEC3";
                case 0x8B55:
                    return "GL_INT_VEC4";
                case 0x8B56:
                    return "GL_BOOL";
                case 0x8B57:
                    return "GL_BOOL_VEC2";
                case 0x8B58:
                    return "GL_BOOL_VEC3";
                case 0x8B59:
                    return "GL_BOOL_VEC4";
                case 0x8B5A:
                    return "GL_FLOAT_MAT2";
                case 0x8B5B:
                    return "GL_FLOAT_MAT3";
                case 0x8B5C:
                    return "GL_FLOAT_MAT4";
                case 0x8B5D:
                    return "GL_SAMPLER_1D";
                case 0x8B5E:
                    return "GL_SAMPLER_2D";
                case 0x8B5F:
                    return "GL_SAMPLER_3D";
                case 0x8B60:
                    return "GL_SAMPLER_CUBE";
                case 0x8B61:
                    return "GL_SAMPLER_1D_SHADOW";
                case 0x8B62:
                    return "GL_SAMPLER_2D_SHADOW";
                case 0x8B63:
                    return "GL_SAMPLER_2D_RECT";
                case 0x8B64:
                    return "GL_SAMPLER_2D_RECT_SHADOW";
                case 0x8B65:
                    return "GL_FLOAT_MAT2x3";
                case 0x8B66:
                    return "GL_FLOAT_MAT2x4";
                case 0x8B67:
                    return "GL_FLOAT_MAT3x2";
                case 0x8B68:
                    return "GL_FLOAT_MAT3x4";
                case 0x8B69:
                    return "GL_FLOAT_MAT4x2";
                case 0x8B6A:
                    return "GL_FLOAT_MAT4x3";
                case 0x8DC2:
                    return "GL_SAMPLER_BUFFER";
                case 0x8DC3:
                    return "GL_SAMPLER_1D_ARRAY_SHADOW";
                case 0x8DC4:
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
                case 0x8DC5:
                    return "GL_SAMPLER_CUBE_SHADOW";
                case 0x8DC6:
                    return "GL_UNSIGNED_INT_VEC2";
                case 0x8DC7:
                    return "GL_UNSIGNED_INT_VEC3";
                case 0x8DC8:
                    return "GL_UNSIGNED_INT_VEC4";
                case 0x8DC9:
                    return "GL_INT_SAMPLER_1D";
                case 0x8DCA:
                    return "GL_INT_SAMPLER_2D";
                case 0x8DCB:
                    return "GL_INT_SAMPLER_3D";
                case 0x8DCC:
                    return "GL_INT_SAMPLER_CUBE";
                case 0x8DCD:
                    return "GL_INT_SAMPLER_2D_RECT";
                case 0x8DCE:
                    return "GL_INT_SAMPLER_1D_ARRAY";
                case 0x8DCF:
                    return "GL_INT_SAMPLER_2D_ARRAY";
                case 0x8DD0:
                    return "GL_INT_SAMPLER_BUFFER";
                case 0x8DD1:
                    return "GL_UNSIGNED_INT_SAMPLER_1D";
                case 0x8DD2:
                    return "GL_UNSIGNED_INT_SAMPLER_2D";
                case 0x8DD3:
                    return "GL_UNSIGNED_INT_SAMPLER_3D";
                case 0x8DD4:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE";
                case 0x8DD5:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_RECT";
                case 0x8DD6:
                    return "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY";
                case 0x8DD7:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
                case 0x8DD8:
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
                case 0x8F46:
                    return "GL_DOUBLE_MAT2";
                case 0x8F47:
                    return "GL_DOUBLE_MAT3";
                case 0x8F48:
                    return "GL_DOUBLE_MAT4";
                case 0x8F49:
                    return "GL_DOUBLE_MAT2x3";
                case 0x8F4A:
                    return "GL_DOUBLE_MAT2x4";
                case 0x8F4B:
                    return "GL_DOUBLE_MAT3x2";
                case 0x8F4C:
                    return "GL_DOUBLE_MAT3x4";
                case 0x8F4D:
                    return "GL_DOUBLE_MAT4x2";
                case 0x8F4E:
                    return "GL_DOUBLE_MAT4x3";
                case 0x8FFC:
                    return "GL_DOUBLE_VEC2";
                case 0x8FFD:
                    return "GL_DOUBLE_VEC3";
                case 0x8FFE:
                    return "GL_DOUBLE_VEC4";
                case 0x900C:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900D:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
                case 0x900E:
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900F:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x904C:
                    return "GL_IMAGE_1D";
                case 0x904D:
                    return "GL_IMAGE_2D";
                case 0x904E:
                    return "GL_IMAGE_3D";
                case 0x904F:
                    return "GL_IMAGE_2D_RECT";
                case 0x9050:
                    return "GL_IMAGE_CUBE";
                case 0x9051:
                    return "GL_IMAGE_BUFFER";
                case 0x9052:
                    return "GL_IMAGE_1D_ARRAY";
                case 0x9053:
                    return "GL_IMAGE_2D_ARRAY";
                case 0x9054:
                    return "GL_IMAGE_CUBE_MAP_ARRAY";
                case 0x9055:
                    return "GL_IMAGE_2D_MULTISAMPLE";
                case 0x9056:
                    return "GL_IMAGE_2D_MULTISAMPLE_ARRAY";
                case 0x9057:
                    return "GL_INT_IMAGE_1D";
                case 0x9058:
                    return "GL_INT_IMAGE_2D";
                case 0x9059:
                    return "GL_INT_IMAGE_3D";
                case 0x905A:
                    return "GL_INT_IMAGE_2D_RECT";
                case 0x905B:
                    return "GL_INT_IMAGE_CUBE";
                case 0x905C:
                    return "GL_INT_IMAGE_BUFFER";
                case 0x905D:
                    return "GL_INT_IMAGE_1D_ARRAY";
                case 0x905E:
                    return "GL_INT_IMAGE_2D_ARRAY";
                case 0x905F:
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x9060:
                    return "GL_INT_IMAGE_2D_MULTISAMPLE";
                case 0x9061:
                    return "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY";
                case 0x9062:
                    return "GL_UNSIGNED_INT_IMAGE_1D";
                case 0x9063:
                    return "GL_UNSIGNED_INT_IMAGE_2D";
                case 0x9064:
                    return "GL_UNSIGNED_INT_IMAGE_3D";
                case 0x9065:
                    return "GL_UNSIGNED_INT_IMAGE_2D_RECT";
                case 0x9066:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE";
                case 0x9067:
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER";
                case 0x9068:
                    return "GL_UNSIGNED_INT_IMAGE_1D_ARRAY";
                case 0x9069:
                    return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY";
                case 0x906A:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x906B:
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE";
                case 0x906C:
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY";
                case 0x9108:
                    return "GL_SAMPLER_2D_MULTISAMPLE";
                case 0x9109:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910A:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910B:
                    return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910C:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910D:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BindTransformFeedbackTarget:
        {
            switch (value)
            {
                case 0x8E22:
                    return "GL_TRANSFORM_FEEDBACK";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BinormalPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BlendEquationModeEXT:
        {
            switch (value)
            {
                case 0x8006:
                    return "GL_FUNC_ADD";
                case 0x8007:
                    return "GL_MIN";
                case 0x8008:
                    return "GL_MAX";
                case 0x800A:
                    return "GL_FUNC_SUBTRACT";
                case 0x800B:
                    return "GL_FUNC_REVERSE_SUBTRACT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BlendingFactor:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x1:
                    return "GL_ONE";
                case 0x300:
                    return "GL_SRC_COLOR";
                case 0x301:
                    return "GL_ONE_MINUS_SRC_COLOR";
                case 0x302:
                    return "GL_SRC_ALPHA";
                case 0x303:
                    return "GL_ONE_MINUS_SRC_ALPHA";
                case 0x304:
                    return "GL_DST_ALPHA";
                case 0x305:
                    return "GL_ONE_MINUS_DST_ALPHA";
                case 0x306:
                    return "GL_DST_COLOR";
                case 0x307:
                    return "GL_ONE_MINUS_DST_COLOR";
                case 0x308:
                    return "GL_SRC_ALPHA_SATURATE";
                case 0x8001:
                    return "GL_CONSTANT_COLOR";
                case 0x8002:
                    return "GL_ONE_MINUS_CONSTANT_COLOR";
                case 0x8003:
                    return "GL_CONSTANT_ALPHA";
                case 0x8004:
                    return "GL_ONE_MINUS_CONSTANT_ALPHA";
                case 0x8589:
                    return "GL_SRC1_ALPHA";
                case 0x88F9:
                    return "GL_SRC1_COLOR";
                case 0x88FA:
                    return "GL_ONE_MINUS_SRC1_COLOR";
                case 0x88FB:
                    return "GL_ONE_MINUS_SRC1_ALPHA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BlitFramebufferFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::Boolean:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_FALSE";
                case 0x1:
                    return "GL_TRUE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::Buffer:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BufferAccessARB:
        {
            switch (value)
            {
                case 0x88B8:
                    return "GL_READ_ONLY";
                case 0x88B9:
                    return "GL_WRITE_ONLY";
                case 0x88BA:
                    return "GL_READ_WRITE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BufferPNameARB:
        {
            switch (value)
            {
                case 0x821F:
                    return "GL_BUFFER_IMMUTABLE_STORAGE";
                case 0x8220:
                    return "GL_BUFFER_STORAGE_FLAGS";
                case 0x8764:
                    return "GL_BUFFER_SIZE";
                case 0x8765:
                    return "GL_BUFFER_USAGE";
                case 0x88BB:
                    return "GL_BUFFER_ACCESS";
                case 0x88BC:
                    return "GL_BUFFER_MAPPED";
                case 0x911F:
                    return "GL_BUFFER_ACCESS_FLAGS";
                case 0x9120:
                    return "GL_BUFFER_MAP_LENGTH";
                case 0x9121:
                    return "GL_BUFFER_MAP_OFFSET";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BufferPointerNameARB:
        {
            switch (value)
            {
                case 0x88BD:
                    return "GL_BUFFER_MAP_POINTER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BufferStorageMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_MAP_READ_BIT";
                case 0x2:
                    return "GL_MAP_WRITE_BIT";
                case 0x40:
                    return "GL_MAP_PERSISTENT_BIT";
                case 0x80:
                    return "GL_MAP_COHERENT_BIT";
                case 0x100:
                    return "GL_DYNAMIC_STORAGE_BIT";
                case 0x200:
                    return "GL_CLIENT_STORAGE_BIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BufferStorageTarget:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x9192:
                    return "GL_QUERY_BUFFER";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BufferTargetARB:
        {
            switch (value)
            {
                case 0x80EE:
                    return "GL_PARAMETER_BUFFER";
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x9192:
                    return "GL_QUERY_BUFFER";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::BufferUsageARB:
        {
            switch (value)
            {
                case 0x88E0:
                    return "GL_STREAM_DRAW";
                case 0x88E1:
                    return "GL_STREAM_READ";
                case 0x88E2:
                    return "GL_STREAM_COPY";
                case 0x88E4:
                    return "GL_STATIC_DRAW";
                case 0x88E5:
                    return "GL_STATIC_READ";
                case 0x88E6:
                    return "GL_STATIC_COPY";
                case 0x88E8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88E9:
                    return "GL_DYNAMIC_READ";
                case 0x88EA:
                    return "GL_DYNAMIC_COPY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ClampColorModeARB:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_FALSE";
                case 0x1:
                    return "GL_TRUE";
                case 0x891D:
                    return "GL_FIXED_ONLY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ClampColorTargetARB:
        {
            switch (value)
            {
                case 0x891C:
                    return "GL_CLAMP_READ_COLOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ClearBufferMask:
        {
            switch (value)
            {
                case 0x100:
                    return "GL_DEPTH_BUFFER_BIT";
                case 0x200:
                    return "GL_ACCUM_BUFFER_BIT";
                case 0x400:
                    return "GL_STENCIL_BUFFER_BIT";
                case 0x4000:
                    return "GL_COLOR_BUFFER_BIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ClientAttribMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_CLIENT_PIXEL_STORE_BIT";
                case 0x2:
                    return "GL_CLIENT_VERTEX_ARRAY_BIT";
                case 0xFFFFFFFF:
                    return "GL_CLIENT_ALL_ATTRIB_BITS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ClipControlDepth:
        {
            switch (value)
            {
                case 0x935E:
                    return "GL_NEGATIVE_ONE_TO_ONE";
                case 0x935F:
                    return "GL_ZERO_TO_ONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ClipControlOrigin:
        {
            switch (value)
            {
                case 0x8CA1:
                    return "GL_LOWER_LEFT";
                case 0x8CA2:
                    return "GL_UPPER_LEFT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ClipPlaneName:
        {
            switch (value)
            {
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                case 0x3006:
                    return "GL_CLIP_DISTANCE6";
                case 0x3007:
                    return "GL_CLIP_DISTANCE7";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ColorBuffer:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x400:
                    return "GL_FRONT_LEFT";
                case 0x401:
                    return "GL_FRONT_RIGHT";
                case 0x402:
                    return "GL_BACK_LEFT";
                case 0x403:
                    return "GL_BACK_RIGHT";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x406:
                    return "GL_LEFT";
                case 0x407:
                    return "GL_RIGHT";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ColorMaterialParameter:
        {
            switch (value)
            {
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1600:
                    return "GL_EMISSION";
                case 0x1602:
                    return "GL_AMBIENT_AND_DIFFUSE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ColorPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ColorTableTarget:
        {
            switch (value)
            {
                case 0x80D0:
                    return "GL_COLOR_TABLE";
                case 0x80D1:
                    return "GL_POST_CONVOLUTION_COLOR_TABLE";
                case 0x80D2:
                    return "GL_POST_COLOR_MATRIX_COLOR_TABLE";
                case 0x80D3:
                    return "GL_PROXY_COLOR_TABLE";
                case 0x80D4:
                    return "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE";
                case 0x80D5:
                    return "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ColorTableTargetSGI:
        {
            switch (value)
            {
                case 0x80D0:
                    return "GL_COLOR_TABLE";
                case 0x80D1:
                    return "GL_POST_CONVOLUTION_COLOR_TABLE";
                case 0x80D2:
                    return "GL_POST_COLOR_MATRIX_COLOR_TABLE";
                case 0x80D3:
                    return "GL_PROXY_COLOR_TABLE";
                case 0x80D4:
                    return "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE";
                case 0x80D5:
                    return "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::CombinerBiasNV:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::CombinerComponentUsageNV:
        {
            switch (value)
            {
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::CombinerPortionNV:
        {
            switch (value)
            {
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::CombinerScaleNV:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ConditionalRenderMode:
        {
            switch (value)
            {
                case 0x8E13:
                    return "GL_QUERY_WAIT";
                case 0x8E14:
                    return "GL_QUERY_NO_WAIT";
                case 0x8E15:
                    return "GL_QUERY_BY_REGION_WAIT";
                case 0x8E16:
                    return "GL_QUERY_BY_REGION_NO_WAIT";
                case 0x8E17:
                    return "GL_QUERY_WAIT_INVERTED";
                case 0x8E18:
                    return "GL_QUERY_NO_WAIT_INVERTED";
                case 0x8E19:
                    return "GL_QUERY_BY_REGION_WAIT_INVERTED";
                case 0x8E1A:
                    return "GL_QUERY_BY_REGION_NO_WAIT_INVERTED";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ContainerType:
        {
            switch (value)
            {
                case 0x8B40:
                    return "GL_PROGRAM_OBJECT_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ContextFlagMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT";
                case 0x2:
                    return "GL_CONTEXT_FLAG_DEBUG_BIT";
                case 0x4:
                    return "GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT";
                case 0x8:
                    return "GL_CONTEXT_FLAG_NO_ERROR_BIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ContextProfileMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_CONTEXT_CORE_PROFILE_BIT";
                case 0x2:
                    return "GL_CONTEXT_COMPATIBILITY_PROFILE_BIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ConvolutionTarget:
        {
            switch (value)
            {
                case 0x8010:
                    return "GL_CONVOLUTION_1D";
                case 0x8011:
                    return "GL_CONVOLUTION_2D";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ConvolutionTargetEXT:
        {
            switch (value)
            {
                case 0x8010:
                    return "GL_CONVOLUTION_1D";
                case 0x8011:
                    return "GL_CONVOLUTION_2D";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::CopyBufferSubDataTarget:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x9192:
                    return "GL_QUERY_BUFFER";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::CopyImageSubDataTarget:
        {
            switch (value)
            {
                case 0xDE0:
                    return "GL_TEXTURE_1D";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x806F:
                    return "GL_TEXTURE_3D";
                case 0x84F5:
                    return "GL_TEXTURE_RECTANGLE";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8C18:
                    return "GL_TEXTURE_1D_ARRAY";
                case 0x8C1A:
                    return "GL_TEXTURE_2D_ARRAY";
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                case 0x9009:
                    return "GL_TEXTURE_CUBE_MAP_ARRAY";
                case 0x9100:
                    return "GL_TEXTURE_2D_MULTISAMPLE";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::DebugSeverity:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x826B:
                    return "GL_DEBUG_SEVERITY_NOTIFICATION";
                case 0x9146:
                    return "GL_DEBUG_SEVERITY_HIGH";
                case 0x9147:
                    return "GL_DEBUG_SEVERITY_MEDIUM";
                case 0x9148:
                    return "GL_DEBUG_SEVERITY_LOW";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::DebugSource:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x8246:
                    return "GL_DEBUG_SOURCE_API";
                case 0x8247:
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM";
                case 0x8248:
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER";
                case 0x8249:
                    return "GL_DEBUG_SOURCE_THIRD_PARTY";
                case 0x824A:
                    return "GL_DEBUG_SOURCE_APPLICATION";
                case 0x824B:
                    return "GL_DEBUG_SOURCE_OTHER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::DebugType:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x824C:
                    return "GL_DEBUG_TYPE_ERROR";
                case 0x824D:
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR";
                case 0x824E:
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR";
                case 0x824F:
                    return "GL_DEBUG_TYPE_PORTABILITY";
                case 0x8250:
                    return "GL_DEBUG_TYPE_PERFORMANCE";
                case 0x8251:
                    return "GL_DEBUG_TYPE_OTHER";
                case 0x8268:
                    return "GL_DEBUG_TYPE_MARKER";
                case 0x8269:
                    return "GL_DEBUG_TYPE_PUSH_GROUP";
                case 0x826A:
                    return "GL_DEBUG_TYPE_POP_GROUP";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::DepthFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::DepthStencilTextureMode:
        {
            switch (value)
            {
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::DrawBufferMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x400:
                    return "GL_FRONT_LEFT";
                case 0x401:
                    return "GL_FRONT_RIGHT";
                case 0x402:
                    return "GL_BACK_LEFT";
                case 0x403:
                    return "GL_BACK_RIGHT";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x406:
                    return "GL_LEFT";
                case 0x407:
                    return "GL_RIGHT";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                case 0x409:
                    return "GL_AUX0";
                case 0x40A:
                    return "GL_AUX1";
                case 0x40B:
                    return "GL_AUX2";
                case 0x40C:
                    return "GL_AUX3";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::DrawElementsType:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ElementPointerTypeATI:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::EnableCap:
        {
            switch (value)
            {
                case 0xB10:
                    return "GL_POINT_SMOOTH";
                case 0xB20:
                    return "GL_LINE_SMOOTH";
                case 0xB24:
                    return "GL_LINE_STIPPLE";
                case 0xB41:
                    return "GL_POLYGON_SMOOTH";
                case 0xB42:
                    return "GL_POLYGON_STIPPLE";
                case 0xB44:
                    return "GL_CULL_FACE";
                case 0xB50:
                    return "GL_LIGHTING";
                case 0xB57:
                    return "GL_COLOR_MATERIAL";
                case 0xB60:
                    return "GL_FOG";
                case 0xB71:
                    return "GL_DEPTH_TEST";
                case 0xB90:
                    return "GL_STENCIL_TEST";
                case 0xBA1:
                    return "GL_NORMALIZE";
                case 0xBC0:
                    return "GL_ALPHA_TEST";
                case 0xBD0:
                    return "GL_DITHER";
                case 0xBE2:
                    return "GL_BLEND";
                case 0xBF1:
                    return "GL_INDEX_LOGIC_OP";
                case 0xBF2:
                    return "GL_COLOR_LOGIC_OP";
                case 0xC11:
                    return "GL_SCISSOR_TEST";
                case 0xC60:
                    return "GL_TEXTURE_GEN_S";
                case 0xC61:
                    return "GL_TEXTURE_GEN_T";
                case 0xC62:
                    return "GL_TEXTURE_GEN_R";
                case 0xC63:
                    return "GL_TEXTURE_GEN_Q";
                case 0xD80:
                    return "GL_AUTO_NORMAL";
                case 0xD90:
                    return "GL_MAP1_COLOR_4";
                case 0xD91:
                    return "GL_MAP1_INDEX";
                case 0xD92:
                    return "GL_MAP1_NORMAL";
                case 0xD93:
                    return "GL_MAP1_TEXTURE_COORD_1";
                case 0xD94:
                    return "GL_MAP1_TEXTURE_COORD_2";
                case 0xD95:
                    return "GL_MAP1_TEXTURE_COORD_3";
                case 0xD96:
                    return "GL_MAP1_TEXTURE_COORD_4";
                case 0xD97:
                    return "GL_MAP1_VERTEX_3";
                case 0xD98:
                    return "GL_MAP1_VERTEX_4";
                case 0xDB0:
                    return "GL_MAP2_COLOR_4";
                case 0xDB1:
                    return "GL_MAP2_INDEX";
                case 0xDB2:
                    return "GL_MAP2_NORMAL";
                case 0xDB3:
                    return "GL_MAP2_TEXTURE_COORD_1";
                case 0xDB4:
                    return "GL_MAP2_TEXTURE_COORD_2";
                case 0xDB5:
                    return "GL_MAP2_TEXTURE_COORD_3";
                case 0xDB6:
                    return "GL_MAP2_TEXTURE_COORD_4";
                case 0xDB7:
                    return "GL_MAP2_VERTEX_3";
                case 0xDB8:
                    return "GL_MAP2_VERTEX_4";
                case 0xDE0:
                    return "GL_TEXTURE_1D";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x2A01:
                    return "GL_POLYGON_OFFSET_POINT";
                case 0x2A02:
                    return "GL_POLYGON_OFFSET_LINE";
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                case 0x3006:
                    return "GL_CLIP_DISTANCE6";
                case 0x3007:
                    return "GL_CLIP_DISTANCE7";
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x8075:
                    return "GL_NORMAL_ARRAY";
                case 0x8076:
                    return "GL_COLOR_ARRAY";
                case 0x8077:
                    return "GL_INDEX_ARRAY";
                case 0x8078:
                    return "GL_TEXTURE_COORD_ARRAY";
                case 0x8079:
                    return "GL_EDGE_FLAG_ARRAY";
                case 0x809D:
                    return "GL_MULTISAMPLE";
                case 0x809E:
                    return "GL_SAMPLE_ALPHA_TO_COVERAGE";
                case 0x809F:
                    return "GL_SAMPLE_ALPHA_TO_ONE";
                case 0x80A0:
                    return "GL_SAMPLE_COVERAGE";
                case 0x80D0:
                    return "GL_COLOR_TABLE";
                case 0x80D1:
                    return "GL_POST_CONVOLUTION_COLOR_TABLE";
                case 0x80D2:
                    return "GL_POST_COLOR_MATRIX_COLOR_TABLE";
                case 0x8242:
                    return "GL_DEBUG_OUTPUT_SYNCHRONOUS";
                case 0x84F5:
                    return "GL_TEXTURE_RECTANGLE";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8642:
                    return "GL_PROGRAM_POINT_SIZE";
                case 0x864F:
                    return "GL_DEPTH_CLAMP";
                case 0x884F:
                    return "GL_TEXTURE_CUBE_MAP_SEAMLESS";
                case 0x8C36:
                    return "GL_SAMPLE_SHADING";
                case 0x8C89:
                    return "GL_RASTERIZER_DISCARD";
                case 0x8D69:
                    return "GL_PRIMITIVE_RESTART_FIXED_INDEX";
                case 0x8DB9:
                    return "GL_FRAMEBUFFER_SRGB";
                case 0x8E51:
                    return "GL_SAMPLE_MASK";
                case 0x8F9D:
                    return "GL_PRIMITIVE_RESTART";
                case 0x92E0:
                    return "GL_DEBUG_OUTPUT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ErrorCode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NO_ERROR";
                case 0x500:
                    return "GL_INVALID_ENUM";
                case 0x501:
                    return "GL_INVALID_VALUE";
                case 0x502:
                    return "GL_INVALID_OPERATION";
                case 0x503:
                    return "GL_STACK_OVERFLOW";
                case 0x504:
                    return "GL_STACK_UNDERFLOW";
                case 0x505:
                    return "GL_OUT_OF_MEMORY";
                case 0x506:
                    return "GL_INVALID_FRAMEBUFFER_OPERATION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ExternalHandleType:
        {
            switch (value)
            {
                case 0x9586:
                    return "GL_HANDLE_TYPE_OPAQUE_FD_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FeedBackToken:
        {
            switch (value)
            {
                case 0x700:
                    return "GL_PASS_THROUGH_TOKEN";
                case 0x701:
                    return "GL_POINT_TOKEN";
                case 0x702:
                    return "GL_LINE_TOKEN";
                case 0x703:
                    return "GL_POLYGON_TOKEN";
                case 0x704:
                    return "GL_BITMAP_TOKEN";
                case 0x705:
                    return "GL_DRAW_PIXEL_TOKEN";
                case 0x706:
                    return "GL_COPY_PIXEL_TOKEN";
                case 0x707:
                    return "GL_LINE_RESET_TOKEN";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FeedbackType:
        {
            switch (value)
            {
                case 0x600:
                    return "GL_2D";
                case 0x601:
                    return "GL_3D";
                case 0x602:
                    return "GL_3D_COLOR";
                case 0x603:
                    return "GL_3D_COLOR_TEXTURE";
                case 0x604:
                    return "GL_4D_COLOR_TEXTURE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FenceConditionNV:
        {
            switch (value)
            {
                case 0x84F2:
                    return "GL_ALL_COMPLETED_NV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FenceParameterNameNV:
        {
            switch (value)
            {
                case 0x84F3:
                    return "GL_FENCE_STATUS_NV";
                case 0x84F4:
                    return "GL_FENCE_CONDITION_NV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FogCoordSrc:
        {
            switch (value)
            {
                case 0x8451:
                    return "GL_FOG_COORD";
                case 0x8452:
                    return "GL_FRAGMENT_DEPTH";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FogCoordinatePointerType:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FogMode:
        {
            switch (value)
            {
                case 0x800:
                    return "GL_EXP";
                case 0x801:
                    return "GL_EXP2";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FogPName:
        {
            switch (value)
            {
                case 0xB61:
                    return "GL_FOG_INDEX";
                case 0xB62:
                    return "GL_FOG_DENSITY";
                case 0xB63:
                    return "GL_FOG_START";
                case 0xB64:
                    return "GL_FOG_END";
                case 0xB65:
                    return "GL_FOG_MODE";
                case 0x8450:
                    return "GL_FOG_COORD_SRC";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FogParameter:
        {
            switch (value)
            {
                case 0xB61:
                    return "GL_FOG_INDEX";
                case 0xB62:
                    return "GL_FOG_DENSITY";
                case 0xB63:
                    return "GL_FOG_START";
                case 0xB64:
                    return "GL_FOG_END";
                case 0xB65:
                    return "GL_FOG_MODE";
                case 0xB66:
                    return "GL_FOG_COLOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FogPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FogPointerTypeIBM:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FragmentLightParameterSGIX:
        {
            switch (value)
            {
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1203:
                    return "GL_POSITION";
                case 0x1204:
                    return "GL_SPOT_DIRECTION";
                case 0x1205:
                    return "GL_SPOT_EXPONENT";
                case 0x1206:
                    return "GL_SPOT_CUTOFF";
                case 0x1207:
                    return "GL_CONSTANT_ATTENUATION";
                case 0x1208:
                    return "GL_LINEAR_ATTENUATION";
                case 0x1209:
                    return "GL_QUADRATIC_ATTENUATION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FragmentShaderDestMaskATI:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FragmentShaderDestModMaskATI:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FragmentShaderGenericSourceATI:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x1:
                    return "GL_ONE";
                case 0x8577:
                    return "GL_PRIMARY_COLOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FragmentShaderTextureSourceATI:
        {
            switch (value)
            {
                case 0x84C0:
                    return "GL_TEXTURE0";
                case 0x84C1:
                    return "GL_TEXTURE1";
                case 0x84C2:
                    return "GL_TEXTURE2";
                case 0x84C3:
                    return "GL_TEXTURE3";
                case 0x84C4:
                    return "GL_TEXTURE4";
                case 0x84C5:
                    return "GL_TEXTURE5";
                case 0x84C6:
                    return "GL_TEXTURE6";
                case 0x84C7:
                    return "GL_TEXTURE7";
                case 0x84C8:
                    return "GL_TEXTURE8";
                case 0x84C9:
                    return "GL_TEXTURE9";
                case 0x84CA:
                    return "GL_TEXTURE10";
                case 0x84CB:
                    return "GL_TEXTURE11";
                case 0x84CC:
                    return "GL_TEXTURE12";
                case 0x84CD:
                    return "GL_TEXTURE13";
                case 0x84CE:
                    return "GL_TEXTURE14";
                case 0x84CF:
                    return "GL_TEXTURE15";
                case 0x84D0:
                    return "GL_TEXTURE16";
                case 0x84D1:
                    return "GL_TEXTURE17";
                case 0x84D2:
                    return "GL_TEXTURE18";
                case 0x84D3:
                    return "GL_TEXTURE19";
                case 0x84D4:
                    return "GL_TEXTURE20";
                case 0x84D5:
                    return "GL_TEXTURE21";
                case 0x84D6:
                    return "GL_TEXTURE22";
                case 0x84D7:
                    return "GL_TEXTURE23";
                case 0x84D8:
                    return "GL_TEXTURE24";
                case 0x84D9:
                    return "GL_TEXTURE25";
                case 0x84DA:
                    return "GL_TEXTURE26";
                case 0x84DB:
                    return "GL_TEXTURE27";
                case 0x84DC:
                    return "GL_TEXTURE28";
                case 0x84DD:
                    return "GL_TEXTURE29";
                case 0x84DE:
                    return "GL_TEXTURE30";
                case 0x84DF:
                    return "GL_TEXTURE31";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FragmentShaderValueRepATI:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FramebufferAttachment:
        {
            switch (value)
            {
                case 0x821A:
                    return "GL_DEPTH_STENCIL_ATTACHMENT";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                case 0x8D00:
                    return "GL_DEPTH_ATTACHMENT";
                case 0x8D20:
                    return "GL_STENCIL_ATTACHMENT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FramebufferAttachmentParameterName:
        {
            switch (value)
            {
                case 0x8210:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING";
                case 0x8211:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE";
                case 0x8212:
                    return "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE";
                case 0x8213:
                    return "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE";
                case 0x8214:
                    return "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE";
                case 0x8215:
                    return "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE";
                case 0x8216:
                    return "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE";
                case 0x8217:
                    return "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE";
                case 0x8CD0:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE";
                case 0x8CD1:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME";
                case 0x8CD2:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL";
                case 0x8CD3:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE";
                case 0x8CD4:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER";
                case 0x8DA7:
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED";
                case 0x9630:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR";
                case 0x9632:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FramebufferParameterName:
        {
            switch (value)
            {
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FramebufferStatus:
        {
            switch (value)
            {
                case 0x8219:
                    return "GL_FRAMEBUFFER_UNDEFINED";
                case 0x8CD5:
                    return "GL_FRAMEBUFFER_COMPLETE";
                case 0x8CD6:
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                case 0x8CD7:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                case 0x8CDB:
                    return "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
                case 0x8CDC:
                    return "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
                case 0x8CDD:
                    return "GL_FRAMEBUFFER_UNSUPPORTED";
                case 0x8D56:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
                case 0x8DA8:
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FramebufferTarget:
        {
            switch (value)
            {
                case 0x8CA8:
                    return "GL_READ_FRAMEBUFFER";
                case 0x8CA9:
                    return "GL_DRAW_FRAMEBUFFER";
                case 0x8D40:
                    return "GL_FRAMEBUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::FrontFaceDirection:
        {
            switch (value)
            {
                case 0x900:
                    return "GL_CW";
                case 0x901:
                    return "GL_CCW";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::GetFramebufferParameter:
        {
            switch (value)
            {
                case 0xC32:
                    return "GL_DOUBLEBUFFER";
                case 0xC33:
                    return "GL_STEREO";
                case 0x80A8:
                    return "GL_SAMPLE_BUFFERS";
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x8B9A:
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
                case 0x8B9B:
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::GetMapQuery:
        {
            switch (value)
            {
                case 0xA00:
                    return "GL_COEFF";
                case 0xA01:
                    return "GL_ORDER";
                case 0xA02:
                    return "GL_DOMAIN";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::GetMultisamplePNameNV:
        {
            switch (value)
            {
                case 0x8E50:
                    return "GL_SAMPLE_POSITION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::GetPName:
        {
            switch (value)
            {
                case 0xB00:
                    return "GL_CURRENT_COLOR";
                case 0xB01:
                    return "GL_CURRENT_INDEX";
                case 0xB02:
                    return "GL_CURRENT_NORMAL";
                case 0xB03:
                    return "GL_CURRENT_TEXTURE_COORDS";
                case 0xB04:
                    return "GL_CURRENT_RASTER_COLOR";
                case 0xB05:
                    return "GL_CURRENT_RASTER_INDEX";
                case 0xB06:
                    return "GL_CURRENT_RASTER_TEXTURE_COORDS";
                case 0xB07:
                    return "GL_CURRENT_RASTER_POSITION";
                case 0xB08:
                    return "GL_CURRENT_RASTER_POSITION_VALID";
                case 0xB09:
                    return "GL_CURRENT_RASTER_DISTANCE";
                case 0xB10:
                    return "GL_POINT_SMOOTH";
                case 0xB11:
                    return "GL_POINT_SIZE";
                case 0xB12:
                    return "GL_POINT_SIZE_RANGE";
                case 0xB13:
                    return "GL_POINT_SIZE_GRANULARITY";
                case 0xB20:
                    return "GL_LINE_SMOOTH";
                case 0xB21:
                    return "GL_LINE_WIDTH";
                case 0xB22:
                    return "GL_LINE_WIDTH_RANGE";
                case 0xB23:
                    return "GL_LINE_WIDTH_GRANULARITY";
                case 0xB24:
                    return "GL_LINE_STIPPLE";
                case 0xB25:
                    return "GL_LINE_STIPPLE_PATTERN";
                case 0xB26:
                    return "GL_LINE_STIPPLE_REPEAT";
                case 0xB30:
                    return "GL_LIST_MODE";
                case 0xB31:
                    return "GL_MAX_LIST_NESTING";
                case 0xB32:
                    return "GL_LIST_BASE";
                case 0xB33:
                    return "GL_LIST_INDEX";
                case 0xB40:
                    return "GL_POLYGON_MODE";
                case 0xB41:
                    return "GL_POLYGON_SMOOTH";
                case 0xB42:
                    return "GL_POLYGON_STIPPLE";
                case 0xB43:
                    return "GL_EDGE_FLAG";
                case 0xB44:
                    return "GL_CULL_FACE";
                case 0xB45:
                    return "GL_CULL_FACE_MODE";
                case 0xB46:
                    return "GL_FRONT_FACE";
                case 0xB50:
                    return "GL_LIGHTING";
                case 0xB51:
                    return "GL_LIGHT_MODEL_LOCAL_VIEWER";
                case 0xB52:
                    return "GL_LIGHT_MODEL_TWO_SIDE";
                case 0xB53:
                    return "GL_LIGHT_MODEL_AMBIENT";
                case 0xB54:
                    return "GL_SHADE_MODEL";
                case 0xB55:
                    return "GL_COLOR_MATERIAL_FACE";
                case 0xB56:
                    return "GL_COLOR_MATERIAL_PARAMETER";
                case 0xB57:
                    return "GL_COLOR_MATERIAL";
                case 0xB60:
                    return "GL_FOG";
                case 0xB61:
                    return "GL_FOG_INDEX";
                case 0xB62:
                    return "GL_FOG_DENSITY";
                case 0xB63:
                    return "GL_FOG_START";
                case 0xB64:
                    return "GL_FOG_END";
                case 0xB65:
                    return "GL_FOG_MODE";
                case 0xB66:
                    return "GL_FOG_COLOR";
                case 0xB70:
                    return "GL_DEPTH_RANGE";
                case 0xB71:
                    return "GL_DEPTH_TEST";
                case 0xB72:
                    return "GL_DEPTH_WRITEMASK";
                case 0xB73:
                    return "GL_DEPTH_CLEAR_VALUE";
                case 0xB74:
                    return "GL_DEPTH_FUNC";
                case 0xB80:
                    return "GL_ACCUM_CLEAR_VALUE";
                case 0xB90:
                    return "GL_STENCIL_TEST";
                case 0xB91:
                    return "GL_STENCIL_CLEAR_VALUE";
                case 0xB92:
                    return "GL_STENCIL_FUNC";
                case 0xB93:
                    return "GL_STENCIL_VALUE_MASK";
                case 0xB94:
                    return "GL_STENCIL_FAIL";
                case 0xB95:
                    return "GL_STENCIL_PASS_DEPTH_FAIL";
                case 0xB96:
                    return "GL_STENCIL_PASS_DEPTH_PASS";
                case 0xB97:
                    return "GL_STENCIL_REF";
                case 0xB98:
                    return "GL_STENCIL_WRITEMASK";
                case 0xBA0:
                    return "GL_MATRIX_MODE";
                case 0xBA1:
                    return "GL_NORMALIZE";
                case 0xBA2:
                    return "GL_VIEWPORT";
                case 0xBA3:
                    return "GL_MODELVIEW_STACK_DEPTH";
                case 0xBA4:
                    return "GL_PROJECTION_STACK_DEPTH";
                case 0xBA5:
                    return "GL_TEXTURE_STACK_DEPTH";
                case 0xBA6:
                    return "GL_MODELVIEW_MATRIX";
                case 0xBA7:
                    return "GL_PROJECTION_MATRIX";
                case 0xBA8:
                    return "GL_TEXTURE_MATRIX";
                case 0xBB0:
                    return "GL_ATTRIB_STACK_DEPTH";
                case 0xBB1:
                    return "GL_CLIENT_ATTRIB_STACK_DEPTH";
                case 0xBC0:
                    return "GL_ALPHA_TEST";
                case 0xBC1:
                    return "GL_ALPHA_TEST_FUNC";
                case 0xBC2:
                    return "GL_ALPHA_TEST_REF";
                case 0xBD0:
                    return "GL_DITHER";
                case 0xBE0:
                    return "GL_BLEND_DST";
                case 0xBE1:
                    return "GL_BLEND_SRC";
                case 0xBE2:
                    return "GL_BLEND";
                case 0xBF0:
                    return "GL_LOGIC_OP_MODE";
                case 0xBF1:
                    return "GL_LOGIC_OP";
                case 0xBF2:
                    return "GL_COLOR_LOGIC_OP";
                case 0xC00:
                    return "GL_AUX_BUFFERS";
                case 0xC01:
                    return "GL_DRAW_BUFFER";
                case 0xC02:
                    return "GL_READ_BUFFER";
                case 0xC10:
                    return "GL_SCISSOR_BOX";
                case 0xC11:
                    return "GL_SCISSOR_TEST";
                case 0xC20:
                    return "GL_INDEX_CLEAR_VALUE";
                case 0xC21:
                    return "GL_INDEX_WRITEMASK";
                case 0xC22:
                    return "GL_COLOR_CLEAR_VALUE";
                case 0xC23:
                    return "GL_COLOR_WRITEMASK";
                case 0xC30:
                    return "GL_INDEX_MODE";
                case 0xC31:
                    return "GL_RGBA_MODE";
                case 0xC32:
                    return "GL_DOUBLEBUFFER";
                case 0xC33:
                    return "GL_STEREO";
                case 0xC40:
                    return "GL_RENDER_MODE";
                case 0xC50:
                    return "GL_PERSPECTIVE_CORRECTION_HINT";
                case 0xC51:
                    return "GL_POINT_SMOOTH_HINT";
                case 0xC52:
                    return "GL_LINE_SMOOTH_HINT";
                case 0xC53:
                    return "GL_POLYGON_SMOOTH_HINT";
                case 0xC54:
                    return "GL_FOG_HINT";
                case 0xC60:
                    return "GL_TEXTURE_GEN_S";
                case 0xC61:
                    return "GL_TEXTURE_GEN_T";
                case 0xC62:
                    return "GL_TEXTURE_GEN_R";
                case 0xC63:
                    return "GL_TEXTURE_GEN_Q";
                case 0xCB0:
                    return "GL_PIXEL_MAP_I_TO_I_SIZE";
                case 0xCB1:
                    return "GL_PIXEL_MAP_S_TO_S_SIZE";
                case 0xCB2:
                    return "GL_PIXEL_MAP_I_TO_R_SIZE";
                case 0xCB3:
                    return "GL_PIXEL_MAP_I_TO_G_SIZE";
                case 0xCB4:
                    return "GL_PIXEL_MAP_I_TO_B_SIZE";
                case 0xCB5:
                    return "GL_PIXEL_MAP_I_TO_A_SIZE";
                case 0xCB6:
                    return "GL_PIXEL_MAP_R_TO_R_SIZE";
                case 0xCB7:
                    return "GL_PIXEL_MAP_G_TO_G_SIZE";
                case 0xCB8:
                    return "GL_PIXEL_MAP_B_TO_B_SIZE";
                case 0xCB9:
                    return "GL_PIXEL_MAP_A_TO_A_SIZE";
                case 0xCF0:
                    return "GL_UNPACK_SWAP_BYTES";
                case 0xCF1:
                    return "GL_UNPACK_LSB_FIRST";
                case 0xCF2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xCF3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xCF4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xCF5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xD00:
                    return "GL_PACK_SWAP_BYTES";
                case 0xD01:
                    return "GL_PACK_LSB_FIRST";
                case 0xD02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xD03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xD04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xD05:
                    return "GL_PACK_ALIGNMENT";
                case 0xD10:
                    return "GL_MAP_COLOR";
                case 0xD11:
                    return "GL_MAP_STENCIL";
                case 0xD12:
                    return "GL_INDEX_SHIFT";
                case 0xD13:
                    return "GL_INDEX_OFFSET";
                case 0xD14:
                    return "GL_RED_SCALE";
                case 0xD15:
                    return "GL_RED_BIAS";
                case 0xD16:
                    return "GL_ZOOM_X";
                case 0xD17:
                    return "GL_ZOOM_Y";
                case 0xD18:
                    return "GL_GREEN_SCALE";
                case 0xD19:
                    return "GL_GREEN_BIAS";
                case 0xD1A:
                    return "GL_BLUE_SCALE";
                case 0xD1B:
                    return "GL_BLUE_BIAS";
                case 0xD1C:
                    return "GL_ALPHA_SCALE";
                case 0xD1D:
                    return "GL_ALPHA_BIAS";
                case 0xD1E:
                    return "GL_DEPTH_SCALE";
                case 0xD1F:
                    return "GL_DEPTH_BIAS";
                case 0xD30:
                    return "GL_MAX_EVAL_ORDER";
                case 0xD31:
                    return "GL_MAX_LIGHTS";
                case 0xD32:
                    return "GL_MAX_CLIP_PLANES";
                case 0xD33:
                    return "GL_MAX_TEXTURE_SIZE";
                case 0xD34:
                    return "GL_MAX_PIXEL_MAP_TABLE";
                case 0xD35:
                    return "GL_MAX_ATTRIB_STACK_DEPTH";
                case 0xD36:
                    return "GL_MAX_MODELVIEW_STACK_DEPTH";
                case 0xD37:
                    return "GL_MAX_NAME_STACK_DEPTH";
                case 0xD38:
                    return "GL_MAX_PROJECTION_STACK_DEPTH";
                case 0xD39:
                    return "GL_MAX_TEXTURE_STACK_DEPTH";
                case 0xD3A:
                    return "GL_MAX_VIEWPORT_DIMS";
                case 0xD3B:
                    return "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH";
                case 0xD50:
                    return "GL_SUBPIXEL_BITS";
                case 0xD51:
                    return "GL_INDEX_BITS";
                case 0xD52:
                    return "GL_RED_BITS";
                case 0xD53:
                    return "GL_GREEN_BITS";
                case 0xD54:
                    return "GL_BLUE_BITS";
                case 0xD55:
                    return "GL_ALPHA_BITS";
                case 0xD56:
                    return "GL_DEPTH_BITS";
                case 0xD57:
                    return "GL_STENCIL_BITS";
                case 0xD58:
                    return "GL_ACCUM_RED_BITS";
                case 0xD59:
                    return "GL_ACCUM_GREEN_BITS";
                case 0xD5A:
                    return "GL_ACCUM_BLUE_BITS";
                case 0xD5B:
                    return "GL_ACCUM_ALPHA_BITS";
                case 0xD70:
                    return "GL_NAME_STACK_DEPTH";
                case 0xD80:
                    return "GL_AUTO_NORMAL";
                case 0xD90:
                    return "GL_MAP1_COLOR_4";
                case 0xD91:
                    return "GL_MAP1_INDEX";
                case 0xD92:
                    return "GL_MAP1_NORMAL";
                case 0xD93:
                    return "GL_MAP1_TEXTURE_COORD_1";
                case 0xD94:
                    return "GL_MAP1_TEXTURE_COORD_2";
                case 0xD95:
                    return "GL_MAP1_TEXTURE_COORD_3";
                case 0xD96:
                    return "GL_MAP1_TEXTURE_COORD_4";
                case 0xD97:
                    return "GL_MAP1_VERTEX_3";
                case 0xD98:
                    return "GL_MAP1_VERTEX_4";
                case 0xDB0:
                    return "GL_MAP2_COLOR_4";
                case 0xDB1:
                    return "GL_MAP2_INDEX";
                case 0xDB2:
                    return "GL_MAP2_NORMAL";
                case 0xDB3:
                    return "GL_MAP2_TEXTURE_COORD_1";
                case 0xDB4:
                    return "GL_MAP2_TEXTURE_COORD_2";
                case 0xDB5:
                    return "GL_MAP2_TEXTURE_COORD_3";
                case 0xDB6:
                    return "GL_MAP2_TEXTURE_COORD_4";
                case 0xDB7:
                    return "GL_MAP2_VERTEX_3";
                case 0xDB8:
                    return "GL_MAP2_VERTEX_4";
                case 0xDD0:
                    return "GL_MAP1_GRID_DOMAIN";
                case 0xDD1:
                    return "GL_MAP1_GRID_SEGMENTS";
                case 0xDD2:
                    return "GL_MAP2_GRID_DOMAIN";
                case 0xDD3:
                    return "GL_MAP2_GRID_SEGMENTS";
                case 0xDE0:
                    return "GL_TEXTURE_1D";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0xDF1:
                    return "GL_FEEDBACK_BUFFER_SIZE";
                case 0xDF2:
                    return "GL_FEEDBACK_BUFFER_TYPE";
                case 0xDF4:
                    return "GL_SELECTION_BUFFER_SIZE";
                case 0x2A00:
                    return "GL_POLYGON_OFFSET_UNITS";
                case 0x2A01:
                    return "GL_POLYGON_OFFSET_POINT";
                case 0x2A02:
                    return "GL_POLYGON_OFFSET_LINE";
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                case 0x8005:
                    return "GL_BLEND_COLOR";
                case 0x8009:
                    return "GL_BLEND_EQUATION";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8038:
                    return "GL_POLYGON_OFFSET_FACTOR";
                case 0x8068:
                    return "GL_TEXTURE_BINDING_1D";
                case 0x8069:
                    return "GL_TEXTURE_BINDING_2D";
                case 0x806A:
                    return "GL_TEXTURE_BINDING_3D";
                case 0x806B:
                    return "GL_PACK_SKIP_IMAGES";
                case 0x806C:
                    return "GL_PACK_IMAGE_HEIGHT";
                case 0x806D:
                    return "GL_UNPACK_SKIP_IMAGES";
                case 0x806E:
                    return "GL_UNPACK_IMAGE_HEIGHT";
                case 0x8073:
                    return "GL_MAX_3D_TEXTURE_SIZE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x8075:
                    return "GL_NORMAL_ARRAY";
                case 0x8076:
                    return "GL_COLOR_ARRAY";
                case 0x8077:
                    return "GL_INDEX_ARRAY";
                case 0x8078:
                    return "GL_TEXTURE_COORD_ARRAY";
                case 0x8079:
                    return "GL_EDGE_FLAG_ARRAY";
                case 0x807A:
                    return "GL_VERTEX_ARRAY_SIZE";
                case 0x807B:
                    return "GL_VERTEX_ARRAY_TYPE";
                case 0x807C:
                    return "GL_VERTEX_ARRAY_STRIDE";
                case 0x807E:
                    return "GL_NORMAL_ARRAY_TYPE";
                case 0x807F:
                    return "GL_NORMAL_ARRAY_STRIDE";
                case 0x8081:
                    return "GL_COLOR_ARRAY_SIZE";
                case 0x8082:
                    return "GL_COLOR_ARRAY_TYPE";
                case 0x8083:
                    return "GL_COLOR_ARRAY_STRIDE";
                case 0x8085:
                    return "GL_INDEX_ARRAY_TYPE";
                case 0x8086:
                    return "GL_INDEX_ARRAY_STRIDE";
                case 0x8088:
                    return "GL_TEXTURE_COORD_ARRAY_SIZE";
                case 0x8089:
                    return "GL_TEXTURE_COORD_ARRAY_TYPE";
                case 0x808A:
                    return "GL_TEXTURE_COORD_ARRAY_STRIDE";
                case 0x808C:
                    return "GL_EDGE_FLAG_ARRAY_STRIDE";
                case 0x80A8:
                    return "GL_SAMPLE_BUFFERS";
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x80AA:
                    return "GL_SAMPLE_COVERAGE_VALUE";
                case 0x80AB:
                    return "GL_SAMPLE_COVERAGE_INVERT";
                case 0x80C8:
                    return "GL_BLEND_DST_RGB";
                case 0x80C9:
                    return "GL_BLEND_SRC_RGB";
                case 0x80CA:
                    return "GL_BLEND_DST_ALPHA";
                case 0x80CB:
                    return "GL_BLEND_SRC_ALPHA";
                case 0x80E8:
                    return "GL_MAX_ELEMENTS_VERTICES";
                case 0x80E9:
                    return "GL_MAX_ELEMENTS_INDICES";
                case 0x8126:
                    return "GL_POINT_SIZE_MIN";
                case 0x8127:
                    return "GL_POINT_SIZE_MAX";
                case 0x8128:
                    return "GL_POINT_FADE_THRESHOLD_SIZE";
                case 0x8129:
                    return "GL_POINT_DISTANCE_ATTENUATION";
                case 0x81F8:
                    return "GL_LIGHT_MODEL_COLOR_CONTROL";
                case 0x821B:
                    return "GL_MAJOR_VERSION";
                case 0x821C:
                    return "GL_MINOR_VERSION";
                case 0x821D:
                    return "GL_NUM_EXTENSIONS";
                case 0x821E:
                    return "GL_CONTEXT_FLAGS";
                case 0x825A:
                    return "GL_PROGRAM_PIPELINE_BINDING";
                case 0x825B:
                    return "GL_MAX_VIEWPORTS";
                case 0x825C:
                    return "GL_VIEWPORT_SUBPIXEL_BITS";
                case 0x825D:
                    return "GL_VIEWPORT_BOUNDS_RANGE";
                case 0x825E:
                    return "GL_LAYER_PROVOKING_VERTEX";
                case 0x825F:
                    return "GL_VIEWPORT_INDEX_PROVOKING_VERTEX";
                case 0x8263:
                    return "GL_MAX_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8264:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS";
                case 0x8265:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTERS";
                case 0x8266:
                    return "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS";
                case 0x826C:
                    return "GL_MAX_DEBUG_GROUP_STACK_DEPTH";
                case 0x826D:
                    return "GL_DEBUG_GROUP_STACK_DEPTH";
                case 0x826E:
                    return "GL_MAX_UNIFORM_LOCATIONS";
                case 0x82D6:
                    return "GL_VERTEX_BINDING_DIVISOR";
                case 0x82D7:
                    return "GL_VERTEX_BINDING_OFFSET";
                case 0x82D8:
                    return "GL_VERTEX_BINDING_STRIDE";
                case 0x82D9:
                    return "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x82DA:
                    return "GL_MAX_VERTEX_ATTRIB_BINDINGS";
                case 0x82E8:
                    return "GL_MAX_LABEL_LENGTH";
                case 0x846D:
                    return "GL_ALIASED_POINT_SIZE_RANGE";
                case 0x846E:
                    return "GL_ALIASED_LINE_WIDTH_RANGE";
                case 0x84E0:
                    return "GL_ACTIVE_TEXTURE";
                case 0x84E8:
                    return "GL_MAX_RENDERBUFFER_SIZE";
                case 0x84EF:
                    return "GL_TEXTURE_COMPRESSION_HINT";
                case 0x84F6:
                    return "GL_TEXTURE_BINDING_RECTANGLE";
                case 0x84F8:
                    return "GL_MAX_RECTANGLE_TEXTURE_SIZE";
                case 0x84FD:
                    return "GL_MAX_TEXTURE_LOD_BIAS";
                case 0x8514:
                    return "GL_TEXTURE_BINDING_CUBE_MAP";
                case 0x851C:
                    return "GL_MAX_CUBE_MAP_TEXTURE_SIZE";
                case 0x85B5:
                    return "GL_VERTEX_ARRAY_BINDING";
                case 0x8642:
                    return "GL_PROGRAM_POINT_SIZE";
                case 0x86A2:
                    return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
                case 0x86A3:
                    return "GL_COMPRESSED_TEXTURE_FORMATS";
                case 0x87FE:
                    return "GL_NUM_PROGRAM_BINARY_FORMATS";
                case 0x87FF:
                    return "GL_PROGRAM_BINARY_FORMATS";
                case 0x8800:
                    return "GL_STENCIL_BACK_FUNC";
                case 0x8801:
                    return "GL_STENCIL_BACK_FAIL";
                case 0x8802:
                    return "GL_STENCIL_BACK_PASS_DEPTH_FAIL";
                case 0x8803:
                    return "GL_STENCIL_BACK_PASS_DEPTH_PASS";
                case 0x8824:
                    return "GL_MAX_DRAW_BUFFERS";
                case 0x883D:
                    return "GL_BLEND_EQUATION_ALPHA";
                case 0x8869:
                    return "GL_MAX_VERTEX_ATTRIBS";
                case 0x8872:
                    return "GL_MAX_TEXTURE_IMAGE_UNITS";
                case 0x8894:
                    return "GL_ARRAY_BUFFER_BINDING";
                case 0x8895:
                    return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
                case 0x88ED:
                    return "GL_PIXEL_PACK_BUFFER_BINDING";
                case 0x88EF:
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING";
                case 0x88FC:
                    return "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS";
                case 0x88FF:
                    return "GL_MAX_ARRAY_TEXTURE_LAYERS";
                case 0x8904:
                    return "GL_MIN_PROGRAM_TEXEL_OFFSET";
                case 0x8905:
                    return "GL_MAX_PROGRAM_TEXEL_OFFSET";
                case 0x8919:
                    return "GL_SAMPLER_BINDING";
                case 0x8A28:
                    return "GL_UNIFORM_BUFFER_BINDING";
                case 0x8A29:
                    return "GL_UNIFORM_BUFFER_START";
                case 0x8A2A:
                    return "GL_UNIFORM_BUFFER_SIZE";
                case 0x8A2B:
                    return "GL_MAX_VERTEX_UNIFORM_BLOCKS";
                case 0x8A2C:
                    return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS";
                case 0x8A2D:
                    return "GL_MAX_FRAGMENT_UNIFORM_BLOCKS";
                case 0x8A2E:
                    return "GL_MAX_COMBINED_UNIFORM_BLOCKS";
                case 0x8A2F:
                    return "GL_MAX_UNIFORM_BUFFER_BINDINGS";
                case 0x8A30:
                    return "GL_MAX_UNIFORM_BLOCK_SIZE";
                case 0x8A31:
                    return "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS";
                case 0x8A32:
                    return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8A33:
                    return "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8A34:
                    return "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT";
                case 0x8B49:
                    return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8B4A:
                    return "GL_MAX_VERTEX_UNIFORM_COMPONENTS";
                case 0x8B4B:
                    return "GL_MAX_VARYING_FLOATS";
                case 0x8B4C:
                    return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS";
                case 0x8B4D:
                    return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS";
                case 0x8B8B:
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
                case 0x8B8D:
                    return "GL_CURRENT_PROGRAM";
                case 0x8B9A:
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
                case 0x8B9B:
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
                case 0x8C1C:
                    return "GL_TEXTURE_BINDING_1D_ARRAY";
                case 0x8C1D:
                    return "GL_TEXTURE_BINDING_2D_ARRAY";
                case 0x8C29:
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS";
                case 0x8C2B:
                    return "GL_MAX_TEXTURE_BUFFER_SIZE";
                case 0x8C2C:
                    return "GL_TEXTURE_BINDING_BUFFER";
                case 0x8C84:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
                case 0x8C85:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
                case 0x8C8F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
                case 0x8CA3:
                    return "GL_STENCIL_BACK_REF";
                case 0x8CA4:
                    return "GL_STENCIL_BACK_VALUE_MASK";
                case 0x8CA5:
                    return "GL_STENCIL_BACK_WRITEMASK";
                case 0x8CA6:
                    return "GL_DRAW_FRAMEBUFFER_BINDING";
                case 0x8CA7:
                    return "GL_RENDERBUFFER_BINDING";
                case 0x8CAA:
                    return "GL_READ_FRAMEBUFFER_BINDING";
                case 0x8CDF:
                    return "GL_MAX_COLOR_ATTACHMENTS";
                case 0x8D6B:
                    return "GL_MAX_ELEMENT_INDEX";
                case 0x8DDF:
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8DF8:
                    return "GL_SHADER_BINARY_FORMATS";
                case 0x8DF9:
                    return "GL_NUM_SHADER_BINARY_FORMATS";
                case 0x8DFA:
                    return "GL_SHADER_COMPILER";
                case 0x8DFB:
                    return "GL_MAX_VERTEX_UNIFORM_VECTORS";
                case 0x8DFC:
                    return "GL_MAX_VARYING_VECTORS";
                case 0x8DFD:
                    return "GL_MAX_FRAGMENT_UNIFORM_VECTORS";
                case 0x8E28:
                    return "GL_TIMESTAMP";
                case 0x8E4F:
                    return "GL_PROVOKING_VERTEX";
                case 0x8E59:
                    return "GL_MAX_SAMPLE_MASK_WORDS";
                case 0x8E89:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS";
                case 0x8E8A:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS";
                case 0x8F9E:
                    return "GL_PRIMITIVE_RESTART_INDEX";
                case 0x90BC:
                    return "GL_MIN_MAP_BUFFER_ALIGNMENT";
                case 0x90D3:
                    return "GL_SHADER_STORAGE_BUFFER_BINDING";
                case 0x90D4:
                    return "GL_SHADER_STORAGE_BUFFER_START";
                case 0x90D5:
                    return "GL_SHADER_STORAGE_BUFFER_SIZE";
                case 0x90D6:
                    return "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS";
                case 0x90D7:
                    return "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS";
                case 0x90D8:
                    return "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS";
                case 0x90D9:
                    return "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS";
                case 0x90DA:
                    return "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS";
                case 0x90DB:
                    return "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS";
                case 0x90DC:
                    return "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS";
                case 0x90DD:
                    return "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS";
                case 0x90DF:
                    return "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT";
                case 0x90EB:
                    return "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS";
                case 0x90EF:
                    return "GL_DISPATCH_INDIRECT_BUFFER_BINDING";
                case 0x9104:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE";
                case 0x9105:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY";
                case 0x910E:
                    return "GL_MAX_COLOR_TEXTURE_SAMPLES";
                case 0x910F:
                    return "GL_MAX_DEPTH_TEXTURE_SAMPLES";
                case 0x9110:
                    return "GL_MAX_INTEGER_SAMPLES";
                case 0x9111:
                    return "GL_MAX_SERVER_WAIT_TIMEOUT";
                case 0x9122:
                    return "GL_MAX_VERTEX_OUTPUT_COMPONENTS";
                case 0x9123:
                    return "GL_MAX_GEOMETRY_INPUT_COMPONENTS";
                case 0x9124:
                    return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS";
                case 0x9125:
                    return "GL_MAX_FRAGMENT_INPUT_COMPONENTS";
                case 0x9126:
                    return "GL_CONTEXT_PROFILE_MASK";
                case 0x919F:
                    return "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT";
                case 0x91BB:
                    return "GL_MAX_COMPUTE_UNIFORM_BLOCKS";
                case 0x91BC:
                    return "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS";
                case 0x91BE:
                    return "GL_MAX_COMPUTE_WORK_GROUP_COUNT";
                case 0x91BF:
                    return "GL_MAX_COMPUTE_WORK_GROUP_SIZE";
                case 0x92D2:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTERS";
                case 0x92D3:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS";
                case 0x92D4:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS";
                case 0x92D5:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTERS";
                case 0x92D6:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTERS";
                case 0x92D7:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTERS";
                case 0x9315:
                    return "GL_MAX_FRAMEBUFFER_WIDTH";
                case 0x9316:
                    return "GL_MAX_FRAMEBUFFER_HEIGHT";
                case 0x9317:
                    return "GL_MAX_FRAMEBUFFER_LAYERS";
                case 0x9318:
                    return "GL_MAX_FRAMEBUFFER_SAMPLES";
                case 0x9596:
                    return "GL_NUM_DEVICE_UUIDS_EXT";
                case 0x9597:
                    return "GL_DEVICE_UUID_EXT";
                case 0x9598:
                    return "GL_DRIVER_UUID_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::GetPointervPName:
        {
            switch (value)
            {
                case 0xDF0:
                    return "GL_FEEDBACK_BUFFER_POINTER";
                case 0xDF3:
                    return "GL_SELECTION_BUFFER_POINTER";
                case 0x808E:
                    return "GL_VERTEX_ARRAY_POINTER";
                case 0x808F:
                    return "GL_NORMAL_ARRAY_POINTER";
                case 0x8090:
                    return "GL_COLOR_ARRAY_POINTER";
                case 0x8091:
                    return "GL_INDEX_ARRAY_POINTER";
                case 0x8092:
                    return "GL_TEXTURE_COORD_ARRAY_POINTER";
                case 0x8093:
                    return "GL_EDGE_FLAG_ARRAY_POINTER";
                case 0x8244:
                    return "GL_DEBUG_CALLBACK_FUNCTION";
                case 0x8245:
                    return "GL_DEBUG_CALLBACK_USER_PARAM";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::GetTextureParameter:
        {
            switch (value)
            {
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_COMPONENTS";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x1005:
                    return "GL_TEXTURE_BORDER";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x805C:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805D:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805E:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805F:
                    return "GL_TEXTURE_ALPHA_SIZE";
                case 0x8060:
                    return "GL_TEXTURE_LUMINANCE_SIZE";
                case 0x8061:
                    return "GL_TEXTURE_INTENSITY_SIZE";
                case 0x8066:
                    return "GL_TEXTURE_PRIORITY";
                case 0x8067:
                    return "GL_TEXTURE_RESIDENT";
                case 0x8511:
                    return "GL_NORMAL_MAP";
                case 0x8512:
                    return "GL_REFLECTION_MAP";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::GraphicsResetStatus:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NO_ERROR";
                case 0x8253:
                    return "GL_GUILTY_CONTEXT_RESET";
                case 0x8254:
                    return "GL_INNOCENT_CONTEXT_RESET";
                case 0x8255:
                    return "GL_UNKNOWN_CONTEXT_RESET";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::HintMode:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x1101:
                    return "GL_FASTEST";
                case 0x1102:
                    return "GL_NICEST";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::HintTarget:
        {
            switch (value)
            {
                case 0xC50:
                    return "GL_PERSPECTIVE_CORRECTION_HINT";
                case 0xC51:
                    return "GL_POINT_SMOOTH_HINT";
                case 0xC52:
                    return "GL_LINE_SMOOTH_HINT";
                case 0xC53:
                    return "GL_POLYGON_SMOOTH_HINT";
                case 0xC54:
                    return "GL_FOG_HINT";
                case 0x8192:
                    return "GL_GENERATE_MIPMAP_HINT";
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x84EF:
                    return "GL_TEXTURE_COMPRESSION_HINT";
                case 0x8B8B:
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::HistogramTarget:
        {
            switch (value)
            {
                case 0x8024:
                    return "GL_HISTOGRAM";
                case 0x8025:
                    return "GL_PROXY_HISTOGRAM";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::HistogramTargetEXT:
        {
            switch (value)
            {
                case 0x8024:
                    return "GL_HISTOGRAM";
                case 0x8025:
                    return "GL_PROXY_HISTOGRAM";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::IndexFunctionEXT:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::IndexMaterialParameterEXT:
        {
            switch (value)
            {
                case 0xD13:
                    return "GL_INDEX_OFFSET";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::IndexPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::InterleavedArrayFormat:
        {
            switch (value)
            {
                case 0x2A20:
                    return "GL_V2F";
                case 0x2A21:
                    return "GL_V3F";
                case 0x2A22:
                    return "GL_C4UB_V2F";
                case 0x2A23:
                    return "GL_C4UB_V3F";
                case 0x2A24:
                    return "GL_C3F_V3F";
                case 0x2A25:
                    return "GL_N3F_V3F";
                case 0x2A26:
                    return "GL_C4F_N3F_V3F";
                case 0x2A27:
                    return "GL_T2F_V3F";
                case 0x2A28:
                    return "GL_T4F_V4F";
                case 0x2A29:
                    return "GL_T2F_C4UB_V3F";
                case 0x2A2A:
                    return "GL_T2F_C3F_V3F";
                case 0x2A2B:
                    return "GL_T2F_N3F_V3F";
                case 0x2A2C:
                    return "GL_T2F_C4F_N3F_V3F";
                case 0x2A2D:
                    return "GL_T4F_C4F_N3F_V4F";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::InternalFormat:
        {
            switch (value)
            {
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x2A10:
                    return "GL_R3_G3_B2";
                case 0x803B:
                    return "GL_ALPHA4";
                case 0x803C:
                    return "GL_ALPHA8";
                case 0x803D:
                    return "GL_ALPHA12";
                case 0x803E:
                    return "GL_ALPHA16";
                case 0x803F:
                    return "GL_LUMINANCE4";
                case 0x8040:
                    return "GL_LUMINANCE8";
                case 0x8041:
                    return "GL_LUMINANCE12";
                case 0x8042:
                    return "GL_LUMINANCE16";
                case 0x8043:
                    return "GL_LUMINANCE4_ALPHA4";
                case 0x8044:
                    return "GL_LUMINANCE6_ALPHA2";
                case 0x8045:
                    return "GL_LUMINANCE8_ALPHA8";
                case 0x8046:
                    return "GL_LUMINANCE12_ALPHA4";
                case 0x8047:
                    return "GL_LUMINANCE12_ALPHA12";
                case 0x8048:
                    return "GL_LUMINANCE16_ALPHA16";
                case 0x8049:
                    return "GL_INTENSITY";
                case 0x804A:
                    return "GL_INTENSITY4";
                case 0x804B:
                    return "GL_INTENSITY8";
                case 0x804C:
                    return "GL_INTENSITY12";
                case 0x804D:
                    return "GL_INTENSITY16";
                case 0x804F:
                    return "GL_RGB4";
                case 0x8050:
                    return "GL_RGB5";
                case 0x8051:
                    return "GL_RGB8";
                case 0x8052:
                    return "GL_RGB10";
                case 0x8053:
                    return "GL_RGB12";
                case 0x8054:
                    return "GL_RGB16";
                case 0x8055:
                    return "GL_RGBA2";
                case 0x8056:
                    return "GL_RGBA4";
                case 0x8057:
                    return "GL_RGB5_A1";
                case 0x8058:
                    return "GL_RGBA8";
                case 0x8059:
                    return "GL_RGB10_A2";
                case 0x805A:
                    return "GL_RGBA12";
                case 0x805B:
                    return "GL_RGBA16";
                case 0x81A5:
                    return "GL_DEPTH_COMPONENT16";
                case 0x81A6:
                    return "GL_DEPTH_COMPONENT24";
                case 0x81A7:
                    return "GL_DEPTH_COMPONENT32";
                case 0x8225:
                    return "GL_COMPRESSED_RED";
                case 0x8226:
                    return "GL_COMPRESSED_RG";
                case 0x8227:
                    return "GL_RG";
                case 0x8229:
                    return "GL_R8";
                case 0x822A:
                    return "GL_R16";
                case 0x822B:
                    return "GL_RG8";
                case 0x822C:
                    return "GL_RG16";
                case 0x822D:
                    return "GL_R16F";
                case 0x822E:
                    return "GL_R32F";
                case 0x822F:
                    return "GL_RG16F";
                case 0x8230:
                    return "GL_RG32F";
                case 0x8231:
                    return "GL_R8I";
                case 0x8232:
                    return "GL_R8UI";
                case 0x8233:
                    return "GL_R16I";
                case 0x8234:
                    return "GL_R16UI";
                case 0x8235:
                    return "GL_R32I";
                case 0x8236:
                    return "GL_R32UI";
                case 0x8237:
                    return "GL_RG8I";
                case 0x8238:
                    return "GL_RG8UI";
                case 0x8239:
                    return "GL_RG16I";
                case 0x823A:
                    return "GL_RG16UI";
                case 0x823B:
                    return "GL_RG32I";
                case 0x823C:
                    return "GL_RG32UI";
                case 0x83F0:
                    return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
                case 0x83F1:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
                case 0x83F2:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
                case 0x83F3:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
                case 0x84ED:
                    return "GL_COMPRESSED_RGB";
                case 0x84EE:
                    return "GL_COMPRESSED_RGBA";
                case 0x84F9:
                    return "GL_DEPTH_STENCIL";
                case 0x8814:
                    return "GL_RGBA32F";
                case 0x8815:
                    return "GL_RGB32F";
                case 0x881A:
                    return "GL_RGBA16F";
                case 0x881B:
                    return "GL_RGB16F";
                case 0x88F0:
                    return "GL_DEPTH24_STENCIL8";
                case 0x8C3A:
                    return "GL_R11F_G11F_B10F";
                case 0x8C3D:
                    return "GL_RGB9_E5";
                case 0x8C40:
                    return "GL_SRGB";
                case 0x8C41:
                    return "GL_SRGB8";
                case 0x8C42:
                    return "GL_SRGB_ALPHA";
                case 0x8C43:
                    return "GL_SRGB8_ALPHA8";
                case 0x8C48:
                    return "GL_COMPRESSED_SRGB";
                case 0x8C49:
                    return "GL_COMPRESSED_SRGB_ALPHA";
                case 0x8CAC:
                    return "GL_DEPTH_COMPONENT32F";
                case 0x8CAD:
                    return "GL_DEPTH32F_STENCIL8";
                case 0x8D46:
                    return "GL_STENCIL_INDEX1";
                case 0x8D47:
                    return "GL_STENCIL_INDEX4";
                case 0x8D48:
                    return "GL_STENCIL_INDEX8";
                case 0x8D49:
                    return "GL_STENCIL_INDEX16";
                case 0x8D62:
                    return "GL_RGB565";
                case 0x8D70:
                    return "GL_RGBA32UI";
                case 0x8D71:
                    return "GL_RGB32UI";
                case 0x8D76:
                    return "GL_RGBA16UI";
                case 0x8D77:
                    return "GL_RGB16UI";
                case 0x8D7C:
                    return "GL_RGBA8UI";
                case 0x8D7D:
                    return "GL_RGB8UI";
                case 0x8D82:
                    return "GL_RGBA32I";
                case 0x8D83:
                    return "GL_RGB32I";
                case 0x8D88:
                    return "GL_RGBA16I";
                case 0x8D89:
                    return "GL_RGB16I";
                case 0x8D8E:
                    return "GL_RGBA8I";
                case 0x8D8F:
                    return "GL_RGB8I";
                case 0x8DBB:
                    return "GL_COMPRESSED_RED_RGTC1";
                case 0x8DBC:
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1";
                case 0x8DBD:
                    return "GL_COMPRESSED_RG_RGTC2";
                case 0x8DBE:
                    return "GL_COMPRESSED_SIGNED_RG_RGTC2";
                case 0x8E8C:
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM";
                case 0x8E8D:
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM";
                case 0x8E8E:
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT";
                case 0x8E8F:
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT";
                case 0x8F94:
                    return "GL_R8_SNORM";
                case 0x8F95:
                    return "GL_RG8_SNORM";
                case 0x8F96:
                    return "GL_RGB8_SNORM";
                case 0x8F97:
                    return "GL_RGBA8_SNORM";
                case 0x8F98:
                    return "GL_R16_SNORM";
                case 0x8F99:
                    return "GL_RG16_SNORM";
                case 0x8F9A:
                    return "GL_RGB16_SNORM";
                case 0x8F9B:
                    return "GL_RGBA16_SNORM";
                case 0x8FBD:
                    return "GL_SR8_EXT";
                case 0x8FBE:
                    return "GL_SRG8_EXT";
                case 0x906F:
                    return "GL_RGB10_A2UI";
                case 0x9270:
                    return "GL_COMPRESSED_R11_EAC";
                case 0x9271:
                    return "GL_COMPRESSED_SIGNED_R11_EAC";
                case 0x9272:
                    return "GL_COMPRESSED_RG11_EAC";
                case 0x9273:
                    return "GL_COMPRESSED_SIGNED_RG11_EAC";
                case 0x9274:
                    return "GL_COMPRESSED_RGB8_ETC2";
                case 0x9275:
                    return "GL_COMPRESSED_SRGB8_ETC2";
                case 0x9276:
                    return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9277:
                    return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9278:
                    return "GL_COMPRESSED_RGBA8_ETC2_EAC";
                case 0x9279:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
                case 0x93B0:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4_KHR";
                case 0x93B1:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4_KHR";
                case 0x93B2:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5_KHR";
                case 0x93B3:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5_KHR";
                case 0x93B4:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6_KHR";
                case 0x93B5:
                    return "GL_COMPRESSED_RGBA_ASTC_8x5_KHR";
                case 0x93B6:
                    return "GL_COMPRESSED_RGBA_ASTC_8x6_KHR";
                case 0x93B7:
                    return "GL_COMPRESSED_RGBA_ASTC_8x8_KHR";
                case 0x93B8:
                    return "GL_COMPRESSED_RGBA_ASTC_10x5_KHR";
                case 0x93B9:
                    return "GL_COMPRESSED_RGBA_ASTC_10x6_KHR";
                case 0x93BA:
                    return "GL_COMPRESSED_RGBA_ASTC_10x8_KHR";
                case 0x93BB:
                    return "GL_COMPRESSED_RGBA_ASTC_10x10_KHR";
                case 0x93BC:
                    return "GL_COMPRESSED_RGBA_ASTC_12x10_KHR";
                case 0x93BD:
                    return "GL_COMPRESSED_RGBA_ASTC_12x12_KHR";
                case 0x93D0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR";
                case 0x93D1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR";
                case 0x93D2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR";
                case 0x93D3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR";
                case 0x93D4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR";
                case 0x93D5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR";
                case 0x93D6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR";
                case 0x93D7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR";
                case 0x93D8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR";
                case 0x93D9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR";
                case 0x93DA:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR";
                case 0x93DB:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR";
                case 0x93DC:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR";
                case 0x93DD:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::InternalFormatPName:
        {
            switch (value)
            {
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x8191:
                    return "GL_GENERATE_MIPMAP";
                case 0x826F:
                    return "GL_INTERNALFORMAT_SUPPORTED";
                case 0x8270:
                    return "GL_INTERNALFORMAT_PREFERRED";
                case 0x8271:
                    return "GL_INTERNALFORMAT_RED_SIZE";
                case 0x8272:
                    return "GL_INTERNALFORMAT_GREEN_SIZE";
                case 0x8273:
                    return "GL_INTERNALFORMAT_BLUE_SIZE";
                case 0x8274:
                    return "GL_INTERNALFORMAT_ALPHA_SIZE";
                case 0x8275:
                    return "GL_INTERNALFORMAT_DEPTH_SIZE";
                case 0x8276:
                    return "GL_INTERNALFORMAT_STENCIL_SIZE";
                case 0x8277:
                    return "GL_INTERNALFORMAT_SHARED_SIZE";
                case 0x8278:
                    return "GL_INTERNALFORMAT_RED_TYPE";
                case 0x8279:
                    return "GL_INTERNALFORMAT_GREEN_TYPE";
                case 0x827A:
                    return "GL_INTERNALFORMAT_BLUE_TYPE";
                case 0x827B:
                    return "GL_INTERNALFORMAT_ALPHA_TYPE";
                case 0x827C:
                    return "GL_INTERNALFORMAT_DEPTH_TYPE";
                case 0x827D:
                    return "GL_INTERNALFORMAT_STENCIL_TYPE";
                case 0x827E:
                    return "GL_MAX_WIDTH";
                case 0x827F:
                    return "GL_MAX_HEIGHT";
                case 0x8280:
                    return "GL_MAX_DEPTH";
                case 0x8281:
                    return "GL_MAX_LAYERS";
                case 0x8283:
                    return "GL_COLOR_COMPONENTS";
                case 0x8286:
                    return "GL_COLOR_RENDERABLE";
                case 0x8287:
                    return "GL_DEPTH_RENDERABLE";
                case 0x8288:
                    return "GL_STENCIL_RENDERABLE";
                case 0x8289:
                    return "GL_FRAMEBUFFER_RENDERABLE";
                case 0x828A:
                    return "GL_FRAMEBUFFER_RENDERABLE_LAYERED";
                case 0x828B:
                    return "GL_FRAMEBUFFER_BLEND";
                case 0x828C:
                    return "GL_READ_PIXELS";
                case 0x828D:
                    return "GL_READ_PIXELS_FORMAT";
                case 0x828E:
                    return "GL_READ_PIXELS_TYPE";
                case 0x828F:
                    return "GL_TEXTURE_IMAGE_FORMAT";
                case 0x8290:
                    return "GL_TEXTURE_IMAGE_TYPE";
                case 0x8291:
                    return "GL_GET_TEXTURE_IMAGE_FORMAT";
                case 0x8292:
                    return "GL_GET_TEXTURE_IMAGE_TYPE";
                case 0x8293:
                    return "GL_MIPMAP";
                case 0x8295:
                    return "GL_AUTO_GENERATE_MIPMAP";
                case 0x8296:
                    return "GL_COLOR_ENCODING";
                case 0x8297:
                    return "GL_SRGB_READ";
                case 0x8298:
                    return "GL_SRGB_WRITE";
                case 0x829A:
                    return "GL_FILTER";
                case 0x829B:
                    return "GL_VERTEX_TEXTURE";
                case 0x829C:
                    return "GL_TESS_CONTROL_TEXTURE";
                case 0x829D:
                    return "GL_TESS_EVALUATION_TEXTURE";
                case 0x829E:
                    return "GL_GEOMETRY_TEXTURE";
                case 0x829F:
                    return "GL_FRAGMENT_TEXTURE";
                case 0x82A0:
                    return "GL_COMPUTE_TEXTURE";
                case 0x82A1:
                    return "GL_TEXTURE_SHADOW";
                case 0x82A2:
                    return "GL_TEXTURE_GATHER";
                case 0x82A3:
                    return "GL_TEXTURE_GATHER_SHADOW";
                case 0x82A4:
                    return "GL_SHADER_IMAGE_LOAD";
                case 0x82A5:
                    return "GL_SHADER_IMAGE_STORE";
                case 0x82A6:
                    return "GL_SHADER_IMAGE_ATOMIC";
                case 0x82A7:
                    return "GL_IMAGE_TEXEL_SIZE";
                case 0x82A8:
                    return "GL_IMAGE_COMPATIBILITY_CLASS";
                case 0x82A9:
                    return "GL_IMAGE_PIXEL_FORMAT";
                case 0x82AA:
                    return "GL_IMAGE_PIXEL_TYPE";
                case 0x82AC:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST";
                case 0x82AD:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST";
                case 0x82AE:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE";
                case 0x82AF:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE";
                case 0x82B1:
                    return "GL_TEXTURE_COMPRESSED_BLOCK_WIDTH";
                case 0x82B2:
                    return "GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT";
                case 0x82B3:
                    return "GL_TEXTURE_COMPRESSED_BLOCK_SIZE";
                case 0x82B4:
                    return "GL_CLEAR_BUFFER";
                case 0x82B5:
                    return "GL_TEXTURE_VIEW";
                case 0x82B6:
                    return "GL_VIEW_COMPATIBILITY_CLASS";
                case 0x86A1:
                    return "GL_TEXTURE_COMPRESSED";
                case 0x90C7:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE";
                case 0x9365:
                    return "GL_CLEAR_TEXTURE";
                case 0x9380:
                    return "GL_NUM_SAMPLE_COUNTS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::InvalidateFramebufferAttachment:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                case 0x821A:
                    return "GL_DEPTH_STENCIL_ATTACHMENT";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                case 0x8D00:
                    return "GL_DEPTH_ATTACHMENT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::LightEnvModeSGIX:
        {
            switch (value)
            {
                case 0x104:
                    return "GL_ADD";
                case 0x1E01:
                    return "GL_REPLACE";
                case 0x2100:
                    return "GL_MODULATE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::LightModelColorControl:
        {
            switch (value)
            {
                case 0x81F9:
                    return "GL_SINGLE_COLOR";
                case 0x81FA:
                    return "GL_SEPARATE_SPECULAR_COLOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::LightModelParameter:
        {
            switch (value)
            {
                case 0xB51:
                    return "GL_LIGHT_MODEL_LOCAL_VIEWER";
                case 0xB52:
                    return "GL_LIGHT_MODEL_TWO_SIDE";
                case 0xB53:
                    return "GL_LIGHT_MODEL_AMBIENT";
                case 0x81F8:
                    return "GL_LIGHT_MODEL_COLOR_CONTROL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::LightName:
        {
            switch (value)
            {
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::LightParameter:
        {
            switch (value)
            {
                case 0x1203:
                    return "GL_POSITION";
                case 0x1204:
                    return "GL_SPOT_DIRECTION";
                case 0x1205:
                    return "GL_SPOT_EXPONENT";
                case 0x1206:
                    return "GL_SPOT_CUTOFF";
                case 0x1207:
                    return "GL_CONSTANT_ATTENUATION";
                case 0x1208:
                    return "GL_LINEAR_ATTENUATION";
                case 0x1209:
                    return "GL_QUADRATIC_ATTENUATION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::LightTextureModeEXT:
        {
            switch (value)
            {
                case 0x8452:
                    return "GL_FRAGMENT_DEPTH";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ListMode:
        {
            switch (value)
            {
                case 0x1300:
                    return "GL_COMPILE";
                case 0x1301:
                    return "GL_COMPILE_AND_EXECUTE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ListNameType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x1407:
                    return "GL_2_BYTES";
                case 0x1408:
                    return "GL_3_BYTES";
                case 0x1409:
                    return "GL_4_BYTES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::LogicOp:
        {
            switch (value)
            {
                case 0x1500:
                    return "GL_CLEAR";
                case 0x1501:
                    return "GL_AND";
                case 0x1502:
                    return "GL_AND_REVERSE";
                case 0x1503:
                    return "GL_COPY";
                case 0x1504:
                    return "GL_AND_INVERTED";
                case 0x1505:
                    return "GL_NOOP";
                case 0x1506:
                    return "GL_XOR";
                case 0x1507:
                    return "GL_OR";
                case 0x1508:
                    return "GL_NOR";
                case 0x1509:
                    return "GL_EQUIV";
                case 0x150A:
                    return "GL_INVERT";
                case 0x150B:
                    return "GL_OR_REVERSE";
                case 0x150C:
                    return "GL_COPY_INVERTED";
                case 0x150D:
                    return "GL_OR_INVERTED";
                case 0x150E:
                    return "GL_NAND";
                case 0x150F:
                    return "GL_SET";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MapBufferAccessMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_MAP_READ_BIT";
                case 0x2:
                    return "GL_MAP_WRITE_BIT";
                case 0x4:
                    return "GL_MAP_INVALIDATE_RANGE_BIT";
                case 0x8:
                    return "GL_MAP_INVALIDATE_BUFFER_BIT";
                case 0x10:
                    return "GL_MAP_FLUSH_EXPLICIT_BIT";
                case 0x20:
                    return "GL_MAP_UNSYNCHRONIZED_BIT";
                case 0x40:
                    return "GL_MAP_PERSISTENT_BIT";
                case 0x80:
                    return "GL_MAP_COHERENT_BIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MapQuery:
        {
            switch (value)
            {
                case 0xA00:
                    return "GL_COEFF";
                case 0xA01:
                    return "GL_ORDER";
                case 0xA02:
                    return "GL_DOMAIN";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MapTarget:
        {
            switch (value)
            {
                case 0xD90:
                    return "GL_MAP1_COLOR_4";
                case 0xD91:
                    return "GL_MAP1_INDEX";
                case 0xD92:
                    return "GL_MAP1_NORMAL";
                case 0xD93:
                    return "GL_MAP1_TEXTURE_COORD_1";
                case 0xD94:
                    return "GL_MAP1_TEXTURE_COORD_2";
                case 0xD95:
                    return "GL_MAP1_TEXTURE_COORD_3";
                case 0xD96:
                    return "GL_MAP1_TEXTURE_COORD_4";
                case 0xD97:
                    return "GL_MAP1_VERTEX_3";
                case 0xD98:
                    return "GL_MAP1_VERTEX_4";
                case 0xDB0:
                    return "GL_MAP2_COLOR_4";
                case 0xDB1:
                    return "GL_MAP2_INDEX";
                case 0xDB2:
                    return "GL_MAP2_NORMAL";
                case 0xDB3:
                    return "GL_MAP2_TEXTURE_COORD_1";
                case 0xDB4:
                    return "GL_MAP2_TEXTURE_COORD_2";
                case 0xDB5:
                    return "GL_MAP2_TEXTURE_COORD_3";
                case 0xDB6:
                    return "GL_MAP2_TEXTURE_COORD_4";
                case 0xDB7:
                    return "GL_MAP2_VERTEX_3";
                case 0xDB8:
                    return "GL_MAP2_VERTEX_4";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MapTypeNV:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MaterialParameter:
        {
            switch (value)
            {
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1600:
                    return "GL_EMISSION";
                case 0x1601:
                    return "GL_SHININESS";
                case 0x1602:
                    return "GL_AMBIENT_AND_DIFFUSE";
                case 0x1603:
                    return "GL_COLOR_INDEXES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MatrixIndexPointerTypeARB:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MatrixMode:
        {
            switch (value)
            {
                case 0x1700:
                    return "GL_MODELVIEW";
                case 0x1701:
                    return "GL_PROJECTION";
                case 0x1702:
                    return "GL_TEXTURE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MemoryBarrierMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT";
                case 0x2:
                    return "GL_ELEMENT_ARRAY_BARRIER_BIT";
                case 0x4:
                    return "GL_UNIFORM_BARRIER_BIT";
                case 0x8:
                    return "GL_TEXTURE_FETCH_BARRIER_BIT";
                case 0x20:
                    return "GL_SHADER_IMAGE_ACCESS_BARRIER_BIT";
                case 0x40:
                    return "GL_COMMAND_BARRIER_BIT";
                case 0x80:
                    return "GL_PIXEL_BUFFER_BARRIER_BIT";
                case 0x100:
                    return "GL_TEXTURE_UPDATE_BARRIER_BIT";
                case 0x200:
                    return "GL_BUFFER_UPDATE_BARRIER_BIT";
                case 0x400:
                    return "GL_FRAMEBUFFER_BARRIER_BIT";
                case 0x800:
                    return "GL_TRANSFORM_FEEDBACK_BARRIER_BIT";
                case 0x1000:
                    return "GL_ATOMIC_COUNTER_BARRIER_BIT";
                case 0x2000:
                    return "GL_SHADER_STORAGE_BARRIER_BIT";
                case 0x4000:
                    return "GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT";
                case 0x8000:
                    return "GL_QUERY_BUFFER_BARRIER_BIT";
                case 0xFFFFFFFF:
                    return "GL_ALL_BARRIER_BITS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MemoryObjectParameterName:
        {
            switch (value)
            {
                case 0x9581:
                    return "GL_DEDICATED_MEMORY_OBJECT_EXT";
                case 0x959B:
                    return "GL_PROTECTED_MEMORY_OBJECT_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MeshMode1:
        {
            switch (value)
            {
                case 0x1B00:
                    return "GL_POINT";
                case 0x1B01:
                    return "GL_LINE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MeshMode2:
        {
            switch (value)
            {
                case 0x1B00:
                    return "GL_POINT";
                case 0x1B01:
                    return "GL_LINE";
                case 0x1B02:
                    return "GL_FILL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MinmaxTarget:
        {
            switch (value)
            {
                case 0x802E:
                    return "GL_MINMAX";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::MinmaxTargetEXT:
        {
            switch (value)
            {
                case 0x802E:
                    return "GL_MINMAX";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::NormalPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ObjectIdentifier:
        {
            switch (value)
            {
                case 0x1702:
                    return "GL_TEXTURE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x82E0:
                    return "GL_BUFFER";
                case 0x82E1:
                    return "GL_SHADER";
                case 0x82E2:
                    return "GL_PROGRAM";
                case 0x82E3:
                    return "GL_QUERY";
                case 0x82E4:
                    return "GL_PROGRAM_PIPELINE";
                case 0x82E6:
                    return "GL_SAMPLER";
                case 0x8D40:
                    return "GL_FRAMEBUFFER";
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                case 0x8E22:
                    return "GL_TRANSFORM_FEEDBACK";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PatchParameterName:
        {
            switch (value)
            {
                case 0x8E72:
                    return "GL_PATCH_VERTICES";
                case 0x8E73:
                    return "GL_PATCH_DEFAULT_INNER_LEVEL";
                case 0x8E74:
                    return "GL_PATCH_DEFAULT_OUTER_LEVEL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PathColor:
        {
            switch (value)
            {
                case 0x8577:
                    return "GL_PRIMARY_COLOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PathColorFormat:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190A:
                    return "GL_LUMINANCE_ALPHA";
                case 0x8049:
                    return "GL_INTENSITY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PathFillMode:
        {
            switch (value)
            {
                case 0x150A:
                    return "GL_INVERT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PathFontStyle:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PathGenMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x2400:
                    return "GL_EYE_LINEAR";
                case 0x2401:
                    return "GL_OBJECT_LINEAR";
                case 0x8576:
                    return "GL_CONSTANT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PathTransformType:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PipelineParameterName:
        {
            switch (value)
            {
                case 0x8259:
                    return "GL_ACTIVE_PROGRAM";
                case 0x8B30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8B31:
                    return "GL_VERTEX_SHADER";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8DD9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8E87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8E88:
                    return "GL_TESS_CONTROL_SHADER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PixelCopyType:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PixelFormat:
        {
            switch (value)
            {
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1900:
                    return "GL_COLOR_INDEX";
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190A:
                    return "GL_LUMINANCE_ALPHA";
                case 0x80E0:
                    return "GL_BGR";
                case 0x80E1:
                    return "GL_BGRA";
                case 0x8227:
                    return "GL_RG";
                case 0x8228:
                    return "GL_RG_INTEGER";
                case 0x84F9:
                    return "GL_DEPTH_STENCIL";
                case 0x8D94:
                    return "GL_RED_INTEGER";
                case 0x8D95:
                    return "GL_GREEN_INTEGER";
                case 0x8D96:
                    return "GL_BLUE_INTEGER";
                case 0x8D98:
                    return "GL_RGB_INTEGER";
                case 0x8D99:
                    return "GL_RGBA_INTEGER";
                case 0x8D9A:
                    return "GL_BGR_INTEGER";
                case 0x8D9B:
                    return "GL_BGRA_INTEGER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PixelMap:
        {
            switch (value)
            {
                case 0xC70:
                    return "GL_PIXEL_MAP_I_TO_I";
                case 0xC71:
                    return "GL_PIXEL_MAP_S_TO_S";
                case 0xC72:
                    return "GL_PIXEL_MAP_I_TO_R";
                case 0xC73:
                    return "GL_PIXEL_MAP_I_TO_G";
                case 0xC74:
                    return "GL_PIXEL_MAP_I_TO_B";
                case 0xC75:
                    return "GL_PIXEL_MAP_I_TO_A";
                case 0xC76:
                    return "GL_PIXEL_MAP_R_TO_R";
                case 0xC77:
                    return "GL_PIXEL_MAP_G_TO_G";
                case 0xC78:
                    return "GL_PIXEL_MAP_B_TO_B";
                case 0xC79:
                    return "GL_PIXEL_MAP_A_TO_A";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PixelStoreParameter:
        {
            switch (value)
            {
                case 0xCF0:
                    return "GL_UNPACK_SWAP_BYTES";
                case 0xCF1:
                    return "GL_UNPACK_LSB_FIRST";
                case 0xCF2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xCF3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xCF4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xCF5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xD00:
                    return "GL_PACK_SWAP_BYTES";
                case 0xD01:
                    return "GL_PACK_LSB_FIRST";
                case 0xD02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xD03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xD04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xD05:
                    return "GL_PACK_ALIGNMENT";
                case 0x806B:
                    return "GL_PACK_SKIP_IMAGES";
                case 0x806C:
                    return "GL_PACK_IMAGE_HEIGHT";
                case 0x806D:
                    return "GL_UNPACK_SKIP_IMAGES";
                case 0x806E:
                    return "GL_UNPACK_IMAGE_HEIGHT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PixelTexGenModeSGIX:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PixelTransferParameter:
        {
            switch (value)
            {
                case 0xD10:
                    return "GL_MAP_COLOR";
                case 0xD11:
                    return "GL_MAP_STENCIL";
                case 0xD12:
                    return "GL_INDEX_SHIFT";
                case 0xD13:
                    return "GL_INDEX_OFFSET";
                case 0xD14:
                    return "GL_RED_SCALE";
                case 0xD15:
                    return "GL_RED_BIAS";
                case 0xD18:
                    return "GL_GREEN_SCALE";
                case 0xD19:
                    return "GL_GREEN_BIAS";
                case 0xD1A:
                    return "GL_BLUE_SCALE";
                case 0xD1B:
                    return "GL_BLUE_BIAS";
                case 0xD1C:
                    return "GL_ALPHA_SCALE";
                case 0xD1D:
                    return "GL_ALPHA_BIAS";
                case 0xD1E:
                    return "GL_DEPTH_SCALE";
                case 0xD1F:
                    return "GL_DEPTH_BIAS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PixelType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x1A00:
                    return "GL_BITMAP";
                case 0x8032:
                    return "GL_UNSIGNED_BYTE_3_3_2";
                case 0x8033:
                    return "GL_UNSIGNED_SHORT_4_4_4_4";
                case 0x8034:
                    return "GL_UNSIGNED_SHORT_5_5_5_1";
                case 0x8035:
                    return "GL_UNSIGNED_INT_8_8_8_8";
                case 0x8036:
                    return "GL_UNSIGNED_INT_10_10_10_2";
                case 0x8362:
                    return "GL_UNSIGNED_BYTE_2_3_3_REV";
                case 0x8363:
                    return "GL_UNSIGNED_SHORT_5_6_5";
                case 0x8364:
                    return "GL_UNSIGNED_SHORT_5_6_5_REV";
                case 0x8365:
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV";
                case 0x8366:
                    return "GL_UNSIGNED_SHORT_1_5_5_5_REV";
                case 0x8367:
                    return "GL_UNSIGNED_INT_8_8_8_8_REV";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x84FA:
                    return "GL_UNSIGNED_INT_24_8";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8C3E:
                    return "GL_UNSIGNED_INT_5_9_9_9_REV";
                case 0x8DAD:
                    return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PointParameterNameARB:
        {
            switch (value)
            {
                case 0x8126:
                    return "GL_POINT_SIZE_MIN";
                case 0x8127:
                    return "GL_POINT_SIZE_MAX";
                case 0x8128:
                    return "GL_POINT_FADE_THRESHOLD_SIZE";
                case 0x8129:
                    return "GL_POINT_DISTANCE_ATTENUATION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PolygonMode:
        {
            switch (value)
            {
                case 0x1B00:
                    return "GL_POINT";
                case 0x1B01:
                    return "GL_LINE";
                case 0x1B02:
                    return "GL_FILL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PrecisionType:
        {
            switch (value)
            {
                case 0x8DF0:
                    return "GL_LOW_FLOAT";
                case 0x8DF1:
                    return "GL_MEDIUM_FLOAT";
                case 0x8DF2:
                    return "GL_HIGH_FLOAT";
                case 0x8DF3:
                    return "GL_LOW_INT";
                case 0x8DF4:
                    return "GL_MEDIUM_INT";
                case 0x8DF5:
                    return "GL_HIGH_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::PrimitiveType:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_POINTS";
                case 0x1:
                    return "GL_LINES";
                case 0x2:
                    return "GL_LINE_LOOP";
                case 0x3:
                    return "GL_LINE_STRIP";
                case 0x4:
                    return "GL_TRIANGLES";
                case 0x5:
                    return "GL_TRIANGLE_STRIP";
                case 0x6:
                    return "GL_TRIANGLE_FAN";
                case 0x7:
                    return "GL_QUADS";
                case 0x8:
                    return "GL_QUAD_STRIP";
                case 0x9:
                    return "GL_POLYGON";
                case 0xA:
                    return "GL_LINES_ADJACENCY";
                case 0xB:
                    return "GL_LINE_STRIP_ADJACENCY";
                case 0xC:
                    return "GL_TRIANGLES_ADJACENCY";
                case 0xD:
                    return "GL_TRIANGLE_STRIP_ADJACENCY";
                case 0xE:
                    return "GL_PATCHES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ProgramInterface:
        {
            switch (value)
            {
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x92E1:
                    return "GL_UNIFORM";
                case 0x92E2:
                    return "GL_UNIFORM_BLOCK";
                case 0x92E3:
                    return "GL_PROGRAM_INPUT";
                case 0x92E4:
                    return "GL_PROGRAM_OUTPUT";
                case 0x92E5:
                    return "GL_BUFFER_VARIABLE";
                case 0x92E6:
                    return "GL_SHADER_STORAGE_BLOCK";
                case 0x92E8:
                    return "GL_VERTEX_SUBROUTINE";
                case 0x92E9:
                    return "GL_TESS_CONTROL_SUBROUTINE";
                case 0x92EA:
                    return "GL_TESS_EVALUATION_SUBROUTINE";
                case 0x92EB:
                    return "GL_GEOMETRY_SUBROUTINE";
                case 0x92EC:
                    return "GL_FRAGMENT_SUBROUTINE";
                case 0x92ED:
                    return "GL_COMPUTE_SUBROUTINE";
                case 0x92EE:
                    return "GL_VERTEX_SUBROUTINE_UNIFORM";
                case 0x92EF:
                    return "GL_TESS_CONTROL_SUBROUTINE_UNIFORM";
                case 0x92F0:
                    return "GL_TESS_EVALUATION_SUBROUTINE_UNIFORM";
                case 0x92F1:
                    return "GL_GEOMETRY_SUBROUTINE_UNIFORM";
                case 0x92F2:
                    return "GL_FRAGMENT_SUBROUTINE_UNIFORM";
                case 0x92F3:
                    return "GL_COMPUTE_SUBROUTINE_UNIFORM";
                case 0x92F4:
                    return "GL_TRANSFORM_FEEDBACK_VARYING";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ProgramInterfacePName:
        {
            switch (value)
            {
                case 0x92F5:
                    return "GL_ACTIVE_RESOURCES";
                case 0x92F6:
                    return "GL_MAX_NAME_LENGTH";
                case 0x92F7:
                    return "GL_MAX_NUM_ACTIVE_VARIABLES";
                case 0x92F8:
                    return "GL_MAX_NUM_COMPATIBLE_SUBROUTINES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ProgramParameterPName:
        {
            switch (value)
            {
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x8258:
                    return "GL_PROGRAM_SEPARABLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ProgramPropertyARB:
        {
            switch (value)
            {
                case 0x8267:
                    return "GL_COMPUTE_WORK_GROUP_SIZE";
                case 0x8741:
                    return "GL_PROGRAM_BINARY_LENGTH";
                case 0x8916:
                    return "GL_GEOMETRY_VERTICES_OUT";
                case 0x8917:
                    return "GL_GEOMETRY_INPUT_TYPE";
                case 0x8918:
                    return "GL_GEOMETRY_OUTPUT_TYPE";
                case 0x8A35:
                    return "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH";
                case 0x8A36:
                    return "GL_ACTIVE_UNIFORM_BLOCKS";
                case 0x8B80:
                    return "GL_DELETE_STATUS";
                case 0x8B82:
                    return "GL_LINK_STATUS";
                case 0x8B83:
                    return "GL_VALIDATE_STATUS";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8B85:
                    return "GL_ATTACHED_SHADERS";
                case 0x8B86:
                    return "GL_ACTIVE_UNIFORMS";
                case 0x8B87:
                    return "GL_ACTIVE_UNIFORM_MAX_LENGTH";
                case 0x8B89:
                    return "GL_ACTIVE_ATTRIBUTES";
                case 0x8B8A:
                    return "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH";
                case 0x8C76:
                    return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH";
                case 0x8C7F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE";
                case 0x8C83:
                    return "GL_TRANSFORM_FEEDBACK_VARYINGS";
                case 0x92D9:
                    return "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ProgramResourceProperty:
        {
            switch (value)
            {
                case 0x8E4A:
                    return "GL_NUM_COMPATIBLE_SUBROUTINES";
                case 0x8E4B:
                    return "GL_COMPATIBLE_SUBROUTINES";
                case 0x92E1:
                    return "GL_UNIFORM";
                case 0x92E7:
                    return "GL_IS_PER_PATCH";
                case 0x92F9:
                    return "GL_NAME_LENGTH";
                case 0x92FA:
                    return "GL_TYPE";
                case 0x92FB:
                    return "GL_ARRAY_SIZE";
                case 0x92FC:
                    return "GL_OFFSET";
                case 0x92FD:
                    return "GL_BLOCK_INDEX";
                case 0x92FE:
                    return "GL_ARRAY_STRIDE";
                case 0x92FF:
                    return "GL_MATRIX_STRIDE";
                case 0x9300:
                    return "GL_IS_ROW_MAJOR";
                case 0x9301:
                    return "GL_ATOMIC_COUNTER_BUFFER_INDEX";
                case 0x9302:
                    return "GL_BUFFER_BINDING";
                case 0x9303:
                    return "GL_BUFFER_DATA_SIZE";
                case 0x9304:
                    return "GL_NUM_ACTIVE_VARIABLES";
                case 0x9305:
                    return "GL_ACTIVE_VARIABLES";
                case 0x9306:
                    return "GL_REFERENCED_BY_VERTEX_SHADER";
                case 0x9307:
                    return "GL_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x9308:
                    return "GL_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x9309:
                    return "GL_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x930A:
                    return "GL_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x930B:
                    return "GL_REFERENCED_BY_COMPUTE_SHADER";
                case 0x930C:
                    return "GL_TOP_LEVEL_ARRAY_SIZE";
                case 0x930D:
                    return "GL_TOP_LEVEL_ARRAY_STRIDE";
                case 0x930E:
                    return "GL_LOCATION";
                case 0x930F:
                    return "GL_LOCATION_INDEX";
                case 0x934A:
                    return "GL_LOCATION_COMPONENT";
                case 0x934B:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_INDEX";
                case 0x934C:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ProgramStagePName:
        {
            switch (value)
            {
                case 0x8DE5:
                    return "GL_ACTIVE_SUBROUTINES";
                case 0x8DE6:
                    return "GL_ACTIVE_SUBROUTINE_UNIFORMS";
                case 0x8E47:
                    return "GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS";
                case 0x8E48:
                    return "GL_ACTIVE_SUBROUTINE_MAX_LENGTH";
                case 0x8E49:
                    return "GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::QueryCounterTarget:
        {
            switch (value)
            {
                case 0x8E28:
                    return "GL_TIMESTAMP";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::QueryObjectParameterName:
        {
            switch (value)
            {
                case 0x82EA:
                    return "GL_QUERY_TARGET";
                case 0x8866:
                    return "GL_QUERY_RESULT";
                case 0x8867:
                    return "GL_QUERY_RESULT_AVAILABLE";
                case 0x9194:
                    return "GL_QUERY_RESULT_NO_WAIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::QueryParameterName:
        {
            switch (value)
            {
                case 0x8864:
                    return "GL_QUERY_COUNTER_BITS";
                case 0x8865:
                    return "GL_CURRENT_QUERY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::QueryTarget:
        {
            switch (value)
            {
                case 0x82EC:
                    return "GL_TRANSFORM_FEEDBACK_OVERFLOW";
                case 0x82EE:
                    return "GL_VERTICES_SUBMITTED";
                case 0x82EF:
                    return "GL_PRIMITIVES_SUBMITTED";
                case 0x82F0:
                    return "GL_VERTEX_SHADER_INVOCATIONS";
                case 0x88BF:
                    return "GL_TIME_ELAPSED";
                case 0x8914:
                    return "GL_SAMPLES_PASSED";
                case 0x8C2F:
                    return "GL_ANY_SAMPLES_PASSED";
                case 0x8C87:
                    return "GL_PRIMITIVES_GENERATED";
                case 0x8C88:
                    return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN";
                case 0x8D6A:
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ReadBufferMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x400:
                    return "GL_FRONT_LEFT";
                case 0x401:
                    return "GL_FRONT_RIGHT";
                case 0x402:
                    return "GL_BACK_LEFT";
                case 0x403:
                    return "GL_BACK_RIGHT";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x406:
                    return "GL_LEFT";
                case 0x407:
                    return "GL_RIGHT";
                case 0x409:
                    return "GL_AUX0";
                case 0x40A:
                    return "GL_AUX1";
                case 0x40B:
                    return "GL_AUX2";
                case 0x40C:
                    return "GL_AUX3";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::RenderbufferParameterName:
        {
            switch (value)
            {
                case 0x8CAB:
                    return "GL_RENDERBUFFER_SAMPLES";
                case 0x8D42:
                    return "GL_RENDERBUFFER_WIDTH";
                case 0x8D43:
                    return "GL_RENDERBUFFER_HEIGHT";
                case 0x8D44:
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT";
                case 0x8D50:
                    return "GL_RENDERBUFFER_RED_SIZE";
                case 0x8D51:
                    return "GL_RENDERBUFFER_GREEN_SIZE";
                case 0x8D52:
                    return "GL_RENDERBUFFER_BLUE_SIZE";
                case 0x8D53:
                    return "GL_RENDERBUFFER_ALPHA_SIZE";
                case 0x8D54:
                    return "GL_RENDERBUFFER_DEPTH_SIZE";
                case 0x8D55:
                    return "GL_RENDERBUFFER_STENCIL_SIZE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::RenderbufferTarget:
        {
            switch (value)
            {
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::RenderingMode:
        {
            switch (value)
            {
                case 0x1C00:
                    return "GL_RENDER";
                case 0x1C01:
                    return "GL_FEEDBACK";
                case 0x1C02:
                    return "GL_SELECT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ReplacementCodeTypeSUN:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SamplerParameterF:
        {
            switch (value)
            {
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x813A:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813B:
                    return "GL_TEXTURE_MAX_LOD";
                case 0x84FE:
                    return "GL_TEXTURE_MAX_ANISOTROPY";
                case 0x8501:
                    return "GL_TEXTURE_LOD_BIAS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SamplerParameterI:
        {
            switch (value)
            {
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x884C:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884D:
                    return "GL_TEXTURE_COMPARE_FUNC";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ScalarType:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SecondaryColorPointerTypeIBM:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SeparableTarget:
        {
            switch (value)
            {
                case 0x8012:
                    return "GL_SEPARABLE_2D";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SeparableTargetEXT:
        {
            switch (value)
            {
                case 0x8012:
                    return "GL_SEPARABLE_2D";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ShaderBinaryFormat:
        {
            switch (value)
            {
                case 0x9551:
                    return "GL_SHADER_BINARY_FORMAT_SPIR_V";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ShaderParameterName:
        {
            switch (value)
            {
                case 0x8B4F:
                    return "GL_SHADER_TYPE";
                case 0x8B80:
                    return "GL_DELETE_STATUS";
                case 0x8B81:
                    return "GL_COMPILE_STATUS";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8B88:
                    return "GL_SHADER_SOURCE_LENGTH";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ShaderType:
        {
            switch (value)
            {
                case 0x8B30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8B31:
                    return "GL_VERTEX_SHADER";
                case 0x8DD9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8E87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8E88:
                    return "GL_TESS_CONTROL_SHADER";
                case 0x91B9:
                    return "GL_COMPUTE_SHADER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::ShadingModel:
        {
            switch (value)
            {
                case 0x1D00:
                    return "GL_FLAT";
                case 0x1D01:
                    return "GL_SMOOTH";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SizedInternalFormat:
        {
            switch (value)
            {
                case 0x2A10:
                    return "GL_R3_G3_B2";
                case 0x803B:
                    return "GL_ALPHA4";
                case 0x803C:
                    return "GL_ALPHA8";
                case 0x803D:
                    return "GL_ALPHA12";
                case 0x803E:
                    return "GL_ALPHA16";
                case 0x803F:
                    return "GL_LUMINANCE4";
                case 0x8040:
                    return "GL_LUMINANCE8";
                case 0x8041:
                    return "GL_LUMINANCE12";
                case 0x8042:
                    return "GL_LUMINANCE16";
                case 0x8043:
                    return "GL_LUMINANCE4_ALPHA4";
                case 0x8044:
                    return "GL_LUMINANCE6_ALPHA2";
                case 0x8045:
                    return "GL_LUMINANCE8_ALPHA8";
                case 0x8046:
                    return "GL_LUMINANCE12_ALPHA4";
                case 0x8047:
                    return "GL_LUMINANCE12_ALPHA12";
                case 0x8048:
                    return "GL_LUMINANCE16_ALPHA16";
                case 0x804A:
                    return "GL_INTENSITY4";
                case 0x804B:
                    return "GL_INTENSITY8";
                case 0x804C:
                    return "GL_INTENSITY12";
                case 0x804D:
                    return "GL_INTENSITY16";
                case 0x804F:
                    return "GL_RGB4";
                case 0x8050:
                    return "GL_RGB5";
                case 0x8051:
                    return "GL_RGB8";
                case 0x8052:
                    return "GL_RGB10";
                case 0x8053:
                    return "GL_RGB12";
                case 0x8054:
                    return "GL_RGB16";
                case 0x8055:
                    return "GL_RGBA2";
                case 0x8056:
                    return "GL_RGBA4";
                case 0x8057:
                    return "GL_RGB5_A1";
                case 0x8058:
                    return "GL_RGBA8";
                case 0x8059:
                    return "GL_RGB10_A2";
                case 0x805A:
                    return "GL_RGBA12";
                case 0x805B:
                    return "GL_RGBA16";
                case 0x81A5:
                    return "GL_DEPTH_COMPONENT16";
                case 0x81A6:
                    return "GL_DEPTH_COMPONENT24";
                case 0x81A7:
                    return "GL_DEPTH_COMPONENT32";
                case 0x8229:
                    return "GL_R8";
                case 0x822A:
                    return "GL_R16";
                case 0x822B:
                    return "GL_RG8";
                case 0x822C:
                    return "GL_RG16";
                case 0x822D:
                    return "GL_R16F";
                case 0x822E:
                    return "GL_R32F";
                case 0x822F:
                    return "GL_RG16F";
                case 0x8230:
                    return "GL_RG32F";
                case 0x8231:
                    return "GL_R8I";
                case 0x8232:
                    return "GL_R8UI";
                case 0x8233:
                    return "GL_R16I";
                case 0x8234:
                    return "GL_R16UI";
                case 0x8235:
                    return "GL_R32I";
                case 0x8236:
                    return "GL_R32UI";
                case 0x8237:
                    return "GL_RG8I";
                case 0x8238:
                    return "GL_RG8UI";
                case 0x8239:
                    return "GL_RG16I";
                case 0x823A:
                    return "GL_RG16UI";
                case 0x823B:
                    return "GL_RG32I";
                case 0x823C:
                    return "GL_RG32UI";
                case 0x83F0:
                    return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
                case 0x83F1:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
                case 0x83F2:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
                case 0x83F3:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
                case 0x8814:
                    return "GL_RGBA32F";
                case 0x8815:
                    return "GL_RGB32F";
                case 0x881A:
                    return "GL_RGBA16F";
                case 0x881B:
                    return "GL_RGB16F";
                case 0x88F0:
                    return "GL_DEPTH24_STENCIL8";
                case 0x8C3A:
                    return "GL_R11F_G11F_B10F";
                case 0x8C3D:
                    return "GL_RGB9_E5";
                case 0x8C41:
                    return "GL_SRGB8";
                case 0x8C43:
                    return "GL_SRGB8_ALPHA8";
                case 0x8CAC:
                    return "GL_DEPTH_COMPONENT32F";
                case 0x8CAD:
                    return "GL_DEPTH32F_STENCIL8";
                case 0x8D46:
                    return "GL_STENCIL_INDEX1";
                case 0x8D47:
                    return "GL_STENCIL_INDEX4";
                case 0x8D48:
                    return "GL_STENCIL_INDEX8";
                case 0x8D49:
                    return "GL_STENCIL_INDEX16";
                case 0x8D62:
                    return "GL_RGB565";
                case 0x8D70:
                    return "GL_RGBA32UI";
                case 0x8D71:
                    return "GL_RGB32UI";
                case 0x8D76:
                    return "GL_RGBA16UI";
                case 0x8D77:
                    return "GL_RGB16UI";
                case 0x8D7C:
                    return "GL_RGBA8UI";
                case 0x8D7D:
                    return "GL_RGB8UI";
                case 0x8D82:
                    return "GL_RGBA32I";
                case 0x8D83:
                    return "GL_RGB32I";
                case 0x8D88:
                    return "GL_RGBA16I";
                case 0x8D89:
                    return "GL_RGB16I";
                case 0x8D8E:
                    return "GL_RGBA8I";
                case 0x8D8F:
                    return "GL_RGB8I";
                case 0x8DBB:
                    return "GL_COMPRESSED_RED_RGTC1";
                case 0x8DBC:
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1";
                case 0x8DBD:
                    return "GL_COMPRESSED_RG_RGTC2";
                case 0x8DBE:
                    return "GL_COMPRESSED_SIGNED_RG_RGTC2";
                case 0x8E8C:
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM";
                case 0x8E8D:
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM";
                case 0x8E8E:
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT";
                case 0x8E8F:
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT";
                case 0x8F94:
                    return "GL_R8_SNORM";
                case 0x8F95:
                    return "GL_RG8_SNORM";
                case 0x8F96:
                    return "GL_RGB8_SNORM";
                case 0x8F97:
                    return "GL_RGBA8_SNORM";
                case 0x8F98:
                    return "GL_R16_SNORM";
                case 0x8F99:
                    return "GL_RG16_SNORM";
                case 0x8F9A:
                    return "GL_RGB16_SNORM";
                case 0x8F9B:
                    return "GL_RGBA16_SNORM";
                case 0x906F:
                    return "GL_RGB10_A2UI";
                case 0x9270:
                    return "GL_COMPRESSED_R11_EAC";
                case 0x9271:
                    return "GL_COMPRESSED_SIGNED_R11_EAC";
                case 0x9272:
                    return "GL_COMPRESSED_RG11_EAC";
                case 0x9273:
                    return "GL_COMPRESSED_SIGNED_RG11_EAC";
                case 0x9274:
                    return "GL_COMPRESSED_RGB8_ETC2";
                case 0x9275:
                    return "GL_COMPRESSED_SRGB8_ETC2";
                case 0x9276:
                    return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9277:
                    return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9278:
                    return "GL_COMPRESSED_RGBA8_ETC2_EAC";
                case 0x9279:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
                case 0x93B0:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4_KHR";
                case 0x93B1:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4_KHR";
                case 0x93B2:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5_KHR";
                case 0x93B3:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5_KHR";
                case 0x93B4:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6_KHR";
                case 0x93B5:
                    return "GL_COMPRESSED_RGBA_ASTC_8x5_KHR";
                case 0x93B6:
                    return "GL_COMPRESSED_RGBA_ASTC_8x6_KHR";
                case 0x93B7:
                    return "GL_COMPRESSED_RGBA_ASTC_8x8_KHR";
                case 0x93B8:
                    return "GL_COMPRESSED_RGBA_ASTC_10x5_KHR";
                case 0x93B9:
                    return "GL_COMPRESSED_RGBA_ASTC_10x6_KHR";
                case 0x93BA:
                    return "GL_COMPRESSED_RGBA_ASTC_10x8_KHR";
                case 0x93BB:
                    return "GL_COMPRESSED_RGBA_ASTC_10x10_KHR";
                case 0x93BC:
                    return "GL_COMPRESSED_RGBA_ASTC_12x10_KHR";
                case 0x93BD:
                    return "GL_COMPRESSED_RGBA_ASTC_12x12_KHR";
                case 0x93D0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR";
                case 0x93D1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR";
                case 0x93D2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR";
                case 0x93D3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR";
                case 0x93D4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR";
                case 0x93D5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR";
                case 0x93D6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR";
                case 0x93D7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR";
                case 0x93D8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR";
                case 0x93D9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR";
                case 0x93DA:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR";
                case 0x93DB:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR";
                case 0x93DC:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR";
                case 0x93DD:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::StencilFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::StencilOp:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x150A:
                    return "GL_INVERT";
                case 0x1E00:
                    return "GL_KEEP";
                case 0x1E01:
                    return "GL_REPLACE";
                case 0x1E02:
                    return "GL_INCR";
                case 0x1E03:
                    return "GL_DECR";
                case 0x8507:
                    return "GL_INCR_WRAP";
                case 0x8508:
                    return "GL_DECR_WRAP";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::StringName:
        {
            switch (value)
            {
                case 0x1F00:
                    return "GL_VENDOR";
                case 0x1F01:
                    return "GL_RENDERER";
                case 0x1F02:
                    return "GL_VERSION";
                case 0x1F03:
                    return "GL_EXTENSIONS";
                case 0x8B8C:
                    return "GL_SHADING_LANGUAGE_VERSION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SubroutineParameterName:
        {
            switch (value)
            {
                case 0x8A38:
                    return "GL_UNIFORM_SIZE";
                case 0x8A39:
                    return "GL_UNIFORM_NAME_LENGTH";
                case 0x8E4A:
                    return "GL_NUM_COMPATIBLE_SUBROUTINES";
                case 0x8E4B:
                    return "GL_COMPATIBLE_SUBROUTINES";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SyncBehaviorFlags:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SyncCondition:
        {
            switch (value)
            {
                case 0x9117:
                    return "GL_SYNC_GPU_COMMANDS_COMPLETE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SyncObjectMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_SYNC_FLUSH_COMMANDS_BIT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SyncParameterName:
        {
            switch (value)
            {
                case 0x9112:
                    return "GL_OBJECT_TYPE";
                case 0x9113:
                    return "GL_SYNC_CONDITION";
                case 0x9114:
                    return "GL_SYNC_STATUS";
                case 0x9115:
                    return "GL_SYNC_FLAGS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::SyncStatus:
        {
            switch (value)
            {
                case 0x911A:
                    return "GL_ALREADY_SIGNALED";
                case 0x911B:
                    return "GL_TIMEOUT_EXPIRED";
                case 0x911C:
                    return "GL_CONDITION_SATISFIED";
                case 0x911D:
                    return "GL_WAIT_FAILED";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TangentPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TexCoordPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureCompareMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x884E:
                    return "GL_COMPARE_R_TO_TEXTURE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureCoordName:
        {
            switch (value)
            {
                case 0x2000:
                    return "GL_S";
                case 0x2001:
                    return "GL_T";
                case 0x2002:
                    return "GL_R";
                case 0x2003:
                    return "GL_Q";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureEnvMode:
        {
            switch (value)
            {
                case 0x104:
                    return "GL_ADD";
                case 0xBE2:
                    return "GL_BLEND";
                case 0x2100:
                    return "GL_MODULATE";
                case 0x2101:
                    return "GL_DECAL";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureEnvParameter:
        {
            switch (value)
            {
                case 0x2200:
                    return "GL_TEXTURE_ENV_MODE";
                case 0x2201:
                    return "GL_TEXTURE_ENV_COLOR";
                case 0x8570:
                    return "GL_COMBINE";
                case 0x8571:
                    return "GL_COMBINE_RGB";
                case 0x8572:
                    return "GL_COMBINE_ALPHA";
                case 0x8573:
                    return "GL_RGB_SCALE";
                case 0x8574:
                    return "GL_ADD_SIGNED";
                case 0x8575:
                    return "GL_INTERPOLATE";
                case 0x8576:
                    return "GL_CONSTANT";
                case 0x8577:
                    return "GL_PRIMARY_COLOR";
                case 0x8578:
                    return "GL_PREVIOUS";
                case 0x8580:
                    return "GL_SRC0_RGB";
                case 0x8581:
                    return "GL_SRC1_RGB";
                case 0x8582:
                    return "GL_SRC2_RGB";
                case 0x8588:
                    return "GL_SRC0_ALPHA";
                case 0x8589:
                    return "GL_SRC1_ALPHA";
                case 0x858A:
                    return "GL_SRC2_ALPHA";
                case 0x8590:
                    return "GL_OPERAND0_RGB";
                case 0x8591:
                    return "GL_OPERAND1_RGB";
                case 0x8592:
                    return "GL_OPERAND2_RGB";
                case 0x8598:
                    return "GL_OPERAND0_ALPHA";
                case 0x8599:
                    return "GL_OPERAND1_ALPHA";
                case 0x859A:
                    return "GL_OPERAND2_ALPHA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureEnvTarget:
        {
            switch (value)
            {
                case 0x2300:
                    return "GL_TEXTURE_ENV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureGenMode:
        {
            switch (value)
            {
                case 0x2400:
                    return "GL_EYE_LINEAR";
                case 0x2401:
                    return "GL_OBJECT_LINEAR";
                case 0x2402:
                    return "GL_SPHERE_MAP";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureGenParameter:
        {
            switch (value)
            {
                case 0x2500:
                    return "GL_TEXTURE_GEN_MODE";
                case 0x2501:
                    return "GL_OBJECT_PLANE";
                case 0x2502:
                    return "GL_EYE_PLANE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureLayout:
        {
            switch (value)
            {
                case 0x9530:
                    return "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT";
                case 0x9531:
                    return "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT";
                case 0x958D:
                    return "GL_LAYOUT_GENERAL_EXT";
                case 0x958E:
                    return "GL_LAYOUT_COLOR_ATTACHMENT_EXT";
                case 0x958F:
                    return "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT";
                case 0x9590:
                    return "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT";
                case 0x9591:
                    return "GL_LAYOUT_SHADER_READ_ONLY_EXT";
                case 0x9592:
                    return "GL_LAYOUT_TRANSFER_SRC_EXT";
                case 0x9593:
                    return "GL_LAYOUT_TRANSFER_DST_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureMagFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureMinFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                case 0x2700:
                    return "GL_NEAREST_MIPMAP_NEAREST";
                case 0x2701:
                    return "GL_LINEAR_MIPMAP_NEAREST";
                case 0x2702:
                    return "GL_NEAREST_MIPMAP_LINEAR";
                case 0x2703:
                    return "GL_LINEAR_MIPMAP_LINEAR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureParameterName:
        {
            switch (value)
            {
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_COMPONENTS";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x1005:
                    return "GL_TEXTURE_BORDER";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x805C:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805D:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805E:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805F:
                    return "GL_TEXTURE_ALPHA_SIZE";
                case 0x8060:
                    return "GL_TEXTURE_LUMINANCE_SIZE";
                case 0x8061:
                    return "GL_TEXTURE_INTENSITY_SIZE";
                case 0x8066:
                    return "GL_TEXTURE_PRIORITY";
                case 0x8067:
                    return "GL_TEXTURE_RESIDENT";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x813A:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813B:
                    return "GL_TEXTURE_MAX_LOD";
                case 0x813C:
                    return "GL_TEXTURE_BASE_LEVEL";
                case 0x813D:
                    return "GL_TEXTURE_MAX_LEVEL";
                case 0x8191:
                    return "GL_GENERATE_MIPMAP";
                case 0x84FE:
                    return "GL_TEXTURE_MAX_ANISOTROPY";
                case 0x8501:
                    return "GL_TEXTURE_LOD_BIAS";
                case 0x884C:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884D:
                    return "GL_TEXTURE_COMPARE_FUNC";
                case 0x8E42:
                    return "GL_TEXTURE_SWIZZLE_R";
                case 0x8E43:
                    return "GL_TEXTURE_SWIZZLE_G";
                case 0x8E44:
                    return "GL_TEXTURE_SWIZZLE_B";
                case 0x8E45:
                    return "GL_TEXTURE_SWIZZLE_A";
                case 0x8E46:
                    return "GL_TEXTURE_SWIZZLE_RGBA";
                case 0x90EA:
                    return "GL_DEPTH_STENCIL_TEXTURE_MODE";
                case 0x9580:
                    return "GL_TEXTURE_TILING_EXT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureSwizzle:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x1:
                    return "GL_ONE";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureTarget:
        {
            switch (value)
            {
                case 0xDE0:
                    return "GL_TEXTURE_1D";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x8063:
                    return "GL_PROXY_TEXTURE_1D";
                case 0x8064:
                    return "GL_PROXY_TEXTURE_2D";
                case 0x806F:
                    return "GL_TEXTURE_3D";
                case 0x8070:
                    return "GL_PROXY_TEXTURE_3D";
                case 0x84F5:
                    return "GL_TEXTURE_RECTANGLE";
                case 0x84F7:
                    return "GL_PROXY_TEXTURE_RECTANGLE";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8515:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X";
                case 0x8516:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X";
                case 0x8517:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y";
                case 0x8518:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y";
                case 0x8519:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z";
                case 0x851A:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z";
                case 0x851B:
                    return "GL_PROXY_TEXTURE_CUBE_MAP";
                case 0x8C18:
                    return "GL_TEXTURE_1D_ARRAY";
                case 0x8C19:
                    return "GL_PROXY_TEXTURE_1D_ARRAY";
                case 0x8C1A:
                    return "GL_TEXTURE_2D_ARRAY";
                case 0x8C1B:
                    return "GL_PROXY_TEXTURE_2D_ARRAY";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                case 0x9009:
                    return "GL_TEXTURE_CUBE_MAP_ARRAY";
                case 0x900B:
                    return "GL_PROXY_TEXTURE_CUBE_MAP_ARRAY";
                case 0x9100:
                    return "GL_TEXTURE_2D_MULTISAMPLE";
                case 0x9101:
                    return "GL_PROXY_TEXTURE_2D_MULTISAMPLE";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
                case 0x9103:
                    return "GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureUnit:
        {
            switch (value)
            {
                case 0x84C0:
                    return "GL_TEXTURE0";
                case 0x84C1:
                    return "GL_TEXTURE1";
                case 0x84C2:
                    return "GL_TEXTURE2";
                case 0x84C3:
                    return "GL_TEXTURE3";
                case 0x84C4:
                    return "GL_TEXTURE4";
                case 0x84C5:
                    return "GL_TEXTURE5";
                case 0x84C6:
                    return "GL_TEXTURE6";
                case 0x84C7:
                    return "GL_TEXTURE7";
                case 0x84C8:
                    return "GL_TEXTURE8";
                case 0x84C9:
                    return "GL_TEXTURE9";
                case 0x84CA:
                    return "GL_TEXTURE10";
                case 0x84CB:
                    return "GL_TEXTURE11";
                case 0x84CC:
                    return "GL_TEXTURE12";
                case 0x84CD:
                    return "GL_TEXTURE13";
                case 0x84CE:
                    return "GL_TEXTURE14";
                case 0x84CF:
                    return "GL_TEXTURE15";
                case 0x84D0:
                    return "GL_TEXTURE16";
                case 0x84D1:
                    return "GL_TEXTURE17";
                case 0x84D2:
                    return "GL_TEXTURE18";
                case 0x84D3:
                    return "GL_TEXTURE19";
                case 0x84D4:
                    return "GL_TEXTURE20";
                case 0x84D5:
                    return "GL_TEXTURE21";
                case 0x84D6:
                    return "GL_TEXTURE22";
                case 0x84D7:
                    return "GL_TEXTURE23";
                case 0x84D8:
                    return "GL_TEXTURE24";
                case 0x84D9:
                    return "GL_TEXTURE25";
                case 0x84DA:
                    return "GL_TEXTURE26";
                case 0x84DB:
                    return "GL_TEXTURE27";
                case 0x84DC:
                    return "GL_TEXTURE28";
                case 0x84DD:
                    return "GL_TEXTURE29";
                case 0x84DE:
                    return "GL_TEXTURE30";
                case 0x84DF:
                    return "GL_TEXTURE31";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TextureWrapMode:
        {
            switch (value)
            {
                case 0x2703:
                    return "GL_LINEAR_MIPMAP_LINEAR";
                case 0x2900:
                    return "GL_CLAMP";
                case 0x2901:
                    return "GL_REPEAT";
                case 0x812D:
                    return "GL_CLAMP_TO_BORDER";
                case 0x812F:
                    return "GL_CLAMP_TO_EDGE";
                case 0x8370:
                    return "GL_MIRRORED_REPEAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TransformFeedbackBufferMode:
        {
            switch (value)
            {
                case 0x8C8C:
                    return "GL_INTERLEAVED_ATTRIBS";
                case 0x8C8D:
                    return "GL_SEPARATE_ATTRIBS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TransformFeedbackPName:
        {
            switch (value)
            {
                case 0x8C84:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
                case 0x8C85:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
                case 0x8C8F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
                case 0x8E23:
                    return "GL_TRANSFORM_FEEDBACK_PAUSED";
                case 0x8E24:
                    return "GL_TRANSFORM_FEEDBACK_ACTIVE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::TriangleFace:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::UniformBlockPName:
        {
            switch (value)
            {
                case 0x84F0:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x84F1:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x8A3F:
                    return "GL_UNIFORM_BLOCK_BINDING";
                case 0x8A40:
                    return "GL_UNIFORM_BLOCK_DATA_SIZE";
                case 0x8A41:
                    return "GL_UNIFORM_BLOCK_NAME_LENGTH";
                case 0x8A42:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS";
                case 0x8A43:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES";
                case 0x8A44:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER";
                case 0x8A45:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x8A46:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x90EC:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::UniformPName:
        {
            switch (value)
            {
                case 0x8A37:
                    return "GL_UNIFORM_TYPE";
                case 0x8A38:
                    return "GL_UNIFORM_SIZE";
                case 0x8A39:
                    return "GL_UNIFORM_NAME_LENGTH";
                case 0x8A3A:
                    return "GL_UNIFORM_BLOCK_INDEX";
                case 0x8A3B:
                    return "GL_UNIFORM_OFFSET";
                case 0x8A3C:
                    return "GL_UNIFORM_ARRAY_STRIDE";
                case 0x8A3D:
                    return "GL_UNIFORM_MATRIX_STRIDE";
                case 0x8A3E:
                    return "GL_UNIFORM_IS_ROW_MAJOR";
                case 0x92DA:
                    return "GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::UniformType:
        {
            switch (value)
            {
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                case 0x8B50:
                    return "GL_FLOAT_VEC2";
                case 0x8B51:
                    return "GL_FLOAT_VEC3";
                case 0x8B52:
                    return "GL_FLOAT_VEC4";
                case 0x8B53:
                    return "GL_INT_VEC2";
                case 0x8B54:
                    return "GL_INT_VEC3";
                case 0x8B55:
                    return "GL_INT_VEC4";
                case 0x8B56:
                    return "GL_BOOL";
                case 0x8B57:
                    return "GL_BOOL_VEC2";
                case 0x8B58:
                    return "GL_BOOL_VEC3";
                case 0x8B59:
                    return "GL_BOOL_VEC4";
                case 0x8B5A:
                    return "GL_FLOAT_MAT2";
                case 0x8B5B:
                    return "GL_FLOAT_MAT3";
                case 0x8B5C:
                    return "GL_FLOAT_MAT4";
                case 0x8B5D:
                    return "GL_SAMPLER_1D";
                case 0x8B5E:
                    return "GL_SAMPLER_2D";
                case 0x8B5F:
                    return "GL_SAMPLER_3D";
                case 0x8B60:
                    return "GL_SAMPLER_CUBE";
                case 0x8B61:
                    return "GL_SAMPLER_1D_SHADOW";
                case 0x8B62:
                    return "GL_SAMPLER_2D_SHADOW";
                case 0x8B63:
                    return "GL_SAMPLER_2D_RECT";
                case 0x8B64:
                    return "GL_SAMPLER_2D_RECT_SHADOW";
                case 0x8B65:
                    return "GL_FLOAT_MAT2x3";
                case 0x8B66:
                    return "GL_FLOAT_MAT2x4";
                case 0x8B67:
                    return "GL_FLOAT_MAT3x2";
                case 0x8B68:
                    return "GL_FLOAT_MAT3x4";
                case 0x8B69:
                    return "GL_FLOAT_MAT4x2";
                case 0x8B6A:
                    return "GL_FLOAT_MAT4x3";
                case 0x8DC0:
                    return "GL_SAMPLER_1D_ARRAY";
                case 0x8DC1:
                    return "GL_SAMPLER_2D_ARRAY";
                case 0x8DC2:
                    return "GL_SAMPLER_BUFFER";
                case 0x8DC3:
                    return "GL_SAMPLER_1D_ARRAY_SHADOW";
                case 0x8DC4:
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
                case 0x8DC5:
                    return "GL_SAMPLER_CUBE_SHADOW";
                case 0x8DC6:
                    return "GL_UNSIGNED_INT_VEC2";
                case 0x8DC7:
                    return "GL_UNSIGNED_INT_VEC3";
                case 0x8DC8:
                    return "GL_UNSIGNED_INT_VEC4";
                case 0x8DC9:
                    return "GL_INT_SAMPLER_1D";
                case 0x8DCA:
                    return "GL_INT_SAMPLER_2D";
                case 0x8DCB:
                    return "GL_INT_SAMPLER_3D";
                case 0x8DCC:
                    return "GL_INT_SAMPLER_CUBE";
                case 0x8DCD:
                    return "GL_INT_SAMPLER_2D_RECT";
                case 0x8DCE:
                    return "GL_INT_SAMPLER_1D_ARRAY";
                case 0x8DCF:
                    return "GL_INT_SAMPLER_2D_ARRAY";
                case 0x8DD0:
                    return "GL_INT_SAMPLER_BUFFER";
                case 0x8DD1:
                    return "GL_UNSIGNED_INT_SAMPLER_1D";
                case 0x8DD2:
                    return "GL_UNSIGNED_INT_SAMPLER_2D";
                case 0x8DD3:
                    return "GL_UNSIGNED_INT_SAMPLER_3D";
                case 0x8DD4:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE";
                case 0x8DD5:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_RECT";
                case 0x8DD6:
                    return "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY";
                case 0x8DD7:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
                case 0x8DD8:
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
                case 0x8F46:
                    return "GL_DOUBLE_MAT2";
                case 0x8F47:
                    return "GL_DOUBLE_MAT3";
                case 0x8F48:
                    return "GL_DOUBLE_MAT4";
                case 0x8F49:
                    return "GL_DOUBLE_MAT2x3";
                case 0x8F4A:
                    return "GL_DOUBLE_MAT2x4";
                case 0x8F4B:
                    return "GL_DOUBLE_MAT3x2";
                case 0x8F4C:
                    return "GL_DOUBLE_MAT3x4";
                case 0x8F4D:
                    return "GL_DOUBLE_MAT4x2";
                case 0x8F4E:
                    return "GL_DOUBLE_MAT4x3";
                case 0x8FFC:
                    return "GL_DOUBLE_VEC2";
                case 0x8FFD:
                    return "GL_DOUBLE_VEC3";
                case 0x8FFE:
                    return "GL_DOUBLE_VEC4";
                case 0x900C:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900D:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
                case 0x900E:
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900F:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x9108:
                    return "GL_SAMPLER_2D_MULTISAMPLE";
                case 0x9109:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910A:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910B:
                    return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910C:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910D:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::UseProgramStageMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_VERTEX_SHADER_BIT";
                case 0x2:
                    return "GL_FRAGMENT_SHADER_BIT";
                case 0x4:
                    return "GL_GEOMETRY_SHADER_BIT";
                case 0x8:
                    return "GL_TESS_CONTROL_SHADER_BIT";
                case 0x10:
                    return "GL_TESS_EVALUATION_SHADER_BIT";
                case 0x20:
                    return "GL_COMPUTE_SHADER_BIT";
                case 0xFFFFFFFF:
                    return "GL_ALL_SHADER_BITS";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexArrayPName:
        {
            switch (value)
            {
                case 0x82D5:
                    return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x874E:
                    return "GL_VERTEX_ATTRIB_ARRAY_LONG";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexAttribEnum:
        {
            switch (value)
            {
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x8626:
                    return "GL_CURRENT_VERTEX_ATTRIB";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x889F:
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexAttribIType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexAttribLType:
        {
            switch (value)
            {
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexAttribPointerPropertyARB:
        {
            switch (value)
            {
                case 0x8645:
                    return "GL_VERTEX_ATTRIB_ARRAY_POINTER";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexAttribPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x140C:
                    return "GL_FIXED";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8D9F:
                    return "GL_INT_2_10_10_10_REV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexAttribPropertyARB:
        {
            switch (value)
            {
                case 0x82D4:
                    return "GL_VERTEX_ATTRIB_BINDING";
                case 0x82D5:
                    return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x8626:
                    return "GL_CURRENT_VERTEX_ATTRIB";
                case 0x874E:
                    return "GL_VERTEX_ATTRIB_ARRAY_LONG";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x889F:
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexAttribType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x140C:
                    return "GL_FIXED";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8D9F:
                    return "GL_INT_2_10_10_10_REV";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexBufferObjectUsage:
        {
            switch (value)
            {
                case 0x88E0:
                    return "GL_STREAM_DRAW";
                case 0x88E1:
                    return "GL_STREAM_READ";
                case 0x88E2:
                    return "GL_STREAM_COPY";
                case 0x88E4:
                    return "GL_STATIC_DRAW";
                case 0x88E5:
                    return "GL_STATIC_READ";
                case 0x88E6:
                    return "GL_STATIC_COPY";
                case 0x88E8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88E9:
                    return "GL_DYNAMIC_READ";
                case 0x88EA:
                    return "GL_DYNAMIC_COPY";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexProvokingMode:
        {
            switch (value)
            {
                case 0x8E4D:
                    return "GL_FIRST_VERTEX_CONVENTION";
                case 0x8E4E:
                    return "GL_LAST_VERTEX_CONVENTION";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexShaderTextureUnitParameter:
        {
            switch (value)
            {
                case 0xB03:
                    return "GL_CURRENT_TEXTURE_COORDS";
                case 0xBA8:
                    return "GL_TEXTURE_MATRIX";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexShaderWriteMaskEXT:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_FALSE";
                case 0x1:
                    return "GL_TRUE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::VertexWeightPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownEnumToString(value);
            }
        }

        case BigGLEnum::WeightPointerTypeARB:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140A:
                    return "GL_DOUBLE";
                default:
                    return UnknownEnumToString(value);
            }
        }

        default:
            return UnknownEnumToString(value);
    }
}

unsigned int StringToGLenum(const char *str)
{
    if (strcmp(str, "GL_1PASS_EXT") == 0)
    {
        return 0x80A1;
    }
    if (strcmp(str, "GL_1PASS_SGIS") == 0)
    {
        return 0x80A1;
    }
    if (strcmp(str, "GL_2D") == 0)
    {
        return 0x0600;
    }
    if (strcmp(str, "GL_2PASS_0_EXT") == 0)
    {
        return 0x80A2;
    }
    if (strcmp(str, "GL_2PASS_0_SGIS") == 0)
    {
        return 0x80A2;
    }
    if (strcmp(str, "GL_2PASS_1_EXT") == 0)
    {
        return 0x80A3;
    }
    if (strcmp(str, "GL_2PASS_1_SGIS") == 0)
    {
        return 0x80A3;
    }
    if (strcmp(str, "GL_2X_BIT_ATI") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_2_BYTES") == 0)
    {
        return 0x1407;
    }
    if (strcmp(str, "GL_2_BYTES_NV") == 0)
    {
        return 0x1407;
    }
    if (strcmp(str, "GL_3D") == 0)
    {
        return 0x0601;
    }
    if (strcmp(str, "GL_3DC_XY_AMD") == 0)
    {
        return 0x87FA;
    }
    if (strcmp(str, "GL_3DC_X_AMD") == 0)
    {
        return 0x87F9;
    }
    if (strcmp(str, "GL_3D_COLOR") == 0)
    {
        return 0x0602;
    }
    if (strcmp(str, "GL_3D_COLOR_TEXTURE") == 0)
    {
        return 0x0603;
    }
    if (strcmp(str, "GL_3_BYTES") == 0)
    {
        return 0x1408;
    }
    if (strcmp(str, "GL_3_BYTES_NV") == 0)
    {
        return 0x1408;
    }
    if (strcmp(str, "GL_422_AVERAGE_EXT") == 0)
    {
        return 0x80CE;
    }
    if (strcmp(str, "GL_422_EXT") == 0)
    {
        return 0x80CC;
    }
    if (strcmp(str, "GL_422_REV_AVERAGE_EXT") == 0)
    {
        return 0x80CF;
    }
    if (strcmp(str, "GL_422_REV_EXT") == 0)
    {
        return 0x80CD;
    }
    if (strcmp(str, "GL_4D_COLOR_TEXTURE") == 0)
    {
        return 0x0604;
    }
    if (strcmp(str, "GL_4PASS_0_EXT") == 0)
    {
        return 0x80A4;
    }
    if (strcmp(str, "GL_4PASS_0_SGIS") == 0)
    {
        return 0x80A4;
    }
    if (strcmp(str, "GL_4PASS_1_EXT") == 0)
    {
        return 0x80A5;
    }
    if (strcmp(str, "GL_4PASS_1_SGIS") == 0)
    {
        return 0x80A5;
    }
    if (strcmp(str, "GL_4PASS_2_EXT") == 0)
    {
        return 0x80A6;
    }
    if (strcmp(str, "GL_4PASS_2_SGIS") == 0)
    {
        return 0x80A6;
    }
    if (strcmp(str, "GL_4PASS_3_EXT") == 0)
    {
        return 0x80A7;
    }
    if (strcmp(str, "GL_4PASS_3_SGIS") == 0)
    {
        return 0x80A7;
    }
    if (strcmp(str, "GL_4X_BIT_ATI") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_4_BYTES") == 0)
    {
        return 0x1409;
    }
    if (strcmp(str, "GL_4_BYTES_NV") == 0)
    {
        return 0x1409;
    }
    if (strcmp(str, "GL_8X_BIT_ATI") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_ABGR_EXT") == 0)
    {
        return 0x8000;
    }
    if (strcmp(str, "GL_ACCUM") == 0)
    {
        return 0x0100;
    }
    if (strcmp(str, "GL_ACCUM_ADJACENT_PAIRS_NV") == 0)
    {
        return 0x90AD;
    }
    if (strcmp(str, "GL_ACCUM_ALPHA_BITS") == 0)
    {
        return 0x0D5B;
    }
    if (strcmp(str, "GL_ACCUM_BLUE_BITS") == 0)
    {
        return 0x0D5A;
    }
    if (strcmp(str, "GL_ACCUM_BUFFER_BIT") == 0)
    {
        return 0x0200;
    }
    if (strcmp(str, "GL_ACCUM_CLEAR_VALUE") == 0)
    {
        return 0x0B80;
    }
    if (strcmp(str, "GL_ACCUM_GREEN_BITS") == 0)
    {
        return 0x0D59;
    }
    if (strcmp(str, "GL_ACCUM_RED_BITS") == 0)
    {
        return 0x0D58;
    }
    if (strcmp(str, "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS") == 0)
    {
        return 0x92D9;
    }
    if (strcmp(str, "GL_ACTIVE_ATTRIBUTES") == 0)
    {
        return 0x8B89;
    }
    if (strcmp(str, "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH") == 0)
    {
        return 0x8B8A;
    }
    if (strcmp(str, "GL_ACTIVE_PROGRAM") == 0)
    {
        return 0x8259;
    }
    if (strcmp(str, "GL_ACTIVE_PROGRAM_EXT") == 0)
    {
        return 0x8259;
    }
    if (strcmp(str, "GL_ACTIVE_PROGRAM_EXT") == 0)
    {
        return 0x8B8D;
    }
    if (strcmp(str, "GL_ACTIVE_RESOURCES") == 0)
    {
        return 0x92F5;
    }
    if (strcmp(str, "GL_ACTIVE_STENCIL_FACE_EXT") == 0)
    {
        return 0x8911;
    }
    if (strcmp(str, "GL_ACTIVE_SUBROUTINES") == 0)
    {
        return 0x8DE5;
    }
    if (strcmp(str, "GL_ACTIVE_SUBROUTINE_MAX_LENGTH") == 0)
    {
        return 0x8E48;
    }
    if (strcmp(str, "GL_ACTIVE_SUBROUTINE_UNIFORMS") == 0)
    {
        return 0x8DE6;
    }
    if (strcmp(str, "GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS") == 0)
    {
        return 0x8E47;
    }
    if (strcmp(str, "GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH") == 0)
    {
        return 0x8E49;
    }
    if (strcmp(str, "GL_ACTIVE_TEXTURE") == 0)
    {
        return 0x84E0;
    }
    if (strcmp(str, "GL_ACTIVE_TEXTURE_ARB") == 0)
    {
        return 0x84E0;
    }
    if (strcmp(str, "GL_ACTIVE_UNIFORMS") == 0)
    {
        return 0x8B86;
    }
    if (strcmp(str, "GL_ACTIVE_UNIFORM_BLOCKS") == 0)
    {
        return 0x8A36;
    }
    if (strcmp(str, "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH") == 0)
    {
        return 0x8A35;
    }
    if (strcmp(str, "GL_ACTIVE_UNIFORM_MAX_LENGTH") == 0)
    {
        return 0x8B87;
    }
    if (strcmp(str, "GL_ACTIVE_VARIABLES") == 0)
    {
        return 0x9305;
    }
    if (strcmp(str, "GL_ACTIVE_VARYINGS_NV") == 0)
    {
        return 0x8C81;
    }
    if (strcmp(str, "GL_ACTIVE_VARYING_MAX_LENGTH_NV") == 0)
    {
        return 0x8C82;
    }
    if (strcmp(str, "GL_ACTIVE_VERTEX_UNITS_ARB") == 0)
    {
        return 0x86A5;
    }
    if (strcmp(str, "GL_ADD") == 0)
    {
        return 0x0104;
    }
    if (strcmp(str, "GL_ADD_ATI") == 0)
    {
        return 0x8963;
    }
    if (strcmp(str, "GL_ADD_BLEND_IMG") == 0)
    {
        return 0x8C09;
    }
    if (strcmp(str, "GL_ADD_SIGNED") == 0)
    {
        return 0x8574;
    }
    if (strcmp(str, "GL_ADD_SIGNED_ARB") == 0)
    {
        return 0x8574;
    }
    if (strcmp(str, "GL_ADD_SIGNED_EXT") == 0)
    {
        return 0x8574;
    }
    if (strcmp(str, "GL_ADJACENT_PAIRS_NV") == 0)
    {
        return 0x90AE;
    }
    if (strcmp(str, "GL_AFFINE_2D_NV") == 0)
    {
        return 0x9092;
    }
    if (strcmp(str, "GL_AFFINE_3D_NV") == 0)
    {
        return 0x9094;
    }
    if (strcmp(str, "GL_ALIASED_LINE_WIDTH_RANGE") == 0)
    {
        return 0x846E;
    }
    if (strcmp(str, "GL_ALIASED_POINT_SIZE_RANGE") == 0)
    {
        return 0x846D;
    }
    if (strcmp(str, "GL_ALLOW_DRAW_FRG_HINT_PGI") == 0)
    {
        return 0x1A210;
    }
    if (strcmp(str, "GL_ALLOW_DRAW_MEM_HINT_PGI") == 0)
    {
        return 0x1A211;
    }
    if (strcmp(str, "GL_ALLOW_DRAW_OBJ_HINT_PGI") == 0)
    {
        return 0x1A20E;
    }
    if (strcmp(str, "GL_ALLOW_DRAW_WIN_HINT_PGI") == 0)
    {
        return 0x1A20F;
    }
    if (strcmp(str, "GL_ALL_ATTRIB_BITS") == 0)
    {
        return 0xFFFFFFFF;
    }
    if (strcmp(str, "GL_ALL_BARRIER_BITS") == 0)
    {
        return 0xFFFFFFFF;
    }
    if (strcmp(str, "GL_ALL_BARRIER_BITS_EXT") == 0)
    {
        return 0xFFFFFFFF;
    }
    if (strcmp(str, "GL_ALL_COMPLETED_NV") == 0)
    {
        return 0x84F2;
    }
    if (strcmp(str, "GL_ALL_PIXELS_AMD") == 0)
    {
        return 0xFFFFFFFF;
    }
    if (strcmp(str, "GL_ALL_SHADER_BITS") == 0)
    {
        return 0xFFFFFFFF;
    }
    if (strcmp(str, "GL_ALL_SHADER_BITS_EXT") == 0)
    {
        return 0xFFFFFFFF;
    }
    if (strcmp(str, "GL_ALL_STATIC_DATA_IBM") == 0)
    {
        return 0x103060;
    }
    if (strcmp(str, "GL_ALPHA") == 0)
    {
        return 0x1906;
    }
    if (strcmp(str, "GL_ALPHA12") == 0)
    {
        return 0x803D;
    }
    if (strcmp(str, "GL_ALPHA12_EXT") == 0)
    {
        return 0x803D;
    }
    if (strcmp(str, "GL_ALPHA16") == 0)
    {
        return 0x803E;
    }
    if (strcmp(str, "GL_ALPHA16F_ARB") == 0)
    {
        return 0x881C;
    }
    if (strcmp(str, "GL_ALPHA16F_EXT") == 0)
    {
        return 0x881C;
    }
    if (strcmp(str, "GL_ALPHA16I_EXT") == 0)
    {
        return 0x8D8A;
    }
    if (strcmp(str, "GL_ALPHA16UI_EXT") == 0)
    {
        return 0x8D78;
    }
    if (strcmp(str, "GL_ALPHA16_EXT") == 0)
    {
        return 0x803E;
    }
    if (strcmp(str, "GL_ALPHA16_SNORM") == 0)
    {
        return 0x9018;
    }
    if (strcmp(str, "GL_ALPHA32F_ARB") == 0)
    {
        return 0x8816;
    }
    if (strcmp(str, "GL_ALPHA32F_EXT") == 0)
    {
        return 0x8816;
    }
    if (strcmp(str, "GL_ALPHA32I_EXT") == 0)
    {
        return 0x8D84;
    }
    if (strcmp(str, "GL_ALPHA32UI_EXT") == 0)
    {
        return 0x8D72;
    }
    if (strcmp(str, "GL_ALPHA4") == 0)
    {
        return 0x803B;
    }
    if (strcmp(str, "GL_ALPHA4_EXT") == 0)
    {
        return 0x803B;
    }
    if (strcmp(str, "GL_ALPHA8") == 0)
    {
        return 0x803C;
    }
    if (strcmp(str, "GL_ALPHA8I_EXT") == 0)
    {
        return 0x8D90;
    }
    if (strcmp(str, "GL_ALPHA8UI_EXT") == 0)
    {
        return 0x8D7E;
    }
    if (strcmp(str, "GL_ALPHA8_EXT") == 0)
    {
        return 0x803C;
    }
    if (strcmp(str, "GL_ALPHA8_OES") == 0)
    {
        return 0x803C;
    }
    if (strcmp(str, "GL_ALPHA8_SNORM") == 0)
    {
        return 0x9014;
    }
    if (strcmp(str, "GL_ALPHA_BIAS") == 0)
    {
        return 0x0D1D;
    }
    if (strcmp(str, "GL_ALPHA_BITS") == 0)
    {
        return 0x0D55;
    }
    if (strcmp(str, "GL_ALPHA_FLOAT16_APPLE") == 0)
    {
        return 0x881C;
    }
    if (strcmp(str, "GL_ALPHA_FLOAT16_ATI") == 0)
    {
        return 0x881C;
    }
    if (strcmp(str, "GL_ALPHA_FLOAT32_APPLE") == 0)
    {
        return 0x8816;
    }
    if (strcmp(str, "GL_ALPHA_FLOAT32_ATI") == 0)
    {
        return 0x8816;
    }
    if (strcmp(str, "GL_ALPHA_INTEGER") == 0)
    {
        return 0x8D97;
    }
    if (strcmp(str, "GL_ALPHA_INTEGER_EXT") == 0)
    {
        return 0x8D97;
    }
    if (strcmp(str, "GL_ALPHA_MAX_CLAMP_INGR") == 0)
    {
        return 0x8567;
    }
    if (strcmp(str, "GL_ALPHA_MAX_SGIX") == 0)
    {
        return 0x8321;
    }
    if (strcmp(str, "GL_ALPHA_MIN_CLAMP_INGR") == 0)
    {
        return 0x8563;
    }
    if (strcmp(str, "GL_ALPHA_MIN_SGIX") == 0)
    {
        return 0x8320;
    }
    if (strcmp(str, "GL_ALPHA_REF_COMMAND_NV") == 0)
    {
        return 0x000F;
    }
    if (strcmp(str, "GL_ALPHA_SCALE") == 0)
    {
        return 0x0D1C;
    }
    if (strcmp(str, "GL_ALPHA_SNORM") == 0)
    {
        return 0x9010;
    }
    if (strcmp(str, "GL_ALPHA_TEST") == 0)
    {
        return 0x0BC0;
    }
    if (strcmp(str, "GL_ALPHA_TEST_FUNC") == 0)
    {
        return 0x0BC1;
    }
    if (strcmp(str, "GL_ALPHA_TEST_FUNC_QCOM") == 0)
    {
        return 0x0BC1;
    }
    if (strcmp(str, "GL_ALPHA_TEST_QCOM") == 0)
    {
        return 0x0BC0;
    }
    if (strcmp(str, "GL_ALPHA_TEST_REF") == 0)
    {
        return 0x0BC2;
    }
    if (strcmp(str, "GL_ALPHA_TEST_REF_QCOM") == 0)
    {
        return 0x0BC2;
    }
    if (strcmp(str, "GL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV") == 0)
    {
        return 0x934D;
    }
    if (strcmp(str, "GL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV") == 0)
    {
        return 0x934F;
    }
    if (strcmp(str, "GL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV") == 0)
    {
        return 0x934E;
    }
    if (strcmp(str, "GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV") == 0)
    {
        return 0x92BF;
    }
    if (strcmp(str, "GL_ALREADY_SIGNALED") == 0)
    {
        return 0x911A;
    }
    if (strcmp(str, "GL_ALREADY_SIGNALED_APPLE") == 0)
    {
        return 0x911A;
    }
    if (strcmp(str, "GL_ALWAYS") == 0)
    {
        return 0x0207;
    }
    if (strcmp(str, "GL_ALWAYS_FAST_HINT_PGI") == 0)
    {
        return 0x1A20C;
    }
    if (strcmp(str, "GL_ALWAYS_SOFT_HINT_PGI") == 0)
    {
        return 0x1A20D;
    }
    if (strcmp(str, "GL_AMBIENT") == 0)
    {
        return 0x1200;
    }
    if (strcmp(str, "GL_AMBIENT_AND_DIFFUSE") == 0)
    {
        return 0x1602;
    }
    if (strcmp(str, "GL_AND") == 0)
    {
        return 0x1501;
    }
    if (strcmp(str, "GL_AND_INVERTED") == 0)
    {
        return 0x1504;
    }
    if (strcmp(str, "GL_AND_REVERSE") == 0)
    {
        return 0x1502;
    }
    if (strcmp(str, "GL_ANY_SAMPLES_PASSED") == 0)
    {
        return 0x8C2F;
    }
    if (strcmp(str, "GL_ANY_SAMPLES_PASSED_CONSERVATIVE") == 0)
    {
        return 0x8D6A;
    }
    if (strcmp(str, "GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT") == 0)
    {
        return 0x8D6A;
    }
    if (strcmp(str, "GL_ANY_SAMPLES_PASSED_EXT") == 0)
    {
        return 0x8C2F;
    }
    if (strcmp(str, "GL_ARC_TO_NV") == 0)
    {
        return 0x00FE;
    }
    if (strcmp(str, "GL_ARRAY_BUFFER") == 0)
    {
        return 0x8892;
    }
    if (strcmp(str, "GL_ARRAY_BUFFER_ARB") == 0)
    {
        return 0x8892;
    }
    if (strcmp(str, "GL_ARRAY_BUFFER_BINDING") == 0)
    {
        return 0x8894;
    }
    if (strcmp(str, "GL_ARRAY_BUFFER_BINDING_ARB") == 0)
    {
        return 0x8894;
    }
    if (strcmp(str, "GL_ARRAY_ELEMENT_LOCK_COUNT_EXT") == 0)
    {
        return 0x81A9;
    }
    if (strcmp(str, "GL_ARRAY_ELEMENT_LOCK_FIRST_EXT") == 0)
    {
        return 0x81A8;
    }
    if (strcmp(str, "GL_ARRAY_OBJECT_BUFFER_ATI") == 0)
    {
        return 0x8766;
    }
    if (strcmp(str, "GL_ARRAY_OBJECT_OFFSET_ATI") == 0)
    {
        return 0x8767;
    }
    if (strcmp(str, "GL_ARRAY_SIZE") == 0)
    {
        return 0x92FB;
    }
    if (strcmp(str, "GL_ARRAY_STRIDE") == 0)
    {
        return 0x92FE;
    }
    if (strcmp(str, "GL_ASYNC_DRAW_PIXELS_SGIX") == 0)
    {
        return 0x835D;
    }
    if (strcmp(str, "GL_ASYNC_HISTOGRAM_SGIX") == 0)
    {
        return 0x832C;
    }
    if (strcmp(str, "GL_ASYNC_MARKER_SGIX") == 0)
    {
        return 0x8329;
    }
    if (strcmp(str, "GL_ASYNC_READ_PIXELS_SGIX") == 0)
    {
        return 0x835E;
    }
    if (strcmp(str, "GL_ASYNC_TEX_IMAGE_SGIX") == 0)
    {
        return 0x835C;
    }
    if (strcmp(str, "GL_ATC_RGBA_EXPLICIT_ALPHA_AMD") == 0)
    {
        return 0x8C93;
    }
    if (strcmp(str, "GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD") == 0)
    {
        return 0x87EE;
    }
    if (strcmp(str, "GL_ATC_RGB_AMD") == 0)
    {
        return 0x8C92;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BARRIER_BIT") == 0)
    {
        return 0x1000;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BARRIER_BIT_EXT") == 0)
    {
        return 0x1000;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER") == 0)
    {
        return 0x92C0;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS") == 0)
    {
        return 0x92C5;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES") == 0)
    {
        return 0x92C6;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_BINDING") == 0)
    {
        return 0x92C1;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE") == 0)
    {
        return 0x92C4;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_INDEX") == 0)
    {
        return 0x9301;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER") == 0)
    {
        return 0x90ED;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER") == 0)
    {
        return 0x92CB;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER") == 0)
    {
        return 0x92CA;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_NV") == 0)
    {
        return 0x959E;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_NV") == 0)
    {
        return 0x959F;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER") == 0)
    {
        return 0x92C8;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER") == 0)
    {
        return 0x92C9;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER") == 0)
    {
        return 0x92C7;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_SIZE") == 0)
    {
        return 0x92C3;
    }
    if (strcmp(str, "GL_ATOMIC_COUNTER_BUFFER_START") == 0)
    {
        return 0x92C2;
    }
    if (strcmp(str, "GL_ATTACHED_MEMORY_OBJECT_NV") == 0)
    {
        return 0x95A4;
    }
    if (strcmp(str, "GL_ATTACHED_MEMORY_OFFSET_NV") == 0)
    {
        return 0x95A5;
    }
    if (strcmp(str, "GL_ATTACHED_SHADERS") == 0)
    {
        return 0x8B85;
    }
    if (strcmp(str, "GL_ATTENUATION_EXT") == 0)
    {
        return 0x834D;
    }
    if (strcmp(str, "GL_ATTRIBUTE_ADDRESS_COMMAND_NV") == 0)
    {
        return 0x0009;
    }
    if (strcmp(str, "GL_ATTRIB_ARRAY_POINTER_NV") == 0)
    {
        return 0x8645;
    }
    if (strcmp(str, "GL_ATTRIB_ARRAY_SIZE_NV") == 0)
    {
        return 0x8623;
    }
    if (strcmp(str, "GL_ATTRIB_ARRAY_STRIDE_NV") == 0)
    {
        return 0x8624;
    }
    if (strcmp(str, "GL_ATTRIB_ARRAY_TYPE_NV") == 0)
    {
        return 0x8625;
    }
    if (strcmp(str, "GL_ATTRIB_STACK_DEPTH") == 0)
    {
        return 0x0BB0;
    }
    if (strcmp(str, "GL_AUTO_GENERATE_MIPMAP") == 0)
    {
        return 0x8295;
    }
    if (strcmp(str, "GL_AUTO_NORMAL") == 0)
    {
        return 0x0D80;
    }
    if (strcmp(str, "GL_AUX0") == 0)
    {
        return 0x0409;
    }
    if (strcmp(str, "GL_AUX1") == 0)
    {
        return 0x040A;
    }
    if (strcmp(str, "GL_AUX2") == 0)
    {
        return 0x040B;
    }
    if (strcmp(str, "GL_AUX3") == 0)
    {
        return 0x040C;
    }
    if (strcmp(str, "GL_AUX_BUFFERS") == 0)
    {
        return 0x0C00;
    }
    if (strcmp(str, "GL_AUX_DEPTH_STENCIL_APPLE") == 0)
    {
        return 0x8A14;
    }
    if (strcmp(str, "GL_AVERAGE_EXT") == 0)
    {
        return 0x8335;
    }
    if (strcmp(str, "GL_AVERAGE_HP") == 0)
    {
        return 0x8160;
    }
    if (strcmp(str, "GL_BACK") == 0)
    {
        return 0x0405;
    }
    if (strcmp(str, "GL_BACK_LEFT") == 0)
    {
        return 0x0402;
    }
    if (strcmp(str, "GL_BACK_NORMALS_HINT_PGI") == 0)
    {
        return 0x1A223;
    }
    if (strcmp(str, "GL_BACK_PRIMARY_COLOR_NV") == 0)
    {
        return 0x8C77;
    }
    if (strcmp(str, "GL_BACK_RIGHT") == 0)
    {
        return 0x0403;
    }
    if (strcmp(str, "GL_BACK_SECONDARY_COLOR_NV") == 0)
    {
        return 0x8C78;
    }
    if (strcmp(str, "GL_BEVEL_NV") == 0)
    {
        return 0x90A6;
    }
    if (strcmp(str, "GL_BGR") == 0)
    {
        return 0x80E0;
    }
    if (strcmp(str, "GL_BGRA") == 0)
    {
        return 0x80E1;
    }
    if (strcmp(str, "GL_BGRA8_EXT") == 0)
    {
        return 0x93A1;
    }
    if (strcmp(str, "GL_BGRA_EXT") == 0)
    {
        return 0x80E1;
    }
    if (strcmp(str, "GL_BGRA_IMG") == 0)
    {
        return 0x80E1;
    }
    if (strcmp(str, "GL_BGRA_INTEGER") == 0)
    {
        return 0x8D9B;
    }
    if (strcmp(str, "GL_BGRA_INTEGER_EXT") == 0)
    {
        return 0x8D9B;
    }
    if (strcmp(str, "GL_BGR_EXT") == 0)
    {
        return 0x80E0;
    }
    if (strcmp(str, "GL_BGR_INTEGER") == 0)
    {
        return 0x8D9A;
    }
    if (strcmp(str, "GL_BGR_INTEGER_EXT") == 0)
    {
        return 0x8D9A;
    }
    if (strcmp(str, "GL_BIAS_BIT_ATI") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_BIAS_BY_NEGATIVE_ONE_HALF_NV") == 0)
    {
        return 0x8541;
    }
    if (strcmp(str, "GL_BINNING_CONTROL_HINT_QCOM") == 0)
    {
        return 0x8FB0;
    }
    if (strcmp(str, "GL_BINORMAL_ARRAY_EXT") == 0)
    {
        return 0x843A;
    }
    if (strcmp(str, "GL_BINORMAL_ARRAY_POINTER_EXT") == 0)
    {
        return 0x8443;
    }
    if (strcmp(str, "GL_BINORMAL_ARRAY_STRIDE_EXT") == 0)
    {
        return 0x8441;
    }
    if (strcmp(str, "GL_BINORMAL_ARRAY_TYPE_EXT") == 0)
    {
        return 0x8440;
    }
    if (strcmp(str, "GL_BITMAP") == 0)
    {
        return 0x1A00;
    }
    if (strcmp(str, "GL_BITMAP_TOKEN") == 0)
    {
        return 0x0704;
    }
    if (strcmp(str, "GL_BLACKHOLE_RENDER_INTEL") == 0)
    {
        return 0x83FC;
    }
    if (strcmp(str, "GL_BLEND") == 0)
    {
        return 0x0BE2;
    }
    if (strcmp(str, "GL_BLEND_ADVANCED_COHERENT_KHR") == 0)
    {
        return 0x9285;
    }
    if (strcmp(str, "GL_BLEND_ADVANCED_COHERENT_NV") == 0)
    {
        return 0x9285;
    }
    if (strcmp(str, "GL_BLEND_COLOR") == 0)
    {
        return 0x8005;
    }
    if (strcmp(str, "GL_BLEND_COLOR_COMMAND_NV") == 0)
    {
        return 0x000B;
    }
    if (strcmp(str, "GL_BLEND_COLOR_EXT") == 0)
    {
        return 0x8005;
    }
    if (strcmp(str, "GL_BLEND_DST") == 0)
    {
        return 0x0BE0;
    }
    if (strcmp(str, "GL_BLEND_DST_ALPHA") == 0)
    {
        return 0x80CA;
    }
    if (strcmp(str, "GL_BLEND_DST_ALPHA_EXT") == 0)
    {
        return 0x80CA;
    }
    if (strcmp(str, "GL_BLEND_DST_ALPHA_OES") == 0)
    {
        return 0x80CA;
    }
    if (strcmp(str, "GL_BLEND_DST_RGB") == 0)
    {
        return 0x80C8;
    }
    if (strcmp(str, "GL_BLEND_DST_RGB_EXT") == 0)
    {
        return 0x80C8;
    }
    if (strcmp(str, "GL_BLEND_DST_RGB_OES") == 0)
    {
        return 0x80C8;
    }
    if (strcmp(str, "GL_BLEND_EQUATION") == 0)
    {
        return 0x8009;
    }
    if (strcmp(str, "GL_BLEND_EQUATION_ALPHA") == 0)
    {
        return 0x883D;
    }
    if (strcmp(str, "GL_BLEND_EQUATION_ALPHA_EXT") == 0)
    {
        return 0x883D;
    }
    if (strcmp(str, "GL_BLEND_EQUATION_ALPHA_OES") == 0)
    {
        return 0x883D;
    }
    if (strcmp(str, "GL_BLEND_EQUATION_EXT") == 0)
    {
        return 0x8009;
    }
    if (strcmp(str, "GL_BLEND_EQUATION_OES") == 0)
    {
        return 0x8009;
    }
    if (strcmp(str, "GL_BLEND_EQUATION_RGB") == 0)
    {
        return 0x8009;
    }
    if (strcmp(str, "GL_BLEND_EQUATION_RGB_EXT") == 0)
    {
        return 0x8009;
    }
    if (strcmp(str, "GL_BLEND_EQUATION_RGB_OES") == 0)
    {
        return 0x8009;
    }
    if (strcmp(str, "GL_BLEND_OVERLAP_NV") == 0)
    {
        return 0x9281;
    }
    if (strcmp(str, "GL_BLEND_PREMULTIPLIED_SRC_NV") == 0)
    {
        return 0x9280;
    }
    if (strcmp(str, "GL_BLEND_SRC") == 0)
    {
        return 0x0BE1;
    }
    if (strcmp(str, "GL_BLEND_SRC_ALPHA") == 0)
    {
        return 0x80CB;
    }
    if (strcmp(str, "GL_BLEND_SRC_ALPHA_EXT") == 0)
    {
        return 0x80CB;
    }
    if (strcmp(str, "GL_BLEND_SRC_ALPHA_OES") == 0)
    {
        return 0x80CB;
    }
    if (strcmp(str, "GL_BLEND_SRC_RGB") == 0)
    {
        return 0x80C9;
    }
    if (strcmp(str, "GL_BLEND_SRC_RGB_EXT") == 0)
    {
        return 0x80C9;
    }
    if (strcmp(str, "GL_BLEND_SRC_RGB_OES") == 0)
    {
        return 0x80C9;
    }
    if (strcmp(str, "GL_BLOCK_INDEX") == 0)
    {
        return 0x92FD;
    }
    if (strcmp(str, "GL_BLUE") == 0)
    {
        return 0x1905;
    }
    if (strcmp(str, "GL_BLUE_BIAS") == 0)
    {
        return 0x0D1B;
    }
    if (strcmp(str, "GL_BLUE_BITS") == 0)
    {
        return 0x0D54;
    }
    if (strcmp(str, "GL_BLUE_BIT_ATI") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_BLUE_INTEGER") == 0)
    {
        return 0x8D96;
    }
    if (strcmp(str, "GL_BLUE_INTEGER_EXT") == 0)
    {
        return 0x8D96;
    }
    if (strcmp(str, "GL_BLUE_MAX_CLAMP_INGR") == 0)
    {
        return 0x8566;
    }
    if (strcmp(str, "GL_BLUE_MIN_CLAMP_INGR") == 0)
    {
        return 0x8562;
    }
    if (strcmp(str, "GL_BLUE_NV") == 0)
    {
        return 0x1905;
    }
    if (strcmp(str, "GL_BLUE_SCALE") == 0)
    {
        return 0x0D1A;
    }
    if (strcmp(str, "GL_BOLD_BIT_NV") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_BOOL") == 0)
    {
        return 0x8B56;
    }
    if (strcmp(str, "GL_BOOL_ARB") == 0)
    {
        return 0x8B56;
    }
    if (strcmp(str, "GL_BOOL_VEC2") == 0)
    {
        return 0x8B57;
    }
    if (strcmp(str, "GL_BOOL_VEC2_ARB") == 0)
    {
        return 0x8B57;
    }
    if (strcmp(str, "GL_BOOL_VEC3") == 0)
    {
        return 0x8B58;
    }
    if (strcmp(str, "GL_BOOL_VEC3_ARB") == 0)
    {
        return 0x8B58;
    }
    if (strcmp(str, "GL_BOOL_VEC4") == 0)
    {
        return 0x8B59;
    }
    if (strcmp(str, "GL_BOOL_VEC4_ARB") == 0)
    {
        return 0x8B59;
    }
    if (strcmp(str, "GL_BOUNDING_BOX_NV") == 0)
    {
        return 0x908D;
    }
    if (strcmp(str, "GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV") == 0)
    {
        return 0x909C;
    }
    if (strcmp(str, "GL_BROWSER_DEFAULT_WEBGL") == 0)
    {
        return 0x9244;
    }
    if (strcmp(str, "GL_BUFFER") == 0)
    {
        return 0x82E0;
    }
    if (strcmp(str, "GL_BUFFER_ACCESS") == 0)
    {
        return 0x88BB;
    }
    if (strcmp(str, "GL_BUFFER_ACCESS_ARB") == 0)
    {
        return 0x88BB;
    }
    if (strcmp(str, "GL_BUFFER_ACCESS_FLAGS") == 0)
    {
        return 0x911F;
    }
    if (strcmp(str, "GL_BUFFER_ACCESS_OES") == 0)
    {
        return 0x88BB;
    }
    if (strcmp(str, "GL_BUFFER_BINDING") == 0)
    {
        return 0x9302;
    }
    if (strcmp(str, "GL_BUFFER_DATA_SIZE") == 0)
    {
        return 0x9303;
    }
    if (strcmp(str, "GL_BUFFER_FLUSHING_UNMAP_APPLE") == 0)
    {
        return 0x8A13;
    }
    if (strcmp(str, "GL_BUFFER_GPU_ADDRESS_NV") == 0)
    {
        return 0x8F1D;
    }
    if (strcmp(str, "GL_BUFFER_IMMUTABLE_STORAGE") == 0)
    {
        return 0x821F;
    }
    if (strcmp(str, "GL_BUFFER_IMMUTABLE_STORAGE_EXT") == 0)
    {
        return 0x821F;
    }
    if (strcmp(str, "GL_BUFFER_KHR") == 0)
    {
        return 0x82E0;
    }
    if (strcmp(str, "GL_BUFFER_MAPPED") == 0)
    {
        return 0x88BC;
    }
    if (strcmp(str, "GL_BUFFER_MAPPED_ARB") == 0)
    {
        return 0x88BC;
    }
    if (strcmp(str, "GL_BUFFER_MAPPED_OES") == 0)
    {
        return 0x88BC;
    }
    if (strcmp(str, "GL_BUFFER_MAP_LENGTH") == 0)
    {
        return 0x9120;
    }
    if (strcmp(str, "GL_BUFFER_MAP_OFFSET") == 0)
    {
        return 0x9121;
    }
    if (strcmp(str, "GL_BUFFER_MAP_POINTER") == 0)
    {
        return 0x88BD;
    }
    if (strcmp(str, "GL_BUFFER_MAP_POINTER_ARB") == 0)
    {
        return 0x88BD;
    }
    if (strcmp(str, "GL_BUFFER_MAP_POINTER_OES") == 0)
    {
        return 0x88BD;
    }
    if (strcmp(str, "GL_BUFFER_OBJECT_APPLE") == 0)
    {
        return 0x85B3;
    }
    if (strcmp(str, "GL_BUFFER_OBJECT_EXT") == 0)
    {
        return 0x9151;
    }
    if (strcmp(str, "GL_BUFFER_SERIALIZED_MODIFY_APPLE") == 0)
    {
        return 0x8A12;
    }
    if (strcmp(str, "GL_BUFFER_SIZE") == 0)
    {
        return 0x8764;
    }
    if (strcmp(str, "GL_BUFFER_SIZE_ARB") == 0)
    {
        return 0x8764;
    }
    if (strcmp(str, "GL_BUFFER_STORAGE_FLAGS") == 0)
    {
        return 0x8220;
    }
    if (strcmp(str, "GL_BUFFER_STORAGE_FLAGS_EXT") == 0)
    {
        return 0x8220;
    }
    if (strcmp(str, "GL_BUFFER_UPDATE_BARRIER_BIT") == 0)
    {
        return 0x0200;
    }
    if (strcmp(str, "GL_BUFFER_UPDATE_BARRIER_BIT_EXT") == 0)
    {
        return 0x0200;
    }
    if (strcmp(str, "GL_BUFFER_USAGE") == 0)
    {
        return 0x8765;
    }
    if (strcmp(str, "GL_BUFFER_USAGE_ARB") == 0)
    {
        return 0x8765;
    }
    if (strcmp(str, "GL_BUFFER_VARIABLE") == 0)
    {
        return 0x92E5;
    }
    if (strcmp(str, "GL_BUMP_ENVMAP_ATI") == 0)
    {
        return 0x877B;
    }
    if (strcmp(str, "GL_BUMP_NUM_TEX_UNITS_ATI") == 0)
    {
        return 0x8777;
    }
    if (strcmp(str, "GL_BUMP_ROT_MATRIX_ATI") == 0)
    {
        return 0x8775;
    }
    if (strcmp(str, "GL_BUMP_ROT_MATRIX_SIZE_ATI") == 0)
    {
        return 0x8776;
    }
    if (strcmp(str, "GL_BUMP_TARGET_ATI") == 0)
    {
        return 0x877C;
    }
    if (strcmp(str, "GL_BUMP_TEX_UNITS_ATI") == 0)
    {
        return 0x8778;
    }
    if (strcmp(str, "GL_BYTE") == 0)
    {
        return 0x1400;
    }
    if (strcmp(str, "GL_C3F_V3F") == 0)
    {
        return 0x2A24;
    }
    if (strcmp(str, "GL_C4F_N3F_V3F") == 0)
    {
        return 0x2A26;
    }
    if (strcmp(str, "GL_C4UB_V2F") == 0)
    {
        return 0x2A22;
    }
    if (strcmp(str, "GL_C4UB_V3F") == 0)
    {
        return 0x2A23;
    }
    if (strcmp(str, "GL_CALLIGRAPHIC_FRAGMENT_SGIX") == 0)
    {
        return 0x8183;
    }
    if (strcmp(str, "GL_CAVEAT_SUPPORT") == 0)
    {
        return 0x82B8;
    }
    if (strcmp(str, "GL_CCW") == 0)
    {
        return 0x0901;
    }
    if (strcmp(str, "GL_CIRCULAR_CCW_ARC_TO_NV") == 0)
    {
        return 0x00F8;
    }
    if (strcmp(str, "GL_CIRCULAR_CW_ARC_TO_NV") == 0)
    {
        return 0x00FA;
    }
    if (strcmp(str, "GL_CIRCULAR_TANGENT_ARC_TO_NV") == 0)
    {
        return 0x00FC;
    }
    if (strcmp(str, "GL_CLAMP") == 0)
    {
        return 0x2900;
    }
    if (strcmp(str, "GL_CLAMP_FRAGMENT_COLOR") == 0)
    {
        return 0x891B;
    }
    if (strcmp(str, "GL_CLAMP_FRAGMENT_COLOR_ARB") == 0)
    {
        return 0x891B;
    }
    if (strcmp(str, "GL_CLAMP_READ_COLOR") == 0)
    {
        return 0x891C;
    }
    if (strcmp(str, "GL_CLAMP_READ_COLOR_ARB") == 0)
    {
        return 0x891C;
    }
    if (strcmp(str, "GL_CLAMP_TO_BORDER") == 0)
    {
        return 0x812D;
    }
    if (strcmp(str, "GL_CLAMP_TO_BORDER_ARB") == 0)
    {
        return 0x812D;
    }
    if (strcmp(str, "GL_CLAMP_TO_BORDER_EXT") == 0)
    {
        return 0x812D;
    }
    if (strcmp(str, "GL_CLAMP_TO_BORDER_NV") == 0)
    {
        return 0x812D;
    }
    if (strcmp(str, "GL_CLAMP_TO_BORDER_OES") == 0)
    {
        return 0x812D;
    }
    if (strcmp(str, "GL_CLAMP_TO_BORDER_SGIS") == 0)
    {
        return 0x812D;
    }
    if (strcmp(str, "GL_CLAMP_TO_EDGE") == 0)
    {
        return 0x812F;
    }
    if (strcmp(str, "GL_CLAMP_TO_EDGE_SGIS") == 0)
    {
        return 0x812F;
    }
    if (strcmp(str, "GL_CLAMP_VERTEX_COLOR") == 0)
    {
        return 0x891A;
    }
    if (strcmp(str, "GL_CLAMP_VERTEX_COLOR_ARB") == 0)
    {
        return 0x891A;
    }
    if (strcmp(str, "GL_CLEAR") == 0)
    {
        return 0x1500;
    }
    if (strcmp(str, "GL_CLEAR_ANGLE") == 0)
    {
        return 0x1500;
    }
    if (strcmp(str, "GL_CLEAR_BUFFER") == 0)
    {
        return 0x82B4;
    }
    if (strcmp(str, "GL_CLEAR_TEXTURE") == 0)
    {
        return 0x9365;
    }
    if (strcmp(str, "GL_CLIENT_ACTIVE_TEXTURE") == 0)
    {
        return 0x84E1;
    }
    if (strcmp(str, "GL_CLIENT_ACTIVE_TEXTURE_ARB") == 0)
    {
        return 0x84E1;
    }
    if (strcmp(str, "GL_CLIENT_ALL_ATTRIB_BITS") == 0)
    {
        return 0xFFFFFFFF;
    }
    if (strcmp(str, "GL_CLIENT_ATTRIB_STACK_DEPTH") == 0)
    {
        return 0x0BB1;
    }
    if (strcmp(str, "GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT") == 0)
    {
        return 0x4000;
    }
    if (strcmp(str, "GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT") == 0)
    {
        return 0x4000;
    }
    if (strcmp(str, "GL_CLIENT_PIXEL_STORE_BIT") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_CLIENT_STORAGE_BIT") == 0)
    {
        return 0x0200;
    }
    if (strcmp(str, "GL_CLIENT_STORAGE_BIT_EXT") == 0)
    {
        return 0x0200;
    }
    if (strcmp(str, "GL_CLIENT_VERTEX_ARRAY_BIT") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_CLIPPING_INPUT_PRIMITIVES") == 0)
    {
        return 0x82F6;
    }
    if (strcmp(str, "GL_CLIPPING_INPUT_PRIMITIVES_ARB") == 0)
    {
        return 0x82F6;
    }
    if (strcmp(str, "GL_CLIPPING_OUTPUT_PRIMITIVES") == 0)
    {
        return 0x82F7;
    }
    if (strcmp(str, "GL_CLIPPING_OUTPUT_PRIMITIVES_ARB") == 0)
    {
        return 0x82F7;
    }
    if (strcmp(str, "GL_CLIP_DEPTH_MODE") == 0)
    {
        return 0x935D;
    }
    if (strcmp(str, "GL_CLIP_DEPTH_MODE_EXT") == 0)
    {
        return 0x935D;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE0") == 0)
    {
        return 0x3000;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE0_ANGLE") == 0)
    {
        return 0x3000;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE0_APPLE") == 0)
    {
        return 0x3000;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE0_EXT") == 0)
    {
        return 0x3000;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE1") == 0)
    {
        return 0x3001;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE1_ANGLE") == 0)
    {
        return 0x3001;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE1_APPLE") == 0)
    {
        return 0x3001;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE1_EXT") == 0)
    {
        return 0x3001;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE2") == 0)
    {
        return 0x3002;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE2_ANGLE") == 0)
    {
        return 0x3002;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE2_APPLE") == 0)
    {
        return 0x3002;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE2_EXT") == 0)
    {
        return 0x3002;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE3") == 0)
    {
        return 0x3003;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE3_ANGLE") == 0)
    {
        return 0x3003;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE3_APPLE") == 0)
    {
        return 0x3003;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE3_EXT") == 0)
    {
        return 0x3003;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE4") == 0)
    {
        return 0x3004;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE4_ANGLE") == 0)
    {
        return 0x3004;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE4_APPLE") == 0)
    {
        return 0x3004;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE4_EXT") == 0)
    {
        return 0x3004;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE5") == 0)
    {
        return 0x3005;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE5_ANGLE") == 0)
    {
        return 0x3005;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE5_APPLE") == 0)
    {
        return 0x3005;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE5_EXT") == 0)
    {
        return 0x3005;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE6") == 0)
    {
        return 0x3006;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE6_ANGLE") == 0)
    {
        return 0x3006;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE6_APPLE") == 0)
    {
        return 0x3006;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE6_EXT") == 0)
    {
        return 0x3006;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE7") == 0)
    {
        return 0x3007;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE7_ANGLE") == 0)
    {
        return 0x3007;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE7_APPLE") == 0)
    {
        return 0x3007;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE7_EXT") == 0)
    {
        return 0x3007;
    }
    if (strcmp(str, "GL_CLIP_DISTANCE_NV") == 0)
    {
        return 0x8C7A;
    }
    if (strcmp(str, "GL_CLIP_FAR_HINT_PGI") == 0)
    {
        return 0x1A221;
    }
    if (strcmp(str, "GL_CLIP_NEAR_HINT_PGI") == 0)
    {
        return 0x1A220;
    }
    if (strcmp(str, "GL_CLIP_ORIGIN") == 0)
    {
        return 0x935C;
    }
    if (strcmp(str, "GL_CLIP_ORIGIN_EXT") == 0)
    {
        return 0x935C;
    }
    if (strcmp(str, "GL_CLIP_PLANE0") == 0)
    {
        return 0x3000;
    }
    if (strcmp(str, "GL_CLIP_PLANE0_IMG") == 0)
    {
        return 0x3000;
    }
    if (strcmp(str, "GL_CLIP_PLANE1") == 0)
    {
        return 0x3001;
    }
    if (strcmp(str, "GL_CLIP_PLANE1_IMG") == 0)
    {
        return 0x3001;
    }
    if (strcmp(str, "GL_CLIP_PLANE2") == 0)
    {
        return 0x3002;
    }
    if (strcmp(str, "GL_CLIP_PLANE2_IMG") == 0)
    {
        return 0x3002;
    }
    if (strcmp(str, "GL_CLIP_PLANE3") == 0)
    {
        return 0x3003;
    }
    if (strcmp(str, "GL_CLIP_PLANE3_IMG") == 0)
    {
        return 0x3003;
    }
    if (strcmp(str, "GL_CLIP_PLANE4") == 0)
    {
        return 0x3004;
    }
    if (strcmp(str, "GL_CLIP_PLANE4_IMG") == 0)
    {
        return 0x3004;
    }
    if (strcmp(str, "GL_CLIP_PLANE5") == 0)
    {
        return 0x3005;
    }
    if (strcmp(str, "GL_CLIP_PLANE5_IMG") == 0)
    {
        return 0x3005;
    }
    if (strcmp(str, "GL_CLIP_VOLUME_CLIPPING_HINT_EXT") == 0)
    {
        return 0x80F0;
    }
    if (strcmp(str, "GL_CLOSE_PATH_NV") == 0)
    {
        return 0x0000;
    }
    if (strcmp(str, "GL_CMYKA_EXT") == 0)
    {
        return 0x800D;
    }
    if (strcmp(str, "GL_CMYK_EXT") == 0)
    {
        return 0x800C;
    }
    if (strcmp(str, "GL_CND0_ATI") == 0)
    {
        return 0x896B;
    }
    if (strcmp(str, "GL_CND_ATI") == 0)
    {
        return 0x896A;
    }
    if (strcmp(str, "GL_COEFF") == 0)
    {
        return 0x0A00;
    }
    if (strcmp(str, "GL_COLOR") == 0)
    {
        return 0x1800;
    }
    if (strcmp(str, "GL_COLOR3_BIT_PGI") == 0)
    {
        return 0x10000;
    }
    if (strcmp(str, "GL_COLOR4_BIT_PGI") == 0)
    {
        return 0x20000;
    }
    if (strcmp(str, "GL_COLORBURN") == 0)
    {
        return 0x929A;
    }
    if (strcmp(str, "GL_COLORBURN_KHR") == 0)
    {
        return 0x929A;
    }
    if (strcmp(str, "GL_COLORBURN_NV") == 0)
    {
        return 0x929A;
    }
    if (strcmp(str, "GL_COLORDODGE") == 0)
    {
        return 0x9299;
    }
    if (strcmp(str, "GL_COLORDODGE_KHR") == 0)
    {
        return 0x9299;
    }
    if (strcmp(str, "GL_COLORDODGE_NV") == 0)
    {
        return 0x9299;
    }
    if (strcmp(str, "GL_COLOR_ALPHA_PAIRING_ATI") == 0)
    {
        return 0x8975;
    }
    if (strcmp(str, "GL_COLOR_ARRAY") == 0)
    {
        return 0x8076;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_ADDRESS_NV") == 0)
    {
        return 0x8F23;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_BUFFER_BINDING") == 0)
    {
        return 0x8898;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_BUFFER_BINDING_ARB") == 0)
    {
        return 0x8898;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_COUNT_EXT") == 0)
    {
        return 0x8084;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_EXT") == 0)
    {
        return 0x8076;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_LENGTH_NV") == 0)
    {
        return 0x8F2D;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_LIST_IBM") == 0)
    {
        return 0x103072;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_LIST_STRIDE_IBM") == 0)
    {
        return 0x103082;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL") == 0)
    {
        return 0x83F7;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_POINTER") == 0)
    {
        return 0x8090;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_POINTER_EXT") == 0)
    {
        return 0x8090;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_SIZE") == 0)
    {
        return 0x8081;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_SIZE_EXT") == 0)
    {
        return 0x8081;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_STRIDE") == 0)
    {
        return 0x8083;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_STRIDE_EXT") == 0)
    {
        return 0x8083;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_TYPE") == 0)
    {
        return 0x8082;
    }
    if (strcmp(str, "GL_COLOR_ARRAY_TYPE_EXT") == 0)
    {
        return 0x8082;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT0") == 0)
    {
        return 0x8CE0;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT0_EXT") == 0)
    {
        return 0x8CE0;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT0_NV") == 0)
    {
        return 0x8CE0;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT0_OES") == 0)
    {
        return 0x8CE0;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT1") == 0)
    {
        return 0x8CE1;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT10") == 0)
    {
        return 0x8CEA;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT10_EXT") == 0)
    {
        return 0x8CEA;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT10_NV") == 0)
    {
        return 0x8CEA;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT11") == 0)
    {
        return 0x8CEB;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT11_EXT") == 0)
    {
        return 0x8CEB;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT11_NV") == 0)
    {
        return 0x8CEB;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT12") == 0)
    {
        return 0x8CEC;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT12_EXT") == 0)
    {
        return 0x8CEC;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT12_NV") == 0)
    {
        return 0x8CEC;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT13") == 0)
    {
        return 0x8CED;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT13_EXT") == 0)
    {
        return 0x8CED;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT13_NV") == 0)
    {
        return 0x8CED;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT14") == 0)
    {
        return 0x8CEE;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT14_EXT") == 0)
    {
        return 0x8CEE;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT14_NV") == 0)
    {
        return 0x8CEE;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT15") == 0)
    {
        return 0x8CEF;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT15_EXT") == 0)
    {
        return 0x8CEF;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT15_NV") == 0)
    {
        return 0x8CEF;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT16") == 0)
    {
        return 0x8CF0;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT17") == 0)
    {
        return 0x8CF1;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT18") == 0)
    {
        return 0x8CF2;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT19") == 0)
    {
        return 0x8CF3;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT1_EXT") == 0)
    {
        return 0x8CE1;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT1_NV") == 0)
    {
        return 0x8CE1;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT2") == 0)
    {
        return 0x8CE2;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT20") == 0)
    {
        return 0x8CF4;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT21") == 0)
    {
        return 0x8CF5;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT22") == 0)
    {
        return 0x8CF6;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT23") == 0)
    {
        return 0x8CF7;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT24") == 0)
    {
        return 0x8CF8;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT25") == 0)
    {
        return 0x8CF9;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT26") == 0)
    {
        return 0x8CFA;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT27") == 0)
    {
        return 0x8CFB;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT28") == 0)
    {
        return 0x8CFC;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT29") == 0)
    {
        return 0x8CFD;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT2_EXT") == 0)
    {
        return 0x8CE2;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT2_NV") == 0)
    {
        return 0x8CE2;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT3") == 0)
    {
        return 0x8CE3;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT30") == 0)
    {
        return 0x8CFE;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT31") == 0)
    {
        return 0x8CFF;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT3_EXT") == 0)
    {
        return 0x8CE3;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT3_NV") == 0)
    {
        return 0x8CE3;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT4") == 0)
    {
        return 0x8CE4;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT4_EXT") == 0)
    {
        return 0x8CE4;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT4_NV") == 0)
    {
        return 0x8CE4;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT5") == 0)
    {
        return 0x8CE5;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT5_EXT") == 0)
    {
        return 0x8CE5;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT5_NV") == 0)
    {
        return 0x8CE5;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT6") == 0)
    {
        return 0x8CE6;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT6_EXT") == 0)
    {
        return 0x8CE6;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT6_NV") == 0)
    {
        return 0x8CE6;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT7") == 0)
    {
        return 0x8CE7;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT7_EXT") == 0)
    {
        return 0x8CE7;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT7_NV") == 0)
    {
        return 0x8CE7;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT8") == 0)
    {
        return 0x8CE8;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT8_EXT") == 0)
    {
        return 0x8CE8;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT8_NV") == 0)
    {
        return 0x8CE8;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT9") == 0)
    {
        return 0x8CE9;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT9_EXT") == 0)
    {
        return 0x8CE9;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT9_NV") == 0)
    {
        return 0x8CE9;
    }
    if (strcmp(str, "GL_COLOR_ATTACHMENT_EXT") == 0)
    {
        return 0x90F0;
    }
    if (strcmp(str, "GL_COLOR_BUFFER_BIT") == 0)
    {
        return 0x4000;
    }
    if (strcmp(str, "GL_COLOR_BUFFER_BIT0_QCOM") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_COLOR_BUFFER_BIT1_QCOM") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_COLOR_BUFFER_BIT2_QCOM") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_COLOR_BUFFER_BIT3_QCOM") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_COLOR_BUFFER_BIT4_QCOM") == 0)
    {
        return 0x0010;
    }
    if (strcmp(str, "GL_COLOR_BUFFER_BIT5_QCOM") == 0)
    {
        return 0x0020;
    }
    if (strcmp(str, "GL_COLOR_BUFFER_BIT6_QCOM") == 0)
    {
        return 0x0040;
    }
    if (strcmp(str, "GL_COLOR_BUFFER_BIT7_QCOM") == 0)
    {
        return 0x0080;
    }
    if (strcmp(str, "GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI") == 0)
    {
        return 0x8835;
    }
    if (strcmp(str, "GL_COLOR_CLEAR_VALUE") == 0)
    {
        return 0x0C22;
    }
    if (strcmp(str, "GL_COLOR_COMPONENTS") == 0)
    {
        return 0x8283;
    }
    if (strcmp(str, "GL_COLOR_ENCODING") == 0)
    {
        return 0x8296;
    }
    if (strcmp(str, "GL_COLOR_EXT") == 0)
    {
        return 0x1800;
    }
    if (strcmp(str, "GL_COLOR_FLOAT_APPLE") == 0)
    {
        return 0x8A0F;
    }
    if (strcmp(str, "GL_COLOR_INDEX") == 0)
    {
        return 0x1900;
    }
    if (strcmp(str, "GL_COLOR_INDEX12_EXT") == 0)
    {
        return 0x80E6;
    }
    if (strcmp(str, "GL_COLOR_INDEX16_EXT") == 0)
    {
        return 0x80E7;
    }
    if (strcmp(str, "GL_COLOR_INDEX1_EXT") == 0)
    {
        return 0x80E2;
    }
    if (strcmp(str, "GL_COLOR_INDEX2_EXT") == 0)
    {
        return 0x80E3;
    }
    if (strcmp(str, "GL_COLOR_INDEX4_EXT") == 0)
    {
        return 0x80E4;
    }
    if (strcmp(str, "GL_COLOR_INDEX8_EXT") == 0)
    {
        return 0x80E5;
    }
    if (strcmp(str, "GL_COLOR_INDEXES") == 0)
    {
        return 0x1603;
    }
    if (strcmp(str, "GL_COLOR_LOGIC_OP") == 0)
    {
        return 0x0BF2;
    }
    if (strcmp(str, "GL_COLOR_LOGIC_OP_ANGLE") == 0)
    {
        return 0x0BF2;
    }
    if (strcmp(str, "GL_COLOR_MATERIAL") == 0)
    {
        return 0x0B57;
    }
    if (strcmp(str, "GL_COLOR_MATERIAL_FACE") == 0)
    {
        return 0x0B55;
    }
    if (strcmp(str, "GL_COLOR_MATERIAL_PARAMETER") == 0)
    {
        return 0x0B56;
    }
    if (strcmp(str, "GL_COLOR_MATRIX") == 0)
    {
        return 0x80B1;
    }
    if (strcmp(str, "GL_COLOR_MATRIX_SGI") == 0)
    {
        return 0x80B1;
    }
    if (strcmp(str, "GL_COLOR_MATRIX_STACK_DEPTH") == 0)
    {
        return 0x80B2;
    }
    if (strcmp(str, "GL_COLOR_MATRIX_STACK_DEPTH_SGI") == 0)
    {
        return 0x80B2;
    }
    if (strcmp(str, "GL_COLOR_RENDERABLE") == 0)
    {
        return 0x8286;
    }
    if (strcmp(str, "GL_COLOR_SAMPLES_NV") == 0)
    {
        return 0x8E20;
    }
    if (strcmp(str, "GL_COLOR_SUM") == 0)
    {
        return 0x8458;
    }
    if (strcmp(str, "GL_COLOR_SUM_ARB") == 0)
    {
        return 0x8458;
    }
    if (strcmp(str, "GL_COLOR_SUM_CLAMP_NV") == 0)
    {
        return 0x854F;
    }
    if (strcmp(str, "GL_COLOR_SUM_EXT") == 0)
    {
        return 0x8458;
    }
    if (strcmp(str, "GL_COLOR_TABLE") == 0)
    {
        return 0x80D0;
    }
    if (strcmp(str, "GL_COLOR_TABLE_ALPHA_SIZE") == 0)
    {
        return 0x80DD;
    }
    if (strcmp(str, "GL_COLOR_TABLE_ALPHA_SIZE_SGI") == 0)
    {
        return 0x80DD;
    }
    if (strcmp(str, "GL_COLOR_TABLE_BIAS") == 0)
    {
        return 0x80D7;
    }
    if (strcmp(str, "GL_COLOR_TABLE_BIAS_SGI") == 0)
    {
        return 0x80D7;
    }
    if (strcmp(str, "GL_COLOR_TABLE_BLUE_SIZE") == 0)
    {
        return 0x80DC;
    }
    if (strcmp(str, "GL_COLOR_TABLE_BLUE_SIZE_SGI") == 0)
    {
        return 0x80DC;
    }
    if (strcmp(str, "GL_COLOR_TABLE_FORMAT") == 0)
    {
        return 0x80D8;
    }
    if (strcmp(str, "GL_COLOR_TABLE_FORMAT_SGI") == 0)
    {
        return 0x80D8;
    }
    if (strcmp(str, "GL_COLOR_TABLE_GREEN_SIZE") == 0)
    {
        return 0x80DB;
    }
    if (strcmp(str, "GL_COLOR_TABLE_GREEN_SIZE_SGI") == 0)
    {
        return 0x80DB;
    }
    if (strcmp(str, "GL_COLOR_TABLE_INTENSITY_SIZE") == 0)
    {
        return 0x80DF;
    }
    if (strcmp(str, "GL_COLOR_TABLE_INTENSITY_SIZE_SGI") == 0)
    {
        return 0x80DF;
    }
    if (strcmp(str, "GL_COLOR_TABLE_LUMINANCE_SIZE") == 0)
    {
        return 0x80DE;
    }
    if (strcmp(str, "GL_COLOR_TABLE_LUMINANCE_SIZE_SGI") == 0)
    {
        return 0x80DE;
    }
    if (strcmp(str, "GL_COLOR_TABLE_RED_SIZE") == 0)
    {
        return 0x80DA;
    }
    if (strcmp(str, "GL_COLOR_TABLE_RED_SIZE_SGI") == 0)
    {
        return 0x80DA;
    }
    if (strcmp(str, "GL_COLOR_TABLE_SCALE") == 0)
    {
        return 0x80D6;
    }
    if (strcmp(str, "GL_COLOR_TABLE_SCALE_SGI") == 0)
    {
        return 0x80D6;
    }
    if (strcmp(str, "GL_COLOR_TABLE_SGI") == 0)
    {
        return 0x80D0;
    }
    if (strcmp(str, "GL_COLOR_TABLE_WIDTH") == 0)
    {
        return 0x80D9;
    }
    if (strcmp(str, "GL_COLOR_TABLE_WIDTH_SGI") == 0)
    {
        return 0x80D9;
    }
    if (strcmp(str, "GL_COLOR_WRITEMASK") == 0)
    {
        return 0x0C23;
    }
    if (strcmp(str, "GL_COMBINE") == 0)
    {
        return 0x8570;
    }
    if (strcmp(str, "GL_COMBINE4_NV") == 0)
    {
        return 0x8503;
    }
    if (strcmp(str, "GL_COMBINER0_NV") == 0)
    {
        return 0x8550;
    }
    if (strcmp(str, "GL_COMBINER1_NV") == 0)
    {
        return 0x8551;
    }
    if (strcmp(str, "GL_COMBINER2_NV") == 0)
    {
        return 0x8552;
    }
    if (strcmp(str, "GL_COMBINER3_NV") == 0)
    {
        return 0x8553;
    }
    if (strcmp(str, "GL_COMBINER4_NV") == 0)
    {
        return 0x8554;
    }
    if (strcmp(str, "GL_COMBINER5_NV") == 0)
    {
        return 0x8555;
    }
    if (strcmp(str, "GL_COMBINER6_NV") == 0)
    {
        return 0x8556;
    }
    if (strcmp(str, "GL_COMBINER7_NV") == 0)
    {
        return 0x8557;
    }
    if (strcmp(str, "GL_COMBINER_AB_DOT_PRODUCT_NV") == 0)
    {
        return 0x8545;
    }
    if (strcmp(str, "GL_COMBINER_AB_OUTPUT_NV") == 0)
    {
        return 0x854A;
    }
    if (strcmp(str, "GL_COMBINER_BIAS_NV") == 0)
    {
        return 0x8549;
    }
    if (strcmp(str, "GL_COMBINER_CD_DOT_PRODUCT_NV") == 0)
    {
        return 0x8546;
    }
    if (strcmp(str, "GL_COMBINER_CD_OUTPUT_NV") == 0)
    {
        return 0x854B;
    }
    if (strcmp(str, "GL_COMBINER_COMPONENT_USAGE_NV") == 0)
    {
        return 0x8544;
    }
    if (strcmp(str, "GL_COMBINER_INPUT_NV") == 0)
    {
        return 0x8542;
    }
    if (strcmp(str, "GL_COMBINER_MAPPING_NV") == 0)
    {
        return 0x8543;
    }
    if (strcmp(str, "GL_COMBINER_MUX_SUM_NV") == 0)
    {
        return 0x8547;
    }
    if (strcmp(str, "GL_COMBINER_SCALE_NV") == 0)
    {
        return 0x8548;
    }
    if (strcmp(str, "GL_COMBINER_SUM_OUTPUT_NV") == 0)
    {
        return 0x854C;
    }
    if (strcmp(str, "GL_COMBINE_ALPHA") == 0)
    {
        return 0x8572;
    }
    if (strcmp(str, "GL_COMBINE_ALPHA_ARB") == 0)
    {
        return 0x8572;
    }
    if (strcmp(str, "GL_COMBINE_ALPHA_EXT") == 0)
    {
        return 0x8572;
    }
    if (strcmp(str, "GL_COMBINE_ARB") == 0)
    {
        return 0x8570;
    }
    if (strcmp(str, "GL_COMBINE_EXT") == 0)
    {
        return 0x8570;
    }
    if (strcmp(str, "GL_COMBINE_RGB") == 0)
    {
        return 0x8571;
    }
    if (strcmp(str, "GL_COMBINE_RGB_ARB") == 0)
    {
        return 0x8571;
    }
    if (strcmp(str, "GL_COMBINE_RGB_EXT") == 0)
    {
        return 0x8571;
    }
    if (strcmp(str, "GL_COMMAND_BARRIER_BIT") == 0)
    {
        return 0x0040;
    }
    if (strcmp(str, "GL_COMMAND_BARRIER_BIT_EXT") == 0)
    {
        return 0x0040;
    }
    if (strcmp(str, "GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT") == 0)
    {
        return 0x884E;
    }
    if (strcmp(str, "GL_COMPARE_REF_TO_TEXTURE") == 0)
    {
        return 0x884E;
    }
    if (strcmp(str, "GL_COMPARE_REF_TO_TEXTURE_EXT") == 0)
    {
        return 0x884E;
    }
    if (strcmp(str, "GL_COMPARE_R_TO_TEXTURE") == 0)
    {
        return 0x884E;
    }
    if (strcmp(str, "GL_COMPARE_R_TO_TEXTURE_ARB") == 0)
    {
        return 0x884E;
    }
    if (strcmp(str, "GL_COMPATIBLE_SUBROUTINES") == 0)
    {
        return 0x8E4B;
    }
    if (strcmp(str, "GL_COMPILE") == 0)
    {
        return 0x1300;
    }
    if (strcmp(str, "GL_COMPILE_AND_EXECUTE") == 0)
    {
        return 0x1301;
    }
    if (strcmp(str, "GL_COMPILE_STATUS") == 0)
    {
        return 0x8B81;
    }
    if (strcmp(str, "GL_COMPLETION_STATUS_ARB") == 0)
    {
        return 0x91B1;
    }
    if (strcmp(str, "GL_COMPLETION_STATUS_KHR") == 0)
    {
        return 0x91B1;
    }
    if (strcmp(str, "GL_COMPRESSED_ALPHA") == 0)
    {
        return 0x84E9;
    }
    if (strcmp(str, "GL_COMPRESSED_ALPHA_ARB") == 0)
    {
        return 0x84E9;
    }
    if (strcmp(str, "GL_COMPRESSED_INTENSITY") == 0)
    {
        return 0x84EC;
    }
    if (strcmp(str, "GL_COMPRESSED_INTENSITY_ARB") == 0)
    {
        return 0x84EC;
    }
    if (strcmp(str, "GL_COMPRESSED_LUMINANCE") == 0)
    {
        return 0x84EA;
    }
    if (strcmp(str, "GL_COMPRESSED_LUMINANCE_ALPHA") == 0)
    {
        return 0x84EB;
    }
    if (strcmp(str, "GL_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI") == 0)
    {
        return 0x8837;
    }
    if (strcmp(str, "GL_COMPRESSED_LUMINANCE_ALPHA_ARB") == 0)
    {
        return 0x84EB;
    }
    if (strcmp(str, "GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT") == 0)
    {
        return 0x8C72;
    }
    if (strcmp(str, "GL_COMPRESSED_LUMINANCE_ARB") == 0)
    {
        return 0x84EA;
    }
    if (strcmp(str, "GL_COMPRESSED_LUMINANCE_LATC1_EXT") == 0)
    {
        return 0x8C70;
    }
    if (strcmp(str, "GL_COMPRESSED_R11_EAC") == 0)
    {
        return 0x9270;
    }
    if (strcmp(str, "GL_COMPRESSED_R11_EAC_OES") == 0)
    {
        return 0x9270;
    }
    if (strcmp(str, "GL_COMPRESSED_RED") == 0)
    {
        return 0x8225;
    }
    if (strcmp(str, "GL_COMPRESSED_RED_GREEN_RGTC2_EXT") == 0)
    {
        return 0x8DBD;
    }
    if (strcmp(str, "GL_COMPRESSED_RED_RGTC1") == 0)
    {
        return 0x8DBB;
    }
    if (strcmp(str, "GL_COMPRESSED_RED_RGTC1_EXT") == 0)
    {
        return 0x8DBB;
    }
    if (strcmp(str, "GL_COMPRESSED_RG") == 0)
    {
        return 0x8226;
    }
    if (strcmp(str, "GL_COMPRESSED_RG11_EAC") == 0)
    {
        return 0x9272;
    }
    if (strcmp(str, "GL_COMPRESSED_RG11_EAC_OES") == 0)
    {
        return 0x9272;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB") == 0)
    {
        return 0x84ED;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB8_ETC2") == 0)
    {
        return 0x9274;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB8_ETC2_OES") == 0)
    {
        return 0x9274;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2") == 0)
    {
        return 0x9276;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES") == 0)
    {
        return 0x9276;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA") == 0)
    {
        return 0x84EE;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA8_ETC2_EAC") == 0)
    {
        return 0x9278;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA8_ETC2_EAC_OES") == 0)
    {
        return 0x9278;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ARB") == 0)
    {
        return 0x84EE;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_10x10") == 0)
    {
        return 0x93BB;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_10x10_KHR") == 0)
    {
        return 0x93BB;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_10x5") == 0)
    {
        return 0x93B8;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_10x5_KHR") == 0)
    {
        return 0x93B8;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_10x6") == 0)
    {
        return 0x93B9;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_10x6_KHR") == 0)
    {
        return 0x93B9;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_10x8") == 0)
    {
        return 0x93BA;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_10x8_KHR") == 0)
    {
        return 0x93BA;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_12x10") == 0)
    {
        return 0x93BC;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_12x10_KHR") == 0)
    {
        return 0x93BC;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_12x12") == 0)
    {
        return 0x93BD;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_12x12_KHR") == 0)
    {
        return 0x93BD;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_3x3x3_OES") == 0)
    {
        return 0x93C0;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_4x3x3_OES") == 0)
    {
        return 0x93C1;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_4x4") == 0)
    {
        return 0x93B0;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_4x4_KHR") == 0)
    {
        return 0x93B0;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_4x4x3_OES") == 0)
    {
        return 0x93C2;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_4x4x4_OES") == 0)
    {
        return 0x93C3;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_5x4") == 0)
    {
        return 0x93B1;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_5x4_KHR") == 0)
    {
        return 0x93B1;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_5x4x4_OES") == 0)
    {
        return 0x93C4;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_5x5") == 0)
    {
        return 0x93B2;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_5x5_KHR") == 0)
    {
        return 0x93B2;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_5x5x4_OES") == 0)
    {
        return 0x93C5;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_5x5x5_OES") == 0)
    {
        return 0x93C6;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_6x5") == 0)
    {
        return 0x93B3;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_6x5_KHR") == 0)
    {
        return 0x93B3;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_6x5x5_OES") == 0)
    {
        return 0x93C7;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_6x6") == 0)
    {
        return 0x93B4;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_6x6_KHR") == 0)
    {
        return 0x93B4;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_6x6x5_OES") == 0)
    {
        return 0x93C8;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_6x6x6_OES") == 0)
    {
        return 0x93C9;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_8x5") == 0)
    {
        return 0x93B5;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_8x5_KHR") == 0)
    {
        return 0x93B5;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_8x6") == 0)
    {
        return 0x93B6;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_8x6_KHR") == 0)
    {
        return 0x93B6;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_8x8") == 0)
    {
        return 0x93B7;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_ASTC_8x8_KHR") == 0)
    {
        return 0x93B7;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_BPTC_UNORM") == 0)
    {
        return 0x8E8C;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_BPTC_UNORM_ARB") == 0)
    {
        return 0x8E8C;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_BPTC_UNORM_EXT") == 0)
    {
        return 0x8E8C;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_FXT1_3DFX") == 0)
    {
        return 0x86B1;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG") == 0)
    {
        return 0x8C03;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG") == 0)
    {
        return 0x9137;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG") == 0)
    {
        return 0x8C02;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG") == 0)
    {
        return 0x9138;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT") == 0)
    {
        return 0x83F1;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE") == 0)
    {
        return 0x83F2;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT") == 0)
    {
        return 0x83F2;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE") == 0)
    {
        return 0x83F3;
    }
    if (strcmp(str, "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT") == 0)
    {
        return 0x83F3;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_ARB") == 0)
    {
        return 0x84ED;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT") == 0)
    {
        return 0x8E8E;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB") == 0)
    {
        return 0x8E8E;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT") == 0)
    {
        return 0x8E8E;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT") == 0)
    {
        return 0x8E8F;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB") == 0)
    {
        return 0x8E8F;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT") == 0)
    {
        return 0x8E8F;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_FXT1_3DFX") == 0)
    {
        return 0x86B0;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG") == 0)
    {
        return 0x8C01;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG") == 0)
    {
        return 0x8C00;
    }
    if (strcmp(str, "GL_COMPRESSED_RGB_S3TC_DXT1_EXT") == 0)
    {
        return 0x83F0;
    }
    if (strcmp(str, "GL_COMPRESSED_RG_RGTC2") == 0)
    {
        return 0x8DBD;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT") == 0)
    {
        return 0x8C73;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT") == 0)
    {
        return 0x8C71;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_R11_EAC") == 0)
    {
        return 0x9271;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_R11_EAC_OES") == 0)
    {
        return 0x9271;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT") == 0)
    {
        return 0x8DBE;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_RED_RGTC1") == 0)
    {
        return 0x8DBC;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_RED_RGTC1_EXT") == 0)
    {
        return 0x8DBC;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_RG11_EAC") == 0)
    {
        return 0x9273;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_RG11_EAC_OES") == 0)
    {
        return 0x9273;
    }
    if (strcmp(str, "GL_COMPRESSED_SIGNED_RG_RGTC2") == 0)
    {
        return 0x8DBE;
    }
    if (strcmp(str, "GL_COMPRESSED_SLUMINANCE") == 0)
    {
        return 0x8C4A;
    }
    if (strcmp(str, "GL_COMPRESSED_SLUMINANCE_ALPHA") == 0)
    {
        return 0x8C4B;
    }
    if (strcmp(str, "GL_COMPRESSED_SLUMINANCE_ALPHA_EXT") == 0)
    {
        return 0x8C4B;
    }
    if (strcmp(str, "GL_COMPRESSED_SLUMINANCE_EXT") == 0)
    {
        return 0x8C4A;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB") == 0)
    {
        return 0x8C48;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10") == 0)
    {
        return 0x93DB;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR") == 0)
    {
        return 0x93DB;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5") == 0)
    {
        return 0x93D8;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR") == 0)
    {
        return 0x93D8;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6") == 0)
    {
        return 0x93D9;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR") == 0)
    {
        return 0x93D9;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8") == 0)
    {
        return 0x93DA;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR") == 0)
    {
        return 0x93DA;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10") == 0)
    {
        return 0x93DC;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR") == 0)
    {
        return 0x93DC;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12") == 0)
    {
        return 0x93DD;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR") == 0)
    {
        return 0x93DD;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES") == 0)
    {
        return 0x93E0;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES") == 0)
    {
        return 0x93E1;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4") == 0)
    {
        return 0x93D0;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR") == 0)
    {
        return 0x93D0;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES") == 0)
    {
        return 0x93E2;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES") == 0)
    {
        return 0x93E3;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4") == 0)
    {
        return 0x93D1;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR") == 0)
    {
        return 0x93D1;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES") == 0)
    {
        return 0x93E4;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5") == 0)
    {
        return 0x93D2;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR") == 0)
    {
        return 0x93D2;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES") == 0)
    {
        return 0x93E5;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES") == 0)
    {
        return 0x93E6;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5") == 0)
    {
        return 0x93D3;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR") == 0)
    {
        return 0x93D3;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES") == 0)
    {
        return 0x93E7;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6") == 0)
    {
        return 0x93D4;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR") == 0)
    {
        return 0x93D4;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES") == 0)
    {
        return 0x93E8;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES") == 0)
    {
        return 0x93E9;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5") == 0)
    {
        return 0x93D5;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR") == 0)
    {
        return 0x93D5;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6") == 0)
    {
        return 0x93D6;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR") == 0)
    {
        return 0x93D6;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8") == 0)
    {
        return 0x93D7;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR") == 0)
    {
        return 0x93D7;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC") == 0)
    {
        return 0x9279;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC_OES") == 0)
    {
        return 0x9279;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ETC2") == 0)
    {
        return 0x9275;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_ETC2_OES") == 0)
    {
        return 0x9275;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2") == 0)
    {
        return 0x9277;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES") == 0)
    {
        return 0x9277;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA") == 0)
    {
        return 0x8C49;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM") == 0)
    {
        return 0x8E8D;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB") == 0)
    {
        return 0x8E8D;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT") == 0)
    {
        return 0x8E8D;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_EXT") == 0)
    {
        return 0x8C49;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT") == 0)
    {
        return 0x8A56;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG") == 0)
    {
        return 0x93F0;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT") == 0)
    {
        return 0x8A57;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG") == 0)
    {
        return 0x93F1;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT") == 0)
    {
        return 0x8C4D;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV") == 0)
    {
        return 0x8C4D;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT") == 0)
    {
        return 0x8C4E;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV") == 0)
    {
        return 0x8C4E;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT") == 0)
    {
        return 0x8C4F;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV") == 0)
    {
        return 0x8C4F;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_EXT") == 0)
    {
        return 0x8C48;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT") == 0)
    {
        return 0x8A54;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT") == 0)
    {
        return 0x8A55;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT") == 0)
    {
        return 0x8C4C;
    }
    if (strcmp(str, "GL_COMPRESSED_SRGB_S3TC_DXT1_NV") == 0)
    {
        return 0x8C4C;
    }
    if (strcmp(str, "GL_COMPRESSED_TEXTURE_FORMATS") == 0)
    {
        return 0x86A3;
    }
    if (strcmp(str, "GL_COMPRESSED_TEXTURE_FORMATS_ARB") == 0)
    {
        return 0x86A3;
    }
    if (strcmp(str, "GL_COMPUTE_PROGRAM_NV") == 0)
    {
        return 0x90FB;
    }
    if (strcmp(str, "GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV") == 0)
    {
        return 0x90FC;
    }
    if (strcmp(str, "GL_COMPUTE_SHADER") == 0)
    {
        return 0x91B9;
    }
    if (strcmp(str, "GL_COMPUTE_SHADER_BIT") == 0)
    {
        return 0x0020;
    }
    if (strcmp(str, "GL_COMPUTE_SHADER_INVOCATIONS") == 0)
    {
        return 0x82F5;
    }
    if (strcmp(str, "GL_COMPUTE_SHADER_INVOCATIONS_ARB") == 0)
    {
        return 0x82F5;
    }
    if (strcmp(str, "GL_COMPUTE_SUBROUTINE") == 0)
    {
        return 0x92ED;
    }
    if (strcmp(str, "GL_COMPUTE_SUBROUTINE_UNIFORM") == 0)
    {
        return 0x92F3;
    }
    if (strcmp(str, "GL_COMPUTE_TEXTURE") == 0)
    {
        return 0x82A0;
    }
    if (strcmp(str, "GL_COMPUTE_WORK_GROUP_SIZE") == 0)
    {
        return 0x8267;
    }
    if (strcmp(str, "GL_COMP_BIT_ATI") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_CONDITION_SATISFIED") == 0)
    {
        return 0x911C;
    }
    if (strcmp(str, "GL_CONDITION_SATISFIED_APPLE") == 0)
    {
        return 0x911C;
    }
    if (strcmp(str, "GL_CONFORMANT_NV") == 0)
    {
        return 0x9374;
    }
    if (strcmp(str, "GL_CONIC_CURVE_TO_NV") == 0)
    {
        return 0x001A;
    }
    if (strcmp(str, "GL_CONJOINT_NV") == 0)
    {
        return 0x9284;
    }
    if (strcmp(str, "GL_CONSERVATIVE_RASTERIZATION_INTEL") == 0)
    {
        return 0x83FE;
    }
    if (strcmp(str, "GL_CONSERVATIVE_RASTERIZATION_NV") == 0)
    {
        return 0x9346;
    }
    if (strcmp(str, "GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV") == 0)
    {
        return 0x937B;
    }
    if (strcmp(str, "GL_CONSERVATIVE_RASTER_DILATE_NV") == 0)
    {
        return 0x9379;
    }
    if (strcmp(str, "GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV") == 0)
    {
        return 0x937A;
    }
    if (strcmp(str, "GL_CONSERVATIVE_RASTER_MODE_NV") == 0)
    {
        return 0x954D;
    }
    if (strcmp(str, "GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV") == 0)
    {
        return 0x954E;
    }
    if (strcmp(str, "GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV") == 0)
    {
        return 0x9550;
    }
    if (strcmp(str, "GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV") == 0)
    {
        return 0x954F;
    }
    if (strcmp(str, "GL_CONSERVE_MEMORY_HINT_PGI") == 0)
    {
        return 0x1A1FD;
    }
    if (strcmp(str, "GL_CONSTANT") == 0)
    {
        return 0x8576;
    }
    if (strcmp(str, "GL_CONSTANT_ALPHA") == 0)
    {
        return 0x8003;
    }
    if (strcmp(str, "GL_CONSTANT_ALPHA_EXT") == 0)
    {
        return 0x8003;
    }
    if (strcmp(str, "GL_CONSTANT_ARB") == 0)
    {
        return 0x8576;
    }
    if (strcmp(str, "GL_CONSTANT_ATTENUATION") == 0)
    {
        return 0x1207;
    }
    if (strcmp(str, "GL_CONSTANT_BORDER") == 0)
    {
        return 0x8151;
    }
    if (strcmp(str, "GL_CONSTANT_BORDER_HP") == 0)
    {
        return 0x8151;
    }
    if (strcmp(str, "GL_CONSTANT_COLOR") == 0)
    {
        return 0x8001;
    }
    if (strcmp(str, "GL_CONSTANT_COLOR0_NV") == 0)
    {
        return 0x852A;
    }
    if (strcmp(str, "GL_CONSTANT_COLOR1_NV") == 0)
    {
        return 0x852B;
    }
    if (strcmp(str, "GL_CONSTANT_COLOR_EXT") == 0)
    {
        return 0x8001;
    }
    if (strcmp(str, "GL_CONSTANT_EXT") == 0)
    {
        return 0x8576;
    }
    if (strcmp(str, "GL_CONSTANT_NV") == 0)
    {
        return 0x8576;
    }
    if (strcmp(str, "GL_CONST_EYE_NV") == 0)
    {
        return 0x86E5;
    }
    if (strcmp(str, "GL_CONTEXT_COMPATIBILITY_PROFILE_BIT") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_CONTEXT_CORE_PROFILE_BIT") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_CONTEXT_FLAGS") == 0)
    {
        return 0x821E;
    }
    if (strcmp(str, "GL_CONTEXT_FLAG_DEBUG_BIT") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_CONTEXT_FLAG_DEBUG_BIT_KHR") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_CONTEXT_FLAG_NO_ERROR_BIT") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_CONTEXT_FLAG_PROTECTED_CONTENT_BIT_EXT") == 0)
    {
        return 0x0010;
    }
    if (strcmp(str, "GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_CONTEXT_LOST") == 0)
    {
        return 0x0507;
    }
    if (strcmp(str, "GL_CONTEXT_LOST_KHR") == 0)
    {
        return 0x0507;
    }
    if (strcmp(str, "GL_CONTEXT_LOST_WEBGL") == 0)
    {
        return 0x9242;
    }
    if (strcmp(str, "GL_CONTEXT_PROFILE_MASK") == 0)
    {
        return 0x9126;
    }
    if (strcmp(str, "GL_CONTEXT_RELEASE_BEHAVIOR") == 0)
    {
        return 0x82FB;
    }
    if (strcmp(str, "GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH") == 0)
    {
        return 0x82FC;
    }
    if (strcmp(str, "GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR") == 0)
    {
        return 0x82FC;
    }
    if (strcmp(str, "GL_CONTEXT_RELEASE_BEHAVIOR_KHR") == 0)
    {
        return 0x82FB;
    }
    if (strcmp(str, "GL_CONTEXT_ROBUST_ACCESS") == 0)
    {
        return 0x90F3;
    }
    if (strcmp(str, "GL_CONTEXT_ROBUST_ACCESS_EXT") == 0)
    {
        return 0x90F3;
    }
    if (strcmp(str, "GL_CONTEXT_ROBUST_ACCESS_KHR") == 0)
    {
        return 0x90F3;
    }
    if (strcmp(str, "GL_CONTINUOUS_AMD") == 0)
    {
        return 0x9007;
    }
    if (strcmp(str, "GL_CONTRAST_NV") == 0)
    {
        return 0x92A1;
    }
    if (strcmp(str, "GL_CONVEX_HULL_NV") == 0)
    {
        return 0x908B;
    }
    if (strcmp(str, "GL_CONVOLUTION_1D") == 0)
    {
        return 0x8010;
    }
    if (strcmp(str, "GL_CONVOLUTION_1D_EXT") == 0)
    {
        return 0x8010;
    }
    if (strcmp(str, "GL_CONVOLUTION_2D") == 0)
    {
        return 0x8011;
    }
    if (strcmp(str, "GL_CONVOLUTION_2D_EXT") == 0)
    {
        return 0x8011;
    }
    if (strcmp(str, "GL_CONVOLUTION_BORDER_COLOR") == 0)
    {
        return 0x8154;
    }
    if (strcmp(str, "GL_CONVOLUTION_BORDER_COLOR_HP") == 0)
    {
        return 0x8154;
    }
    if (strcmp(str, "GL_CONVOLUTION_BORDER_MODE") == 0)
    {
        return 0x8013;
    }
    if (strcmp(str, "GL_CONVOLUTION_BORDER_MODE_EXT") == 0)
    {
        return 0x8013;
    }
    if (strcmp(str, "GL_CONVOLUTION_FILTER_BIAS") == 0)
    {
        return 0x8015;
    }
    if (strcmp(str, "GL_CONVOLUTION_FILTER_BIAS_EXT") == 0)
    {
        return 0x8015;
    }
    if (strcmp(str, "GL_CONVOLUTION_FILTER_SCALE") == 0)
    {
        return 0x8014;
    }
    if (strcmp(str, "GL_CONVOLUTION_FILTER_SCALE_EXT") == 0)
    {
        return 0x8014;
    }
    if (strcmp(str, "GL_CONVOLUTION_FORMAT") == 0)
    {
        return 0x8017;
    }
    if (strcmp(str, "GL_CONVOLUTION_FORMAT_EXT") == 0)
    {
        return 0x8017;
    }
    if (strcmp(str, "GL_CONVOLUTION_HEIGHT") == 0)
    {
        return 0x8019;
    }
    if (strcmp(str, "GL_CONVOLUTION_HEIGHT_EXT") == 0)
    {
        return 0x8019;
    }
    if (strcmp(str, "GL_CONVOLUTION_HINT_SGIX") == 0)
    {
        return 0x8316;
    }
    if (strcmp(str, "GL_CONVOLUTION_WIDTH") == 0)
    {
        return 0x8018;
    }
    if (strcmp(str, "GL_CONVOLUTION_WIDTH_EXT") == 0)
    {
        return 0x8018;
    }
    if (strcmp(str, "GL_CON_0_ATI") == 0)
    {
        return 0x8941;
    }
    if (strcmp(str, "GL_CON_10_ATI") == 0)
    {
        return 0x894B;
    }
    if (strcmp(str, "GL_CON_11_ATI") == 0)
    {
        return 0x894C;
    }
    if (strcmp(str, "GL_CON_12_ATI") == 0)
    {
        return 0x894D;
    }
    if (strcmp(str, "GL_CON_13_ATI") == 0)
    {
        return 0x894E;
    }
    if (strcmp(str, "GL_CON_14_ATI") == 0)
    {
        return 0x894F;
    }
    if (strcmp(str, "GL_CON_15_ATI") == 0)
    {
        return 0x8950;
    }
    if (strcmp(str, "GL_CON_16_ATI") == 0)
    {
        return 0x8951;
    }
    if (strcmp(str, "GL_CON_17_ATI") == 0)
    {
        return 0x8952;
    }
    if (strcmp(str, "GL_CON_18_ATI") == 0)
    {
        return 0x8953;
    }
    if (strcmp(str, "GL_CON_19_ATI") == 0)
    {
        return 0x8954;
    }
    if (strcmp(str, "GL_CON_1_ATI") == 0)
    {
        return 0x8942;
    }
    if (strcmp(str, "GL_CON_20_ATI") == 0)
    {
        return 0x8955;
    }
    if (strcmp(str, "GL_CON_21_ATI") == 0)
    {
        return 0x8956;
    }
    if (strcmp(str, "GL_CON_22_ATI") == 0)
    {
        return 0x8957;
    }
    if (strcmp(str, "GL_CON_23_ATI") == 0)
    {
        return 0x8958;
    }
    if (strcmp(str, "GL_CON_24_ATI") == 0)
    {
        return 0x8959;
    }
    if (strcmp(str, "GL_CON_25_ATI") == 0)
    {
        return 0x895A;
    }
    if (strcmp(str, "GL_CON_26_ATI") == 0)
    {
        return 0x895B;
    }
    if (strcmp(str, "GL_CON_27_ATI") == 0)
    {
        return 0x895C;
    }
    if (strcmp(str, "GL_CON_28_ATI") == 0)
    {
        return 0x895D;
    }
    if (strcmp(str, "GL_CON_29_ATI") == 0)
    {
        return 0x895E;
    }
    if (strcmp(str, "GL_CON_2_ATI") == 0)
    {
        return 0x8943;
    }
    if (strcmp(str, "GL_CON_30_ATI") == 0)
    {
        return 0x895F;
    }
    if (strcmp(str, "GL_CON_31_ATI") == 0)
    {
        return 0x8960;
    }
    if (strcmp(str, "GL_CON_3_ATI") == 0)
    {
        return 0x8944;
    }
    if (strcmp(str, "GL_CON_4_ATI") == 0)
    {
        return 0x8945;
    }
    if (strcmp(str, "GL_CON_5_ATI") == 0)
    {
        return 0x8946;
    }
    if (strcmp(str, "GL_CON_6_ATI") == 0)
    {
        return 0x8947;
    }
    if (strcmp(str, "GL_CON_7_ATI") == 0)
    {
        return 0x8948;
    }
    if (strcmp(str, "GL_CON_8_ATI") == 0)
    {
        return 0x8949;
    }
    if (strcmp(str, "GL_CON_9_ATI") == 0)
    {
        return 0x894A;
    }
    if (strcmp(str, "GL_COORD_REPLACE") == 0)
    {
        return 0x8862;
    }
    if (strcmp(str, "GL_COORD_REPLACE_ARB") == 0)
    {
        return 0x8862;
    }
    if (strcmp(str, "GL_COORD_REPLACE_NV") == 0)
    {
        return 0x8862;
    }
    if (strcmp(str, "GL_COORD_REPLACE_OES") == 0)
    {
        return 0x8862;
    }
    if (strcmp(str, "GL_COPY") == 0)
    {
        return 0x1503;
    }
    if (strcmp(str, "GL_COPY_INVERTED") == 0)
    {
        return 0x150C;
    }
    if (strcmp(str, "GL_COPY_PIXEL_TOKEN") == 0)
    {
        return 0x0706;
    }
    if (strcmp(str, "GL_COPY_READ_BUFFER") == 0)
    {
        return 0x8F36;
    }
    if (strcmp(str, "GL_COPY_READ_BUFFER_BINDING") == 0)
    {
        return 0x8F36;
    }
    if (strcmp(str, "GL_COPY_READ_BUFFER_NV") == 0)
    {
        return 0x8F36;
    }
    if (strcmp(str, "GL_COPY_WRITE_BUFFER") == 0)
    {
        return 0x8F37;
    }
    if (strcmp(str, "GL_COPY_WRITE_BUFFER_BINDING") == 0)
    {
        return 0x8F37;
    }
    if (strcmp(str, "GL_COPY_WRITE_BUFFER_NV") == 0)
    {
        return 0x8F37;
    }
    if (strcmp(str, "GL_COUNTER_RANGE_AMD") == 0)
    {
        return 0x8BC1;
    }
    if (strcmp(str, "GL_COUNTER_TYPE_AMD") == 0)
    {
        return 0x8BC0;
    }
    if (strcmp(str, "GL_COUNT_DOWN_NV") == 0)
    {
        return 0x9089;
    }
    if (strcmp(str, "GL_COUNT_UP_NV") == 0)
    {
        return 0x9088;
    }
    if (strcmp(str, "GL_COVERAGE_ALL_FRAGMENTS_NV") == 0)
    {
        return 0x8ED5;
    }
    if (strcmp(str, "GL_COVERAGE_ATTACHMENT_NV") == 0)
    {
        return 0x8ED2;
    }
    if (strcmp(str, "GL_COVERAGE_AUTOMATIC_NV") == 0)
    {
        return 0x8ED7;
    }
    if (strcmp(str, "GL_COVERAGE_BUFFERS_NV") == 0)
    {
        return 0x8ED3;
    }
    if (strcmp(str, "GL_COVERAGE_BUFFER_BIT_NV") == 0)
    {
        return 0x8000;
    }
    if (strcmp(str, "GL_COVERAGE_COMPONENT4_NV") == 0)
    {
        return 0x8ED1;
    }
    if (strcmp(str, "GL_COVERAGE_COMPONENT_NV") == 0)
    {
        return 0x8ED0;
    }
    if (strcmp(str, "GL_COVERAGE_EDGE_FRAGMENTS_NV") == 0)
    {
        return 0x8ED6;
    }
    if (strcmp(str, "GL_COVERAGE_MODULATION_NV") == 0)
    {
        return 0x9332;
    }
    if (strcmp(str, "GL_COVERAGE_MODULATION_TABLE_NV") == 0)
    {
        return 0x9331;
    }
    if (strcmp(str, "GL_COVERAGE_MODULATION_TABLE_SIZE_NV") == 0)
    {
        return 0x9333;
    }
    if (strcmp(str, "GL_COVERAGE_SAMPLES_NV") == 0)
    {
        return 0x8ED4;
    }
    if (strcmp(str, "GL_CPU_OPTIMIZED_QCOM") == 0)
    {
        return 0x8FB1;
    }
    if (strcmp(str, "GL_CREATE_2D_ARRAY_COMPATIBLE_BIT_ANGLE") == 0)
    {
        return 0x0020;
    }
    if (strcmp(str, "GL_CREATE_ALIAS_BIT_ANGLE") == 0)
    {
        return 0x0400;
    }
    if (strcmp(str, "GL_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_ANGLE") == 0)
    {
        return 0x0080;
    }
    if (strcmp(str, "GL_CREATE_CORNER_SAMPLED_BIT_ANGLE") == 0)
    {
        return 0x2000;
    }
    if (strcmp(str, "GL_CREATE_CUBE_COMPATIBLE_BIT_ANGLE") == 0)
    {
        return 0x0010;
    }
    if (strcmp(str, "GL_CREATE_DISJOINT_BIT_ANGLE") == 0)
    {
        return 0x0200;
    }
    if (strcmp(str, "GL_CREATE_EXTENDED_USAGE_BIT_ANGLE") == 0)
    {
        return 0x0100;
    }
    if (strcmp(str, "GL_CREATE_MUTABLE_FORMAT_BIT_ANGLE") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_CREATE_PROTECTED_BIT_ANGLE") == 0)
    {
        return 0x0800;
    }
    if (strcmp(str, "GL_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_ANGLE") == 0)
    {
        return 0x1000;
    }
    if (strcmp(str, "GL_CREATE_SPARSE_ALIASED_BIT_ANGLE") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_CREATE_SPARSE_BINDING_BIT_ANGLE") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_CREATE_SPARSE_RESIDENCY_BIT_ANGLE") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_ANGLE") == 0)
    {
        return 0x0040;
    }
    if (strcmp(str, "GL_CREATE_SUBSAMPLED_BIT_ANGLE") == 0)
    {
        return 0x4000;
    }
    if (strcmp(str, "GL_CUBIC_CURVE_TO_NV") == 0)
    {
        return 0x000C;
    }
    if (strcmp(str, "GL_CUBIC_EXT") == 0)
    {
        return 0x8334;
    }
    if (strcmp(str, "GL_CUBIC_HP") == 0)
    {
        return 0x815F;
    }
    if (strcmp(str, "GL_CUBIC_IMG") == 0)
    {
        return 0x9139;
    }
    if (strcmp(str, "GL_CUBIC_MIPMAP_LINEAR_IMG") == 0)
    {
        return 0x913B;
    }
    if (strcmp(str, "GL_CUBIC_MIPMAP_NEAREST_IMG") == 0)
    {
        return 0x913A;
    }
    if (strcmp(str, "GL_CULL_FACE") == 0)
    {
        return 0x0B44;
    }
    if (strcmp(str, "GL_CULL_FACE_MODE") == 0)
    {
        return 0x0B45;
    }
    if (strcmp(str, "GL_CULL_FRAGMENT_NV") == 0)
    {
        return 0x86E7;
    }
    if (strcmp(str, "GL_CULL_MODES_NV") == 0)
    {
        return 0x86E0;
    }
    if (strcmp(str, "GL_CULL_VERTEX_EXT") == 0)
    {
        return 0x81AA;
    }
    if (strcmp(str, "GL_CULL_VERTEX_EYE_POSITION_EXT") == 0)
    {
        return 0x81AB;
    }
    if (strcmp(str, "GL_CULL_VERTEX_IBM") == 0)
    {
        return 0x103050;
    }
    if (strcmp(str, "GL_CULL_VERTEX_OBJECT_POSITION_EXT") == 0)
    {
        return 0x81AC;
    }
    if (strcmp(str, "GL_CURRENT_ATTRIB_NV") == 0)
    {
        return 0x8626;
    }
    if (strcmp(str, "GL_CURRENT_BINORMAL_EXT") == 0)
    {
        return 0x843C;
    }
    if (strcmp(str, "GL_CURRENT_BIT") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_CURRENT_COLOR") == 0)
    {
        return 0x0B00;
    }
    if (strcmp(str, "GL_CURRENT_FOG_COORD") == 0)
    {
        return 0x8453;
    }
    if (strcmp(str, "GL_CURRENT_FOG_COORDINATE") == 0)
    {
        return 0x8453;
    }
    if (strcmp(str, "GL_CURRENT_FOG_COORDINATE_EXT") == 0)
    {
        return 0x8453;
    }
    if (strcmp(str, "GL_CURRENT_INDEX") == 0)
    {
        return 0x0B01;
    }
    if (strcmp(str, "GL_CURRENT_MATRIX_ARB") == 0)
    {
        return 0x8641;
    }
    if (strcmp(str, "GL_CURRENT_MATRIX_INDEX_ARB") == 0)
    {
        return 0x8845;
    }
    if (strcmp(str, "GL_CURRENT_MATRIX_NV") == 0)
    {
        return 0x8641;
    }
    if (strcmp(str, "GL_CURRENT_MATRIX_STACK_DEPTH_ARB") == 0)
    {
        return 0x8640;
    }
    if (strcmp(str, "GL_CURRENT_MATRIX_STACK_DEPTH_NV") == 0)
    {
        return 0x8640;
    }
    if (strcmp(str, "GL_CURRENT_NORMAL") == 0)
    {
        return 0x0B02;
    }
    if (strcmp(str, "GL_CURRENT_OCCLUSION_QUERY_ID_NV") == 0)
    {
        return 0x8865;
    }
    if (strcmp(str, "GL_CURRENT_PALETTE_MATRIX_ARB") == 0)
    {
        return 0x8843;
    }
    if (strcmp(str, "GL_CURRENT_PALETTE_MATRIX_OES") == 0)
    {
        return 0x8843;
    }
    if (strcmp(str, "GL_CURRENT_PROGRAM") == 0)
    {
        return 0x8B8D;
    }
    if (strcmp(str, "GL_CURRENT_QUERY") == 0)
    {
        return 0x8865;
    }
    if (strcmp(str, "GL_CURRENT_QUERY_ARB") == 0)
    {
        return 0x8865;
    }
    if (strcmp(str, "GL_CURRENT_QUERY_EXT") == 0)
    {
        return 0x8865;
    }
    if (strcmp(str, "GL_CURRENT_RASTER_COLOR") == 0)
    {
        return 0x0B04;
    }
    if (strcmp(str, "GL_CURRENT_RASTER_DISTANCE") == 0)
    {
        return 0x0B09;
    }
    if (strcmp(str, "GL_CURRENT_RASTER_INDEX") == 0)
    {
        return 0x0B05;
    }
    if (strcmp(str, "GL_CURRENT_RASTER_NORMAL_SGIX") == 0)
    {
        return 0x8406;
    }
    if (strcmp(str, "GL_CURRENT_RASTER_POSITION") == 0)
    {
        return 0x0B07;
    }
    if (strcmp(str, "GL_CURRENT_RASTER_POSITION_VALID") == 0)
    {
        return 0x0B08;
    }
    if (strcmp(str, "GL_CURRENT_RASTER_SECONDARY_COLOR") == 0)
    {
        return 0x845F;
    }
    if (strcmp(str, "GL_CURRENT_RASTER_TEXTURE_COORDS") == 0)
    {
        return 0x0B06;
    }
    if (strcmp(str, "GL_CURRENT_SECONDARY_COLOR") == 0)
    {
        return 0x8459;
    }
    if (strcmp(str, "GL_CURRENT_SECONDARY_COLOR_EXT") == 0)
    {
        return 0x8459;
    }
    if (strcmp(str, "GL_CURRENT_TANGENT_EXT") == 0)
    {
        return 0x843B;
    }
    if (strcmp(str, "GL_CURRENT_TEXTURE_COORDS") == 0)
    {
        return 0x0B03;
    }
    if (strcmp(str, "GL_CURRENT_TIME_NV") == 0)
    {
        return 0x8E28;
    }
    if (strcmp(str, "GL_CURRENT_VERTEX_ATTRIB") == 0)
    {
        return 0x8626;
    }
    if (strcmp(str, "GL_CURRENT_VERTEX_ATTRIB_ARB") == 0)
    {
        return 0x8626;
    }
    if (strcmp(str, "GL_CURRENT_VERTEX_EXT") == 0)
    {
        return 0x87E2;
    }
    if (strcmp(str, "GL_CURRENT_VERTEX_WEIGHT_EXT") == 0)
    {
        return 0x850B;
    }
    if (strcmp(str, "GL_CURRENT_WEIGHT_ARB") == 0)
    {
        return 0x86A8;
    }
    if (strcmp(str, "GL_CW") == 0)
    {
        return 0x0900;
    }
    if (strcmp(str, "GL_D3D12_FENCE_VALUE_EXT") == 0)
    {
        return 0x9595;
    }
    if (strcmp(str, "GL_DARKEN") == 0)
    {
        return 0x9297;
    }
    if (strcmp(str, "GL_DARKEN_KHR") == 0)
    {
        return 0x9297;
    }
    if (strcmp(str, "GL_DARKEN_NV") == 0)
    {
        return 0x9297;
    }
    if (strcmp(str, "GL_DATA_BUFFER_AMD") == 0)
    {
        return 0x9151;
    }
    if (strcmp(str, "GL_DEBUG_ASSERT_MESA") == 0)
    {
        return 0x875B;
    }
    if (strcmp(str, "GL_DEBUG_CALLBACK_FUNCTION") == 0)
    {
        return 0x8244;
    }
    if (strcmp(str, "GL_DEBUG_CALLBACK_FUNCTION_ARB") == 0)
    {
        return 0x8244;
    }
    if (strcmp(str, "GL_DEBUG_CALLBACK_FUNCTION_KHR") == 0)
    {
        return 0x8244;
    }
    if (strcmp(str, "GL_DEBUG_CALLBACK_USER_PARAM") == 0)
    {
        return 0x8245;
    }
    if (strcmp(str, "GL_DEBUG_CALLBACK_USER_PARAM_ARB") == 0)
    {
        return 0x8245;
    }
    if (strcmp(str, "GL_DEBUG_CALLBACK_USER_PARAM_KHR") == 0)
    {
        return 0x8245;
    }
    if (strcmp(str, "GL_DEBUG_CATEGORY_API_ERROR_AMD") == 0)
    {
        return 0x9149;
    }
    if (strcmp(str, "GL_DEBUG_CATEGORY_APPLICATION_AMD") == 0)
    {
        return 0x914F;
    }
    if (strcmp(str, "GL_DEBUG_CATEGORY_DEPRECATION_AMD") == 0)
    {
        return 0x914B;
    }
    if (strcmp(str, "GL_DEBUG_CATEGORY_OTHER_AMD") == 0)
    {
        return 0x9150;
    }
    if (strcmp(str, "GL_DEBUG_CATEGORY_PERFORMANCE_AMD") == 0)
    {
        return 0x914D;
    }
    if (strcmp(str, "GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD") == 0)
    {
        return 0x914E;
    }
    if (strcmp(str, "GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD") == 0)
    {
        return 0x914C;
    }
    if (strcmp(str, "GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD") == 0)
    {
        return 0x914A;
    }
    if (strcmp(str, "GL_DEBUG_GROUP_STACK_DEPTH") == 0)
    {
        return 0x826D;
    }
    if (strcmp(str, "GL_DEBUG_GROUP_STACK_DEPTH_KHR") == 0)
    {
        return 0x826D;
    }
    if (strcmp(str, "GL_DEBUG_LOGGED_MESSAGES") == 0)
    {
        return 0x9145;
    }
    if (strcmp(str, "GL_DEBUG_LOGGED_MESSAGES_AMD") == 0)
    {
        return 0x9145;
    }
    if (strcmp(str, "GL_DEBUG_LOGGED_MESSAGES_ARB") == 0)
    {
        return 0x9145;
    }
    if (strcmp(str, "GL_DEBUG_LOGGED_MESSAGES_KHR") == 0)
    {
        return 0x9145;
    }
    if (strcmp(str, "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH") == 0)
    {
        return 0x8243;
    }
    if (strcmp(str, "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB") == 0)
    {
        return 0x8243;
    }
    if (strcmp(str, "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR") == 0)
    {
        return 0x8243;
    }
    if (strcmp(str, "GL_DEBUG_OBJECT_MESA") == 0)
    {
        return 0x8759;
    }
    if (strcmp(str, "GL_DEBUG_OUTPUT") == 0)
    {
        return 0x92E0;
    }
    if (strcmp(str, "GL_DEBUG_OUTPUT_KHR") == 0)
    {
        return 0x92E0;
    }
    if (strcmp(str, "GL_DEBUG_OUTPUT_SYNCHRONOUS") == 0)
    {
        return 0x8242;
    }
    if (strcmp(str, "GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB") == 0)
    {
        return 0x8242;
    }
    if (strcmp(str, "GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR") == 0)
    {
        return 0x8242;
    }
    if (strcmp(str, "GL_DEBUG_PRINT_MESA") == 0)
    {
        return 0x875A;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_HIGH") == 0)
    {
        return 0x9146;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_HIGH_AMD") == 0)
    {
        return 0x9146;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_HIGH_ARB") == 0)
    {
        return 0x9146;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_HIGH_KHR") == 0)
    {
        return 0x9146;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_LOW") == 0)
    {
        return 0x9148;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_LOW_AMD") == 0)
    {
        return 0x9148;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_LOW_ARB") == 0)
    {
        return 0x9148;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_LOW_KHR") == 0)
    {
        return 0x9148;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_MEDIUM") == 0)
    {
        return 0x9147;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_MEDIUM_AMD") == 0)
    {
        return 0x9147;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_MEDIUM_ARB") == 0)
    {
        return 0x9147;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_MEDIUM_KHR") == 0)
    {
        return 0x9147;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_NOTIFICATION") == 0)
    {
        return 0x826B;
    }
    if (strcmp(str, "GL_DEBUG_SEVERITY_NOTIFICATION_KHR") == 0)
    {
        return 0x826B;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_API") == 0)
    {
        return 0x8246;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_API_ARB") == 0)
    {
        return 0x8246;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_API_KHR") == 0)
    {
        return 0x8246;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_APPLICATION") == 0)
    {
        return 0x824A;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_APPLICATION_ARB") == 0)
    {
        return 0x824A;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_APPLICATION_KHR") == 0)
    {
        return 0x824A;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_OTHER") == 0)
    {
        return 0x824B;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_OTHER_ARB") == 0)
    {
        return 0x824B;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_OTHER_KHR") == 0)
    {
        return 0x824B;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_SHADER_COMPILER") == 0)
    {
        return 0x8248;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_SHADER_COMPILER_ARB") == 0)
    {
        return 0x8248;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_SHADER_COMPILER_KHR") == 0)
    {
        return 0x8248;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_THIRD_PARTY") == 0)
    {
        return 0x8249;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_THIRD_PARTY_ARB") == 0)
    {
        return 0x8249;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_THIRD_PARTY_KHR") == 0)
    {
        return 0x8249;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_WINDOW_SYSTEM") == 0)
    {
        return 0x8247;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB") == 0)
    {
        return 0x8247;
    }
    if (strcmp(str, "GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR") == 0)
    {
        return 0x8247;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR") == 0)
    {
        return 0x824D;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB") == 0)
    {
        return 0x824D;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR") == 0)
    {
        return 0x824D;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_ERROR") == 0)
    {
        return 0x824C;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_ERROR_ARB") == 0)
    {
        return 0x824C;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_ERROR_KHR") == 0)
    {
        return 0x824C;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_MARKER") == 0)
    {
        return 0x8268;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_MARKER_KHR") == 0)
    {
        return 0x8268;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_OTHER") == 0)
    {
        return 0x8251;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_OTHER_ARB") == 0)
    {
        return 0x8251;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_OTHER_KHR") == 0)
    {
        return 0x8251;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_PERFORMANCE") == 0)
    {
        return 0x8250;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_PERFORMANCE_ARB") == 0)
    {
        return 0x8250;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_PERFORMANCE_KHR") == 0)
    {
        return 0x8250;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_POP_GROUP") == 0)
    {
        return 0x826A;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_POP_GROUP_KHR") == 0)
    {
        return 0x826A;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_PORTABILITY") == 0)
    {
        return 0x824F;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_PORTABILITY_ARB") == 0)
    {
        return 0x824F;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_PORTABILITY_KHR") == 0)
    {
        return 0x824F;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_PUSH_GROUP") == 0)
    {
        return 0x8269;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_PUSH_GROUP_KHR") == 0)
    {
        return 0x8269;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR") == 0)
    {
        return 0x824E;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB") == 0)
    {
        return 0x824E;
    }
    if (strcmp(str, "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR") == 0)
    {
        return 0x824E;
    }
    if (strcmp(str, "GL_DECAL") == 0)
    {
        return 0x2101;
    }
    if (strcmp(str, "GL_DECODE_EXT") == 0)
    {
        return 0x8A49;
    }
    if (strcmp(str, "GL_DECR") == 0)
    {
        return 0x1E03;
    }
    if (strcmp(str, "GL_DECR_WRAP") == 0)
    {
        return 0x8508;
    }
    if (strcmp(str, "GL_DECR_WRAP_EXT") == 0)
    {
        return 0x8508;
    }
    if (strcmp(str, "GL_DECR_WRAP_OES") == 0)
    {
        return 0x8508;
    }
    if (strcmp(str, "GL_DEDICATED_MEMORY_OBJECT_EXT") == 0)
    {
        return 0x9581;
    }
    if (strcmp(str, "GL_DEFORMATIONS_MASK_SGIX") == 0)
    {
        return 0x8196;
    }
    if (strcmp(str, "GL_DELETE_STATUS") == 0)
    {
        return 0x8B80;
    }
    if (strcmp(str, "GL_DEPENDENT_AR_TEXTURE_2D_NV") == 0)
    {
        return 0x86E9;
    }
    if (strcmp(str, "GL_DEPENDENT_GB_TEXTURE_2D_NV") == 0)
    {
        return 0x86EA;
    }
    if (strcmp(str, "GL_DEPENDENT_HILO_TEXTURE_2D_NV") == 0)
    {
        return 0x8858;
    }
    if (strcmp(str, "GL_DEPENDENT_RGB_TEXTURE_3D_NV") == 0)
    {
        return 0x8859;
    }
    if (strcmp(str, "GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV") == 0)
    {
        return 0x885A;
    }
    if (strcmp(str, "GL_DEPTH") == 0)
    {
        return 0x1801;
    }
    if (strcmp(str, "GL_DEPTH24_STENCIL8") == 0)
    {
        return 0x88F0;
    }
    if (strcmp(str, "GL_DEPTH24_STENCIL8_EXT") == 0)
    {
        return 0x88F0;
    }
    if (strcmp(str, "GL_DEPTH24_STENCIL8_OES") == 0)
    {
        return 0x88F0;
    }
    if (strcmp(str, "GL_DEPTH32F_STENCIL8") == 0)
    {
        return 0x8CAD;
    }
    if (strcmp(str, "GL_DEPTH32F_STENCIL8_NV") == 0)
    {
        return 0x8DAC;
    }
    if (strcmp(str, "GL_DEPTH_ATTACHMENT") == 0)
    {
        return 0x8D00;
    }
    if (strcmp(str, "GL_DEPTH_ATTACHMENT_EXT") == 0)
    {
        return 0x8D00;
    }
    if (strcmp(str, "GL_DEPTH_ATTACHMENT_OES") == 0)
    {
        return 0x8D00;
    }
    if (strcmp(str, "GL_DEPTH_BIAS") == 0)
    {
        return 0x0D1F;
    }
    if (strcmp(str, "GL_DEPTH_BITS") == 0)
    {
        return 0x0D56;
    }
    if (strcmp(str, "GL_DEPTH_BOUNDS_EXT") == 0)
    {
        return 0x8891;
    }
    if (strcmp(str, "GL_DEPTH_BOUNDS_TEST_EXT") == 0)
    {
        return 0x8890;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_BIT") == 0)
    {
        return 0x0100;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_BIT0_QCOM") == 0)
    {
        return 0x0100;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_BIT1_QCOM") == 0)
    {
        return 0x0200;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_BIT2_QCOM") == 0)
    {
        return 0x0400;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_BIT3_QCOM") == 0)
    {
        return 0x0800;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_BIT4_QCOM") == 0)
    {
        return 0x1000;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_BIT5_QCOM") == 0)
    {
        return 0x2000;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_BIT6_QCOM") == 0)
    {
        return 0x4000;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_BIT7_QCOM") == 0)
    {
        return 0x8000;
    }
    if (strcmp(str, "GL_DEPTH_BUFFER_FLOAT_MODE_NV") == 0)
    {
        return 0x8DAF;
    }
    if (strcmp(str, "GL_DEPTH_CLAMP") == 0)
    {
        return 0x864F;
    }
    if (strcmp(str, "GL_DEPTH_CLAMP_EXT") == 0)
    {
        return 0x864F;
    }
    if (strcmp(str, "GL_DEPTH_CLAMP_FAR_AMD") == 0)
    {
        return 0x901F;
    }
    if (strcmp(str, "GL_DEPTH_CLAMP_NEAR_AMD") == 0)
    {
        return 0x901E;
    }
    if (strcmp(str, "GL_DEPTH_CLAMP_NV") == 0)
    {
        return 0x864F;
    }
    if (strcmp(str, "GL_DEPTH_CLEAR_VALUE") == 0)
    {
        return 0x0B73;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT") == 0)
    {
        return 0x1902;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT16") == 0)
    {
        return 0x81A5;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT16_ARB") == 0)
    {
        return 0x81A5;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT16_NONLINEAR_NV") == 0)
    {
        return 0x8E2C;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT16_OES") == 0)
    {
        return 0x81A5;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT16_SGIX") == 0)
    {
        return 0x81A5;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT24") == 0)
    {
        return 0x81A6;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT24_ARB") == 0)
    {
        return 0x81A6;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT24_OES") == 0)
    {
        return 0x81A6;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT24_SGIX") == 0)
    {
        return 0x81A6;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT32") == 0)
    {
        return 0x81A7;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT32F") == 0)
    {
        return 0x8CAC;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT32F_NV") == 0)
    {
        return 0x8DAB;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT32_ARB") == 0)
    {
        return 0x81A7;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT32_OES") == 0)
    {
        return 0x81A7;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENT32_SGIX") == 0)
    {
        return 0x81A7;
    }
    if (strcmp(str, "GL_DEPTH_COMPONENTS") == 0)
    {
        return 0x8284;
    }
    if (strcmp(str, "GL_DEPTH_EXT") == 0)
    {
        return 0x1801;
    }
    if (strcmp(str, "GL_DEPTH_FUNC") == 0)
    {
        return 0x0B74;
    }
    if (strcmp(str, "GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX") == 0)
    {
        return 0x8311;
    }
    if (strcmp(str, "GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX") == 0)
    {
        return 0x8312;
    }
    if (strcmp(str, "GL_DEPTH_PASS_INSTRUMENT_SGIX") == 0)
    {
        return 0x8310;
    }
    if (strcmp(str, "GL_DEPTH_RANGE") == 0)
    {
        return 0x0B70;
    }
    if (strcmp(str, "GL_DEPTH_RENDERABLE") == 0)
    {
        return 0x8287;
    }
    if (strcmp(str, "GL_DEPTH_SAMPLES_NV") == 0)
    {
        return 0x932D;
    }
    if (strcmp(str, "GL_DEPTH_SCALE") == 0)
    {
        return 0x0D1E;
    }
    if (strcmp(str, "GL_DEPTH_STENCIL") == 0)
    {
        return 0x84F9;
    }
    if (strcmp(str, "GL_DEPTH_STENCIL_ATTACHMENT") == 0)
    {
        return 0x821A;
    }
    if (strcmp(str, "GL_DEPTH_STENCIL_EXT") == 0)
    {
        return 0x84F9;
    }
    if (strcmp(str, "GL_DEPTH_STENCIL_MESA") == 0)
    {
        return 0x8750;
    }
    if (strcmp(str, "GL_DEPTH_STENCIL_NV") == 0)
    {
        return 0x84F9;
    }
    if (strcmp(str, "GL_DEPTH_STENCIL_OES") == 0)
    {
        return 0x84F9;
    }
    if (strcmp(str, "GL_DEPTH_STENCIL_TEXTURE_MODE") == 0)
    {
        return 0x90EA;
    }
    if (strcmp(str, "GL_DEPTH_STENCIL_TO_BGRA_NV") == 0)
    {
        return 0x886F;
    }
    if (strcmp(str, "GL_DEPTH_STENCIL_TO_RGBA_NV") == 0)
    {
        return 0x886E;
    }
    if (strcmp(str, "GL_DEPTH_TEST") == 0)
    {
        return 0x0B71;
    }
    if (strcmp(str, "GL_DEPTH_TEXTURE_MODE") == 0)
    {
        return 0x884B;
    }
    if (strcmp(str, "GL_DEPTH_TEXTURE_MODE_ARB") == 0)
    {
        return 0x884B;
    }
    if (strcmp(str, "GL_DEPTH_WRITEMASK") == 0)
    {
        return 0x0B72;
    }
    if (strcmp(str, "GL_DETACHED_BUFFERS_NV") == 0)
    {
        return 0x95AB;
    }
    if (strcmp(str, "GL_DETACHED_MEMORY_INCARNATION_NV") == 0)
    {
        return 0x95A9;
    }
    if (strcmp(str, "GL_DETACHED_TEXTURES_NV") == 0)
    {
        return 0x95AA;
    }
    if (strcmp(str, "GL_DETAIL_TEXTURE_2D_BINDING_SGIS") == 0)
    {
        return 0x8096;
    }
    if (strcmp(str, "GL_DETAIL_TEXTURE_2D_SGIS") == 0)
    {
        return 0x8095;
    }
    if (strcmp(str, "GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS") == 0)
    {
        return 0x809C;
    }
    if (strcmp(str, "GL_DETAIL_TEXTURE_LEVEL_SGIS") == 0)
    {
        return 0x809A;
    }
    if (strcmp(str, "GL_DETAIL_TEXTURE_MODE_SGIS") == 0)
    {
        return 0x809B;
    }
    if (strcmp(str, "GL_DEVICE_LUID_EXT") == 0)
    {
        return 0x9599;
    }
    if (strcmp(str, "GL_DEVICE_NODE_MASK_EXT") == 0)
    {
        return 0x959A;
    }
    if (strcmp(str, "GL_DEVICE_UUID_EXT") == 0)
    {
        return 0x9597;
    }
    if (strcmp(str, "GL_DIFFERENCE") == 0)
    {
        return 0x929E;
    }
    if (strcmp(str, "GL_DIFFERENCE_KHR") == 0)
    {
        return 0x929E;
    }
    if (strcmp(str, "GL_DIFFERENCE_NV") == 0)
    {
        return 0x929E;
    }
    if (strcmp(str, "GL_DIFFUSE") == 0)
    {
        return 0x1201;
    }
    if (strcmp(str, "GL_DISCARD_ATI") == 0)
    {
        return 0x8763;
    }
    if (strcmp(str, "GL_DISCARD_NV") == 0)
    {
        return 0x8530;
    }
    if (strcmp(str, "GL_DISCRETE_AMD") == 0)
    {
        return 0x9006;
    }
    if (strcmp(str, "GL_DISJOINT_NV") == 0)
    {
        return 0x9283;
    }
    if (strcmp(str, "GL_DISPATCH_INDIRECT_BUFFER") == 0)
    {
        return 0x90EE;
    }
    if (strcmp(str, "GL_DISPATCH_INDIRECT_BUFFER_BINDING") == 0)
    {
        return 0x90EF;
    }
    if (strcmp(str, "GL_DISPLAY_LIST") == 0)
    {
        return 0x82E7;
    }
    if (strcmp(str, "GL_DISTANCE_ATTENUATION_EXT") == 0)
    {
        return 0x8129;
    }
    if (strcmp(str, "GL_DISTANCE_ATTENUATION_SGIS") == 0)
    {
        return 0x8129;
    }
    if (strcmp(str, "GL_DITHER") == 0)
    {
        return 0x0BD0;
    }
    if (strcmp(str, "GL_DMP_PROGRAM_BINARY_DMP") == 0)
    {
        return 0x9253;
    }
    if (strcmp(str, "GL_DOMAIN") == 0)
    {
        return 0x0A02;
    }
    if (strcmp(str, "GL_DONT_CARE") == 0)
    {
        return 0x1100;
    }
    if (strcmp(str, "GL_DOT2_ADD_ATI") == 0)
    {
        return 0x896C;
    }
    if (strcmp(str, "GL_DOT3_ATI") == 0)
    {
        return 0x8966;
    }
    if (strcmp(str, "GL_DOT3_RGB") == 0)
    {
        return 0x86AE;
    }
    if (strcmp(str, "GL_DOT3_RGBA") == 0)
    {
        return 0x86AF;
    }
    if (strcmp(str, "GL_DOT3_RGBA_ARB") == 0)
    {
        return 0x86AF;
    }
    if (strcmp(str, "GL_DOT3_RGBA_EXT") == 0)
    {
        return 0x8741;
    }
    if (strcmp(str, "GL_DOT3_RGBA_IMG") == 0)
    {
        return 0x86AF;
    }
    if (strcmp(str, "GL_DOT3_RGB_ARB") == 0)
    {
        return 0x86AE;
    }
    if (strcmp(str, "GL_DOT3_RGB_EXT") == 0)
    {
        return 0x8740;
    }
    if (strcmp(str, "GL_DOT4_ATI") == 0)
    {
        return 0x8967;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV") == 0)
    {
        return 0x885D;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV") == 0)
    {
        return 0x86F3;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_DEPTH_REPLACE_NV") == 0)
    {
        return 0x86ED;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV") == 0)
    {
        return 0x86F1;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_NV") == 0)
    {
        return 0x86EC;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_PASS_THROUGH_NV") == 0)
    {
        return 0x885B;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV") == 0)
    {
        return 0x86F2;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_TEXTURE_1D_NV") == 0)
    {
        return 0x885C;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_TEXTURE_2D_NV") == 0)
    {
        return 0x86EE;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_TEXTURE_3D_NV") == 0)
    {
        return 0x86EF;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV") == 0)
    {
        return 0x86F0;
    }
    if (strcmp(str, "GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV") == 0)
    {
        return 0x864E;
    }
    if (strcmp(str, "GL_DOUBLE") == 0)
    {
        return 0x140A;
    }
    if (strcmp(str, "GL_DOUBLEBUFFER") == 0)
    {
        return 0x0C32;
    }
    if (strcmp(str, "GL_DOUBLE_EXT") == 0)
    {
        return 0x140A;
    }
    if (strcmp(str, "GL_DOUBLE_MAT2") == 0)
    {
        return 0x8F46;
    }
    if (strcmp(str, "GL_DOUBLE_MAT2_EXT") == 0)
    {
        return 0x8F46;
    }
    if (strcmp(str, "GL_DOUBLE_MAT2x3") == 0)
    {
        return 0x8F49;
    }
    if (strcmp(str, "GL_DOUBLE_MAT2x3_EXT") == 0)
    {
        return 0x8F49;
    }
    if (strcmp(str, "GL_DOUBLE_MAT2x4") == 0)
    {
        return 0x8F4A;
    }
    if (strcmp(str, "GL_DOUBLE_MAT2x4_EXT") == 0)
    {
        return 0x8F4A;
    }
    if (strcmp(str, "GL_DOUBLE_MAT3") == 0)
    {
        return 0x8F47;
    }
    if (strcmp(str, "GL_DOUBLE_MAT3_EXT") == 0)
    {
        return 0x8F47;
    }
    if (strcmp(str, "GL_DOUBLE_MAT3x2") == 0)
    {
        return 0x8F4B;
    }
    if (strcmp(str, "GL_DOUBLE_MAT3x2_EXT") == 0)
    {
        return 0x8F4B;
    }
    if (strcmp(str, "GL_DOUBLE_MAT3x4") == 0)
    {
        return 0x8F4C;
    }
    if (strcmp(str, "GL_DOUBLE_MAT3x4_EXT") == 0)
    {
        return 0x8F4C;
    }
    if (strcmp(str, "GL_DOUBLE_MAT4") == 0)
    {
        return 0x8F48;
    }
    if (strcmp(str, "GL_DOUBLE_MAT4_EXT") == 0)
    {
        return 0x8F48;
    }
    if (strcmp(str, "GL_DOUBLE_MAT4x2") == 0)
    {
        return 0x8F4D;
    }
    if (strcmp(str, "GL_DOUBLE_MAT4x2_EXT") == 0)
    {
        return 0x8F4D;
    }
    if (strcmp(str, "GL_DOUBLE_MAT4x3") == 0)
    {
        return 0x8F4E;
    }
    if (strcmp(str, "GL_DOUBLE_MAT4x3_EXT") == 0)
    {
        return 0x8F4E;
    }
    if (strcmp(str, "GL_DOUBLE_VEC2") == 0)
    {
        return 0x8FFC;
    }
    if (strcmp(str, "GL_DOUBLE_VEC2_EXT") == 0)
    {
        return 0x8FFC;
    }
    if (strcmp(str, "GL_DOUBLE_VEC3") == 0)
    {
        return 0x8FFD;
    }
    if (strcmp(str, "GL_DOUBLE_VEC3_EXT") == 0)
    {
        return 0x8FFD;
    }
    if (strcmp(str, "GL_DOUBLE_VEC4") == 0)
    {
        return 0x8FFE;
    }
    if (strcmp(str, "GL_DOUBLE_VEC4_EXT") == 0)
    {
        return 0x8FFE;
    }
    if (strcmp(str, "GL_DOWNSAMPLE_SCALES_IMG") == 0)
    {
        return 0x913E;
    }
    if (strcmp(str, "GL_DRAW_ARRAYS_COMMAND_NV") == 0)
    {
        return 0x0003;
    }
    if (strcmp(str, "GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV") == 0)
    {
        return 0x0007;
    }
    if (strcmp(str, "GL_DRAW_ARRAYS_STRIP_COMMAND_NV") == 0)
    {
        return 0x0005;
    }
    if (strcmp(str, "GL_DRAW_BUFFER") == 0)
    {
        return 0x0C01;
    }
    if (strcmp(str, "GL_DRAW_BUFFER0") == 0)
    {
        return 0x8825;
    }
    if (strcmp(str, "GL_DRAW_BUFFER0_ARB") == 0)
    {
        return 0x8825;
    }
    if (strcmp(str, "GL_DRAW_BUFFER0_ATI") == 0)
    {
        return 0x8825;
    }
    if (strcmp(str, "GL_DRAW_BUFFER0_EXT") == 0)
    {
        return 0x8825;
    }
    if (strcmp(str, "GL_DRAW_BUFFER0_NV") == 0)
    {
        return 0x8825;
    }
    if (strcmp(str, "GL_DRAW_BUFFER1") == 0)
    {
        return 0x8826;
    }
    if (strcmp(str, "GL_DRAW_BUFFER10") == 0)
    {
        return 0x882F;
    }
    if (strcmp(str, "GL_DRAW_BUFFER10_ARB") == 0)
    {
        return 0x882F;
    }
    if (strcmp(str, "GL_DRAW_BUFFER10_ATI") == 0)
    {
        return 0x882F;
    }
    if (strcmp(str, "GL_DRAW_BUFFER10_EXT") == 0)
    {
        return 0x882F;
    }
    if (strcmp(str, "GL_DRAW_BUFFER10_NV") == 0)
    {
        return 0x882F;
    }
    if (strcmp(str, "GL_DRAW_BUFFER11") == 0)
    {
        return 0x8830;
    }
    if (strcmp(str, "GL_DRAW_BUFFER11_ARB") == 0)
    {
        return 0x8830;
    }
    if (strcmp(str, "GL_DRAW_BUFFER11_ATI") == 0)
    {
        return 0x8830;
    }
    if (strcmp(str, "GL_DRAW_BUFFER11_EXT") == 0)
    {
        return 0x8830;
    }
    if (strcmp(str, "GL_DRAW_BUFFER11_NV") == 0)
    {
        return 0x8830;
    }
    if (strcmp(str, "GL_DRAW_BUFFER12") == 0)
    {
        return 0x8831;
    }
    if (strcmp(str, "GL_DRAW_BUFFER12_ARB") == 0)
    {
        return 0x8831;
    }
    if (strcmp(str, "GL_DRAW_BUFFER12_ATI") == 0)
    {
        return 0x8831;
    }
    if (strcmp(str, "GL_DRAW_BUFFER12_EXT") == 0)
    {
        return 0x8831;
    }
    if (strcmp(str, "GL_DRAW_BUFFER12_NV") == 0)
    {
        return 0x8831;
    }
    if (strcmp(str, "GL_DRAW_BUFFER13") == 0)
    {
        return 0x8832;
    }
    if (strcmp(str, "GL_DRAW_BUFFER13_ARB") == 0)
    {
        return 0x8832;
    }
    if (strcmp(str, "GL_DRAW_BUFFER13_ATI") == 0)
    {
        return 0x8832;
    }
    if (strcmp(str, "GL_DRAW_BUFFER13_EXT") == 0)
    {
        return 0x8832;
    }
    if (strcmp(str, "GL_DRAW_BUFFER13_NV") == 0)
    {
        return 0x8832;
    }
    if (strcmp(str, "GL_DRAW_BUFFER14") == 0)
    {
        return 0x8833;
    }
    if (strcmp(str, "GL_DRAW_BUFFER14_ARB") == 0)
    {
        return 0x8833;
    }
    if (strcmp(str, "GL_DRAW_BUFFER14_ATI") == 0)
    {
        return 0x8833;
    }
    if (strcmp(str, "GL_DRAW_BUFFER14_EXT") == 0)
    {
        return 0x8833;
    }
    if (strcmp(str, "GL_DRAW_BUFFER14_NV") == 0)
    {
        return 0x8833;
    }
    if (strcmp(str, "GL_DRAW_BUFFER15") == 0)
    {
        return 0x8834;
    }
    if (strcmp(str, "GL_DRAW_BUFFER15_ARB") == 0)
    {
        return 0x8834;
    }
    if (strcmp(str, "GL_DRAW_BUFFER15_ATI") == 0)
    {
        return 0x8834;
    }
    if (strcmp(str, "GL_DRAW_BUFFER15_EXT") == 0)
    {
        return 0x8834;
    }
    if (strcmp(str, "GL_DRAW_BUFFER15_NV") == 0)
    {
        return 0x8834;
    }
    if (strcmp(str, "GL_DRAW_BUFFER1_ARB") == 0)
    {
        return 0x8826;
    }
    if (strcmp(str, "GL_DRAW_BUFFER1_ATI") == 0)
    {
        return 0x8826;
    }
    if (strcmp(str, "GL_DRAW_BUFFER1_EXT") == 0)
    {
        return 0x8826;
    }
    if (strcmp(str, "GL_DRAW_BUFFER1_NV") == 0)
    {
        return 0x8826;
    }
    if (strcmp(str, "GL_DRAW_BUFFER2") == 0)
    {
        return 0x8827;
    }
    if (strcmp(str, "GL_DRAW_BUFFER2_ARB") == 0)
    {
        return 0x8827;
    }
    if (strcmp(str, "GL_DRAW_BUFFER2_ATI") == 0)
    {
        return 0x8827;
    }
    if (strcmp(str, "GL_DRAW_BUFFER2_EXT") == 0)
    {
        return 0x8827;
    }
    if (strcmp(str, "GL_DRAW_BUFFER2_NV") == 0)
    {
        return 0x8827;
    }
    if (strcmp(str, "GL_DRAW_BUFFER3") == 0)
    {
        return 0x8828;
    }
    if (strcmp(str, "GL_DRAW_BUFFER3_ARB") == 0)
    {
        return 0x8828;
    }
    if (strcmp(str, "GL_DRAW_BUFFER3_ATI") == 0)
    {
        return 0x8828;
    }
    if (strcmp(str, "GL_DRAW_BUFFER3_EXT") == 0)
    {
        return 0x8828;
    }
    if (strcmp(str, "GL_DRAW_BUFFER3_NV") == 0)
    {
        return 0x8828;
    }
    if (strcmp(str, "GL_DRAW_BUFFER4") == 0)
    {
        return 0x8829;
    }
    if (strcmp(str, "GL_DRAW_BUFFER4_ARB") == 0)
    {
        return 0x8829;
    }
    if (strcmp(str, "GL_DRAW_BUFFER4_ATI") == 0)
    {
        return 0x8829;
    }
    if (strcmp(str, "GL_DRAW_BUFFER4_EXT") == 0)
    {
        return 0x8829;
    }
    if (strcmp(str, "GL_DRAW_BUFFER4_NV") == 0)
    {
        return 0x8829;
    }
    if (strcmp(str, "GL_DRAW_BUFFER5") == 0)
    {
        return 0x882A;
    }
    if (strcmp(str, "GL_DRAW_BUFFER5_ARB") == 0)
    {
        return 0x882A;
    }
    if (strcmp(str, "GL_DRAW_BUFFER5_ATI") == 0)
    {
        return 0x882A;
    }
    if (strcmp(str, "GL_DRAW_BUFFER5_EXT") == 0)
    {
        return 0x882A;
    }
    if (strcmp(str, "GL_DRAW_BUFFER5_NV") == 0)
    {
        return 0x882A;
    }
    if (strcmp(str, "GL_DRAW_BUFFER6") == 0)
    {
        return 0x882B;
    }
    if (strcmp(str, "GL_DRAW_BUFFER6_ARB") == 0)
    {
        return 0x882B;
    }
    if (strcmp(str, "GL_DRAW_BUFFER6_ATI") == 0)
    {
        return 0x882B;
    }
    if (strcmp(str, "GL_DRAW_BUFFER6_EXT") == 0)
    {
        return 0x882B;
    }
    if (strcmp(str, "GL_DRAW_BUFFER6_NV") == 0)
    {
        return 0x882B;
    }
    if (strcmp(str, "GL_DRAW_BUFFER7") == 0)
    {
        return 0x882C;
    }
    if (strcmp(str, "GL_DRAW_BUFFER7_ARB") == 0)
    {
        return 0x882C;
    }
    if (strcmp(str, "GL_DRAW_BUFFER7_ATI") == 0)
    {
        return 0x882C;
    }
    if (strcmp(str, "GL_DRAW_BUFFER7_EXT") == 0)
    {
        return 0x882C;
    }
    if (strcmp(str, "GL_DRAW_BUFFER7_NV") == 0)
    {
        return 0x882C;
    }
    if (strcmp(str, "GL_DRAW_BUFFER8") == 0)
    {
        return 0x882D;
    }
    if (strcmp(str, "GL_DRAW_BUFFER8_ARB") == 0)
    {
        return 0x882D;
    }
    if (strcmp(str, "GL_DRAW_BUFFER8_ATI") == 0)
    {
        return 0x882D;
    }
    if (strcmp(str, "GL_DRAW_BUFFER8_EXT") == 0)
    {
        return 0x882D;
    }
    if (strcmp(str, "GL_DRAW_BUFFER8_NV") == 0)
    {
        return 0x882D;
    }
    if (strcmp(str, "GL_DRAW_BUFFER9") == 0)
    {
        return 0x882E;
    }
    if (strcmp(str, "GL_DRAW_BUFFER9_ARB") == 0)
    {
        return 0x882E;
    }
    if (strcmp(str, "GL_DRAW_BUFFER9_ATI") == 0)
    {
        return 0x882E;
    }
    if (strcmp(str, "GL_DRAW_BUFFER9_EXT") == 0)
    {
        return 0x882E;
    }
    if (strcmp(str, "GL_DRAW_BUFFER9_NV") == 0)
    {
        return 0x882E;
    }
    if (strcmp(str, "GL_DRAW_BUFFER_EXT") == 0)
    {
        return 0x0C01;
    }
    if (strcmp(str, "GL_DRAW_ELEMENTS_COMMAND_NV") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV") == 0)
    {
        return 0x0006;
    }
    if (strcmp(str, "GL_DRAW_ELEMENTS_STRIP_COMMAND_NV") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER") == 0)
    {
        return 0x8CA9;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER_ANGLE") == 0)
    {
        return 0x8CA9;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER_APPLE") == 0)
    {
        return 0x8CA9;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER_BINDING") == 0)
    {
        return 0x8CA6;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER_BINDING_ANGLE") == 0)
    {
        return 0x8CA6;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER_BINDING_APPLE") == 0)
    {
        return 0x8CA6;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER_BINDING_EXT") == 0)
    {
        return 0x8CA6;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER_BINDING_NV") == 0)
    {
        return 0x8CA6;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER_EXT") == 0)
    {
        return 0x8CA9;
    }
    if (strcmp(str, "GL_DRAW_FRAMEBUFFER_NV") == 0)
    {
        return 0x8CA9;
    }
    if (strcmp(str, "GL_DRAW_INDIRECT_ADDRESS_NV") == 0)
    {
        return 0x8F41;
    }
    if (strcmp(str, "GL_DRAW_INDIRECT_BUFFER") == 0)
    {
        return 0x8F3F;
    }
    if (strcmp(str, "GL_DRAW_INDIRECT_BUFFER_BINDING") == 0)
    {
        return 0x8F43;
    }
    if (strcmp(str, "GL_DRAW_INDIRECT_LENGTH_NV") == 0)
    {
        return 0x8F42;
    }
    if (strcmp(str, "GL_DRAW_INDIRECT_UNIFIED_NV") == 0)
    {
        return 0x8F40;
    }
    if (strcmp(str, "GL_DRAW_PIXELS_APPLE") == 0)
    {
        return 0x8A0A;
    }
    if (strcmp(str, "GL_DRAW_PIXEL_TOKEN") == 0)
    {
        return 0x0705;
    }
    if (strcmp(str, "GL_DRIVER_UUID_EXT") == 0)
    {
        return 0x9598;
    }
    if (strcmp(str, "GL_DSDT8_MAG8_INTENSITY8_NV") == 0)
    {
        return 0x870B;
    }
    if (strcmp(str, "GL_DSDT8_MAG8_NV") == 0)
    {
        return 0x870A;
    }
    if (strcmp(str, "GL_DSDT8_NV") == 0)
    {
        return 0x8709;
    }
    if (strcmp(str, "GL_DSDT_MAG_INTENSITY_NV") == 0)
    {
        return 0x86DC;
    }
    if (strcmp(str, "GL_DSDT_MAG_NV") == 0)
    {
        return 0x86F6;
    }
    if (strcmp(str, "GL_DSDT_MAG_VIB_NV") == 0)
    {
        return 0x86F7;
    }
    if (strcmp(str, "GL_DSDT_NV") == 0)
    {
        return 0x86F5;
    }
    if (strcmp(str, "GL_DST_ALPHA") == 0)
    {
        return 0x0304;
    }
    if (strcmp(str, "GL_DST_ATOP_NV") == 0)
    {
        return 0x928F;
    }
    if (strcmp(str, "GL_DST_COLOR") == 0)
    {
        return 0x0306;
    }
    if (strcmp(str, "GL_DST_IN_NV") == 0)
    {
        return 0x928B;
    }
    if (strcmp(str, "GL_DST_NV") == 0)
    {
        return 0x9287;
    }
    if (strcmp(str, "GL_DST_OUT_NV") == 0)
    {
        return 0x928D;
    }
    if (strcmp(str, "GL_DST_OVER_NV") == 0)
    {
        return 0x9289;
    }
    if (strcmp(str, "GL_DS_BIAS_NV") == 0)
    {
        return 0x8716;
    }
    if (strcmp(str, "GL_DS_SCALE_NV") == 0)
    {
        return 0x8710;
    }
    if (strcmp(str, "GL_DT_BIAS_NV") == 0)
    {
        return 0x8717;
    }
    if (strcmp(str, "GL_DT_SCALE_NV") == 0)
    {
        return 0x8711;
    }
    if (strcmp(str, "GL_DU8DV8_ATI") == 0)
    {
        return 0x877A;
    }
    if (strcmp(str, "GL_DUAL_ALPHA12_SGIS") == 0)
    {
        return 0x8112;
    }
    if (strcmp(str, "GL_DUAL_ALPHA16_SGIS") == 0)
    {
        return 0x8113;
    }
    if (strcmp(str, "GL_DUAL_ALPHA4_SGIS") == 0)
    {
        return 0x8110;
    }
    if (strcmp(str, "GL_DUAL_ALPHA8_SGIS") == 0)
    {
        return 0x8111;
    }
    if (strcmp(str, "GL_DUAL_INTENSITY12_SGIS") == 0)
    {
        return 0x811A;
    }
    if (strcmp(str, "GL_DUAL_INTENSITY16_SGIS") == 0)
    {
        return 0x811B;
    }
    if (strcmp(str, "GL_DUAL_INTENSITY4_SGIS") == 0)
    {
        return 0x8118;
    }
    if (strcmp(str, "GL_DUAL_INTENSITY8_SGIS") == 0)
    {
        return 0x8119;
    }
    if (strcmp(str, "GL_DUAL_LUMINANCE12_SGIS") == 0)
    {
        return 0x8116;
    }
    if (strcmp(str, "GL_DUAL_LUMINANCE16_SGIS") == 0)
    {
        return 0x8117;
    }
    if (strcmp(str, "GL_DUAL_LUMINANCE4_SGIS") == 0)
    {
        return 0x8114;
    }
    if (strcmp(str, "GL_DUAL_LUMINANCE8_SGIS") == 0)
    {
        return 0x8115;
    }
    if (strcmp(str, "GL_DUAL_LUMINANCE_ALPHA4_SGIS") == 0)
    {
        return 0x811C;
    }
    if (strcmp(str, "GL_DUAL_LUMINANCE_ALPHA8_SGIS") == 0)
    {
        return 0x811D;
    }
    if (strcmp(str, "GL_DUAL_TEXTURE_SELECT_SGIS") == 0)
    {
        return 0x8124;
    }
    if (strcmp(str, "GL_DUDV_ATI") == 0)
    {
        return 0x8779;
    }
    if (strcmp(str, "GL_DUP_FIRST_CUBIC_CURVE_TO_NV") == 0)
    {
        return 0x00F2;
    }
    if (strcmp(str, "GL_DUP_LAST_CUBIC_CURVE_TO_NV") == 0)
    {
        return 0x00F4;
    }
    if (strcmp(str, "GL_DYNAMIC_ATI") == 0)
    {
        return 0x8761;
    }
    if (strcmp(str, "GL_DYNAMIC_COPY") == 0)
    {
        return 0x88EA;
    }
    if (strcmp(str, "GL_DYNAMIC_COPY_ARB") == 0)
    {
        return 0x88EA;
    }
    if (strcmp(str, "GL_DYNAMIC_DRAW") == 0)
    {
        return 0x88E8;
    }
    if (strcmp(str, "GL_DYNAMIC_DRAW_ARB") == 0)
    {
        return 0x88E8;
    }
    if (strcmp(str, "GL_DYNAMIC_READ") == 0)
    {
        return 0x88E9;
    }
    if (strcmp(str, "GL_DYNAMIC_READ_ARB") == 0)
    {
        return 0x88E9;
    }
    if (strcmp(str, "GL_DYNAMIC_STORAGE_BIT") == 0)
    {
        return 0x0100;
    }
    if (strcmp(str, "GL_DYNAMIC_STORAGE_BIT_EXT") == 0)
    {
        return 0x0100;
    }
    if (strcmp(str, "GL_EDGEFLAG_BIT_PGI") == 0)
    {
        return 0x40000;
    }
    if (strcmp(str, "GL_EDGE_FLAG") == 0)
    {
        return 0x0B43;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY") == 0)
    {
        return 0x8079;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_ADDRESS_NV") == 0)
    {
        return 0x8F26;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING") == 0)
    {
        return 0x889B;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB") == 0)
    {
        return 0x889B;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_COUNT_EXT") == 0)
    {
        return 0x808D;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_EXT") == 0)
    {
        return 0x8079;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_LENGTH_NV") == 0)
    {
        return 0x8F30;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_LIST_IBM") == 0)
    {
        return 0x103075;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM") == 0)
    {
        return 0x103085;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_POINTER") == 0)
    {
        return 0x8093;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_POINTER_EXT") == 0)
    {
        return 0x8093;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_STRIDE") == 0)
    {
        return 0x808C;
    }
    if (strcmp(str, "GL_EDGE_FLAG_ARRAY_STRIDE_EXT") == 0)
    {
        return 0x808C;
    }
    if (strcmp(str, "GL_EFFECTIVE_RASTER_SAMPLES_EXT") == 0)
    {
        return 0x932C;
    }
    if (strcmp(str, "GL_EIGHTH_BIT_ATI") == 0)
    {
        return 0x0020;
    }
    if (strcmp(str, "GL_ELEMENT_ADDRESS_COMMAND_NV") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_ADDRESS_NV") == 0)
    {
        return 0x8F29;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_APPLE") == 0)
    {
        return 0x8A0C;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_ATI") == 0)
    {
        return 0x8768;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_BARRIER_BIT") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_BARRIER_BIT_EXT") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_BUFFER") == 0)
    {
        return 0x8893;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_BUFFER_ARB") == 0)
    {
        return 0x8893;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_BUFFER_BINDING") == 0)
    {
        return 0x8895;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB") == 0)
    {
        return 0x8895;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_LENGTH_NV") == 0)
    {
        return 0x8F33;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_POINTER_APPLE") == 0)
    {
        return 0x8A0E;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_POINTER_ATI") == 0)
    {
        return 0x876A;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_TYPE_APPLE") == 0)
    {
        return 0x8A0D;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_TYPE_ATI") == 0)
    {
        return 0x8769;
    }
    if (strcmp(str, "GL_ELEMENT_ARRAY_UNIFIED_NV") == 0)
    {
        return 0x8F1F;
    }
    if (strcmp(str, "GL_EMBOSS_CONSTANT_NV") == 0)
    {
        return 0x855E;
    }
    if (strcmp(str, "GL_EMBOSS_LIGHT_NV") == 0)
    {
        return 0x855D;
    }
    if (strcmp(str, "GL_EMBOSS_MAP_NV") == 0)
    {
        return 0x855F;
    }
    if (strcmp(str, "GL_EMISSION") == 0)
    {
        return 0x1600;
    }
    if (strcmp(str, "GL_ENABLE_BIT") == 0)
    {
        return 0x2000;
    }
    if (strcmp(str, "GL_EQUAL") == 0)
    {
        return 0x0202;
    }
    if (strcmp(str, "GL_EQUIV") == 0)
    {
        return 0x1509;
    }
    if (strcmp(str, "GL_ETC1_RGB8_OES") == 0)
    {
        return 0x8D64;
    }
    if (strcmp(str, "GL_ETC1_SRGB8_NV") == 0)
    {
        return 0x88EE;
    }
    if (strcmp(str, "GL_EVAL_2D_NV") == 0)
    {
        return 0x86C0;
    }
    if (strcmp(str, "GL_EVAL_BIT") == 0)
    {
        return 0x10000;
    }
    if (strcmp(str, "GL_EVAL_FRACTIONAL_TESSELLATION_NV") == 0)
    {
        return 0x86C5;
    }
    if (strcmp(str, "GL_EVAL_TRIANGULAR_2D_NV") == 0)
    {
        return 0x86C1;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB0_NV") == 0)
    {
        return 0x86C6;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB10_NV") == 0)
    {
        return 0x86D0;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB11_NV") == 0)
    {
        return 0x86D1;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB12_NV") == 0)
    {
        return 0x86D2;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB13_NV") == 0)
    {
        return 0x86D3;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB14_NV") == 0)
    {
        return 0x86D4;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB15_NV") == 0)
    {
        return 0x86D5;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB1_NV") == 0)
    {
        return 0x86C7;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB2_NV") == 0)
    {
        return 0x86C8;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB3_NV") == 0)
    {
        return 0x86C9;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB4_NV") == 0)
    {
        return 0x86CA;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB5_NV") == 0)
    {
        return 0x86CB;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB6_NV") == 0)
    {
        return 0x86CC;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB7_NV") == 0)
    {
        return 0x86CD;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB8_NV") == 0)
    {
        return 0x86CE;
    }
    if (strcmp(str, "GL_EVAL_VERTEX_ATTRIB9_NV") == 0)
    {
        return 0x86CF;
    }
    if (strcmp(str, "GL_EXCLUSION") == 0)
    {
        return 0x92A0;
    }
    if (strcmp(str, "GL_EXCLUSION_KHR") == 0)
    {
        return 0x92A0;
    }
    if (strcmp(str, "GL_EXCLUSION_NV") == 0)
    {
        return 0x92A0;
    }
    if (strcmp(str, "GL_EXCLUSIVE_EXT") == 0)
    {
        return 0x8F11;
    }
    if (strcmp(str, "GL_EXP") == 0)
    {
        return 0x0800;
    }
    if (strcmp(str, "GL_EXP2") == 0)
    {
        return 0x0801;
    }
    if (strcmp(str, "GL_EXPAND_NEGATE_NV") == 0)
    {
        return 0x8539;
    }
    if (strcmp(str, "GL_EXPAND_NORMAL_NV") == 0)
    {
        return 0x8538;
    }
    if (strcmp(str, "GL_EXTENSIONS") == 0)
    {
        return 0x1F03;
    }
    if (strcmp(str, "GL_EXTERNAL_STORAGE_BIT_NVX") == 0)
    {
        return 0x2000;
    }
    if (strcmp(str, "GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD") == 0)
    {
        return 0x9160;
    }
    if (strcmp(str, "GL_EYE_DISTANCE_TO_LINE_SGIS") == 0)
    {
        return 0x81F2;
    }
    if (strcmp(str, "GL_EYE_DISTANCE_TO_POINT_SGIS") == 0)
    {
        return 0x81F0;
    }
    if (strcmp(str, "GL_EYE_LINEAR") == 0)
    {
        return 0x2400;
    }
    if (strcmp(str, "GL_EYE_LINEAR_NV") == 0)
    {
        return 0x2400;
    }
    if (strcmp(str, "GL_EYE_LINE_SGIS") == 0)
    {
        return 0x81F6;
    }
    if (strcmp(str, "GL_EYE_PLANE") == 0)
    {
        return 0x2502;
    }
    if (strcmp(str, "GL_EYE_PLANE_ABSOLUTE_NV") == 0)
    {
        return 0x855C;
    }
    if (strcmp(str, "GL_EYE_POINT_SGIS") == 0)
    {
        return 0x81F4;
    }
    if (strcmp(str, "GL_EYE_RADIAL_NV") == 0)
    {
        return 0x855B;
    }
    if (strcmp(str, "GL_E_TIMES_F_NV") == 0)
    {
        return 0x8531;
    }
    if (strcmp(str, "GL_FACTOR_ALPHA_MODULATE_IMG") == 0)
    {
        return 0x8C07;
    }
    if (strcmp(str, "GL_FACTOR_MAX_AMD") == 0)
    {
        return 0x901D;
    }
    if (strcmp(str, "GL_FACTOR_MIN_AMD") == 0)
    {
        return 0x901C;
    }
    if (strcmp(str, "GL_FAILURE_NV") == 0)
    {
        return 0x9030;
    }
    if (strcmp(str, "GL_FALSE") == 0)
    {
        return 0x0000;
    }
    if (strcmp(str, "GL_FASTEST") == 0)
    {
        return 0x1101;
    }
    if (strcmp(str, "GL_FEEDBACK") == 0)
    {
        return 0x1C01;
    }
    if (strcmp(str, "GL_FEEDBACK_BUFFER_POINTER") == 0)
    {
        return 0x0DF0;
    }
    if (strcmp(str, "GL_FEEDBACK_BUFFER_SIZE") == 0)
    {
        return 0x0DF1;
    }
    if (strcmp(str, "GL_FEEDBACK_BUFFER_TYPE") == 0)
    {
        return 0x0DF2;
    }
    if (strcmp(str, "GL_FENCE_APPLE") == 0)
    {
        return 0x8A0B;
    }
    if (strcmp(str, "GL_FENCE_CONDITION_NV") == 0)
    {
        return 0x84F4;
    }
    if (strcmp(str, "GL_FENCE_STATUS_NV") == 0)
    {
        return 0x84F3;
    }
    if (strcmp(str, "GL_FETCH_PER_SAMPLE_ARM") == 0)
    {
        return 0x8F65;
    }
    if (strcmp(str, "GL_FIELDS_NV") == 0)
    {
        return 0x8E27;
    }
    if (strcmp(str, "GL_FIELD_LOWER_NV") == 0)
    {
        return 0x9023;
    }
    if (strcmp(str, "GL_FIELD_UPPER_NV") == 0)
    {
        return 0x9022;
    }
    if (strcmp(str, "GL_FILE_NAME_NV") == 0)
    {
        return 0x9074;
    }
    if (strcmp(str, "GL_FILL") == 0)
    {
        return 0x1B02;
    }
    if (strcmp(str, "GL_FILL_NV") == 0)
    {
        return 0x1B02;
    }
    if (strcmp(str, "GL_FILL_RECTANGLE_NV") == 0)
    {
        return 0x933C;
    }
    if (strcmp(str, "GL_FILTER") == 0)
    {
        return 0x829A;
    }
    if (strcmp(str, "GL_FILTER4_SGIS") == 0)
    {
        return 0x8146;
    }
    if (strcmp(str, "GL_FIRST_TO_REST_NV") == 0)
    {
        return 0x90AF;
    }
    if (strcmp(str, "GL_FIRST_VERTEX_CONVENTION") == 0)
    {
        return 0x8E4D;
    }
    if (strcmp(str, "GL_FIRST_VERTEX_CONVENTION_ANGLE") == 0)
    {
        return 0x8E4D;
    }
    if (strcmp(str, "GL_FIRST_VERTEX_CONVENTION_EXT") == 0)
    {
        return 0x8E4D;
    }
    if (strcmp(str, "GL_FIRST_VERTEX_CONVENTION_OES") == 0)
    {
        return 0x8E4D;
    }
    if (strcmp(str, "GL_FIXED") == 0)
    {
        return 0x140C;
    }
    if (strcmp(str, "GL_FIXED_OES") == 0)
    {
        return 0x140C;
    }
    if (strcmp(str, "GL_FIXED_ONLY") == 0)
    {
        return 0x891D;
    }
    if (strcmp(str, "GL_FIXED_ONLY_ARB") == 0)
    {
        return 0x891D;
    }
    if (strcmp(str, "GL_FLAT") == 0)
    {
        return 0x1D00;
    }
    if (strcmp(str, "GL_FLOAT") == 0)
    {
        return 0x1406;
    }
    if (strcmp(str, "GL_FLOAT16_MAT2_AMD") == 0)
    {
        return 0x91C5;
    }
    if (strcmp(str, "GL_FLOAT16_MAT2x3_AMD") == 0)
    {
        return 0x91C8;
    }
    if (strcmp(str, "GL_FLOAT16_MAT2x4_AMD") == 0)
    {
        return 0x91C9;
    }
    if (strcmp(str, "GL_FLOAT16_MAT3_AMD") == 0)
    {
        return 0x91C6;
    }
    if (strcmp(str, "GL_FLOAT16_MAT3x2_AMD") == 0)
    {
        return 0x91CA;
    }
    if (strcmp(str, "GL_FLOAT16_MAT3x4_AMD") == 0)
    {
        return 0x91CB;
    }
    if (strcmp(str, "GL_FLOAT16_MAT4_AMD") == 0)
    {
        return 0x91C7;
    }
    if (strcmp(str, "GL_FLOAT16_MAT4x2_AMD") == 0)
    {
        return 0x91CC;
    }
    if (strcmp(str, "GL_FLOAT16_MAT4x3_AMD") == 0)
    {
        return 0x91CD;
    }
    if (strcmp(str, "GL_FLOAT16_NV") == 0)
    {
        return 0x8FF8;
    }
    if (strcmp(str, "GL_FLOAT16_VEC2_NV") == 0)
    {
        return 0x8FF9;
    }
    if (strcmp(str, "GL_FLOAT16_VEC3_NV") == 0)
    {
        return 0x8FFA;
    }
    if (strcmp(str, "GL_FLOAT16_VEC4_NV") == 0)
    {
        return 0x8FFB;
    }
    if (strcmp(str, "GL_FLOAT_32_UNSIGNED_INT_24_8_REV") == 0)
    {
        return 0x8DAD;
    }
    if (strcmp(str, "GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV") == 0)
    {
        return 0x8DAD;
    }
    if (strcmp(str, "GL_FLOAT_CLEAR_COLOR_VALUE_NV") == 0)
    {
        return 0x888D;
    }
    if (strcmp(str, "GL_FLOAT_MAT2") == 0)
    {
        return 0x8B5A;
    }
    if (strcmp(str, "GL_FLOAT_MAT2_ARB") == 0)
    {
        return 0x8B5A;
    }
    if (strcmp(str, "GL_FLOAT_MAT2x3") == 0)
    {
        return 0x8B65;
    }
    if (strcmp(str, "GL_FLOAT_MAT2x3_NV") == 0)
    {
        return 0x8B65;
    }
    if (strcmp(str, "GL_FLOAT_MAT2x4") == 0)
    {
        return 0x8B66;
    }
    if (strcmp(str, "GL_FLOAT_MAT2x4_NV") == 0)
    {
        return 0x8B66;
    }
    if (strcmp(str, "GL_FLOAT_MAT3") == 0)
    {
        return 0x8B5B;
    }
    if (strcmp(str, "GL_FLOAT_MAT3_ARB") == 0)
    {
        return 0x8B5B;
    }
    if (strcmp(str, "GL_FLOAT_MAT3x2") == 0)
    {
        return 0x8B67;
    }
    if (strcmp(str, "GL_FLOAT_MAT3x2_NV") == 0)
    {
        return 0x8B67;
    }
    if (strcmp(str, "GL_FLOAT_MAT3x4") == 0)
    {
        return 0x8B68;
    }
    if (strcmp(str, "GL_FLOAT_MAT3x4_NV") == 0)
    {
        return 0x8B68;
    }
    if (strcmp(str, "GL_FLOAT_MAT4") == 0)
    {
        return 0x8B5C;
    }
    if (strcmp(str, "GL_FLOAT_MAT4_ARB") == 0)
    {
        return 0x8B5C;
    }
    if (strcmp(str, "GL_FLOAT_MAT4x2") == 0)
    {
        return 0x8B69;
    }
    if (strcmp(str, "GL_FLOAT_MAT4x2_NV") == 0)
    {
        return 0x8B69;
    }
    if (strcmp(str, "GL_FLOAT_MAT4x3") == 0)
    {
        return 0x8B6A;
    }
    if (strcmp(str, "GL_FLOAT_MAT4x3_NV") == 0)
    {
        return 0x8B6A;
    }
    if (strcmp(str, "GL_FLOAT_R16_NV") == 0)
    {
        return 0x8884;
    }
    if (strcmp(str, "GL_FLOAT_R32_NV") == 0)
    {
        return 0x8885;
    }
    if (strcmp(str, "GL_FLOAT_RG16_NV") == 0)
    {
        return 0x8886;
    }
    if (strcmp(str, "GL_FLOAT_RG32_NV") == 0)
    {
        return 0x8887;
    }
    if (strcmp(str, "GL_FLOAT_RGB16_NV") == 0)
    {
        return 0x8888;
    }
    if (strcmp(str, "GL_FLOAT_RGB32_NV") == 0)
    {
        return 0x8889;
    }
    if (strcmp(str, "GL_FLOAT_RGBA16_NV") == 0)
    {
        return 0x888A;
    }
    if (strcmp(str, "GL_FLOAT_RGBA32_NV") == 0)
    {
        return 0x888B;
    }
    if (strcmp(str, "GL_FLOAT_RGBA_MODE_NV") == 0)
    {
        return 0x888E;
    }
    if (strcmp(str, "GL_FLOAT_RGBA_NV") == 0)
    {
        return 0x8883;
    }
    if (strcmp(str, "GL_FLOAT_RGB_NV") == 0)
    {
        return 0x8882;
    }
    if (strcmp(str, "GL_FLOAT_RG_NV") == 0)
    {
        return 0x8881;
    }
    if (strcmp(str, "GL_FLOAT_R_NV") == 0)
    {
        return 0x8880;
    }
    if (strcmp(str, "GL_FLOAT_VEC2") == 0)
    {
        return 0x8B50;
    }
    if (strcmp(str, "GL_FLOAT_VEC2_ARB") == 0)
    {
        return 0x8B50;
    }
    if (strcmp(str, "GL_FLOAT_VEC3") == 0)
    {
        return 0x8B51;
    }
    if (strcmp(str, "GL_FLOAT_VEC3_ARB") == 0)
    {
        return 0x8B51;
    }
    if (strcmp(str, "GL_FLOAT_VEC4") == 0)
    {
        return 0x8B52;
    }
    if (strcmp(str, "GL_FLOAT_VEC4_ARB") == 0)
    {
        return 0x8B52;
    }
    if (strcmp(str, "GL_FOG") == 0)
    {
        return 0x0B60;
    }
    if (strcmp(str, "GL_FOG_BIT") == 0)
    {
        return 0x0080;
    }
    if (strcmp(str, "GL_FOG_COLOR") == 0)
    {
        return 0x0B66;
    }
    if (strcmp(str, "GL_FOG_COORD") == 0)
    {
        return 0x8451;
    }
    if (strcmp(str, "GL_FOG_COORDINATE") == 0)
    {
        return 0x8451;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY") == 0)
    {
        return 0x8457;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING") == 0)
    {
        return 0x889D;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB") == 0)
    {
        return 0x889D;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_EXT") == 0)
    {
        return 0x8457;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_LIST_IBM") == 0)
    {
        return 0x103076;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM") == 0)
    {
        return 0x103086;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_POINTER") == 0)
    {
        return 0x8456;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_POINTER_EXT") == 0)
    {
        return 0x8456;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_STRIDE") == 0)
    {
        return 0x8455;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_STRIDE_EXT") == 0)
    {
        return 0x8455;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_TYPE") == 0)
    {
        return 0x8454;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_ARRAY_TYPE_EXT") == 0)
    {
        return 0x8454;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_EXT") == 0)
    {
        return 0x8451;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_SOURCE") == 0)
    {
        return 0x8450;
    }
    if (strcmp(str, "GL_FOG_COORDINATE_SOURCE_EXT") == 0)
    {
        return 0x8450;
    }
    if (strcmp(str, "GL_FOG_COORD_ARRAY") == 0)
    {
        return 0x8457;
    }
    if (strcmp(str, "GL_FOG_COORD_ARRAY_ADDRESS_NV") == 0)
    {
        return 0x8F28;
    }
    if (strcmp(str, "GL_FOG_COORD_ARRAY_BUFFER_BINDING") == 0)
    {
        return 0x889D;
    }
    if (strcmp(str, "GL_FOG_COORD_ARRAY_LENGTH_NV") == 0)
    {
        return 0x8F32;
    }
    if (strcmp(str, "GL_FOG_COORD_ARRAY_POINTER") == 0)
    {
        return 0x8456;
    }
    if (strcmp(str, "GL_FOG_COORD_ARRAY_STRIDE") == 0)
    {
        return 0x8455;
    }
    if (strcmp(str, "GL_FOG_COORD_ARRAY_TYPE") == 0)
    {
        return 0x8454;
    }
    if (strcmp(str, "GL_FOG_COORD_SRC") == 0)
    {
        return 0x8450;
    }
    if (strcmp(str, "GL_FOG_DENSITY") == 0)
    {
        return 0x0B62;
    }
    if (strcmp(str, "GL_FOG_DISTANCE_MODE_NV") == 0)
    {
        return 0x855A;
    }
    if (strcmp(str, "GL_FOG_END") == 0)
    {
        return 0x0B64;
    }
    if (strcmp(str, "GL_FOG_FUNC_POINTS_SGIS") == 0)
    {
        return 0x812B;
    }
    if (strcmp(str, "GL_FOG_FUNC_SGIS") == 0)
    {
        return 0x812A;
    }
    if (strcmp(str, "GL_FOG_HINT") == 0)
    {
        return 0x0C54;
    }
    if (strcmp(str, "GL_FOG_INDEX") == 0)
    {
        return 0x0B61;
    }
    if (strcmp(str, "GL_FOG_MODE") == 0)
    {
        return 0x0B65;
    }
    if (strcmp(str, "GL_FOG_OFFSET_SGIX") == 0)
    {
        return 0x8198;
    }
    if (strcmp(str, "GL_FOG_OFFSET_VALUE_SGIX") == 0)
    {
        return 0x8199;
    }
    if (strcmp(str, "GL_FOG_SPECULAR_TEXTURE_WIN") == 0)
    {
        return 0x80EC;
    }
    if (strcmp(str, "GL_FOG_START") == 0)
    {
        return 0x0B63;
    }
    if (strcmp(str, "GL_FONT_ASCENDER_BIT_NV") == 0)
    {
        return 0x200000;
    }
    if (strcmp(str, "GL_FONT_DESCENDER_BIT_NV") == 0)
    {
        return 0x400000;
    }
    if (strcmp(str, "GL_FONT_GLYPHS_AVAILABLE_NV") == 0)
    {
        return 0x9368;
    }
    if (strcmp(str, "GL_FONT_HAS_KERNING_BIT_NV") == 0)
    {
        return 0x10000000;
    }
    if (strcmp(str, "GL_FONT_HEIGHT_BIT_NV") == 0)
    {
        return 0x800000;
    }
    if (strcmp(str, "GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV") == 0)
    {
        return 0x2000000;
    }
    if (strcmp(str, "GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV") == 0)
    {
        return 0x1000000;
    }
    if (strcmp(str, "GL_FONT_NUM_GLYPH_INDICES_BIT_NV") == 0)
    {
        return 0x20000000;
    }
    if (strcmp(str, "GL_FONT_TARGET_UNAVAILABLE_NV") == 0)
    {
        return 0x9369;
    }
    if (strcmp(str, "GL_FONT_UNAVAILABLE_NV") == 0)
    {
        return 0x936A;
    }
    if (strcmp(str, "GL_FONT_UNDERLINE_POSITION_BIT_NV") == 0)
    {
        return 0x4000000;
    }
    if (strcmp(str, "GL_FONT_UNDERLINE_THICKNESS_BIT_NV") == 0)
    {
        return 0x8000000;
    }
    if (strcmp(str, "GL_FONT_UNINTELLIGIBLE_NV") == 0)
    {
        return 0x936B;
    }
    if (strcmp(str, "GL_FONT_UNITS_PER_EM_BIT_NV") == 0)
    {
        return 0x100000;
    }
    if (strcmp(str, "GL_FONT_X_MAX_BOUNDS_BIT_NV") == 0)
    {
        return 0x40000;
    }
    if (strcmp(str, "GL_FONT_X_MIN_BOUNDS_BIT_NV") == 0)
    {
        return 0x10000;
    }
    if (strcmp(str, "GL_FONT_Y_MAX_BOUNDS_BIT_NV") == 0)
    {
        return 0x80000;
    }
    if (strcmp(str, "GL_FONT_Y_MIN_BOUNDS_BIT_NV") == 0)
    {
        return 0x20000;
    }
    if (strcmp(str, "GL_FORCE_BLUE_TO_ONE_NV") == 0)
    {
        return 0x8860;
    }
    if (strcmp(str, "GL_FORMAT_SUBSAMPLE_244_244_OML") == 0)
    {
        return 0x8983;
    }
    if (strcmp(str, "GL_FORMAT_SUBSAMPLE_24_24_OML") == 0)
    {
        return 0x8982;
    }
    if (strcmp(str, "GL_FOVEATION_ENABLE_BIT_QCOM") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_FOVEATION_SCALED_BIN_METHOD_BIT_QCOM") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_FOVEATION_SUBSAMPLED_LAYOUT_METHOD_BIT_QCOM") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_FRACTIONAL_EVEN") == 0)
    {
        return 0x8E7C;
    }
    if (strcmp(str, "GL_FRACTIONAL_EVEN_EXT") == 0)
    {
        return 0x8E7C;
    }
    if (strcmp(str, "GL_FRACTIONAL_EVEN_OES") == 0)
    {
        return 0x8E7C;
    }
    if (strcmp(str, "GL_FRACTIONAL_ODD") == 0)
    {
        return 0x8E7B;
    }
    if (strcmp(str, "GL_FRACTIONAL_ODD_EXT") == 0)
    {
        return 0x8E7B;
    }
    if (strcmp(str, "GL_FRACTIONAL_ODD_OES") == 0)
    {
        return 0x8E7B;
    }
    if (strcmp(str, "GL_FRAGMENTS_INSTRUMENT_COUNTERS_SGIX") == 0)
    {
        return 0x8314;
    }
    if (strcmp(str, "GL_FRAGMENTS_INSTRUMENT_MAX_SGIX") == 0)
    {
        return 0x8315;
    }
    if (strcmp(str, "GL_FRAGMENTS_INSTRUMENT_SGIX") == 0)
    {
        return 0x8313;
    }
    if (strcmp(str, "GL_FRAGMENT_ALPHA_MODULATE_IMG") == 0)
    {
        return 0x8C08;
    }
    if (strcmp(str, "GL_FRAGMENT_COLOR_EXT") == 0)
    {
        return 0x834C;
    }
    if (strcmp(str, "GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX") == 0)
    {
        return 0x8402;
    }
    if (strcmp(str, "GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX") == 0)
    {
        return 0x8403;
    }
    if (strcmp(str, "GL_FRAGMENT_COLOR_MATERIAL_SGIX") == 0)
    {
        return 0x8401;
    }
    if (strcmp(str, "GL_FRAGMENT_COVERAGE_COLOR_NV") == 0)
    {
        return 0x92DE;
    }
    if (strcmp(str, "GL_FRAGMENT_COVERAGE_TO_COLOR_NV") == 0)
    {
        return 0x92DD;
    }
    if (strcmp(str, "GL_FRAGMENT_DEPTH") == 0)
    {
        return 0x8452;
    }
    if (strcmp(str, "GL_FRAGMENT_DEPTH_EXT") == 0)
    {
        return 0x8452;
    }
    if (strcmp(str, "GL_FRAGMENT_INPUT_NV") == 0)
    {
        return 0x936D;
    }
    if (strcmp(str, "GL_FRAGMENT_INTERPOLATION_OFFSET_BITS") == 0)
    {
        return 0x8E5D;
    }
    if (strcmp(str, "GL_FRAGMENT_INTERPOLATION_OFFSET_BITS_OES") == 0)
    {
        return 0x8E5D;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT0_SGIX") == 0)
    {
        return 0x840C;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT1_SGIX") == 0)
    {
        return 0x840D;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT2_SGIX") == 0)
    {
        return 0x840E;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT3_SGIX") == 0)
    {
        return 0x840F;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT4_SGIX") == 0)
    {
        return 0x8410;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT5_SGIX") == 0)
    {
        return 0x8411;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT6_SGIX") == 0)
    {
        return 0x8412;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT7_SGIX") == 0)
    {
        return 0x8413;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHTING_SGIX") == 0)
    {
        return 0x8400;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX") == 0)
    {
        return 0x840A;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX") == 0)
    {
        return 0x8408;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX") == 0)
    {
        return 0x840B;
    }
    if (strcmp(str, "GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX") == 0)
    {
        return 0x8409;
    }
    if (strcmp(str, "GL_FRAGMENT_MATERIAL_EXT") == 0)
    {
        return 0x8349;
    }
    if (strcmp(str, "GL_FRAGMENT_NORMAL_EXT") == 0)
    {
        return 0x834A;
    }
    if (strcmp(str, "GL_FRAGMENT_PROGRAM_ARB") == 0)
    {
        return 0x8804;
    }
    if (strcmp(str, "GL_FRAGMENT_PROGRAM_BINDING_NV") == 0)
    {
        return 0x8873;
    }
    if (strcmp(str, "GL_FRAGMENT_PROGRAM_CALLBACK_DATA_MESA") == 0)
    {
        return 0x8BB3;
    }
    if (strcmp(str, "GL_FRAGMENT_PROGRAM_CALLBACK_FUNC_MESA") == 0)
    {
        return 0x8BB2;
    }
    if (strcmp(str, "GL_FRAGMENT_PROGRAM_CALLBACK_MESA") == 0)
    {
        return 0x8BB1;
    }
    if (strcmp(str, "GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV") == 0)
    {
        return 0x8E5D;
    }
    if (strcmp(str, "GL_FRAGMENT_PROGRAM_NV") == 0)
    {
        return 0x8870;
    }
    if (strcmp(str, "GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV") == 0)
    {
        return 0x8DA4;
    }
    if (strcmp(str, "GL_FRAGMENT_PROGRAM_POSITION_MESA") == 0)
    {
        return 0x8BB0;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER") == 0)
    {
        return 0x8B30;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_ARB") == 0)
    {
        return 0x8B30;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_ATI") == 0)
    {
        return 0x8920;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_BIT") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_BIT_EXT") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_DERIVATIVE_HINT") == 0)
    {
        return 0x8B8B;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB") == 0)
    {
        return 0x8B8B;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES") == 0)
    {
        return 0x8B8B;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT") == 0)
    {
        return 0x8A52;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM") == 0)
    {
        return 0x8F66;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_INVOCATIONS") == 0)
    {
        return 0x82F4;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADER_INVOCATIONS_ARB") == 0)
    {
        return 0x82F4;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADING_RATE_ATTACHMENT_WITH_DEFAULT_FRAMEBUFFER_SUPPORTED_EXT") ==
        0)
    {
        return 0x96DF;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_EXT") == 0)
    {
        return 0x96D2;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_EXT") == 0)
    {
        return 0x96D5;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_EXT") == 0)
    {
        return 0x96D4;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_EXT") == 0)
    {
        return 0x96D6;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_EXT") == 0)
    {
        return 0x96D3;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADING_RATE_NON_TRIVIAL_COMBINERS_SUPPORTED_EXT") == 0)
    {
        return 0x8F6F;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADING_RATE_WITH_SAMPLE_MASK_SUPPORTED_EXT") == 0)
    {
        return 0x96DE;
    }
    if (strcmp(str, "GL_FRAGMENT_SHADING_RATE_WITH_SHADER_DEPTH_STENCIL_WRITES_SUPPORTED_EXT") == 0)
    {
        return 0x96DD;
    }
    if (strcmp(str, "GL_FRAGMENT_SUBROUTINE") == 0)
    {
        return 0x92EC;
    }
    if (strcmp(str, "GL_FRAGMENT_SUBROUTINE_UNIFORM") == 0)
    {
        return 0x92F2;
    }
    if (strcmp(str, "GL_FRAGMENT_TEXTURE") == 0)
    {
        return 0x829F;
    }
    if (strcmp(str, "GL_FRAMEBUFFER") == 0)
    {
        return 0x8D40;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE") == 0)
    {
        return 0x8215;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_ANGLE") == 0)
    {
        return 0x93A3;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE") == 0)
    {
        return 0x8214;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING") == 0)
    {
        return 0x8210;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT") == 0)
    {
        return 0x8210;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE") == 0)
    {
        return 0x8211;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT") == 0)
    {
        return 0x8211;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE") == 0)
    {
        return 0x8216;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE") == 0)
    {
        return 0x8213;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_LAYERED") == 0)
    {
        return 0x8DA7;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB") == 0)
    {
        return 0x8DA7;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT") == 0)
    {
        return 0x8DA7;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_OES") == 0)
    {
        return 0x8DA7;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME") == 0)
    {
        return 0x8CD1;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT") == 0)
    {
        return 0x8CD1;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES") == 0)
    {
        return 0x8CD1;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE") == 0)
    {
        return 0x8CD0;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT") == 0)
    {
        return 0x8CD0;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES") == 0)
    {
        return 0x8CD0;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE") == 0)
    {
        return 0x8212;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE") == 0)
    {
        return 0x8217;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT") == 0)
    {
        return 0x8CD4;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES") == 0)
    {
        return 0x8CD4;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR") == 0)
    {
        return 0x9632;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE") == 0)
    {
        return 0x8CD3;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT") == 0)
    {
        return 0x8CD3;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES") == 0)
    {
        return 0x8CD3;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER") == 0)
    {
        return 0x8CD4;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT") == 0)
    {
        return 0x8CD4;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL") == 0)
    {
        return 0x8CD2;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT") == 0)
    {
        return 0x8CD2;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES") == 0)
    {
        return 0x8CD2;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR") == 0)
    {
        return 0x9630;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT") == 0)
    {
        return 0x8D6C;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SCALE_IMG") == 0)
    {
        return 0x913F;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_BARRIER_BIT") == 0)
    {
        return 0x0400;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_BARRIER_BIT_EXT") == 0)
    {
        return 0x0400;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_BINDING") == 0)
    {
        return 0x8CA6;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_BINDING_ANGLE") == 0)
    {
        return 0x8CA6;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_BINDING_EXT") == 0)
    {
        return 0x8CA6;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_BINDING_OES") == 0)
    {
        return 0x8CA6;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_BLEND") == 0)
    {
        return 0x828B;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_COMPLETE") == 0)
    {
        return 0x8CD5;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_COMPLETE_EXT") == 0)
    {
        return 0x8CD5;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_COMPLETE_OES") == 0)
    {
        return 0x8CD5;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_DEFAULT") == 0)
    {
        return 0x8218;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS") == 0)
    {
        return 0x9314;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_DEFAULT_HEIGHT") == 0)
    {
        return 0x9311;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_DEFAULT_LAYERS") == 0)
    {
        return 0x9312;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_DEFAULT_LAYERS_EXT") == 0)
    {
        return 0x9312;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_DEFAULT_LAYERS_OES") == 0)
    {
        return 0x9312;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_DEFAULT_SAMPLES") == 0)
    {
        return 0x9313;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_DEFAULT_WIDTH") == 0)
    {
        return 0x9310;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_EXT") == 0)
    {
        return 0x8D40;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_FETCH_NONCOHERENT_QCOM") == 0)
    {
        return 0x96A2;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_FLIP_X_MESA") == 0)
    {
        return 0x8BBC;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_FLIP_Y_MESA") == 0)
    {
        return 0x8BBB;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT") == 0)
    {
        return 0x8CD6;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT") == 0)
    {
        return 0x8CD6;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES") == 0)
    {
        return 0x8CD6;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS") == 0)
    {
        return 0x8CD9;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT") == 0)
    {
        return 0x8CD9;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES") == 0)
    {
        return 0x8CD9;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER") == 0)
    {
        return 0x8CDB;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT") == 0)
    {
        return 0x8CDB;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_OES") == 0)
    {
        return 0x8CDB;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT") == 0)
    {
        return 0x8CDA;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES") == 0)
    {
        return 0x8CDA;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_FOVEATION_QCOM") == 0)
    {
        return 0x8BFF;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_INSUFFICIENT_SHADER_COMBINED_LOCAL_STORAGE_EXT") ==
        0)
    {
        return 0x9652;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB") == 0)
    {
        return 0x8DA9;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT") == 0)
    {
        return 0x8DA9;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS") == 0)
    {
        return 0x8DA8;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB") == 0)
    {
        return 0x8DA8;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT") == 0)
    {
        return 0x8DA8;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_OES") == 0)
    {
        return 0x8DA8;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT") == 0)
    {
        return 0x8CD7;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT") == 0)
    {
        return 0x8CD7;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES") == 0)
    {
        return 0x8CD7;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE") == 0)
    {
        return 0x8D56;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_AND_DOWNSAMPLE_IMG") == 0)
    {
        return 0x913C;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE") == 0)
    {
        return 0x8D56;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE") == 0)
    {
        return 0x8D56;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT") == 0)
    {
        return 0x8D56;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG") == 0)
    {
        return 0x9134;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV") == 0)
    {
        return 0x8D56;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER") == 0)
    {
        return 0x8CDC;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT") == 0)
    {
        return 0x8CDC;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_OES") == 0)
    {
        return 0x8CDC;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR") == 0)
    {
        return 0x9633;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_OES") == 0)
    {
        return 0x8D40;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB") == 0)
    {
        return 0x9342;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV") == 0)
    {
        return 0x9342;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_RENDERABLE") == 0)
    {
        return 0x8289;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_RENDERABLE_LAYERED") == 0)
    {
        return 0x828A;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB") == 0)
    {
        return 0x9343;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV") == 0)
    {
        return 0x9343;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_SRGB") == 0)
    {
        return 0x8DB9;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_SRGB_CAPABLE_EXT") == 0)
    {
        return 0x8DBA;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_SRGB_EXT") == 0)
    {
        return 0x8DB9;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_SWAP_XY_MESA") == 0)
    {
        return 0x8BBD;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_UNDEFINED") == 0)
    {
        return 0x8219;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_UNDEFINED_OES") == 0)
    {
        return 0x8219;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_UNSUPPORTED") == 0)
    {
        return 0x8CDD;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_UNSUPPORTED_EXT") == 0)
    {
        return 0x8CDD;
    }
    if (strcmp(str, "GL_FRAMEBUFFER_UNSUPPORTED_OES") == 0)
    {
        return 0x8CDD;
    }
    if (strcmp(str, "GL_FRAMEZOOM_FACTOR_SGIX") == 0)
    {
        return 0x818C;
    }
    if (strcmp(str, "GL_FRAMEZOOM_SGIX") == 0)
    {
        return 0x818B;
    }
    if (strcmp(str, "GL_FRAME_NV") == 0)
    {
        return 0x8E26;
    }
    if (strcmp(str, "GL_FRONT") == 0)
    {
        return 0x0404;
    }
    if (strcmp(str, "GL_FRONT_AND_BACK") == 0)
    {
        return 0x0408;
    }
    if (strcmp(str, "GL_FRONT_FACE") == 0)
    {
        return 0x0B46;
    }
    if (strcmp(str, "GL_FRONT_FACE_COMMAND_NV") == 0)
    {
        return 0x0012;
    }
    if (strcmp(str, "GL_FRONT_LEFT") == 0)
    {
        return 0x0400;
    }
    if (strcmp(str, "GL_FRONT_RIGHT") == 0)
    {
        return 0x0401;
    }
    if (strcmp(str, "GL_FULL_RANGE_EXT") == 0)
    {
        return 0x87E1;
    }
    if (strcmp(str, "GL_FULL_STIPPLE_HINT_PGI") == 0)
    {
        return 0x1A219;
    }
    if (strcmp(str, "GL_FULL_SUPPORT") == 0)
    {
        return 0x82B7;
    }
    if (strcmp(str, "GL_FUNC_ADD") == 0)
    {
        return 0x8006;
    }
    if (strcmp(str, "GL_FUNC_ADD_EXT") == 0)
    {
        return 0x8006;
    }
    if (strcmp(str, "GL_FUNC_ADD_OES") == 0)
    {
        return 0x8006;
    }
    if (strcmp(str, "GL_FUNC_REVERSE_SUBTRACT") == 0)
    {
        return 0x800B;
    }
    if (strcmp(str, "GL_FUNC_REVERSE_SUBTRACT_EXT") == 0)
    {
        return 0x800B;
    }
    if (strcmp(str, "GL_FUNC_REVERSE_SUBTRACT_OES") == 0)
    {
        return 0x800B;
    }
    if (strcmp(str, "GL_FUNC_SUBTRACT") == 0)
    {
        return 0x800A;
    }
    if (strcmp(str, "GL_FUNC_SUBTRACT_EXT") == 0)
    {
        return 0x800A;
    }
    if (strcmp(str, "GL_FUNC_SUBTRACT_OES") == 0)
    {
        return 0x800A;
    }
    if (strcmp(str, "GL_GCCSO_SHADER_BINARY_FJ") == 0)
    {
        return 0x9260;
    }
    if (strcmp(str, "GL_GENERATE_MIPMAP") == 0)
    {
        return 0x8191;
    }
    if (strcmp(str, "GL_GENERATE_MIPMAP_HINT") == 0)
    {
        return 0x8192;
    }
    if (strcmp(str, "GL_GENERATE_MIPMAP_HINT_SGIS") == 0)
    {
        return 0x8192;
    }
    if (strcmp(str, "GL_GENERATE_MIPMAP_SGIS") == 0)
    {
        return 0x8191;
    }
    if (strcmp(str, "GL_GENERIC_ATTRIB_NV") == 0)
    {
        return 0x8C7D;
    }
    if (strcmp(str, "GL_GEOMETRY_DEFORMATION_BIT_SGIX") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_GEOMETRY_DEFORMATION_SGIX") == 0)
    {
        return 0x8194;
    }
    if (strcmp(str, "GL_GEOMETRY_INPUT_TYPE") == 0)
    {
        return 0x8917;
    }
    if (strcmp(str, "GL_GEOMETRY_INPUT_TYPE_ARB") == 0)
    {
        return 0x8DDB;
    }
    if (strcmp(str, "GL_GEOMETRY_INPUT_TYPE_EXT") == 0)
    {
        return 0x8DDB;
    }
    if (strcmp(str, "GL_GEOMETRY_LINKED_INPUT_TYPE_EXT") == 0)
    {
        return 0x8917;
    }
    if (strcmp(str, "GL_GEOMETRY_LINKED_INPUT_TYPE_OES") == 0)
    {
        return 0x8917;
    }
    if (strcmp(str, "GL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT") == 0)
    {
        return 0x8918;
    }
    if (strcmp(str, "GL_GEOMETRY_LINKED_OUTPUT_TYPE_OES") == 0)
    {
        return 0x8918;
    }
    if (strcmp(str, "GL_GEOMETRY_LINKED_VERTICES_OUT_EXT") == 0)
    {
        return 0x8916;
    }
    if (strcmp(str, "GL_GEOMETRY_LINKED_VERTICES_OUT_OES") == 0)
    {
        return 0x8916;
    }
    if (strcmp(str, "GL_GEOMETRY_OUTPUT_TYPE") == 0)
    {
        return 0x8918;
    }
    if (strcmp(str, "GL_GEOMETRY_OUTPUT_TYPE_ARB") == 0)
    {
        return 0x8DDC;
    }
    if (strcmp(str, "GL_GEOMETRY_OUTPUT_TYPE_EXT") == 0)
    {
        return 0x8DDC;
    }
    if (strcmp(str, "GL_GEOMETRY_PROGRAM_NV") == 0)
    {
        return 0x8C26;
    }
    if (strcmp(str, "GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV") == 0)
    {
        return 0x8DA3;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER") == 0)
    {
        return 0x8DD9;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_ARB") == 0)
    {
        return 0x8DD9;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_BIT") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_BIT_EXT") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_BIT_OES") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_EXT") == 0)
    {
        return 0x8DD9;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_INVOCATIONS") == 0)
    {
        return 0x887F;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_INVOCATIONS_EXT") == 0)
    {
        return 0x887F;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_INVOCATIONS_OES") == 0)
    {
        return 0x887F;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_OES") == 0)
    {
        return 0x8DD9;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED") == 0)
    {
        return 0x82F3;
    }
    if (strcmp(str, "GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB") == 0)
    {
        return 0x82F3;
    }
    if (strcmp(str, "GL_GEOMETRY_SUBROUTINE") == 0)
    {
        return 0x92EB;
    }
    if (strcmp(str, "GL_GEOMETRY_SUBROUTINE_UNIFORM") == 0)
    {
        return 0x92F1;
    }
    if (strcmp(str, "GL_GEOMETRY_TEXTURE") == 0)
    {
        return 0x829E;
    }
    if (strcmp(str, "GL_GEOMETRY_VERTICES_OUT") == 0)
    {
        return 0x8916;
    }
    if (strcmp(str, "GL_GEOMETRY_VERTICES_OUT_ARB") == 0)
    {
        return 0x8DDA;
    }
    if (strcmp(str, "GL_GEOMETRY_VERTICES_OUT_EXT") == 0)
    {
        return 0x8DDA;
    }
    if (strcmp(str, "GL_GEQUAL") == 0)
    {
        return 0x0206;
    }
    if (strcmp(str, "GL_GET_TEXTURE_IMAGE_FORMAT") == 0)
    {
        return 0x8291;
    }
    if (strcmp(str, "GL_GET_TEXTURE_IMAGE_TYPE") == 0)
    {
        return 0x8292;
    }
    if (strcmp(str, "GL_GLOBAL_ALPHA_FACTOR_SUN") == 0)
    {
        return 0x81DA;
    }
    if (strcmp(str, "GL_GLOBAL_ALPHA_SUN") == 0)
    {
        return 0x81D9;
    }
    if (strcmp(str, "GL_GLYPH_HAS_KERNING_BIT_NV") == 0)
    {
        return 0x0100;
    }
    if (strcmp(str, "GL_GLYPH_HEIGHT_BIT_NV") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV") == 0)
    {
        return 0x0010;
    }
    if (strcmp(str, "GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV") == 0)
    {
        return 0x0080;
    }
    if (strcmp(str, "GL_GLYPH_VERTICAL_BEARING_X_BIT_NV") == 0)
    {
        return 0x0020;
    }
    if (strcmp(str, "GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV") == 0)
    {
        return 0x0040;
    }
    if (strcmp(str, "GL_GLYPH_WIDTH_BIT_NV") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_GPU_ADDRESS_NV") == 0)
    {
        return 0x8F34;
    }
    if (strcmp(str, "GL_GPU_DISJOINT_EXT") == 0)
    {
        return 0x8FBB;
    }
    if (strcmp(str, "GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX") == 0)
    {
        return 0x9049;
    }
    if (strcmp(str, "GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX") == 0)
    {
        return 0x9047;
    }
    if (strcmp(str, "GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX") == 0)
    {
        return 0x904B;
    }
    if (strcmp(str, "GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX") == 0)
    {
        return 0x904A;
    }
    if (strcmp(str, "GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX") == 0)
    {
        return 0x9048;
    }
    if (strcmp(str, "GL_GPU_OPTIMIZED_QCOM") == 0)
    {
        return 0x8FB2;
    }
    if (strcmp(str, "GL_GREATER") == 0)
    {
        return 0x0204;
    }
    if (strcmp(str, "GL_GREEN") == 0)
    {
        return 0x1904;
    }
    if (strcmp(str, "GL_GREEN_BIAS") == 0)
    {
        return 0x0D19;
    }
    if (strcmp(str, "GL_GREEN_BITS") == 0)
    {
        return 0x0D53;
    }
    if (strcmp(str, "GL_GREEN_BIT_ATI") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_GREEN_INTEGER") == 0)
    {
        return 0x8D95;
    }
    if (strcmp(str, "GL_GREEN_INTEGER_EXT") == 0)
    {
        return 0x8D95;
    }
    if (strcmp(str, "GL_GREEN_MAX_CLAMP_INGR") == 0)
    {
        return 0x8565;
    }
    if (strcmp(str, "GL_GREEN_MIN_CLAMP_INGR") == 0)
    {
        return 0x8561;
    }
    if (strcmp(str, "GL_GREEN_NV") == 0)
    {
        return 0x1904;
    }
    if (strcmp(str, "GL_GREEN_SCALE") == 0)
    {
        return 0x0D18;
    }
    if (strcmp(str, "GL_GS_PROGRAM_BINARY_MTK") == 0)
    {
        return 0x9641;
    }
    if (strcmp(str, "GL_GS_SHADER_BINARY_MTK") == 0)
    {
        return 0x9640;
    }
    if (strcmp(str, "GL_GUILTY_CONTEXT_RESET") == 0)
    {
        return 0x8253;
    }
    if (strcmp(str, "GL_GUILTY_CONTEXT_RESET_ARB") == 0)
    {
        return 0x8253;
    }
    if (strcmp(str, "GL_GUILTY_CONTEXT_RESET_EXT") == 0)
    {
        return 0x8253;
    }
    if (strcmp(str, "GL_GUILTY_CONTEXT_RESET_KHR") == 0)
    {
        return 0x8253;
    }
    if (strcmp(str, "GL_HALF_APPLE") == 0)
    {
        return 0x140B;
    }
    if (strcmp(str, "GL_HALF_BIAS_NEGATE_NV") == 0)
    {
        return 0x853B;
    }
    if (strcmp(str, "GL_HALF_BIAS_NORMAL_NV") == 0)
    {
        return 0x853A;
    }
    if (strcmp(str, "GL_HALF_BIT_ATI") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_HALF_FLOAT") == 0)
    {
        return 0x140B;
    }
    if (strcmp(str, "GL_HALF_FLOAT_ARB") == 0)
    {
        return 0x140B;
    }
    if (strcmp(str, "GL_HALF_FLOAT_NV") == 0)
    {
        return 0x140B;
    }
    if (strcmp(str, "GL_HALF_FLOAT_OES") == 0)
    {
        return 0x8D61;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_D3D11_IMAGE_EXT") == 0)
    {
        return 0x958B;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT") == 0)
    {
        return 0x958C;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_D3D12_FENCE_EXT") == 0)
    {
        return 0x9594;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_D3D12_RESOURCE_EXT") == 0)
    {
        return 0x958A;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT") == 0)
    {
        return 0x9589;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_OPAQUE_FD_EXT") == 0)
    {
        return 0x9586;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_OPAQUE_WIN32_EXT") == 0)
    {
        return 0x9587;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT") == 0)
    {
        return 0x9588;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_ZIRCON_EVENT_ANGLE") == 0)
    {
        return 0x93AF;
    }
    if (strcmp(str, "GL_HANDLE_TYPE_ZIRCON_VMO_ANGLE") == 0)
    {
        return 0x93AE;
    }
    if (strcmp(str, "GL_HARDLIGHT") == 0)
    {
        return 0x929B;
    }
    if (strcmp(str, "GL_HARDLIGHT_KHR") == 0)
    {
        return 0x929B;
    }
    if (strcmp(str, "GL_HARDLIGHT_NV") == 0)
    {
        return 0x929B;
    }
    if (strcmp(str, "GL_HARDMIX_NV") == 0)
    {
        return 0x92A9;
    }
    if (strcmp(str, "GL_HIGH_FLOAT") == 0)
    {
        return 0x8DF2;
    }
    if (strcmp(str, "GL_HIGH_INT") == 0)
    {
        return 0x8DF5;
    }
    if (strcmp(str, "GL_HILO16_NV") == 0)
    {
        return 0x86F8;
    }
    if (strcmp(str, "GL_HILO8_NV") == 0)
    {
        return 0x885E;
    }
    if (strcmp(str, "GL_HILO_NV") == 0)
    {
        return 0x86F4;
    }
    if (strcmp(str, "GL_HINT_BIT") == 0)
    {
        return 0x8000;
    }
    if (strcmp(str, "GL_HISTOGRAM") == 0)
    {
        return 0x8024;
    }
    if (strcmp(str, "GL_HISTOGRAM_ALPHA_SIZE") == 0)
    {
        return 0x802B;
    }
    if (strcmp(str, "GL_HISTOGRAM_ALPHA_SIZE_EXT") == 0)
    {
        return 0x802B;
    }
    if (strcmp(str, "GL_HISTOGRAM_BLUE_SIZE") == 0)
    {
        return 0x802A;
    }
    if (strcmp(str, "GL_HISTOGRAM_BLUE_SIZE_EXT") == 0)
    {
        return 0x802A;
    }
    if (strcmp(str, "GL_HISTOGRAM_EXT") == 0)
    {
        return 0x8024;
    }
    if (strcmp(str, "GL_HISTOGRAM_FORMAT") == 0)
    {
        return 0x8027;
    }
    if (strcmp(str, "GL_HISTOGRAM_FORMAT_EXT") == 0)
    {
        return 0x8027;
    }
    if (strcmp(str, "GL_HISTOGRAM_GREEN_SIZE") == 0)
    {
        return 0x8029;
    }
    if (strcmp(str, "GL_HISTOGRAM_GREEN_SIZE_EXT") == 0)
    {
        return 0x8029;
    }
    if (strcmp(str, "GL_HISTOGRAM_LUMINANCE_SIZE") == 0)
    {
        return 0x802C;
    }
    if (strcmp(str, "GL_HISTOGRAM_LUMINANCE_SIZE_EXT") == 0)
    {
        return 0x802C;
    }
    if (strcmp(str, "GL_HISTOGRAM_RED_SIZE") == 0)
    {
        return 0x8028;
    }
    if (strcmp(str, "GL_HISTOGRAM_RED_SIZE_EXT") == 0)
    {
        return 0x8028;
    }
    if (strcmp(str, "GL_HISTOGRAM_SINK") == 0)
    {
        return 0x802D;
    }
    if (strcmp(str, "GL_HISTOGRAM_SINK_EXT") == 0)
    {
        return 0x802D;
    }
    if (strcmp(str, "GL_HISTOGRAM_WIDTH") == 0)
    {
        return 0x8026;
    }
    if (strcmp(str, "GL_HISTOGRAM_WIDTH_EXT") == 0)
    {
        return 0x8026;
    }
    if (strcmp(str, "GL_HI_BIAS_NV") == 0)
    {
        return 0x8714;
    }
    if (strcmp(str, "GL_HI_SCALE_NV") == 0)
    {
        return 0x870E;
    }
    if (strcmp(str, "GL_HORIZONTAL_LINE_TO_NV") == 0)
    {
        return 0x0006;
    }
    if (strcmp(str, "GL_HSL_COLOR") == 0)
    {
        return 0x92AF;
    }
    if (strcmp(str, "GL_HSL_COLOR_KHR") == 0)
    {
        return 0x92AF;
    }
    if (strcmp(str, "GL_HSL_COLOR_NV") == 0)
    {
        return 0x92AF;
    }
    if (strcmp(str, "GL_HSL_HUE") == 0)
    {
        return 0x92AD;
    }
    if (strcmp(str, "GL_HSL_HUE_KHR") == 0)
    {
        return 0x92AD;
    }
    if (strcmp(str, "GL_HSL_HUE_NV") == 0)
    {
        return 0x92AD;
    }
    if (strcmp(str, "GL_HSL_LUMINOSITY") == 0)
    {
        return 0x92B0;
    }
    if (strcmp(str, "GL_HSL_LUMINOSITY_KHR") == 0)
    {
        return 0x92B0;
    }
    if (strcmp(str, "GL_HSL_LUMINOSITY_NV") == 0)
    {
        return 0x92B0;
    }
    if (strcmp(str, "GL_HSL_SATURATION") == 0)
    {
        return 0x92AE;
    }
    if (strcmp(str, "GL_HSL_SATURATION_KHR") == 0)
    {
        return 0x92AE;
    }
    if (strcmp(str, "GL_HSL_SATURATION_NV") == 0)
    {
        return 0x92AE;
    }
    if (strcmp(str, "GL_IDENTITY_NV") == 0)
    {
        return 0x862A;
    }
    if (strcmp(str, "GL_IGNORE_BORDER_HP") == 0)
    {
        return 0x8150;
    }
    if (strcmp(str, "GL_IMAGE_1D") == 0)
    {
        return 0x904C;
    }
    if (strcmp(str, "GL_IMAGE_1D_ARRAY") == 0)
    {
        return 0x9052;
    }
    if (strcmp(str, "GL_IMAGE_1D_ARRAY_EXT") == 0)
    {
        return 0x9052;
    }
    if (strcmp(str, "GL_IMAGE_1D_EXT") == 0)
    {
        return 0x904C;
    }
    if (strcmp(str, "GL_IMAGE_2D") == 0)
    {
        return 0x904D;
    }
    if (strcmp(str, "GL_IMAGE_2D_ARRAY") == 0)
    {
        return 0x9053;
    }
    if (strcmp(str, "GL_IMAGE_2D_ARRAY_EXT") == 0)
    {
        return 0x9053;
    }
    if (strcmp(str, "GL_IMAGE_2D_EXT") == 0)
    {
        return 0x904D;
    }
    if (strcmp(str, "GL_IMAGE_2D_MULTISAMPLE") == 0)
    {
        return 0x9055;
    }
    if (strcmp(str, "GL_IMAGE_2D_MULTISAMPLE_ARRAY") == 0)
    {
        return 0x9056;
    }
    if (strcmp(str, "GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT") == 0)
    {
        return 0x9056;
    }
    if (strcmp(str, "GL_IMAGE_2D_MULTISAMPLE_EXT") == 0)
    {
        return 0x9055;
    }
    if (strcmp(str, "GL_IMAGE_2D_RECT") == 0)
    {
        return 0x904F;
    }
    if (strcmp(str, "GL_IMAGE_2D_RECT_EXT") == 0)
    {
        return 0x904F;
    }
    if (strcmp(str, "GL_IMAGE_3D") == 0)
    {
        return 0x904E;
    }
    if (strcmp(str, "GL_IMAGE_3D_EXT") == 0)
    {
        return 0x904E;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_ACCESS") == 0)
    {
        return 0x8F3E;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_ACCESS_EXT") == 0)
    {
        return 0x8F3E;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_FORMAT") == 0)
    {
        return 0x906E;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_FORMAT_EXT") == 0)
    {
        return 0x906E;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_LAYER") == 0)
    {
        return 0x8F3D;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_LAYERED") == 0)
    {
        return 0x8F3C;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_LAYERED_EXT") == 0)
    {
        return 0x8F3C;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_LAYER_EXT") == 0)
    {
        return 0x8F3D;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_LEVEL") == 0)
    {
        return 0x8F3B;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_LEVEL_EXT") == 0)
    {
        return 0x8F3B;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_NAME") == 0)
    {
        return 0x8F3A;
    }
    if (strcmp(str, "GL_IMAGE_BINDING_NAME_EXT") == 0)
    {
        return 0x8F3A;
    }
    if (strcmp(str, "GL_IMAGE_BUFFER") == 0)
    {
        return 0x9051;
    }
    if (strcmp(str, "GL_IMAGE_BUFFER_EXT") == 0)
    {
        return 0x9051;
    }
    if (strcmp(str, "GL_IMAGE_BUFFER_OES") == 0)
    {
        return 0x9051;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_10_10_10_2") == 0)
    {
        return 0x82C3;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_11_11_10") == 0)
    {
        return 0x82C2;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_1_X_16") == 0)
    {
        return 0x82BE;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_1_X_32") == 0)
    {
        return 0x82BB;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_1_X_8") == 0)
    {
        return 0x82C1;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_2_X_16") == 0)
    {
        return 0x82BD;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_2_X_32") == 0)
    {
        return 0x82BA;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_2_X_8") == 0)
    {
        return 0x82C0;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_4_X_16") == 0)
    {
        return 0x82BC;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_4_X_32") == 0)
    {
        return 0x82B9;
    }
    if (strcmp(str, "GL_IMAGE_CLASS_4_X_8") == 0)
    {
        return 0x82BF;
    }
    if (strcmp(str, "GL_IMAGE_COMPATIBILITY_CLASS") == 0)
    {
        return 0x82A8;
    }
    if (strcmp(str, "GL_IMAGE_CUBE") == 0)
    {
        return 0x9050;
    }
    if (strcmp(str, "GL_IMAGE_CUBE_EXT") == 0)
    {
        return 0x9050;
    }
    if (strcmp(str, "GL_IMAGE_CUBE_MAP_ARRAY") == 0)
    {
        return 0x9054;
    }
    if (strcmp(str, "GL_IMAGE_CUBE_MAP_ARRAY_EXT") == 0)
    {
        return 0x9054;
    }
    if (strcmp(str, "GL_IMAGE_CUBE_MAP_ARRAY_OES") == 0)
    {
        return 0x9054;
    }
    if (strcmp(str, "GL_IMAGE_CUBIC_WEIGHT_HP") == 0)
    {
        return 0x815E;
    }
    if (strcmp(str, "GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS") == 0)
    {
        return 0x90C9;
    }
    if (strcmp(str, "GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE") == 0)
    {
        return 0x90C8;
    }
    if (strcmp(str, "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE") == 0)
    {
        return 0x90C7;
    }
    if (strcmp(str, "GL_IMAGE_MAG_FILTER_HP") == 0)
    {
        return 0x815C;
    }
    if (strcmp(str, "GL_IMAGE_MIN_FILTER_HP") == 0)
    {
        return 0x815D;
    }
    if (strcmp(str, "GL_IMAGE_PIXEL_FORMAT") == 0)
    {
        return 0x82A9;
    }
    if (strcmp(str, "GL_IMAGE_PIXEL_TYPE") == 0)
    {
        return 0x82AA;
    }
    if (strcmp(str, "GL_IMAGE_ROTATE_ANGLE_HP") == 0)
    {
        return 0x8159;
    }
    if (strcmp(str, "GL_IMAGE_ROTATE_ORIGIN_X_HP") == 0)
    {
        return 0x815A;
    }
    if (strcmp(str, "GL_IMAGE_ROTATE_ORIGIN_Y_HP") == 0)
    {
        return 0x815B;
    }
    if (strcmp(str, "GL_IMAGE_SCALE_X_HP") == 0)
    {
        return 0x8155;
    }
    if (strcmp(str, "GL_IMAGE_SCALE_Y_HP") == 0)
    {
        return 0x8156;
    }
    if (strcmp(str, "GL_IMAGE_TEXEL_SIZE") == 0)
    {
        return 0x82A7;
    }
    if (strcmp(str, "GL_IMAGE_TRANSFORM_2D_HP") == 0)
    {
        return 0x8161;
    }
    if (strcmp(str, "GL_IMAGE_TRANSLATE_X_HP") == 0)
    {
        return 0x8157;
    }
    if (strcmp(str, "GL_IMAGE_TRANSLATE_Y_HP") == 0)
    {
        return 0x8158;
    }
    if (strcmp(str, "GL_IMPLEMENTATION_COLOR_READ_FORMAT") == 0)
    {
        return 0x8B9B;
    }
    if (strcmp(str, "GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES") == 0)
    {
        return 0x8B9B;
    }
    if (strcmp(str, "GL_IMPLEMENTATION_COLOR_READ_TYPE") == 0)
    {
        return 0x8B9A;
    }
    if (strcmp(str, "GL_IMPLEMENTATION_COLOR_READ_TYPE_OES") == 0)
    {
        return 0x8B9A;
    }
    if (strcmp(str, "GL_INCLUSIVE_EXT") == 0)
    {
        return 0x8F10;
    }
    if (strcmp(str, "GL_INCR") == 0)
    {
        return 0x1E02;
    }
    if (strcmp(str, "GL_INCR_WRAP") == 0)
    {
        return 0x8507;
    }
    if (strcmp(str, "GL_INCR_WRAP_EXT") == 0)
    {
        return 0x8507;
    }
    if (strcmp(str, "GL_INCR_WRAP_OES") == 0)
    {
        return 0x8507;
    }
    if (strcmp(str, "GL_INDEX") == 0)
    {
        return 0x8222;
    }
    if (strcmp(str, "GL_INDEX_ARRAY") == 0)
    {
        return 0x8077;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_ADDRESS_NV") == 0)
    {
        return 0x8F24;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_BUFFER_BINDING") == 0)
    {
        return 0x8899;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_BUFFER_BINDING_ARB") == 0)
    {
        return 0x8899;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_COUNT_EXT") == 0)
    {
        return 0x8087;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_EXT") == 0)
    {
        return 0x8077;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_LENGTH_NV") == 0)
    {
        return 0x8F2E;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_LIST_IBM") == 0)
    {
        return 0x103073;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_LIST_STRIDE_IBM") == 0)
    {
        return 0x103083;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_POINTER") == 0)
    {
        return 0x8091;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_POINTER_EXT") == 0)
    {
        return 0x8091;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_STRIDE") == 0)
    {
        return 0x8086;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_STRIDE_EXT") == 0)
    {
        return 0x8086;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_TYPE") == 0)
    {
        return 0x8085;
    }
    if (strcmp(str, "GL_INDEX_ARRAY_TYPE_EXT") == 0)
    {
        return 0x8085;
    }
    if (strcmp(str, "GL_INDEX_BITS") == 0)
    {
        return 0x0D51;
    }
    if (strcmp(str, "GL_INDEX_BIT_PGI") == 0)
    {
        return 0x80000;
    }
    if (strcmp(str, "GL_INDEX_CLEAR_VALUE") == 0)
    {
        return 0x0C20;
    }
    if (strcmp(str, "GL_INDEX_LOGIC_OP") == 0)
    {
        return 0x0BF1;
    }
    if (strcmp(str, "GL_INDEX_MATERIAL_EXT") == 0)
    {
        return 0x81B8;
    }
    if (strcmp(str, "GL_INDEX_MATERIAL_FACE_EXT") == 0)
    {
        return 0x81BA;
    }
    if (strcmp(str, "GL_INDEX_MATERIAL_PARAMETER_EXT") == 0)
    {
        return 0x81B9;
    }
    if (strcmp(str, "GL_INDEX_MODE") == 0)
    {
        return 0x0C30;
    }
    if (strcmp(str, "GL_INDEX_OFFSET") == 0)
    {
        return 0x0D13;
    }
    if (strcmp(str, "GL_INDEX_SHIFT") == 0)
    {
        return 0x0D12;
    }
    if (strcmp(str, "GL_INDEX_TEST_EXT") == 0)
    {
        return 0x81B5;
    }
    if (strcmp(str, "GL_INDEX_TEST_FUNC_EXT") == 0)
    {
        return 0x81B6;
    }
    if (strcmp(str, "GL_INDEX_TEST_REF_EXT") == 0)
    {
        return 0x81B7;
    }
    if (strcmp(str, "GL_INDEX_WRITEMASK") == 0)
    {
        return 0x0C21;
    }
    if (strcmp(str, "GL_INFO_LOG_LENGTH") == 0)
    {
        return 0x8B84;
    }
    if (strcmp(str, "GL_INNOCENT_CONTEXT_RESET") == 0)
    {
        return 0x8254;
    }
    if (strcmp(str, "GL_INNOCENT_CONTEXT_RESET_ARB") == 0)
    {
        return 0x8254;
    }
    if (strcmp(str, "GL_INNOCENT_CONTEXT_RESET_EXT") == 0)
    {
        return 0x8254;
    }
    if (strcmp(str, "GL_INNOCENT_CONTEXT_RESET_KHR") == 0)
    {
        return 0x8254;
    }
    if (strcmp(str, "GL_INSTRUMENT_BUFFER_POINTER_SGIX") == 0)
    {
        return 0x8180;
    }
    if (strcmp(str, "GL_INSTRUMENT_MEASUREMENTS_SGIX") == 0)
    {
        return 0x8181;
    }
    if (strcmp(str, "GL_INT") == 0)
    {
        return 0x1404;
    }
    if (strcmp(str, "GL_INT16_NV") == 0)
    {
        return 0x8FE4;
    }
    if (strcmp(str, "GL_INT16_VEC2_NV") == 0)
    {
        return 0x8FE5;
    }
    if (strcmp(str, "GL_INT16_VEC3_NV") == 0)
    {
        return 0x8FE6;
    }
    if (strcmp(str, "GL_INT16_VEC4_NV") == 0)
    {
        return 0x8FE7;
    }
    if (strcmp(str, "GL_INT64_ARB") == 0)
    {
        return 0x140E;
    }
    if (strcmp(str, "GL_INT64_NV") == 0)
    {
        return 0x140E;
    }
    if (strcmp(str, "GL_INT64_VEC2_ARB") == 0)
    {
        return 0x8FE9;
    }
    if (strcmp(str, "GL_INT64_VEC2_NV") == 0)
    {
        return 0x8FE9;
    }
    if (strcmp(str, "GL_INT64_VEC3_ARB") == 0)
    {
        return 0x8FEA;
    }
    if (strcmp(str, "GL_INT64_VEC3_NV") == 0)
    {
        return 0x8FEA;
    }
    if (strcmp(str, "GL_INT64_VEC4_ARB") == 0)
    {
        return 0x8FEB;
    }
    if (strcmp(str, "GL_INT64_VEC4_NV") == 0)
    {
        return 0x8FEB;
    }
    if (strcmp(str, "GL_INT8_NV") == 0)
    {
        return 0x8FE0;
    }
    if (strcmp(str, "GL_INT8_VEC2_NV") == 0)
    {
        return 0x8FE1;
    }
    if (strcmp(str, "GL_INT8_VEC3_NV") == 0)
    {
        return 0x8FE2;
    }
    if (strcmp(str, "GL_INT8_VEC4_NV") == 0)
    {
        return 0x8FE3;
    }
    if (strcmp(str, "GL_INTENSITY") == 0)
    {
        return 0x8049;
    }
    if (strcmp(str, "GL_INTENSITY12") == 0)
    {
        return 0x804C;
    }
    if (strcmp(str, "GL_INTENSITY12_EXT") == 0)
    {
        return 0x804C;
    }
    if (strcmp(str, "GL_INTENSITY16") == 0)
    {
        return 0x804D;
    }
    if (strcmp(str, "GL_INTENSITY16F_ARB") == 0)
    {
        return 0x881D;
    }
    if (strcmp(str, "GL_INTENSITY16I_EXT") == 0)
    {
        return 0x8D8B;
    }
    if (strcmp(str, "GL_INTENSITY16UI_EXT") == 0)
    {
        return 0x8D79;
    }
    if (strcmp(str, "GL_INTENSITY16_EXT") == 0)
    {
        return 0x804D;
    }
    if (strcmp(str, "GL_INTENSITY16_SNORM") == 0)
    {
        return 0x901B;
    }
    if (strcmp(str, "GL_INTENSITY32F_ARB") == 0)
    {
        return 0x8817;
    }
    if (strcmp(str, "GL_INTENSITY32I_EXT") == 0)
    {
        return 0x8D85;
    }
    if (strcmp(str, "GL_INTENSITY32UI_EXT") == 0)
    {
        return 0x8D73;
    }
    if (strcmp(str, "GL_INTENSITY4") == 0)
    {
        return 0x804A;
    }
    if (strcmp(str, "GL_INTENSITY4_EXT") == 0)
    {
        return 0x804A;
    }
    if (strcmp(str, "GL_INTENSITY8") == 0)
    {
        return 0x804B;
    }
    if (strcmp(str, "GL_INTENSITY8I_EXT") == 0)
    {
        return 0x8D91;
    }
    if (strcmp(str, "GL_INTENSITY8UI_EXT") == 0)
    {
        return 0x8D7F;
    }
    if (strcmp(str, "GL_INTENSITY8_EXT") == 0)
    {
        return 0x804B;
    }
    if (strcmp(str, "GL_INTENSITY8_SNORM") == 0)
    {
        return 0x9017;
    }
    if (strcmp(str, "GL_INTENSITY_EXT") == 0)
    {
        return 0x8049;
    }
    if (strcmp(str, "GL_INTENSITY_FLOAT16_APPLE") == 0)
    {
        return 0x881D;
    }
    if (strcmp(str, "GL_INTENSITY_FLOAT16_ATI") == 0)
    {
        return 0x881D;
    }
    if (strcmp(str, "GL_INTENSITY_FLOAT32_APPLE") == 0)
    {
        return 0x8817;
    }
    if (strcmp(str, "GL_INTENSITY_FLOAT32_ATI") == 0)
    {
        return 0x8817;
    }
    if (strcmp(str, "GL_INTENSITY_SNORM") == 0)
    {
        return 0x9013;
    }
    if (strcmp(str, "GL_INTERLACE_OML") == 0)
    {
        return 0x8980;
    }
    if (strcmp(str, "GL_INTERLACE_READ_INGR") == 0)
    {
        return 0x8568;
    }
    if (strcmp(str, "GL_INTERLACE_READ_OML") == 0)
    {
        return 0x8981;
    }
    if (strcmp(str, "GL_INTERLACE_SGIX") == 0)
    {
        return 0x8094;
    }
    if (strcmp(str, "GL_INTERLEAVED_ATTRIBS") == 0)
    {
        return 0x8C8C;
    }
    if (strcmp(str, "GL_INTERLEAVED_ATTRIBS_EXT") == 0)
    {
        return 0x8C8C;
    }
    if (strcmp(str, "GL_INTERLEAVED_ATTRIBS_NV") == 0)
    {
        return 0x8C8C;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_ALPHA_SIZE") == 0)
    {
        return 0x8274;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_ALPHA_TYPE") == 0)
    {
        return 0x827B;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_BLUE_SIZE") == 0)
    {
        return 0x8273;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_BLUE_TYPE") == 0)
    {
        return 0x827A;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_DEPTH_SIZE") == 0)
    {
        return 0x8275;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_DEPTH_TYPE") == 0)
    {
        return 0x827C;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_GREEN_SIZE") == 0)
    {
        return 0x8272;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_GREEN_TYPE") == 0)
    {
        return 0x8279;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_PREFERRED") == 0)
    {
        return 0x8270;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_RED_SIZE") == 0)
    {
        return 0x8271;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_RED_TYPE") == 0)
    {
        return 0x8278;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_SHARED_SIZE") == 0)
    {
        return 0x8277;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_STENCIL_SIZE") == 0)
    {
        return 0x8276;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_STENCIL_TYPE") == 0)
    {
        return 0x827D;
    }
    if (strcmp(str, "GL_INTERNALFORMAT_SUPPORTED") == 0)
    {
        return 0x826F;
    }
    if (strcmp(str, "GL_INTERPOLATE") == 0)
    {
        return 0x8575;
    }
    if (strcmp(str, "GL_INTERPOLATE_ARB") == 0)
    {
        return 0x8575;
    }
    if (strcmp(str, "GL_INTERPOLATE_EXT") == 0)
    {
        return 0x8575;
    }
    if (strcmp(str, "GL_INT_10_10_10_2_OES") == 0)
    {
        return 0x8DF7;
    }
    if (strcmp(str, "GL_INT_2_10_10_10_REV") == 0)
    {
        return 0x8D9F;
    }
    if (strcmp(str, "GL_INT_IMAGE_1D") == 0)
    {
        return 0x9057;
    }
    if (strcmp(str, "GL_INT_IMAGE_1D_ARRAY") == 0)
    {
        return 0x905D;
    }
    if (strcmp(str, "GL_INT_IMAGE_1D_ARRAY_EXT") == 0)
    {
        return 0x905D;
    }
    if (strcmp(str, "GL_INT_IMAGE_1D_EXT") == 0)
    {
        return 0x9057;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D") == 0)
    {
        return 0x9058;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D_ARRAY") == 0)
    {
        return 0x905E;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D_ARRAY_EXT") == 0)
    {
        return 0x905E;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D_EXT") == 0)
    {
        return 0x9058;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D_MULTISAMPLE") == 0)
    {
        return 0x9060;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY") == 0)
    {
        return 0x9061;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT") == 0)
    {
        return 0x9061;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D_MULTISAMPLE_EXT") == 0)
    {
        return 0x9060;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D_RECT") == 0)
    {
        return 0x905A;
    }
    if (strcmp(str, "GL_INT_IMAGE_2D_RECT_EXT") == 0)
    {
        return 0x905A;
    }
    if (strcmp(str, "GL_INT_IMAGE_3D") == 0)
    {
        return 0x9059;
    }
    if (strcmp(str, "GL_INT_IMAGE_3D_EXT") == 0)
    {
        return 0x9059;
    }
    if (strcmp(str, "GL_INT_IMAGE_BUFFER") == 0)
    {
        return 0x905C;
    }
    if (strcmp(str, "GL_INT_IMAGE_BUFFER_EXT") == 0)
    {
        return 0x905C;
    }
    if (strcmp(str, "GL_INT_IMAGE_BUFFER_OES") == 0)
    {
        return 0x905C;
    }
    if (strcmp(str, "GL_INT_IMAGE_CUBE") == 0)
    {
        return 0x905B;
    }
    if (strcmp(str, "GL_INT_IMAGE_CUBE_EXT") == 0)
    {
        return 0x905B;
    }
    if (strcmp(str, "GL_INT_IMAGE_CUBE_MAP_ARRAY") == 0)
    {
        return 0x905F;
    }
    if (strcmp(str, "GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT") == 0)
    {
        return 0x905F;
    }
    if (strcmp(str, "GL_INT_IMAGE_CUBE_MAP_ARRAY_OES") == 0)
    {
        return 0x905F;
    }
    if (strcmp(str, "GL_INT_SAMPLER_1D") == 0)
    {
        return 0x8DC9;
    }
    if (strcmp(str, "GL_INT_SAMPLER_1D_ARRAY") == 0)
    {
        return 0x8DCE;
    }
    if (strcmp(str, "GL_INT_SAMPLER_1D_ARRAY_EXT") == 0)
    {
        return 0x8DCE;
    }
    if (strcmp(str, "GL_INT_SAMPLER_1D_EXT") == 0)
    {
        return 0x8DC9;
    }
    if (strcmp(str, "GL_INT_SAMPLER_2D") == 0)
    {
        return 0x8DCA;
    }
    if (strcmp(str, "GL_INT_SAMPLER_2D_ARRAY") == 0)
    {
        return 0x8DCF;
    }
    if (strcmp(str, "GL_INT_SAMPLER_2D_ARRAY_EXT") == 0)
    {
        return 0x8DCF;
    }
    if (strcmp(str, "GL_INT_SAMPLER_2D_EXT") == 0)
    {
        return 0x8DCA;
    }
    if (strcmp(str, "GL_INT_SAMPLER_2D_MULTISAMPLE") == 0)
    {
        return 0x9109;
    }
    if (strcmp(str, "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY") == 0)
    {
        return 0x910C;
    }
    if (strcmp(str, "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES") == 0)
    {
        return 0x910C;
    }
    if (strcmp(str, "GL_INT_SAMPLER_2D_RECT") == 0)
    {
        return 0x8DCD;
    }
    if (strcmp(str, "GL_INT_SAMPLER_2D_RECT_EXT") == 0)
    {
        return 0x8DCD;
    }
    if (strcmp(str, "GL_INT_SAMPLER_3D") == 0)
    {
        return 0x8DCB;
    }
    if (strcmp(str, "GL_INT_SAMPLER_3D_EXT") == 0)
    {
        return 0x8DCB;
    }
    if (strcmp(str, "GL_INT_SAMPLER_BUFFER") == 0)
    {
        return 0x8DD0;
    }
    if (strcmp(str, "GL_INT_SAMPLER_BUFFER_AMD") == 0)
    {
        return 0x9002;
    }
    if (strcmp(str, "GL_INT_SAMPLER_BUFFER_EXT") == 0)
    {
        return 0x8DD0;
    }
    if (strcmp(str, "GL_INT_SAMPLER_BUFFER_OES") == 0)
    {
        return 0x8DD0;
    }
    if (strcmp(str, "GL_INT_SAMPLER_CUBE") == 0)
    {
        return 0x8DCC;
    }
    if (strcmp(str, "GL_INT_SAMPLER_CUBE_EXT") == 0)
    {
        return 0x8DCC;
    }
    if (strcmp(str, "GL_INT_SAMPLER_CUBE_MAP_ARRAY") == 0)
    {
        return 0x900E;
    }
    if (strcmp(str, "GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB") == 0)
    {
        return 0x900E;
    }
    if (strcmp(str, "GL_INT_SAMPLER_CUBE_MAP_ARRAY_EXT") == 0)
    {
        return 0x900E;
    }
    if (strcmp(str, "GL_INT_SAMPLER_CUBE_MAP_ARRAY_OES") == 0)
    {
        return 0x900E;
    }
    if (strcmp(str, "GL_INT_SAMPLER_RENDERBUFFER_NV") == 0)
    {
        return 0x8E57;
    }
    if (strcmp(str, "GL_INT_VEC2") == 0)
    {
        return 0x8B53;
    }
    if (strcmp(str, "GL_INT_VEC2_ARB") == 0)
    {
        return 0x8B53;
    }
    if (strcmp(str, "GL_INT_VEC3") == 0)
    {
        return 0x8B54;
    }
    if (strcmp(str, "GL_INT_VEC3_ARB") == 0)
    {
        return 0x8B54;
    }
    if (strcmp(str, "GL_INT_VEC4") == 0)
    {
        return 0x8B55;
    }
    if (strcmp(str, "GL_INT_VEC4_ARB") == 0)
    {
        return 0x8B55;
    }
    if (strcmp(str, "GL_INVALID_ENUM") == 0)
    {
        return 0x0500;
    }
    if (strcmp(str, "GL_INVALID_FRAMEBUFFER_OPERATION") == 0)
    {
        return 0x0506;
    }
    if (strcmp(str, "GL_INVALID_FRAMEBUFFER_OPERATION_EXT") == 0)
    {
        return 0x0506;
    }
    if (strcmp(str, "GL_INVALID_FRAMEBUFFER_OPERATION_OES") == 0)
    {
        return 0x0506;
    }
    if (strcmp(str, "GL_INVALID_INDEX") == 0)
    {
        return 0xFFFFFFFF;
    }
    if (strcmp(str, "GL_INVALID_OPERATION") == 0)
    {
        return 0x0502;
    }
    if (strcmp(str, "GL_INVALID_VALUE") == 0)
    {
        return 0x0501;
    }
    if (strcmp(str, "GL_INVARIANT_DATATYPE_EXT") == 0)
    {
        return 0x87EB;
    }
    if (strcmp(str, "GL_INVARIANT_EXT") == 0)
    {
        return 0x87C2;
    }
    if (strcmp(str, "GL_INVARIANT_VALUE_EXT") == 0)
    {
        return 0x87EA;
    }
    if (strcmp(str, "GL_INVERSE_NV") == 0)
    {
        return 0x862B;
    }
    if (strcmp(str, "GL_INVERSE_TRANSPOSE_NV") == 0)
    {
        return 0x862D;
    }
    if (strcmp(str, "GL_INVERT") == 0)
    {
        return 0x150A;
    }
    if (strcmp(str, "GL_INVERTED_SCREEN_W_REND") == 0)
    {
        return 0x8491;
    }
    if (strcmp(str, "GL_INVERT_OVG_NV") == 0)
    {
        return 0x92B4;
    }
    if (strcmp(str, "GL_INVERT_RGB_NV") == 0)
    {
        return 0x92A3;
    }
    if (strcmp(str, "GL_IR_INSTRUMENT1_SGIX") == 0)
    {
        return 0x817F;
    }
    if (strcmp(str, "GL_ISOLINES") == 0)
    {
        return 0x8E7A;
    }
    if (strcmp(str, "GL_ISOLINES_EXT") == 0)
    {
        return 0x8E7A;
    }
    if (strcmp(str, "GL_ISOLINES_OES") == 0)
    {
        return 0x8E7A;
    }
    if (strcmp(str, "GL_IS_PER_PATCH") == 0)
    {
        return 0x92E7;
    }
    if (strcmp(str, "GL_IS_PER_PATCH_EXT") == 0)
    {
        return 0x92E7;
    }
    if (strcmp(str, "GL_IS_PER_PATCH_OES") == 0)
    {
        return 0x92E7;
    }
    if (strcmp(str, "GL_IS_ROW_MAJOR") == 0)
    {
        return 0x9300;
    }
    if (strcmp(str, "GL_ITALIC_BIT_NV") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_IUI_N3F_V2F_EXT") == 0)
    {
        return 0x81AF;
    }
    if (strcmp(str, "GL_IUI_N3F_V3F_EXT") == 0)
    {
        return 0x81B0;
    }
    if (strcmp(str, "GL_IUI_V2F_EXT") == 0)
    {
        return 0x81AD;
    }
    if (strcmp(str, "GL_IUI_V3F_EXT") == 0)
    {
        return 0x81AE;
    }
    if (strcmp(str, "GL_KEEP") == 0)
    {
        return 0x1E00;
    }
    if (strcmp(str, "GL_LARGE_CCW_ARC_TO_NV") == 0)
    {
        return 0x0016;
    }
    if (strcmp(str, "GL_LARGE_CW_ARC_TO_NV") == 0)
    {
        return 0x0018;
    }
    if (strcmp(str, "GL_LAST_VERTEX_CONVENTION") == 0)
    {
        return 0x8E4E;
    }
    if (strcmp(str, "GL_LAST_VERTEX_CONVENTION_ANGLE") == 0)
    {
        return 0x8E4E;
    }
    if (strcmp(str, "GL_LAST_VERTEX_CONVENTION_EXT") == 0)
    {
        return 0x8E4E;
    }
    if (strcmp(str, "GL_LAST_VERTEX_CONVENTION_OES") == 0)
    {
        return 0x8E4E;
    }
    if (strcmp(str, "GL_LAST_VIDEO_CAPTURE_STATUS_NV") == 0)
    {
        return 0x9027;
    }
    if (strcmp(str, "GL_LAYER_NV") == 0)
    {
        return 0x8DAA;
    }
    if (strcmp(str, "GL_LAYER_PROVOKING_VERTEX") == 0)
    {
        return 0x825E;
    }
    if (strcmp(str, "GL_LAYER_PROVOKING_VERTEX_EXT") == 0)
    {
        return 0x825E;
    }
    if (strcmp(str, "GL_LAYER_PROVOKING_VERTEX_OES") == 0)
    {
        return 0x825E;
    }
    if (strcmp(str, "GL_LAYOUT_COLOR_ATTACHMENT_EXT") == 0)
    {
        return 0x958E;
    }
    if (strcmp(str, "GL_LAYOUT_DEFAULT_INTEL") == 0)
    {
        return 0x0000;
    }
    if (strcmp(str, "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT") == 0)
    {
        return 0x9531;
    }
    if (strcmp(str, "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT") == 0)
    {
        return 0x9530;
    }
    if (strcmp(str, "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT") == 0)
    {
        return 0x958F;
    }
    if (strcmp(str, "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT") == 0)
    {
        return 0x9590;
    }
    if (strcmp(str, "GL_LAYOUT_GENERAL_EXT") == 0)
    {
        return 0x958D;
    }
    if (strcmp(str, "GL_LAYOUT_LINEAR_CPU_CACHED_INTEL") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_LAYOUT_LINEAR_INTEL") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_LAYOUT_SHADER_READ_ONLY_EXT") == 0)
    {
        return 0x9591;
    }
    if (strcmp(str, "GL_LAYOUT_TRANSFER_DST_EXT") == 0)
    {
        return 0x9593;
    }
    if (strcmp(str, "GL_LAYOUT_TRANSFER_SRC_EXT") == 0)
    {
        return 0x9592;
    }
    if (strcmp(str, "GL_LEFT") == 0)
    {
        return 0x0406;
    }
    if (strcmp(str, "GL_LEQUAL") == 0)
    {
        return 0x0203;
    }
    if (strcmp(str, "GL_LERP_ATI") == 0)
    {
        return 0x8969;
    }
    if (strcmp(str, "GL_LESS") == 0)
    {
        return 0x0201;
    }
    if (strcmp(str, "GL_LGPU_SEPARATE_STORAGE_BIT_NVX") == 0)
    {
        return 0x0800;
    }
    if (strcmp(str, "GL_LIGHT0") == 0)
    {
        return 0x4000;
    }
    if (strcmp(str, "GL_LIGHT1") == 0)
    {
        return 0x4001;
    }
    if (strcmp(str, "GL_LIGHT2") == 0)
    {
        return 0x4002;
    }
    if (strcmp(str, "GL_LIGHT3") == 0)
    {
        return 0x4003;
    }
    if (strcmp(str, "GL_LIGHT4") == 0)
    {
        return 0x4004;
    }
    if (strcmp(str, "GL_LIGHT5") == 0)
    {
        return 0x4005;
    }
    if (strcmp(str, "GL_LIGHT6") == 0)
    {
        return 0x4006;
    }
    if (strcmp(str, "GL_LIGHT7") == 0)
    {
        return 0x4007;
    }
    if (strcmp(str, "GL_LIGHTEN") == 0)
    {
        return 0x9298;
    }
    if (strcmp(str, "GL_LIGHTEN_KHR") == 0)
    {
        return 0x9298;
    }
    if (strcmp(str, "GL_LIGHTEN_NV") == 0)
    {
        return 0x9298;
    }
    if (strcmp(str, "GL_LIGHTING") == 0)
    {
        return 0x0B50;
    }
    if (strcmp(str, "GL_LIGHTING_BIT") == 0)
    {
        return 0x0040;
    }
    if (strcmp(str, "GL_LIGHT_ENV_MODE_SGIX") == 0)
    {
        return 0x8407;
    }
    if (strcmp(str, "GL_LIGHT_MODEL_AMBIENT") == 0)
    {
        return 0x0B53;
    }
    if (strcmp(str, "GL_LIGHT_MODEL_COLOR_CONTROL") == 0)
    {
        return 0x81F8;
    }
    if (strcmp(str, "GL_LIGHT_MODEL_COLOR_CONTROL_EXT") == 0)
    {
        return 0x81F8;
    }
    if (strcmp(str, "GL_LIGHT_MODEL_LOCAL_VIEWER") == 0)
    {
        return 0x0B51;
    }
    if (strcmp(str, "GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE") == 0)
    {
        return 0x85B0;
    }
    if (strcmp(str, "GL_LIGHT_MODEL_TWO_SIDE") == 0)
    {
        return 0x0B52;
    }
    if (strcmp(str, "GL_LINE") == 0)
    {
        return 0x1B01;
    }
    if (strcmp(str, "GL_LINEAR") == 0)
    {
        return 0x2601;
    }
    if (strcmp(str, "GL_LINEARBURN_NV") == 0)
    {
        return 0x92A5;
    }
    if (strcmp(str, "GL_LINEARDODGE_NV") == 0)
    {
        return 0x92A4;
    }
    if (strcmp(str, "GL_LINEARLIGHT_NV") == 0)
    {
        return 0x92A7;
    }
    if (strcmp(str, "GL_LINEAR_ATTENUATION") == 0)
    {
        return 0x1208;
    }
    if (strcmp(str, "GL_LINEAR_CLIPMAP_LINEAR_SGIX") == 0)
    {
        return 0x8170;
    }
    if (strcmp(str, "GL_LINEAR_CLIPMAP_NEAREST_SGIX") == 0)
    {
        return 0x844F;
    }
    if (strcmp(str, "GL_LINEAR_DETAIL_ALPHA_SGIS") == 0)
    {
        return 0x8098;
    }
    if (strcmp(str, "GL_LINEAR_DETAIL_COLOR_SGIS") == 0)
    {
        return 0x8099;
    }
    if (strcmp(str, "GL_LINEAR_DETAIL_SGIS") == 0)
    {
        return 0x8097;
    }
    if (strcmp(str, "GL_LINEAR_MIPMAP_LINEAR") == 0)
    {
        return 0x2703;
    }
    if (strcmp(str, "GL_LINEAR_MIPMAP_NEAREST") == 0)
    {
        return 0x2701;
    }
    if (strcmp(str, "GL_LINEAR_SHARPEN_ALPHA_SGIS") == 0)
    {
        return 0x80AE;
    }
    if (strcmp(str, "GL_LINEAR_SHARPEN_COLOR_SGIS") == 0)
    {
        return 0x80AF;
    }
    if (strcmp(str, "GL_LINEAR_SHARPEN_SGIS") == 0)
    {
        return 0x80AD;
    }
    if (strcmp(str, "GL_LINEAR_TILING_EXT") == 0)
    {
        return 0x9585;
    }
    if (strcmp(str, "GL_LINES") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_LINES_ADJACENCY") == 0)
    {
        return 0x000A;
    }
    if (strcmp(str, "GL_LINES_ADJACENCY_ARB") == 0)
    {
        return 0x000A;
    }
    if (strcmp(str, "GL_LINES_ADJACENCY_EXT") == 0)
    {
        return 0x000A;
    }
    if (strcmp(str, "GL_LINES_ADJACENCY_OES") == 0)
    {
        return 0x000A;
    }
    if (strcmp(str, "GL_LINE_BIT") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_LINE_LOOP") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_LINE_NV") == 0)
    {
        return 0x1B01;
    }
    if (strcmp(str, "GL_LINE_QUALITY_HINT_SGIX") == 0)
    {
        return 0x835B;
    }
    if (strcmp(str, "GL_LINE_RESET_TOKEN") == 0)
    {
        return 0x0707;
    }
    if (strcmp(str, "GL_LINE_SMOOTH") == 0)
    {
        return 0x0B20;
    }
    if (strcmp(str, "GL_LINE_SMOOTH_HINT") == 0)
    {
        return 0x0C52;
    }
    if (strcmp(str, "GL_LINE_STIPPLE") == 0)
    {
        return 0x0B24;
    }
    if (strcmp(str, "GL_LINE_STIPPLE_PATTERN") == 0)
    {
        return 0x0B25;
    }
    if (strcmp(str, "GL_LINE_STIPPLE_REPEAT") == 0)
    {
        return 0x0B26;
    }
    if (strcmp(str, "GL_LINE_STRIP") == 0)
    {
        return 0x0003;
    }
    if (strcmp(str, "GL_LINE_STRIP_ADJACENCY") == 0)
    {
        return 0x000B;
    }
    if (strcmp(str, "GL_LINE_STRIP_ADJACENCY_ARB") == 0)
    {
        return 0x000B;
    }
    if (strcmp(str, "GL_LINE_STRIP_ADJACENCY_EXT") == 0)
    {
        return 0x000B;
    }
    if (strcmp(str, "GL_LINE_STRIP_ADJACENCY_OES") == 0)
    {
        return 0x000B;
    }
    if (strcmp(str, "GL_LINE_TOKEN") == 0)
    {
        return 0x0702;
    }
    if (strcmp(str, "GL_LINE_TO_NV") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_LINE_WIDTH") == 0)
    {
        return 0x0B21;
    }
    if (strcmp(str, "GL_LINE_WIDTH_COMMAND_NV") == 0)
    {
        return 0x000D;
    }
    if (strcmp(str, "GL_LINE_WIDTH_GRANULARITY") == 0)
    {
        return 0x0B23;
    }
    if (strcmp(str, "GL_LINE_WIDTH_RANGE") == 0)
    {
        return 0x0B22;
    }
    if (strcmp(str, "GL_LINK_STATUS") == 0)
    {
        return 0x8B82;
    }
    if (strcmp(str, "GL_LIST_BASE") == 0)
    {
        return 0x0B32;
    }
    if (strcmp(str, "GL_LIST_BIT") == 0)
    {
        return 0x20000;
    }
    if (strcmp(str, "GL_LIST_INDEX") == 0)
    {
        return 0x0B33;
    }
    if (strcmp(str, "GL_LIST_MODE") == 0)
    {
        return 0x0B30;
    }
    if (strcmp(str, "GL_LIST_PRIORITY_SGIX") == 0)
    {
        return 0x8182;
    }
    if (strcmp(str, "GL_LOAD") == 0)
    {
        return 0x0101;
    }
    if (strcmp(str, "GL_LOAD_OP_CLEAR_ANGLE") == 0)
    {
        return 0x96E5;
    }
    if (strcmp(str, "GL_LOAD_OP_DISABLE_ANGLE") == 0)
    {
        return 0x96E7;
    }
    if (strcmp(str, "GL_LOAD_OP_LOAD_ANGLE") == 0)
    {
        return 0x96E6;
    }
    if (strcmp(str, "GL_LOAD_OP_ZERO_ANGLE") == 0)
    {
        return 0x96E4;
    }
    if (strcmp(str, "GL_LOCAL_CONSTANT_DATATYPE_EXT") == 0)
    {
        return 0x87ED;
    }
    if (strcmp(str, "GL_LOCAL_CONSTANT_EXT") == 0)
    {
        return 0x87C3;
    }
    if (strcmp(str, "GL_LOCAL_CONSTANT_VALUE_EXT") == 0)
    {
        return 0x87EC;
    }
    if (strcmp(str, "GL_LOCAL_EXT") == 0)
    {
        return 0x87C4;
    }
    if (strcmp(str, "GL_LOCATION") == 0)
    {
        return 0x930E;
    }
    if (strcmp(str, "GL_LOCATION_COMPONENT") == 0)
    {
        return 0x934A;
    }
    if (strcmp(str, "GL_LOCATION_INDEX") == 0)
    {
        return 0x930F;
    }
    if (strcmp(str, "GL_LOCATION_INDEX_EXT") == 0)
    {
        return 0x930F;
    }
    if (strcmp(str, "GL_LOGIC_OP") == 0)
    {
        return 0x0BF1;
    }
    if (strcmp(str, "GL_LOGIC_OP_AND_ANGLE") == 0)
    {
        return 0x1501;
    }
    if (strcmp(str, "GL_LOGIC_OP_AND_INVERTED_ANGLE") == 0)
    {
        return 0x1504;
    }
    if (strcmp(str, "GL_LOGIC_OP_AND_REVERSE_ANGLE") == 0)
    {
        return 0x1502;
    }
    if (strcmp(str, "GL_LOGIC_OP_CLEAR_ANGLE") == 0)
    {
        return 0x1500;
    }
    if (strcmp(str, "GL_LOGIC_OP_COPY_ANGLE") == 0)
    {
        return 0x1503;
    }
    if (strcmp(str, "GL_LOGIC_OP_COPY_INVERTED_ANGLE") == 0)
    {
        return 0x150C;
    }
    if (strcmp(str, "GL_LOGIC_OP_EQUIV_ANGLE") == 0)
    {
        return 0x1509;
    }
    if (strcmp(str, "GL_LOGIC_OP_INVERT_ANGLE") == 0)
    {
        return 0x150A;
    }
    if (strcmp(str, "GL_LOGIC_OP_MODE") == 0)
    {
        return 0x0BF0;
    }
    if (strcmp(str, "GL_LOGIC_OP_NAND_ANGLE") == 0)
    {
        return 0x150E;
    }
    if (strcmp(str, "GL_LOGIC_OP_NOOP_ANGLE") == 0)
    {
        return 0x1505;
    }
    if (strcmp(str, "GL_LOGIC_OP_NOR_ANGLE") == 0)
    {
        return 0x1508;
    }
    if (strcmp(str, "GL_LOGIC_OP_OR_ANGLE") == 0)
    {
        return 0x1507;
    }
    if (strcmp(str, "GL_LOGIC_OP_OR_INVERTED_ANGLE") == 0)
    {
        return 0x150D;
    }
    if (strcmp(str, "GL_LOGIC_OP_OR_REVERSE_ANGLE") == 0)
    {
        return 0x150B;
    }
    if (strcmp(str, "GL_LOGIC_OP_SET_ANGLE") == 0)
    {
        return 0x150F;
    }
    if (strcmp(str, "GL_LOGIC_OP_XOR_ANGLE") == 0)
    {
        return 0x1506;
    }
    if (strcmp(str, "GL_LOSE_CONTEXT_ON_RESET") == 0)
    {
        return 0x8252;
    }
    if (strcmp(str, "GL_LOSE_CONTEXT_ON_RESET_ARB") == 0)
    {
        return 0x8252;
    }
    if (strcmp(str, "GL_LOSE_CONTEXT_ON_RESET_EXT") == 0)
    {
        return 0x8252;
    }
    if (strcmp(str, "GL_LOSE_CONTEXT_ON_RESET_KHR") == 0)
    {
        return 0x8252;
    }
    if (strcmp(str, "GL_LOWER_LEFT") == 0)
    {
        return 0x8CA1;
    }
    if (strcmp(str, "GL_LOWER_LEFT_EXT") == 0)
    {
        return 0x8CA1;
    }
    if (strcmp(str, "GL_LOW_FLOAT") == 0)
    {
        return 0x8DF0;
    }
    if (strcmp(str, "GL_LOW_INT") == 0)
    {
        return 0x8DF3;
    }
    if (strcmp(str, "GL_LO_BIAS_NV") == 0)
    {
        return 0x8715;
    }
    if (strcmp(str, "GL_LO_SCALE_NV") == 0)
    {
        return 0x870F;
    }
    if (strcmp(str, "GL_LUID_SIZE_EXT") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_LUMINANCE") == 0)
    {
        return 0x1909;
    }
    if (strcmp(str, "GL_LUMINANCE12") == 0)
    {
        return 0x8041;
    }
    if (strcmp(str, "GL_LUMINANCE12_ALPHA12") == 0)
    {
        return 0x8047;
    }
    if (strcmp(str, "GL_LUMINANCE12_ALPHA12_EXT") == 0)
    {
        return 0x8047;
    }
    if (strcmp(str, "GL_LUMINANCE12_ALPHA4") == 0)
    {
        return 0x8046;
    }
    if (strcmp(str, "GL_LUMINANCE12_ALPHA4_EXT") == 0)
    {
        return 0x8046;
    }
    if (strcmp(str, "GL_LUMINANCE12_EXT") == 0)
    {
        return 0x8041;
    }
    if (strcmp(str, "GL_LUMINANCE16") == 0)
    {
        return 0x8042;
    }
    if (strcmp(str, "GL_LUMINANCE16F_ARB") == 0)
    {
        return 0x881E;
    }
    if (strcmp(str, "GL_LUMINANCE16F_EXT") == 0)
    {
        return 0x881E;
    }
    if (strcmp(str, "GL_LUMINANCE16I_EXT") == 0)
    {
        return 0x8D8C;
    }
    if (strcmp(str, "GL_LUMINANCE16UI_EXT") == 0)
    {
        return 0x8D7A;
    }
    if (strcmp(str, "GL_LUMINANCE16_ALPHA16") == 0)
    {
        return 0x8048;
    }
    if (strcmp(str, "GL_LUMINANCE16_ALPHA16_EXT") == 0)
    {
        return 0x8048;
    }
    if (strcmp(str, "GL_LUMINANCE16_ALPHA16_SNORM") == 0)
    {
        return 0x901A;
    }
    if (strcmp(str, "GL_LUMINANCE16_EXT") == 0)
    {
        return 0x8042;
    }
    if (strcmp(str, "GL_LUMINANCE16_SNORM") == 0)
    {
        return 0x9019;
    }
    if (strcmp(str, "GL_LUMINANCE32F_ARB") == 0)
    {
        return 0x8818;
    }
    if (strcmp(str, "GL_LUMINANCE32F_EXT") == 0)
    {
        return 0x8818;
    }
    if (strcmp(str, "GL_LUMINANCE32I_EXT") == 0)
    {
        return 0x8D86;
    }
    if (strcmp(str, "GL_LUMINANCE32UI_EXT") == 0)
    {
        return 0x8D74;
    }
    if (strcmp(str, "GL_LUMINANCE4") == 0)
    {
        return 0x803F;
    }
    if (strcmp(str, "GL_LUMINANCE4_ALPHA4") == 0)
    {
        return 0x8043;
    }
    if (strcmp(str, "GL_LUMINANCE4_ALPHA4_EXT") == 0)
    {
        return 0x8043;
    }
    if (strcmp(str, "GL_LUMINANCE4_ALPHA4_OES") == 0)
    {
        return 0x8043;
    }
    if (strcmp(str, "GL_LUMINANCE4_EXT") == 0)
    {
        return 0x803F;
    }
    if (strcmp(str, "GL_LUMINANCE6_ALPHA2") == 0)
    {
        return 0x8044;
    }
    if (strcmp(str, "GL_LUMINANCE6_ALPHA2_EXT") == 0)
    {
        return 0x8044;
    }
    if (strcmp(str, "GL_LUMINANCE8") == 0)
    {
        return 0x8040;
    }
    if (strcmp(str, "GL_LUMINANCE8I_EXT") == 0)
    {
        return 0x8D92;
    }
    if (strcmp(str, "GL_LUMINANCE8UI_EXT") == 0)
    {
        return 0x8D80;
    }
    if (strcmp(str, "GL_LUMINANCE8_ALPHA8") == 0)
    {
        return 0x8045;
    }
    if (strcmp(str, "GL_LUMINANCE8_ALPHA8_EXT") == 0)
    {
        return 0x8045;
    }
    if (strcmp(str, "GL_LUMINANCE8_ALPHA8_OES") == 0)
    {
        return 0x8045;
    }
    if (strcmp(str, "GL_LUMINANCE8_ALPHA8_SNORM") == 0)
    {
        return 0x9016;
    }
    if (strcmp(str, "GL_LUMINANCE8_EXT") == 0)
    {
        return 0x8040;
    }
    if (strcmp(str, "GL_LUMINANCE8_OES") == 0)
    {
        return 0x8040;
    }
    if (strcmp(str, "GL_LUMINANCE8_SNORM") == 0)
    {
        return 0x9015;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA") == 0)
    {
        return 0x190A;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA16F_ARB") == 0)
    {
        return 0x881F;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA16F_EXT") == 0)
    {
        return 0x881F;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA16I_EXT") == 0)
    {
        return 0x8D8D;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA16UI_EXT") == 0)
    {
        return 0x8D7B;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA32F_ARB") == 0)
    {
        return 0x8819;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA32F_EXT") == 0)
    {
        return 0x8819;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA32I_EXT") == 0)
    {
        return 0x8D87;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA32UI_EXT") == 0)
    {
        return 0x8D75;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA8I_EXT") == 0)
    {
        return 0x8D93;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA8UI_EXT") == 0)
    {
        return 0x8D81;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA_FLOAT16_APPLE") == 0)
    {
        return 0x881F;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA_FLOAT16_ATI") == 0)
    {
        return 0x881F;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA_FLOAT32_APPLE") == 0)
    {
        return 0x8819;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA_FLOAT32_ATI") == 0)
    {
        return 0x8819;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA_INTEGER_EXT") == 0)
    {
        return 0x8D9D;
    }
    if (strcmp(str, "GL_LUMINANCE_ALPHA_SNORM") == 0)
    {
        return 0x9012;
    }
    if (strcmp(str, "GL_LUMINANCE_FLOAT16_APPLE") == 0)
    {
        return 0x881E;
    }
    if (strcmp(str, "GL_LUMINANCE_FLOAT16_ATI") == 0)
    {
        return 0x881E;
    }
    if (strcmp(str, "GL_LUMINANCE_FLOAT32_APPLE") == 0)
    {
        return 0x8818;
    }
    if (strcmp(str, "GL_LUMINANCE_FLOAT32_ATI") == 0)
    {
        return 0x8818;
    }
    if (strcmp(str, "GL_LUMINANCE_INTEGER_EXT") == 0)
    {
        return 0x8D9C;
    }
    if (strcmp(str, "GL_LUMINANCE_SNORM") == 0)
    {
        return 0x9011;
    }
    if (strcmp(str, "GL_MAD_ATI") == 0)
    {
        return 0x8968;
    }
    if (strcmp(str, "GL_MAGNITUDE_BIAS_NV") == 0)
    {
        return 0x8718;
    }
    if (strcmp(str, "GL_MAGNITUDE_SCALE_NV") == 0)
    {
        return 0x8712;
    }
    if (strcmp(str, "GL_MAJOR_VERSION") == 0)
    {
        return 0x821B;
    }
    if (strcmp(str, "GL_MALI_PROGRAM_BINARY_ARM") == 0)
    {
        return 0x8F61;
    }
    if (strcmp(str, "GL_MALI_SHADER_BINARY_ARM") == 0)
    {
        return 0x8F60;
    }
    if (strcmp(str, "GL_MANUAL_GENERATE_MIPMAP") == 0)
    {
        return 0x8294;
    }
    if (strcmp(str, "GL_MAP1_BINORMAL_EXT") == 0)
    {
        return 0x8446;
    }
    if (strcmp(str, "GL_MAP1_COLOR_4") == 0)
    {
        return 0x0D90;
    }
    if (strcmp(str, "GL_MAP1_GRID_DOMAIN") == 0)
    {
        return 0x0DD0;
    }
    if (strcmp(str, "GL_MAP1_GRID_SEGMENTS") == 0)
    {
        return 0x0DD1;
    }
    if (strcmp(str, "GL_MAP1_INDEX") == 0)
    {
        return 0x0D91;
    }
    if (strcmp(str, "GL_MAP1_NORMAL") == 0)
    {
        return 0x0D92;
    }
    if (strcmp(str, "GL_MAP1_TANGENT_EXT") == 0)
    {
        return 0x8444;
    }
    if (strcmp(str, "GL_MAP1_TEXTURE_COORD_1") == 0)
    {
        return 0x0D93;
    }
    if (strcmp(str, "GL_MAP1_TEXTURE_COORD_2") == 0)
    {
        return 0x0D94;
    }
    if (strcmp(str, "GL_MAP1_TEXTURE_COORD_3") == 0)
    {
        return 0x0D95;
    }
    if (strcmp(str, "GL_MAP1_TEXTURE_COORD_4") == 0)
    {
        return 0x0D96;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_3") == 0)
    {
        return 0x0D97;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_4") == 0)
    {
        return 0x0D98;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB0_4_NV") == 0)
    {
        return 0x8660;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB10_4_NV") == 0)
    {
        return 0x866A;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB11_4_NV") == 0)
    {
        return 0x866B;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB12_4_NV") == 0)
    {
        return 0x866C;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB13_4_NV") == 0)
    {
        return 0x866D;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB14_4_NV") == 0)
    {
        return 0x866E;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB15_4_NV") == 0)
    {
        return 0x866F;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB1_4_NV") == 0)
    {
        return 0x8661;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB2_4_NV") == 0)
    {
        return 0x8662;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB3_4_NV") == 0)
    {
        return 0x8663;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB4_4_NV") == 0)
    {
        return 0x8664;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB5_4_NV") == 0)
    {
        return 0x8665;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB6_4_NV") == 0)
    {
        return 0x8666;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB7_4_NV") == 0)
    {
        return 0x8667;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB8_4_NV") == 0)
    {
        return 0x8668;
    }
    if (strcmp(str, "GL_MAP1_VERTEX_ATTRIB9_4_NV") == 0)
    {
        return 0x8669;
    }
    if (strcmp(str, "GL_MAP2_BINORMAL_EXT") == 0)
    {
        return 0x8447;
    }
    if (strcmp(str, "GL_MAP2_COLOR_4") == 0)
    {
        return 0x0DB0;
    }
    if (strcmp(str, "GL_MAP2_GRID_DOMAIN") == 0)
    {
        return 0x0DD2;
    }
    if (strcmp(str, "GL_MAP2_GRID_SEGMENTS") == 0)
    {
        return 0x0DD3;
    }
    if (strcmp(str, "GL_MAP2_INDEX") == 0)
    {
        return 0x0DB1;
    }
    if (strcmp(str, "GL_MAP2_NORMAL") == 0)
    {
        return 0x0DB2;
    }
    if (strcmp(str, "GL_MAP2_TANGENT_EXT") == 0)
    {
        return 0x8445;
    }
    if (strcmp(str, "GL_MAP2_TEXTURE_COORD_1") == 0)
    {
        return 0x0DB3;
    }
    if (strcmp(str, "GL_MAP2_TEXTURE_COORD_2") == 0)
    {
        return 0x0DB4;
    }
    if (strcmp(str, "GL_MAP2_TEXTURE_COORD_3") == 0)
    {
        return 0x0DB5;
    }
    if (strcmp(str, "GL_MAP2_TEXTURE_COORD_4") == 0)
    {
        return 0x0DB6;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_3") == 0)
    {
        return 0x0DB7;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_4") == 0)
    {
        return 0x0DB8;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB0_4_NV") == 0)
    {
        return 0x8670;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB10_4_NV") == 0)
    {
        return 0x867A;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB11_4_NV") == 0)
    {
        return 0x867B;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB12_4_NV") == 0)
    {
        return 0x867C;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB13_4_NV") == 0)
    {
        return 0x867D;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB14_4_NV") == 0)
    {
        return 0x867E;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB15_4_NV") == 0)
    {
        return 0x867F;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB1_4_NV") == 0)
    {
        return 0x8671;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB2_4_NV") == 0)
    {
        return 0x8672;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB3_4_NV") == 0)
    {
        return 0x8673;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB4_4_NV") == 0)
    {
        return 0x8674;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB5_4_NV") == 0)
    {
        return 0x8675;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB6_4_NV") == 0)
    {
        return 0x8676;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB7_4_NV") == 0)
    {
        return 0x8677;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB8_4_NV") == 0)
    {
        return 0x8678;
    }
    if (strcmp(str, "GL_MAP2_VERTEX_ATTRIB9_4_NV") == 0)
    {
        return 0x8679;
    }
    if (strcmp(str, "GL_MAP_ATTRIB_U_ORDER_NV") == 0)
    {
        return 0x86C3;
    }
    if (strcmp(str, "GL_MAP_ATTRIB_V_ORDER_NV") == 0)
    {
        return 0x86C4;
    }
    if (strcmp(str, "GL_MAP_COHERENT_BIT") == 0)
    {
        return 0x0080;
    }
    if (strcmp(str, "GL_MAP_COHERENT_BIT_EXT") == 0)
    {
        return 0x0080;
    }
    if (strcmp(str, "GL_MAP_COLOR") == 0)
    {
        return 0x0D10;
    }
    if (strcmp(str, "GL_MAP_FLUSH_EXPLICIT_BIT") == 0)
    {
        return 0x0010;
    }
    if (strcmp(str, "GL_MAP_FLUSH_EXPLICIT_BIT_EXT") == 0)
    {
        return 0x0010;
    }
    if (strcmp(str, "GL_MAP_INVALIDATE_BUFFER_BIT") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_MAP_INVALIDATE_BUFFER_BIT_EXT") == 0)
    {
        return 0x0008;
    }
    if (strcmp(str, "GL_MAP_INVALIDATE_RANGE_BIT") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_MAP_INVALIDATE_RANGE_BIT_EXT") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_MAP_PERSISTENT_BIT") == 0)
    {
        return 0x0040;
    }
    if (strcmp(str, "GL_MAP_PERSISTENT_BIT_EXT") == 0)
    {
        return 0x0040;
    }
    if (strcmp(str, "GL_MAP_READ_BIT") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_MAP_READ_BIT_EXT") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_MAP_STENCIL") == 0)
    {
        return 0x0D11;
    }
    if (strcmp(str, "GL_MAP_TESSELLATION_NV") == 0)
    {
        return 0x86C2;
    }
    if (strcmp(str, "GL_MAP_UNSYNCHRONIZED_BIT") == 0)
    {
        return 0x0020;
    }
    if (strcmp(str, "GL_MAP_UNSYNCHRONIZED_BIT_EXT") == 0)
    {
        return 0x0020;
    }
    if (strcmp(str, "GL_MAP_WRITE_BIT") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_MAP_WRITE_BIT_EXT") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_MATERIAL_SIDE_HINT_PGI") == 0)
    {
        return 0x1A22C;
    }
    if (strcmp(str, "GL_MATRIX0_ARB") == 0)
    {
        return 0x88C0;
    }
    if (strcmp(str, "GL_MATRIX0_NV") == 0)
    {
        return 0x8630;
    }
    if (strcmp(str, "GL_MATRIX10_ARB") == 0)
    {
        return 0x88CA;
    }
    if (strcmp(str, "GL_MATRIX11_ARB") == 0)
    {
        return 0x88CB;
    }
    if (strcmp(str, "GL_MATRIX12_ARB") == 0)
    {
        return 0x88CC;
    }
    if (strcmp(str, "GL_MATRIX13_ARB") == 0)
    {
        return 0x88CD;
    }
    if (strcmp(str, "GL_MATRIX14_ARB") == 0)
    {
        return 0x88CE;
    }
    if (strcmp(str, "GL_MATRIX15_ARB") == 0)
    {
        return 0x88CF;
    }
    if (strcmp(str, "GL_MATRIX16_ARB") == 0)
    {
        return 0x88D0;
    }
    if (strcmp(str, "GL_MATRIX17_ARB") == 0)
    {
        return 0x88D1;
    }
    if (strcmp(str, "GL_MATRIX18_ARB") == 0)
    {
        return 0x88D2;
    }
    if (strcmp(str, "GL_MATRIX19_ARB") == 0)
    {
        return 0x88D3;
    }
    if (strcmp(str, "GL_MATRIX1_ARB") == 0)
    {
        return 0x88C1;
    }
    if (strcmp(str, "GL_MATRIX1_NV") == 0)
    {
        return 0x8631;
    }
    if (strcmp(str, "GL_MATRIX20_ARB") == 0)
    {
        return 0x88D4;
    }
    if (strcmp(str, "GL_MATRIX21_ARB") == 0)
    {
        return 0x88D5;
    }
    if (strcmp(str, "GL_MATRIX22_ARB") == 0)
    {
        return 0x88D6;
    }
    if (strcmp(str, "GL_MATRIX23_ARB") == 0)
    {
        return 0x88D7;
    }
    if (strcmp(str, "GL_MATRIX24_ARB") == 0)
    {
        return 0x88D8;
    }
    if (strcmp(str, "GL_MATRIX25_ARB") == 0)
    {
        return 0x88D9;
    }
    if (strcmp(str, "GL_MATRIX26_ARB") == 0)
    {
        return 0x88DA;
    }
    if (strcmp(str, "GL_MATRIX27_ARB") == 0)
    {
        return 0x88DB;
    }
    if (strcmp(str, "GL_MATRIX28_ARB") == 0)
    {
        return 0x88DC;
    }
    if (strcmp(str, "GL_MATRIX29_ARB") == 0)
    {
        return 0x88DD;
    }
    if (strcmp(str, "GL_MATRIX2_ARB") == 0)
    {
        return 0x88C2;
    }
    if (strcmp(str, "GL_MATRIX2_NV") == 0)
    {
        return 0x8632;
    }
    if (strcmp(str, "GL_MATRIX30_ARB") == 0)
    {
        return 0x88DE;
    }
    if (strcmp(str, "GL_MATRIX31_ARB") == 0)
    {
        return 0x88DF;
    }
    if (strcmp(str, "GL_MATRIX3_ARB") == 0)
    {
        return 0x88C3;
    }
    if (strcmp(str, "GL_MATRIX3_NV") == 0)
    {
        return 0x8633;
    }
    if (strcmp(str, "GL_MATRIX4_ARB") == 0)
    {
        return 0x88C4;
    }
    if (strcmp(str, "GL_MATRIX4_NV") == 0)
    {
        return 0x8634;
    }
    if (strcmp(str, "GL_MATRIX5_ARB") == 0)
    {
        return 0x88C5;
    }
    if (strcmp(str, "GL_MATRIX5_NV") == 0)
    {
        return 0x8635;
    }
    if (strcmp(str, "GL_MATRIX6_ARB") == 0)
    {
        return 0x88C6;
    }
    if (strcmp(str, "GL_MATRIX6_NV") == 0)
    {
        return 0x8636;
    }
    if (strcmp(str, "GL_MATRIX7_ARB") == 0)
    {
        return 0x88C7;
    }
    if (strcmp(str, "GL_MATRIX7_NV") == 0)
    {
        return 0x8637;
    }
    if (strcmp(str, "GL_MATRIX8_ARB") == 0)
    {
        return 0x88C8;
    }
    if (strcmp(str, "GL_MATRIX9_ARB") == 0)
    {
        return 0x88C9;
    }
    if (strcmp(str, "GL_MATRIX_EXT") == 0)
    {
        return 0x87C0;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_ARB") == 0)
    {
        return 0x8844;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES") == 0)
    {
        return 0x8B9E;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_OES") == 0)
    {
        return 0x8844;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_POINTER_ARB") == 0)
    {
        return 0x8849;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_POINTER_OES") == 0)
    {
        return 0x8849;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_SIZE_ARB") == 0)
    {
        return 0x8846;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_SIZE_OES") == 0)
    {
        return 0x8846;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_STRIDE_ARB") == 0)
    {
        return 0x8848;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_STRIDE_OES") == 0)
    {
        return 0x8848;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_TYPE_ARB") == 0)
    {
        return 0x8847;
    }
    if (strcmp(str, "GL_MATRIX_INDEX_ARRAY_TYPE_OES") == 0)
    {
        return 0x8847;
    }
    if (strcmp(str, "GL_MATRIX_MODE") == 0)
    {
        return 0x0BA0;
    }
    if (strcmp(str, "GL_MATRIX_PALETTE_ARB") == 0)
    {
        return 0x8840;
    }
    if (strcmp(str, "GL_MATRIX_PALETTE_OES") == 0)
    {
        return 0x8840;
    }
    if (strcmp(str, "GL_MATRIX_STRIDE") == 0)
    {
        return 0x92FF;
    }
    if (strcmp(str, "GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI") == 0)
    {
        return 0x200000;
    }
    if (strcmp(str, "GL_MAT_AMBIENT_BIT_PGI") == 0)
    {
        return 0x100000;
    }
    if (strcmp(str, "GL_MAT_COLOR_INDEXES_BIT_PGI") == 0)
    {
        return 0x1000000;
    }
    if (strcmp(str, "GL_MAT_DIFFUSE_BIT_PGI") == 0)
    {
        return 0x400000;
    }
    if (strcmp(str, "GL_MAT_EMISSION_BIT_PGI") == 0)
    {
        return 0x800000;
    }
    if (strcmp(str, "GL_MAT_SHININESS_BIT_PGI") == 0)
    {
        return 0x2000000;
    }
    if (strcmp(str, "GL_MAT_SPECULAR_BIT_PGI") == 0)
    {
        return 0x4000000;
    }
    if (strcmp(str, "GL_MAX") == 0)
    {
        return 0x8008;
    }
    if (strcmp(str, "GL_MAX_3D_TEXTURE_SIZE") == 0)
    {
        return 0x8073;
    }
    if (strcmp(str, "GL_MAX_3D_TEXTURE_SIZE_EXT") == 0)
    {
        return 0x8073;
    }
    if (strcmp(str, "GL_MAX_3D_TEXTURE_SIZE_OES") == 0)
    {
        return 0x8073;
    }
    if (strcmp(str, "GL_MAX_4D_TEXTURE_SIZE_SGIS") == 0)
    {
        return 0x8138;
    }
    if (strcmp(str, "GL_MAX_ACTIVE_LIGHTS_SGIX") == 0)
    {
        return 0x8405;
    }
    if (strcmp(str, "GL_MAX_ARRAY_TEXTURE_LAYERS") == 0)
    {
        return 0x88FF;
    }
    if (strcmp(str, "GL_MAX_ARRAY_TEXTURE_LAYERS_EXT") == 0)
    {
        return 0x88FF;
    }
    if (strcmp(str, "GL_MAX_ASYNC_DRAW_PIXELS_SGIX") == 0)
    {
        return 0x8360;
    }
    if (strcmp(str, "GL_MAX_ASYNC_HISTOGRAM_SGIX") == 0)
    {
        return 0x832D;
    }
    if (strcmp(str, "GL_MAX_ASYNC_READ_PIXELS_SGIX") == 0)
    {
        return 0x8361;
    }
    if (strcmp(str, "GL_MAX_ASYNC_TEX_IMAGE_SGIX") == 0)
    {
        return 0x835F;
    }
    if (strcmp(str, "GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS") == 0)
    {
        return 0x92DC;
    }
    if (strcmp(str, "GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE") == 0)
    {
        return 0x92D8;
    }
    if (strcmp(str, "GL_MAX_ATTRIB_STACK_DEPTH") == 0)
    {
        return 0x0D35;
    }
    if (strcmp(str, "GL_MAX_BINDABLE_UNIFORM_SIZE_EXT") == 0)
    {
        return 0x8DED;
    }
    if (strcmp(str, "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH") == 0)
    {
        return 0x0D3B;
    }
    if (strcmp(str, "GL_MAX_CLIPMAP_DEPTH_SGIX") == 0)
    {
        return 0x8177;
    }
    if (strcmp(str, "GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX") == 0)
    {
        return 0x8178;
    }
    if (strcmp(str, "GL_MAX_CLIP_DISTANCES") == 0)
    {
        return 0x0D32;
    }
    if (strcmp(str, "GL_MAX_CLIP_DISTANCES_ANGLE") == 0)
    {
        return 0x0D32;
    }
    if (strcmp(str, "GL_MAX_CLIP_DISTANCES_APPLE") == 0)
    {
        return 0x0D32;
    }
    if (strcmp(str, "GL_MAX_CLIP_DISTANCES_EXT") == 0)
    {
        return 0x0D32;
    }
    if (strcmp(str, "GL_MAX_CLIP_PLANES") == 0)
    {
        return 0x0D32;
    }
    if (strcmp(str, "GL_MAX_CLIP_PLANES_IMG") == 0)
    {
        return 0x0D32;
    }
    if (strcmp(str, "GL_MAX_COARSE_FRAGMENT_SAMPLES_NV") == 0)
    {
        return 0x955F;
    }
    if (strcmp(str, "GL_MAX_COLOR_ATTACHMENTS") == 0)
    {
        return 0x8CDF;
    }
    if (strcmp(str, "GL_MAX_COLOR_ATTACHMENTS_EXT") == 0)
    {
        return 0x8CDF;
    }
    if (strcmp(str, "GL_MAX_COLOR_ATTACHMENTS_NV") == 0)
    {
        return 0x8CDF;
    }
    if (strcmp(str, "GL_MAX_COLOR_ATTACHMENTS_WITH_ACTIVE_PIXEL_LOCAL_STORAGE_ANGLE") == 0)
    {
        return 0x96E1;
    }
    if (strcmp(str, "GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD") == 0)
    {
        return 0x91B3;
    }
    if (strcmp(str, "GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD") == 0)
    {
        return 0x91B4;
    }
    if (strcmp(str, "GL_MAX_COLOR_MATRIX_STACK_DEPTH") == 0)
    {
        return 0x80B3;
    }
    if (strcmp(str, "GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI") == 0)
    {
        return 0x80B3;
    }
    if (strcmp(str, "GL_MAX_COLOR_TEXTURE_SAMPLES") == 0)
    {
        return 0x910E;
    }
    if (strcmp(str, "GL_MAX_COMBINED_ATOMIC_COUNTERS") == 0)
    {
        return 0x92D7;
    }
    if (strcmp(str, "GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS") == 0)
    {
        return 0x92D1;
    }
    if (strcmp(str, "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES") == 0)
    {
        return 0x82FA;
    }
    if (strcmp(str, "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_ANGLE") == 0)
    {
        return 0x82FA;
    }
    if (strcmp(str, "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_EXT") == 0)
    {
        return 0x82FA;
    }
    if (strcmp(str, "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8266;
    }
    if (strcmp(str, "GL_MAX_COMBINED_DIMENSIONS") == 0)
    {
        return 0x8282;
    }
    if (strcmp(str, "GL_MAX_COMBINED_DRAW_BUFFERS_AND_PIXEL_LOCAL_STORAGE_PLANES_ANGLE") == 0)
    {
        return 0x96E2;
    }
    if (strcmp(str, "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8A33;
    }
    if (strcmp(str, "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8A32;
    }
    if (strcmp(str, "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT") == 0)
    {
        return 0x8A32;
    }
    if (strcmp(str, "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_OES") == 0)
    {
        return 0x8A32;
    }
    if (strcmp(str, "GL_MAX_COMBINED_IMAGE_UNIFORMS") == 0)
    {
        return 0x90CF;
    }
    if (strcmp(str, "GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS") == 0)
    {
        return 0x8F39;
    }
    if (strcmp(str, "GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT") == 0)
    {
        return 0x8F39;
    }
    if (strcmp(str, "GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_NV") == 0)
    {
        return 0x8E67;
    }
    if (strcmp(str, "GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES") == 0)
    {
        return 0x8F39;
    }
    if (strcmp(str, "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS") == 0)
    {
        return 0x90DC;
    }
    if (strcmp(str, "GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_NV") == 0)
    {
        return 0x8E6F;
    }
    if (strcmp(str, "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8E1E;
    }
    if (strcmp(str, "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT") == 0)
    {
        return 0x8E1E;
    }
    if (strcmp(str, "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_OES") == 0)
    {
        return 0x8E1E;
    }
    if (strcmp(str, "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8E1F;
    }
    if (strcmp(str, "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT") == 0)
    {
        return 0x8E1F;
    }
    if (strcmp(str, "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_OES") == 0)
    {
        return 0x8E1F;
    }
    if (strcmp(str, "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS") == 0)
    {
        return 0x8B4D;
    }
    if (strcmp(str, "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB") == 0)
    {
        return 0x8B4D;
    }
    if (strcmp(str, "GL_MAX_COMBINED_UNIFORM_BLOCKS") == 0)
    {
        return 0x8A2E;
    }
    if (strcmp(str, "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8A31;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_ATOMIC_COUNTERS") == 0)
    {
        return 0x8265;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS") == 0)
    {
        return 0x8264;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB") == 0)
    {
        return 0x90EB;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB") == 0)
    {
        return 0x91BF;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_IMAGE_UNIFORMS") == 0)
    {
        return 0x91BD;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS") == 0)
    {
        return 0x90DB;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_SHARED_MEMORY_SIZE") == 0)
    {
        return 0x8262;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS") == 0)
    {
        return 0x91BC;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_UNIFORM_BLOCKS") == 0)
    {
        return 0x91BB;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8263;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB") == 0)
    {
        return 0x9344;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB") == 0)
    {
        return 0x9345;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_WORK_GROUP_COUNT") == 0)
    {
        return 0x91BE;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS") == 0)
    {
        return 0x90EB;
    }
    if (strcmp(str, "GL_MAX_COMPUTE_WORK_GROUP_SIZE") == 0)
    {
        return 0x91BF;
    }
    if (strcmp(str, "GL_MAX_CONVOLUTION_HEIGHT") == 0)
    {
        return 0x801B;
    }
    if (strcmp(str, "GL_MAX_CONVOLUTION_HEIGHT_EXT") == 0)
    {
        return 0x801B;
    }
    if (strcmp(str, "GL_MAX_CONVOLUTION_WIDTH") == 0)
    {
        return 0x801A;
    }
    if (strcmp(str, "GL_MAX_CONVOLUTION_WIDTH_EXT") == 0)
    {
        return 0x801A;
    }
    if (strcmp(str, "GL_MAX_CUBE_MAP_TEXTURE_SIZE") == 0)
    {
        return 0x851C;
    }
    if (strcmp(str, "GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB") == 0)
    {
        return 0x851C;
    }
    if (strcmp(str, "GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT") == 0)
    {
        return 0x851C;
    }
    if (strcmp(str, "GL_MAX_CUBE_MAP_TEXTURE_SIZE_OES") == 0)
    {
        return 0x851C;
    }
    if (strcmp(str, "GL_MAX_CULL_DISTANCES") == 0)
    {
        return 0x82F9;
    }
    if (strcmp(str, "GL_MAX_CULL_DISTANCES_ANGLE") == 0)
    {
        return 0x82F9;
    }
    if (strcmp(str, "GL_MAX_CULL_DISTANCES_EXT") == 0)
    {
        return 0x82F9;
    }
    if (strcmp(str, "GL_MAX_DEBUG_GROUP_STACK_DEPTH") == 0)
    {
        return 0x826C;
    }
    if (strcmp(str, "GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR") == 0)
    {
        return 0x826C;
    }
    if (strcmp(str, "GL_MAX_DEBUG_LOGGED_MESSAGES") == 0)
    {
        return 0x9144;
    }
    if (strcmp(str, "GL_MAX_DEBUG_LOGGED_MESSAGES_AMD") == 0)
    {
        return 0x9144;
    }
    if (strcmp(str, "GL_MAX_DEBUG_LOGGED_MESSAGES_ARB") == 0)
    {
        return 0x9144;
    }
    if (strcmp(str, "GL_MAX_DEBUG_LOGGED_MESSAGES_KHR") == 0)
    {
        return 0x9144;
    }
    if (strcmp(str, "GL_MAX_DEBUG_MESSAGE_LENGTH") == 0)
    {
        return 0x9143;
    }
    if (strcmp(str, "GL_MAX_DEBUG_MESSAGE_LENGTH_AMD") == 0)
    {
        return 0x9143;
    }
    if (strcmp(str, "GL_MAX_DEBUG_MESSAGE_LENGTH_ARB") == 0)
    {
        return 0x9143;
    }
    if (strcmp(str, "GL_MAX_DEBUG_MESSAGE_LENGTH_KHR") == 0)
    {
        return 0x9143;
    }
    if (strcmp(str, "GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV") == 0)
    {
        return 0x90D1;
    }
    if (strcmp(str, "GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV") == 0)
    {
        return 0x90D0;
    }
    if (strcmp(str, "GL_MAX_DEFORMATION_ORDER_SGIX") == 0)
    {
        return 0x8197;
    }
    if (strcmp(str, "GL_MAX_DEPTH") == 0)
    {
        return 0x8280;
    }
    if (strcmp(str, "GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD") == 0)
    {
        return 0x91B5;
    }
    if (strcmp(str, "GL_MAX_DEPTH_TEXTURE_SAMPLES") == 0)
    {
        return 0x910F;
    }
    if (strcmp(str, "GL_MAX_DETACHED_BUFFERS_NV") == 0)
    {
        return 0x95AD;
    }
    if (strcmp(str, "GL_MAX_DETACHED_TEXTURES_NV") == 0)
    {
        return 0x95AC;
    }
    if (strcmp(str, "GL_MAX_DRAW_BUFFERS") == 0)
    {
        return 0x8824;
    }
    if (strcmp(str, "GL_MAX_DRAW_BUFFERS_ARB") == 0)
    {
        return 0x8824;
    }
    if (strcmp(str, "GL_MAX_DRAW_BUFFERS_ATI") == 0)
    {
        return 0x8824;
    }
    if (strcmp(str, "GL_MAX_DRAW_BUFFERS_EXT") == 0)
    {
        return 0x8824;
    }
    if (strcmp(str, "GL_MAX_DRAW_BUFFERS_NV") == 0)
    {
        return 0x8824;
    }
    if (strcmp(str, "GL_MAX_DRAW_MESH_TASKS_COUNT_NV") == 0)
    {
        return 0x953D;
    }
    if (strcmp(str, "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS") == 0)
    {
        return 0x88FC;
    }
    if (strcmp(str, "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT") == 0)
    {
        return 0x88FC;
    }
    if (strcmp(str, "GL_MAX_ELEMENTS_INDICES") == 0)
    {
        return 0x80E9;
    }
    if (strcmp(str, "GL_MAX_ELEMENTS_INDICES_EXT") == 0)
    {
        return 0x80E9;
    }
    if (strcmp(str, "GL_MAX_ELEMENTS_VERTICES") == 0)
    {
        return 0x80E8;
    }
    if (strcmp(str, "GL_MAX_ELEMENTS_VERTICES_EXT") == 0)
    {
        return 0x80E8;
    }
    if (strcmp(str, "GL_MAX_ELEMENT_INDEX") == 0)
    {
        return 0x8D6B;
    }
    if (strcmp(str, "GL_MAX_EVAL_ORDER") == 0)
    {
        return 0x0D30;
    }
    if (strcmp(str, "GL_MAX_EXT") == 0)
    {
        return 0x8008;
    }
    if (strcmp(str, "GL_MAX_FOG_FUNC_POINTS_SGIS") == 0)
    {
        return 0x812C;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_ATOMIC_COUNTERS") == 0)
    {
        return 0x92D6;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS") == 0)
    {
        return 0x92D0;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT") == 0)
    {
        return 0x8DE3;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_IMAGE_UNIFORMS") == 0)
    {
        return 0x90CE;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_INPUT_COMPONENTS") == 0)
    {
        return 0x9125;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET") == 0)
    {
        return 0x8E5C;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV") == 0)
    {
        return 0x8E5C;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES") == 0)
    {
        return 0x8E5C;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_LIGHTS_SGIX") == 0)
    {
        return 0x8404;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV") == 0)
    {
        return 0x8868;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS") == 0)
    {
        return 0x90DA;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_LAYERS_EXT") == 0)
    {
        return 0x96DC;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_ASPECT_RATIO_EXT") == 0)
    {
        return 0x96DB;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_HEIGHT_EXT") == 0)
    {
        return 0x96DA;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_WIDTH_EXT") == 0)
    {
        return 0x96D8;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_UNIFORM_BLOCKS") == 0)
    {
        return 0x8A2D;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8B49;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB") == 0)
    {
        return 0x8B49;
    }
    if (strcmp(str, "GL_MAX_FRAGMENT_UNIFORM_VECTORS") == 0)
    {
        return 0x8DFD;
    }
    if (strcmp(str, "GL_MAX_FRAMEBUFFER_HEIGHT") == 0)
    {
        return 0x9316;
    }
    if (strcmp(str, "GL_MAX_FRAMEBUFFER_LAYERS") == 0)
    {
        return 0x9317;
    }
    if (strcmp(str, "GL_MAX_FRAMEBUFFER_LAYERS_EXT") == 0)
    {
        return 0x9317;
    }
    if (strcmp(str, "GL_MAX_FRAMEBUFFER_LAYERS_OES") == 0)
    {
        return 0x9317;
    }
    if (strcmp(str, "GL_MAX_FRAMEBUFFER_SAMPLES") == 0)
    {
        return 0x9318;
    }
    if (strcmp(str, "GL_MAX_FRAMEBUFFER_WIDTH") == 0)
    {
        return 0x9315;
    }
    if (strcmp(str, "GL_MAX_FRAMEZOOM_FACTOR_SGIX") == 0)
    {
        return 0x818D;
    }
    if (strcmp(str, "GL_MAX_GENERAL_COMBINERS_NV") == 0)
    {
        return 0x854D;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_ATOMIC_COUNTERS") == 0)
    {
        return 0x92D5;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT") == 0)
    {
        return 0x92D5;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_ATOMIC_COUNTERS_OES") == 0)
    {
        return 0x92D5;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS") == 0)
    {
        return 0x92CF;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT") == 0)
    {
        return 0x92CF;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_OES") == 0)
    {
        return 0x92CF;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT") == 0)
    {
        return 0x8DE4;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_IMAGE_UNIFORMS") == 0)
    {
        return 0x90CD;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT") == 0)
    {
        return 0x90CD;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_IMAGE_UNIFORMS_OES") == 0)
    {
        return 0x90CD;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_INPUT_COMPONENTS") == 0)
    {
        return 0x9123;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_INPUT_COMPONENTS_EXT") == 0)
    {
        return 0x9123;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_INPUT_COMPONENTS_OES") == 0)
    {
        return 0x9123;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS") == 0)
    {
        return 0x9124;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT") == 0)
    {
        return 0x9124;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_OES") == 0)
    {
        return 0x9124;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_OUTPUT_VERTICES") == 0)
    {
        return 0x8DE0;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB") == 0)
    {
        return 0x8DE0;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT") == 0)
    {
        return 0x8DE0;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_OUTPUT_VERTICES_OES") == 0)
    {
        return 0x8DE0;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV") == 0)
    {
        return 0x8E5A;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_SHADER_INVOCATIONS") == 0)
    {
        return 0x8E5A;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT") == 0)
    {
        return 0x8E5A;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_SHADER_INVOCATIONS_OES") == 0)
    {
        return 0x8E5A;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS") == 0)
    {
        return 0x90D7;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT") == 0)
    {
        return 0x90D7;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_OES") == 0)
    {
        return 0x90D7;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS") == 0)
    {
        return 0x8C29;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB") == 0)
    {
        return 0x8C29;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT") == 0)
    {
        return 0x8C29;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_OES") == 0)
    {
        return 0x8C29;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS") == 0)
    {
        return 0x8DE1;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB") == 0)
    {
        return 0x8DE1;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT") == 0)
    {
        return 0x8DE1;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_OES") == 0)
    {
        return 0x8DE1;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_UNIFORM_BLOCKS") == 0)
    {
        return 0x8A2C;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT") == 0)
    {
        return 0x8A2C;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_UNIFORM_BLOCKS_OES") == 0)
    {
        return 0x8A2C;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8DDF;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB") == 0)
    {
        return 0x8DDF;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT") == 0)
    {
        return 0x8DDF;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_OES") == 0)
    {
        return 0x8DDF;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB") == 0)
    {
        return 0x8DDD;
    }
    if (strcmp(str, "GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT") == 0)
    {
        return 0x8DDD;
    }
    if (strcmp(str, "GL_MAX_HEIGHT") == 0)
    {
        return 0x827F;
    }
    if (strcmp(str, "GL_MAX_IMAGE_SAMPLES") == 0)
    {
        return 0x906D;
    }
    if (strcmp(str, "GL_MAX_IMAGE_SAMPLES_EXT") == 0)
    {
        return 0x906D;
    }
    if (strcmp(str, "GL_MAX_IMAGE_UNITS") == 0)
    {
        return 0x8F38;
    }
    if (strcmp(str, "GL_MAX_IMAGE_UNITS_EXT") == 0)
    {
        return 0x8F38;
    }
    if (strcmp(str, "GL_MAX_INTEGER_SAMPLES") == 0)
    {
        return 0x9110;
    }
    if (strcmp(str, "GL_MAX_LABEL_LENGTH") == 0)
    {
        return 0x82E8;
    }
    if (strcmp(str, "GL_MAX_LABEL_LENGTH_KHR") == 0)
    {
        return 0x82E8;
    }
    if (strcmp(str, "GL_MAX_LAYERS") == 0)
    {
        return 0x8281;
    }
    if (strcmp(str, "GL_MAX_LGPU_GPUS_NVX") == 0)
    {
        return 0x92BA;
    }
    if (strcmp(str, "GL_MAX_LIGHTS") == 0)
    {
        return 0x0D31;
    }
    if (strcmp(str, "GL_MAX_LIST_NESTING") == 0)
    {
        return 0x0B31;
    }
    if (strcmp(str, "GL_MAX_MAP_TESSELLATION_NV") == 0)
    {
        return 0x86D6;
    }
    if (strcmp(str, "GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB") == 0)
    {
        return 0x8841;
    }
    if (strcmp(str, "GL_MAX_MESH_ATOMIC_COUNTERS_NV") == 0)
    {
        return 0x8E65;
    }
    if (strcmp(str, "GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_NV") == 0)
    {
        return 0x8E64;
    }
    if (strcmp(str, "GL_MAX_MESH_IMAGE_UNIFORMS_NV") == 0)
    {
        return 0x8E62;
    }
    if (strcmp(str, "GL_MAX_MESH_OUTPUT_PRIMITIVES_NV") == 0)
    {
        return 0x9539;
    }
    if (strcmp(str, "GL_MAX_MESH_OUTPUT_VERTICES_NV") == 0)
    {
        return 0x9538;
    }
    if (strcmp(str, "GL_MAX_MESH_SHADER_STORAGE_BLOCKS_NV") == 0)
    {
        return 0x8E66;
    }
    if (strcmp(str, "GL_MAX_MESH_TEXTURE_IMAGE_UNITS_NV") == 0)
    {
        return 0x8E61;
    }
    if (strcmp(str, "GL_MAX_MESH_TOTAL_MEMORY_SIZE_NV") == 0)
    {
        return 0x9536;
    }
    if (strcmp(str, "GL_MAX_MESH_UNIFORM_BLOCKS_NV") == 0)
    {
        return 0x8E60;
    }
    if (strcmp(str, "GL_MAX_MESH_UNIFORM_COMPONENTS_NV") == 0)
    {
        return 0x8E63;
    }
    if (strcmp(str, "GL_MAX_MESH_VIEWS_NV") == 0)
    {
        return 0x9557;
    }
    if (strcmp(str, "GL_MAX_MESH_WORK_GROUP_INVOCATIONS_NV") == 0)
    {
        return 0x95A2;
    }
    if (strcmp(str, "GL_MAX_MESH_WORK_GROUP_SIZE_NV") == 0)
    {
        return 0x953B;
    }
    if (strcmp(str, "GL_MAX_MODELVIEW_STACK_DEPTH") == 0)
    {
        return 0x0D36;
    }
    if (strcmp(str, "GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV") == 0)
    {
        return 0x8E11;
    }
    if (strcmp(str, "GL_MAX_MULTIVIEW_BUFFERS_EXT") == 0)
    {
        return 0x90F2;
    }
    if (strcmp(str, "GL_MAX_NAME_LENGTH") == 0)
    {
        return 0x92F6;
    }
    if (strcmp(str, "GL_MAX_NAME_STACK_DEPTH") == 0)
    {
        return 0x0D37;
    }
    if (strcmp(str, "GL_MAX_NUM_ACTIVE_VARIABLES") == 0)
    {
        return 0x92F7;
    }
    if (strcmp(str, "GL_MAX_NUM_COMPATIBLE_SUBROUTINES") == 0)
    {
        return 0x92F8;
    }
    if (strcmp(str, "GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT") == 0)
    {
        return 0x87CA;
    }
    if (strcmp(str, "GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT") == 0)
    {
        return 0x87CD;
    }
    if (strcmp(str, "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT") == 0)
    {
        return 0x87CE;
    }
    if (strcmp(str, "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT") == 0)
    {
        return 0x87CC;
    }
    if (strcmp(str, "GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT") == 0)
    {
        return 0x87CB;
    }
    if (strcmp(str, "GL_MAX_PALETTE_MATRICES_ARB") == 0)
    {
        return 0x8842;
    }
    if (strcmp(str, "GL_MAX_PALETTE_MATRICES_OES") == 0)
    {
        return 0x8842;
    }
    if (strcmp(str, "GL_MAX_PATCH_VERTICES") == 0)
    {
        return 0x8E7D;
    }
    if (strcmp(str, "GL_MAX_PATCH_VERTICES_EXT") == 0)
    {
        return 0x8E7D;
    }
    if (strcmp(str, "GL_MAX_PATCH_VERTICES_OES") == 0)
    {
        return 0x8E7D;
    }
    if (strcmp(str, "GL_MAX_PIXEL_LOCAL_STORAGE_PLANES_ANGLE") == 0)
    {
        return 0x96E0;
    }
    if (strcmp(str, "GL_MAX_PIXEL_MAP_TABLE") == 0)
    {
        return 0x0D34;
    }
    if (strcmp(str, "GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT") == 0)
    {
        return 0x8337;
    }
    if (strcmp(str, "GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI") == 0)
    {
        return 0x87F1;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB") == 0)
    {
        return 0x88B1;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB") == 0)
    {
        return 0x880B;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_ATTRIBS_ARB") == 0)
    {
        return 0x88AD;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV") == 0)
    {
        return 0x8908;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_CALL_DEPTH_NV") == 0)
    {
        return 0x88F5;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_ENV_PARAMETERS_ARB") == 0)
    {
        return 0x88B5;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV") == 0)
    {
        return 0x88F4;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV") == 0)
    {
        return 0x8DA5;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_GENERIC_RESULTS_NV") == 0)
    {
        return 0x8DA6;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_IF_DEPTH_NV") == 0)
    {
        return 0x88F6;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_INSTRUCTIONS_ARB") == 0)
    {
        return 0x88A1;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB") == 0)
    {
        return 0x88B4;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_LOOP_COUNT_NV") == 0)
    {
        return 0x88F8;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_LOOP_DEPTH_NV") == 0)
    {
        return 0x88F7;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_MATRICES_ARB") == 0)
    {
        return 0x862F;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB") == 0)
    {
        return 0x862E;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB") == 0)
    {
        return 0x88B3;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB") == 0)
    {
        return 0x880E;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB") == 0)
    {
        return 0x88AF;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB") == 0)
    {
        return 0x88A3;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB") == 0)
    {
        return 0x88AB;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB") == 0)
    {
        return 0x88A7;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB") == 0)
    {
        return 0x8810;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB") == 0)
    {
        return 0x880F;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_OUTPUT_VERTICES_NV") == 0)
    {
        return 0x8C27;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_PARAMETERS_ARB") == 0)
    {
        return 0x88A9;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV") == 0)
    {
        return 0x8DA0;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV") == 0)
    {
        return 0x8DA1;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_PATCH_ATTRIBS_NV") == 0)
    {
        return 0x86D8;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_RESULT_COMPONENTS_NV") == 0)
    {
        return 0x8909;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_SUBROUTINE_NUM_NV") == 0)
    {
        return 0x8F45;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV") == 0)
    {
        return 0x8F44;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEMPORARIES_ARB") == 0)
    {
        return 0x88A5;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEXEL_OFFSET") == 0)
    {
        return 0x8905;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEXEL_OFFSET_EXT") == 0)
    {
        return 0x8905;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEXEL_OFFSET_NV") == 0)
    {
        return 0x8905;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB") == 0)
    {
        return 0x8F9F;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET") == 0)
    {
        return 0x8E5F;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB") == 0)
    {
        return 0x8E5F;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV") == 0)
    {
        return 0x8E5F;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB") == 0)
    {
        return 0x880D;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB") == 0)
    {
        return 0x880C;
    }
    if (strcmp(str, "GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV") == 0)
    {
        return 0x8C28;
    }
    if (strcmp(str, "GL_MAX_PROJECTION_STACK_DEPTH") == 0)
    {
        return 0x0D38;
    }
    if (strcmp(str, "GL_MAX_RASTER_SAMPLES_EXT") == 0)
    {
        return 0x9329;
    }
    if (strcmp(str, "GL_MAX_RATIONAL_EVAL_ORDER_NV") == 0)
    {
        return 0x86D7;
    }
    if (strcmp(str, "GL_MAX_RECTANGLE_TEXTURE_SIZE") == 0)
    {
        return 0x84F8;
    }
    if (strcmp(str, "GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB") == 0)
    {
        return 0x84F8;
    }
    if (strcmp(str, "GL_MAX_RECTANGLE_TEXTURE_SIZE_NV") == 0)
    {
        return 0x84F8;
    }
    if (strcmp(str, "GL_MAX_RENDERBUFFER_SIZE") == 0)
    {
        return 0x84E8;
    }
    if (strcmp(str, "GL_MAX_RENDERBUFFER_SIZE_EXT") == 0)
    {
        return 0x84E8;
    }
    if (strcmp(str, "GL_MAX_RENDERBUFFER_SIZE_OES") == 0)
    {
        return 0x84E8;
    }
    if (strcmp(str, "GL_MAX_SAMPLES") == 0)
    {
        return 0x8D57;
    }
    if (strcmp(str, "GL_MAX_SAMPLES_ANGLE") == 0)
    {
        return 0x8D57;
    }
    if (strcmp(str, "GL_MAX_SAMPLES_APPLE") == 0)
    {
        return 0x8D57;
    }
    if (strcmp(str, "GL_MAX_SAMPLES_EXT") == 0)
    {
        return 0x8D57;
    }
    if (strcmp(str, "GL_MAX_SAMPLES_IMG") == 0)
    {
        return 0x9135;
    }
    if (strcmp(str, "GL_MAX_SAMPLES_NV") == 0)
    {
        return 0x8D57;
    }
    if (strcmp(str, "GL_MAX_SAMPLE_MASK_WORDS") == 0)
    {
        return 0x8E59;
    }
    if (strcmp(str, "GL_MAX_SAMPLE_MASK_WORDS_NV") == 0)
    {
        return 0x8E59;
    }
    if (strcmp(str, "GL_MAX_SERVER_WAIT_TIMEOUT") == 0)
    {
        return 0x9111;
    }
    if (strcmp(str, "GL_MAX_SERVER_WAIT_TIMEOUT_APPLE") == 0)
    {
        return 0x9111;
    }
    if (strcmp(str, "GL_MAX_SHADER_BUFFER_ADDRESS_NV") == 0)
    {
        return 0x8F35;
    }
    if (strcmp(str, "GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_FAST_SIZE_EXT") == 0)
    {
        return 0x9650;
    }
    if (strcmp(str, "GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_SIZE_EXT") == 0)
    {
        return 0x9651;
    }
    if (strcmp(str, "GL_MAX_SHADER_COMPILER_THREADS_ARB") == 0)
    {
        return 0x91B0;
    }
    if (strcmp(str, "GL_MAX_SHADER_COMPILER_THREADS_KHR") == 0)
    {
        return 0x91B0;
    }
    if (strcmp(str, "GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_FAST_SIZE_EXT") == 0)
    {
        return 0x8F63;
    }
    if (strcmp(str, "GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_SIZE_EXT") == 0)
    {
        return 0x8F67;
    }
    if (strcmp(str, "GL_MAX_SHADER_STORAGE_BLOCK_SIZE") == 0)
    {
        return 0x90DE;
    }
    if (strcmp(str, "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS") == 0)
    {
        return 0x90DD;
    }
    if (strcmp(str, "GL_MAX_SHADER_SUBSAMPLED_IMAGE_UNITS_QCOM") == 0)
    {
        return 0x8FA1;
    }
    if (strcmp(str, "GL_MAX_SHININESS_NV") == 0)
    {
        return 0x8504;
    }
    if (strcmp(str, "GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD") == 0)
    {
        return 0x9199;
    }
    if (strcmp(str, "GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB") == 0)
    {
        return 0x9199;
    }
    if (strcmp(str, "GL_MAX_SPARSE_3D_TEXTURE_SIZE_EXT") == 0)
    {
        return 0x9199;
    }
    if (strcmp(str, "GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS") == 0)
    {
        return 0x919A;
    }
    if (strcmp(str, "GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB") == 0)
    {
        return 0x919A;
    }
    if (strcmp(str, "GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_EXT") == 0)
    {
        return 0x919A;
    }
    if (strcmp(str, "GL_MAX_SPARSE_TEXTURE_SIZE_AMD") == 0)
    {
        return 0x9198;
    }
    if (strcmp(str, "GL_MAX_SPARSE_TEXTURE_SIZE_ARB") == 0)
    {
        return 0x9198;
    }
    if (strcmp(str, "GL_MAX_SPARSE_TEXTURE_SIZE_EXT") == 0)
    {
        return 0x9198;
    }
    if (strcmp(str, "GL_MAX_SPOT_EXPONENT_NV") == 0)
    {
        return 0x8505;
    }
    if (strcmp(str, "GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV") == 0)
    {
        return 0x9349;
    }
    if (strcmp(str, "GL_MAX_SUBROUTINES") == 0)
    {
        return 0x8DE7;
    }
    if (strcmp(str, "GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS") == 0)
    {
        return 0x8DE8;
    }
    if (strcmp(str, "GL_MAX_TASK_ATOMIC_COUNTERS_NV") == 0)
    {
        return 0x8E6D;
    }
    if (strcmp(str, "GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_NV") == 0)
    {
        return 0x8E6C;
    }
    if (strcmp(str, "GL_MAX_TASK_IMAGE_UNIFORMS_NV") == 0)
    {
        return 0x8E6A;
    }
    if (strcmp(str, "GL_MAX_TASK_OUTPUT_COUNT_NV") == 0)
    {
        return 0x953A;
    }
    if (strcmp(str, "GL_MAX_TASK_SHADER_STORAGE_BLOCKS_NV") == 0)
    {
        return 0x8E6E;
    }
    if (strcmp(str, "GL_MAX_TASK_TEXTURE_IMAGE_UNITS_NV") == 0)
    {
        return 0x8E69;
    }
    if (strcmp(str, "GL_MAX_TASK_TOTAL_MEMORY_SIZE_NV") == 0)
    {
        return 0x9537;
    }
    if (strcmp(str, "GL_MAX_TASK_UNIFORM_BLOCKS_NV") == 0)
    {
        return 0x8E68;
    }
    if (strcmp(str, "GL_MAX_TASK_UNIFORM_COMPONENTS_NV") == 0)
    {
        return 0x8E6B;
    }
    if (strcmp(str, "GL_MAX_TASK_WORK_GROUP_INVOCATIONS_NV") == 0)
    {
        return 0x95A3;
    }
    if (strcmp(str, "GL_MAX_TASK_WORK_GROUP_SIZE_NV") == 0)
    {
        return 0x953C;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS") == 0)
    {
        return 0x92D3;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT") == 0)
    {
        return 0x92D3;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_OES") == 0)
    {
        return 0x92D3;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS") == 0)
    {
        return 0x92CD;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT") == 0)
    {
        return 0x92CD;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_OES") == 0)
    {
        return 0x92CD;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS") == 0)
    {
        return 0x90CB;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT") == 0)
    {
        return 0x90CB;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_OES") == 0)
    {
        return 0x90CB;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS") == 0)
    {
        return 0x886C;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT") == 0)
    {
        return 0x886C;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_OES") == 0)
    {
        return 0x886C;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS") == 0)
    {
        return 0x8E83;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT") == 0)
    {
        return 0x8E83;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_OES") == 0)
    {
        return 0x8E83;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS") == 0)
    {
        return 0x90D8;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT") == 0)
    {
        return 0x90D8;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_OES") == 0)
    {
        return 0x90D8;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS") == 0)
    {
        return 0x8E81;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT") == 0)
    {
        return 0x8E81;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_OES") == 0)
    {
        return 0x8E81;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS") == 0)
    {
        return 0x8E85;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT") == 0)
    {
        return 0x8E85;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_OES") == 0)
    {
        return 0x8E85;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS") == 0)
    {
        return 0x8E89;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT") == 0)
    {
        return 0x8E89;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_OES") == 0)
    {
        return 0x8E89;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8E7F;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT") == 0)
    {
        return 0x8E7F;
    }
    if (strcmp(str, "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_OES") == 0)
    {
        return 0x8E7F;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS") == 0)
    {
        return 0x92D4;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT") == 0)
    {
        return 0x92D4;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_OES") == 0)
    {
        return 0x92D4;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS") == 0)
    {
        return 0x92CE;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT") == 0)
    {
        return 0x92CE;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_OES") == 0)
    {
        return 0x92CE;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS") == 0)
    {
        return 0x90CC;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT") == 0)
    {
        return 0x90CC;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_OES") == 0)
    {
        return 0x90CC;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS") == 0)
    {
        return 0x886D;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT") == 0)
    {
        return 0x886D;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_OES") == 0)
    {
        return 0x886D;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS") == 0)
    {
        return 0x8E86;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT") == 0)
    {
        return 0x8E86;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_OES") == 0)
    {
        return 0x8E86;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS") == 0)
    {
        return 0x90D9;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT") == 0)
    {
        return 0x90D9;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_OES") == 0)
    {
        return 0x90D9;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS") == 0)
    {
        return 0x8E82;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT") == 0)
    {
        return 0x8E82;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_OES") == 0)
    {
        return 0x8E82;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS") == 0)
    {
        return 0x8E8A;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT") == 0)
    {
        return 0x8E8A;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_OES") == 0)
    {
        return 0x8E8A;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8E80;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT") == 0)
    {
        return 0x8E80;
    }
    if (strcmp(str, "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_OES") == 0)
    {
        return 0x8E80;
    }
    if (strcmp(str, "GL_MAX_TESS_GEN_LEVEL") == 0)
    {
        return 0x8E7E;
    }
    if (strcmp(str, "GL_MAX_TESS_GEN_LEVEL_EXT") == 0)
    {
        return 0x8E7E;
    }
    if (strcmp(str, "GL_MAX_TESS_GEN_LEVEL_OES") == 0)
    {
        return 0x8E7E;
    }
    if (strcmp(str, "GL_MAX_TESS_PATCH_COMPONENTS") == 0)
    {
        return 0x8E84;
    }
    if (strcmp(str, "GL_MAX_TESS_PATCH_COMPONENTS_EXT") == 0)
    {
        return 0x8E84;
    }
    if (strcmp(str, "GL_MAX_TESS_PATCH_COMPONENTS_OES") == 0)
    {
        return 0x8E84;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_BUFFER_SIZE") == 0)
    {
        return 0x8C2B;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_BUFFER_SIZE_ARB") == 0)
    {
        return 0x8C2B;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_BUFFER_SIZE_EXT") == 0)
    {
        return 0x8C2B;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_BUFFER_SIZE_OES") == 0)
    {
        return 0x8C2B;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_COORDS") == 0)
    {
        return 0x8871;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_COORDS_ARB") == 0)
    {
        return 0x8871;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_COORDS_NV") == 0)
    {
        return 0x8871;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_IMAGE_UNITS") == 0)
    {
        return 0x8872;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_IMAGE_UNITS_ARB") == 0)
    {
        return 0x8872;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_IMAGE_UNITS_NV") == 0)
    {
        return 0x8872;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_LOD_BIAS") == 0)
    {
        return 0x84FD;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_LOD_BIAS_EXT") == 0)
    {
        return 0x84FD;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_MAX_ANISOTROPY") == 0)
    {
        return 0x84FF;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT") == 0)
    {
        return 0x84FF;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_SIZE") == 0)
    {
        return 0x0D33;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_STACK_DEPTH") == 0)
    {
        return 0x0D39;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_UNITS") == 0)
    {
        return 0x84E2;
    }
    if (strcmp(str, "GL_MAX_TEXTURE_UNITS_ARB") == 0)
    {
        return 0x84E2;
    }
    if (strcmp(str, "GL_MAX_TIMELINE_SEMAPHORE_VALUE_DIFFERENCE_NV") == 0)
    {
        return 0x95B6;
    }
    if (strcmp(str, "GL_MAX_TRACK_MATRICES_NV") == 0)
    {
        return 0x862F;
    }
    if (strcmp(str, "GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV") == 0)
    {
        return 0x862E;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_BUFFERS") == 0)
    {
        return 0x8E70;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS") == 0)
    {
        return 0x8C8A;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT") == 0)
    {
        return 0x8C8A;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV") == 0)
    {
        return 0x8C8A;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS") == 0)
    {
        return 0x8C8B;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT") == 0)
    {
        return 0x8C8B;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV") == 0)
    {
        return 0x8C8B;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS") == 0)
    {
        return 0x8C80;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT") == 0)
    {
        return 0x8C80;
    }
    if (strcmp(str, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV") == 0)
    {
        return 0x8C80;
    }
    if (strcmp(str, "GL_MAX_UNIFORM_BLOCK_SIZE") == 0)
    {
        return 0x8A30;
    }
    if (strcmp(str, "GL_MAX_UNIFORM_BUFFER_BINDINGS") == 0)
    {
        return 0x8A2F;
    }
    if (strcmp(str, "GL_MAX_UNIFORM_LOCATIONS") == 0)
    {
        return 0x826E;
    }
    if (strcmp(str, "GL_MAX_VARYING_COMPONENTS") == 0)
    {
        return 0x8B4B;
    }
    if (strcmp(str, "GL_MAX_VARYING_COMPONENTS_EXT") == 0)
    {
        return 0x8B4B;
    }
    if (strcmp(str, "GL_MAX_VARYING_FLOATS") == 0)
    {
        return 0x8B4B;
    }
    if (strcmp(str, "GL_MAX_VARYING_FLOATS_ARB") == 0)
    {
        return 0x8B4B;
    }
    if (strcmp(str, "GL_MAX_VARYING_VECTORS") == 0)
    {
        return 0x8DFC;
    }
    if (strcmp(str, "GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV") == 0)
    {
        return 0x8520;
    }
    if (strcmp(str, "GL_MAX_VERTEX_ATOMIC_COUNTERS") == 0)
    {
        return 0x92D2;
    }
    if (strcmp(str, "GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS") == 0)
    {
        return 0x92CC;
    }
    if (strcmp(str, "GL_MAX_VERTEX_ATTRIBS") == 0)
    {
        return 0x8869;
    }
    if (strcmp(str, "GL_MAX_VERTEX_ATTRIBS_ARB") == 0)
    {
        return 0x8869;
    }
    if (strcmp(str, "GL_MAX_VERTEX_ATTRIB_BINDINGS") == 0)
    {
        return 0x82DA;
    }
    if (strcmp(str, "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET") == 0)
    {
        return 0x82D9;
    }
    if (strcmp(str, "GL_MAX_VERTEX_ATTRIB_STRIDE") == 0)
    {
        return 0x82E5;
    }
    if (strcmp(str, "GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT") == 0)
    {
        return 0x8DE2;
    }
    if (strcmp(str, "GL_MAX_VERTEX_HINT_PGI") == 0)
    {
        return 0x1A22D;
    }
    if (strcmp(str, "GL_MAX_VERTEX_IMAGE_UNIFORMS") == 0)
    {
        return 0x90CA;
    }
    if (strcmp(str, "GL_MAX_VERTEX_OUTPUT_COMPONENTS") == 0)
    {
        return 0x9122;
    }
    if (strcmp(str, "GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT") == 0)
    {
        return 0x87C5;
    }
    if (strcmp(str, "GL_MAX_VERTEX_SHADER_INVARIANTS_EXT") == 0)
    {
        return 0x87C7;
    }
    if (strcmp(str, "GL_MAX_VERTEX_SHADER_LOCALS_EXT") == 0)
    {
        return 0x87C9;
    }
    if (strcmp(str, "GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT") == 0)
    {
        return 0x87C8;
    }
    if (strcmp(str, "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS") == 0)
    {
        return 0x90D6;
    }
    if (strcmp(str, "GL_MAX_VERTEX_SHADER_VARIANTS_EXT") == 0)
    {
        return 0x87C6;
    }
    if (strcmp(str, "GL_MAX_VERTEX_STREAMS") == 0)
    {
        return 0x8E71;
    }
    if (strcmp(str, "GL_MAX_VERTEX_STREAMS_ATI") == 0)
    {
        return 0x876B;
    }
    if (strcmp(str, "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS") == 0)
    {
        return 0x8B4C;
    }
    if (strcmp(str, "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB") == 0)
    {
        return 0x8B4C;
    }
    if (strcmp(str, "GL_MAX_VERTEX_UNIFORM_BLOCKS") == 0)
    {
        return 0x8A2B;
    }
    if (strcmp(str, "GL_MAX_VERTEX_UNIFORM_COMPONENTS") == 0)
    {
        return 0x8B4A;
    }
    if (strcmp(str, "GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB") == 0)
    {
        return 0x8B4A;
    }
    if (strcmp(str, "GL_MAX_VERTEX_UNIFORM_VECTORS") == 0)
    {
        return 0x8DFB;
    }
    if (strcmp(str, "GL_MAX_VERTEX_UNITS_ARB") == 0)
    {
        return 0x86A4;
    }
    if (strcmp(str, "GL_MAX_VERTEX_UNITS_OES") == 0)
    {
        return 0x86A4;
    }
    if (strcmp(str, "GL_MAX_VERTEX_VARYING_COMPONENTS_ARB") == 0)
    {
        return 0x8DDE;
    }
    if (strcmp(str, "GL_MAX_VERTEX_VARYING_COMPONENTS_EXT") == 0)
    {
        return 0x8DDE;
    }
    if (strcmp(str, "GL_MAX_VIEWPORTS") == 0)
    {
        return 0x825B;
    }
    if (strcmp(str, "GL_MAX_VIEWPORTS_NV") == 0)
    {
        return 0x825B;
    }
    if (strcmp(str, "GL_MAX_VIEWPORTS_OES") == 0)
    {
        return 0x825B;
    }
    if (strcmp(str, "GL_MAX_VIEWPORT_DIMS") == 0)
    {
        return 0x0D3A;
    }
    if (strcmp(str, "GL_MAX_VIEWS_OVR") == 0)
    {
        return 0x9631;
    }
    if (strcmp(str, "GL_MAX_WIDTH") == 0)
    {
        return 0x827E;
    }
    if (strcmp(str, "GL_MAX_WINDOW_RECTANGLES_EXT") == 0)
    {
        return 0x8F14;
    }
    if (strcmp(str, "GL_MEDIUM_FLOAT") == 0)
    {
        return 0x8DF1;
    }
    if (strcmp(str, "GL_MEDIUM_INT") == 0)
    {
        return 0x8DF4;
    }
    if (strcmp(str, "GL_MEMORY_ATTACHABLE_ALIGNMENT_NV") == 0)
    {
        return 0x95A6;
    }
    if (strcmp(str, "GL_MEMORY_ATTACHABLE_NV") == 0)
    {
        return 0x95A8;
    }
    if (strcmp(str, "GL_MEMORY_ATTACHABLE_SIZE_NV") == 0)
    {
        return 0x95A7;
    }
    if (strcmp(str, "GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_NV") == 0)
    {
        return 0x9543;
    }
    if (strcmp(str, "GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_NV") == 0)
    {
        return 0x92DF;
    }
    if (strcmp(str, "GL_MESH_OUTPUT_TYPE_NV") == 0)
    {
        return 0x957B;
    }
    if (strcmp(str, "GL_MESH_PRIMITIVES_OUT_NV") == 0)
    {
        return 0x957A;
    }
    if (strcmp(str, "GL_MESH_SHADER_BIT_NV") == 0)
    {
        return 0x0040;
    }
    if (strcmp(str, "GL_MESH_SHADER_NV") == 0)
    {
        return 0x9559;
    }
    if (strcmp(str, "GL_MESH_SUBROUTINE_NV") == 0)
    {
        return 0x957C;
    }
    if (strcmp(str, "GL_MESH_SUBROUTINE_UNIFORM_NV") == 0)
    {
        return 0x957E;
    }
    if (strcmp(str, "GL_MESH_VERTICES_OUT_NV") == 0)
    {
        return 0x9579;
    }
    if (strcmp(str, "GL_MESH_WORK_GROUP_SIZE_NV") == 0)
    {
        return 0x953E;
    }
    if (strcmp(str, "GL_MIN") == 0)
    {
        return 0x8007;
    }
    if (strcmp(str, "GL_MINMAX") == 0)
    {
        return 0x802E;
    }
    if (strcmp(str, "GL_MINMAX_EXT") == 0)
    {
        return 0x802E;
    }
    if (strcmp(str, "GL_MINMAX_FORMAT") == 0)
    {
        return 0x802F;
    }
    if (strcmp(str, "GL_MINMAX_FORMAT_EXT") == 0)
    {
        return 0x802F;
    }
    if (strcmp(str, "GL_MINMAX_SINK") == 0)
    {
        return 0x8030;
    }
    if (strcmp(str, "GL_MINMAX_SINK_EXT") == 0)
    {
        return 0x8030;
    }
    if (strcmp(str, "GL_MINOR_VERSION") == 0)
    {
        return 0x821C;
    }
    if (strcmp(str, "GL_MINUS_CLAMPED_NV") == 0)
    {
        return 0x92B3;
    }
    if (strcmp(str, "GL_MINUS_NV") == 0)
    {
        return 0x929F;
    }
    if (strcmp(str, "GL_MIN_EXT") == 0)
    {
        return 0x8007;
    }
    if (strcmp(str, "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET") == 0)
    {
        return 0x8E5B;
    }
    if (strcmp(str, "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV") == 0)
    {
        return 0x8E5B;
    }
    if (strcmp(str, "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES") == 0)
    {
        return 0x8E5B;
    }
    if (strcmp(str, "GL_MIN_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_HEIGHT_EXT") == 0)
    {
        return 0x96D9;
    }
    if (strcmp(str, "GL_MIN_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_WIDTH_EXT") == 0)
    {
        return 0x96D7;
    }
    if (strcmp(str, "GL_MIN_LOD_WARNING_AMD") == 0)
    {
        return 0x919C;
    }
    if (strcmp(str, "GL_MIN_MAP_BUFFER_ALIGNMENT") == 0)
    {
        return 0x90BC;
    }
    if (strcmp(str, "GL_MIN_PROGRAM_TEXEL_OFFSET") == 0)
    {
        return 0x8904;
    }
    if (strcmp(str, "GL_MIN_PROGRAM_TEXEL_OFFSET_EXT") == 0)
    {
        return 0x8904;
    }
    if (strcmp(str, "GL_MIN_PROGRAM_TEXEL_OFFSET_NV") == 0)
    {
        return 0x8904;
    }
    if (strcmp(str, "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET") == 0)
    {
        return 0x8E5E;
    }
    if (strcmp(str, "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB") == 0)
    {
        return 0x8E5E;
    }
    if (strcmp(str, "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV") == 0)
    {
        return 0x8E5E;
    }
    if (strcmp(str, "GL_MIN_SAMPLE_SHADING_VALUE") == 0)
    {
        return 0x8C37;
    }
    if (strcmp(str, "GL_MIN_SAMPLE_SHADING_VALUE_ARB") == 0)
    {
        return 0x8C37;
    }
    if (strcmp(str, "GL_MIN_SAMPLE_SHADING_VALUE_OES") == 0)
    {
        return 0x8C37;
    }
    if (strcmp(str, "GL_MIN_SPARSE_LEVEL_AMD") == 0)
    {
        return 0x919B;
    }
    if (strcmp(str, "GL_MIPMAP") == 0)
    {
        return 0x8293;
    }
    if (strcmp(str, "GL_MIRRORED_REPEAT") == 0)
    {
        return 0x8370;
    }
    if (strcmp(str, "GL_MIRRORED_REPEAT_ARB") == 0)
    {
        return 0x8370;
    }
    if (strcmp(str, "GL_MIRRORED_REPEAT_IBM") == 0)
    {
        return 0x8370;
    }
    if (strcmp(str, "GL_MIRRORED_REPEAT_OES") == 0)
    {
        return 0x8370;
    }
    if (strcmp(str, "GL_MIRROR_CLAMP_ATI") == 0)
    {
        return 0x8742;
    }
    if (strcmp(str, "GL_MIRROR_CLAMP_EXT") == 0)
    {
        return 0x8742;
    }
    if (strcmp(str, "GL_MIRROR_CLAMP_TO_BORDER_EXT") == 0)
    {
        return 0x8912;
    }
    if (strcmp(str, "GL_MIRROR_CLAMP_TO_EDGE") == 0)
    {
        return 0x8743;
    }
    if (strcmp(str, "GL_MIRROR_CLAMP_TO_EDGE_ATI") == 0)
    {
        return 0x8743;
    }
    if (strcmp(str, "GL_MIRROR_CLAMP_TO_EDGE_EXT") == 0)
    {
        return 0x8743;
    }
    if (strcmp(str, "GL_MITER_REVERT_NV") == 0)
    {
        return 0x90A7;
    }
    if (strcmp(str, "GL_MITER_TRUNCATE_NV") == 0)
    {
        return 0x90A8;
    }
    if (strcmp(str, "GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV") == 0)
    {
        return 0x932F;
    }
    if (strcmp(str, "GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV") == 0)
    {
        return 0x9330;
    }
    if (strcmp(str, "GL_MODELVIEW") == 0)
    {
        return 0x1700;
    }
    if (strcmp(str, "GL_MODELVIEW0_ARB") == 0)
    {
        return 0x1700;
    }
    if (strcmp(str, "GL_MODELVIEW0_EXT") == 0)
    {
        return 0x1700;
    }
    if (strcmp(str, "GL_MODELVIEW0_MATRIX_EXT") == 0)
    {
        return 0x0BA6;
    }
    if (strcmp(str, "GL_MODELVIEW0_STACK_DEPTH_EXT") == 0)
    {
        return 0x0BA3;
    }
    if (strcmp(str, "GL_MODELVIEW10_ARB") == 0)
    {
        return 0x872A;
    }
    if (strcmp(str, "GL_MODELVIEW11_ARB") == 0)
    {
        return 0x872B;
    }
    if (strcmp(str, "GL_MODELVIEW12_ARB") == 0)
    {
        return 0x872C;
    }
    if (strcmp(str, "GL_MODELVIEW13_ARB") == 0)
    {
        return 0x872D;
    }
    if (strcmp(str, "GL_MODELVIEW14_ARB") == 0)
    {
        return 0x872E;
    }
    if (strcmp(str, "GL_MODELVIEW15_ARB") == 0)
    {
        return 0x872F;
    }
    if (strcmp(str, "GL_MODELVIEW16_ARB") == 0)
    {
        return 0x8730;
    }
    if (strcmp(str, "GL_MODELVIEW17_ARB") == 0)
    {
        return 0x8731;
    }
    if (strcmp(str, "GL_MODELVIEW18_ARB") == 0)
    {
        return 0x8732;
    }
    if (strcmp(str, "GL_MODELVIEW19_ARB") == 0)
    {
        return 0x8733;
    }
    if (strcmp(str, "GL_MODELVIEW1_ARB") == 0)
    {
        return 0x850A;
    }
    if (strcmp(str, "GL_MODELVIEW1_EXT") == 0)
    {
        return 0x850A;
    }
    if (strcmp(str, "GL_MODELVIEW1_MATRIX_EXT") == 0)
    {
        return 0x8506;
    }
    if (strcmp(str, "GL_MODELVIEW1_STACK_DEPTH_EXT") == 0)
    {
        return 0x8502;
    }
    if (strcmp(str, "GL_MODELVIEW20_ARB") == 0)
    {
        return 0x8734;
    }
    if (strcmp(str, "GL_MODELVIEW21_ARB") == 0)
    {
        return 0x8735;
    }
    if (strcmp(str, "GL_MODELVIEW22_ARB") == 0)
    {
        return 0x8736;
    }
    if (strcmp(str, "GL_MODELVIEW23_ARB") == 0)
    {
        return 0x8737;
    }
    if (strcmp(str, "GL_MODELVIEW24_ARB") == 0)
    {
        return 0x8738;
    }
    if (strcmp(str, "GL_MODELVIEW25_ARB") == 0)
    {
        return 0x8739;
    }
    if (strcmp(str, "GL_MODELVIEW26_ARB") == 0)
    {
        return 0x873A;
    }
    if (strcmp(str, "GL_MODELVIEW27_ARB") == 0)
    {
        return 0x873B;
    }
    if (strcmp(str, "GL_MODELVIEW28_ARB") == 0)
    {
        return 0x873C;
    }
    if (strcmp(str, "GL_MODELVIEW29_ARB") == 0)
    {
        return 0x873D;
    }
    if (strcmp(str, "GL_MODELVIEW2_ARB") == 0)
    {
        return 0x8722;
    }
    if (strcmp(str, "GL_MODELVIEW30_ARB") == 0)
    {
        return 0x873E;
    }
    if (strcmp(str, "GL_MODELVIEW31_ARB") == 0)
    {
        return 0x873F;
    }
    if (strcmp(str, "GL_MODELVIEW3_ARB") == 0)
    {
        return 0x8723;
    }
    if (strcmp(str, "GL_MODELVIEW4_ARB") == 0)
    {
        return 0x8724;
    }
    if (strcmp(str, "GL_MODELVIEW5_ARB") == 0)
    {
        return 0x8725;
    }
    if (strcmp(str, "GL_MODELVIEW6_ARB") == 0)
    {
        return 0x8726;
    }
    if (strcmp(str, "GL_MODELVIEW7_ARB") == 0)
    {
        return 0x8727;
    }
    if (strcmp(str, "GL_MODELVIEW8_ARB") == 0)
    {
        return 0x8728;
    }
    if (strcmp(str, "GL_MODELVIEW9_ARB") == 0)
    {
        return 0x8729;
    }
    if (strcmp(str, "GL_MODELVIEW_MATRIX") == 0)
    {
        return 0x0BA6;
    }
    if (strcmp(str, "GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES") == 0)
    {
        return 0x898D;
    }
    if (strcmp(str, "GL_MODELVIEW_PROJECTION_NV") == 0)
    {
        return 0x8629;
    }
    if (strcmp(str, "GL_MODELVIEW_STACK_DEPTH") == 0)
    {
        return 0x0BA3;
    }
    if (strcmp(str, "GL_MODULATE") == 0)
    {
        return 0x2100;
    }
    if (strcmp(str, "GL_MODULATE_ADD_ATI") == 0)
    {
        return 0x8744;
    }
    if (strcmp(str, "GL_MODULATE_COLOR_IMG") == 0)
    {
        return 0x8C04;
    }
    if (strcmp(str, "GL_MODULATE_SIGNED_ADD_ATI") == 0)
    {
        return 0x8745;
    }
    if (strcmp(str, "GL_MODULATE_SUBTRACT_ATI") == 0)
    {
        return 0x8746;
    }
    if (strcmp(str, "GL_MOTION_ESTIMATION_SEARCH_BLOCK_X_QCOM") == 0)
    {
        return 0x8C90;
    }
    if (strcmp(str, "GL_MOTION_ESTIMATION_SEARCH_BLOCK_Y_QCOM") == 0)
    {
        return 0x8C91;
    }
    if (strcmp(str, "GL_MOVE_TO_CONTINUES_NV") == 0)
    {
        return 0x90B6;
    }
    if (strcmp(str, "GL_MOVE_TO_NV") == 0)
    {
        return 0x0002;
    }
    if (strcmp(str, "GL_MOVE_TO_RESETS_NV") == 0)
    {
        return 0x90B5;
    }
    if (strcmp(str, "GL_MOV_ATI") == 0)
    {
        return 0x8961;
    }
    if (strcmp(str, "GL_MULT") == 0)
    {
        return 0x0103;
    }
    if (strcmp(str, "GL_MULTICAST_GPUS_NV") == 0)
    {
        return 0x92BA;
    }
    if (strcmp(str, "GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV") == 0)
    {
        return 0x9549;
    }
    if (strcmp(str, "GL_MULTIPLY") == 0)
    {
        return 0x9294;
    }
    if (strcmp(str, "GL_MULTIPLY_KHR") == 0)
    {
        return 0x9294;
    }
    if (strcmp(str, "GL_MULTIPLY_NV") == 0)
    {
        return 0x9294;
    }
    if (strcmp(str, "GL_MULTISAMPLE") == 0)
    {
        return 0x809D;
    }
    if (strcmp(str, "GL_MULTISAMPLES_NV") == 0)
    {
        return 0x9371;
    }
    if (strcmp(str, "GL_MULTISAMPLE_3DFX") == 0)
    {
        return 0x86B2;
    }
    if (strcmp(str, "GL_MULTISAMPLE_ARB") == 0)
    {
        return 0x809D;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BIT") == 0)
    {
        return 0x20000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BIT_3DFX") == 0)
    {
        return 0x20000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BIT_ARB") == 0)
    {
        return 0x20000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BIT_EXT") == 0)
    {
        return 0x20000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BUFFER_BIT0_QCOM") == 0)
    {
        return 0x1000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BUFFER_BIT1_QCOM") == 0)
    {
        return 0x2000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BUFFER_BIT2_QCOM") == 0)
    {
        return 0x4000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BUFFER_BIT3_QCOM") == 0)
    {
        return 0x8000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BUFFER_BIT4_QCOM") == 0)
    {
        return 0x10000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BUFFER_BIT5_QCOM") == 0)
    {
        return 0x20000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BUFFER_BIT6_QCOM") == 0)
    {
        return 0x40000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_BUFFER_BIT7_QCOM") == 0)
    {
        return 0x80000000;
    }
    if (strcmp(str, "GL_MULTISAMPLE_COVERAGE_MODES_NV") == 0)
    {
        return 0x8E12;
    }
    if (strcmp(str, "GL_MULTISAMPLE_EXT") == 0)
    {
        return 0x809D;
    }
    if (strcmp(str, "GL_MULTISAMPLE_FILTER_HINT_NV") == 0)
    {
        return 0x8534;
    }
    if (strcmp(str, "GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY") == 0)
    {
        return 0x9382;
    }
    if (strcmp(str, "GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB") == 0)
    {
        return 0x9382;
    }
    if (strcmp(str, "GL_MULTISAMPLE_LINE_WIDTH_RANGE") == 0)
    {
        return 0x9381;
    }
    if (strcmp(str, "GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB") == 0)
    {
        return 0x9381;
    }
    if (strcmp(str, "GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT") == 0)
    {
        return 0x932B;
    }
    if (strcmp(str, "GL_MULTISAMPLE_SGIS") == 0)
    {
        return 0x809D;
    }
    if (strcmp(str, "GL_MULTIVIEW_EXT") == 0)
    {
        return 0x90F1;
    }
    if (strcmp(str, "GL_MUL_ATI") == 0)
    {
        return 0x8964;
    }
    if (strcmp(str, "GL_MVP_MATRIX_EXT") == 0)
    {
        return 0x87E3;
    }
    if (strcmp(str, "GL_N3F_V3F") == 0)
    {
        return 0x2A25;
    }
    if (strcmp(str, "GL_NAMED_STRING_LENGTH_ARB") == 0)
    {
        return 0x8DE9;
    }
    if (strcmp(str, "GL_NAMED_STRING_TYPE_ARB") == 0)
    {
        return 0x8DEA;
    }
    if (strcmp(str, "GL_NAME_LENGTH") == 0)
    {
        return 0x92F9;
    }
    if (strcmp(str, "GL_NAME_STACK_DEPTH") == 0)
    {
        return 0x0D70;
    }
    if (strcmp(str, "GL_NAND") == 0)
    {
        return 0x150E;
    }
    if (strcmp(str, "GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI") == 0)
    {
        return 0x1A203;
    }
    if (strcmp(str, "GL_NATIVE_GRAPHICS_END_HINT_PGI") == 0)
    {
        return 0x1A204;
    }
    if (strcmp(str, "GL_NATIVE_GRAPHICS_HANDLE_PGI") == 0)
    {
        return 0x1A202;
    }
    if (strcmp(str, "GL_NEAREST") == 0)
    {
        return 0x2600;
    }
    if (strcmp(str, "GL_NEAREST_CLIPMAP_LINEAR_SGIX") == 0)
    {
        return 0x844E;
    }
    if (strcmp(str, "GL_NEAREST_CLIPMAP_NEAREST_SGIX") == 0)
    {
        return 0x844D;
    }
    if (strcmp(str, "GL_NEAREST_MIPMAP_LINEAR") == 0)
    {
        return 0x2702;
    }
    if (strcmp(str, "GL_NEAREST_MIPMAP_NEAREST") == 0)
    {
        return 0x2700;
    }
    if (strcmp(str, "GL_NEGATE_BIT_ATI") == 0)
    {
        return 0x0004;
    }
    if (strcmp(str, "GL_NEGATIVE_ONE_EXT") == 0)
    {
        return 0x87DF;
    }
    if (strcmp(str, "GL_NEGATIVE_ONE_TO_ONE") == 0)
    {
        return 0x935E;
    }
    if (strcmp(str, "GL_NEGATIVE_ONE_TO_ONE_EXT") == 0)
    {
        return 0x935E;
    }
    if (strcmp(str, "GL_NEGATIVE_W_EXT") == 0)
    {
        return 0x87DC;
    }
    if (strcmp(str, "GL_NEGATIVE_X_EXT") == 0)
    {
        return 0x87D9;
    }
    if (strcmp(str, "GL_NEGATIVE_Y_EXT") == 0)
    {
        return 0x87DA;
    }
    if (strcmp(str, "GL_NEGATIVE_Z_EXT") == 0)
    {
        return 0x87DB;
    }
    if (strcmp(str, "GL_NEVER") == 0)
    {
        return 0x0200;
    }
    if (strcmp(str, "GL_NEXT_BUFFER_NV") == 0)
    {
        return -2;
    }
    if (strcmp(str, "GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV") == 0)
    {
        return 0x9025;
    }
    if (strcmp(str, "GL_NICEST") == 0)
    {
        return 0x1102;
    }
    if (strcmp(str, "GL_NONE") == 0)
    {
        return 0x0000;
    }
    if (strcmp(str, "GL_NONE_OES") == 0)
    {
        return 0x0000;
    }
    if (strcmp(str, "GL_NOOP") == 0)
    {
        return 0x1505;
    }
    if (strcmp(str, "GL_NOP_COMMAND_NV") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_NOR") == 0)
    {
        return 0x1508;
    }
    if (strcmp(str, "GL_NORMALIZE") == 0)
    {
        return 0x0BA1;
    }
    if (strcmp(str, "GL_NORMALIZED_RANGE_EXT") == 0)
    {
        return 0x87E0;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY") == 0)
    {
        return 0x8075;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_ADDRESS_NV") == 0)
    {
        return 0x8F22;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_BUFFER_BINDING") == 0)
    {
        return 0x8897;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_BUFFER_BINDING_ARB") == 0)
    {
        return 0x8897;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_COUNT_EXT") == 0)
    {
        return 0x8080;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_EXT") == 0)
    {
        return 0x8075;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_LENGTH_NV") == 0)
    {
        return 0x8F2C;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_LIST_IBM") == 0)
    {
        return 0x103071;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_LIST_STRIDE_IBM") == 0)
    {
        return 0x103081;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL") == 0)
    {
        return 0x83F6;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_POINTER") == 0)
    {
        return 0x808F;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_POINTER_EXT") == 0)
    {
        return 0x808F;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_STRIDE") == 0)
    {
        return 0x807F;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_STRIDE_EXT") == 0)
    {
        return 0x807F;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_TYPE") == 0)
    {
        return 0x807E;
    }
    if (strcmp(str, "GL_NORMAL_ARRAY_TYPE_EXT") == 0)
    {
        return 0x807E;
    }
    if (strcmp(str, "GL_NORMAL_BIT_PGI") == 0)
    {
        return 0x8000000;
    }
    if (strcmp(str, "GL_NORMAL_MAP") == 0)
    {
        return 0x8511;
    }
    if (strcmp(str, "GL_NORMAL_MAP_ARB") == 0)
    {
        return 0x8511;
    }
    if (strcmp(str, "GL_NORMAL_MAP_EXT") == 0)
    {
        return 0x8511;
    }
    if (strcmp(str, "GL_NORMAL_MAP_NV") == 0)
    {
        return 0x8511;
    }
    if (strcmp(str, "GL_NORMAL_MAP_OES") == 0)
    {
        return 0x8511;
    }
    if (strcmp(str, "GL_NOTEQUAL") == 0)
    {
        return 0x0205;
    }
    if (strcmp(str, "GL_NO_ERROR") == 0)
    {
        return 0x0000;
    }
    if (strcmp(str, "GL_NO_RESET_NOTIFICATION") == 0)
    {
        return 0x8261;
    }
    if (strcmp(str, "GL_NO_RESET_NOTIFICATION_ARB") == 0)
    {
        return 0x8261;
    }
    if (strcmp(str, "GL_NO_RESET_NOTIFICATION_EXT") == 0)
    {
        return 0x8261;
    }
    if (strcmp(str, "GL_NO_RESET_NOTIFICATION_KHR") == 0)
    {
        return 0x8261;
    }
    if (strcmp(str, "GL_NUM_ACTIVE_VARIABLES") == 0)
    {
        return 0x9304;
    }
    if (strcmp(str, "GL_NUM_COMPATIBLE_SUBROUTINES") == 0)
    {
        return 0x8E4A;
    }
    if (strcmp(str, "GL_NUM_COMPRESSED_TEXTURE_FORMATS") == 0)
    {
        return 0x86A2;
    }
    if (strcmp(str, "GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB") == 0)
    {
        return 0x86A2;
    }
    if (strcmp(str, "GL_NUM_DEVICE_UUIDS_EXT") == 0)
    {
        return 0x9596;
    }
    if (strcmp(str, "GL_NUM_DOWNSAMPLE_SCALES_IMG") == 0)
    {
        return 0x913D;
    }
    if (strcmp(str, "GL_NUM_EXTENSIONS") == 0)
    {
        return 0x821D;
    }
    if (strcmp(str, "GL_NUM_FILL_STREAMS_NV") == 0)
    {
        return 0x8E29;
    }
    if (strcmp(str, "GL_NUM_FRAGMENT_CONSTANTS_ATI") == 0)
    {
        return 0x896F;
    }
    if (strcmp(str, "GL_NUM_FRAGMENT_REGISTERS_ATI") == 0)
    {
        return 0x896E;
    }
    if (strcmp(str, "GL_NUM_GENERAL_COMBINERS_NV") == 0)
    {
        return 0x854E;
    }
    if (strcmp(str, "GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI") == 0)
    {
        return 0x8973;
    }
    if (strcmp(str, "GL_NUM_INSTRUCTIONS_PER_PASS_ATI") == 0)
    {
        return 0x8971;
    }
    if (strcmp(str, "GL_NUM_INSTRUCTIONS_TOTAL_ATI") == 0)
    {
        return 0x8972;
    }
    if (strcmp(str, "GL_NUM_LOOPBACK_COMPONENTS_ATI") == 0)
    {
        return 0x8974;
    }
    if (strcmp(str, "GL_NUM_PASSES_ATI") == 0)
    {
        return 0x8970;
    }
    if (strcmp(str, "GL_NUM_PROGRAM_BINARY_FORMATS") == 0)
    {
        return 0x87FE;
    }
    if (strcmp(str, "GL_NUM_PROGRAM_BINARY_FORMATS_OES") == 0)
    {
        return 0x87FE;
    }
    if (strcmp(str, "GL_NUM_SAMPLE_COUNTS") == 0)
    {
        return 0x9380;
    }
    if (strcmp(str, "GL_NUM_SHADER_BINARY_FORMATS") == 0)
    {
        return 0x8DF9;
    }
    if (strcmp(str, "GL_NUM_SHADING_LANGUAGE_VERSIONS") == 0)
    {
        return 0x82E9;
    }
    if (strcmp(str, "GL_NUM_SPARSE_LEVELS_ARB") == 0)
    {
        return 0x91AA;
    }
    if (strcmp(str, "GL_NUM_SPARSE_LEVELS_EXT") == 0)
    {
        return 0x91AA;
    }
    if (strcmp(str, "GL_NUM_SPIR_V_EXTENSIONS") == 0)
    {
        return 0x9554;
    }
    if (strcmp(str, "GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD") == 0)
    {
        return 0x91B6;
    }
    if (strcmp(str, "GL_NUM_SURFACE_COMPRESSION_FIXED_RATES_EXT") == 0)
    {
        return 0x8F6E;
    }
    if (strcmp(str, "GL_NUM_TILING_TYPES_EXT") == 0)
    {
        return 0x9582;
    }
    if (strcmp(str, "GL_NUM_VIDEO_CAPTURE_STREAMS_NV") == 0)
    {
        return 0x9024;
    }
    if (strcmp(str, "GL_NUM_VIRTUAL_PAGE_SIZES_ARB") == 0)
    {
        return 0x91A8;
    }
    if (strcmp(str, "GL_NUM_VIRTUAL_PAGE_SIZES_EXT") == 0)
    {
        return 0x91A8;
    }
    if (strcmp(str, "GL_NUM_WINDOW_RECTANGLES_EXT") == 0)
    {
        return 0x8F15;
    }
    if (strcmp(str, "GL_OBJECT_ACTIVE_ATTRIBUTES_ARB") == 0)
    {
        return 0x8B89;
    }
    if (strcmp(str, "GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB") == 0)
    {
        return 0x8B8A;
    }
    if (strcmp(str, "GL_OBJECT_ACTIVE_UNIFORMS_ARB") == 0)
    {
        return 0x8B86;
    }
    if (strcmp(str, "GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB") == 0)
    {
        return 0x8B87;
    }
    if (strcmp(str, "GL_OBJECT_ATTACHED_OBJECTS_ARB") == 0)
    {
        return 0x8B85;
    }
    if (strcmp(str, "GL_OBJECT_BUFFER_SIZE_ATI") == 0)
    {
        return 0x8764;
    }
    if (strcmp(str, "GL_OBJECT_BUFFER_USAGE_ATI") == 0)
    {
        return 0x8765;
    }
    if (strcmp(str, "GL_OBJECT_COMPILE_STATUS_ARB") == 0)
    {
        return 0x8B81;
    }
    if (strcmp(str, "GL_OBJECT_DELETE_STATUS_ARB") == 0)
    {
        return 0x8B80;
    }
    if (strcmp(str, "GL_OBJECT_DISTANCE_TO_LINE_SGIS") == 0)
    {
        return 0x81F3;
    }
    if (strcmp(str, "GL_OBJECT_DISTANCE_TO_POINT_SGIS") == 0)
    {
        return 0x81F1;
    }
    if (strcmp(str, "GL_OBJECT_INFO_LOG_LENGTH_ARB") == 0)
    {
        return 0x8B84;
    }
    if (strcmp(str, "GL_OBJECT_LINEAR") == 0)
    {
        return 0x2401;
    }
    if (strcmp(str, "GL_OBJECT_LINEAR_NV") == 0)
    {
        return 0x2401;
    }
    if (strcmp(str, "GL_OBJECT_LINE_SGIS") == 0)
    {
        return 0x81F7;
    }
    if (strcmp(str, "GL_OBJECT_LINK_STATUS_ARB") == 0)
    {
        return 0x8B82;
    }
    if (strcmp(str, "GL_OBJECT_PLANE") == 0)
    {
        return 0x2501;
    }
    if (strcmp(str, "GL_OBJECT_POINT_SGIS") == 0)
    {
        return 0x81F5;
    }
    if (strcmp(str, "GL_OBJECT_SHADER_SOURCE_LENGTH_ARB") == 0)
    {
        return 0x8B88;
    }
    if (strcmp(str, "GL_OBJECT_SUBTYPE_ARB") == 0)
    {
        return 0x8B4F;
    }
    if (strcmp(str, "GL_OBJECT_TYPE") == 0)
    {
        return 0x9112;
    }
    if (strcmp(str, "GL_OBJECT_TYPE_APPLE") == 0)
    {
        return 0x9112;
    }
    if (strcmp(str, "GL_OBJECT_TYPE_ARB") == 0)
    {
        return 0x8B4E;
    }
    if (strcmp(str, "GL_OBJECT_VALIDATE_STATUS_ARB") == 0)
    {
        return 0x8B83;
    }
    if (strcmp(str, "GL_OCCLUSION_QUERY_EVENT_MASK_AMD") == 0)
    {
        return 0x874F;
    }
    if (strcmp(str, "GL_OCCLUSION_TEST_HP") == 0)
    {
        return 0x8165;
    }
    if (strcmp(str, "GL_OCCLUSION_TEST_RESULT_HP") == 0)
    {
        return 0x8166;
    }
    if (strcmp(str, "GL_OFFSET") == 0)
    {
        return 0x92FC;
    }
    if (strcmp(str, "GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV") == 0)
    {
        return 0x8856;
    }
    if (strcmp(str, "GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV") == 0)
    {
        return 0x8857;
    }
    if (strcmp(str, "GL_OFFSET_HILO_TEXTURE_2D_NV") == 0)
    {
        return 0x8854;
    }
    if (strcmp(str, "GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV") == 0)
    {
        return 0x8855;
    }
    if (strcmp(str, "GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV") == 0)
    {
        return 0x8850;
    }
    if (strcmp(str, "GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV") == 0)
    {
        return 0x8851;
    }
    if (strcmp(str, "GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV") == 0)
    {
        return 0x8852;
    }
    if (strcmp(str, "GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV") == 0)
    {
        return 0x8853;
    }
    if (strcmp(str, "GL_OFFSET_TEXTURE_2D_BIAS_NV") == 0)
    {
        return 0x86E3;
    }
    if (strcmp(str, "GL_OFFSET_TEXTURE_2D_MATRIX_NV") == 0)
    {
        return 0x86E1;
    }
    if (strcmp(str, "GL_OFFSET_TEXTURE_2D_NV") == 0)
    {
        return 0x86E8;
    }
    if (strcmp(str, "GL_OFFSET_TEXTURE_2D_SCALE_NV") == 0)
    {
        return 0x86E2;
    }
    if (strcmp(str, "GL_OFFSET_TEXTURE_BIAS_NV") == 0)
    {
        return 0x86E3;
    }
    if (strcmp(str, "GL_OFFSET_TEXTURE_MATRIX_NV") == 0)
    {
        return 0x86E1;
    }
    if (strcmp(str, "GL_OFFSET_TEXTURE_RECTANGLE_NV") == 0)
    {
        return 0x864C;
    }
    if (strcmp(str, "GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV") == 0)
    {
        return 0x864D;
    }
    if (strcmp(str, "GL_OFFSET_TEXTURE_SCALE_NV") == 0)
    {
        return 0x86E2;
    }
    if (strcmp(str, "GL_ONE") == 0)
    {
        return 0x0001;
    }
    if (strcmp(str, "GL_ONE_EXT") == 0)
    {
        return 0x87DE;
    }
    if (strcmp(str, "GL_ONE_MINUS_CONSTANT_ALPHA") == 0)
    {
        return 0x8004;
    }
    if (strcmp(str, "GL_ONE_MINUS_CONSTANT_ALPHA_EXT") == 0)
    {
        return 0x8004;
    }
    if (strcmp(str, "GL_ONE_MINUS_CONSTANT_COLOR") == 0)
    {
        return 0x8002;
    }
    if (strcmp(str, "GL_ONE_MINUS_CONSTANT_COLOR_EXT") == 0)
    {
        return 0x8002;
    }
    if (strcmp(str, "GL_ONE_MINUS_DST_ALPHA") == 0)
    {
        return 0x0305;
    }
    if (strcmp(str, "GL_ONE_MINUS_DST_COLOR") == 0)
    {
        return 0x0307;
    }
    if (strcmp(str, "GL_ONE_MINUS_SRC1_ALPHA") == 0)
    {
        return 0x88FB;
    }
    if (strcmp(str, "GL_ONE_MINUS_SRC1_ALPHA_EXT") == 0)
    {
        return 0x88FB;
    }
    if (strcmp(str, "GL_ONE_MINUS_SRC1_COLOR") == 0)
    {
        return 0x88FA;
    }
    if (strcmp(str, "GL_ONE_MINUS_SRC1_COLOR_EXT") == 0)
    {
        return 0x88FA;
    }
    if (strcmp(str, "GL_ONE_MINUS_SRC_ALPHA") == 0)
    {
        return 0x0303;
    }
    if (strcmp(str, "GL_ONE_MINUS_SRC_COLOR") == 0)
    {
        return 0x0301;
    }
    if (strcmp(str, "GL_OPERAND0_ALPHA") == 0)
    {
        return 0x8598;
    }
    if (strcmp(str, "GL_OPERAND0_ALPHA_ARB") == 0)
    {
        return 0x8598;
    }
    if (strcmp(str, "GL_OPERAND0_ALPHA_EXT") == 0)
    {
        return 0x8598;
    }
    if (strcmp(str, "GL_OPERAND0_RGB") == 0)
    {
        return 0x8590;
    }
    if (strcmp(str, "GL_OPERAND0_RGB_ARB") == 0)
    {
        return 0x8590;
    }
    if (strcmp(str, "GL_OPERAND0_RGB_EXT") == 0)
    {
        return 0x8590;
    }
    if (strcmp(str, "GL_OPERAND1_ALPHA") == 0)
    {
        return 0x8599;
    }
    if (strcmp(str, "GL_OPERAND1_ALPHA_ARB") == 0)
    {
        return 0x8599;
    }
    if (strcmp(str, "GL_OPERAND1_ALPHA_EXT") == 0)
    {
        return 0x8599;
    }
    if (strcmp(str, "GL_OPERAND1_RGB") == 0)
    {
        return 0x8591;
    }
    if (strcmp(str, "GL_OPERAND1_RGB_ARB") == 0)
    {
        return 0x8591;
    }
    if (strcmp(str, "GL_OPERAND1_RGB_EXT") == 0)
    {
        return 0x8591;
    }
    if (strcmp(str, "GL_OPERAND2_ALPHA") == 0)
    {
        return 0x859A;
    }
    if (strcmp(str, "GL_OPERAND2_ALPHA_ARB") == 0)
    {
        return 0x859A;
    }
    if (strcmp(str, "GL_OPERAND2_ALPHA_EXT") == 0)
    {
        return 0x859A;
    }
    if (strcmp(str, "GL_OPERAND2_RGB") == 0)
    {
        return 0x8592;
    }
    if (strcmp(str, "GL_OPERAND2_RGB_ARB") == 0)
    {
        return 0x8592;
    }
    if (strcmp(str, "GL_OPERAND2_RGB_EXT") == 0)
    {
        return 0x8592;
    }
    if (strcmp(str, "GL_OPERAND3_ALPHA_NV") == 0)
    {
        return 0x859B;
    }
    if (strcmp(str, "GL_OPERAND3_RGB_NV") == 0)
    {
        return 0x8593;
    }
    if (strcmp(str, "GL_OPTIMAL_TILING_EXT") == 0)
    {
        return 0x9584;
    }
    if (strcmp(str, "GL_OP_ADD_EXT") == 0)
    {
        return 0x8787;
    }
    if (strcmp(str, "GL_OP_CLAMP_EXT") == 0)
    {
        return 0x878E;
    }
    if (strcmp(str, "GL_OP_CROSS_PRODUCT_EXT") == 0)
    {
        return 0x8797;
    }
    if (strcmp(str, "GL_OP_DOT3_EXT") == 0)
    {
        return 0x8784;
    }
    if (strcmp(str, "GL_OP_DOT4_EXT") == 0)
    {
        return 0x8785;
    }
    if (strcmp(str, "GL_OP_EXP_BASE_2_EXT") == 0)
    {
        return 0x8791;
    }
    if (strcmp(str, "GL_OP_FLOOR_EXT") == 0)
    {
        return 0x878F;
    }
    if (strcmp(str, "GL_OP_FRAC_EXT") == 0)
    {
        return 0x8789;
    }
    if (strcmp(str, "GL_OP_INDEX_EXT") == 0)
    {
        return 0x8782;
    }
    if (strcmp(str, "GL_OP_LOG_BASE_2_EXT") == 0)
    {
        return 0x8792;
    }
    if (strcmp(str, "GL_OP_MADD_EXT") == 0)
    {
        return 0x8788;
    }
    if (strcmp(str, "GL_OP_MAX_EXT") == 0)
    {
        return 0x878A;
    }
    if (strcmp(str, "GL_OP_MIN_EXT") == 0)
    {
        return 0x878B;
    }
    if (strcmp(str, "GL_OP_MOV_EXT") == 0)
    {
        return 0x8799;
    }
    if (strcmp(str, "GL_OP_MULTIPLY_MATRIX_EXT") == 0)
    {
        return 0x8798;
    }
    if (strcmp(str, "GL_OP_MUL_EXT") == 0)
    {
        return 0x8786;
    }
    if (strcmp(str, "GL_OP_NEGATE_EXT") == 0)
    {
        return 0x8783;
    }
    if (strcmp(str, "GL_OP_POWER_EXT") == 0)
    {
        return 0x8793;
    }
    if (strcmp(str, "GL_OP_RECIP_EXT") == 0)
    {
        return 0x8794;
    }
    if (strcmp(str, "GL_OP_RECIP_SQRT_EXT") == 0)
    {
        return 0x8795;
    }
    if (strcmp(str, "GL_OP_ROUND_EXT") == 0)
    {
        return 0x8790;
    }
    if (strcmp(str, "GL_OP_SET_GE_EXT") == 0)
    {
        return 0x878C;
    }
    if (strcmp(str, "GL_OP_SET_LT_EXT") == 0)
    {
        return 0x878D;
    }
    if (strcmp(str, "GL_OP_SUB_EXT") == 0)
    {
        return 0x8796;
    }
    if (strcmp(str, "GL_OR") == 0)
    {
        return 0x1507;
    }
    if (strcmp(str, "GL_ORDER") == 0)
    {
        return 0x0A01;
    }
    if (strcmp(str, "GL_OR_INVERTED") == 0)
    {
        return 0x150D;
    }
    if (strcmp(str, "GL_OR_REVERSE") == 0)
    {
        return 0x150B;
    }
    if (strcmp(str, "GL_OUTPUT_COLOR0_EXT") == 0)
    {
        return 0x879B;
    }
    if (strcmp(str, "GL_OUTPUT_COLOR1_EXT") == 0)
    {
        return 0x879C;
    }
    if (strcmp(str, "GL_OUTPUT_FOG_EXT") == 0)
    {
        return 0x87BD;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD0_EXT") == 0)
    {
        return 0x879D;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD10_EXT") == 0)
    {
        return 0x87A7;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD11_EXT") == 0)
    {
        return 0x87A8;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD12_EXT") == 0)
    {
        return 0x87A9;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD13_EXT") == 0)
    {
        return 0x87AA;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD14_EXT") == 0)
    {
        return 0x87AB;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD15_EXT") == 0)
    {
        return 0x87AC;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD16_EXT") == 0)
    {
        return 0x87AD;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD17_EXT") == 0)
    {
        return 0x87AE;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD18_EXT") == 0)
    {
        return 0x87AF;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD19_EXT") == 0)
    {
        return 0x87B0;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD1_EXT") == 0)
    {
        return 0x879E;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD20_EXT") == 0)
    {
        return 0x87B1;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD21_EXT") == 0)
    {
        return 0x87B2;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD22_EXT") == 0)
    {
        return 0x87B3;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD23_EXT") == 0)
    {
        return 0x87B4;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD24_EXT") == 0)
    {
        return 0x87B5;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD25_EXT") == 0)
    {
        return 0x87B6;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD26_EXT") == 0)
    {
        return 0x87B7;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD27_EXT") == 0)
    {
        return 0x87B8;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD28_EXT") == 0)
    {
        return 0x87B9;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD29_EXT") == 0)
    {
        return 0x87BA;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD2_EXT") == 0)
    {
        return 0x879F;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD30_EXT") == 0)
    {
        return 0x87BB;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD31_EXT") == 0)
    {
        return 0x87BC;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD3_EXT") == 0)
    {
        return 0x87A0;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD4_EXT") == 0)
    {
        return 0x87A1;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD5_EXT") == 0)
    {
        return 0x87A2;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD6_EXT") == 0)
    {
        return 0x87A3;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD7_EXT") == 0)
    {
        return 0x87A4;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD8_EXT") == 0)
    {
        return 0x87A5;
    }
    if (strcmp(str, "GL_OUTPUT_TEXTURE_COORD9_EXT") == 0)
    {
        return 0x87A6;
    }
    if (strcmp(str, "GL_OUTPUT_VERTEX_EXT") == 0)
    {
        return 0x879A;
    }
    if (strcmp(str, "GL_OUT_OF_MEMORY") == 0)
    {
        return 0x0505;
    }
    if (strcmp(str, "GL_OVERLAY") == 0)
    {
        return 0x9296;
    }
    if (strcmp(str, "GL_OVERLAY_KHR") == 0)
    {
        return 0x9296;
    }
    if (strcmp(str, "GL_OVERLAY_NV") == 0)
    {
        return 0x9296;
    }
    if (strcmp(str, "GL_PACK_ALIGNMENT") == 0)
    {
        return 0x0D05;
    }
    if (strcmp(str, "GL_PACK_CMYK_HINT_EXT") == 0)
    {
        return 0x800E;
    }
    if (strcmp(str, "GL_PACK_COMPRESSED_BLOCK_DEPTH") == 0)
    {
        return 0x912D;
    }
    if (strcmp(str, "GL_PACK_COMPRESSED_BLOCK_HEIGHT") == 0)
    {
        return 0x912C;
    }
    if (strcmp(str, "GL_PACK_COMPRESSED_BLOCK_SIZE") == 0)
    {
        return 0x912E;
    }
    if (strcmp(str, "GL_PACK_COMPRESSED_BLOCK_WIDTH") == 0)
    {
        return 0x912B;
    }
    if (strcmp(str, "GL_PACK_COMPRESSED_SIZE_SGIX") == 0)
    {
        return 0x831C;
    }
    if (strcmp(str, "GL_PACK_IMAGE_DEPTH_SGIS") == 0)
    {
        return 0x8131;
    }
    if (strcmp(str, "GL_PACK_IMAGE_HEIGHT") == 0)
    {
        return 0x806C;
    }
    if (strcmp(str, "GL_PACK_IMAGE_HEIGHT_EXT") == 0)
    {
        return 0x806C;
    }
    if (strcmp(str, "GL_PACK_INVERT_MESA") == 0)
    {
        return 0x8758;
    }
    if (strcmp(str, "GL_PACK_LSB_FIRST") == 0)
    {
        return 0x0D01;
    }
    if (strcmp(str, "GL_PACK_MAX_COMPRESSED_SIZE_SGIX") == 0)
    {
        return 0x831B;
    }
    if (strcmp(str, "GL_PACK_RESAMPLE_OML") == 0)
    {
        return 0x8984;
    }
    if (strcmp(str, "GL_PACK_RESAMPLE_SGIX") == 0)
    {
        return 0x842E;
    }
    if (strcmp(str, "GL_PACK_REVERSE_ROW_ORDER_ANGLE") == 0)
    {
        return 0x93A4;
    }
    if (strcmp(str, "GL_PACK_ROW_BYTES_APPLE") == 0)
    {
        return 0x8A15;
    }
    if (strcmp(str, "GL_PACK_ROW_LENGTH") == 0)
    {
        return 0x0D02;
    }
    if (strcmp(str, "GL_PACK_SKIP_IMAGES") == 0)
    {
        return 0x806B;
    }
    if (strcmp(str, "GL_PACK_SKIP_IMAGES_EXT") == 0)
    {
        return 0x806B;
    }
    if (strcmp(str, "GL_PACK_SKIP_PIXELS") == 0)
    {
        return 0x0D04;
    }
    if (strcmp(str, "GL_PACK_SKIP_ROWS") == 0)
    {
        return 0x0D03;
    }
    if (strcmp(str, "GL_PACK_SKIP_VOLUMES_SGIS") == 0)
    {
        return 0x8130;
    }
    if (strcmp(str, "GL_PACK_SUBSAMPLE_RATE_SGIX") == 0)
    {
        return 0x85A0;
    }
    if (strcmp(str, "GL_PACK_SWAP_BYTES") == 0)
    {
        return 0x0D00;
    }
    if (strcmp(str, "GL_PALETTE4_R5_G6_B5_OES") == 0)
    {
        return 0x8B92;
    }
    if (strcmp(str, "GL_PALETTE4_RGB5_A1_OES") == 0)
    {
        return 0x8B94;
    }
    if (str